/* edts.c
 * Copyright (C) 2001 QT4Linux and OpenQuicktime Teams
 *
 * This file is part of OpenQuicktime, a free QuickTime library.
 *
 * Based on QT4Linux by Adam Williams.
 *
 * OpenQuicktime is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * OpenQuicktime is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "funcprotos.h"
#include "openquicktime.h"

void quicktime_edts_init(quicktime_edts_t *edts)
{
	quicktime_elst_init(&(edts->elst));
}

void quicktime_edts_delete(quicktime_edts_t *edts)
{
	quicktime_elst_delete(&(edts->elst));
}

void quicktime_edts_init_table(quicktime_edts_t *edts)
{
	quicktime_elst_init_all(&(edts->elst));
}

void quicktime_read_edts(quicktime_t *file, quicktime_edts_t *edts, quicktime_atom_t *edts_atom)
{
	quicktime_atom_t leaf_atom;

	do
	{
		quicktime_atom_read_header(file, &leaf_atom);
//printf("quicktime_read_edts %llx %llx\n", quicktime_position(file), leaf_atom.end);
		if(quicktime_atom_is(&leaf_atom, "elst"))
		{ quicktime_read_elst(file, &(edts->elst)); }
		else
			quicktime_atom_skip(file, &leaf_atom);
	}while(quicktime_position(file) < edts_atom->end);
}

void quicktime_edts_dump(quicktime_edts_t *edts)
{
	printf("  edit atom (edts)\n");
	quicktime_elst_dump(&(edts->elst));
}

void quicktime_write_edts(quicktime_t *file, quicktime_edts_t *edts, long duration)
{
	quicktime_atom_t atom;
	quicktime_atom_write_header(file, &atom, "edts");
	quicktime_write_elst(file, &(edts->elst), duration);
	quicktime_atom_write_footer(file, &atom);
}
