/* stss.c
 * Copyright (C) 2001 QT4Linux and OpenQuicktime Teams
 *
 * This file is part of OpenQuicktime, a free QuickTime library.
 *
 * Based on QT4Linux by Adam Williams.
 *
 * OpenQuicktime is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * OpenQuicktime is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "funcprotos.h"
#include "openquicktime.h"



void quicktime_stss_init(quicktime_stss_t *stss)
{
	stss->version = 0;
	stss->flags = 0;
	stss->total_entries = 0;
}

void quicktime_stss_delete(quicktime_stss_t *stss)
{
	if(stss->total_entries) free(stss->table);
	stss->total_entries = 0;
}

void quicktime_stss_dump(quicktime_stss_t *stss)
{
	long i;
	printf("     sync sample\n");
	printf("      version %d\n", stss->version);
	printf("      flags %ld\n", stss->flags);
	printf("      total_entries %ld\n", stss->total_entries);
	printf("      entries_allocated %ld\n", stss->entries_allocated);
	for(i = 0; i < stss->total_entries; i++)
	{
		printf("       sample %lx\n", stss->table[i].sample);
	}
}

void quicktime_read_stss(quicktime_t *file, quicktime_stss_t *stss)
{
	long i;
	stss->version = quicktime_read_char(file);
	stss->flags = quicktime_read_int24(file);
	stss->total_entries = quicktime_read_int32(file);
	
	stss->table = (quicktime_stss_table_t*)malloc(sizeof(quicktime_stss_table_t) * stss->total_entries);
	for(i = 0; i < stss->total_entries; i++)
	{
		stss->table[i].sample = quicktime_read_int32(file);
	}
}


void quicktime_write_stss(quicktime_t *file, quicktime_stss_t *stss)
{
	long i;
	quicktime_atom_t atom;

	//	printf("Je suis dans quicktime_write_stss %u\n", stss->total_entries);

	if(stss->total_entries)
	{
		quicktime_atom_write_header(file, &atom, "stss");

		quicktime_write_char(file, stss->version);
		quicktime_write_int24(file, stss->flags);
		quicktime_write_int32(file, stss->total_entries);
		for(i = 0; i < stss->total_entries; i++)
		{
			quicktime_write_int32(file, stss->table[i].sample);
		}

		quicktime_atom_write_footer(file, &atom);
	}
}
