/* stsz.c
 * Copyright (C) 2001 QT4Linux and OpenQuicktime Teams
 *
 * This file is part of OpenQuicktime, a free QuickTime library.
 *
 * Based on QT4Linux by Adam Williams.
 *
 * OpenQuicktime is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * OpenQuicktime is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "funcprotos.h"
#include "openquicktime.h"



void quicktime_stsz_init(quicktime_stsz_t *stsz)
{
	stsz->version = 0;
	stsz->flags = 0;
	stsz->sample_size = 0;
	stsz->total_entries = 0;
	stsz->entries_allocated = 0;
}

void quicktime_stsz_init_video(quicktime_t *file, quicktime_stsz_t *stsz)
{
	stsz->sample_size = 0;
	if(!stsz->entries_allocated)
	{
		stsz->entries_allocated = 2000;
		stsz->total_entries = 0;
		stsz->table = (quicktime_stsz_table_t*)malloc(sizeof(quicktime_stsz_table_t) * stsz->entries_allocated);
	}
}

void quicktime_stsz_init_audio(quicktime_t *file, quicktime_stsz_t *stsz, int channels, int bits)
{
	/*stsz->sample_size = channels * bits / 8; */
	stsz->sample_size = 1;   /* ? */
	stsz->total_entries = 0;   /* set this when closing */
	stsz->entries_allocated = 0;
}

void quicktime_stsz_delete(quicktime_stsz_t *stsz)
{
	if(!stsz->sample_size && stsz->total_entries) free(stsz->table);
	stsz->total_entries = 0;
	stsz->entries_allocated = 0;
}

void quicktime_stsz_dump(quicktime_stsz_t *stsz)
{
        long i;
	printf("     sample size\n");
	printf("      version %d\n", stsz->version);
	printf("      flags %ld\n", stsz->flags);
	printf("      sample_size %lld\n", stsz->sample_size);
	printf("      total_entries %ld\n", stsz->total_entries);
	
	if(!stsz->sample_size)
	{
		for(i = 0; i < stsz->total_entries; i++)
		{
			printf("       sample_size %lld\n", stsz->table[i].size);
		}
	}
}

void quicktime_read_stsz(quicktime_t *file, quicktime_stsz_t *stsz)
{
	long i;
	stsz->version = quicktime_read_char(file);
	stsz->flags = quicktime_read_int24(file);
	stsz->sample_size = quicktime_read_int32(file);
	stsz->total_entries = quicktime_read_int32(file);
	stsz->entries_allocated = stsz->total_entries;
	if(!stsz->sample_size)
	{
		stsz->table = (quicktime_stsz_table_t*)malloc(sizeof(quicktime_stsz_table_t) * stsz->entries_allocated);
		for(i = 0; i < stsz->total_entries; i++)
		{
			stsz->table[i].size = quicktime_read_int32(file);
		}
	}
}

void quicktime_write_stsz(quicktime_t *file, quicktime_stsz_t *stsz)
{
	long i, result;
	quicktime_atom_t atom;
	quicktime_atom_write_header(file, &atom, "stsz");

/* optimize if possible */
/* Xanim requires an unoptimized table for video. */
/* 	if(!stsz->sample_size) */
/* 	{ */
/* 		for(i = 0, result = 0; i < stsz->total_entries && !result; i++) */
/* 		{ */
/* 			if(stsz->table[i].size != stsz->table[0].size) result = 1; */
/* 		} */
/* 		 */
/* 		if(!result) */
/* 		{ */
/* 			stsz->sample_size = stsz->table[0].size; */
/* 			stsz->total_entries = 0; */
/* 			free(stsz->table); */
/* 		} */
/* 	} */

	quicktime_write_char(file, stsz->version);
	quicktime_write_int24(file, stsz->flags);
	quicktime_write_int32(file, stsz->sample_size);
	if(stsz->sample_size)
	{
		quicktime_write_int32(file, stsz->total_entries);
	}
	else
	{
		quicktime_write_int32(file, stsz->total_entries);
		for(i = 0; i < stsz->total_entries; i++)
		{
			quicktime_write_int32(file, stsz->table[i].size);
		}
	}

	quicktime_atom_write_footer(file, &atom);
}

void quicktime_update_stsz(quicktime_stsz_t *stsz, long sample, long sample_size)
{
	long i;

	if(!stsz->sample_size)
	{
		if(sample >= stsz->entries_allocated)
		{
			stsz->entries_allocated = sample * 2;
			stsz->table = (quicktime_stsz_table_t*)realloc(stsz->table, sizeof(quicktime_stsz_table_t) * stsz->entries_allocated);
		}

		//		printf("sample %ld sample_size %ld\n", sample, sample_size);
		stsz->table[sample].size = sample_size;
		if(sample >= stsz->total_entries) stsz->total_entries = sample + 1;
	}
}
