#include "misc.h"

struct systab errnos[] = {
	{ "0", 0 },

	{ "EPERM", 1 },
	{ "ENOENT", 2 },
	{ "ESRCH", 3 },
	{ "EINTR", 4 },
	{ "EIO", 5 },
	{ "ENXIO", 6 },
	{ "E2BIG", 7 },
	{ "ENOEXEC", 8 },
	{ "EBADF", 9 },
	{ "ECHILD", 10 },
	{ "EDEADLK", 11 },
	{ "ENOMEM", 12 },
	{ "EACCES", 13 },
	{ "EFAULT", 14 },
	{ "ENOTBLK", 15 },
	{ "EBUSY", 16 },
	{ "EEXIST", 17 },
	{ "EXDEV", 18 },
	{ "ENODEV", 19 },
	{ "ENOTDIR", 20 },
	{ "EISDIR", 21 },
	{ "EINVAL", 22 },
	{ "ENFILE", 23 },
	{ "EMFILE", 24 },
	{ "ENOTTY", 25 },
	{ "ETXTBSY", 26 },
	{ "EFBIG", 27 },
	{ "ENOSPC", 28 },
	{ "ESPIPE", 29 },
	{ "EROFS", 30 },
	{ "EMLINK", 31 },
	{ "EPIPE", 32 },
	{ "EDOM", 33 },
	{ "ERANGE", 34 },
	{ "EAGAIN", 35 },
	{ "EINPROGRESS", 36 },
	{ "EALREADY", 37 },
	{ "ENOTSOCK", 38 },
	{ "EDESTADDRREQ", 39 },
	{ "EMSGSIZE", 40 },
	{ "EPROTOTYPE", 41 },
	{ "ENOPROTOOPT", 42 },
	{ "EPROTONOSUPPORT", 43 },
	{ "ESOCKTNOSUPPORT", 44 },
	{ "EOPNOTSUPP", 45 },
	{ "EPFNOSUPPORT", 46 },
	{ "EAFNOSUPPORT", 47 },
	{ "EADDRINUSE", 48 },
	{ "EADDRNOTAVAIL", 49 },
	{ "ENETDOWN", 50 },
	{ "ENETUNREACH", 51 },
	{ "ENETRESET", 52 },
	{ "ECONNABORTED", 53 },
	{ "ECONNRESET", 54 },
	{ "ENOBUFS", 55 },
	{ "EISCONN", 56 },
	{ "ENOTCONN", 57 },
	{ "ESHUTDOWN", 58 },
	{ "ETOOMANYREFS", 59 },
	{ "ETIMEDOUT", 60 },
	{ "ECONNREFUSED", 61 },
	{ "ELOOP", 62 },
	{ "ENAMETOOLONG", 63 },
	{ "EHOSTDOWN", 64 },
	{ "EHOSTUNREACH", 65 },
	{ "ENOTEMPTY", 66 },
	{ "EPROCLIM", 67 },
	{ "EUSERS", 68 },
	{ "EDQUOT", 69 },
	{ "ESTALE", 70 },
	{ "EREMOTE", 71 },
	{ "EBADRPC", 72 },
	{ "ERPCMISMATCH", 73 },
	{ "EPROGUNAVAIL", 74 },
	{ "EPROGMISMATCH", 75 },
	{ "EPROCUNAVAIL", 76 },
	{ "ENOLCK", 77 },
	{ "ENOSYS", 78 },
	{ "EFTYPE", 79 },
	{ "EAUTH", 80 },
	{ "ENEEDAUTH", 81 },
	{ "EIDRM", 82 },
	{ "ENOMSG", 83 },
	{ "EOVERFLOW", 84 },
	{ "EILSEQ", 85 },
	{ "ENOTSUP", 86 },
	{ "ECANCELED", 87 },
	{ "EBADMSG", 88 },
	{ "ENODATA", 89 },
	{ "ENOSR", 90 },
	{ "ENOSTR", 91 },
	{ "ETIME", 92 },
	{ "ENOATTR", 93 },
	{ "EMULTIHOP", 94 },
	{ "ENOLINK", 95 },
	{ "EPROTO", 96 },
	{ "ELAST", 96 },
	{ 0L, 0},
};

struct systab signals[] = {
	{ "0", 0 },

	{ "SIGHUP", 1 },
	{ "SIGINT", 2 },
	{ "SIGQUIT", 3 },
	{ "SIGILL", 4 },
	{ "SIGTRAP", 5 },
	{ "SIGABRT", 6 },
	{ "SIGEMT", 7 },
	{ "SIGFPE", 8 },
	{ "SIGKILL", 9 },
	{ "SIGBUS", 10 },
	{ "SIGSEGV", 11 },
	{ "SIGSYS", 12 },
	{ "SIGPIPE", 13 },
	{ "SIGALRM", 14 },
	{ "SIGTERM", 15 },
	{ "SIGURG", 16 },
	{ "SIGSTOP", 17 },
	{ "SIGTSTP", 18 },
	{ "SIGCONT", 19 },
	{ "SIGCHLD", 20 },
	{ "SIGTTIN", 21 },
	{ "SIGTTOU", 22 },
	{ "SIGIO", 23 },
	{ "SIGXCPU", 24 },
	{ "SIGXFSZ", 25 },
	{ "SIGVTALRM", 26 },
	{ "SIGPROF", 27 },
	{ "SIGWINCH", 28 },
	{ "SIGINFO", 29 },
	{ "SIGUSR1", 30 },
	{ "SIGUSR2", 31 },
	{ "SIGPWR", 32 },
	{ "SIGRTMIN", 33 },
	{ "SIGRTMIN+1", 34 },
	{ "SIGRTMIN+2", 35 },
	{ "SIGRTMIN+3", 36 },
	{ "SIGRTMIN+4", 37 },
	{ "SIGRTMIN+5", 38 },
	{ "SIGRTMIN+6", 39 },
	{ "SIGRTMIN+7", 40 },
	{ "SIGRTMIN+8", 41 },
	{ "SIGRTMIN+9", 42 },
	{ "SIGRTMIN+10", 43 },
	{ "SIGRTMIN+11", 44 },
	{ "SIGRTMIN+12", 45 },
	{ "SIGRTMIN+13", 46 },
	{ "SIGRTMIN+14", 47 },
	{ "SIGRTMIN+15", 48 },
	{ "SIGRTMIN+16", 49 },
	{ "SIGRTMIN+17", 50 },
	{ "SIGRTMIN+18", 51 },
	{ "SIGRTMIN+19", 52 },
	{ "SIGRTMIN+20", 53 },
	{ "SIGRTMIN+21", 54 },
	{ "SIGRTMIN+22", 55 },
	{ "SIGRTMIN+23", 56 },
	{ "SIGRTMIN+24", 57 },
	{ "SIGRTMIN+25", 58 },
	{ "SIGRTMIN+26", 59 },
	{ "SIGRTMIN+27", 60 },
	{ "SIGRTMIN+28", 61 },
	{ "SIGRTMIN+29", 62 },
	{ "SIGRTMAX", 63 },
	{ 0L, 0},
};
