#### Fix unstable comment print in union type comments (#18395 by @fisker)

<!-- prettier-ignore -->
```tsx
// Input
type X = (A | B) & (
  // comment
  A | B
);

// Prettier stable (first format)
type X = (A | B) &
  (// comment
  A | B);

// Prettier stable (second format)
type X = (
  | A
  | B // comment
) &
  (A | B);

// Prettier main
type X = (A | B) &
  // comment
  (A | B);
```
