---
authors: "vjeux"
title: Prettier 1.2
---

1.0 is not the end of prettier, we're going to continue to work on the long tail of formatting issues in order to make it an awesome JavaScript code formatter. You should expect minor version releases like this one to change small things and edge cases but nothing major or controversial.

<!-- truncate -->

### Format

#### Do not print the sub-tree when using prettier-ignore ([#1286](https://github.com/prettier/prettier/pull/1286))

#### Bail when traversing === groups ([#1294](https://github.com/prettier/prettier/pull/1294))

A regression was introduced in 1.0 where deeply nested functions like this would trigger an exponential behavior and no longer complete in a reasonable time. We introduced a mitigation such that it's not instant but at least completes in a reasonable amount of time.

<!-- prettier-ignore -->
```js
someObject.someFunction().then(function () {
    return someObject.someFunction().then(function () {
        return someObject.someFunction().then(function () {
            return someObject.someFunction().then(function () {
                return someObject.someFunction().then(function () {
                });
            });
        });
    });
});
```

#### Break if () if conditional inside breaks ([#1344](https://github.com/prettier/prettier/pull/1344))

prettier was sometimes breaking inside of an if condition as it didn't fit 80 columns but would print all the conditions in a single line. This was very weird looking. Now if the if break, prettier will also break the conditions.

<!-- prettier-ignore -->
```js
// Before
if (
  this.hasPlugin("dynamicImports") && this.lookahead().type === tt.parenLeft
) {

// After
if (
  this.hasPlugin("dynamicImports") &&
  this.lookahead().type === tt.parenLeft
) {
```

#### Avoid breaking arguments for last arg expansion ([#1305](https://github.com/prettier/prettier/pull/1305))

A long-standing issue around last argument expansion and complex arguments has been fixed, it no longer looks crazy bad.

<!-- prettier-ignore -->
```js
// Before
manageChildren: jest.fn(function manageChildren(parentTag, moveFromIndices = [
], moveToIndices = [], addChildReactTags = [], addAtIndices = [
], removeAtIndices = []) {

// After
manageChildren: jest.fn(function manageChildren(
  parentTag,
  moveFromIndices = [],
  moveToIndices = [],
  addChildReactTags = [],
  addAtIndices = [],
  removeAtIndices = []
) {
```

#### Add parentheses for assignment as body of arrow ([#1326](https://github.com/prettier/prettier/pull/1326))

We're fine tuning when to add parenthesis in order to improve understanding of the code. This time, we're adding it to assignment inside of arrow functions. Please open up issues if you think that there should be parenthesis and prettier doesn't put them.

<!-- prettier-ignore -->
```js
// Before
() => foo = bar + 2;

// After
() => (foo = bar + 2);
```

#### Improve regex printing ([#1341](https://github.com/prettier/prettier/pull/1341))

Flow and Babylon were inconsistent in how they printed escapes and flags. Now the escapes are untouched compared to the original ones and the flags are sorted.

<!-- prettier-ignore -->
```js
// Before
/[\/]\/\u0aBc/mgi;

// After
/[/]\/\u0aBc/gim;
```

#### Fix arrow function parenthesis with comments in flow ([#1339](https://github.com/prettier/prettier/pull/1339))

With the Flow parser, prettier didn't add parenthesis for single argument functions with a comment.

<!-- prettier-ignore -->
```js
// Before
call(/*object*/ row => {});

// After
call((/*object*/ row) => {});
```

#### Don't inline paren at right of arguments ([#1345](https://github.com/prettier/prettier/pull/1345))

We incorrectly put a comment at the right of arguments inside of the argument list.

<!-- prettier-ignore -->
```js
// Before
f(/* ... */) {}

// After
f() /* ... */ {}
```

#### Fix template literal comments ([#1296](https://github.com/prettier/prettier/pull/1296))

Comments inside of template literals would crash in some conditions and be inserted in the wrong `${}`, no more :)

<!-- prettier-ignore -->
```js
// Before
stdin: TypeError: Cannot read property 'comments' of undefined

// After
`
(?:${escapeChar}[\\S\\s]|(?:(?!${// Using `XRegExp.union` safely rewrites backreferences in `left` and `right`.
// Intentionally not passing `basicFlags` to `XRegExp.union` since any syntax
// transformation resulting from those flags was already applied to `left` and
// `right` when they were passed through the XRegExp constructor above.
XRegExp.union([left, right], '', {conjunction: 'or'}).source})[^${escapeChar}])+)+
`
```

#### Fix isPreviousLineEmpty on Windows ([#1263](https://github.com/prettier/prettier/pull/1263))

Empty lines were not properly preserved for switch case on windows.

<!-- prettier-ignore -->
```js
// Before
switch (a) {
  case x:

  case y:
    call();
}

// After
switch (a) {
  case x:
  case y:
    call();
}
```

### CLI

#### Skip globbing filenames with node-glob when the filename is not a glob ([#1307](https://github.com/prettier/prettier/pull/1307))

If you run `prettier file.js` and `file.js` doesn't exist, it's going to throw an exception instead of silently doing nothing.

#### Write out change CLI changes synchronously ([#1292](https://github.com/prettier/prettier/pull/1292))

There was a race condition when you did ctrl-c to stop the process where it could delete files. Now we write files synchronously so it doesn't anymore.
