---
authors: "sosukesuzuki"
title: "Prettier 2.6: new singleAttributePerLine option and new JavaScript features!"
---

This release includes a new `singleAttributePerLine` option. This is an option to print only one attribute per line in Vue SFC templates, HTML, and JSX. Per our [Option Philosophy](https://prettier.io/docs/option-philosophy), we would prefer not to add such an option. However, there are many users who want this feature, and major style guides like [Airbnb’s JavaScript Style Guide](https://github.com/airbnb/javascript/blob/274c8d570155a05b016980294d4204c5711bce86/packages/eslint-config-airbnb/rules/react.js#L97-L99) and [Vue’s style guide](https://vuejs.org/style-guide/rules-strongly-recommended.html#multi-attribute-elements) recommend the single attribute per line style. A [PR](https://github.com/prettier/prettier/pull/6644) to add this feature was opened in October 2019, and both it and the [corresponding issue](https://github.com/prettier/prettier/issues/5501) have received a significant amount of support from users. For us it was a hard decision to add this option. We hope the addition of this option will benefit many users without significantly harming our principles.

We've also added support formatting for some new JavaScript syntax proposals via Babel.

<!-- truncate -->

## Thanks to our sponsors!

As discussed in [a blog post from earlier this year](https://prettier.io/blog/2022/01/06/prettier-begins-paying-maintainers.html), we have begun paying our maintainers from funds received from our sponsors. We would like to thank our many sponsors who have made this possible! We’re especially grateful to the following companies and individuals, who have donated over $1,000 to us:

- [Frontend Masters](https://frontendmasters.com/)
- [Salesforce](https://www.salesforce.com/)
- [Indeed](https://indeed.com/)
- [Sentry](https://sentry.io/welcome/)
- [Airbnb](https://www.airbnb.com/)
- [LINE](https://engineering.linecorp.com/en/)
- [AMP Project](https://www.ampproject.org/)
- [InVision AG](https://www.ivx.com/)
- [Ubie](https://ubiehealth.com/)
- [Shogun Labs, Inc](https://getshogun.com/)
- [Underbelly](https://www.underbelly.is/)
- [Principal Financial Group](https://www.principal.com/about-us)
- [Suhail Doshi](https://twitter.com/suhail)

If you enjoy Prettier and would like to support our work, consider sponsoring us directly via [our OpenCollective](https://opencollective.com/prettier) or by sponsoring the projects we depend on, including [typescript-eslint](https://opencollective.com/typescript-eslint), [remark](https://opencollective.com/unified), and [Babel](https://opencollective.com/babel).

<!-- truncate -->

## Highlights

### TypeScript

#### TypeScript 4.6 support ([#12400](https://github.com/prettier/prettier/pull/12400) by [@dependabot](https://github.com/dependabot))

We’ve updated the version of TypeScript that we use to parse TS code to [TypeScript 4.6](https://devblogs.microsoft.com/typescript/announcing-typescript-4-6/). However, no new syntax was added in this release of TypeScript so we have not had to make any other changes.

### HTML

#### Enforce Single Attribute Per Line ([#6644](https://github.com/prettier/prettier/pull/6644) by [@kankje](https://github.com/kankje))

Added the `singleAttributePerLine` option for specifying if Prettier should enforce single attribute per line in HTML, Vue and JSX.

<!-- prettier-ignore -->
```html
<!-- Input -->
<div data-a="1">
  Lorem ipsum dolor sit amet, consectetur adipiscing elit.
</div>
<div data-a="1" data-b="2" data-c="3">
  Lorem ipsum dolor sit amet, consectetur adipiscing elit.
</div>

<!-- Prettier 2.5 -->
<div data-a="1">
  Lorem ipsum dolor sit amet, consectetur adipiscing elit.
</div>
<div data-a="1" data-b="2" data-c="3">
  Lorem ipsum dolor sit amet, consectetur adipiscing elit.
</div>

<!-- Prettier 2.6, with `{"singleAttributePerLine": false}` -->
<div data-a="1">
  Lorem ipsum dolor sit amet, consectetur adipiscing elit.
</div>
<div data-a="1" data-b="2" data-c="3">
  Lorem ipsum dolor sit amet, consectetur adipiscing elit.
</div>

<!-- Prettier 2.6, with `{"singleAttributePerLine": true}` -->
<div data-a="1">
  Lorem ipsum dolor sit amet, consectetur adipiscing elit.
</div>
<div
  data-a="1"
  data-b="2"
  data-c="3"
>
  Lorem ipsum dolor sit amet, consectetur adipiscing elit.
</div>
```

## Other Changes

### JavaScript

#### Recognize waitForAsync as test-statement in Angular ([#11992](https://github.com/prettier/prettier/pull/11992) by [@HendrikN](https://github.com/HendrikN))

<!-- prettier-ignore -->
```js
// Input
test("foo bar", waitForAsync(() => {
  const foo = "bar";
  expect(foo).toEqual("bar")
}));

// Prettier 2.5
test(
  "foo bar",
  waitForAsync(() => {
    const foo = "bar";
    expect(foo).toEqual("bar");
  })
);

// Prettier 2.6
test("foo bar", waitForAsync(() => {
  const foo = "bar";
  expect(foo).toEqual("bar");
}));
```

#### Preserve end-of-line comments after if statements without blocks ([#12017](https://github.com/prettier/prettier/pull/12017) by [@sosukesuzuki](https://github.com/sosukesuzuki))

<!-- prettier-ignore -->
```jsx
// Input
if (condition1) expression1; // comment A
else if (condition2) expression2; // comment B
else expression3; // comment C

// Prettier 2.5
if (condition1) expression1;
// comment A
else if (condition2) expression2;
// comment B
else expression3; // comment C

// Prettier 2.6
if (condition1) expression1; // comment A
else if (condition2) expression2; // comment B
else expression3; // comment C

```

#### Print comments for parenthesized TS keyword types with `babel-ts` parser ([#12070](https://github.com/prettier/prettier/pull/12070) by [@sosukesuzuki](https://github.com/sosukesuzuki))

<!-- prettier-ignore -->
```ts
// Input
let foo: (
   // comment
   never
);

// Prettier 2.5
Error: Comment "comment" was not printed. Please report this error!

// Prettier 2.6
let foo: // comment
never;
```

#### Print end-of-line comments for `continue`/`break` statements ([#12075](https://github.com/prettier/prettier/pull/12075) by [@sosukesuzuki](https://github.com/sosukesuzuki))

<!-- prettier-ignore -->
```jsx
// Input
for (;;) continue // comment
;

// Prettier 2.5
Error: Comment "comment" was not printed. Please report this error!

// Prettier 2.6
for (;;)
  continue; // comment

```

#### Inline `await` expressions in JSX ([#12088](https://github.com/prettier/prettier/pull/12088) & [#12109](https://github.com/prettier/prettier/pull/12109) by [@j-f1](https://github.com/j-f1))

`await` expressions in JSX are now inlined if their argument would be inlined.

<!-- prettier-ignore -->
```jsx
// Input
{await Promise.all(
  someVeryLongExpression
)}

{await (
  <div>Lorem ipsum ...</div>
)}


// Prettier 2.5
{
  await Promise.all(
    someVeryLongExpression
  )
}

{
  await (
    <div>Lorem ipsum ...</div>
  )
}


// Prettier 2.6
{await Promise.all(
  someVeryLongExpression
)}

{await (
  <div>Lorem ipsum ...</div>
)}

```

#### Add `acorn` parser ([#12172](https://github.com/prettier/prettier/pull/12172) by [@fisker](https://github.com/fisker))

A new value for the `parser` option has been added: [`acorn`](https://github.com/acornjs/acorn) - A small, fast, JavaScript-based JavaScript parser.

#### Keep comments after `default` cases in the same line ([#12177](https://github.com/prettier/prettier/pull/12177) by [@duailibe](https://github.com/duailibe))

Keep comments right after `default` cases (in switch statements) in the same line, when possible.

<!-- prettier-ignore -->
```jsx
// Input
function read_statement() {
  switch (peek_keyword()) {
    case Keyword.impl: // impl<T> Growling<T> for Wolf {}
      return ImplDeclaration.read();

    default: // expression;
      return ExpressionStatement.read();
  }
}

// Prettier 2.5
function read_statement() {
  switch (peek_keyword()) {
    case Keyword.impl: // impl<T> Growling<T> for Wolf {}
      return ImplDeclaration.read();

    default:
      // expression;
      return ExpressionStatement.read();
  }
}

// Prettier 2.6
function read_statement() {
  switch (peek_keyword()) {
    case Keyword.impl: // impl<T> Growling<T> for Wolf {}
      return ImplDeclaration.read();

    default: // expression;
      return ExpressionStatement.read();
  }
}
```

#### Fix misplaced argument comment in abstract methods ([#12185](https://github.com/prettier/prettier/pull/12185) by [@duailibe](https://github.com/duailibe))

<!-- prettier-ignore -->
```ts
// Input
abstract class Foo {
  abstract bar(
    /** comment explaining userId param */
    userId
  )
}

// Prettier 2.5
abstract class Foo {
  abstract bar(userId);
  /** comment explaining userId param */
}

// Prettier 2.6
abstract class Foo {
  abstract bar(
    /** comment explaining userId param */
    userId
  );
}
```

#### Fix typecast of superclass in class declarations ([#12222](https://github.com/prettier/prettier/pull/12222) & [#12226](https://github.com/prettier/prettier/pull/12226) by [@duailibe](https://github.com/duailibe))

This was a combination of two separate bugs: moving the comments before the superclass and adding multiple parenthesis around the superclass.

<!-- prettier-ignore -->
```js
// Input
class Foo extends /** @type {Type} */ (Bar) {}

// Prettier 2.5
class Foo /** @type {Type} */ extends ((Bar)) {}

// Prettier 2.6
class Foo extends /** @type {Type} */ (Bar) {}
```

#### Add support for Unicode Set Notation in regular expressions ([#12241](https://github.com/prettier/prettier/pull/12241) by [@fisker](https://github.com/fisker))

The Stage 3 proposal for [Unicode Set Notation](https://github.com/tc39/proposal-regexp-set-notation/) in regular expressions is now supported via [Babel 7.17.0](https://babeljs.io/blog/2022/02/02/7.17.0).

See [the release blog post of Babel v7.17.0](https://babeljs.io/blog/2022/02/02/7.17.0#regexp-set-notation-and-properties-of-strings-14125httpsgithubcombabelbabelpull14125) and [the README of this proposal](https://github.com/tc39/proposal-regexp-set-notation/) for details. Also keep in mind our [policy on non-standardized syntax](https://prettier.io/docs/rationale#disclaimer-about-non-standard-syntax) before using this proposed syntax feature with Prettier.

<!-- prettier-ignore -->
```jsx
// Examples

/[\p{Decimal_Number}--[0-9]]/v; // Non-ASCII decimal digits

"Did you see the 👩🏿‍❤️‍💋‍👩🏾 emoji?".match(/\p{RGI_Emoji}/v). // ["👩🏿‍❤️‍💋‍👩🏾"]

/[\r\n\q{\r\n|NEWLINE}]/v; // Matches \r, \n, \r\n or NEWLINE
```

#### Add parens to `ClassExpression` with decorators ([#12260](https://github.com/prettier/prettier/pull/12260) by [@fisker](https://github.com/fisker))

<!-- prettier-ignore -->
```js
// Input
(@f() class {});

// Prettier 2.5
@f()
class {};

// Prettier 2.5 (Second format)
SyntaxError: A class name is required. (2:7)
  1 | @f()
> 2 | class {};
    |       ^
  3 |

// Prettier 2.6
(
  @f()
  class {}
);
```

#### Improve printing of comments in type aliases in Flow & TS ([#12268](https://github.com/prettier/prettier/pull/12268) by [@duailibe](https://github.com/duailibe))

For Flow, the comments will now be more aligned to how we print comments in assignments where the right-hand side is an object expression:

<!-- prettier-ignore -->
```js
// Input
type Props = // comment explaining the props
  {
    isPlaying: boolean
  };

// Prettier 2.5
// comment explaining the props
type Props = {
  isPlaying: boolean,
};

// Prettier 2.6
type Props =
  // comment explaining the props
  {
    isPlaying: boolean,
  };
```

This change also fixes an issue where a similarly-placed comment in TypeScript would be moved again after a second formatting operation:

<!-- prettier-ignore -->
```ts
// Input
type Props = // comment explaining the props
  {
    isPlaying: boolean
  };

// Prettier 2.5
type Props = { // comment explaining the props
  isPlaying: boolean;
};

// Prettier 2.5 (2nd format)
type Props = {
  // comment explaining the props
  isPlaying: boolean;
};

// Prettier 2.6
type Props =
  // comment explaining the props
  {
    isPlaying: boolean,
  };
```

#### Add support for destructuring of private fields ([#12276](https://github.com/prettier/prettier/pull/12276) by [@sosukesuzuki](https://github.com/sosukesuzuki))

The Stage 2 TC39 proposal for [destructuring of private fields](https://github.com/tc39/proposal-destructuring-private) is now supported via [Babel 7.17](https://babeljs.io/blog/2022/02/02/7.17.0). Please read our [policy on non-standardized syntax](https://prettier.io/docs/rationale#disclaimer-about-non-standard-syntax) before you decide to use this proposed syntax feature with Prettier.

<!-- prettier-ignore -->
```jsx
// Example
class Foo {
  constructor() {
    console.log(this.#x); // => 1
    const { #x: x } = this;
    console.log(x); // => 1
  }
}
```

#### Support decorator auto accessors syntax ([#12299](https://github.com/prettier/prettier/pull/12299) by [@sosukesuzuki](https://github.com/sosukesuzuki))

Support auto accessors syntax that is introduced in [new decorators proposal](https://github.com/tc39/proposal-decorators). Please read our [policy on non-standardized syntax](https://prettier.io/docs/rationale#disclaimer-about-non-standard-syntax) before you decide to use this proposed syntax feature with Prettier.

<!-- prettier-ignore -->
```jsx
// Example
@defineElement("my-class")
class C extends HTMLElement {
  @reactive accessor clicked = false;
}
```

#### Fix idempotence issues caused by line comments after `=` in assignments ([#12349](https://github.com/prettier/prettier/pull/12349) by [@thorn0](https://github.com/thorn0))

<!-- prettier-ignore -->
```jsx
// Input
const kochabCooieGameOnOboleUnweave = // !!!
  rhubarbRhubarb(annularCooeedSplicesWalksWayWay);

// Prettier 2.5, first format
const kochabCooieGameOnOboleUnweave = rhubarbRhubarb( // !!!
  annularCooeedSplicesWalksWayWay
);

// Prettier 2.5, second format
const kochabCooieGameOnOboleUnweave = rhubarbRhubarb(
  // !!!
  annularCooeedSplicesWalksWayWay
);

// Prettier 2.6
const kochabCooieGameOnOboleUnweave = // !!!
  rhubarbRhubarb(annularCooeedSplicesWalksWayWay);
```

### TypeScript

#### Refactor printing definite assignment assertions ([#12351](https://github.com/prettier/prettier/pull/12351) by [@thorn0](https://github.com/thorn0))

Definite assignment assertions are now printed even when they aren't followed by type annotations. This is an error in TypeScript, but TS is still able to parse the file.

<!-- prettier-ignore -->
```ts
// Input
let a!;

// Prettier 2.5
let a;

// Prettier 2.6
let a!;
```

#### Print trailing comma for rest elements in tuple types ([#12390](https://github.com/prettier/prettier/pull/12390) by [@sosukesuzuki](https://github.com/sosukesuzuki))

TypeScript has allowed rest elements in tuple types (`...T`) to have normal elements come after them since [TypeScript 4.2](https://www.typescriptlang.org/docs/handbook/release-notes/typescript-4-2.html#leadingmiddle-rest-elements-in-tuple-types).
Prettier now prints a trailing comma for the trailing rest element (when trailing commas are enabled) for consistency and to reduce diffs if you decide to add more elements after the final element in the future.

<!-- prettier-ignore -->
```tsx
// { trailingCommma: "all" }

// Input
type Foo = [
  Element,
  Element,
  Element,
  Element,
  Element,
  Element,
  ...RestElement,
];


// Prettier 2.5
type Foo = [
  Element,
  Element,
  Element,
  Element,
  Element,
  Element,
  ...RestElement
];


// Prettier 2.6
type Foo = [
  Element,
  Element,
  Element,
  Element,
  Element,
  Element,
  ...RestElement,
];

```

### Flow

#### Fix Flow's class declaration's `static` indexer formatting ([#12009](https://github.com/prettier/prettier/pull/12009) by [@gkz](https://github.com/gkz))

<!-- prettier-ignore -->
```jsx
// Input
declare class A {
  static [string]: boolean;
}

// Prettier 2.5
declare class A {
  [string]: boolean;
}

// Prettier 2.6
declare class A {
  static [string]: boolean;
}
```

### CSS

#### Preserve blank lines in SCSS maps ([#12210](https://github.com/prettier/prettier/pull/12210) by [@duailibe](https://github.com/duailibe))

This change also applies to some PostCSS features with similar syntax.

<!-- prettier-ignore -->
```css
/* Input */
$colours: (
    "text": $light-100,

    "background-primary": $dark-300,
    "background-secondary": $dark-200,
    "background-tertiary": $dark-100
);

/* Prettier 2.5 */
$colours: (
  "text": $light-100,
  "background-primary": $dark-300,
  "background-secondary": $dark-200,
  "background-tertiary": $dark-100
);

/* Prettier 2.6 */
$colours: (
    "text": $light-100,

    "background-primary": $dark-300,
    "background-secondary": $dark-200,
    "background-tertiary": $dark-100
);
```

#### Fix lowercasing postcss values ([#12393](https://github.com/prettier/prettier/pull/12393) by [@niklasvatn](https://github.com/niklasvatn))

PostCSS values can start with digits. Prettier interprets this as a number followed by a unit in the example below.

<!-- prettier-ignore -->
```css
// Input
@value 4XLarge 28/36px;

.test {
  font: 4XLarge Helvetica;
}

// Prettier 2.5
@value 4XLarge 28/36px;

.test {
  font: 4xlarge Helvetica;
}

// Prettier 2.6
@value 4XLarge 28/36px;

.test {
  font: 4XLarge Helvetica;
}
```

### SCSS

#### Fix comments inside map ([#11920](https://github.com/prettier/prettier/pull/11920) by [@fisker](https://github.com/fisker))

<!-- prettier-ignore -->
```scss
// Input
.ag-theme-balham {
    @include ag-theme-balham(
        (
            foreground-color: $custom-foreground-color,
            disabled-foreground-color: null, // TODO some comment
        )
    );
}

// Prettier 2.5
.ag-theme-balham {
    @include ag-theme-balham(
        (
            foreground-color: $custom-foreground-color,
            disabled-foreground-color: null,
            r: null, // TODO som
        )
    );
}

// Prettier 2.6
.ag-theme-balham {
  @include ag-theme-balham(
    (
      foreground-color: $custom-foreground-color,
      disabled-foreground-color: null,
      // TODO some comment
    )
  );
}
```

#### Fixes printing parameters of a mixin named `selector()` ([#12213](https://github.com/prettier/prettier/pull/12213) by [@duailibe](https://github.com/duailibe))

<!-- prettier-ignore -->
```css
/* Input */
@mixin selector($param: 'value') {
}

/* Prettier 2.5 */
@mixin selector($param: 'value) {
}

/* Prettier 2.6 */
@mixin selector($param: 'value') {
}
```

### Vue

#### Fix hangs on invalid `v-for` ([#12113](https://github.com/prettier/prettier/pull/12113) by [@fisker](https://github.com/fisker))

<!-- prettier-ignore -->
```jsx
// Input
<template>
  <div>
    <div v-for=" a in ">aaaaa</div>
  </div>
</template>

// Prettier 2.5
// Hangs

// Prettier 2.6
<template>
  <div>
    <div v-for=" a in ">aaaaa</div>
  </div>
</template>;
```

#### Allow `lang` attribute of `<template>` to be empty ([#12394](https://github.com/prettier/prettier/pull/12394) by [@HallvardMM](https://github.com/HallvardMM))

Template tag should allow empty string lang="" or undefined lang

<!-- prettier-ignore -->
```vue
<!-- Input -->
<template lang="">
  <v-app-bar>
    <v-menu offset-y>
      <template></template>
    </v-menu>
  </v-app-bar>
</template>

<template lang>
  <v-app-bar>
    <v-menu offset-y>
      <template></template>
    </v-menu>
  </v-app-bar>
</template>

<!-- Prettier 2.5 -->
SyntaxError: Unexpected closing tag "v-menu". It may happen when the tag has already been closed by another tag. For more info see https://www.w3.org/TR/html5/syntax.html#closing-elements-that-have-implied-end-tags (5:5)
[error]   3 |     <v-menu offset-y>
[error]   4 |       <template></template>
[error] > 5 |     </v-menu>
[error]     |     ^^^^^^^^^
[error]   6 |   </v-app-bar>
[error]   7 | </template>

<!-- Prettier 2.6 -->
<template lang="">
  <v-app-bar>
    <v-menu offset-y>
      <template></template>
    </v-menu>
  </v-app-bar>
</template>

<template lang>
  <v-app-bar>
    <v-menu offset-y>
      <template></template>
    </v-menu>
  </v-app-bar>
</template>
```

### Ember / Handlebars

#### Correctly identify which backslashes are removed by glimmer ([#12302](https://github.com/prettier/prettier/pull/12302) by [@MattTheNub](https://github.com/MattTheNub))

This caused Prettier to unnecessarily add backslashes every time a file was formatted.

<!-- prettier-ignore -->
```hbs
{{! Input }}
<p>\</p>
<p>\\</p>
<p>\\\</p>

{{! Prettier 2.5 }}
<p>\\</p>
<p>\\\</p>
<p>\\\\</p>

{{! Prettier 2.6 }}
<p>\</p>
<p>\\</p>
<p>\\\</p>
```

### GraphQL

#### Print descriptions on graphql schema definition nodes ([#11901](https://github.com/prettier/prettier/pull/11901) by [@trevor-scheer](https://github.com/trevor-scheer))

<!-- prettier-ignore -->
```graphql
# Input
"""SchemaDefinition description is lost"""
schema {
  query: Query
}

# Prettier 2.5
schema {
  query: Query
}

# Prettier 2.6
"""
SchemaDefinition description is lost
"""
schema {
  query: Query
}

```

### YAML

#### Fix unexpected deletion of block-literal lines which starts with U+3000 ([#12305](https://github.com/prettier/prettier/pull/12305) by [@Quramy](https://github.com/Quramy))

<!-- prettier-ignore -->
```yaml
# Input
block_with_ideographic_space: |
  　line-content # This line starts with U+3000

# Prettier 2.5
block_with_ideographic_space: |

// Prettier 2.6
block_with_ideographic_space: |
  　line-content # This line starts with U+3000
```

### CLI

#### Add `--no-plugin-search` option to turn off plugin autoloading ([#10274](https://github.com/prettier/prettier/pull/10274) by [@fisker](https://github.com/fisker))

To turn off plugin autoloading, use `--no-plugin-search` when using Prettier CLI or add `{ pluginSearchDirs: false }` to options in `prettier.format()` or to the config file.

<!-- prettier-ignore -->
```cli
// Prettier 2.5
$ prettier . --plugin-search-dir=a-dir-without-plugins

// Prettier 2.6
$ prettier . --no-plugin-search
```

#### Infer parser for `.swcrc` ([#12320](https://github.com/prettier/prettier/pull/12320) by [@sosukesuzuki](https://github.com/sosukesuzuki))

Format the [`.swcrc`](https://swc.rs/docs/configuration/swcrc) file as a JSON file.

### Miscellaneous

#### Switch to `esbuild` ([#12055](https://github.com/prettier/prettier/pull/12055) by [@fisker](https://github.com/fisker))

We've switched our build process from Rollup to [esbuild](https://esbuild.github.io). esbuild is much faster and has improved our development experience. This is an internal change and should not affect users. If something isn’t working for you after upgrading, please [open an issue](https://github.com/prettier/prettier/issues/new?assignees=&labels=&template=integration.md)!
