# MD039 - Remove extra spaces in links

Aliases: `no-space-in-links`

## What this rule does

Removes unnecessary spaces inside square brackets for link text and image descriptions.

## Why this matters

- **Clean appearance**: Extra spaces make links look unprofessional
- **Consistent formatting**: All links should follow the same pattern
- **Better readability**: Clear link boundaries improve document flow
- **Prevents broken links**: Some parsers may not handle extra spaces correctly

## Examples

<!-- rumdl-disable MD039 -->

### ✅ Correct

Link text directly touches the brackets:

```markdown
[Visit our website](https://example.com)

![Company logo](logo.png)

[Reference link][docs]

Check the [API documentation](https://api.example.com) for details.
```

### ❌ Incorrect

Extra spaces inside square brackets:

```markdown
[ Visit our website](https://example.com)

[Visit our website ](https://example.com)

[ Visit our website ](https://example.com)

![ Company logo ](logo.png)
```

### 🔧 Fixed

Spaces removed from inside brackets:

```markdown
[Visit our website](https://example.com)

[Visit our website](https://example.com)

[Visit our website](https://example.com)

![Company logo](logo.png)
```

<!-- rumdl-enable MD039 -->

## Configuration

This rule has no configuration options.

## Automatic fixes

This rule will:

- Remove spaces after opening brackets `[`
- Remove spaces before closing brackets `]`
- Work on both regular links and image alt text
- Handle reference-style links
- Preserve spaces within the link text itself

## Learn more

- [CommonMark specification for links](https://spec.commonmark.org/0.31.2/#links)
- [CommonMark specification for images](https://spec.commonmark.org/0.31.2/#images)

## Related rules

- [MD034 - No bare URLs](md034.md) - Ensure URLs are properly formatted as links
- [MD042 - No empty links](md042.md) - Ensure links have descriptive text
- [MD051 - Link fragments should be valid](md051.md) - Check internal link targets
