# MD066 - Footnote validation

Aliases: `footnote-validation`

## What this rule does

Checks that all footnote references have corresponding definitions and vice versa.

## Why this matters

- **Prevents broken footnotes**: References without definitions leave readers confused
- **Avoids clutter**: Unused definitions add noise to your document
- **Ensures completeness**: All footnotes work as intended
- **Improves accessibility**: Screen readers can follow properly linked footnotes

## Examples

### Correct

```markdown
This text has a footnote[^1] that is properly defined.

Another reference[^note] works too.

[^1]: This is the first footnote.
[^note]: Named footnotes are also valid.
```

### Incorrect - orphaned reference

```markdown
This references[^missing] a footnote that doesn't exist.
```

**Warning**: `Footnote reference [^missing] has no corresponding definition`

### Incorrect - orphaned definition

```markdown
Some text without any footnote references.

[^unused]: This footnote is defined but never referenced.
```

**Warning**: `Footnote definition [^unused] is never referenced`

## Configuration

This rule has no configuration options.

## Automatic fixes

This rule cannot automatically fix issues because:

- Missing definitions require you to provide the footnote content
- Unused definitions might be intentional placeholders or copy-paste errors

## Footnote syntax

Footnotes are a common markdown extension (not part of CommonMark):

- **Reference**: `[^identifier]` placed inline in text
- **Definition**: `[^identifier]: content` at the start of a line

Footnote definitions can span multiple lines with indentation:

```markdown
[^long]: This is a multi-line footnote.

    Additional paragraphs are indented with 4 spaces.

    You can include code blocks and other content.
```

## Related rules

- [MD067 - Footnote definition order](md067.md)
- [MD068 - Empty footnote definitions](md068.md)
