#!/bin/sh
svn cleanup
svn update
REV=`svn info | grep "^Revision:" | cut -d " " -f 2`
LASTREV=`cat lastrev.txt`
if [ "${1}" != "force" ] ; then
  if [ "${REV}" -le "${LASTREV}" ] ; then
    echo "No need to update..."
    exit
  fi
fi
echo "Making tarball"
rm -Rf stegavorto-src
svn co svn://gilgamesh.hamsterrepublic.com/hamster/stegavorto stegavorto-src
tar -jcvf stegavorto-src.tar.bz2 --exclude *.svn stegavorto-src 
rm -Rf stegavorto-src
echo "Erase old distrib tarballs..."
ssh james_paige@motherhamster.org rm HamsterRepublic.com/games/stegavorto/stegavorto-src*.tar.bz2
NOW=`date "+%Y.%m.%d"`
echo "Upload..."
scp -p stegavorto-src.tar.bz2 james_paige@motherhamster.org:HamsterRepublic.com/games/stegavorto/stegavorto-src-"${NOW}".tar.bz2
echo "Update symlink..."
ssh james_paige@motherhamster.org ln -s stegavorto-src-"${NOW}".tar.bz2 HamsterRepublic.com/games/stegavorto/stegavorto-src.tar.bz2
echo "${REV}" > lastrev.txt

if  [ -d "/Applications" ] ; then
  echo "Build Mac App"
  python setup.py
  scp -p dist/StegaVorto.dmg james_paige@motherhamster.org:HamsterRepublic.com/games/stegavorto/
fi
