# Generated by Django 4.0.3 on 2022-05-26 13:58

from django.db import migrations, models
from django.db.models.functions import Cast


def populate_latest_revision(apps, schema_editor):
    Page = apps.get_model("wagtailcore.Page")
    Revision = apps.get_model("wagtailcore.Revision")
    latest_revision_id = models.Subquery(
        Revision.objects.filter(
            content_type_id=models.OuterRef("content_type_id"),
            object_id=Cast(models.OuterRef("pk"), models.CharField()),
        )
        .order_by("-created_at", "-id")
        .values("pk")[:1]
    )
    Page.objects.all().update(latest_revision_id=latest_revision_id)


def populate_revision_object_str(apps, schema_editor):
    Revision = apps.get_model("wagtailcore.Revision")
    Revision.objects.all().update(object_str=models.F("content__title"))


class Migration(migrations.Migration):

    dependencies = [
        ("wagtailcore", "0074_revision_object_str"),
    ]

    operations = [
        migrations.RunPython(
            populate_latest_revision,
            migrations.RunPython.noop,
        ),
        migrations.RunPython(
            populate_revision_object_str,
            migrations.RunPython.noop,
        ),
    ]
