/* $Header: /home/yav/catty/xmagv/RCS/fblib.c,v 1.13 1995/11/17 17:29:49 yav Exp $
 */

#include <stdio.h>
#ifndef __MSDOS__
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#endif
#include "fb.h"

#ifdef __X11__
#ifndef USE_CENTER
#define USE_CENTER No
#endif
#ifndef USE_BACKING_STORE
#define USE_BACKING_STORE Yes
#endif
#ifndef QUICK_RESPONSE
#define QUICK_RESPONSE No
#endif
#ifndef USE_TITLE
#define USE_TITLE Yes
#endif
#else /* __X11__ */
#ifndef USE_CENTER
#define USE_CENTER No
#endif
#ifndef USE_BACKING_STORE
#define USE_BACKING_STORE No
#endif
#ifndef QUICK_RESPONSE
#define QUICK_RESPONSE No
#endif
#ifndef USE_TITLE
#define USE_TITLE No
#endif
#endif /* __X11__ */

char fblib_id[] = "$Id: fblib.c,v 1.13 1995/11/17 17:29:49 yav Exp $";
char fblibRCSrevision[] = "$Revision: 1.13 $";
char *fbsym[] = {"default", "X68k", "SZslow", "SZ", "HF", "HF+", "SF",
		   "X11", "PC98", NULL};
int fb_id = FBID_default;
int fb_xsize = FB_XSIZEMAX;
int fb_ysize = FB_YSIZEMAX;
int fb_realtime = 0;
unsigned int fb_icon_w = 0, fb_icon_h = 0;
char *fb_icon_d = NULL; /* bitmap data or bitmap file name */

char *fblibproginfo[] = {
#ifdef __X11__
  "X11",
#endif
#ifdef __MSDOS__
  "MS-DOS",
#endif
#if USE_CENTER
  "USE_CENTER",
#endif
#if USE_BACKING_STORE
  "USE_BACKING_STORE",
#endif
#if USE_TITLE
  "USE_TITLE",
#endif
#if QUICK_RESPONSE
  "QUICK_RESPONSE",
#endif
  NULL};

/***** X Window System interface *****/
Display *dsp;
int scr;
Colormap cmap;
Window win;
GC gc;
unsigned long fgpix, bgpix;
XImage *img;
unsigned char *image_data;
int wx = 0, wy = 0; /* window pos */
unsigned wxs = 0, wys = 0; /* window size */
int imgx, imgy; /* image pos offset */
char *str_display = NULL;
char *str_geometry = NULL;
char *fb_font = NULL;	/* = NULL -> default "8x13" */
char *fb_title = NULL;
int title_w, title_h;
long fb_eventmask =  ExposureMask | StructureNotifyMask |
  ButtonPressMask | ButtonReleaseMask | KeyPressMask;
int fb_root = 0;
static int windowopened = 0;
static int title_lbear, title_rbear, title_dsc;
static int fb_mcn = FBMC_OFF;
static Cursor fb_cur;

/* color map interface */
FBPIX fb_xcoln = 256;
XColor *fb_xcoltbl = NULL; /* [fb_xcoln] */
char *fb_xcolf = NULL; /* [fb_xcoln] */

#if USE_TITLE
int GetFontmetric(fontname, str)
     char *fontname; char *str;
{
  Font fnt;
  int fontdirec, fontasc, fontdsc;
  XCharStruct fs;
  
  if (fontname == NULL) {
    /* default font is "8x13" */
    title_w = (title_rbear = strlen(str)<<3) - (title_lbear = 1);
    title_dsc = 3;
    title_h = 10;
  } else {
    fnt = XLoadFont(dsp, fontname);
    XSetFont(dsp, gc, fnt);
    XTextExtents(XQueryFont(dsp, fnt), str, strlen(str),
		 &fontdirec, &fontasc, &fontdsc, &fs);
    title_w = (title_rbear = fs.rbearing) - (title_lbear = fs.lbearing);
    title_dsc = fontdsc;
    title_h = fontasc;
  }
  return 0;
}
#endif

/* window standby
 * ref.
 * str_display - display name (default NULL -> $DISPLAY)
 * str_geometry - option set geometry (default NULL)
 */
int SetupWindow()
{
  windowopened = 0;
  if ((dsp = XOpenDisplay(str_display)) == NULL)
    return 1;
  scr = DefaultScreen(dsp);
  cmap = DefaultColormap(dsp, scr);
  fgpix = BlackPixel(dsp, scr);
  bgpix = WhitePixel(dsp, scr);
  return 0;
}

/* open window
 * ref.
 * wx, wy, wxs, wys - default window geometry
 * fb_xsize, fb_ysize - image size
 */
int OpenWindow(argc, argv, wname)
     int argc; char **argv; char *wname;
{
  unsigned long mask;
  XSetWindowAttributes at;
  XSizeHints hint;
  unsigned depth;
  int i, pad, format;
  Font fnt;
  Pixmap ipx = None; /* icon pixmap */
  int wflags = 0;
  
  if (str_geometry != NULL)
    wflags = XParseGeometry(str_geometry, &wx, &wy, &wxs, &wys);
  if (wflags & XNegative)
	wx = DisplayWidth(dsp, DefaultScreen(dsp)) - 1 + wx - wxs;
  if (wflags & YNegative)
	wy = DisplayHeight(dsp, DefaultScreen(dsp)) - 1 + wy - wys;
  hint.x = wx; hint.y = wy;
  hint.width = wxs; hint.height = wys;
  if (str_geometry != NULL)
	hint.flags = USPosition | USSize;
  else
	hint.flags = PPosition | PSize;
  if (windowopened) {
    XResizeWindow(dsp, win, wxs, wys);
    XClearArea(dsp, win, 0,0,0,0,True);
  } else {
    win = DefaultRootWindow(dsp);
    if (!fb_root)
      win = XCreateSimpleWindow(dsp, win, wx, wy, wxs, wys, 1, fgpix, bgpix);
    windowopened = 1;
  }
  if (fb_icon_d != NULL) {
    /* create icon pixmap */
    if (fb_icon_w && fb_icon_h) {
      ipx = XCreateBitmapFromData(dsp, win, fb_icon_d, fb_icon_w, fb_icon_h);
    } else {
      int i;
      i = XReadBitmapFile(dsp, win, fb_icon_d, &fb_icon_w, &fb_icon_h, &ipx,
			  NULL, NULL);
      if (i != BitmapSuccess) {
	fprintf(stderr, "icon bitmap ``%s'' read error (%d)!\n", fb_icon_d, i);
	ipx = None;
      }
    }
  }
  if (!fb_root)
    XSetStandardProperties(dsp, win, wname, wname, ipx, argv, argc, &hint);
  mask = 0;
#if USE_CENTER
  at.bit_gravity = CenterGravity;
  mask |= CWBitGravity;
#endif
#if USE_BACKING_STORE
  mask |= CWBackingStore;
  at.backing_store = WhenMapped;
#endif
  gc = XCreateGC(dsp, win, 0, NULL);
  XSetForeground(dsp, gc, fgpix);
  XSetBackground(dsp, gc, bgpix);
  if (!fb_root) {
    XChangeWindowAttributes(dsp, win, mask, &at);
    XStoreName(dsp, win, wname);
    XSelectInput(dsp, win, fb_eventmask);
    /* XMapRaised(dsp, win); */
  }
  depth = DefaultDepth(dsp, scr);
  if (depth == 1) {
    format = XYPixmap;
    pad = 32;
  } else {
    format = ZPixmap;
    pad = (depth > 8) ? 32 : 8;
  }
  img=XCreateImage(dsp, DefaultVisual(dsp, scr), depth,
		   format, 0, None, fb_xsize, fb_ysize, pad, 0);
#if QUICK_RESPONSE
  XFlush(dsp);
#endif
  if (img == NULL)
    return 1;
  img->data = (char *)malloc(img->bytes_per_line * fb_ysize);
  if (img->data == NULL)
    return 1;
  image_data = (unsigned char *)img->data;
#if USE_TITLE
  if (fb_title != NULL)
    GetFontmetric(fb_font, fb_title);
#endif
  return 0;
}

void CloseWindow()
{
  XDestroyImage(img); /* free img and image_data */
  XFreeGC(dsp, gc);
#if 0
  XFlush(dsp);
#endif
}

void FreeWindow()
{
  if (windowopened) {
    XDestroyWindow(dsp, win);
#if 1
    XFlush(dsp);
#endif
    XCloseDisplay(dsp);
  }
  windowopened = 0;
}

int dummy() {return 0;}

int (*redraw_hook)() = dummy;
int (*redraw_hook2)() = dummy;
int (*resize_hook)() = dummy;
int (*event_hook)() = dummy;
int (*press_hook)() = dummy;
int (*keybd_hook)() = dummy;

/* regist main event loop */
void FB_setevent(p)
     int (*p)();
{
  event_hook = p;
}

/* regist key event */
void FB_setkeyevent(p)
     int (*p)();
{
  keybd_hook = p;
}

/* regist mouse event */
void FB_setmouseevent(p)
     int (*p)();
{
  press_hook = p;
}

void FB_setredrawevent(p)
     int (*p)();
{
  redraw_hook = p;
}

void FB_setredraw2event(p)
     int (*p)();
{
  redraw_hook2 = p;
}

void FB_setresizeevent(p)
     int (*p)();
{
  resize_hook = p;
}

static int titleredrawf = 0;

#if USE_TITLE
void RedrawTitle()
{
  int x, y;

  x = (fb_xsize - title_w)/2 - imgx + title_lbear;
  y = fb_ysize - imgy + title_h;
  if (x > -title_w) {
    if (fb_title != NULL)
      XDrawString(dsp, win, gc, x-title_lbear, y, fb_title, strlen(fb_title));
  }
}
#endif


/*
 * x0, y0 - redraw pos
 * xs, ys - redraw size
 * imgx, imgy - img pos offset
 */
int FB_redrawimage(x0, y0, xs, ys)
     int x0, y0, xs, ys;
{
  int x, y, w, h, f;

  if ((f = (*redraw_hook)(x0, y0, xs, ys)) < 0)
    return 1;
  if (!f) {
    /* default redraw image operation */
    x = imgx + x0;
    y = imgy + y0;
    if (x < 0) {
      XClearArea(dsp, win, x0, y0, -x, ys, False);
      x0 -= x;
      xs += x;
      x = 0;
    }
    if (y < 0) {
      XClearArea(dsp, win, x0, y0, xs, -y, False);
      y0 -= y;
      ys += y;
      y = 0;
    }
    w = fb_xsize - imgx - x0 - xs;
    h = fb_ysize - imgy - y0 - ys;
    if (w < 0) {
      xs += w;
      XClearArea(dsp, win, x0+xs, y0, -w, ys, False);
    }
    if (h < 0) {
      ys += h;
      XClearArea(dsp, win, x0, y0+ys, xs, -h, False);
#if USE_TITLE
      if (fb_title != NULL)
	titleredrawf = 1;
#endif
    }
    XPutImage(dsp, win, gc, img, x, y, x0, y0, xs, ys);
#if USE_TITLE
    if (titleredrawf) {
      RedrawTitle();
      titleredrawf = 0;
    }
#endif
  }
  return (*redraw_hook2)(x0, y0, xs, ys) < 0;
}

void ResizeWindow(x,y,w,h)
     int x, y, w, h;
{
  if ((*resize_hook)(x, y, w, h))
    return;
  /* default resize operation */
  wx = x;
  wy = y;
  wxs = w;
  wys = h;
  imgx = (fb_xsize-(int)wxs)/2;
  imgy = (fb_ysize-(int)wys)/2;
  FB_redrawimage(0, 0, wxs, wys);
}

int mouse_button(f, x, y)
     int f, x, y;
{
  int i, r;
  
  r = 0;
  if ((i = (*press_hook)(f, x, y)) < 0)
    r = 1;
  if (!i) {
    /* default mouse button press operation */
    switch(f) {
    case 1:
      break;
    case 2:
      FB_clear();
      FB_redrawimage(0, 0, wxs, wys);
      break;
    case 3:
      r = 1;
    default:
      break;
    }
  }
  return r;
}

int keyboard(e)
     XKeyEvent *e;
{
  int n, i, r;
  char keybuf[10];
  KeySym key;
  
  r = 0;
  n = XLookupString(e, keybuf, sizeof(keybuf), &key, 0);
  keybuf[n] = '\0';
  if ((i = (*keybd_hook)(keybuf, &key)) < 0)
    r = 1;
  if (!i)
    if (n == 1 && keybuf[0] == 'q')
      r = 1;
  return r;
}

void FB_event()
{
  int i, fin;
  XEvent e;
  
  fin = 0;
  while(!fin) {
    if ((i = (*event_hook)(XEventsQueued(dsp, QueuedAfterFlush))) < 0)
      fin = 1;
    if (i)
      continue;
    XNextEvent(dsp, &e);
    switch(e.type) {
    case Expose:
      fin = FB_redrawimage(e.xexpose.x, e.xexpose.y,
		   e.xexpose.width, e.xexpose.height);
      break;
    case ConfigureNotify:
      if (e.xconfigure.width != wxs || e.xconfigure.height != wys)
	ResizeWindow(e.xconfigure.x, e.xconfigure.y,
		     e.xconfigure.width, e.xconfigure.height);
      break;
    case GraphicsExpose:
      fin = FB_redrawimage(e.xgraphicsexpose.x, e.xgraphicsexpose.y,
		   e.xgraphicsexpose.width, e.xgraphicsexpose.height);
      break;
    case ButtonPress :
      fin = mouse_button(e.xbutton.button, e.xbutton.x, e.xbutton.y);
      break;
    case ButtonRelease :
      fin = mouse_button(0x80|e.xbutton.button, e.xbutton.x, e.xbutton.y);
      break;
#if 0
    case MappingNotify:
      XRefreshKeyboardMapping(&e);
      break;
#endif
    case KeyPress:
      fin = keyboard(&e);
      break;
    default:
      break;
    }
  }
}

/********************************************************************/


int FB_libinit(fbname)
     char *fbname;
{
  int i;

  if (fbname == NULL)
    fbname = fbsym[FBID_default];
  for (i = 0; i < sizeof(fbsym)/sizeof(*fbsym); i++) {
    if (!strcmp(fbname, fbsym[i])) {
      return SetupWindow() ? -1 : i;
    }      
  }
  return -1; /* unknown frame buffer name */
}

void FB_libend()
{
  FB_setmousecursor(FBMC_OFF);
  FreeWindow();
}

int FB_open(argc, argv, wname)
     int argc; char **argv; char *wname;
{
  fb_xcoltbl = (XColor *)malloc(sizeof(*fb_xcoltbl)*fb_xcoln);
  fb_xcolf = (char *)malloc(sizeof(*fb_xcolf)*fb_xcoln);
  if (fb_xcoltbl == NULL || fb_xcolf == NULL)
    return 1;
  memset(fb_xcolf, 0, sizeof(*fb_xcolf)*fb_xcoln);
  /* default window size is same as image size */
  if (!wxs)
    wxs = fb_xsize;
  if (!wys)
    wys = fb_ysize;
  return OpenWindow(argc, argv, wname);
}

int FB_close()
{
  CloseWindow();
  free(fb_xcolf);
  free(fb_xcoltbl);
  return 0;
}

void FB_disp(mode)
     int mode;
{
  if (mode & 2) {
    XMapWindow(dsp, win);
    if (fb_realtime)
      XFlush(dsp);
  }
}


void FB_putline2(x, y, xs, p)
     int x; int y; int xs; unsigned long *p;
{
  int xx,xxs;
  
  xx = x;
  xxs = xs;
  while (xs--) {
    XPutPixel(img, x, y, *p);
    x++;
    p++;
  }
  if (fb_realtime)
    FB_redrawimage(xx, y, xxs, 1);
}


void FB_clear()
{
  XClearWindow(dsp,win);
}

/* color map interface */

static int freecolidx()
{
  int i;
  
  for (i = 0; i < fb_xcoln; i++) {
    if (!*(fb_xcolf+i))
      return i;
  }
  return 0;
}

int FB_alloccol(px, p)
     FBPIX *px; PIXEL *p;
{
#define PIXRGB(n) ((n<<8)|n)
  FBPIX i;
  
  i = freecolidx();
  (fb_xcoltbl+i)->red   = PIXRGB(p->r);
  (fb_xcoltbl+i)->green = PIXRGB(p->g);
  (fb_xcoltbl+i)->blue  = PIXRGB(p->b);
  if (XAllocColor(dsp, cmap, fb_xcoltbl+i)) {
    ++*(fb_xcolf+i);
    *px = i;
    return 0;
  }
  return -1;
#undef PIXRGB
}

void FB_freecol(px)
     FBPIX px;
{
  *(fb_xcolf+px) = 0;
}

void FB_putline3(x, y, xs, p)
     int x; int y; int xs; FBPIX *p;
{
  int xx, xxs;
  
  xx = x;
  xxs = xs;
  while (xs--) {
    XPutPixel(img, x, y, (fb_xcoltbl+*p)->pixel);
    x++;
    p++;
  }
  if (fb_realtime)
    FB_redrawimage(xx, y, xxs, 1);
}

/* mouse cursor font control */
void FB_setmousecursor(f)
     int f;
{
  if (f == fb_mcn)
    return;
  if (fb_mcn != FBMC_OFF)
    XFreeCursor(dsp, fb_cur);
  fb_mcn = f;
  if (f == FBMC_OFF) {
    XUndefineCursor(dsp, win);
    return;
  }
  fb_cur = XCreateFontCursor(dsp, f);
  XDefineCursor(dsp, win, fb_cur);
}

int FB_getmousecursor()
{
  return fb_mcn;
}

/* End of file */
