//
//  Copyright (c) 2013, 2015, 2018, 2021
//  by Tomi Tapper ( tomi.o.tapper@student.jyu.fi )
//
//  Based on linux/btrymeter.h:
//  Copyright (c) 1997, 2005, 2006 by Mike Romberg ( mike.romberg@noaa.gov )
//
//  This file may be distributed under terms of the GPL
//

#ifndef btrymeter_h
#define btrymeter_h

#include "fieldmeter.h"



class BtryMeter : public FieldMeter {
public:
    BtryMeter(void);

    virtual std::string resName(void) const override { return "battery"; }
    virtual void checkevent(void) override;
    virtual void checkResources(const ResDB &rdb) override;

    static bool hasBattery(void);

private:
    enum BatteryState {
        XOSVIEW_BATT_NONE        = 0,
        XOSVIEW_BATT_CHARGING    = (1u << 0),
        XOSVIEW_BATT_DISCHARGING = (1u << 1),
        XOSVIEW_BATT_FULL        = (1u << 2),
        XOSVIEW_BATT_LOW         = (1u << 3),
        XOSVIEW_BATT_CRITICAL    = (1u << 4)
    };

    unsigned long _leftColor, _usedColor, _chargeColor, _fullColor,
        _lowColor, _critColor, _noneColor;
    unsigned int _oldState;

    void getstats(void);
    static void getBatteryInfo(int &remaining, unsigned int &state);
};


#endif
