/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.systemdata;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.systemdata.Messages;
import org.pentaho.di.trans.steps.systemdata.SystemData;
import org.pentaho.di.trans.steps.systemdata.SystemDataData;
import org.pentaho.di.trans.steps.systemdata.SystemDataMetaFunction;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemDataMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static final int TYPE_SYSTEM_INFO_NONE = 0;
    public static final int TYPE_SYSTEM_INFO_SYSTEM_DATE = 1;
    public static final int TYPE_SYSTEM_INFO_SYSTEM_START = 2;
    public static final int TYPE_SYSTEM_INFO_TRANS_DATE_FROM = 3;
    public static final int TYPE_SYSTEM_INFO_TRANS_DATE_TO = 4;
    public static final int TYPE_SYSTEM_INFO_JOB_DATE_FROM = 5;
    public static final int TYPE_SYSTEM_INFO_JOB_DATE_TO = 6;
    public static final int TYPE_SYSTEM_INFO_PREV_DAY_START = 7;
    public static final int TYPE_SYSTEM_INFO_PREV_DAY_END = 8;
    public static final int TYPE_SYSTEM_INFO_THIS_DAY_START = 9;
    public static final int TYPE_SYSTEM_INFO_THIS_DAY_END = 10;
    public static final int TYPE_SYSTEM_INFO_NEXT_DAY_START = 11;
    public static final int TYPE_SYSTEM_INFO_NEXT_DAY_END = 12;
    public static final int TYPE_SYSTEM_INFO_PREV_MONTH_START = 13;
    public static final int TYPE_SYSTEM_INFO_PREV_MONTH_END = 14;
    public static final int TYPE_SYSTEM_INFO_THIS_MONTH_START = 15;
    public static final int TYPE_SYSTEM_INFO_THIS_MONTH_END = 16;
    public static final int TYPE_SYSTEM_INFO_NEXT_MONTH_START = 17;
    public static final int TYPE_SYSTEM_INFO_NEXT_MONTH_END = 18;
    public static final int TYPE_SYSTEM_INFO_COPYNR = 19;
    public static final int TYPE_SYSTEM_INFO_TRANS_NAME = 20;
    public static final int TYPE_SYSTEM_INFO_FILENAME = 21;
    public static final int TYPE_SYSTEM_INFO_MODIFIED_USER = 22;
    public static final int TYPE_SYSTEM_INFO_MODIFIED_DATE = 23;
    public static final int TYPE_SYSTEM_INFO_TRANS_BATCH_ID = 24;
    public static final int TYPE_SYSTEM_INFO_JOB_BATCH_ID = 25;
    public static final int TYPE_SYSTEM_INFO_HOSTNAME = 26;
    public static final int TYPE_SYSTEM_INFO_IP_ADDRESS = 27;
    public static final int TYPE_SYSTEM_INFO_ARGUMENT_01 = 28;
    public static final int TYPE_SYSTEM_INFO_ARGUMENT_02 = 29;
    public static final int TYPE_SYSTEM_INFO_ARGUMENT_03 = 30;
    public static final int TYPE_SYSTEM_INFO_ARGUMENT_04 = 31;
    public static final int TYPE_SYSTEM_INFO_ARGUMENT_05 = 32;
    public static final int TYPE_SYSTEM_INFO_ARGUMENT_06 = 33;
    public static final int TYPE_SYSTEM_INFO_ARGUMENT_07 = 34;
    public static final int TYPE_SYSTEM_INFO_ARGUMENT_08 = 35;
    public static final int TYPE_SYSTEM_INFO_ARGUMENT_09 = 36;
    public static final int TYPE_SYSTEM_INFO_ARGUMENT_10 = 37;
    public static final int TYPE_SYSTEM_INFO_KETTLE_VERSION = 38;
    public static final int TYPE_SYSTEM_INFO_KETTLE_BUILD_VERSION = 39;
    public static final int TYPE_SYSTEM_INFO_KETTLE_BUILD_DATE = 40;
    public static final int TYPE_SYSTEM_INFO_CURRENT_PID = 41;
    public static final SystemDataMetaFunction[] functions = new SystemDataMetaFunction[]{null, new SystemDataMetaFunction(1, "system date (variable)", Messages.getString("SystemDataMeta.TypeDesc.SystemDateVariable")), new SystemDataMetaFunction(2, "system date (fixed)", Messages.getString("SystemDataMeta.TypeDesc.SystemDateFixed")), new SystemDataMetaFunction(3, "start date range", Messages.getString("SystemDataMeta.TypeDesc.StartDateRange")), new SystemDataMetaFunction(4, "end date range", Messages.getString("SystemDataMeta.TypeDesc.EndDateRange")), new SystemDataMetaFunction(5, "job start date range", Messages.getString("SystemDataMeta.TypeDesc.JobStartDateRange")), new SystemDataMetaFunction(6, "job end date range", Messages.getString("SystemDataMeta.TypeDesc.JobEndDateRange")), new SystemDataMetaFunction(7, "yesterday start", Messages.getString("SystemDataMeta.TypeDesc.YesterdayStart")), new SystemDataMetaFunction(8, "yesterday end", Messages.getString("SystemDataMeta.TypeDesc.YesterdayEnd")), new SystemDataMetaFunction(9, "today start", Messages.getString("SystemDataMeta.TypeDesc.TodayStart")), new SystemDataMetaFunction(10, "today end", Messages.getString("SystemDataMeta.TypeDesc.TodayEnd")), new SystemDataMetaFunction(11, "tomorrow start", Messages.getString("SystemDataMeta.TypeDesc.TomorrowStart")), new SystemDataMetaFunction(12, "tomorrow end", Messages.getString("SystemDataMeta.TypeDesc.TomorrowEnd")), new SystemDataMetaFunction(13, "last month start", Messages.getString("SystemDataMeta.TypeDesc.LastMonthStart")), new SystemDataMetaFunction(14, "last month end", Messages.getString("SystemDataMeta.TypeDesc.LastMonthEnd")), new SystemDataMetaFunction(15, "this month start", Messages.getString("SystemDataMeta.TypeDesc.ThisMonthStart")), new SystemDataMetaFunction(16, "this month end", Messages.getString("SystemDataMeta.TypeDesc.ThisMonthEnd")), new SystemDataMetaFunction(17, "next month start", Messages.getString("SystemDataMeta.TypeDesc.NextMonthStart")), new SystemDataMetaFunction(18, "next month end", Messages.getString("SystemDataMeta.TypeDesc.NextMonthEnd")), new SystemDataMetaFunction(19, "copy of step", Messages.getString("SystemDataMeta.TypeDesc.CopyOfStep")), new SystemDataMetaFunction(20, "transformation name", Messages.getString("SystemDataMeta.TypeDesc.TransformationName")), new SystemDataMetaFunction(21, "transformation file name", Messages.getString("SystemDataMeta.TypeDesc.TransformationFileName")), new SystemDataMetaFunction(22, "User modified", Messages.getString("SystemDataMeta.TypeDesc.UserModified")), new SystemDataMetaFunction(23, "Date modified", Messages.getString("SystemDataMeta.TypeDesc.DateModified")), new SystemDataMetaFunction(24, "batch ID", Messages.getString("SystemDataMeta.TypeDesc.BatchID")), new SystemDataMetaFunction(25, "job batch ID", Messages.getString("SystemDataMeta.TypeDesc.JobBatchID")), new SystemDataMetaFunction(26, "Hostname", Messages.getString("SystemDataMeta.TypeDesc.Hostname")), new SystemDataMetaFunction(27, "IP address", Messages.getString("SystemDataMeta.TypeDesc.IPAddress")), new SystemDataMetaFunction(28, "command line argument 1", Messages.getString("SystemDataMeta.TypeDesc.CommandLineArgument1")), new SystemDataMetaFunction(29, "command line argument 2", Messages.getString("SystemDataMeta.TypeDesc.CommandLineArgument2")), new SystemDataMetaFunction(30, "command line argument 3", Messages.getString("SystemDataMeta.TypeDesc.CommandLineArgument3")), new SystemDataMetaFunction(31, "command line argument 4", Messages.getString("SystemDataMeta.TypeDesc.CommandLineArgument4")), new SystemDataMetaFunction(32, "command line argument 5", Messages.getString("SystemDataMeta.TypeDesc.CommandLineArgument5")), new SystemDataMetaFunction(33, "command line argument 6", Messages.getString("SystemDataMeta.TypeDesc.CommandLineArgument6")), new SystemDataMetaFunction(34, "command line argument 7", Messages.getString("SystemDataMeta.TypeDesc.CommandLineArgument7")), new SystemDataMetaFunction(35, "command line argument 8", Messages.getString("SystemDataMeta.TypeDesc.CommandLineArgument8")), new SystemDataMetaFunction(36, "command line argument 9", Messages.getString("SystemDataMeta.TypeDesc.CommandLineArgument9")), new SystemDataMetaFunction(37, "command line argument 10", Messages.getString("SystemDataMeta.TypeDesc.CommandLineArgument10")), new SystemDataMetaFunction(38, "kettle version", Messages.getString("SystemDataMeta.TypeDesc.KettleVersion")), new SystemDataMetaFunction(39, "kettle build version", Messages.getString("SystemDataMeta.TypeDesc.KettleBuildVersion")), new SystemDataMetaFunction(40, "kettle build date", Messages.getString("SystemDataMeta.TypeDesc.KettleBuildDate")), new SystemDataMetaFunction(41, "Current PID", Messages.getString("SystemDataMeta.TypeDesc.CurrentPID"))};
    private String[] fieldName;
    private int[] fieldType;

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public int[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int[] fieldType) {
        this.fieldType = fieldType;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int count) {
        this.fieldName = new String[count];
        this.fieldType = new int[count];
    }

    @Override
    public Object clone() {
        SystemDataMeta retval = (SystemDataMeta)super.clone();
        int count = this.fieldName.length;
        retval.allocate(count);
        for (int i = 0; i < count; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.fieldType[i] = this.fieldType[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int count = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                String type = XMLHandler.getTagValue((Node)fnode, (String)"type");
                this.fieldType[i] = SystemDataMeta.getType(type);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to read step information from XML", (Throwable)e);
        }
    }

    public static final int getType(String type) {
        for (int i = 1; i < functions.length; ++i) {
            if (functions[i].getCode().equalsIgnoreCase(type)) {
                return i;
            }
            if (!functions[i].getDescription().equalsIgnoreCase(type)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTypeDesc(int t) {
        if (functions == null || functions.length == 0) {
            return null;
        }
        if (t < 0 || t >= functions.length || functions[t] == null) {
            return null;
        }
        return functions[t].getDescription();
    }

    @Override
    public void setDefault() {
        int count = 0;
        this.allocate(count);
        for (int i = 0; i < count; ++i) {
            this.fieldName[i] = "field" + i;
            this.fieldType[i] = 1;
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        for (int i = 0; i < this.fieldName.length; ++i) {
            ValueMeta v;
            switch (this.fieldType[i]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 23: 
                case 40: {
                    v = new ValueMeta(this.fieldName[i], 3);
                    break;
                }
                case 19: 
                case 24: 
                case 25: 
                case 39: {
                    v = new ValueMeta(this.fieldName[i], 5);
                    v.setLength(10, 0);
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: {
                    v = new ValueMeta(this.fieldName[i], 2);
                    break;
                }
                case 41: {
                    v = new ValueMeta(this.fieldName[i], 5);
                    v.setLength(10, 0);
                    break;
                }
                default: {
                    v = new ValueMeta(this.fieldName[i], 0);
                }
            }
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    <fields>" + Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"type", (String)(functions[this.fieldType[i]] != null ? functions[this.fieldType[i]].getCode() : "")));
            retval.append("        </field>" + Const.CR);
        }
        retval.append("      </fields>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldType[i] = SystemDataMeta.getType(rep.getStepAttributeString(id_step, i, "field_type"));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            for (int i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_type", functions[this.fieldType[i]] != null ? functions[this.fieldType[i]].getCode() : "");
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        int nrRemarks = remarks.size();
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (this.fieldType[i] > 0) continue;
            CheckResult cr = new CheckResult(4, Messages.getString("SystemDataMeta.CheckResult.FieldHasNoType", this.fieldName[i]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (remarks.size() == nrRemarks) {
            CheckResult cr = new CheckResult(1, Messages.getString("SystemDataMeta.CheckResult.AllTypesSpecified"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public Map<String, String> getUsedArguments() {
        HashMap<String, String> stepArgs = new HashMap<String, String>();
        DecimalFormat df = new DecimalFormat("00");
        for (int argNr = 0; argNr < 10; ++argNr) {
            boolean found = false;
            for (int i = 0; i < this.fieldName.length; ++i) {
                if (this.fieldType[i] != 28 + argNr) continue;
                found = true;
            }
            if (!found) continue;
            stepArgs.put(df.format(argNr + 1), "");
        }
        return stepArgs;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SystemData(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SystemDataData();
    }
}

