/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.logging.Logger;
import java.util.stream.Stream;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.LogBuilder;

public abstract class TileItem
extends FreeColGameObject
implements Locatable,
Named {
    private static final Logger logger = Logger.getLogger(TileItem.class.getName());
    protected Tile tile;

    protected TileItem(Game game, Tile tile) {
        super(game);
        if (tile == null) {
            throw new RuntimeException("Tile must not be null: " + this);
        }
        this.tile = tile;
    }

    public TileItem(Game game, FreeColXMLReader xr) {
        super(game, null);
    }

    public TileItem(Game game, String id) {
        super(game, id);
    }

    public abstract int getZIndex();

    public abstract boolean isTileTypeAllowed(TileType var1);

    public abstract int applyBonus(GoodsType var1, UnitType var2, int var3);

    public abstract boolean canProduce(GoodsType var1, UnitType var2);

    public abstract Stream<Modifier> getProductionModifiers(GoodsType var1, UnitType var2);

    public abstract boolean isNatural();

    public abstract boolean isComplete();

    public abstract Map.Layer getLayer();

    @Override
    public Location getLocation() {
        return this.tile;
    }

    @Override
    public boolean setLocation(Location newLocation) {
        if (newLocation == null || newLocation instanceof Tile) {
            this.tile = (Tile)newLocation;
            return true;
        }
        throw new RuntimeException("newLocation is not a Tile: " + newLocation);
    }

    @Override
    public boolean isInEurope() {
        return false;
    }

    @Override
    public Tile getTile() {
        return this.tile;
    }

    @Override
    public int getSpaceTaken() {
        return 0;
    }

    @Override
    public abstract String getNameKey();

    @Override
    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = super.checkIntegrity(fix, lb);
        if (this.tile == null) {
            lb.add("\n  Tile item with no tile: ", this.getId());
            result = result.fail();
        }
        return result;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        TileItem o = this.copyInCast(other, TileItem.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.tile = this.getGame().updateRef(o.getTile());
        return true;
    }
}

