/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import jakarta.persistence.metamodel.Type;
import java.util.Objects;
import org.hibernate.type.BasicTypeReference;
import org.hibernate.type.BindableType;

public record TypedParameterValue<J>(BindableType<J> type, J value) {
    public TypedParameterValue {
        Objects.requireNonNull(type, "type must not be null");
    }

    public static <J> TypedParameterValue<J> of(Type<J> type, J value) {
        return new TypedParameterValue<J>((BindableType)type, value);
    }

    public static <J> TypedParameterValue<J> ofNull(Type<J> type) {
        return new TypedParameterValue<Object>((BindableType)type, null);
    }

    @Deprecated(since="7")
    public J getValue() {
        return this.value;
    }

    @Deprecated(since="7")
    public BindableType<J> getType() {
        return this.type;
    }

    @Deprecated(since="7")
    public BasicTypeReference<J> getTypeReference() {
        BasicTypeReference reference;
        BindableType<J> bindableType = this.type;
        return bindableType instanceof BasicTypeReference ? (reference = (BasicTypeReference)bindableType) : null;
    }
}

