/**
 *
 * Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
 * Requires jQuery and raphael.js
 *
 * Map of Ukraine with regions
 *
 * @author Ievgen Sentiabov https://github.com/joni-jones
 */
(function ($) {
    $.extend(true, $.fn.mapael,
        {
            maps: {
                ukraine: {
                    width: 570,
                    height: 390,
                    getCoords : function(lat, lon) {
                        var ax = 29.485884032047;
                        var bx = -626;
                        var ay = -44.3404565721;
                        var by = 2349.2960336992;
                        var x = (lon * ax) + bx;
                        var y = (lat * ay) + by;
                        return {x: x, y: y};
                    },
                    elems: {
                        "Zhytomyr": "m 233.456,60.381 c -0.173,-0.303 -0.692,-0.52 -1.429,-0.736 -0.779,-0.173 -1.342,-0.216 -1.775,-0.086 -0.736,0.26 -1.169,0.606 -1.255,1.083 0.043,0.346 0.043,0.606 -0.043,0.736 -0.13,0.216 -0.433,0.52 -0.823,0.823 l -0.433,0.26 c -0.39,-0.13 -0.693,-0.217 -0.909,-0.217 -0.087,-0.043 -0.303,-0.043 -0.606,-0.043 -0.52,0.043 -1.125,0.216 -1.818,0.649 -0.346,0.13 -0.649,0.26 -0.823,0.346 -0.52,0.303 -1.169,1.126 -1.991,2.425 -0.39,0.563 -0.52,1.125 -0.433,1.688 0.13,0.26 0.173,0.476 0.173,0.606 l -0.13,1.386 c -0.086,0.13 -0.216,0.216 -0.39,0.26 -0.39,0.043 -0.606,-0.216 -0.693,-0.779 -0.043,-0.649 -0.173,-0.996 -0.259,-1.039 -0.087,0 -0.26,0.13 -0.477,0.346 -0.216,0.173 -0.39,0.26 -0.563,0.26 -0.476,-0.086 -0.822,-0.779 -1.082,-2.122 -0.043,-0.13 -0.087,-0.346 -0.217,-0.606 0,-0.303 -0.086,-0.779 -0.26,-1.429 0,-0.26 0,-0.693 0.043,-1.256 -0.086,-0.26 -0.26,-0.39 -0.563,-0.39 -0.606,0.173 -1.039,0.26 -1.342,0.26 -0.563,-0.303 -0.996,-0.52 -1.255,-0.563 -0.346,-0.086 -0.606,-0.173 -0.779,-0.216 -0.693,-0.043 -1.516,0.303 -2.555,1.083 -0.996,0.736 -1.559,1.125 -1.602,1.169 l -0.13,-0.086 c -0.13,-0.433 -0.303,-1.039 -0.476,-1.862 -0.043,-0.087 -0.173,-0.26 -0.39,-0.433 -0.173,-0.173 -0.433,-0.433 -0.779,-0.736 -0.173,-0.13 -0.563,-0.39 -1.126,-0.779 -0.13,-0.173 -0.086,-0.736 0.13,-1.689 -0.043,-0.13 -0.13,-0.216 -0.216,-0.216 -1.039,0 -1.818,0.346 -2.381,1.126 -0.043,0.086 -0.26,0.476 -0.606,1.125 -0.39,0.823 -0.606,1.255 -0.692,1.342 -0.13,0.173 -0.433,0.346 -0.866,0.52 -0.303,0.13 -0.953,0.173 -1.949,0.173 -0.52,0.087 -0.909,0.087 -1.169,0.087 -0.346,-0.087 -0.563,-0.173 -0.736,-0.26 -0.216,-0.13 -0.433,-0.217 -0.563,-0.303 -0.13,-0.043 -0.649,-0.52 -1.602,-1.429 -0.086,-0.13 -0.26,-0.303 -0.52,-0.563 -0.303,-0.216 -0.52,-0.26 -0.693,-0.13 -0.173,0.087 -0.303,0.13 -0.39,0.217 -0.779,0.52 -1.125,1.082 -1.082,1.688 0.086,0.346 0.129,0.606 0.173,0.779 0.173,0.563 0.173,1.039 0.043,1.429 -0.043,0.043 -0.13,0.173 -0.26,0.346 -0.26,0.26 -0.52,0.606 -0.736,0.996 -0.346,0.39 -0.606,0.649 -0.692,0.823 -0.087,0.303 -0.173,0.52 -0.26,0.649 l -0.173,0.043 c -0.433,-0.303 -0.693,-0.52 -0.866,-0.606 -0.173,-0.13 -0.52,-0.346 -1.083,-0.649 l 0.086,-0.26 c -0.173,0.26 -0.433,0.433 -0.779,0.476 -0.433,0.043 -0.693,0.087 -0.693,0.087 -0.043,0 -0.13,0.043 -0.26,0.13 l -0.476,0.26 c -0.303,0.043 -0.52,0.13 -0.693,0.26 -0.086,0.13 -0.173,0.39 -0.303,0.909 -0.173,0.476 -0.216,0.823 -0.216,0.953 0.39,0.346 0.649,0.606 0.823,0.779 0.216,0.216 0.303,0.563 0.216,1.039 l -0.13,0.043 c -0.216,-0.043 -0.52,-0.26 -0.996,-0.606 -0.433,-0.346 -0.692,-0.606 -0.822,-0.779 0,-0.216 -0.086,-0.433 -0.26,-0.693 -0.217,-0.26 -0.39,-0.39 -0.563,-0.39 -0.13,0.043 -0.216,0.13 -0.216,0.216 l -0.13,0.347 c 0,0.303 -0.043,0.563 -0.043,0.736 l -0.173,0.736 c -0.173,0.476 -0.26,0.823 -0.26,1.039 0.043,0.173 0.173,0.303 0.433,0.52 0.26,0.173 0.39,0.303 0.477,0.476 0.043,0.13 0,0.347 -0.087,0.649 -0.086,0.13 -0.173,0.303 -0.303,0.477 -0.346,0.39 -0.692,0.606 -1.125,0.693 -0.649,0.086 -1.126,0.173 -1.299,0.259 l -0.087,0.13 c 0.043,0.13 0.303,0.65 0.779,1.473 0.39,0.692 0.477,1.342 0.347,1.861 -0.13,0.39 -0.347,0.693 -0.693,0.866 -0.476,0.26 -0.736,0.433 -0.866,0.563 -0.087,0.173 -0.173,0.39 -0.217,0.693 0,0.303 -0.043,0.476 -0.086,0.563 -0.476,0.433 -0.779,0.779 -0.909,1.125 -0.13,0.173 -0.173,0.563 -0.173,1.169 0,0.52 -0.043,0.823 -0.13,0.91 -0.606,0.606 -0.909,0.952 -0.953,1.039 -0.086,0.606 -0.13,0.953 -0.26,1.039 -0.476,0.303 -0.823,0.476 -1.039,0.563 -0.736,0.043 -1.212,0.173 -1.472,0.346 -0.13,0.13 -0.216,0.346 -0.303,0.693 -0.043,0.346 -0.217,0.649 -0.52,0.866 0.346,0.477 0.563,0.866 0.692,1.169 -0.086,0.39 -0.086,0.693 0,0.866 0.347,0.26 0.563,0.433 0.65,0.606 0.043,0.433 -0.173,0.606 -0.736,0.563 l -0.086,0.13 c 0,0.086 0.043,0.173 0.13,0.26 0.52,0.606 0.779,1.039 0.736,1.255 -0.043,0.477 -0.173,1.126 -0.39,2.079 -0.173,0.563 -0.217,0.996 -0.173,1.299 0,0.433 0.303,1.083 0.866,1.905 0.13,0.13 0.216,0.26 0.303,0.303 0.26,0.433 0.39,0.823 0.346,1.169 -0.043,0.303 -0.086,0.563 -0.173,0.736 -0.086,0.303 -0.39,0.909 -0.953,1.862 -0.303,0.346 -0.563,0.649 -0.736,0.822 0,0.303 -0.043,0.52 -0.086,0.693 -0.087,0.13 -0.26,0.476 -0.563,0.953 -0.043,0.086 -0.087,0.173 -0.043,0.346 0.087,0.173 0.303,0.347 0.693,0.563 0.39,0.173 0.649,0.39 0.779,0.563 0,0.043 0,0.13 0,0.26 -0.043,0.216 -0.216,0.52 -0.52,0.822 -0.476,0.477 -0.736,0.736 -0.823,0.779 v 0.043 c 0.347,0.087 0.563,0.217 0.649,0.39 0,0.217 0.043,0.39 0.087,0.52 0.129,0.13 0.39,0.217 0.866,0.26 0.087,0.52 0.216,0.91 0.433,1.169 0.606,0.173 1.083,0.303 1.385,0.39 l 0.087,0.129 c -0.173,0.13 -0.52,0.347 -1.083,0.606 l -0.086,0.13 c -0.433,0.346 -0.693,0.866 -0.866,1.472 l -0.26,0.953 c -0.216,0.779 -0.13,1.255 0.346,1.342 0.26,0 0.477,0.043 0.649,0.087 0.303,0 0.52,0.086 0.693,0.216 0.087,0.086 0.217,0.347 0.26,0.736 0.086,0.346 0.217,0.606 0.433,0.736 0.563,0.26 0.953,0.433 1.169,0.563 0.13,0.086 0.303,0.216 0.606,0.476 l 0.606,0.476 c 0.216,0.043 0.39,0.173 0.52,0.303 0,0.13 -0.13,0.26 -0.39,0.476 l -0.043,0.173 0.13,0.26 0.13,0.087 c 0.087,0 0.173,-0.043 0.347,-0.13 0.13,-0.087 0.303,-0.087 0.476,-0.043 0.043,0.043 0.086,0.216 0.086,0.433 0.043,0.216 0.087,0.39 0.173,0.433 0,0 0.216,0.043 0.606,0.087 0.303,0.043 0.563,0.216 0.736,0.476 -0.087,0.39 -0.087,0.693 -0.087,0.909 0.043,0.043 0.39,0.087 0.953,0.173 0.606,0.043 0.91,0.086 1.039,0.043 0,-0.043 0.13,-0.347 0.39,-0.866 l 0.217,-0.173 c 0.086,-0.086 0.173,-0.26 0.26,-0.606 l 0.13,-0.13 c 0.26,0 0.433,0.043 0.563,0.086 0.26,0.13 0.26,0.78 0.043,1.992 -0.043,0.347 0.043,0.606 0.217,0.779 0.086,0.13 0.39,0.39 0.779,0.823 0.346,0.39 0.476,0.736 0.39,1.039 -0.043,0.086 -0.086,0.173 -0.13,0.217 l -0.563,0.216 c -0.086,0.13 -0.13,0.303 -0.086,0.52 0.043,0.086 0.303,0.26 0.693,0.52 0.043,0.13 0,0.26 -0.087,0.346 -0.216,0.043 -0.433,0.303 -0.606,0.78 -0.217,0.433 -0.217,0.822 -0.043,1.039 0.043,0.043 0.303,0.13 0.736,0.26 0.303,0.086 0.476,0.346 0.519,0.736 -0.043,0.26 -0.086,0.563 -0.173,1.039 l -0.086,0.087 c -0.477,0 -0.78,0.173 -0.996,0.476 -0.216,0.303 -0.649,0.39 -1.255,0.346 -0.563,-0.086 -0.953,-0.173 -1.212,-0.216 0,0.303 0.216,0.736 0.606,1.299 0.39,0.563 0.606,0.996 0.606,1.386 -0.13,0.086 -0.477,0.13 -1.039,0.13 l -0.087,0.13 c -0.086,0.996 -0.086,1.559 0,1.645 l 0.216,0.217 c 0.13,0.043 0.477,0.086 1.039,0.043 0.477,0.087 0.563,0.477 0.303,1.126 0,0.26 0.347,0.779 1.039,1.559 0.173,0.26 0.303,0.52 0.433,0.909 0.043,0.303 0.216,0.606 0.39,0.866 l 0.087,0.043 c 0.173,0.173 0.39,0.26 0.563,0.216 0.26,0 0.433,0 0.477,0.043 l 0.52,0.13 c 1.125,0.216 1.732,0.346 1.862,0.39 0.303,0.13 0.822,0.347 1.515,0.649 0.606,0.087 0.953,0.173 1.083,0.217 0.043,0 0.043,0 0.043,0 0.086,0.086 0.216,0.13 0.346,0.086 1.688,-0.346 2.728,-0.477 3.031,-0.39 0.216,0.043 0.563,0.173 0.996,0.346 0.26,0.087 0.736,0.043 1.342,-0.13 0.303,-0.13 0.779,-0.26 1.342,-0.476 0.779,-0.173 1.256,-0.26 1.429,-0.26 l 0.563,0.13 c 0.173,0 0.649,-0.043 1.429,-0.13 0.433,-0.043 0.693,-0.13 0.823,-0.13 0.606,-0.26 0.996,-0.347 1.039,-0.347 0.087,0.043 0.477,0.26 1.212,0.606 0.476,0.26 0.909,0.39 1.299,0.303 0.347,-0.043 0.693,-0.346 0.996,-0.866 0.303,-0.563 0.519,-0.866 0.606,-0.909 0.303,-0.086 0.866,0.043 1.602,0.476 0.086,0 0.39,-0.13 0.909,-0.346 0.346,-0.216 0.736,-0.173 1.169,0.216 0.303,0.26 0.52,0.52 0.563,0.736 l 0.779,-0.217 c 0.216,-0.086 0.563,-0.26 1.039,-0.52 0.26,0 0.779,0.13 1.559,0.347 0.736,0.173 1.169,0.086 1.385,-0.217 0.087,-0.173 0.173,-0.476 0.303,-0.822 0.087,-0.173 0.217,-0.433 0.433,-0.823 0.13,-0.173 0.433,-0.303 0.823,-0.476 0.433,-0.13 0.736,-0.303 0.909,-0.477 0.173,-0.174 0.26,-0.563 0.39,-1.125 0.043,0 0.433,0.043 1.169,0.13 0.779,0.13 1.256,0.173 1.385,0.216 l 0.087,0.13 c 0,0.043 -0.13,0.303 -0.26,0.736 0.52,0.086 0.953,0.259 1.212,0.52 0,0.086 -0.087,0.39 -0.347,0.952 0,0.13 0.043,0.347 0.173,0.693 0.043,0.13 0,0.346 -0.043,0.606 0.259,0.823 0.519,1.386 0.909,1.689 0.217,0.216 0.606,0.433 1.169,0.692 0.043,0.087 -0.26,0.52 -0.953,1.299 -0.736,0.822 -0.996,1.299 -0.909,1.559 0.086,0.086 0.346,0.26 0.866,0.476 l 0.086,0.13 c -0.129,0.303 0,0.649 0.217,0.996 0.26,0.39 0.39,0.606 0.346,0.692 -0.086,0.173 -0.303,0.477 -0.606,0.866 0.13,0.26 0.346,0.433 0.736,0.606 0.346,0.13 0.693,0.173 0.996,0.087 0.086,0 0.26,-0.087 0.563,-0.217 0.347,0.087 0.866,0.173 1.516,0.303 0.173,0.043 0.433,0.086 0.779,0.173 l 1.169,-0.13 c 0.26,0 0.649,-0.043 1.083,-0.043 0.216,0 0.52,-0.043 0.866,-0.086 0.173,0.043 0.477,0.086 0.953,0.173 0,0 0,-0.26 0.043,-0.692 0,-0.303 0.086,-0.52 0.216,-0.693 0.606,-0.217 0.996,-0.347 1.169,-0.39 0.086,0 0.303,0.043 0.65,0.216 0.303,0.13 0.563,0.13 0.736,0.043 0.39,-0.173 0.693,-0.433 0.909,-0.779 0.303,-0.39 0.52,-0.649 0.693,-0.779 0.433,-0.087 0.693,-0.087 0.822,0.086 -0.129,-0.217 -0.086,-0.477 0.043,-0.736 0.173,-0.13 0.433,-0.26 0.866,-0.346 0.26,-0.823 0.26,-1.342 0.043,-1.559 -0.346,0.086 -0.649,0.13 -0.866,0.13 -0.13,0.043 -0.477,0.043 -1.039,0 0.173,-0.173 0.26,-0.347 0.346,-0.476 0.52,-0.693 0.779,-1.386 0.736,-2.035 -0.043,-0.13 -0.087,-0.346 -0.26,-0.606 -0.217,-0.26 -0.26,-0.52 -0.26,-0.78 0.13,-0.043 0.347,-0.173 0.606,-0.39 0.13,0 0.39,0 0.693,0.087 l 0.216,-0.217 c 0.043,-0.26 0.086,-0.433 0.173,-0.52 0.086,0 0.216,0 0.389,0.087 0.13,0.043 0.303,0 0.433,-0.043 0.173,-0.173 0.563,-0.433 1.04,-0.823 0.303,-0.173 0.692,-0.346 1.255,-0.606 0.043,-0.043 0.173,-0.173 0.39,-0.39 l 0.606,-0.217 0.087,-0.043 0.13,-0.13 c 0.043,-0.043 0.173,-0.173 0.433,-0.433 0.043,0 0.087,-0.086 0.173,-0.216 0,-0.26 0.043,-0.52 0.13,-0.649 0.13,-0.13 0.52,-0.347 1.212,-0.649 0.649,-0.347 0.953,-0.78 0.996,-1.299 -1.473,-2.165 -2.122,-3.42 -2.035,-3.723 0.043,-0.043 0.26,-0.173 0.476,-0.347 -0.346,-1.385 -0.52,-2.208 -0.563,-2.468 0,-0.216 0.13,-0.39 0.39,-0.476 0.086,0.043 0.39,0 0.909,-0.173 0.52,-0.217 0.779,-0.347 0.909,-0.476 0.043,-0.347 0.086,-0.52 0.086,-0.563 -0.346,-0.043 -0.606,-0.13 -0.693,-0.217 -0.086,-0.216 -0.086,-0.433 0.043,-0.649 0.173,-0.216 0.217,-0.346 0.217,-0.433 l -0.13,-0.26 c -0.52,-0.216 -0.822,-0.476 -0.952,-0.779 l -0.043,-0.13 c 0.043,-0.476 0.043,-0.866 0.043,-1.125 0,-0.216 0,-0.563 -0.043,-0.996 -0.043,-0.259 -0.043,-0.606 0,-1.082 0.043,-0.173 0.173,-0.347 0.303,-0.52 v -0.13 l -0.26,-0.173 c -0.13,0 -0.347,-0.043 -0.52,-0.173 -0.476,-1.083 -0.822,-1.688 -1.039,-1.862 -0.736,0.043 -1.169,0.043 -1.255,0 l -0.043,-0.13 c -0.043,-0.26 0,-0.692 0.217,-1.299 -0.303,-0.13 -0.477,-0.216 -0.606,-0.346 -0.043,-0.26 -0.043,-0.693 0.043,-1.256 -0.043,-0.216 -0.216,-0.563 -0.563,-0.996 -0.346,-0.477 -0.649,-0.693 -0.823,-0.693 -0.606,0 -0.996,0 -1.255,0.043 l -0.303,0.13 c -0.216,0.13 -0.433,0.216 -0.563,0.26 l -0.736,0.216 c -0.13,0.043 -0.303,0 -0.476,-0.13 -0.173,-0.39 -0.13,-0.649 0.13,-0.736 l 0.866,-0.087 c 0.043,0 0.173,-0.173 0.346,-0.476 v -0.13 l -0.779,-0.346 -0.087,-0.13 0.087,-0.303 0.129,-0.13 c 0.477,0.173 0.736,0.216 0.91,0.216 0.129,-0.13 0.26,-0.346 0.433,-0.693 0.217,-0.606 0.26,-1.082 0.043,-1.385 l -0.693,-0.26 c -0.086,-0.173 -0.086,-0.39 0,-0.693 0.13,-0.13 0.346,-0.173 0.693,-0.086 0.13,-0.173 0.346,-0.736 0.649,-1.732 -0.043,-0.086 -0.26,-0.26 -0.693,-0.52 -0.303,-0.26 -0.476,-0.433 -0.476,-0.563 0.13,-0.26 0.303,-0.649 0.52,-1.212 0.216,-0.303 0.563,-0.779 0.996,-1.385 0.303,-0.563 0.433,-0.866 0.477,-0.866 0.693,-0.347 1.125,-0.563 1.299,-0.736 0.216,-0.26 0.216,-0.693 0.043,-1.255 -0.217,-0.693 -0.303,-1.083 -0.303,-1.212 -0.086,-0.26 -0.173,-0.606 -0.217,-1.083 -0.216,-0.476 -0.952,-0.563 -2.251,-0.346 h -0.173 l -0.086,-0.13 c 0.086,-0.736 0.216,-1.689 0.563,-2.858 l 0.087,-0.563 c 0.043,-0.217 0.043,-0.39 0,-0.477 -0.39,-0.346 -0.649,-0.649 -0.78,-0.866 -0.129,-0.13 -0.519,-0.693 -1.168,-1.732 -0.347,-0.39 -0.563,-0.736 -0.693,-0.953 -0.087,-0.086 -0.217,-0.13 -0.39,-0.086 -0.217,0.043 -0.39,0.043 -0.433,0 -0.043,-0.217 -0.086,-0.606 -0.086,-1.212 l 0.086,-0.13 c 0.476,-0.043 0.953,-0.043 1.299,0.043 0.086,0 0.217,0.13 0.433,0.303 0.216,0.217 0.346,0.26 0.52,0.26 0.043,-0.086 0,-0.563 -0.13,-1.472 -0.087,-0.563 -0.043,-1.04 0.043,-1.299 0.129,-0.26 0.39,-0.606 0.736,-0.996 0.043,-0.13 0.043,-0.303 0,-0.52 -0.13,-0.52 -0.736,-0.909 -1.732,-1.169 l -0.086,-0.087 c -0.043,-0.303 -0.087,-0.52 -0.173,-0.606 -0.086,-0.346 -0.433,-0.693 -0.953,-1.126 -0.476,-0.39 -0.909,-0.606 -1.299,-0.692 l -0.173,0.086 c -0.477,0.823 -0.78,1.255 -0.823,1.255 -0.303,-0.563 -0.477,-1.299 -0.606,-2.294 0,-0.52 -0.086,-0.909 -0.086,-1.169 -0.043,-0.217 -0.13,-0.563 -0.303,-1.039 l -0.043,-0.043 c -0.043,-0.173 -0.13,-0.52 -0.303,-0.996 l 0.043,-0.13 c 0.563,0.086 1.125,-0.087 1.688,-0.52 0.822,-0.563 1.385,-1.169 1.688,-1.819 0.173,-0.346 0.26,-0.606 0.26,-0.779 0,-0.216 0,-0.563 -0.043,-0.953 0.13,-0.822 0.043,-1.342 -0.086,-1.472 h -0.13 c -0.173,0.216 -0.26,0.303 -0.39,0.303 l -0.13,-0.043 c -0.173,-0.26 -0.303,-0.477 -0.39,-0.606 -0.173,0.086 -0.26,0.13 -0.39,0.13 -0.043,0 -0.173,-0.043 -0.303,-0.173 -0.433,-0.26 -0.736,-0.693 -0.866,-1.342 -0.216,-0.866 -0.39,-1.386 -0.519,-1.602 -0.087,-0.173 -0.303,-0.347 -0.563,-0.477 -0.347,-0.173 -0.563,-0.303 -0.693,-0.39 -0.043,-0.043 -0.086,-0.086 -0.086,-0.173 -0.087,-0.173 0.043,-0.693 0.39,-1.472 0.086,-0.606 0,-1.212 -0.217,-1.818 -0.043,-0.087 -0.173,-0.303 -0.433,-0.606 l -0.649,-0.606 c -0.087,-0.086 -0.173,-0.303 -0.26,-0.649 -0.262,-0.95 -0.393,-1.47 -0.479,-1.556",
                        "Zaporizhia": "m 408.202,215.47 c -0.433,0.13 -0.736,0.173 -0.866,0.216 -0.39,0.173 -0.433,0.563 -0.13,1.126 0.13,0.346 0.39,0.692 0.693,0.952 0.26,0.303 0.563,0.693 0.952,1.256 0.13,0.173 0.26,0.39 0.39,0.606 0.259,0.433 0.39,0.952 0.476,1.515 0.043,0.606 -0.043,1.039 -0.217,1.299 -0.346,0.52 -0.433,1.212 -0.259,2.251 0.13,0.649 0,1.169 -0.39,1.646 -0.043,0.043 -0.043,0.086 -0.043,0.086 l -0.39,1.212 c 0.086,0.043 0.26,0.086 0.433,0.13 0,0 0.043,0 0.043,0.043 0.217,0.953 0.52,1.646 0.823,1.992 0.173,0.217 0.39,0.476 0.736,0.823 0.173,0.26 0.303,0.736 0.433,1.429 0.043,0.216 0.26,0.433 0.563,0.823 0.086,0.173 0.086,0.433 0,0.779 -0.086,0.346 -0.043,0.649 0.086,0.996 0.13,0.26 0.477,0.823 1.126,1.646 0.13,0.173 0.39,0.476 0.736,0.866 0.13,0.216 0.173,0.563 0.13,1.039 0,0.433 0.043,0.779 0.13,0.996 0.087,0.216 0.347,0.433 0.779,0.736 0.39,0.26 0.563,0.519 0.606,0.736 v 0.866 c 0,0.173 0.043,0.477 0.086,0.909 0.043,0.347 0,0.649 -0.13,0.823 -0.043,0.043 -0.26,0.173 -0.736,0.476 -0.39,0.217 -0.563,0.52 -0.519,0.91 0,0.303 0.173,0.822 0.519,1.515 -0.259,0.217 -0.563,0.087 -0.866,-0.346 -0.346,-0.52 -0.563,-0.779 -0.736,-0.779 0,0 -0.26,0.13 -0.736,0.433 -0.216,0.087 -0.563,0.173 -0.996,0.217 -0.433,0.043 -0.909,0.043 -1.516,0 -0.346,-0.086 -0.606,-0.173 -0.736,-0.173 -0.303,-0.043 -0.52,-0.043 -0.736,0.087 -0.087,0 -0.13,0.043 -0.13,0.086 -0.173,0.043 -0.26,0.26 -0.303,0.606 -0.043,0.303 -0.13,0.52 -0.173,0.563 -0.476,-0.043 -0.779,0 -0.953,0.086 -0.346,0.26 -0.563,0.477 -0.693,0.563 -0.433,0.39 -0.996,0.606 -1.602,0.606 -0.216,0 -0.606,-0.129 -1.082,-0.39 -0.476,-0.13 -0.779,-0.303 -0.953,-0.433 -0.433,-0.649 -0.779,-1.126 -0.953,-1.342 l -0.303,-0.346 c -0.087,-0.043 -0.26,-0.173 -0.563,-0.347 -0.477,-0.26 -0.866,-0.606 -1.212,-1.083 -0.303,-0.693 -0.649,-1.169 -1.039,-1.385 -0.26,-0.13 -0.563,-0.216 -0.953,-0.216 -0.39,-0.043 -0.693,-0.043 -0.823,-0.087 -0.13,-0.044 -0.433,-0.26 -0.866,-0.606 -0.39,-0.303 -0.693,-0.477 -0.866,-0.52 -0.043,0 -0.173,0.043 -0.433,0.13 -0.39,0.086 -0.693,0.216 -0.823,0.303 -0.563,0.303 -0.953,0.52 -1.169,0.563 -0.303,-0.043 -0.563,0.043 -0.736,0.173 -0.086,0.173 -0.173,0.26 -0.259,0.346 -0.347,0.433 -0.823,0.649 -1.386,0.779 -0.216,0 -0.779,-0.043 -1.602,-0.13 -0.606,-0.13 -1.039,-0.043 -1.342,0.216 -0.173,0.217 -0.346,0.477 -0.433,0.866 -0.173,0.433 -0.26,0.736 -0.347,0.866 -0.086,0.13 -0.476,0.477 -1.126,1.083 -0.259,0.216 -0.519,0.347 -0.692,0.433 h -0.173 c -0.13,-0.173 -0.173,-0.26 -0.216,-0.346 -0.086,-0.043 -0.217,-0.087 -0.39,-0.087 -0.13,0.043 -0.217,0.087 -0.346,0.13 0.129,0.52 0.26,1.039 0.433,1.646 0,0.086 0.217,0.649 0.563,1.688 0.086,0.216 0.173,0.606 0.303,1.125 0.086,0.26 0.216,0.606 0.39,1.083 l 0.043,0.866 c 0,0.086 0.043,0.173 0.13,0.26 0.39,0.13 0.78,-0.043 1.212,-0.52 0.043,0.043 0.217,0 0.433,-0.043 0.476,0.346 0.823,0.433 1.083,0.346 0.086,-0.043 0.173,-0.086 0.173,-0.13 0,-0.13 0.13,-0.39 0.39,-0.692 0.043,-0.087 0.087,-0.303 0.13,-0.736 0.26,-0.13 0.52,-0.216 0.693,-0.216 l 1.732,-0.173 c 0.087,0 0.216,0.086 0.39,0.26 l 0.043,0.173 c -0.043,0.086 -0.217,0.216 -0.477,0.303 -0.303,0.13 -0.476,0.217 -0.476,0.303 -0.26,0.823 -0.173,1.299 0.217,1.559 0.433,0.26 0.649,0.477 0.649,0.736 0,0.173 -0.087,0.346 -0.303,0.52 -0.173,0.13 -0.26,0.346 -0.217,0.563 l 0.217,1.04 c 0,0.086 0.043,0.173 0.086,0.303 0,0.39 0,0.996 -0.13,1.775 0.043,0.173 0.087,0.476 0.216,0.909 0,0.13 0,0.346 0.043,0.606 l 0.087,0.13 0.866,0.26 0.086,0.13 0.13,0.736 c 0.043,0.173 0.13,0.476 0.26,0.866 l 0.087,0.606 c 0.043,0.173 0.043,0.563 0.043,1.169 -0.043,0.52 0.043,0.866 0.217,1.083 0.13,0.043 0.346,0.043 0.649,0.043 0.26,0.13 0.433,0.477 0.433,1.04 0.043,0.52 0.087,0.822 0.217,0.909 0.606,0.043 0.996,0.173 1.212,0.346 0.26,0.26 0.477,0.433 0.563,0.433 0.996,0.346 1.602,0.563 1.775,0.779 0.173,1.212 0.346,1.948 0.606,2.122 0.087,0.086 0.303,0.086 0.693,0.086 0.303,0.043 0.563,0.347 0.649,0.953 0.13,0.52 0.13,0.823 0.086,0.996 -0.606,0.303 -0.952,0.477 -0.996,0.477 -0.346,0.13 -0.52,0.216 -0.52,0.216 -0.13,0.303 -0.13,0.736 -0.043,1.342 0,0.043 -0.13,0.303 -0.433,0.693 -0.086,0.476 -0.216,0.779 -0.389,0.996 -0.26,0.086 -0.477,0.173 -0.606,0.347 -0.173,0.39 -0.303,0.606 -0.39,0.649 -0.086,0.043 -0.433,0.043 -0.953,0.043 -0.346,0 -0.606,0.13 -0.736,0.433 0,0.693 0.043,1.125 0.173,1.256 0.216,0.173 0.519,0.086 0.822,-0.173 h 0.173 c 0.087,0.043 0.173,0.216 0.303,0.52 0.043,0.043 0.476,0.13 1.342,0.26 0.217,0 0.347,0.13 0.39,0.346 0.303,0.736 0.346,1.255 0.216,1.559 0,0.043 -0.13,0.217 -0.433,0.563 -0.173,0.26 -0.26,0.433 -0.173,0.649 0.13,0.476 0.39,0.866 0.649,1.083 0.043,0.13 0.13,0.303 0.26,0.52 0.086,0.173 0.216,0.433 0.303,0.823 0.043,0.043 0.347,0.043 0.91,0 0.173,-0.043 0.563,-0.043 1.168,0 0.606,0.043 0.953,0.13 1.039,0.216 l 0.087,0.13 c -0.043,0.303 -0.216,0.563 -0.52,0.736 -0.043,0.043 -0.043,0.216 -0.043,0.476 0,0.216 0.043,0.39 0.086,0.476 0.173,0.087 0.52,0.043 1.082,-0.043 0.52,-0.087 0.823,-0.13 0.953,-0.043 0.086,0.043 0.303,0.26 0.52,0.649 0.216,0.173 0.477,0.26 0.823,0.26 0.13,0.043 0.346,0.216 0.606,0.433 0.779,0 1.212,0.043 1.299,0.086 0.043,0.173 0.173,0.823 0.39,1.949 0,0.086 0.043,0.259 0.043,0.476 0.26,0.909 0.39,1.429 0.39,1.515 0,0.217 -0.129,0.606 -0.303,1.083 0,0.433 0.087,1.083 0.26,1.992 -0.043,0.303 0,0.52 0.13,0.563 0.13,0.086 0.563,0.13 1.299,0.13 0.346,-0.346 0.563,-0.563 0.606,-0.606 0.217,-0.389 0.52,-0.996 0.866,-1.775 0.086,-0.173 0.303,-0.39 0.606,-0.649 0.52,-0.606 0.866,-1.169 1.039,-1.646 0.087,-0.26 0.087,-0.52 0,-0.779 -0.173,-0.303 -0.26,-0.52 -0.346,-0.693 -0.087,-0.39 -0.173,-0.606 -0.26,-0.692 l -0.433,-0.39 c -0.39,-0.346 -0.476,-0.866 -0.216,-1.558 0.13,-0.433 0.346,-0.65 0.563,-0.606 0,0.736 0.043,1.212 0.217,1.429 0.086,0.086 0.26,0.173 0.476,0.346 l 0.173,0.217 c 0.043,0 0.086,0.13 0.216,0.346 0.13,0.26 0.26,0.433 0.347,0.476 0.26,0.13 0.693,0.217 1.212,0.26 l 0.13,0.086 v 0.173 c -0.087,0.173 -0.303,0.476 -0.606,0.866 -0.043,0.087 -0.043,0.217 0,0.39 0.086,0.477 0.13,0.953 0.086,1.429 0,0.129 -0.043,0.346 -0.086,0.692 0,0.13 0.043,0.303 0.13,0.433 0.043,0.086 0.13,0.13 0.217,0.216 0.173,0.043 0.39,0.13 0.692,0.216 0.13,0.087 0.217,0.13 0.26,0.173 h 0.173 c 0.13,-0.086 0.39,-0.433 0.823,-1.039 h 0.173 c 0.087,0.13 0.087,0.347 -0.043,0.693 -0.303,0.822 -0.823,1.429 -1.516,1.775 -0.13,0.173 -0.173,0.347 -0.173,0.563 0,0.26 -0.043,0.476 -0.087,0.563 -0.043,0.13 -0.216,0.346 -0.52,0.649 -0.13,0.13 -0.216,0.303 -0.26,0.476 -0.173,0.433 -0.52,0.996 -1.039,1.646 -0.173,0.39 -0.303,0.693 -0.39,0.866 -0.173,0.303 -0.347,0.563 -0.606,0.736 -0.086,0.13 -0.606,0.303 -1.429,0.563 -1.775,0.606 -2.728,0.953 -2.901,1.169 l -0.043,0.13 c 0.173,0.216 0.259,0.346 0.303,0.346 -0.173,0.13 -0.346,0.26 -0.563,0.303 -0.26,0.086 -0.477,0.173 -0.606,0.26 -0.043,0.26 -0.13,0.433 -0.173,0.476 0,0.043 -0.086,0.086 -0.173,0.13 -0.043,0 -0.26,0.13 -0.606,0.433 -0.043,0.13 -0.043,0.26 -0.043,0.39 0.13,0.173 0.303,0.303 0.649,0.346 0.216,-0.086 0.563,-0.26 0.953,-0.52 0.13,-0.086 0.303,-0.13 0.563,-0.216 l 0.303,-0.217 c 0.39,-0.216 0.996,-0.476 1.818,-0.779 1.083,-0.606 1.905,-1.429 2.468,-2.425 l 2.251,-3.983 c 0.043,-0.13 0.173,-0.303 0.346,-0.477 0.086,-0.129 0.303,-0.476 0.649,-1.082 1.342,-2.251 2.035,-3.42 2.122,-3.464 0.303,-0.39 0.866,-0.909 1.688,-1.559 0.13,-0.13 0.347,-0.476 0.649,-0.996 0.26,-0.476 0.52,-0.779 0.736,-0.952 l -0.693,-0.433 c -0.086,0.13 -0.303,0.26 -0.563,0.346 -0.347,0.13 -0.52,0.26 -0.649,0.39 -0.216,0.217 -0.52,0.693 -0.866,1.386 -0.13,0.216 -0.173,0.39 -0.26,0.476 -0.216,0.26 -0.389,0.433 -0.476,0.52 l -0.173,0.043 -0.129,-0.043 c -0.087,-0.13 -0.087,-0.303 0.043,-0.606 0.086,-0.26 0.086,-0.477 0,-0.563 -0.649,-0.736 -1.039,-1.212 -1.212,-1.429 -0.086,-0.173 -0.086,-0.346 -0.043,-0.563 0,-0.303 0.043,-0.52 0.043,-0.606 -0.216,-0.303 -0.346,-0.476 -0.39,-0.606 0,-0.043 -0.086,-0.303 -0.216,-0.736 -0.13,-0.52 -0.173,-0.779 -0.173,-0.823 0.13,-0.39 0.173,-0.692 0.13,-0.823 -0.173,-0.173 -0.303,-0.303 -0.346,-0.433 -0.216,-0.433 -0.216,-0.953 -0.086,-1.472 0.26,-0.346 0.389,-0.606 0.346,-0.779 -0.303,-0.347 -0.52,-0.606 -0.563,-0.779 l -0.043,-0.347 c 0.087,-0.779 0.13,-1.169 0.13,-1.212 0,-0.043 0,-0.13 0.043,-0.217 0.043,-0.13 0.173,-0.26 0.39,-0.433 0.086,0 0.26,-0.043 0.433,-0.043 0.13,-0.043 0.303,-0.13 0.52,-0.26 h 0.13 l 0.043,0.13 -0.043,0.173 0.043,0.043 c -0.217,0.39 -0.13,0.866 0.216,1.429 0.39,0.606 0.606,1.039 0.606,1.169 0,0.26 -0.173,0.693 -0.433,1.342 -0.043,0.347 0.13,0.78 0.433,1.386 0,0.13 -0.043,0.39 -0.173,0.736 0.086,0.173 0.26,0.433 0.476,0.693 0.043,0.043 0.13,0.13 0.216,0.216 0,0.13 0.043,0.26 0.13,0.433 0,0.216 -0.043,0.476 -0.087,0.909 0.087,0.13 0.346,0.26 0.823,0.433 0.13,0.086 0.26,0.26 0.39,0.433 0.346,0.173 0.606,0.173 0.823,0.086 0.173,-0.13 0.39,-0.39 0.563,-0.779 0.13,-0.39 0.26,-0.606 0.39,-0.606 l 0.087,0.043 c -0.087,0.477 -0.26,0.909 -0.52,1.342 l 0.693,0.433 c 0.129,-0.087 0.563,-0.26 1.342,-0.433 0.303,-0.086 0.649,-0.216 1.083,-0.476 0.996,-0.606 1.516,-0.91 1.559,-0.91 0.043,-0.086 0.129,-0.173 0.216,-0.26 0.346,-0.173 0.649,-0.52 0.996,-0.996 0.217,-0.39 0.39,-0.693 0.52,-0.779 l 0.39,-0.476 c 0.779,-0.996 1.256,-1.602 1.472,-1.819 0.173,-0.173 0.346,-0.346 0.563,-0.433 0.086,-0.086 0.26,-0.173 0.476,-0.216 0.173,-0.13 0.347,-0.346 0.606,-0.649 0.26,-0.173 0.649,-0.346 1.169,-0.563 l 0.649,-0.303 c 0.26,-0.13 0.649,-0.347 1.212,-0.693 0,0 0.346,0 0.952,0 0.043,0 0.477,-0.043 1.256,-0.173 0.216,0 0.52,-0.043 0.953,0 0.173,-0.043 0.39,-0.13 0.736,-0.303 l 0.043,-0.043 c 0.346,-0.173 0.606,-0.303 0.822,-0.303 0.043,-0.043 0.26,0.087 0.693,0.303 0.39,0.173 0.78,0.303 1.083,0.303 0.086,0 0.52,-0.129 1.255,-0.389 0.477,-0.173 0.91,-0.13 1.256,0.173 l 0.086,0.173 c 0.087,0.13 0.217,0.303 0.303,0.606 0.086,0.087 0.217,0.217 0.39,0.433 0,0.043 0.043,0.173 0.087,0.26 0,0.26 0,0.606 -0.043,1.039 l 0.173,0.043 c 0.043,-0.043 0.086,-0.173 0.173,-0.39 0.043,-0.26 0.13,-0.433 0.26,-0.52 l 0.13,-0.043 0.13,0.086 c 0,0 0,0.303 -0.086,0.866 l 0.13,0.043 c 0.173,-0.346 0.346,-0.822 0.433,-1.515 0.26,-0.39 0.476,-0.736 0.692,-0.996 0.52,-0.563 0.78,-0.866 0.823,-0.91 0.086,-0.129 0.13,-0.216 0.173,-0.26 0.216,-0.303 0.346,-0.519 0.476,-0.563 0.606,-0.563 1.212,-0.953 1.818,-1.212 0.13,-0.043 0.347,-0.13 0.606,-0.217 0.216,-0.043 0.476,-0.13 0.779,-0.216 0.26,-0.13 0.823,-0.433 1.602,-0.866 0.13,-0.043 0.39,-0.043 0.866,0.043 h 0.043 c 0.433,0.087 0.736,0.087 0.909,0 0.173,-0.086 0.39,-0.303 0.52,-0.693 0.086,-0.086 0.173,-0.173 0.346,-0.259 h 0.043 c 0.086,0.043 0.217,0.043 0.477,0.086 h 0.043 c 0.087,0.043 0.26,0.086 0.477,0.216 0.043,0 0.346,-0.043 0.866,-0.13 0.476,-0.086 0.909,-0.043 1.212,0.043 0.649,0.216 1.212,0.649 1.688,1.299 0.086,0.13 0.26,0.303 0.52,0.52 0.433,0.693 0.433,1.559 0,2.555 -0.086,0.13 -0.173,0.303 -0.346,0.563 -0.043,0.433 -0.173,0.779 -0.303,0.952 -0.13,0.087 -0.26,0.087 -0.433,-0.043 -0.173,-0.13 -0.303,-0.217 -0.346,-0.217 0.086,0.303 0.216,0.476 0.476,0.606 0.217,0.086 0.39,0.043 0.52,-0.087 0.13,-0.13 0.606,-1.299 1.342,-3.42 0.13,-0.476 0.216,-0.866 0.303,-1.083 0.563,-0.909 0.866,-1.602 0.909,-2.035 -0.216,-0.26 -0.303,-0.476 -0.26,-0.649 l 0.086,-0.13 c 0.13,-0.087 0.39,-0.13 0.779,-0.087 0.217,-0.086 0.606,-0.52 1.039,-1.299 0.303,-0.216 0.693,-0.39 1.169,-0.476 0.259,-0.173 0.563,-0.433 0.996,-0.823 0.173,-0.086 0.433,-0.216 0.736,-0.346 0.173,-0.087 0.346,-0.217 0.606,-0.39 l -0.823,-1.688 c -0.13,-0.26 -0.173,-0.433 -0.13,-0.563 0.477,-0.606 0.779,-0.953 0.866,-0.996 0.26,-0.303 0.389,-0.433 0.389,-0.433 0.13,-0.043 0.26,-0.13 0.347,-0.26 0.173,0 0.433,0.086 0.736,0.39 h 0.173 c 0.52,-0.39 0.823,-0.65 0.866,-0.736 -0.043,-0.216 -0.173,-0.433 -0.39,-0.692 -0.259,-0.303 -0.39,-0.52 -0.433,-0.65 0.043,-0.13 0.216,-0.303 0.52,-0.606 0.26,-0.216 0.39,-0.39 0.346,-0.52 -0.433,-0.346 -0.736,-0.606 -0.953,-0.779 -0.26,-0.303 -0.476,-0.52 -0.563,-0.649 l -0.13,-0.043 c -0.217,0.217 -0.347,0.477 -0.39,0.693 h -0.13 c -0.259,-0.303 -0.649,-0.649 -1.255,-1.039 -0.173,-0.736 -0.303,-1.169 -0.303,-1.299 -0.303,-0.822 -0.563,-1.429 -0.866,-1.818 -0.216,-0.26 -0.693,-0.563 -1.386,-0.866 -0.563,-0.216 -0.822,-0.303 -0.822,-0.303 l -0.433,-0.433 c -0.39,-0.433 -0.649,-0.692 -0.736,-0.866 l 0.086,-0.173 c 0.086,-0.129 0.52,-0.173 1.212,-0.173 0.649,0 1.039,-0.13 1.255,-0.347 0.087,-0.216 0.087,-0.649 -0.043,-1.299 -0.087,-0.606 -0.173,-1.039 -0.303,-1.299 -0.217,-0.303 -0.39,-0.52 -0.477,-0.606 -0.173,-0.217 -0.129,-0.477 0.043,-0.736 0.13,-0.216 0.39,-0.346 0.693,-0.39 l 0.26,0.347 c 0.173,0.043 0.346,0.043 0.649,0 0.043,0.043 0.13,0.129 0.13,0.26 0.087,0.086 0.346,0.173 0.823,0.216 0.433,0.043 0.736,0.043 0.866,0 0.693,-0.13 1.126,-0.303 1.342,-0.52 v -0.866 c 0.216,-0.476 0.39,-0.822 0.476,-1.039 0.13,-0.39 0.173,-0.649 0.26,-0.822 0.086,-0.26 0.303,-0.433 0.606,-0.52 0.52,-0.043 0.952,0.39 1.299,1.256 0.346,-0.217 0.606,-0.346 0.693,-0.433 -0.087,-0.303 -0.087,-0.52 -0.13,-0.649 -0.13,-0.736 0.043,-1.342 0.52,-1.732 -0.043,-0.39 -0.043,-0.649 -0.043,-0.779 0.477,-0.649 0.736,-1.125 0.736,-1.515 l -0.13,-0.087 c -0.303,0.087 -0.563,0.13 -0.736,0.13 -0.563,-0.174 -1.039,-0.26 -1.429,-0.26 l -0.086,0.13 -0.043,0.303 c -0.13,0.173 -0.26,0.26 -0.347,0.26 l -0.173,-0.043 c -0.043,-0.13 -0.086,-0.216 -0.13,-0.26 -0.433,-0.736 -0.693,-1.125 -0.779,-1.212 -0.39,-0.26 -0.693,-0.477 -0.909,-0.606 -0.217,-0.346 -0.433,-0.563 -0.563,-0.649 -0.303,-0.216 -0.52,-0.39 -0.606,-0.476 -0.39,-0.693 -0.693,-1.126 -0.91,-1.299 -0.476,-0.043 -0.909,-0.39 -1.299,-1.083 h -0.173 c -0.433,0.216 -0.779,0.433 -1.039,0.736 -0.347,0.303 -0.563,0.433 -0.693,0.433 -0.693,-0.866 -1.169,-1.516 -1.429,-1.948 l -0.39,-0.65 c -0.129,-0.129 -0.216,-0.216 -0.346,-0.303 -0.909,0.563 -1.472,0.736 -1.775,0.649 l -0.129,-0.086 c 0,-0.217 0,-0.477 0.129,-0.91 0.087,-0.346 0.13,-0.563 0.043,-0.649 -0.13,-0.086 -0.303,-0.086 -0.606,-0.043 -0.173,-0.043 -0.347,-0.39 -0.563,-0.996 0.043,-0.043 0.433,-0.216 1.083,-0.39 0.043,-0.043 0.043,-0.13 0.043,-0.26 -0.779,-0.13 -1.212,-0.26 -1.385,-0.433 -0.086,-0.13 -0.216,-0.433 -0.303,-0.91 -0.129,-0.519 -0.26,-0.822 -0.39,-0.996 l -0.52,-0.52 c -0.086,-1.385 -0.173,-2.165 -0.346,-2.295 -0.433,0.13 -0.693,0.173 -0.866,0.217 -0.736,0.086 -1.213,-0.087 -1.472,-0.606 -0.043,-0.086 -0.087,-0.13 -0.043,-0.216 0.303,-0.909 0.346,-1.515 0.173,-1.732 -1.126,0.13 -1.992,0.303 -2.555,0.39 -0.606,0.13 -1.083,0.26 -1.429,0.346 -0.043,0 -0.086,0 -0.13,0 -0.649,0 -1.083,0.043 -1.429,0.13 -0.043,-0.043 -0.173,-0.217 -0.303,-0.477 -0.087,-0.173 -0.303,-0.216 -0.693,-0.216 -0.26,0.043 -0.476,0.13 -0.649,0.303 -0.086,0.39 -0.173,0.693 -0.303,0.823 l -0.866,0.173 c -0.346,0 -0.649,-0.087 -0.866,-0.303 -0.26,-0.26 -0.433,-0.39 -0.52,-0.433 -0.563,0 -0.91,-0.043 -0.996,-0.086 -0.043,-0.216 -0.043,-0.346 -0.043,-0.476 -0.043,-0.217 -0.043,-0.52 -0.13,-0.953 l -0.086,-0.086 c -0.476,-0.043 -0.779,0 -0.953,0.086 -0.086,0.52 -0.216,0.866 -0.346,0.996 -0.433,0.216 -1.039,0.303 -1.905,0.216 l -0.086,-0.13 v -0.173 c -0.13,-0.13 -0.303,-0.173 -0.52,-0.13 -0.043,-0.13 -0.043,-0.26 0,-0.476 l -0.086,-0.13 -0.347,-0.129 c -0.043,0 -0.043,-0.26 -0.043,-0.736 0.173,-0.086 0.346,0.043 0.563,0.303 0.217,0.216 0.39,0.303 0.52,0.173 l 0.087,-0.173 c 0.13,-0.563 0.303,-1.126 0.563,-1.732 0.043,-0.043 0,-0.173 -0.087,-0.39 -0.086,-0.26 -0.043,-0.52 0.087,-0.823 l -0.043,-0.13 c -0.303,0 -0.52,0 -0.606,0.087 -0.13,0.173 -0.26,0.26 -0.303,0.26 -0.043,0 -0.087,-0.13 -0.217,-0.477 -0.086,-0.26 -0.303,-0.346 -0.649,-0.303 0.043,-0.173 0.043,-0.303 0.043,-0.39 0.086,-0.692 0.043,-1.255 -0.173,-1.688 -0.043,-0.086 -0.216,-0.13 -0.52,-0.173 -0.26,0 -0.39,-0.087 -0.476,-0.13 0,-0.216 0.13,-0.476 0.433,-0.779 0.26,-0.303 0.433,-0.563 0.433,-0.736 -0.043,-0.216 -0.086,-0.346 -0.173,-0.433 -0.129,0 -0.216,0 -0.303,0.043 -0.823,0.823 -1.386,1.125 -1.732,0.953 -0.043,-0.216 -0.086,-0.477 0,-0.866 -0.217,-0.303 -0.217,-0.823 -0.043,-1.645 0.043,-0.26 -0.13,-0.433 -0.563,-0.433 -0.736,-0.086 -1.731,0.216 -2.857,0.779 -0.173,0.086 -0.346,0.173 -0.52,0.303 -0.26,0.13 -0.433,0.216 -0.476,0.26 -0.26,-0.043 -0.433,-0.26 -0.649,-0.649 -0.217,-0.39 -0.39,-0.649 -0.563,-0.649 -1.083,-0.217 -1.602,-0.303 -1.646,-0.346 -0.433,-0.563 -0.736,-0.953 -0.866,-1.083 -0.26,-0.26 -0.736,-0.303 -1.472,-0.13 -0.953,0.26 -1.732,0.563 -2.251,0.996 -0.216,0.52 -0.433,0.779 -0.649,0.823 -0.606,0.216 -1.039,0.216 -1.385,0.043 -0.087,-0.087 -0.217,-0.13 -0.26,-0.13 -0.779,-0.173 -1.386,-0.303 -1.775,-0.39 -1.602,-0.173 -2.555,-0.26 -2.771,-0.39 -0.216,-0.086 -0.823,-0.433 -1.905,-0.996 -0.173,-0.13 -0.39,-0.173 -0.65,-0.173 l -0.216,-0.043 -1.646,0.303 c -0.13,0.043 -0.216,0.087 -0.259,0.087 -0.087,0.043 -0.173,0.043 -0.303,0.086 h -0.043 -0.173 c -0.216,0 -0.52,0 -0.822,0 l -0.347,-0.043 c -0.602,-0.09 -0.991,-0.134 -1.078,-0.09 m -6.408,0.13 -0.087,-0.13 c -0.563,-0.043 -0.909,0 -1.082,0.13 -0.086,0.26 -0.043,0.563 0.13,0.953 0.043,0.216 0.173,0.52 0.303,0.909 0,0.086 -0.043,0.173 -0.129,0.346 -0.043,1.039 -0.13,1.602 -0.217,1.688 l -0.563,0.173 -0.087,0.086 c -0.043,0.39 0,0.606 0.13,0.779 h 0.649 l 0.13,0.043 c 0.086,0.693 0.13,1.083 0.173,1.083 0.13,0.216 0.563,0.433 1.299,0.563 0.563,0.13 0.779,0.476 0.693,1.039 -0.087,0.39 -0.13,0.649 -0.216,0.736 -0.693,0.043 -1.299,0.13 -1.819,0.303 -0.216,0.346 -0.346,0.52 -0.433,0.649 l -0.346,0.043 c -0.216,0.13 -0.346,0.433 -0.39,0.866 -0.043,0.39 0,0.649 0.13,0.866 0.043,0.043 0.303,0.216 0.736,0.563 0.259,0.13 0.736,0.433 1.472,0.78 0.173,0.086 0.346,0.216 0.519,0.476 0,0.26 -0.173,0.649 -0.563,1.169 0,0.086 0.043,0.39 0.173,0.909 0,0.086 -0.043,0.26 -0.129,0.606 0,0.173 -0.043,0.26 -0.087,0.39 l 0.043,0.087 0.736,0.216 c 0.217,0.043 0.563,0.13 1.039,0.217 0,0.779 -0.086,1.559 -0.346,2.468 -0.043,0.13 -0.13,0.346 -0.26,0.649 -0.086,0.476 -0.216,1.125 -0.39,2.078 l -0.52,1.472 v 0.173 c 0.606,0.389 0.909,0.692 0.996,0.866 0.043,0.087 0.043,0.433 -0.043,0.909 0,0.173 -0.043,0.26 -0.086,0.39 0.996,-0.043 1.602,-0.13 1.862,-0.26 0.433,-0.216 0.953,-0.952 1.646,-2.251 0.13,-0.26 0.216,-0.476 0.303,-0.563 0.173,-0.216 0.52,-0.476 1.039,-0.779 0.043,-0.043 0.13,-0.26 0.217,-0.692 0.173,-0.736 0.303,-1.212 0.39,-1.342 0,-0.043 0,-0.086 0.043,-0.086 0.303,-0.52 0.477,-0.953 0.563,-1.342 0.086,-0.26 0.13,-0.649 0.086,-1.212 -0.043,-0.649 -0.259,-1.256 -0.649,-1.948 -0.216,-0.347 -0.476,-0.693 -0.779,-1.04 -0.173,-0.303 -0.303,-0.476 -0.389,-0.606 l -0.087,-0.433 c -0.043,-0.173 0.043,-0.39 0.216,-0.606 0.173,-0.26 0.303,-0.346 0.477,-0.346 0.043,0 0.086,0 0.13,0 l 0.39,-1.212 c 0,0 0,-0.043 0.043,-0.086 0.39,-0.477 0.52,-0.996 0.39,-1.646 -0.173,-1.039 -0.087,-1.732 0.259,-2.251 0.173,-0.26 0.26,-0.693 0.217,-1.299 -0.086,-0.563 -0.217,-1.083 -0.476,-1.515 -0.13,-0.217 -0.26,-0.433 -0.39,-0.606 -0.39,-0.563 -0.692,-0.953 -0.952,-1.256 -0.303,-0.26 -0.563,-0.606 -0.693,-0.952 -0.303,-0.563 -0.26,-0.953 0.13,-1.126 0.13,-0.043 0.433,-0.086 0.866,-0.216 -0.519,0.13 -0.866,0.173 -1.039,0.216 -0.39,0 -0.736,-0.043 -1.039,-0.173 -0.736,0.952 -1.169,1.472 -1.385,1.645 -0.173,0.13 -0.996,0.173 -2.511,0.216 -0.087,-0.043 -0.217,-0.043 -0.346,-0.129 -0.134,-0.695 -0.177,-1.215 -0.09,-1.647",
                        "Zakarpattia": "m 37.538,173.039 c -0.043,0.086 -0.087,0.216 -0.087,0.346 l -0.087,0.866 c 0,0.477 -0.043,0.779 -0.13,0.866 l -0.216,0.173 c -0.13,0.347 -0.13,0.78 -0.043,1.299 -0.086,0.26 -0.39,0.346 -0.909,0.39 -0.563,0 -0.996,0.173 -1.212,0.52 -0.13,0.173 -0.173,0.606 -0.173,1.299 -0.043,0.173 -0.173,0.346 -0.433,0.563 -0.26,0.173 -0.39,0.303 -0.39,0.433 -0.043,0.087 0,0.347 0,0.693 0.043,0.303 0,0.52 -0.087,0.736 -0.087,0.13 -0.303,0.39 -0.736,0.823 -0.476,0.433 -0.779,0.779 -0.866,1.083 -0.043,0.13 0.043,0.52 0.173,1.169 0.13,0.693 0.216,1.083 0.216,1.256 -0.043,0.173 -0.303,0.52 -0.779,0.909 -0.39,0.39 -0.606,0.779 -0.476,1.169 0.087,0.606 0,1.255 -0.26,2.035 -0.086,0.173 -0.216,0.476 -0.346,0.909 -0.173,0.26 -0.52,0.476 -1.039,0.692 -0.563,0.173 -0.909,0.39 -1.082,0.649 -0.217,0.347 -0.476,0.91 -0.823,1.646 -0.13,0.173 -0.39,0.303 -0.736,0.476 -0.13,0.043 -0.26,0.173 -0.476,0.347 -0.52,0.39 -0.823,0.692 -0.866,0.953 v 0.216 c -0.043,0.216 0,0.476 0.086,0.823 0,0.216 0,0.476 -0.043,0.866 l 0.043,0.303 c 0.043,0.13 0.173,0.346 0.346,0.693 0.043,0.13 -0.043,0.303 -0.26,0.476 -0.043,0.043 -0.13,0.13 -0.26,0.216 0,0.26 -0.043,0.606 -0.087,1.126 0,0.173 0.043,0.433 0.087,0.822 0.087,0.866 0.043,1.429 -0.087,1.775 l 0.563,0.173 c 0.39,-0.173 0.823,-0.347 1.299,-0.477 0.26,0.043 0.52,0.173 0.693,0.347 0.13,0.043 0.39,0.086 0.693,0.086 l 0.26,0.303 -0.043,0.303 -0.303,0.303 c -0.13,0.52 -0.13,0.909 0.087,1.212 l 0.13,0.043 c 0.823,-0.173 1.342,-0.259 1.515,-0.173 l 0.087,0.086 c 0.043,0.173 0,0.433 -0.087,0.91 -0.087,0.346 -0.087,0.736 0.087,1.212 0.043,0.173 0.173,0.39 0.39,0.606 0.13,0.52 0.303,0.909 0.433,1.125 0.217,0.26 0.39,0.39 0.52,0.52 0.173,0.173 0.26,0.346 0.346,0.606 0,0.086 0.043,0.129 0.087,0.173 0.173,0.173 0.433,0.087 0.779,-0.173 0,-0.087 0.173,-0.087 0.52,0 0.563,0.173 0.866,0.26 0.909,0.26 0.216,0.043 0.52,-0.087 0.866,-0.26 0.173,-0.087 0.346,-0.087 0.52,0 0.13,0.129 0.346,0.476 0.693,1.082 0.303,0.563 0.563,0.953 0.736,1.083 0.346,0.086 0.563,0.13 0.693,0.173 0.13,0.086 0.173,0.216 0.043,0.433 -0.13,0.216 -0.173,0.39 -0.173,0.433 l 0.087,0.087 c 0.13,0.13 0.26,0.216 0.346,0.259 0.303,0.477 0.433,0.823 0.476,1.126 0,0.13 0,0.26 -0.043,0.433 0,0.086 0.043,0.173 0.13,0.26 0.043,0.13 0.043,0.303 0,0.606 0.13,0.303 0.346,0.52 0.736,0.649 0.693,0.39 1.212,0.477 1.602,0.26 0.217,-0.129 0.39,-0.216 0.476,-0.26 0.39,-0.173 0.693,-0.26 0.866,-0.39 0.303,-0.173 0.476,-0.26 0.519,-0.26 0.26,0.173 0.433,0.26 0.52,0.303 l 0.173,-0.043 c 0.13,-0.13 0.26,-0.216 0.346,-0.26 0.217,-0.173 0.563,0.043 1.126,0.649 0.26,0.26 0.476,0.477 0.606,0.649 l 0.217,0.043 c 0.26,0.477 0.476,0.866 0.649,1.126 0.217,0.26 0.39,0.476 0.476,0.563 0.13,0.217 0.173,0.477 0.087,0.823 -0.087,0.216 -0.173,0.346 -0.217,0.39 -0.087,0.086 -0.173,0.13 -0.346,0.26 l -0.043,0.13 c 0.043,0.13 0.087,0.26 0.087,0.433 -0.043,0.13 -0.217,0.346 -0.433,0.476 -0.13,0.173 -0.13,0.39 0,0.736 0.13,0.13 0.217,0.216 0.303,0.26 0.346,0.086 0.519,0.173 0.519,0.173 0.174,0.217 0.347,0.347 0.433,0.433 0.043,0 0.303,-0.086 0.823,-0.216 0.26,-0.086 0.433,-0.303 0.52,-0.649 l 0.043,-0.52 c -0.13,-0.303 -0.217,-0.52 -0.26,-0.649 -0.043,-0.217 -0.043,-0.347 0,-0.39 0.217,-0.259 0.476,-0.303 0.866,-0.086 0.39,0.217 0.693,0.39 0.823,0.477 0,0 0.173,0.13 0.52,0.303 0.043,0.043 0.13,0.043 0.303,0.13 0.303,0.086 0.65,-0.086 1.039,-0.433 0.606,-0.303 0.953,-0.52 1.083,-0.693 0.173,-0.303 0.39,-0.866 0.606,-1.732 0.216,-0.996 0.346,-1.516 0.39,-1.516 0.043,-0.086 0.216,-0.26 0.433,-0.476 0.26,-0.216 0.563,-0.39 0.866,-0.39 0.26,-0.043 0.563,0.086 0.909,0.346 0.346,0.303 0.693,0.477 0.866,0.52 0.346,-0.086 0.649,-0.13 0.823,-0.13 0.13,0.043 0.26,0.173 0.433,0.39 0.087,0.086 0.173,0.129 0.173,0.216 0.217,0.649 0.39,1.169 0.563,1.385 0.823,0.477 1.385,0.823 1.688,1.083 0.346,0.476 0.606,0.779 0.779,0.996 0.087,0.086 0.26,0.13 0.52,0.086 0.303,-0.086 0.476,-0.13 0.52,-0.086 0.173,0 0.563,0.173 1.212,0.519 0.433,0.26 0.693,0.433 0.736,0.477 0.476,0.13 0.823,-0.043 1.039,-0.477 0.043,-0.216 0.086,-0.433 0.216,-0.519 0.346,-0.13 0.563,-0.303 0.693,-0.477 l 0.606,0.477 c 0.26,0.173 0.606,0.303 1.082,0.216 0.52,0 0.909,0 1.126,0.086 0.39,0.303 0.65,0.433 0.823,0.39 l -0.043,0.043 c 0.173,0.043 0.346,0.043 0.606,0 0.39,0 0.606,-0.043 0.649,-0.043 0.39,0.043 0.693,0.087 0.909,0.087 0.433,-0.13 0.823,-0.087 1.169,0.043 0.043,0 0.39,0.173 0.952,0.52 0.346,0.13 0.52,0.26 0.563,0.303 0.13,0.13 0.217,0.346 0.26,0.649 0.087,0.303 0.13,0.52 0.217,0.606 0.13,0.173 0.346,0.26 0.736,0.26 0.346,0 0.606,-0.043 0.736,-0.217 0.303,-0.26 0.519,-0.433 0.649,-0.433 l 0.13,0.087 c 0.26,-0.043 0.39,-0.13 0.52,-0.26 0.13,-0.216 0.217,-0.303 0.303,-0.347 l 0.563,-0.303 c 0.216,0.086 0.39,0.13 0.519,0.13 0.78,0.043 1.299,0.086 1.515,0.173 0.477,0.347 0.866,0.606 1.169,0.693 0.217,0.043 0.39,0.087 0.433,0.173 0.086,0.043 0.173,0.173 0.26,0.39 0.303,0.433 0.736,0.736 1.342,0.736 0.173,0 0.303,-0.043 0.433,-0.173 0.173,-0.13 0.26,-0.26 0.216,-0.39 0.173,0.043 0.26,0.13 0.347,0.173 0.909,0.606 1.602,0.823 2.035,0.649 l 0.173,-0.086 c 0.13,-0.13 0.433,-0.303 0.866,-0.606 0.39,-0.217 0.606,-0.303 0.736,-0.347 0.217,-0.043 0.52,-0.043 0.953,0.043 0.39,0.086 0.693,0.086 0.866,-0.086 0.173,-0.087 0.39,-0.303 0.606,-0.65 0.13,-0.303 0.433,-0.52 0.909,-0.649 0.347,-0.129 0.779,-0.086 1.342,0.087 0.649,0.173 1.083,0.303 1.256,0.303 0.303,-0.303 0.866,-0.303 1.732,-0.043 l 0.043,-0.13 0.13,-0.606 c 0.087,-0.52 0.433,-1.212 0.996,-2.121 0.217,-0.433 0.39,-0.736 0.52,-0.91 0.26,-0.303 0.476,-0.52 0.563,-0.692 l -0.043,-0.173 c -1.256,-1.559 -2.035,-2.468 -2.295,-2.728 -1.212,-1.125 -1.602,-2.078 -1.169,-2.9 0.39,-0.693 0.563,-1.039 0.563,-1.126 -0.217,-0.39 -0.39,-0.649 -0.433,-0.736 0,-0.086 -0.043,-0.129 -0.043,-0.173 -0.216,-0.216 -0.346,-0.433 -0.39,-0.606 l -0.433,-0.91 -2.079,-1.992 c -0.173,-0.173 -0.476,-0.39 -0.823,-0.606 -0.129,-0.13 -0.303,-0.346 -0.563,-0.736 -0.477,-0.043 -0.866,-0.043 -1.126,0 -0.043,-0.087 -0.043,-0.347 -0.043,-0.693 0.043,-0.347 0,-0.606 -0.173,-0.823 -0.086,-0.13 -0.303,-0.26 -0.563,-0.433 -0.303,-0.26 -0.433,-0.39 -0.433,-0.39 l -0.13,0.043 c -0.173,0.173 -0.346,0.606 -0.649,1.212 -0.303,0.346 -0.909,0.476 -1.861,0.476 -0.779,-0.043 -1.386,-0.173 -1.732,-0.476 -0.303,-0.347 -0.563,-0.866 -0.649,-1.688 -0.13,-0.866 -0.13,-1.775 0.043,-2.685 0.086,-0.303 0.13,-0.563 0.13,-0.736 -0.173,-0.433 -0.26,-0.866 -0.173,-1.342 0.043,-0.649 0.086,-1.039 0.086,-1.083 -0.26,-0.216 -0.563,-0.216 -0.953,0 -0.216,0.13 -0.476,0.346 -0.823,0.693 -0.346,0.216 -0.649,0.346 -0.952,0.476 -0.26,0.086 -0.736,0.13 -1.343,0.173 l -0.606,0.433 c -0.13,0.087 -0.26,0.26 -0.476,0.563 -0.173,0.173 -0.433,0.303 -0.693,0.347 -0.346,0.086 -0.563,0.043 -0.78,-0.087 -0.217,-0.216 -0.26,-0.563 -0.13,-1.082 0.13,-0.693 0.217,-1.126 0.217,-1.212 -0.043,-0.13 -0.13,-0.433 -0.39,-0.823 -0.216,-0.39 -0.563,-0.606 -0.996,-0.649 -0.606,-0.086 -0.909,-0.086 -0.909,-0.086 -0.13,-0.173 -0.26,-0.39 -0.346,-0.693 -0.087,-0.086 -0.303,-0.26 -0.649,-0.433 -0.303,-0.173 -0.52,-0.346 -0.649,-0.52 -0.13,-0.26 -0.13,-0.606 -0.043,-1.125 0.087,-0.477 0.087,-0.78 -0.043,-0.91 -0.043,0 -0.173,-0.086 -0.433,-0.173 -0.433,-0.13 -0.779,-0.173 -1.125,-0.087 -0.13,0.043 -0.346,0.13 -0.693,0.26 -0.303,0.043 -0.52,0 -0.693,-0.129 -0.173,-0.173 -0.346,-0.433 -0.606,-0.823 l -0.476,-0.52 c -0.52,-0.823 -0.866,-1.212 -0.953,-1.256 -1.039,-0.52 -1.818,-0.779 -2.381,-0.909 -0.173,-0.043 -0.433,-0.173 -0.823,-0.346 -0.043,0 -0.346,0.086 -0.909,0.26 -0.52,0.086 -1.126,0.043 -1.905,-0.173 -0.476,-0.086 -0.693,-0.13 -0.693,-0.173 -0.303,-0.086 -0.433,-0.433 -0.476,-1.039 -0.043,-0.52 -0.217,-0.779 -0.476,-0.779 -0.173,0 -0.346,0.173 -0.563,0.52 -0.217,0.39 -0.433,0.606 -0.52,0.649 l -0.216,-0.043 c -0.173,-0.173 -0.217,-0.433 -0.217,-0.736 0.043,-0.346 0,-0.606 0,-0.736 l -0.13,-0.087 -0.13,0.087 c -0.39,0.346 -0.65,0.563 -0.736,0.606 -0.086,0.043 -0.26,0.043 -0.563,0.043 -1.169,0.043 -2.035,-0.606 -2.684,-1.992 -0.173,-0.476 -0.433,-1.125 -0.736,-1.992 -0.346,-0.606 -0.909,-0.779 -1.732,-0.476 -0.043,0.043 -0.433,0.173 -1.169,0.39 -0.39,0.216 -0.649,0.303 -0.693,0.303 -0.736,0.13 -1.125,-0.173 -1.255,-0.909 -0.043,-0.086 -0.087,-0.26 -0.087,-0.52 -0.173,-0.216 -0.476,-0.39 -0.953,-0.606 -0.087,-0.043 -0.303,-0.303 -0.736,-0.736 -0.736,-0.866 -0.779,-1.905 -0.173,-3.161 0.043,-0.13 0.043,-0.216 0.043,-0.346 -0.346,-0.303 -0.52,-0.476 -0.563,-0.563 h -0.087 c -0.043,0 -0.043,0.043 -0.043,0.043 -0.13,0.13 -0.346,0.173 -0.52,0.173 -0.39,-0.087 -0.606,-0.217 -0.693,-0.433 -0.13,-0.347 -0.217,-0.52 -0.26,-0.563 -0.216,-0.13 -0.476,-0.173 -0.823,-0.086 -0.13,-0.13 -0.26,-0.303 -0.433,-0.606 -0.26,-0.39 -0.476,-0.563 -0.606,-0.606 -0.13,0 -0.39,0.086 -0.78,0.26 -0.173,0.043 -0.39,0.043 -0.693,-0.043 -0.043,0 -0.26,0.087 -0.65,0.173 -0.26,0.086 -0.519,0.086 -0.692,0.043 -0.39,-0.13 -0.736,-0.39 -1.126,-0.779 -0.13,-0.173 -0.39,-0.477 -0.65,-0.909 -0.303,-0.39 -0.606,-0.52 -0.996,-0.433 -0.217,0.043 -0.433,0.13 -0.563,0.303 l -0.129,0.261",
                        "Volyn": "m 88.802,54.536 c -0.13,0.346 -0.693,0.823 -1.688,1.515 -0.087,0.043 -0.39,0.26 -0.78,0.649 l -0.736,0.52 c -0.173,0.086 -0.39,0.216 -0.736,0.39 -0.39,0.26 -0.736,0.476 -0.953,0.736 -0.26,0.216 -0.606,0.649 -1.039,1.212 -0.606,0.563 -1.083,0.953 -1.386,1.169 l -0.866,0.476 c -0.649,0.39 -1.256,0.606 -1.775,0.649 -0.26,-0.13 -0.39,-0.216 -0.433,-0.26 0,-0.043 -0.043,-0.13 -0.043,-0.303 -0.217,-0.693 -0.476,-1.169 -0.779,-1.472 -0.173,-0.13 -0.996,-0.26 -2.468,-0.346 -0.303,0 -0.693,-0.13 -1.126,-0.347 -0.433,-0.173 -0.779,-0.303 -1.083,-0.303 -0.563,0.043 -0.952,0.173 -1.212,0.477 -0.303,0.043 -0.78,0.043 -1.342,0.086 -0.433,0.087 -0.779,0.26 -1.169,0.563 -0.39,0.346 -0.606,0.693 -0.606,1.083 0.043,0.13 0.087,0.303 0.217,0.433 0.13,0.13 0.26,0.26 0.26,0.303 0.217,0.736 0.39,1.256 0.52,1.602 0.087,0.26 0.173,0.433 0.173,0.563 0.043,0.086 0,0.346 0,0.779 l -0.13,0.086 c -0.13,0 -0.26,-0.086 -0.476,-0.26 -0.217,-0.13 -0.433,-0.216 -0.649,-0.13 0.086,0.563 0.13,0.996 0.26,1.212 0.043,0.346 0.217,0.52 0.52,0.563 0.433,0.043 0.693,0.086 0.693,0.13 0.217,0.26 0.217,0.563 -0.043,0.866 -0.26,0.346 -0.39,0.606 -0.39,0.736 0.303,0.13 0.563,0.303 0.779,0.477 0.13,0.086 0.173,0.173 0.173,0.303 0,0.129 0,0.26 0.043,0.303 0.217,0.217 0.347,0.39 0.476,0.52 0.173,0.217 0.173,0.433 0.043,0.693 l -0.39,0.217 -0.087,0.129 c 0.13,0.347 0.217,0.606 0.217,0.78 l -0.043,0.173 c -0.346,0.087 -0.563,0.217 -0.693,0.303 -0.043,0.043 -0.217,0.39 -0.606,1.169 l -0.13,0.26 -0.043,0.606 c 0,0.347 0.087,0.606 0.303,0.866 0.13,0.13 0.39,0.216 0.693,0.216 0.39,0.043 0.649,0.087 0.736,0.13 0.217,0.13 0.39,0.39 0.52,0.736 0.13,0.433 0.217,0.736 0.303,0.909 0.087,0.346 0.13,0.52 0.216,0.563 0.173,0.13 0.26,0.216 0.347,0.303 -0.087,0.303 -0.087,0.52 -0.13,0.693 0.217,0.086 0.346,0.173 0.433,0.216 0.13,0.26 0.216,0.39 0.303,0.477 0.217,0.086 0.346,0.13 0.476,0.173 0.043,0.303 0.346,0.52 0.866,0.649 0.086,0.347 0.217,0.563 0.39,0.65 0.26,0 0.433,0 0.563,0.043 0.217,0.173 0.39,0.303 0.476,0.347 0.346,0.26 0.52,0.433 0.563,0.476 0.043,0.13 0.043,0.346 0,0.736 -0.086,0.087 -0.216,0.173 -0.39,0.217 -0.043,0.346 0.043,0.736 0.217,1.212 0.173,0.26 0.303,0.476 0.39,0.606 l 0.13,0.303 c 0.26,0.086 0.476,0.216 0.693,0.346 0.043,0.476 0.043,0.779 0.043,0.866 0.13,0.216 0.217,0.346 0.26,0.39 0.087,0.26 0.043,0.476 -0.173,0.606 l -0.043,0.13 c 0,0.173 0.087,0.303 0.217,0.39 l 0.043,0.173 c -0.087,0.086 -0.173,0.173 -0.217,0.216 0.043,0.043 0.13,0.173 0.303,0.303 0.39,0.26 0.693,0.433 0.866,0.606 0.173,0.217 0.26,0.347 0.389,0.433 0,0.52 0,0.866 0.087,1.125 0.303,0.303 0.476,0.52 0.606,0.649 l 0.13,0.26 c 0.043,0.086 0.173,0.216 0.303,0.303 0.26,0.173 0.433,0.39 0.606,0.649 0.173,0.259 0.346,0.433 0.476,0.563 0.173,0.173 0.433,0.303 0.779,0.39 0.433,0.13 0.693,0.216 0.779,0.26 0.216,0.26 0.347,0.433 0.476,0.52 0.477,0.173 0.866,0.303 1.126,0.433 0.043,0.043 0.043,0.13 0.086,0.303 -0.043,0.086 -0.086,0.216 -0.216,0.476 -0.043,0.043 -0.086,0.13 -0.13,0.26 -0.173,0.216 -0.736,0.346 -1.688,0.346 -0.173,0 -0.39,-0.043 -0.736,-0.086 l -0.26,0.173 c -0.173,-0.13 -0.52,-0.173 -0.996,-0.13 -0.173,0 -0.476,0 -0.866,0.043 -0.303,0.043 -0.52,0.217 -0.65,0.52 -0.043,0.173 -0.043,0.347 -0.086,0.433 -0.13,0.39 -0.13,0.779 0.086,1.083 0.087,0.173 0.217,0.26 0.26,0.303 0.13,0.043 0.216,0.086 0.26,0.173 0.13,0.13 0.217,0.26 0.303,0.347 0.087,0.043 0.26,0.043 0.476,-0.043 0.173,-0.043 0.39,0 0.52,0.086 0.086,0.043 0.13,0.173 0.086,0.303 -0.173,0.303 -0.26,0.52 -0.26,0.563 0,0.303 0.086,0.606 0.303,0.909 0.173,0.346 0.389,0.52 0.693,0.606 0.346,-0.043 0.649,0 0.866,0.087 l 0.086,0.173 c 0,0.087 -0.086,0.217 -0.216,0.39 -0.087,0.52 -0.087,0.823 0.086,0.996 0.173,0.086 0.303,0.216 0.39,0.346 0.043,0.217 0.086,0.39 0.086,0.477 0.303,0.433 0.477,0.822 0.477,1.125 0,0.086 0,0.173 -0.043,0.26 0.217,-0.476 0.52,-0.736 1.039,-0.736 0.477,0 0.736,0.173 0.866,0.52 -0.086,0.39 0.043,0.649 0.303,0.779 l 0.692,0.303 c 0.173,0.433 0.303,0.736 0.433,0.779 0.649,0.346 1.039,0.52 1.212,0.476 0.086,-0.13 0.26,-0.26 0.433,-0.39 0.303,-0.13 0.563,-0.26 0.823,-0.26 0.347,-0.043 0.563,-0.043 0.693,-0.13 0.216,-0.346 0.433,-0.606 0.563,-0.693 0.217,-0.13 0.563,-0.043 1.126,0.26 0.52,0.26 0.779,0.52 0.823,0.693 -0.217,0.303 -0.303,0.563 -0.26,0.823 0.086,0.13 0.303,0.346 0.692,0.649 0.39,0.346 0.65,0.52 0.823,0.52 0.043,0 0.173,-0.087 0.389,-0.216 0.13,-0.173 0.347,-0.173 0.65,-0.13 0.216,0.086 0.476,0.259 0.779,0.563 0.39,0.563 0.606,0.823 0.65,0.866 0.13,0.303 0.086,0.563 -0.043,0.866 -0.217,0.303 -0.52,0.52 -0.996,0.649 -0.26,0.043 -0.65,0.13 -1.126,0.217 l -0.39,0.26 -0.043,0.173 c 0.043,0.173 0.52,0.563 1.342,1.169 0.26,0.13 0.39,0.347 0.346,0.693 -0.086,0.303 -0.129,0.52 -0.129,0.649 0,0 0.086,0.13 0.216,0.39 0.13,0.087 0.346,0.13 0.606,0.043 0.303,-0.173 0.477,-0.39 0.477,-0.693 0,-0.433 0,-0.736 0.043,-0.823 l 0.13,-0.086 c 0.303,-0.086 0.477,0 0.563,0.216 l 0.217,0.606 c 0.086,0.173 0.39,0.26 0.779,0.26 0.563,-0.043 0.866,-0.043 0.909,0 0.13,0.13 0.13,0.346 0.13,0.563 -0.043,0.173 0,0.303 0.043,0.346 0.043,0.043 0.347,0.13 0.91,0.216 0.519,0.087 0.822,0.26 0.952,0.563 0,0.13 0,0.433 -0.043,0.909 -0.043,0.217 0.086,0.39 0.346,0.52 0.303,0.087 0.52,0.173 0.606,0.217 l 0.953,0.39 c 0.086,0.043 0.346,-0.087 0.693,-0.347 0.476,-0.303 0.692,-0.476 0.736,-0.476 0.173,-0.086 0.39,-0.13 0.649,-0.173 0.52,-0.13 0.996,-0.043 1.342,0.26 l 0.303,0.26 c 0.216,0.13 0.563,0.173 0.953,0.13 l 0.13,-0.043 c 0.043,-0.173 0.086,-0.39 0,-0.736 -0.043,-0.303 -0.043,-0.563 0.043,-0.649 0.303,-0.086 0.693,0.13 1.04,0.563 0.39,0.433 0.692,0.649 0.952,0.606 l 1.169,-0.216 c 0.087,-0.043 0.217,0 0.347,0.13 0.346,0.173 0.52,0.563 0.52,1.039 -0.043,0.476 -0.087,0.823 -0.087,1.083 1.386,-1.039 2.122,-1.688 2.252,-1.948 0.216,-0.52 0.433,-0.823 0.563,-0.909 0.087,-0.043 0.303,-0.043 0.736,0.043 0.303,0.043 0.519,-0.043 0.519,-0.26 l 0.087,-0.779 -0.13,-0.26 c -0.173,-0.086 -0.476,-0.173 -0.996,-0.303 L 114,113.203 c -0.13,-0.173 -0.39,-0.476 -0.866,-0.823 -0.476,-0.346 -0.692,-0.563 -0.692,-0.736 l 0.043,-0.13 c 0.173,-0.086 0.39,-0.086 0.779,0.043 0.217,0.086 0.563,-0.087 0.91,-0.563 0.303,-0.39 0.519,-0.693 0.606,-0.953 l -0.087,-0.173 c -0.216,-0.303 -0.692,-0.736 -1.472,-1.255 v -0.13 c 0.26,-0.433 0.433,-0.736 0.606,-0.823 0.13,-0.043 0.39,0 0.823,0.13 1.645,0.433 2.814,0.563 3.507,0.433 0.563,-0.087 0.78,-0.563 0.649,-1.429 -0.043,-0.26 -0.216,-0.649 -0.433,-1.083 -0.173,-0.26 -0.26,-0.476 -0.26,-0.606 0.043,-0.217 0.217,-0.303 0.39,-0.26 1.515,0.216 2.338,0.346 2.468,0.39 l 0.173,-0.043 c 0.173,-0.173 0.043,-0.39 -0.303,-0.606 -0.52,-0.346 -0.736,-0.52 -0.823,-0.649 0,-0.13 0,-0.26 0.086,-0.303 0.173,-0.087 0.347,-0.217 0.433,-0.347 0.13,-0.26 0,-0.649 -0.26,-1.212 l 0.043,-0.13 0.216,0.043 c 0.39,0.477 0.823,0.779 1.342,0.953 0.693,0.13 1.212,0.26 1.602,0.39 l 0.173,-0.043 c 0.086,-0.303 0.216,-0.52 0.39,-0.693 0.043,-0.043 0.129,-0.086 0.303,-0.086 0.389,-0.13 0.692,-0.26 0.909,-0.346 0.217,-0.13 0.39,-0.26 0.52,-0.26 0.433,-0.086 0.779,-0.173 0.996,-0.26 0.173,-0.39 0.346,-0.606 0.476,-0.779 0.217,-0.043 0.649,-0.087 1.386,-0.087 0.649,0 1.083,0.173 1.385,0.433 0.173,0.216 0.477,0.52 0.823,0.953 v 0.13 l -0.13,0.303 c 0.043,0.087 0.13,0.173 0.216,0.173 0.823,0.087 1.299,0.173 1.386,0.26 l 0.39,0.26 c 0.303,0.303 0.52,0.563 0.736,0.693 0.303,0.26 0.606,0.346 0.866,0.26 0.13,-0.043 0.216,-0.13 0.26,-0.26 0.086,-0.909 0.173,-1.429 0.216,-1.559 0.043,-0.13 0.216,-0.39 0.563,-0.866 0.216,-0.216 0.26,-0.606 0.13,-1.169 l -0.13,-0.823 c 0,-0.303 0,-0.909 0.13,-1.861 -0.043,-0.217 -0.043,-0.347 0,-0.433 l 0.13,-0.303 c 0.563,-0.26 0.953,-0.52 1.169,-0.649 0.563,-0.563 0.953,-0.823 1.039,-0.823 0.26,-0.043 0.477,0 0.693,0.087 0.26,0.13 0.433,0.173 0.52,0.173 0.13,-0.13 0.303,-0.346 0.52,-0.736 -0.043,-0.13 -0.216,-0.26 -0.563,-0.433 -0.433,-0.173 -0.692,-0.346 -0.779,-0.52 v -0.173 c 0.173,-0.39 0.477,-0.693 0.866,-0.953 0.346,-0.216 0.606,-0.347 0.649,-0.477 0.043,-0.346 0.086,-0.52 0.086,-0.563 0.043,-0.26 -0.086,-0.477 -0.26,-0.52 -0.043,-0.13 -0.26,-0.347 -0.692,-0.65 -0.347,-0.26 -0.433,-0.52 -0.217,-0.779 0.13,-0.216 0.26,-0.303 0.39,-0.303 l 1.256,-0.173 c 0.779,-0.173 1.342,-0.26 1.731,-0.26 0.173,-0.13 0.217,-0.476 0.13,-1.083 -0.086,-0.52 -0.13,-0.822 -0.086,-0.822 l -0.346,-0.303 c -0.043,-1.126 -0.563,-1.949 -1.602,-2.511 -0.39,0.043 -0.693,0.13 -0.866,0.303 -0.216,0.13 -0.346,0.217 -0.476,0.217 -0.39,-0.217 -0.736,-0.39 -1.039,-0.433 0.13,-0.649 0.173,-1.125 0.173,-1.515 -0.043,-0.217 -0.043,-0.39 0,-0.477 0.563,0.043 1.169,-0.043 1.818,-0.216 0.866,-0.217 1.342,-0.606 1.472,-1.212 0,-0.086 0,-0.303 0,-0.52 0.043,-0.563 0,-0.909 -0.13,-0.996 -0.259,-0.216 -0.563,-0.52 -1.039,-0.909 -0.129,-0.086 -0.303,-0.303 -0.519,-0.52 l -0.52,-0.26 c -0.086,-0.043 -0.173,-0.086 -0.346,-0.173 l -1.385,-0.606 c -0.13,-0.043 -0.217,-0.216 -0.347,-0.476 -0.26,-0.39 -0.693,-0.779 -1.299,-1.212 -0.216,-0.216 -0.39,-0.346 -0.39,-0.476 l -0.086,-0.65 c -0.043,-0.173 -0.39,-0.389 -1.083,-0.649 -0.087,-0.043 -0.216,-0.216 -0.347,-0.476 -0.086,-0.303 0,-0.823 0.347,-1.645 0.173,-0.52 0.26,-0.779 0.26,-0.823 l -0.13,-0.13 c -0.13,0.043 -0.433,0.26 -0.953,0.736 -0.909,0.087 -1.342,-0.13 -1.299,-0.779 l -0.13,-0.043 c -0.217,-0.086 -0.346,0 -0.477,0.217 -0.086,0.26 -0.173,0.433 -0.216,0.52 l -0.433,0.39 c -0.173,0.086 -0.476,0 -0.952,-0.13 -0.606,-0.26 -1.256,-0.173 -1.992,0.303 -0.087,0.086 -0.173,0.346 -0.303,0.692 -0.086,0.303 -0.216,0.477 -0.39,0.52 -0.303,-0.043 -0.563,-0.216 -0.736,-0.52 -0.13,-0.303 -0.217,-0.649 -0.13,-0.952 0.173,-0.91 0.217,-1.386 0.217,-1.516 0,-0.303 0,-0.693 -0.043,-1.212 0,-0.346 0.043,-0.779 0.216,-1.385 0,-0.26 -0.129,-0.779 -0.346,-1.472 -0.173,-0.606 -0.26,-1.125 -0.173,-1.472 0.043,-0.303 0.39,-0.736 1.082,-1.342 0.52,-0.476 0.649,-0.953 0.347,-1.472 -0.26,-0.26 -0.563,-0.39 -0.953,-0.39 -0.13,-0.086 -0.173,-0.346 -0.216,-0.779 -0.173,0.13 -0.39,0.173 -0.649,0.173 -0.433,-0.043 -0.693,-0.173 -0.78,-0.39 -0.086,-0.13 -0.086,-0.433 -0.086,-0.953 -0.086,-0.563 -0.043,-1.212 0,-2.035 0.086,-0.649 0.173,-1.082 0.26,-1.342 0.043,-0.173 0.347,-0.563 0.866,-1.212 0.477,-0.649 0.823,-1.126 1.04,-1.299 0.13,-0.173 0.433,-0.347 0.822,-0.649 0.563,-0.477 0.953,-1.039 1.04,-1.732 0.043,-0.173 -0.043,-0.39 -0.173,-0.606 -0.173,-0.563 -0.26,-0.866 -0.303,-0.952 0,-0.347 0.087,-0.649 0.39,-0.823 0.087,-0.086 0.347,-0.216 0.823,-0.477 -0.13,-0.086 -0.736,-0.129 -1.862,-0.173 -1.126,-0.044 -1.732,-0.13 -1.775,-0.173 -0.043,-0.086 -0.043,-0.433 0,-1.039 -0.086,0 -0.216,-0.043 -0.39,-0.043 -0.649,-0.13 -1.559,-0.13 -2.728,0.043 -0.303,0 -0.736,-0.086 -1.385,-0.26 -0.217,0 -0.52,0 -0.953,0.086 -0.13,-0.043 -0.39,-0.13 -0.779,-0.346 -0.043,-0.043 -0.26,-0.086 -0.649,-0.26 -0.173,-0.043 -0.52,-0.217 -1.126,-0.52 -0.52,-0.26 -0.909,-0.39 -1.083,-0.39 -0.13,0 -0.303,0.086 -0.606,0.26 0,0 -0.216,0.043 -0.52,0.086 -0.216,-0.086 -0.39,-0.173 -0.52,-0.303 -0.087,-0.043 -0.346,0 -0.693,0.13 -0.086,0.043 -0.26,0.13 -0.476,0.26 -0.173,0.043 -0.433,0.13 -0.823,0.173 -0.043,0 -0.433,0.13 -1.083,0.39 -0.13,0.087 -0.433,0.173 -0.779,0.26 -0.346,0.13 -0.953,0.433 -1.775,0.909 -0.303,0.087 -0.736,0.087 -1.386,0.043 -0.173,0.043 -0.433,0.13 -0.736,0.26 -0.606,0.216 -1.256,0.347 -1.992,0.303 l -0.823,-0.043 c -0.173,-0.043 -0.433,-0.043 -0.736,-0.13 -0.52,0.043 -1.212,0.26 -2.122,0.606 -0.26,0.043 -0.736,-0.13 -1.342,-0.389 -0.217,-0.087 -0.477,-0.087 -0.823,-0.13 -0.043,0 -0.996,0.087 -2.814,0.26 -0.216,0.043 -0.476,0.086 -0.866,0.173 l -1.559,0.13 c -0.26,0 -1.126,0.043 -2.555,0.087 -0.216,0.086 -0.39,0.303 -0.52,0.563 -0.086,0.173 -0.216,0.39 -0.39,0.649 -0.174,0.259 -0.303,0.433 -0.346,0.52 -0.693,0.649 -1.039,1.039 -1.083,1.039 -0.043,0.13 -0.13,0.563 -0.216,1.256 -0.087,0.26 -0.13,0.433 -0.13,0.563 -0.04,0.473 -0.127,0.993 -0.3,1.426",
                        "Vinnytsia": "m 222.9375,137.40624 c -0.13,0.563 -0.201,0.952 -0.375,1.125 -0.174,0.173 -0.47425,0.369 -0.90625,0.5 -0.39,0.173 -0.71375,0.29575 -0.84375,0.46875 -0.216,0.39 -0.3505,0.6385 -0.4375,0.8125 -0.13,0.346 -0.19425,0.6395 -0.28125,0.8125 -0.216,0.303 -0.67025,0.39175 -1.40625,0.21875 -0.779,-0.217 -1.27125,-0.34375 -1.53125,-0.34375 -0.477,0.26 -0.8465,0.44425 -1.0625,0.53125 l -0.78125,0.21875 c -0.043,-0.217 -0.2595,-0.491 -0.5625,-0.75 -0.442,-0.4 -0.81025,-0.43575 -1.15625,-0.21875 -0.52,0.216 -0.82025,0.34375 -0.90625,0.34375 -0.736,-0.433 -1.322,-0.55575 -1.625,-0.46875 -0.087,0.043 -0.29075,0.34325 -0.59375,0.90625 -0.303,0.52 -0.653,0.832 -1,0.875 -0.39,0.087 -0.8365,-0.0525 -1.3125,-0.3125 -0.736,-0.347 -1.1005,-0.55075 -1.1875,-0.59375 -0.043,0 -0.4565,0.0838 -1.0625,0.34375 -0.13,0 -0.3795,0.081 -0.8125,0.125 -0.779,0.086 -1.2635,0.125 -1.4375,0.125 l -0.5625,-0.125 c -0.173,0 -0.62625,0.076 -1.40625,0.25 -0.563,0.216 -1.04075,0.33875 -1.34375,0.46875 -0.606,0.173 -1.08375,0.24325 -1.34375,0.15625 -0.433,-0.173 -0.784,-0.30075 -1,-0.34375 -0.303,-0.087 -1.34225,0.028 -3.03125,0.375 -0.13,0.043 -0.25775,-0.008 -0.34375,-0.0937 l -0.0625,0 c -0.043,0.39 -0.11325,0.663 -0.15625,0.75 -0.043,0.043 -0.317,0.0743 -0.75,0.0312 -0.52,0 -0.7685,-0.005 -0.8125,0.125 0.606,0.39 0.957,0.67475 1,0.71875 -0.13,0.433 -0.46825,0.77125 -1.03125,1.03125 -0.52,-0.13 -0.909,-0.21875 -1.125,-0.21875 -0.13,0.087 -0.2645,0.31025 -0.4375,0.65625 -0.173,0.39 -0.26275,0.65125 -0.21875,0.78125 0.26,0.26 0.726,0.448 1.375,0.75 0.433,0.347 0.6435,0.6775 0.6875,0.9375 0,0.216 -0.115,0.563 -0.375,1.125 -0.347,0.779 -0.60825,1.24 -0.78125,1.5 -0.043,0.086 -0.18925,0.27125 -0.40625,0.53125 l 0.0625,0.15625 c 0.303,0.217 0.5155,0.491 0.6875,0.75 0.086,0.26 -0.003,0.5105 -0.21875,0.8125 -0.303,0.26 -0.5525,0.221 -0.8125,-0.125 -0.086,-0.043 -0.23225,-0.043 -0.40625,0 -0.26,0 -0.42575,0.18425 -0.46875,0.53125 -0.087,0.216 -0.1445,0.45375 -0.1875,0.84375 0,0.043 0.45325,0.43975 1.40625,1.21875 l 0,0.125 c -0.043,0.086 -0.279,0.23225 -0.625,0.40625 -0.216,0.13 -0.293,0.35325 -0.25,0.65625 0.043,0.216 0.20775,0.37 0.46875,0.5 0.433,0.13 1.17875,0.1925 2.21875,0.0625 0.086,0 0.23225,0.2555 0.40625,0.6875 0.173,0.477 0.2315,0.71375 0.1875,0.84375 -1.212,0.216 -1.641,0.57375 -1.25,1.09375 l 0.28125,0.46875 c 0.086,0.13 0.125,0.442 0.125,0.875 l 0.25,0.125 0.4375,0.0937 c 0.259,0.043 0.375,0.2595 0.375,0.5625 -0.043,0.173 -0.0185,0.4235 -0.0625,0.8125 0,0.087 0.12175,0.361 0.46875,0.75 l 0.0937,0.0937 c 0.26,0.39 0.2795,0.6775 0.0625,0.9375 -0.346,0.346 -0.5195,0.5955 -0.5625,0.8125 -0.043,0.13 -0.043,0.2255 0,0.3125 0.043,0.39 0.32975,0.8365 0.71875,1.3125 0.13,0.303 0.1485,0.725 0.0625,1.375 0.173,0.649 0.26275,0.98825 0.21875,1.03125 -0.13,0.173 -0.25775,0.28125 -0.34375,0.28125 -0.823,0 -1.4615,0.0848 -1.9375,0.34375 l -0.34375,0.25 c -0.217,0.39 -0.3945,0.6015 -0.4375,0.6875 -0.216,0.173 -0.447,0.2315 -0.75,0.1875 -0.26,-0.043 -0.45975,-0.1825 -0.71875,-0.3125 -0.216,-0.26 -0.4325,-0.42575 -0.5625,-0.46875 -0.477,-0.086 -0.8465,-0.19425 -1.0625,-0.28125 -0.39,-0.346 -0.69025,-0.55075 -0.90625,-0.59375 -0.78,-0.303 -1.21375,-0.38 -1.34375,-0.25 -0.087,0.13 -0.202,0.36775 -0.375,0.84375 -0.13,0.39 -0.29475,0.65125 -0.46875,0.78125 -0.606,-0.086 -1.0095,-0.17575 -1.3125,-0.21875 -0.476,0.043 -0.83375,0.0625 -1.09375,0.0625 l -0.0312,0.0314 c -0.043,0.043 -0.0937,0.081 -0.0937,0.125 -0.13,0.216 -0.17575,0.53575 -0.21875,0.96875 l -0.375,0.46875 c -0.043,0.13 -0.005,0.35425 0.125,0.65625 l 0,0.15625 -0.125,0.0937 c -0.476,-0.043 -0.788,0.1345 -0.875,0.4375 -0.043,0.13 -0.121,0.47325 -0.25,0.90625 -0.13,0.216 -0.442,0.43525 -0.875,0.78125 -0.173,0 -0.23825,0.076 -0.28125,0.25 0.043,0.303 -0.0905,0.692 -0.4375,1.125 -0.087,0.26 -0.043,0.457 0,0.5 0.692,0.779 0.802,1.23325 0.5,1.40625 l -0.5625,0.28125 c -0.086,0 -0.125,0.077 -0.125,0.25 -0.043,0.173 -0.043,0.29975 0,0.34375 0.086,0.216 0.2205,0.51725 0.4375,0.90625 0.303,1.082 0.4375,1.6445 0.4375,1.6875 l -0.125,0.5625 c -0.13,0.52 -0.0217,1.3175 0.28125,2.3125 l 0.28125,0.71875 c 0,0.086 0.076,0.20875 0.25,0.46875 0.13,0.173 0.125,0.35725 0.125,0.53125 -0.086,0.043 -0.163,0.0937 -0.25,0.0937 -0.346,-0.129 -0.5575,-0.18075 -0.6875,-0.0937 l -0.0937,0.0937 0.15625,1 0.0937,0.28125 c 0,0 -0.008,0.12775 -0.0937,0.34375 -0.043,0.086 -0.0312,0.60275 -0.0312,1.46875 0,0.39 -0.115,0.88225 -0.375,1.53125 -0.303,0.693 -0.456,1.153 -0.5,1.5 0.26,-0.043 0.87225,0.307 1.78125,1 0.13,0.13 0.3845,0.3025 0.6875,0.5625 0.043,0.13 0.24,0.6575 0.5,1.4375 0.13,0.433 0.19525,0.78975 0.28125,1.09375 0.26,1.646 0.48325,2.534 0.65625,2.75 0.0806,0.12182 0.28887,0.19967 0.5625,0.28125 0.086,0 0.21375,-0.0195 0.34375,-0.0625 0.477,-0.043 0.9665,-0.1775 1.3125,-0.4375 0.477,-0.303 0.67575,-0.46875 0.71875,-0.46875 0.173,0.13 0.2745,0.3415 0.1875,0.6875 -0.043,0.39 -0.0548,0.663 0.0312,0.75 l 0.125,0.0937 c 1.083,0.39 1.65125,0.582 1.78125,0.625 0.346,0 0.8695,-0.12775 1.5625,-0.34375 0.476,-0.217 0.87675,-0.28625 1.09375,-0.15625 0.086,0.043 0.201,0.0693 0.375,0.15625 l 0.125,0.15625 c 0.086,0.043 0.1825,0.121 0.3125,0.25 0.086,0.087 0.245,0.2595 0.375,0.5625 0.26,0.303 0.52225,0.5195 0.78125,0.5625 l 0.75,0.3125 c 0.043,0.043 0.12,0.0625 0.25,0.0625 0.173,0.086 0.3455,0.394 0.5625,1 0.216,0.563 0.4285,0.9705 0.6875,1.1875 0.13,0.216 0.481,0.45375 1,0.84375 0.52,0.477 1.13125,0.70025 1.78125,0.65625 0.217,0.087 0.55525,0.21875 1.03125,0.21875 0.996,0.043 1.56525,0.26625 1.78125,0.65625 0.086,0.303 0.11825,0.692 0.0312,1.125 -0.087,0.26 -0.17075,0.605 -0.34375,1.125 -0.13,0.519 0.067,0.826 0.5,1 0.433,0.086 0.7205,-0.0213 0.9375,-0.28125 0.216,-0.346 0.3505,-0.60825 0.4375,-0.78125 0.087,-0.217 0.31425,-0.28125 0.53125,-0.28125 0.26,0 0.413,0.0642 0.5,0.28125 0.043,0.086 0.0625,0.40575 0.0625,0.96875 0,0.39 0.12775,0.65125 0.34375,0.78125 0.433,0.26 0.7595,0.336 1.0625,0.25 0.13,-0.043 0.442,-0.26725 0.875,-0.65625 0.26,-0.217 0.4325,-0.27625 0.5625,-0.40625 0.13,-0.13 0.21375,-0.2695 0.34375,-0.3125 0.173,-0.086 0.365,-0.0977 0.625,0.0312 0.216,0.086 0.32025,0.168 0.40625,0.125 0.216,-0.26 0.36225,-0.36325 0.40625,-0.40625 0.216,-0.086 0.40125,-0.0675 0.53125,0.0625 0.173,0.173 0.33975,0.43025 0.46875,0.90625 0.043,0.173 0.0235,0.485 -0.0625,0.875 -0.086,0.563 -0.40575,1.05425 -0.96875,1.53125 -0.043,0.043 -0.15125,0.081 -0.28125,0.125 l -0.15625,0.25 c -0.217,0.13 -0.3125,0.2255 -0.3125,0.3125 -0.043,0.173 -0.0352,0.3845 0.0937,0.6875 0.086,0.26 0.2595,0.3945 0.5625,0.4375 0.303,0.043 0.615,-0.18025 0.875,-0.65625 0.347,-0.606 0.62175,-1.02625 0.96875,-1.15625 0.26,-0.087 0.495,-0.17975 0.625,-0.0937 0.52,0.477 0.72375,0.98 0.59375,1.5 -0.043,0.13 -0.197,0.3025 -0.5,0.5625 0,0.043 0.0702,0.2155 0.15625,0.5625 0.13,0.26 0.21375,0.62175 0.34375,0.96875 0.129,0.303 0.36,0.50275 0.75,0.71875 0.086,-0.173 0.15625,-0.288 0.15625,-0.375 0,-0.866 0.10725,-1.4715 0.28125,-1.6875 l 0.15625,-0.25 c 0,0 0.658,-0.57425 2,-1.65625 0.086,-0.043 0.1825,-0.0937 0.3125,-0.0937 0.043,0 0.16975,0.0195 0.34375,0.0625 0.303,0.043 0.731,0.10825 1.25,0.28125 0.779,0.086 1.11325,0.1875 1.15625,0.1875 0.086,0.043 0.34825,0.26625 0.78125,0.65625 l 0.21875,0 c 0.086,-0.087 0.38725,-0.15625 0.90625,-0.15625 0.346,0 0.53125,0.0195 0.53125,0.0625 0.216,0.087 0.5045,0.2595 0.9375,0.5625 0.173,0.043 0.45475,0.048 0.84375,-0.125 0.217,0.043 0.4715,0.196 0.6875,0.5 0.26,0.303 0.375,0.62675 0.375,0.84375 0,0.173 -0.0898,0.37275 -0.21875,0.71875 0,0.303 0.26225,0.64125 0.78125,1.03125 0.086,0.217 0.0977,0.6675 -0.0312,1.1875 l 0.8125,0.9375 0,0.0625 c 0.173,0 0.6195,-0.12675 1.3125,-0.34375 0.823,-0.26 1.29575,-0.4325 1.46875,-0.5625 0,-0.043 0.16575,-0.32375 0.46875,-0.84375 0.26,-0.433 0.56025,-0.783 0.90625,-1 0.477,-0.26 0.77625,-0.46375 0.90625,-0.59375 0.043,-0.173 0.005,-0.562 -0.125,-1.125 -0.173,-0.606 -0.16125,-0.96375 -0.0312,-1.09375 0.953,-0.52 1.5145,-0.68075 1.6875,-0.59375 0.303,0.477 0.6725,0.83375 1.0625,1.09375 l 0.4375,0.25 c 0.043,0.043 0.13175,0.12775 0.21875,0.34375 0.086,0.087 0.2205,0.207 0.4375,0.25 1.212,0.52 1.86325,0.81925 1.90625,0.90625 0.303,0 0.68025,-0.0263 1.15625,-0.15625 0.26,0 0.67925,0.008 1.15625,0.0937 0.39,0.043 0.7545,-0.008 1.1875,-0.0937 0.217,0 0.4325,-0.12775 0.5625,-0.34375 0.13,-0.043 0.31425,-0.081 0.53125,-0.125 0.649,-0.173 1.08475,-0.486 1.34375,-0.875 l 0.15625,0 c 0.086,0.043 0.1445,0.13175 0.1875,0.21875 0.086,0.129 0.36,0.2595 0.75,0.5625 0.39,0.217 0.59375,0.34375 0.59375,0.34375 0.216,0.13 0.72,0.17575 1.5,0.21875 1.039,0.043 1.778,0 2.125,0 0.26,-0.043 0.6295,-0.1395 1.0625,-0.3125 0.216,0 0.43525,0.0965 0.78125,0.3125 l 0.0625,-0.0312 0.0937,-0.15625 c -0.086,-0.39 -0.0937,-0.6015 -0.0937,-0.6875 0.086,-0.087 0.1875,-0.13175 0.1875,-0.21875 0.346,-0.476 0.346,-0.93025 0,-1.40625 l -0.4375,-0.625 c -0.39,-0.477 -0.39,-0.865 0,-1.125 0.173,-0.13 0.3505,-0.168 0.4375,-0.125 0.13,0.043 0.21375,0.1775 0.34375,0.4375 0.087,0 0.34825,-0.0955 0.78125,-0.3125 0.389,-0.303 0.701,-0.418 0.875,-0.375 0.26,-0.173 0.413,-0.37 0.5,-0.5 0.044,-0.086 -0.008,-0.21475 -0.0937,-0.34375 0.216,-0.347 0.414,-0.60825 0.5,-0.78125 l -0.0626,-0.2812 c -0.043,-0.087 -0.125,-0.15225 -0.125,-0.28125 0.087,-0.217 0.125,-0.36325 0.125,-0.40625 l -0.0312,-0.15625 c -0.909,-0.13 -1.38275,-0.32875 -1.46875,-0.71875 0.606,-0.693 0.9705,-1.38225 1.1875,-2.03125 -0.044,-0.953 0.008,-1.48325 0.0937,-1.65625 0.086,-0.216 0.30925,-0.47825 0.65625,-0.78125 0.433,-0.432 0.75,-0.6445 0.75,-0.6875 l 0.46875,-0.59375 c 0.216,-0.346 0.38275,-0.60825 0.46875,-0.78125 0.217,-0.216 0.485,-0.49 0.875,-0.75 0.476,-0.303 0.8075,-0.35375 0.9375,-0.0937 0.087,0.217 0.048,0.57375 -0.125,1.09375 0.173,0.086 0.3075,0.38625 0.4375,0.90625 0.087,0.477 0.202,0.7255 0.375,0.8125 0.087,0 0.2255,-0.0195 0.3125,-0.0625 0.693,-0.606 1.05075,-1.00275 1.09375,-1.21875 0.043,-0.346 0.0507,-0.60825 0.0937,-0.78125 0.043,-0.173 0.0702,-0.17575 0.15625,-0.21875 0.086,-0.043 0.399,-0.081 0.875,-0.125 0.39,0 0.58875,-0.1005 0.71875,-0.1875 0.33985,-0.46717 0.62664,-0.79235 0.71875,-0.96875 -0.002,-0.005 0.003,-0.0262 0,-0.0312 -0.0885,-0.16805 -0.2788,-0.3413 -0.53125,-0.59375 -0.39,-0.347 -1.00225,-0.29525 -1.78125,0.0937 -0.693,0.347 -1.12,0.47375 -1.25,0.34375 -0.173,-0.26 -0.135,-0.5095 0.125,-0.8125 0.13,-0.13 0.35325,-0.3465 0.65625,-0.5625 0.173,-0.216 0.25675,-0.53575 0.34375,-0.96875 0.303,0 0.52725,-0.1345 0.65625,-0.4375 0.13,-0.26 0.15625,-0.46375 0.15625,-0.59375 l -0.125,-0.65625 c -0.043,-0.346 -0.2155,-0.697 -0.5625,-1 l -0.5,-0.6875 c 0,0 -0.1345,-0.2495 -0.4375,-0.8125 -0.216,-0.52 -0.3555,-0.99275 -0.3125,-1.46875 0.087,-0.52 0.0752,-0.82025 0.0312,-0.90625 l -0.125,-0.0937 -1.15625,-0.4375 c -0.13,-0.043 -0.3025,-0.1395 -0.5625,-0.3125 -0.823,-0.563 -1.207,-1.03575 -1.25,-1.46875 l 0,-0.375 c 0.173,-0.26 0.4995,-0.534 1.0625,-0.75 l 0.0625,-0.15625 -0.0625,-0.15625 c -0.216,-0.13 -0.47825,-0.23825 -0.78125,-0.28125 0,-0.259 -0.0195,-0.42575 -0.0625,-0.46875 l 0,-0.21875 -0.0937,-0.0937 c -1.255,0.129 -2.09825,0.12225 -2.53125,-0.0937 -0.173,-0.086 -0.23825,-0.399 -0.28125,-0.875 0,-0.563 -0.0195,-0.90125 -0.0625,-1.03125 -0.086,-0.347 -0.11325,-0.60725 -0.15625,-0.78125 -0.129,-0.563 -0.21875,-0.875 -0.21875,-0.875 -0.649,-0.173 -1.00675,-0.25775 -1.09375,-0.34375 -0.13,-0.13 -0.245,-0.4565 -0.375,-1.0625 0.433,-0.26 0.69525,-0.495 0.78125,-0.625 0.043,-0.13 0.005,-0.33375 -0.125,-0.59375 -0.216,-0.563 -0.49775,-0.875 -0.84375,-0.875 -0.303,0.043 -0.496,0.043 -0.625,0 -0.087,-0.173 -0.31025,-0.3465 -0.65625,-0.5625 -0.303,-0.173 -0.4375,-0.288 -0.4375,-0.375 l 0.375,-0.40625 c 0.043,-0.173 0.1055,-0.4225 0.0625,-0.8125 0.173,-0.173 0.43525,-0.26275 0.78125,-0.21875 l 0.0625,-0.0937 c 0.086,-0.13 0.0245,-0.35325 -0.0625,-0.65625 -0.173,-0.303 -0.27725,-0.4755 -0.40625,-0.5625 -0.65,0 -1.12275,-0.0263 -1.46875,-0.15625 -0.217,-0.043 -0.33875,-0.16575 -0.46875,-0.46875 -0.303,-0.606 -0.1685,-1.17925 0.4375,-1.65625 0.173,-0.173 0.45375,-0.3455 0.84375,-0.5625 l 0.28125,-0.125 0.84375,-0.46875 c 0,-0.087 -0.0145,-0.44375 -0.1875,-1.09375 0.086,-0.303 0.50125,-0.5525 1.28125,-0.8125 0.043,-0.13 -0.0397,-0.43025 -0.34375,-0.90625 -0.216,-0.39 -0.0765,-0.7215 0.3125,-0.9375 0.173,-0.39 0.0267,-0.62675 -0.40625,-0.84375 -0.52,-0.347 -0.86325,-0.57025 -0.90625,-0.65625 l 0,-0.1875 c 0.043,-0.087 0.18925,-0.18925 0.40625,-0.40625 0.26,-0.216 0.38275,-0.3125 0.46875,-0.3125 -0.043,-0.39 -0.12,-0.663 -0.25,-0.75 l -0.375,-0.0312 c -0.433,0.217 -0.7585,0.298 -1.0625,0.125 -0.043,-0.346 -0.1445,-0.58875 -0.1875,-0.71875 -0.26,-0.303 -0.3895,-0.54575 -0.5625,-0.71875 -0.217,-0.953 -0.54075,-1.457 -0.84375,-1.5 -0.996,-0.043 -1.5585,-0.0888 -1.6875,-0.21875 -0.086,-0.043 -0.17575,-0.471 -0.21875,-1.25 -0.043,-0.173 -0.1775,-0.4275 -0.4375,-0.6875 -0.216,-0.216 -0.30575,-0.51725 -0.21875,-0.90625 0.043,-0.346 0.2595,-0.60825 0.5625,-0.78125 0.996,-0.649 1.456,-1.0145 1.5,-1.1875 l 0.0625,-0.90625 c -0.043,-0.087 -0.18525,-0.437 -0.53125,-1 -0.303,-0.563 -0.46875,-0.94025 -0.46875,-1.15625 0.043,-0.173 0.1775,-0.3075 0.4375,-0.4375 0.303,-0.086 0.4375,-0.2255 0.4375,-0.3125 l -0.0625,-0.125 c 0.043,-0.389 0.1055,-0.68925 0.0625,-0.90625 0,-0.13 -0.269,-0.3025 -0.875,-0.5625 -0.649,-0.26 -1.0145,-0.61 -1.1875,-1 -0.173,-0.52 -0.173,-1.11175 0,-1.71875 0.086,-0.086 0.1875,-0.19525 0.1875,-0.28125 0.26,-0.433 0.34375,-0.7595 0.34375,-1.0625 -0.13,-0.303 -0.43025,-0.4765 -0.90625,-0.5625 -0.52,0 -0.908,-0.038 -1.125,-0.125 -0.129,-0.173 -0.3805,-0.18075 -0.8125,-0.0937 -0.173,0.13 -0.3845,0.39125 -0.6875,0.78125 -0.216,0.346 -0.5485,0.60825 -0.9375,0.78125 -0.173,0.086 -0.41575,0.0665 -0.71875,-0.0625 -0.347,-0.173 -0.56925,-0.21875 -0.65625,-0.21875 -0.173,0.043 -0.55025,0.18925 -1.15625,0.40625 -0.13,0.173 -0.21875,0.3845 -0.21875,0.6875 -0.043,0.433 -0.0625,0.6875 -0.0625,0.6875 -0.476,-0.086 -0.7635,-0.11325 -0.9375,-0.15625 -0.346,0.043 -0.658,0.0625 -0.875,0.0625 -0.433,0 -0.8025,0.0625 -1.0625,0.0625 l -1.1875,0.125 c -0.346,-0.087 -0.60825,-0.1445 -0.78125,-0.1875 -0.649,-0.13 -1.153,-0.19425 -1.5,-0.28125 -0.303,0.13 -0.4755,0.21875 -0.5625,0.21875 -0.303,0.086 -0.654,0.0362 -1,-0.0937 -0.39,-0.173 -0.62,-0.33375 -0.75,-0.59375 0.303,-0.39 0.539,-0.702 0.625,-0.875 0.043,-0.086 -0.0838,-0.2985 -0.34375,-0.6875 -0.217,-0.347 -0.34775,-0.697 -0.21875,-1 l -0.0937,-0.125 c -0.52,-0.216 -0.788,-0.414 -0.875,-0.5 -0.087,-0.26 0.17025,-0.7395 0.90625,-1.5625 0.692,-0.78 1.01175,-1.19425 0.96875,-1.28125 -0.563,-0.26 -0.9715,-0.4715 -1.1875,-0.6875 -0.39,-0.303 -0.64625,-0.8645 -0.90625,-1.6875 0.043,-0.26 0.1055,-0.495 0.0625,-0.625 -0.13,-0.346 -0.1875,-0.5575 -0.1875,-0.6875 0.26,-0.563 0.34375,-0.8515 0.34375,-0.9375 -0.26,-0.26 -0.69975,-0.44425 -1.21875,-0.53125 0.13,-0.433 0.28125,-0.67575 0.28125,-0.71875 l -0.0938,-0.1567 c -0.129,-0.043 -0.596,-0.0888 -1.375,-0.21875 -0.736,-0.087 -1.1435,-0.125 -1.1875,-0.125 z",
                        "Ivano-Frankivsk": "m 101.1875,154.62499 c -0.018,0.0141 -0.0126,0.0826 -0.0312,0.0937 -0.216,0.13 -0.4285,0.13 -0.6875,0 -0.13,-0.086 -0.366,-0.17075 -0.625,-0.34375 l -0.25,0.1875 c -0.173,0.043 -0.6195,-0.307 -1.3125,-1 -0.173,-0.086 -0.43525,-0.206 -0.78125,-0.25 -0.303,-0.043 -0.4755,-0.043 -0.5625,0 -1.429,0.39 -2.27025,0.6055 -2.53125,0.5625 -0.173,-0.043 -0.61275,-0.0888 -1.21875,-0.21875 -0.217,0.13 -0.4325,0.41075 -0.5625,0.84375 -0.043,0.086 -0.13175,0.2205 -0.21875,0.4375 -0.043,0.086 0.077,0.31025 0.25,0.65625 0.216,0.39 0.256,0.78575 0.125,1.21875 -0.043,0.13 -0.34325,0.4615 -0.90625,0.9375 -0.433,0.433 -0.586,0.79075 -0.5,1.09375 0.087,0.173 0.235,0.3465 0.625,0.5625 0.389,0.26 0.65125,0.44425 0.78125,0.53125 0,0.39 -0.114,0.62675 -0.375,0.84375 -0.173,0.13 -0.49775,0.3025 -0.84375,0.5625 -0.043,0.087 -0.11325,0.24 -0.15625,0.5 -0.086,0.216 -0.12,0.331 -0.25,0.375 -0.13,0.043 -0.48,0.125 -1,0.125 -0.606,0.043 -1.04175,0.12 -1.34375,0.25 -0.26,0.086 -0.3565,0.32975 -0.3125,0.71875 0.043,0.303 0.18925,0.50775 0.40625,0.59375 0.173,0.086 0.4275,-0.0525 0.6875,-0.3125 0.39,-0.346 0.61325,-0.5625 0.65625,-0.5625 0.13,-0.043 0.283,0.0145 0.5,0.1875 0.346,0.173 0.423,0.4275 0.25,0.6875 -0.216,0.433 -0.34375,0.6435 -0.34375,0.6875 0,0.346 0.05075,0.8305 0.09375,1.4375 l 0.0625,0.15625 c 0.216,0.173 0.51725,0.26175 0.90625,0.21875 0.433,-0.13 0.7205,-0.21875 0.9375,-0.21875 0.173,0.433 0.43525,0.8465 0.78125,1.0625 0.086,0.217 -0.1245,0.62725 -0.6875,1.40625 -0.173,0.173 -0.3465,0.26275 -0.5625,0.21875 -0.13,-0.043 -0.3025,-0.1775 -0.5625,-0.4375 -0.39,-0.13 -1.05875,0.0163 -1.96875,0.40625 -0.13,0.087 -0.29575,0.16975 -0.46875,0.34375 -0.996,0.476 -1.5955,0.73825 -1.8125,0.78125 -0.259,0 -0.649,0.0118 -1.125,-0.0312 -0.13,0.087 -0.43025,0.25175 -0.90625,0.46875 -0.433,0.216 -0.74,0.24325 -1,0.15625 -0.909,-0.303 -1.48325,-0.46875 -1.65625,-0.46875 -0.52,0 -0.95475,0.30025 -1.34375,0.90625 -0.173,0.346 -0.288,0.5195 -0.375,0.5625 -0.13,0 -0.56475,-0.16475 -1.34375,-0.46875 -0.563,-0.26 -0.93925,-0.26775 -1.15625,-0.0937 -0.043,0.043 -0.1775,0.279 -0.4375,0.625 -0.087,0.13 -0.2645,0.15625 -0.4375,0.15625 -1.429,0.043 -2.25175,0.1055 -2.46875,0.0625 -0.52,-0.043 -1.12725,-0.201 -1.90625,-0.375 -0.606,-0.043 -1.21825,0.16075 -1.78125,0.59375 l 0.09375,0 c -0.303,0.26 -0.4755,0.36325 -0.5625,0.40625 -0.13,0.13 -0.25275,0.76175 -0.46875,1.84375 0,0.13 -0.1005,0.33375 -0.1875,0.59375 -0.043,0.173 -0.13175,0.39725 -0.21875,0.65625 -0.303,0.477 -0.95325,1.058 -1.90625,1.75 -0.39,0.26 -0.5625,0.456 -0.5625,0.5 -0.087,1.169 -0.15125,1.99175 -0.28125,2.46875 -0.043,0.216 -0.27125,0.7785 -0.53125,1.6875 0.606,0.563 0.8985,1.2785 0.8125,2.1875 -0.043,0.563 -0.2165,1.3545 -0.5625,2.4375 -0.303,1.299 -0.5145,2.04575 -0.6875,2.21875 0.563,0.13 1.336,0.38725 2.375,0.90625 0.087,0.043 0.44875,0.427 0.96875,1.25 l 0.4687,0.5312 c 0.26,0.39 0.42075,0.6385 0.59375,0.8125 0.173,0.129 0.41575,0.169 0.71875,0.125 0.346,-0.129 0.5575,-0.206 0.6875,-0.25 0.346,-0.086 0.693,-0.0362 1.125,0.0937 0.26,0.086 0.3945,0.15625 0.4375,0.15625 0.13,0.13 0.11825,0.42925 0.03125,0.90625 -0.086,0.52 -0.09775,0.866 0.03125,1.125 0.13,0.173 0.35325,0.35725 0.65625,0.53125 0.346,0.173 0.57025,0.3515 0.65625,0.4375 0.087,0.303 0.21475,0.5145 0.34375,0.6875 0,0 0.30025,0.008 0.90625,0.0937 0.433,0.043 0.784,0.236 1,0.625 0.26,0.39 0.331,0.71375 0.375,0.84375 0,0.086 -0.08875,0.4955 -0.21875,1.1875 -0.13,0.52 -0.06075,0.87775 0.15625,1.09375 0.217,0.13 0.43425,0.17975 0.78125,0.0937 0.26,-0.043 0.5135,-0.16975 0.6875,-0.34375 0.216,-0.303 0.33875,-0.4755 0.46875,-0.5625 l 0.59375,-0.4375 c 0.606,-0.043 1.08275,-0.1015 1.34375,-0.1875 0.303,-0.13 0.62275,-0.25275 0.96875,-0.46875 0.347,-0.347 0.5955,-0.5575 0.8125,-0.6875 0.39,-0.216 0.70875,-0.216 0.96875,0 0,0.043 -0.05075,0.44375 -0.09375,1.09375 -0.087,0.476 -0.01675,0.91075 0.15625,1.34375 0,0.173 -0.038,0.41575 -0.125,0.71875 -0.173,0.909 -0.16125,1.8205 -0.03125,2.6875 0.086,0.823 0.35325,1.3415 0.65625,1.6875 0.346,0.303 0.93975,0.42575 1.71875,0.46875 0.952,0 1.573,-0.12275 1.875,-0.46875 0.303,-0.606 0.453,-1.04575 0.625,-1.21875 l 0.15625,-0.0312 c 0,0 0.10225,0.115 0.40625,0.375 0.26,0.173 0.4765,0.3075 0.5625,0.4375 0.173,0.217 0.2305,0.49675 0.1875,0.84375 0,0.346 -0.01175,0.6005 0.03125,0.6875 0.26,-0.043 0.648,-0.043 1.125,0 0.26,0.39 0.4325,0.58875 0.5625,0.71875 0.347,0.216 0.66975,0.452 0.84375,0.625 l 2.0625,1.96875 0.4375,0.9375 c 0.043,0.173 0.18925,0.37775 0.40625,0.59375 0,0.043 0.03125,0.0693 0.03125,0.15625 0.043,0.087 0.2205,0.361 0.4375,0.75 0,0.087 -0.1725,0.432 -0.5625,1.125 -0.433,0.822 -0.05575,1.78125 1.15625,2.90625 0.26,0.26 1.0565,1.15975 2.3125,2.71875 l 0.03125,0.1875 c -0.086,0.173 -0.3025,0.3855 -0.5625,0.6875 -0.13,0.173 -0.31425,0.47325 -0.53125,0.90625 -0.563,0.909 -0.88175,1.606 -0.96875,2.125 l -0.15625,0.59385 -0.03125,0.125 c 0,0.043 0.05075,0.0625 0.09375,0.0625 0.692,0.217 1.16575,0.4225 1.46875,0.8125 0.13,0.173 0.29075,0.4665 0.59375,0.8125 0.563,0.346 0.86325,0.58875 0.90625,0.71875 0.043,0.086 0.0235,0.34825 -0.0625,0.78125 -0.087,0.346 -0.0168,0.5525 0.15625,0.8125 0.52,0.606 1.0045,0.9335 1.4375,1.0625 0.346,0.043 0.60825,0.1015 0.78125,0.1875 0.216,0.26 0.42075,0.44425 0.59375,0.53125 0.216,0.13 0.644,0.163 1.25,0.25 0.217,0.086 0.82925,1.02575 1.78125,2.84375 0.13,0.173 0.206,0.3515 0.25,0.4375 0.043,0.13 0.19425,0.404 0.28125,0.75 0.13,0.303 0.33475,0.456 0.59375,0.5 0.173,0.043 0.35725,0.0548 0.53125,-0.0312 l 0.0312,-0.0312 -0.0312,-0.5 0,-0.40625 c 0.086,-0.779 0.26725,-1.5375 0.65625,-2.1875 l 0.46875,-1 c 0.13,-0.13 0.206,-0.25775 0.25,-0.34375 0.303,-0.779 0.35375,-1.38725 0.0937,-1.90625 -0.173,-0.52 -0.3125,-0.8085 -0.3125,-0.9375 0.043,-0.649 0.043,-0.98325 0,-1.15625 0,-0.13 -0.20475,-0.5045 -0.59375,-0.9375 -0.216,-0.216 -0.3945,-0.63125 -0.4375,-1.28125 -0.043,-0.693 -0.082,-1.1775 -0.125,-1.4375 -0.13,-0.649 0.336,-1.76525 1.375,-3.28125 0.13,-0.216 0.25675,-0.68975 0.34375,-1.46875 0.086,-0.649 0.3415,-1.0965 0.6875,-1.3125 0.649,0.13 1.0965,0.01 1.3125,-0.25 0.39,-0.477 0.6435,-0.77625 0.6875,-0.90625 0.173,-0.303 0.3515,-0.577 0.4375,-0.75 0.216,-0.303 0.42075,-0.456 0.59375,-0.5 0.52,0 0.832,-0.0507 0.875,-0.0937 0.043,-0.13 0.0118,-0.3075 -0.0312,-0.4375 -0.13,-0.26 -0.21875,-0.38275 -0.21875,-0.46875 -0.043,-0.173 -0.0625,-0.4275 -0.0625,-0.6875 0,-0.173 0.0195,-0.31925 0.0625,-0.40625 0.216,-0.563 0.5055,-0.913 0.9375,-1 0.52,-0.216 0.832,-0.331 0.875,-0.375 0.433,-0.649 0.77125,-1.12175 1.03125,-1.46875 0.173,-0.217 0.25675,-0.37 0.34375,-0.5 0.346,-0.563 0.62775,-0.9285 0.84375,-1.1875 0.346,-0.347 1.0235,-0.92025 2.0625,-1.65625 0.347,-0.346 0.658,-0.62 0.875,-0.75 0.779,-0.477 1.75675,-0.8075 2.96875,-0.9375 l 0.15625,-0.0312 c 0.823,0 1.25775,-0.0118 1.34375,0.0312 0.346,0.086 0.54575,0.2255 0.71875,0.3125 0.26,0.129 0.4325,0.19425 0.5625,0.28125 0.26,0.043 0.42075,0.0665 0.59375,-0.0625 0.086,-0.13 0.18925,-0.62125 0.40625,-1.53125 0.086,-0.39 0.125,-0.663 0.125,-0.75 0.043,-0.086 0.076,-1.287 0.25,-3.625 -0.13,-0.216 -0.207,-0.4325 -0.25,-0.5625 l -0.34375,-1 c -0.216,-0.433 -0.288,-0.783 -0.375,-1 -0.346,-1.429 -0.4855,-2.25175 -0.3125,-2.46875 l 0.46875,-0.5625 c 0.26,-0.303 0.42075,-0.46475 0.59375,-0.59375 0.433,-0.216 0.702,-0.42075 0.875,-0.59375 l 0,-0.0312 0.0312,0 c 0.303,-0.26 0.44425,-0.42075 0.53125,-0.59375 l 0,-0.34375 c -0.13,-0.216 -0.3465,-0.3505 -0.5625,-0.4375 -0.217,-0.087 -0.375,-0.1825 -0.375,-0.3125 0,-0.303 0.20375,-0.5525 0.59375,-0.8125 0.087,-0.13 0.087,-0.31525 0,-0.53125 -0.087,-0.174 -0.1835,-0.332 -0.3125,-0.375 -0.52,-0.303 -0.75775,-0.539 -0.84375,-0.625 -0.303,-0.606 -0.52625,-0.88275 -0.65625,-0.96875 -0.217,-0.13 -0.53575,-0.2695 -0.96875,-0.3125 -0.476,-0.043 -0.77625,-0.1445 -0.90625,-0.1875 -0.216,-0.129 -0.55525,-0.322 -1.03125,-0.625 l -0.53125,-0.15625 c -0.1945,-0.1735 -0.31125,-0.33225 -0.34375,-0.5 -0.0325,-0.16775 0.036,-0.31725 0.1875,-0.46875 l 0.375,-0.40625 0,-0.21875 c -0.346,-0.434 -0.735,-0.59875 -1.125,-0.46875 l -0.125,0.0937 c 0,0.043 -0.0118,0.20875 0.0312,0.46875 0,0.216 -0.039,0.38275 -0.125,0.46875 -0.174,0.087 -0.4995,0.053 -1.0625,-0.25 -0.563,-0.26 -0.952,-0.3605 -1.125,-0.1875 -0.13,0.13 -0.1105,0.48 0.0625,1 0.217,0.476 0.18475,0.85825 -0.0312,1.03125 -0.087,0.087 -0.13275,0.15625 -0.21875,0.15625 -0.087,-0.043 -0.2215,-0.0888 -0.4375,-0.21875 -0.173,-0.129 -0.3515,-0.18075 -0.4375,-0.0937 -0.216,0.087 -0.4325,0.399 -0.5625,0.875 -0.172,0.476 -0.365,0.7255 -0.625,0.8125 -0.3675,-0.065 -0.65975,-0.1855 -0.84375,-0.375 -0.184,-0.1895 -0.25975,-0.447 -0.28125,-0.75 -0.044,-0.346 0.0457,-0.60825 0.21875,-0.78125 0.087,-0.13 0.514,-0.2265 1.25,-0.3125 0.693,-0.043 1.08875,-0.158 1.21875,-0.375 0.044,-0.217 -0.0457,-0.40125 -0.21875,-0.53125 -0.346,0 -0.62,-0.0702 -0.75,-0.15625 -0.217,-0.303 -0.38275,-0.495 -0.46875,-0.625 -0.216,-0.172 -0.447,-0.22375 -0.75,-0.0937 -0.216,0.087 -0.47825,0.41075 -0.78125,0.84375 l -0.15625,0.0312 -0.125,-0.0937 c -0.087,-0.216 -0.0675,-0.47325 0.0625,-0.90625 0.217,-0.433 0.375,-0.73325 0.375,-0.90625 -0.086,-0.259 -0.13675,-0.452 -0.0937,-0.625 0.26,-0.779 0.418,-1.17575 0.375,-1.21875 l -0.0937,-0.0937 c -0.433,-0.043 -0.7545,0.1295 -1.1875,0.5625 -0.087,0.087 -0.1825,0.27125 -0.3125,0.53125 -0.173,0.346 -0.25,0.50775 -0.25,0.59375 -0.043,0.606 -0.17575,0.96375 -0.21875,1.09375 -0.173,-0.043 -0.365,-0.0118 -0.625,0.0312 -0.217,-0.087 -0.34375,-0.2595 -0.34375,-0.5625 0,-0.39 -0.0507,-0.65125 -0.0937,-0.78125 l -0.46875,-0.8125 -0.0937,-0.0625 0.0625,-0.375 0.15625,-0.21875 0.28125,-0.125 0.0625,-0.125 c 0.087,-0.26 0.0285,-0.457 -0.1875,-0.5 -0.649,-0.26 -1.08875,-0.42575 -1.21875,-0.46875 l -0.4689,-0.6565 c -0.26,-0.304 -0.49,-0.42975 -0.75,-0.34375 -0.043,0.087 -0.0937,0.0937 -0.0937,0.0937 -0.563,0.347 -0.90125,0.5195 -1.03125,0.5625 -0.347,0.044 -0.653,-0.0788 -1,-0.46875 -0.173,-0.216 -0.3125,-0.4705 -0.3125,-0.6875 l 0,-0.78125 c -0.044,-0.173 -0.2545,-0.409 -0.6875,-0.625 -0.433,-0.26 -0.71375,-0.34375 -0.84375,-0.34375 l -0.15625,-0.0625 c -0.087,-0.043 -0.163,-0.1395 -0.25,-0.3125 -0.173,-0.26 -0.211,-0.60325 -0.125,-0.90625 l 0.0937,-0.125 c 0.302,-0.13 0.687,-0.0412 1.25,0.21875 0.519,0.303 0.947,0.36825 1.25,0.28125 0.173,-0.217 0.3125,-0.37 0.3125,-0.5 -0.086,-0.217 -0.17575,-0.3895 -0.21875,-0.5625 0,-0.563 -0.0507,-0.95875 -0.0937,-1.21875 -0.086,-0.217 -0.17575,-0.36325 -0.21875,-0.40625 -0.303,-0.26 -0.68025,-0.32425 -1.15625,-0.28125 -0.173,-0.043 -0.404,-0.17075 -0.75,-0.34375 -0.26,0.086 -0.61775,0.317 -1.09375,0.75 -0.087,0 -0.15125,-0.10825 -0.28125,-0.28125 -0.216,-0.347 -0.2735,-0.70375 -0.1875,-1.09375 0.043,-0.389 0.0547,-0.73325 -0.0312,-0.90625 l -0.21875,-0.5625 c -0.043,-0.173 0.12275,-0.447 0.46875,-0.75 0.39,-0.346 0.55575,-0.812 0.46875,-1.375 -0.087,-0.737 -0.202,-1.202 -0.375,-1.375 -0.519,0 -0.81925,-0.14625 -0.90625,-0.40625 -0.086,-0.779 -0.13275,-1.3845 -0.21875,-1.6875 -0.13,-0.346 -0.207,-0.58875 -0.25,-0.71875 0,-0.216 0.0263,-0.409 0.15625,-0.625 0.174,-0.26 0.21875,-0.42575 0.21875,-0.46875 l -0.21875,-0.375 c -0.043,-0.13 -0.202,-0.48 -0.375,-1 L 104,159.28124 c -0.303,-0.563 -0.5575,-1.02125 -0.6875,-1.28125 -0.476,-0.866 -0.73325,-1.35825 -0.90625,-1.53125 -0.476,-0.606 -0.8845,-1.18025 -1.1875,-1.65625 l -0.0312,-0.1875 z",
                        "Sumy": "m 361.701,28.558 c 0.216,-0.303 0.303,-0.477 0.347,-0.563 -0.043,-0.086 -0.347,-0.346 -0.866,-0.823 -0.13,0 -0.26,0.087 -0.433,0.26 -0.26,0.347 -0.39,0.52 -0.433,0.52 -0.39,0.39 -0.91,0.303 -1.516,-0.303 0,-0.043 -0.043,-0.087 -0.043,-0.13 -0.216,0.173 -0.433,0.606 -0.563,1.255 -0.216,0.823 -0.346,1.299 -0.39,1.429 -0.216,0.303 -0.346,0.52 -0.433,0.693 l -0.39,0.736 c -0.043,0.13 -0.043,0.346 0,0.606 0.086,0.26 0.13,0.476 0.086,0.563 -0.086,0.216 -0.216,0.346 -0.26,0.39 -0.476,0.26 -0.779,0.476 -0.866,0.606 -0.173,0.216 -0.217,0.52 -0.173,0.996 v 0.563 c 0.13,0.779 0.173,1.256 0.173,1.386 l 0.086,-0.086 c 0.303,0.173 0.779,0.346 1.515,0.476 0,0 0.087,0.086 0.26,0.216 l 0.52,0.477 c 0.13,0.13 0.303,0.39 0.519,0.736 0.087,0.086 0.217,0.216 0.433,0.39 0.13,0.303 0.217,0.52 0.26,0.563 0.087,0.086 0.52,0.086 1.299,0.086 0,0.13 -0.086,0.606 -0.216,1.516 -0.563,0.39 -1.342,0.52 -2.338,0.346 l -0.13,-0.13 c 0,-0.216 -0.086,-0.39 -0.216,-0.52 -0.13,0 -0.26,0.043 -0.433,0.173 -0.086,0.086 -0.13,0.476 -0.086,1.039 0.043,0.693 0.043,1.125 0,1.342 -0.087,0.13 -0.303,0.303 -0.563,0.476 l -0.043,0.086 0.043,0.043 c 0.043,0.043 0.086,0.13 0.13,0.26 0.52,0.693 0.736,1.255 0.649,1.645 -0.087,0.13 -0.173,0.173 -0.26,0.173 -0.563,0 -0.91,0 -1.039,0.043 -0.13,0.13 -0.39,0.26 -0.736,0.39 l -1.039,0.346 -0.13,0.087 -0.043,0.13 c -0.433,0 -0.736,0 -0.909,0.086 -0.043,0.043 -0.13,0.216 -0.173,0.52 -0.91,-0.13 -1.516,-0.13 -1.862,0 -0.13,0.043 -0.173,0.216 -0.216,0.477 0,0.086 0.043,0.216 0.173,0.39 l -0.043,0.173 c -0.39,0.087 -0.692,0.173 -0.909,0.303 -0.086,0.043 -0.173,0.216 -0.216,0.476 -0.086,0.347 -0.13,0.563 -0.173,0.649 0,0 -0.173,0.173 -0.52,0.477 -0.173,0.13 -0.433,0.39 -0.736,0.779 -0.347,0.433 -0.52,0.909 -0.477,1.472 0,0.173 0.087,0.693 0.303,1.515 0.13,0.606 0.303,1.039 0.563,1.299 0.086,0.087 0.476,0.347 1.169,0.866 0.303,0.216 0.563,0.433 0.736,0.649 0.043,0.173 -0.13,0.52 -0.563,1.083 -0.13,0.086 -0.173,0.173 -0.173,0.216 -0.086,0.39 -0.043,0.649 0.13,0.736 0.173,0.043 0.346,0.087 0.52,0.043 0.13,0.217 0.173,0.563 0.173,1.169 0,0.649 0,1.083 0,1.212 0.173,0.043 0.39,0.173 0.563,0.303 0.087,0.086 0.13,0.216 0.13,0.433 -0.563,0.087 -0.91,0.173 -1.04,0.347 -0.043,0.13 0,0.476 0.087,1.125 0.476,0.347 0.736,0.606 0.822,0.693 0.043,0.086 0.173,0.216 0.303,0.347 -0.39,0.52 -0.649,0.779 -0.693,0.866 -0.606,-0.303 -1.039,-0.563 -1.342,-0.693 l -0.043,0.13 c 0.346,0.606 0.476,1.083 0.433,1.472 -0.086,0.13 -0.346,0.303 -0.779,0.433 l -0.087,0.173 c 0.087,0.39 0.087,0.78 0,1.169 l 0.087,0.13 c 0.216,0.043 0.476,0.216 0.692,0.433 l 0.043,0.173 c -0.303,0.216 -0.433,0.433 -0.433,0.606 0.217,0.477 0.303,0.909 0.173,1.299 -0.26,0.216 -0.693,0.39 -1.255,0.476 -0.52,0.043 -0.866,-0.043 -0.996,-0.39 -0.13,-0.39 -0.26,-0.693 -0.433,-0.909 -0.13,-0.043 -0.303,-0.087 -0.563,-0.087 -0.303,0.477 -0.433,0.823 -0.433,1.126 0.39,0.39 0.606,0.823 0.563,1.212 0.043,0.086 0.13,0.13 0.26,0.173 0.39,-0.086 0.606,-0.086 0.692,-0.043 0.217,0.216 0.26,0.476 0.217,0.779 -0.173,0.303 -0.303,0.563 -0.347,0.736 v 0.173 c 0.52,0.26 0.823,0.52 0.909,0.823 -0.303,0.303 -0.433,0.52 -0.476,0.606 0.26,0.476 0.346,0.779 0.346,0.996 -0.086,0.173 -0.303,0.303 -0.692,0.477 -0.433,0.13 -0.649,0.303 -0.649,0.476 0.216,0.433 0.26,0.909 0.129,1.299 -0.129,0.217 -0.476,0.39 -1.125,0.52 -0.606,0.129 -0.953,0.259 -0.996,0.346 0.26,0.216 0.26,0.606 -0.043,1.125 l 0.39,0.39 c 0.086,0.087 0.086,0.173 0.043,0.303 -0.303,0.433 -0.52,0.736 -0.606,0.953 l -0.476,0.866 0.043,0.087 c 0.52,0.086 0.953,0.173 1.342,0.346 0.26,0.086 0.736,0.26 1.472,0.606 0.477,-0.173 0.693,-0.26 0.78,-0.216 l 0.129,0.086 c 0.13,0.217 0.173,0.433 0.087,0.563 -0.477,0.173 -0.736,0.346 -0.736,0.477 l -0.043,0.173 c 0.13,0.26 0.649,0.52 1.515,0.779 0.823,0.303 1.342,0.39 1.516,0.303 0.173,-0.086 0.433,-0.649 0.866,-1.646 0.173,0.043 0.52,0.173 1.039,0.347 l 0.13,0.13 c 0,0.043 -0.303,0.52 -0.822,1.472 -0.26,0.216 -0.477,0.39 -0.606,0.563 -0.216,0.217 -0.346,0.477 -0.303,0.693 0,0.13 0.347,0.477 1.126,1.039 -0.173,0.303 -0.26,0.52 -0.303,0.649 0.217,1.559 0.173,2.468 -0.173,2.685 -0.13,0.043 -0.303,0 -0.563,-0.043 -0.217,0.433 -0.39,0.736 -0.433,0.953 0,0.39 -0.043,0.649 -0.086,0.823 l -0.433,1.125 c -0.173,0.477 -0.173,1.212 0,2.251 0.173,0.173 0.433,0.433 0.779,0.779 0.086,0.043 0.26,0.087 0.476,0.173 0,0.043 0.043,0.216 0.087,0.563 0,0.303 -0.13,0.52 -0.433,0.693 -0.433,0.26 -0.693,0.433 -0.779,0.563 0,1.169 0,1.775 -0.086,1.819 -0.477,0.13 -0.736,0.259 -0.78,0.433 0.087,0.13 0.087,0.26 0.087,0.477 0.086,0.26 0.173,0.39 0.173,0.433 0,1.04 -0.26,2.079 -0.823,3.031 -0.217,0.39 -0.433,0.736 -0.52,1.04 0,0.216 0,0.389 -0.043,0.52 l 0.476,0.216 c 0.173,0.043 0.477,0.26 0.953,0.606 0.477,-0.346 0.91,-0.433 1.256,-0.216 0.086,0.043 0.26,0.173 0.476,0.346 0,0 0.217,0.043 0.52,0.043 0.347,0 0.52,0 0.649,-0.043 0.173,-0.216 0.303,-0.649 0.39,-1.299 l 0.13,-0.13 1.429,0.043 c 0.26,0 0.433,0.086 0.563,0.346 0.086,0.13 0.173,0.347 0.303,0.649 0.086,0 0.26,0 0.52,-0.086 0.26,-0.043 0.433,-0.043 0.476,0.043 0.173,0.13 0.39,0.303 0.606,0.563 0.216,0.13 0.476,0.26 0.736,0.303 0.779,0.086 1.905,0.173 3.42,0.216 l 1.862,0.347 c 0.477,0.086 1.212,0.173 2.208,0.303 0.087,0 0.347,0.13 0.693,0.347 0.13,0.043 0.303,0.13 0.563,0.216 0.866,0.433 1.385,0.693 1.559,0.736 0.13,-0.043 0.303,-0.173 0.563,-0.52 0.216,-0.303 0.476,-0.433 0.736,-0.433 l 0.779,0.086 c 0.477,0.043 0.866,0.086 1.169,0.217 0.087,-0.217 0.087,-0.39 0.087,-0.563 -0.606,-0.346 -0.953,-0.563 -1.126,-0.649 l -0.043,-0.13 c 0.043,-0.173 0.13,-0.303 0.303,-0.39 0.217,-0.13 0.693,-0.347 1.386,-0.563 0.693,-0.303 1.169,-0.433 1.342,-0.433 l 0.129,0.087 c 0.26,0.433 0.606,0.866 1.04,1.255 0.216,0.173 0.953,0.563 2.251,1.126 0.13,0.043 0.303,0.173 0.606,0.346 0.26,0.173 0.433,0.173 0.606,0.043 0.043,-0.13 0.043,-0.26 -0.043,-0.433 -0.043,-0.173 -0.087,-0.347 0,-0.433 0.26,-0.26 0.476,-0.433 0.606,-0.39 0.217,0 0.52,0.173 0.953,0.433 0.13,-0.13 0.173,-0.346 0.086,-0.649 -0.043,-0.347 -0.086,-0.563 -0.043,-0.649 0.13,-0.087 0.476,-0.087 1.082,0.043 l 0.087,-0.39 0.086,-0.086 c 0.476,-0.13 0.866,-0.13 1.169,0.043 0.087,-0.13 0.173,-0.433 0.26,-0.78 0.26,0.13 0.736,0.303 1.386,0.52 l 0.043,0.129 c -0.129,0.65 -0.173,1.775 -0.086,3.334 0,0.39 0.217,0.866 0.649,1.472 0.043,0.043 0.303,0.347 0.779,0.866 0.13,0.086 0.303,0.26 0.477,0.563 0.26,0.217 0.693,0.606 1.342,1.039 0.346,0.39 0.52,0.736 0.52,1.04 0.043,0.173 -0.043,0.346 -0.26,0.649 -0.173,0.26 -0.26,0.476 -0.26,0.649 0.043,0.303 0.086,0.52 0.086,0.649 0.086,0.953 0.26,1.515 0.563,1.688 h 0.173 c 0,0 0.087,-0.173 0.26,-0.52 0.13,-0.216 0.26,-0.303 0.52,-0.216 0.173,0.086 0.303,0.13 0.347,0.216 0.13,0.173 0.173,0.303 0.173,0.433 l 0.043,0.649 c 0,0.043 0.13,0.13 0.433,0.216 0.086,0.086 0.13,0.433 0.086,0.996 0.649,0.173 1.083,0.346 1.342,0.52 0.347,0.303 0.433,0.692 0.303,1.255 -0.173,0.606 -0.563,0.823 -1.256,0.649 l -0.13,0.086 c -0.216,0.736 -0.303,1.256 -0.216,1.516 0.216,0 0.39,0 0.563,0.086 0,0 -0.043,0.303 -0.13,0.823 l 0.043,0.13 0.13,0.087 c 0.216,-0.043 0.433,-0.26 0.693,-0.52 0.13,-0.13 0.779,-0.26 1.948,-0.52 0.217,-0.043 0.433,0.043 0.649,0.217 0.26,0.216 0.433,0.346 0.563,0.346 0.433,0.043 1.083,0.043 1.949,0 0.303,-0.086 0.476,-0.39 0.563,-0.823 0.087,-0.52 0.216,-0.822 0.39,-0.866 h 0.173 c 0.433,0.346 0.692,0.563 0.779,0.693 l 0.216,0.043 c 0.303,-0.13 0.736,-0.39 1.212,-0.779 l 0.13,-0.043 c 0.346,-0.433 0.649,-0.606 0.866,-0.563 1.602,0.346 2.511,0.693 2.728,0.996 0.043,0 0.303,-0.13 0.823,-0.346 0.389,-0.173 0.563,-0.39 0.649,-0.563 0.13,-0.693 0.26,-1.083 0.39,-1.212 l 0.173,-0.043 c 0,0 0.086,0.13 0.216,0.303 0.086,0.13 0.303,0.303 0.606,0.52 0.346,0.26 0.606,0.347 0.693,0.347 0.086,-0.043 0.173,-0.26 0.303,-0.606 -0.217,-0.346 -0.303,-0.606 -0.39,-0.822 0,-0.087 0.173,-0.217 0.433,-0.347 0.26,-0.13 0.477,-0.26 0.693,-0.39 0.13,0 0.346,0.173 0.693,0.563 l 0.13,-0.043 c 0.13,-0.086 0.26,-0.433 0.39,-0.952 0.086,-0.433 0.303,-0.693 0.606,-0.78 0.13,-0.043 0.347,-0.086 0.563,0 l 0.52,0.043 0.779,0.39 0.477,0.39 c 0.043,0 0.303,-0.086 0.736,-0.26 0.347,-0.13 0.606,-0.26 0.736,-0.39 0.13,-0.173 0.087,-0.52 -0.173,-1.039 0,-0.086 0.043,-0.216 0.173,-0.39 0.173,-0.26 0.433,-0.303 0.823,-0.173 0.173,0.043 0.346,0.087 0.433,0.217 h 0.173 l 0.347,-0.303 v -0.13 l -0.39,-0.433 c 0,-0.13 0.26,-0.39 0.736,-0.693 0.173,-0.043 0.433,0.043 0.823,0.303 0.39,0.26 0.693,0.39 0.866,0.433 0.347,-0.26 0.433,-0.866 0.173,-1.732 l 0.086,-0.13 c 0.39,-0.216 0.996,0 1.905,0.606 0.909,0.606 1.386,0.909 1.516,0.909 l 0.086,-0.13 c 0,-0.216 -0.173,-0.476 -0.606,-0.822 0.13,-0.087 0.259,-0.13 0.433,-0.087 1.039,0.26 1.688,0.303 1.905,0.173 0.086,-0.086 0.26,-0.216 0.433,-0.39 0.129,-0.043 0.649,0.086 1.602,0.346 0.649,0.173 1.126,0.043 1.429,-0.433 0.173,-0.303 0.26,-0.563 0.173,-0.866 -0.173,0.043 -0.303,0.043 -0.346,0.043 -0.52,-0.086 -1.169,-0.347 -1.862,-0.866 -0.477,-0.259 -0.779,-0.476 -0.909,-0.649 -0.13,-0.13 -0.173,-0.563 -0.173,-1.255 -0.043,-0.779 -0.13,-1.342 -0.26,-1.732 -0.086,-0.173 -0.173,-0.26 -0.216,-0.346 -0.347,-0.39 -0.823,-0.649 -1.472,-0.736 -0.779,-0.086 -1.212,-0.216 -1.385,-0.346 -0.13,-0.086 -0.303,-0.39 -0.52,-0.909 -0.26,-0.433 -0.433,-1.169 -0.52,-2.208 -0.043,-0.087 -0.13,-0.52 -0.39,-1.299 -0.13,-0.39 -0.26,-1.039 -0.476,-1.905 l -0.173,-0.217 c -0.043,-0.173 -0.086,-0.26 -0.13,-0.26 0.043,-0.39 0.477,-0.736 1.342,-1.125 0.909,-0.39 1.429,-0.649 1.516,-0.779 -0.043,-0.087 -0.217,-0.217 -0.477,-0.346 -0.26,-0.173 -0.39,-0.347 -0.433,-0.433 -0.043,-0.13 0,-0.39 0.086,-0.866 0.13,-0.52 0.173,-0.909 0.13,-1.125 -0.087,-1.083 -0.303,-1.775 -0.736,-2.078 -0.043,0 -0.346,-0.173 -0.866,-0.477 -0.217,-0.086 -0.346,-0.216 -0.39,-0.303 -0.13,-0.129 -0.13,-0.433 -0.087,-0.866 0.087,-0.563 0.087,-0.866 0.087,-0.996 -0.043,-0.13 -0.26,-0.347 -0.563,-0.606 -0.346,-0.303 -0.52,-0.476 -0.563,-0.606 -0.043,-0.13 0,-0.52 0.13,-1.126 0.086,-0.52 0.043,-0.909 -0.087,-1.255 -0.216,-0.347 -0.433,-0.563 -0.736,-0.606 -0.39,-0.086 -0.693,-0.13 -0.909,-0.173 -0.087,-0.217 -0.043,-0.52 0.043,-0.909 0.043,-0.433 0.087,-0.693 0.043,-0.823 -0.173,-0.173 -0.303,-0.303 -0.39,-0.433 l -0.043,-0.173 0.13,-0.173 c 0.347,-0.217 0.866,-0.303 1.516,-0.303 0.303,-0.13 0.52,-0.346 0.692,-0.649 0.26,-0.476 0.13,-0.823 -0.303,-1.039 -0.087,-0.043 -0.477,-0.216 -1.256,-0.477 -0.346,-0.13 -0.52,-0.216 -0.563,-0.216 -0.086,0 -0.606,0.13 -1.515,0.39 -0.866,0.216 -1.516,0.26 -1.905,0.13 -0.433,-0.086 -0.822,-0.52 -1.082,-1.212 0,-0.173 0.043,-0.433 0.13,-0.692 -0.043,-0.52 -0.173,-0.953 -0.39,-1.342 -0.433,-0.823 -0.649,-1.256 -0.606,-1.299 -0.043,-0.26 0.043,-0.606 0.13,-1.126 0.043,-0.173 0,-0.346 -0.086,-0.606 -0.086,-0.433 -0.173,-0.736 -0.303,-0.823 -0.346,0 -0.606,0 -0.736,-0.086 -0.087,-0.173 -0.173,-0.303 -0.216,-0.39 -0.26,-0.173 -0.736,0.043 -1.559,0.563 -0.086,0 -0.346,-0.13 -0.736,-0.433 -0.39,-0.26 -0.823,-0.347 -1.299,-0.217 -0.303,0.043 -0.52,0.217 -0.649,0.433 -0.13,0.346 -0.26,0.52 -0.39,0.606 -0.087,0.043 -0.52,0.13 -1.299,0.26 -0.043,0 -0.303,0.13 -0.779,0.39 -0.303,0.087 -0.477,0.173 -0.606,0.217 -1.083,0.433 -2.381,0.476 -3.854,0.173 -0.606,-0.13 -0.909,-0.173 -0.952,-0.217 -0.13,-0.13 -0.303,-0.606 -0.52,-1.429 -0.216,-0.823 -0.346,-1.255 -0.346,-1.255 l -0.173,-0.087 c -1.429,0.347 -2.468,0.477 -3.074,0.303 -0.693,-0.303 -1.083,-0.476 -1.126,-0.52 -0.433,0.086 -0.736,0.043 -0.909,0 -0.043,0 -0.216,-0.13 -0.563,-0.346 -0.52,-0.303 -0.996,-0.433 -1.429,-0.39 -0.823,0.043 -1.342,0.217 -1.645,0.52 -0.173,0.26 -0.303,0.477 -0.39,0.606 -0.173,0.26 -0.39,0.346 -0.606,0.346 -0.346,-0.043 -0.823,-0.216 -1.429,-0.52 -0.693,-0.476 -1.169,-0.736 -1.429,-0.736 0.173,-0.087 0.476,-0.217 0.866,-0.347 0.13,-0.086 0.303,-0.173 0.52,-0.303 0.52,-0.39 0.866,-0.996 1.039,-1.688 l 0.13,-0.78 c 0.13,-0.216 0.303,-0.476 0.563,-0.736 0.13,-0.26 0,-0.52 -0.39,-0.823 l -0.043,-0.173 h -0.346 c -0.13,0 -0.39,-0.087 -0.736,-0.217 -0.736,-0.303 -1.299,-0.736 -1.645,-1.385 l -0.173,-0.217 0.043,-0.26 c 0.043,-0.043 0.216,-0.043 0.476,-0.086 0.217,0 0.39,-0.13 0.52,-0.346 0,0 0,0 0.043,-0.043 v -0.043 l 0.086,-0.606 c -0.043,-0.26 -0.129,-0.52 -0.303,-0.823 0,-0.13 0.086,-0.39 0.216,-0.736 0.13,-0.26 0.173,-0.477 0.217,-0.649 l 0.043,-0.39 c 0,-0.043 0,-0.043 0,-0.043 -0.13,-1.126 -0.26,-1.905 -0.433,-2.208 -0.13,-0.216 -0.39,-0.52 -0.822,-0.822 -0.477,-0.347 -0.736,-0.649 -0.866,-0.909 -0.216,-1.083 -0.39,-1.688 -0.433,-1.775 -0.433,-0.13 -0.779,-0.303 -0.996,-0.39 -0.52,-0.216 -0.779,-0.433 -0.822,-0.563 -0.087,-0.563 -0.043,-0.996 0.259,-1.256 0.087,-0.043 0.217,-0.086 0.39,-0.13 0.563,-0.087 0.952,-0.173 1.125,-0.217 0.26,-0.086 0.649,-0.259 1.169,-0.476 0.346,-0.043 0.909,-0.13 1.688,-0.173 0.303,-0.086 0.736,-0.26 1.299,-0.52 0.043,-0.043 0.563,0 1.516,0.043 l 0.52,-0.043 c 0.13,-0.043 0.39,-0.086 0.693,-0.086 0.823,-0.216 1.342,-0.693 1.472,-1.385 0.086,-0.433 -0.043,-0.91 -0.303,-1.472 l -0.13,-0.217 c -0.043,-0.563 -0.13,-0.909 -0.216,-1.083 -0.043,-0.086 -0.26,-0.346 -0.65,-0.822 -0.346,-0.39 -0.476,-0.606 -0.39,-0.736 -0.692,-0.26 -1.125,-0.476 -1.299,-0.52 -0.173,-0.086 -0.346,-0.346 -0.563,-0.779 -0.216,-0.39 -0.476,-0.649 -0.736,-0.693 -0.39,0.26 -0.693,0.433 -0.996,0.477 l -0.129,-0.086 c -0.087,-0.087 -0.13,-0.26 -0.13,-0.477 0.043,-0.303 0,-0.476 -0.086,-0.606 -0.043,-0.087 -0.303,-0.303 -0.822,-0.693 -0.173,-0.13 -0.433,-0.39 -0.649,-0.779 -0.26,-0.433 -0.477,-0.693 -0.65,-0.823 -0.303,-0.216 -0.692,-0.26 -1.125,-0.173 -0.52,0.043 -0.823,0.043 -0.909,0 -0.13,-0.173 -0.043,-0.39 0.26,-0.736 0.346,-0.303 0.346,-0.649 0.043,-1.083 -0.736,-0.953 -1.126,-1.602 -1.213,-1.905 -0.043,-0.13 -0.086,-0.26 -0.086,-0.477 -0.086,-0.216 -0.13,-0.346 -0.086,-0.433 0,-0.26 0.086,-0.606 0.216,-1.083 0,-0.087 -0.043,-0.347 -0.086,-0.823 -0.086,-0.346 -0.086,-0.649 0.043,-0.823 0.087,-0.173 0.303,-0.39 0.606,-0.692 0.043,-0.173 0,-0.26 0,-0.347 -0.086,-0.216 -0.26,-0.52 -0.606,-0.866 -0.043,-0.563 -0.216,-0.953 -0.476,-1.256 -0.216,-0.216 -0.52,-0.476 -1.039,-0.779 -0.996,-0.303 -1.602,-0.563 -1.775,-0.736 -0.173,-0.13 -0.346,-0.563 -0.563,-1.256 -0.26,-0.736 -0.477,-1.255 -0.779,-1.559 -0.26,-0.303 -0.606,-0.52 -1.04,-0.693 -0.433,-0.13 -0.692,-0.303 -0.866,-0.52 -0.13,-0.173 -0.26,-0.433 -0.39,-0.823 -0.173,-0.39 -0.216,-0.692 -0.173,-0.822 0,-0.217 -0.476,-0.347 -1.429,-0.39 -0.52,-0.087 -0.866,-0.087 -1.125,-0.043 -0.303,0.043 -0.52,0.086 -0.649,0.13 -0.649,0.043 -1.472,0.346 -2.425,0.823 -0.909,0.433 -1.386,0.649 -1.429,0.693 -0.649,0.822 -1.169,1.385 -1.602,1.645 -0.303,0.043 -0.52,-0.043 -0.736,-0.26 -0.265,-0.301 -0.309,-0.821 -0.179,-1.556",
                        "Sevastopol": "m 362.74245,361.41432 c -0.50619,0.63185 -0.61133,1.53551 -0.81623,2.31197 0.0522,0.71515 0.23564,1.39472 0.31184,2.11223 0.3484,1.05315 0.66809,2.32141 -0.17513,3.23547 -0.59356,0.58231 -0.19238,1.61523 0.63529,1.64049 0.16616,0.0738 0.55972,0.25157 0.52271,0.43425 -1.73856,0.48365 -3.89636,0.17073 -5.17882,1.70885 -0.45917,0.75976 0.63218,1.26941 1.09241,1.7046 1.03737,0.22058 2.15441,0.0313 3.22193,0.0967 -0.767,0.13412 -1.76747,-0.23495 -2.37243,0.29255 -0.35309,0.85487 0.91697,1.04582 1.43558,1.45249 0.58335,0.47795 1.31139,0.3566 1.92999,0.0764 0.73536,0.25471 1.05619,1.1619 1.43544,1.78927 0.26705,0.48803 0.0956,1.3 0.84035,1.40729 0.7336,0.0593 1.28859,0.57397 1.68874,1.14191 0.77068,0.49034 1.39182,-0.50557 1.73298,-1.0615 0.35617,-0.45053 0.94168,0.22417 1.3912,-0.18093 0.80137,-0.53816 1.82301,0.64898 2.55725,-0.0844 0.3026,-0.80696 -0.45066,-1.58169 -0.94892,-2.11093 -0.13354,-0.7861 -0.69373,-1.39201 -1.12985,-2.00237 0.0377,-0.8197 -0.52682,-1.48601 -0.60312,-2.27579 -0.32154,-0.91312 -1.4084,-0.8631 -2.16723,-0.9851 -0.50886,-0.6143 -0.73149,-1.67538 0.0716,-2.16196 0.48861,-0.41802 0.80745,-0.98404 0.96575,-1.58142 0.70357,-0.39024 0.36707,-1.20439 -0.28548,-1.40729 -1.17549,-0.55252 -2.57175,-0.24228 -3.8037,-0.5589 -0.60104,0.008 -0.27697,-0.80594 -0.36992,-1.17006 -0.0555,-0.62795 0.84856,-0.49483 1.25048,-0.73179 0.53915,-0.10099 1.49219,-0.51063 0.96902,-1.19418 -0.9688,-0.61646 -2.3375,-0.55448 -3.15635,-1.39523 -0.19904,-0.37827 -0.58554,-0.76794 -1.04541,-0.5026 z",
			"Rivne": "m 125.907,46.872 c -0.043,0.606 -0.043,0.953 0,1.039 0.043,0.043 0.649,0.13 1.775,0.173 1.126,0.043 1.732,0.086 1.862,0.173 -0.476,0.26 -0.736,0.39 -0.823,0.477 -0.303,0.173 -0.39,0.476 -0.39,0.823 0.043,0.086 0.13,0.39 0.303,0.952 0.13,0.217 0.216,0.433 0.173,0.606 -0.087,0.693 -0.477,1.255 -1.04,1.732 -0.389,0.303 -0.692,0.476 -0.822,0.649 -0.217,0.173 -0.563,0.649 -1.04,1.299 -0.519,0.649 -0.822,1.039 -0.866,1.212 -0.086,0.26 -0.173,0.692 -0.26,1.342 -0.043,0.823 -0.086,1.472 0,2.035 0,0.52 0,0.823 0.086,0.953 0.087,0.216 0.347,0.346 0.78,0.39 0.259,0 0.476,-0.043 0.649,-0.173 0.043,0.433 0.086,0.693 0.216,0.779 0.39,0 0.693,0.13 0.953,0.39 0.303,0.52 0.173,0.996 -0.347,1.472 -0.692,0.606 -1.039,1.039 -1.082,1.342 -0.087,0.347 0,0.866 0.173,1.472 0.217,0.693 0.346,1.212 0.346,1.472 -0.173,0.606 -0.216,1.039 -0.216,1.385 0.043,0.52 0.043,0.909 0.043,1.212 0,0.13 -0.043,0.606 -0.217,1.516 -0.086,0.303 0,0.649 0.13,0.952 0.173,0.303 0.433,0.477 0.736,0.52 0.173,-0.043 0.303,-0.216 0.39,-0.52 0.13,-0.346 0.216,-0.606 0.303,-0.692 0.736,-0.477 1.385,-0.563 1.992,-0.303 0.476,0.13 0.779,0.216 0.952,0.13 l 0.433,-0.39 c 0.043,-0.087 0.13,-0.26 0.216,-0.52 0.13,-0.217 0.26,-0.303 0.477,-0.217 l 0.13,0.043 c -0.043,0.649 0.39,0.866 1.299,0.779 0.52,-0.476 0.823,-0.693 0.953,-0.736 l 0.13,0.13 c 0,0.043 -0.087,0.303 -0.26,0.823 -0.347,0.822 -0.433,1.342 -0.347,1.645 0.13,0.26 0.26,0.433 0.347,0.476 0.693,0.26 1.039,0.477 1.083,0.649 l 0.086,0.65 c 0,0.13 0.173,0.26 0.39,0.476 0.606,0.433 1.039,0.823 1.299,1.212 0.13,0.26 0.217,0.433 0.347,0.476 l 1.385,0.606 c 0.173,0.086 0.26,0.13 0.346,0.173 l 0.52,0.26 c 0.216,0.217 0.39,0.433 0.519,0.52 0.477,0.39 0.78,0.693 1.039,0.909 0.13,0.087 0.174,0.433 0.13,0.996 0,0.216 0,0.433 0,0.52 -0.13,0.606 -0.606,0.996 -1.472,1.212 -0.649,0.173 -1.256,0.26 -1.818,0.216 -0.043,0.086 -0.043,0.26 0,0.477 0,0.39 -0.043,0.866 -0.173,1.515 0.303,0.043 0.649,0.216 1.039,0.433 0.13,0 0.26,-0.086 0.476,-0.217 0.173,-0.173 0.477,-0.26 0.866,-0.303 1.039,0.563 1.559,1.385 1.602,2.511 l 0.346,0.303 c -0.043,0 0,0.303 0.086,0.822 0.087,0.606 0.043,0.953 -0.13,1.083 -0.39,0 -0.953,0.086 -1.731,0.26 l -1.256,0.173 c -0.13,0 -0.26,0.086 -0.39,0.303 -0.216,0.26 -0.13,0.52 0.217,0.779 0.433,0.303 0.649,0.52 0.692,0.65 0.173,0.043 0.303,0.26 0.26,0.52 0,0.043 -0.043,0.216 -0.086,0.563 -0.043,0.13 -0.303,0.26 -0.649,0.477 -0.39,0.26 -0.693,0.563 -0.866,0.953 v 0.173 c 0.087,0.173 0.347,0.347 0.779,0.52 0.347,0.173 0.52,0.303 0.563,0.433 -0.216,0.39 -0.39,0.606 -0.52,0.736 -0.086,0 -0.26,-0.043 -0.52,-0.173 -0.216,-0.087 -0.433,-0.13 -0.693,-0.087 -0.086,0 -0.476,0.26 -1.039,0.823 -0.216,0.13 -0.606,0.39 -1.169,0.649 l -0.13,0.303 c -0.043,0.086 -0.043,0.216 0,0.433 -0.13,0.952 -0.13,1.559 -0.13,1.861 l 0.13,0.823 c 0.13,0.563 0.086,0.953 -0.13,1.169 -0.347,0.477 -0.52,0.736 -0.563,0.866 -0.043,0.13 -0.13,0.649 -0.216,1.559 -0.043,0.13 -0.13,0.217 -0.26,0.26 -0.26,0.086 -0.563,0 -0.866,-0.26 -0.217,-0.13 -0.433,-0.39 -0.736,-0.693 l -0.39,-0.26 c -0.086,-0.086 -0.563,-0.173 -1.386,-0.26 -0.086,0 -0.173,-0.086 -0.216,-0.173 l 0.13,-0.303 v -0.13 c -0.346,-0.433 -0.649,-0.736 -0.823,-0.953 -0.303,-0.26 -0.736,-0.433 -1.385,-0.433 -0.736,0 -1.169,0.043 -1.386,0.087 -0.13,0.173 -0.303,0.39 -0.476,0.779 -0.217,0.086 -0.563,0.173 -0.996,0.26 -0.13,0 -0.303,0.13 -0.52,0.26 -0.216,0.086 -0.52,0.216 -0.909,0.346 -0.174,0 -0.26,0.043 -0.303,0.086 -0.173,0.173 -0.303,0.39 -0.39,0.693 l -0.173,0.043 c -0.39,-0.13 -0.909,-0.26 -1.602,-0.39 -0.52,-0.173 -0.953,-0.476 -1.342,-0.953 l -0.216,-0.043 -0.043,0.13 c 0.26,0.563 0.39,0.953 0.26,1.212 -0.086,0.13 -0.26,0.26 -0.433,0.347 -0.086,0.043 -0.086,0.173 -0.086,0.303 0.086,0.13 0.303,0.303 0.823,0.649 0.346,0.217 0.476,0.433 0.303,0.606 l -0.173,0.043 c -0.13,-0.043 -0.953,-0.173 -2.468,-0.39 -0.173,-0.043 -0.347,0.043 -0.39,0.26 0,0.13 0.087,0.346 0.26,0.606 0.216,0.433 0.389,0.823 0.433,1.083 0.13,0.866 -0.086,1.342 -0.649,1.429 -0.693,0.13 -1.862,0 -3.507,-0.433 -0.433,-0.13 -0.693,-0.173 -0.823,-0.13 -0.173,0.087 -0.346,0.39 -0.606,0.823 v 0.13 c 0.779,0.52 1.255,0.953 1.472,1.255 l 0.087,0.173 c -0.087,0.26 -0.303,0.563 -0.606,0.953 -0.347,0.476 -0.693,0.649 -0.91,0.563 -0.39,-0.13 -0.606,-0.13 -0.779,-0.043 l -0.043,0.13 c 0,0.173 0.216,0.39 0.692,0.736 0.477,0.347 0.736,0.649 0.866,0.823 l 0.692,1.299 c 0.52,0.13 0.823,0.217 0.996,0.303 l 0.13,0.26 -0.087,0.779 c 0,0.217 -0.216,0.303 -0.519,0.26 -0.433,-0.086 -0.649,-0.086 -0.736,-0.043 -0.13,0.086 -0.346,0.389 -0.563,0.909 -0.13,0.26 -0.866,0.909 -2.252,1.948 0,0.086 0,0.13 0,0.173 0,0.26 0,0.433 0.087,0.52 0.043,0 0.216,0.043 0.52,0.13 0.563,0.13 0.996,0.086 1.342,-0.13 0.476,-0.303 0.822,-0.476 0.996,-0.52 0.043,0 0.217,0 0.52,0.087 0.39,0.086 0.649,0.346 0.823,0.779 0.13,0.346 0.13,0.736 0,1.126 -0.086,0.216 -0.39,0.52 -0.823,0.909 -0.39,0.347 -0.563,0.65 -0.563,0.91 0.043,0 0.216,0.216 0.563,0.52 0.303,0.26 0.433,0.433 0.433,0.563 -0.216,0.823 -0.346,1.472 -0.346,1.992 0,0.433 0.13,1.083 0.346,1.948 0.216,0.13 0.433,0.26 0.563,0.347 0.39,0.303 0.692,0.563 0.909,0.736 l 0.086,0.13 c 0.173,0.087 0.52,0.433 1.083,0.996 0.086,0.043 0.39,0.26 1.039,0.649 0.563,0.303 1.039,0.52 1.299,0.649 l 0.13,0.173 c 0,-0.173 0.043,-0.52 0.086,-1.04 l 0.13,-0.086 c 0.346,-0.043 0.606,0.043 0.736,0.13 0.13,0.217 0.173,0.346 0.173,0.39 l 0.173,0.087 c 0.086,-0.563 0.129,-0.953 0.086,-1.126 -0.043,-0.26 -0.043,-0.39 -0.043,-0.52 l 0.043,-0.346 0.216,-0.217 c 0.563,0 0.866,-0.086 0.996,-0.216 0,-0.476 0.086,-0.866 0.39,-1.125 v -0.173 l -0.087,-0.087 c 0,-0.043 -0.216,-0.173 -0.476,-0.433 -0.39,-0.303 -0.39,-0.866 0,-1.732 0.086,-0.217 0.216,-0.346 0.346,-0.346 0.779,0.043 1.256,0.043 1.386,0.129 l 0.043,0.13 c 0,0.087 0,0.217 0.043,0.303 0.13,0.173 0.346,0.173 0.563,0.13 0.26,-0.13 0.476,-0.173 0.52,-0.13 0.086,0.347 0.173,0.563 0.303,0.649 l 0.216,0.043 c 0.52,-0.52 0.996,-0.909 1.342,-1.126 h 0.13 l 0.086,0.13 c 0.043,0.217 0.13,0.39 0.26,0.52 0.087,0.087 0.216,0.087 0.347,0.087 l 0.13,-0.13 c 0.303,-0.39 0.563,-0.649 0.692,-0.736 0.303,-0.26 1.169,-0.39 2.598,-0.39 0.173,0.043 0.303,0.043 0.433,0.043 0.91,0 1.559,-0.26 2.035,-0.779 0.736,-0.736 1.299,-1.299 1.645,-1.688 0.39,-0.433 0.693,-0.779 0.996,-1.039 0.52,-0.52 0.909,-0.693 1.255,-0.563 0.477,0.649 0.996,0.866 1.559,0.606 0.736,-0.39 1.169,-0.606 1.256,-0.563 0.303,0.043 0.476,0.13 0.563,0.13 1.212,0.736 1.992,1.039 2.294,0.952 l 0.693,-0.216 c 0.346,-0.173 0.693,-0.433 0.953,-0.779 l 0.13,-0.043 0.086,0.13 c 0.217,0.39 0.303,0.649 0.303,0.693 -0.043,0.086 -0.217,0.303 -0.52,0.606 -0.476,0.52 -0.649,1.126 -0.476,1.775 l 0.822,0.13 0.087,0.086 c 0.086,0.953 0.13,1.516 0.086,1.646 0.52,-0.346 0.866,-0.563 1.039,-0.649 0.347,-0.086 0.606,-0.13 0.779,-0.217 0.303,-0.13 0.606,-0.52 0.953,-1.125 0.779,-1.385 1.559,-2.208 2.251,-2.555 0.39,0.13 0.693,0.217 0.866,0.26 0.13,0.043 0.346,0.043 0.693,-0.043 l 0.563,-0.086 c 0.13,-0.043 0.52,-0.52 1.255,-1.516 0.52,-0.216 0.909,-0.39 1.083,-0.52 0.13,-0.087 0.303,-0.346 0.52,-0.779 0.216,-0.477 0.39,-0.779 0.563,-0.909 0.866,-0.52 1.385,-0.866 1.515,-1.083 0.13,-0.217 0.173,-0.433 0.173,-0.693 -0.043,-0.216 -0.043,-0.39 0,-0.476 0.13,-0.13 0.476,-0.26 0.996,-0.39 0.433,-0.087 0.693,-0.303 0.693,-0.606 l 0.086,-0.953 c 0.043,-0.13 0.26,-0.216 0.649,-0.346 0.043,-0.086 0.087,-0.346 0.13,-0.866 0,-0.39 0.13,-0.606 0.303,-0.649 0.173,0 0.39,0.13 0.693,0.346 0.216,0.216 0.52,0.26 0.866,0.13 l 0.087,-0.086 c 0,-0.173 0,-0.477 -0.087,-0.909 -0.043,-0.26 0.043,-0.563 0.303,-0.866 0.13,-0.13 0.217,-0.173 0.26,-0.173 0.563,0 0.866,0 0.909,-0.043 0.433,-0.26 0.693,-0.477 0.866,-0.606 0.346,-0.346 0.649,-0.563 0.823,-0.606 0.13,0.043 0.476,0.216 1.083,0.563 0.433,0.26 0.822,0.303 1.125,0.173 0.216,-0.13 0.39,-0.346 0.563,-0.736 0.129,-0.086 0.303,-0.26 0.563,-0.433 0.13,-0.086 0.433,-0.216 0.996,-0.39 0.433,-0.13 0.692,-0.26 0.736,-0.346 0.043,-0.563 0.216,-0.909 0.433,-1.126 0.086,-0.086 0.303,-0.086 0.606,-0.086 0.347,0.043 0.52,0.086 0.563,0.216 0.086,0.087 0.086,0.303 0.086,0.693 -0.043,0.39 -0.043,0.649 -0.043,0.736 0.043,0.043 0.303,0.173 0.866,0.259 0.476,0.13 0.779,0.173 0.909,0.173 v -0.043 c 0.087,-0.043 0.347,-0.303 0.823,-0.779 0.303,-0.303 0.476,-0.606 0.52,-0.822 0,-0.13 0,-0.217 0,-0.26 -0.13,-0.173 -0.39,-0.39 -0.779,-0.563 -0.39,-0.216 -0.606,-0.39 -0.693,-0.563 -0.043,-0.173 0,-0.26 0.043,-0.346 0.303,-0.477 0.476,-0.823 0.563,-0.953 0.043,-0.173 0.086,-0.39 0.086,-0.693 0.173,-0.173 0.433,-0.476 0.736,-0.822 0.563,-0.953 0.866,-1.559 0.953,-1.862 0.087,-0.173 0.13,-0.433 0.173,-0.736 0.043,-0.346 -0.086,-0.736 -0.346,-1.169 -0.087,-0.043 -0.173,-0.173 -0.303,-0.303 -0.563,-0.822 -0.866,-1.472 -0.866,-1.905 -0.043,-0.303 0,-0.736 0.173,-1.299 0.216,-0.953 0.347,-1.602 0.39,-2.079 0.043,-0.216 -0.216,-0.649 -0.736,-1.255 -0.087,-0.086 -0.13,-0.173 -0.13,-0.26 l 0.086,-0.13 c 0.563,0.043 0.779,-0.13 0.736,-0.563 -0.087,-0.173 -0.303,-0.346 -0.65,-0.606 -0.086,-0.173 -0.086,-0.477 0,-0.866 -0.13,-0.303 -0.346,-0.692 -0.692,-1.169 0.303,-0.216 0.476,-0.52 0.52,-0.866 0.086,-0.347 0.173,-0.563 0.303,-0.693 0.26,-0.173 0.736,-0.303 1.472,-0.346 0.216,-0.087 0.563,-0.26 1.039,-0.563 0.13,-0.086 0.173,-0.433 0.26,-1.039 0.043,-0.087 0.347,-0.433 0.953,-1.039 0.087,-0.087 0.13,-0.39 0.13,-0.91 0,-0.606 0.043,-0.996 0.173,-1.169 0.13,-0.346 0.433,-0.692 0.909,-1.125 0.043,-0.087 0.086,-0.26 0.086,-0.563 0.043,-0.303 0.13,-0.52 0.217,-0.693 0.129,-0.13 0.39,-0.303 0.866,-0.563 0.346,-0.173 0.563,-0.477 0.693,-0.866 0.13,-0.52 0.043,-1.169 -0.347,-1.861 -0.476,-0.823 -0.736,-1.342 -0.779,-1.473 l 0.087,-0.13 c 0.173,-0.086 0.649,-0.173 1.299,-0.259 0.433,-0.087 0.779,-0.303 1.125,-0.693 0.13,-0.173 0.217,-0.347 0.303,-0.477 0.087,-0.303 0.13,-0.52 0.087,-0.649 -0.087,-0.173 -0.217,-0.303 -0.477,-0.476 -0.26,-0.216 -0.39,-0.346 -0.433,-0.52 0,-0.216 0.086,-0.563 0.26,-1.039 l 0.173,-0.736 c 0,-0.173 0.043,-0.433 0.043,-0.736 l 0.13,-0.347 c 0,-0.086 0.086,-0.173 0.216,-0.216 0.173,0 0.346,0.13 0.563,0.39 0.173,0.26 0.26,0.477 0.26,0.693 0.13,0.173 0.39,0.433 0.822,0.779 0.477,0.346 0.78,0.563 0.996,0.606 l 0.13,-0.043 c 0.086,-0.477 0,-0.823 -0.216,-1.039 -0.173,-0.173 -0.433,-0.433 -0.823,-0.779 0,-0.13 0.043,-0.477 0.216,-0.953 0.13,-0.52 0.217,-0.779 0.303,-0.909 0.173,-0.13 0.39,-0.217 0.693,-0.26 l 0.476,-0.26 c 0.13,-0.087 0.216,-0.13 0.26,-0.13 0,0 0.26,-0.043 0.693,-0.087 0.346,-0.043 0.606,-0.216 0.779,-0.476 l 0.779,-2.251 c 0.043,-0.086 0.173,-0.26 0.39,-0.52 0.13,-0.26 0.217,-0.52 0.173,-0.823 -0.043,-0.476 -0.433,-0.779 -1.169,-0.866 -0.866,-0.043 -1.428,-0.087 -1.645,-0.173 -0.693,-0.346 -1.212,-0.606 -1.559,-0.693 -0.043,-0.043 -0.39,-0.043 -0.996,-0.13 -0.39,-0.043 -0.693,-0.13 -0.866,-0.303 h -0.216 c -0.649,-0.087 -1.039,-0.087 -1.169,0 -0.086,0.692 -0.216,1.039 -0.303,1.125 -0.173,0.13 -0.52,0.216 -1.126,0.26 -0.563,0.086 -0.952,0.086 -1.169,0 -0.346,-0.173 -0.649,-0.26 -0.866,-0.26 -0.086,0 -0.52,0.086 -1.256,0.303 -0.563,0.13 -0.953,0.043 -1.169,-0.217 -0.043,-0.173 0.13,-0.476 0.477,-1.039 0.303,-0.476 0.433,-0.909 0.303,-1.255 -0.086,-0.347 -0.563,-0.433 -1.385,-0.39 -0.823,0.086 -1.342,-0.043 -1.516,-0.303 -0.13,-0.216 -0.086,-0.996 0.173,-2.295 v -0.952 c 0,-0.13 -0.043,-0.347 -0.173,-0.606 -0.13,-0.216 -0.996,-0.39 -2.468,-0.52 -0.649,-0.086 -0.996,-0.13 -1.083,-0.13 -0.52,-0.043 -1.169,0 -1.862,0.13 -0.216,0 -0.563,0.173 -0.996,0.477 -0.39,0.26 -0.736,0.39 -1.039,0.39 -0.823,0 -2.555,-0.563 -5.239,-1.646 -0.087,-0.043 -0.39,-0.216 -0.823,-0.433 -0.433,-0.26 -0.996,-0.476 -1.646,-0.649 -0.26,-0.086 -0.649,-0.26 -1.125,-0.433 -0.433,-0.13 -1.169,-0.086 -2.165,0.043 -1.299,0.217 -2.035,0.303 -2.294,0.303 -0.779,0 -1.342,-0.043 -1.603,-0.13 -0.216,-0.217 -0.259,-0.823 -0.129,-1.775 -0.173,-0.26 -1.212,-0.303 -3.031,-0.13 -0.303,0.043 -0.779,0.13 -1.429,0.217 -0.217,0 -0.606,-0.087 -1.083,-0.303 -0.173,-0.043 -0.563,-0.043 -1.212,0.043 -0.52,0.043 -0.953,-0.043 -1.256,-0.217 -0.433,-0.303 -0.736,-0.563 -0.909,-0.822 -0.043,-0.087 -0.13,-0.217 -0.216,-0.39 -0.13,-0.129 -0.26,-0.303 -0.52,-0.563 -0.043,-0.087 -0.13,-0.216 -0.216,-0.39 0,-0.087 -0.087,-0.13 -0.26,-0.173 -0.13,-0.043 -0.26,-0.043 -0.39,-0.043 -0.087,0.043 -0.26,0.087 -0.433,0.173 -0.563,0.173 -1.256,0.217 -2.122,0.13 -0.347,-0.043 -0.823,-0.086 -1.429,-0.173 -0.043,-0.043 -0.13,-0.043 -0.26,0 -0.26,-0.043 -0.606,-0.13 -1.125,-0.303 -0.173,0 -0.476,-0.043 -0.823,-0.043 -0.649,-0.173 -1.429,-0.39 -2.338,-0.649 -0.13,-0.043 -0.346,-0.043 -0.606,-0.086 -0.303,0.043 -0.78,0.216 -1.516,0.606 -0.303,0.086 -0.736,0.13 -1.342,0.13 -0.303,0 -0.736,0 -1.342,0 -0.303,0 -0.822,0.086 -1.472,0.173 -0.251,-0.043 -0.684,-0.087 -1.16,-0.173",
                        "Ternopil": "m 101.1875,154.62499 0.0312,0.1875 c 0.303,0.476 0.7115,1.05025 1.1875,1.65625 0.173,0.173 0.43025,0.66525 0.90625,1.53125 0.13,0.26 0.3845,0.71825 0.6875,1.28125 l 0.3125,0.90625 c 0.173,0.52 0.332,0.87 0.375,1 l 0.21875,0.375 c 0,0.043 -0.0447,0.20875 -0.21875,0.46875 -0.13,0.216 -0.15625,0.409 -0.15625,0.625 0.043,0.13 0.12,0.37275 0.25,0.71875 0.086,0.303 0.13275,0.9085 0.21875,1.6875 0.087,0.26 0.38725,0.40625 0.90625,0.40625 0.173,0.173 0.288,0.638 0.375,1.375 0.087,0.563 -0.0787,1.029 -0.46875,1.375 -0.346,0.303 -0.51175,0.577 -0.46875,0.75 l 0.21875,0.5625 c 0.086,0.173 0.0743,0.51725 0.0312,0.90625 -0.086,0.39 -0.0285,0.74675 0.1875,1.09375 0.13,0.173 0.19425,0.28125 0.28125,0.28125 0.476,-0.433 0.83375,-0.664 1.09375,-0.75 0.346,0.173 0.577,0.30075 0.75,0.34375 0.476,-0.043 0.85325,0.0213 1.15625,0.28125 0.043,0.043 0.13275,0.18925 0.21875,0.40625 0.043,0.26 0.0937,0.65575 0.0937,1.21875 0.043,0.173 0.13275,0.3455 0.21875,0.5625 0,0.13 -0.1395,0.283 -0.3125,0.5 -0.303,0.087 -0.731,0.0217 -1.25,-0.28125 -0.563,-0.26 -0.948,-0.34875 -1.25,-0.21875 l -0.0936,0.125 c -0.086,0.303 -0.048,0.64625 0.125,0.90625 0.087,0.173 0.163,0.2695 0.25,0.3125 l 0.15625,0.0625 c 0.13,0 0.41075,0.0838 0.84375,0.34375 0.433,0.216 0.6435,0.452 0.6875,0.625 l 0,0.78125 c 0,0.217 0.1395,0.4715 0.3125,0.6875 0.347,0.39 0.653,0.51275 1,0.46875 0.13,-0.043 0.46825,-0.2155 1.03125,-0.5625 0,0 0.0507,-0.007 0.0937,-0.0937 0.26,-0.086 0.49,0.0397 0.75,0.34375 l 0.46875,0.65625 c 0.13,0.043 0.56975,0.20875 1.21875,0.46875 0.216,0.043 0.2745,0.24 0.1875,0.5 l -0.0625,0.125 -0.28125,0.125 -0.15625,0.21875 -0.0625,0.375 0.0937,0.0625 0.46875,0.8125 c 0.043,0.13 0.0937,0.39125 0.0937,0.78125 0,0.303 0.12675,0.4755 0.34375,0.5625 0.26,-0.043 0.452,-0.0743 0.625,-0.0312 0.043,-0.13 0.17575,-0.48775 0.21875,-1.09375 0,-0.086 0.077,-0.24775 0.25,-0.59375 0.13,-0.26 0.2255,-0.44425 0.3125,-0.53125 0.433,-0.433 0.7545,-0.6055 1.1875,-0.5625 l 0.0937,0.0937 c 0.043,0.043 -0.115,0.43975 -0.375,1.21875 -0.043,0.173 0.008,0.366 0.0937,0.625 0,0.173 -0.158,0.47325 -0.375,0.90625 -0.13,0.433 -0.1495,0.69025 -0.0625,0.90625 l 0.125,0.0937 0.15625,-0.0312 c 0.303,-0.433 0.56525,-0.75675 0.78125,-0.84375 0.303,-0.13 0.534,-0.0782 0.75,0.0937 0.086,0.13 0.25175,0.322 0.46875,0.625 0.13,0.086 0.404,0.15625 0.75,0.15625 0.173,0.13 0.26275,0.31425 0.21875,0.53125 -0.13,0.217 -0.52575,0.332 -1.21875,0.375 -0.736,0.086 -1.163,0.1825 -1.25,0.3125 -0.173,0.173 -0.26275,0.43525 -0.21875,0.78125 0.0215,0.303 0.0973,0.5605 0.28125,0.75 0.184,0.1895 0.47625,0.31 0.84375,0.375 0.26,-0.087 0.453,-0.3365 0.625,-0.8125 0.13,-0.476 0.3465,-0.788 0.5625,-0.875 0.086,-0.087 0.2645,-0.0352 0.4375,0.0937 0.216,0.13 0.3505,0.17575 0.4375,0.21875 0.086,0 0.13175,-0.0693 0.21875,-0.15625 0.216,-0.173 0.24825,-0.55525 0.0312,-1.03125 -0.173,-0.52 -0.1925,-0.87 -0.0625,-1 0.173,-0.173 0.562,-0.0725 1.125,0.1875 0.563,0.303 0.8885,0.337 1.0625,0.25 0.086,-0.086 0.125,-0.25275 0.125,-0.46875 -0.043,-0.26 -0.0312,-0.42575 -0.0312,-0.46875 l 0.125,-0.0937 c 0.39,-0.13 0.779,0.0348 1.125,0.46875 l 0,0.21875 -0.375,0.40625 c -0.1515,0.1515 -0.22,0.301 -0.1875,0.46875 0.0325,0.16775 0.14925,0.3265 0.34375,0.5 L 124,184.78124 c 0.476,0.303 0.81525,0.496 1.03125,0.625 0.13,0.043 0.43025,0.1445 0.90625,0.1875 0.433,0.043 0.75175,0.1825 0.96875,0.3125 0.13,0.086 0.35325,0.36275 0.65625,0.96875 0.086,0.086 0.32375,0.322 0.84375,0.625 0.129,0.043 0.2255,0.201 0.3125,0.375 0.087,0.216 0.087,0.40125 0,0.53125 -0.39,0.26 -0.59375,0.5095 -0.59375,0.8125 0,0.13 0.158,0.2255 0.375,0.3125 0.216,0.087 0.4325,0.2215 0.5625,0.4375 l 0,0.34375 c -0.087,0.173 -0.22825,0.33375 -0.53125,0.59375 l -0.0312,0 0,0.0312 c -0.009,0.0606 0.0883,0.0468 0.0937,0.0937 0.0216,0.18794 0.063,0.3406 0.375,0.375 0.433,-0.043 0.65125,-0.0625 0.78125,-0.0625 0.736,0.13 1.18925,0.327 1.40625,0.5 0,0.086 0.0693,0.3355 0.15625,0.8125 0.13,0.433 0.3415,0.5675 0.6875,0.4375 0.173,-0.173 0.3125,-0.409 0.3125,-0.625 0.043,-0.346 0.081,-0.5575 0.125,-0.6875 0.13,-0.26 0.35325,-0.3945 0.65625,-0.4375 0.26,0 0.5145,0.0955 0.6875,0.3125 0.303,0.303 0.58475,0.69975 0.84375,1.21875 0.043,0.087 0.24775,0.32875 0.59375,0.71875 l 0.0312,0.15635 c 0,0.13 -0.038,0.245 -0.125,0.375 0,0.173 0.008,0.3075 0.0937,0.4375 l 0.125,0.0312 c 0.433,-0.043 0.6435,-0.0743 0.6875,-0.0312 0.26,0.13 0.44425,0.2695 0.53125,0.3125 0.649,0.26 1.154,0.2405 1.5,-0.0625 0.217,-0.216 0.452,-0.682 0.625,-1.375 0.043,0 0.2155,0.0955 0.5625,0.3125 0.26,0.13 0.50275,0.13 0.71875,0 0.216,-0.866 0.44025,-1.33875 0.65625,-1.46875 l 0.1875,0 c 0.086,0.086 0.17075,0.20875 0.34375,0.46875 0,0.173 -0.007,0.41575 -0.0937,0.71875 0.043,0.043 0.082,0.1775 0.125,0.4375 l 0.0312,0.25 c -0.303,0.347 -0.457,0.697 -0.5,1 0,0.043 0.0888,0.2595 0.21875,0.5625 l 0.21875,0.40625 c 0.043,0.086 0.2155,0.24 0.5625,0.5 0.606,0.476 1.02125,0.54625 1.28125,0.15625 0.086,-0.13 0.1055,-0.3465 0.0625,-0.5625 -0.129,-0.13 -0.21875,-0.25775 -0.21875,-0.34375 -0.649,-1.169 -0.79525,-1.908 -0.40625,-2.125 0.217,-0.087 0.4275,0.003 0.6875,0.21875 l 0.5,0.375 c 0.13,0.086 0.087,0.5335 0,1.3125 -0.12258,0.73455 -0.0485,1.24414 0.25,1.59375 l 0.0937,0.125 c 0.433,0.303 1.02175,0.3605 1.84375,0.1875 0.823,-0.173 1.33775,-0.2315 1.46875,-0.1875 0.346,0.39 0.64625,0.65125 0.90625,0.78125 0.433,0 0.707,-0.0118 0.75,0.0312 0.563,0.303 0.913,0.4375 1,0.4375 0.13,-0.043 0.29475,-0.17075 0.46875,-0.34375 0.173,-0.216 0.30075,-0.38275 0.34375,-0.46875 l 0.0625,0 c -0.086,-0.087 -0.279,-0.322 -0.625,-0.625 0,-0.476 -0.1775,-0.85325 -0.4375,-1.15625 l 0,-0.125 0.21875,-0.1875 0.1875,0.0625 c 0.13,0 0.2255,-0.008 0.3125,-0.0937 l 0.0312,-0.125 -0.0312,-0.1875 c -0.476,-0.086 -0.788,-0.3025 -0.875,-0.5625 -0.736,-0.26 -1.2255,-0.5105 -1.3125,-0.8125 0.26,-0.433 0.457,-0.9185 0.5,-1.4375 0.043,-0.13 0.043,-0.25675 0,-0.34375 l -0.15615,0.0312 c -0.26,0.39 -0.5095,0.5675 -0.8125,0.4375 -0.086,-0.043 -0.1435,-0.13275 -0.1875,-0.21875 0,-0.303 0.0888,-0.5145 0.21875,-0.6875 l 0,-0.15625 -0.0625,-0.0937 c -0.5195,0.0215 -0.918,-0.0811 -1.15625,-0.28125 -0.23825,-0.20012 -0.32475,-0.5045 -0.28125,-0.9375 0.086,-0.26 0.17575,-0.46475 0.21875,-0.59375 0.043,-0.173 0.043,-0.6575 0,-1.4375 0.216,-0.346 0.34375,-0.577 0.34375,-0.75 -0.043,-0.043 -0.2555,-0.28575 -0.6875,-0.71875 -0.217,-0.216 -0.139,-0.53575 0.25,-0.96875 -0.043,-0.26 -0.0312,-0.413 -0.0312,-0.5 0.433,0.087 0.6815,0.005 0.8125,-0.125 l 0,-0.1875 -0.0312,-0.125 c -0.606,-0.173 -0.9325,-0.33875 -1.0625,-0.46875 -0.043,-0.13 -0.082,-0.23725 -0.125,-0.28125 -0.26,-0.346 -0.38675,-0.496 -0.34375,-0.625 0.043,-0.953 0.082,-1.4755 0.125,-1.5625 0.13,-0.433 0.1875,-0.73325 0.1875,-0.90625 l -0.0625,-0.15625 -0.15625,-0.0625 -0.5625,0.25 -0.125,-0.0312 c -0.086,-0.13 -0.0665,-0.37275 0.0625,-0.71875 0.173,-0.39 0.28125,-0.63175 0.28125,-0.71875 0.043,-0.217 -0.0457,-0.409 -0.21875,-0.625 -0.26,-0.216 -0.36225,-0.36325 -0.40625,-0.40625 0.043,-0.129 0.1015,-0.23825 0.1875,-0.28125 l 0.4375,-0.125 0.0937,-0.125 c 0.043,-0.13 -0.0145,-0.31425 -0.1875,-0.53125 -0.173,-0.216 -0.25,-0.3945 -0.25,-0.4375 l 0.0625,-0.125 c 0.13,-0.087 0.404,-0.087 0.75,0 l 0.0937,-0.125 c -0.043,-0.26 -0.22725,-0.65675 -0.53125,-1.21875 -0.303,-0.477 -0.35375,-0.8845 -0.0937,-1.1875 0.39,-0.303 0.73325,-0.66475 0.90625,-0.96875 0.043,-0.26 -0.0838,-0.649 -0.34375,-1.125 -0.217,-0.477 -0.34375,-0.788 -0.34375,-0.875 0,-0.476 0.0457,-0.8025 0.21875,-1.0625 0.13,-0.217 0.1875,-0.38175 0.1875,-0.46875 -0.043,-0.13 -0.1775,-0.31425 -0.4375,-0.53125 -0.217,-0.216 -0.36325,-0.4275 -0.40625,-0.6875 0.173,-0.649 0.28125,-1.235 0.28125,-1.625 0,-0.39 0.007,-0.582 0.0937,-0.625 0.13,-0.216 0.37275,-0.40125 0.71875,-0.53125 0.26,-0.086 0.42475,-0.163 0.46875,-0.25 0.086,-0.13 0.086,-0.31425 0,-0.53125 -0.043,-0.303 -0.0753,-0.46375 -0.0312,-0.59375 0.39,-0.303 0.47375,-0.62175 0.34375,-0.96875 -0.303,-0.39 -0.577,-0.74 -0.75,-1 -0.13,-0.173 -0.13,-0.366 0,-0.625 0.086,-0.39 0.1875,-0.61325 0.1875,-0.65625 -0.216,-0.606 -0.331,-1.10325 -0.375,-1.40625 0.13,-0.39 0.168,-0.69025 0.125,-0.90625 -0.043,-0.173 -0.279,-0.37775 -0.625,-0.59375 -0.39005,-0.2601 -0.5938,-0.48335 -0.5938,-0.65635 -0.217,-1.125 -0.4275,-1.93025 -0.6875,-2.40625 -0.346,-0.649 -0.5625,-1.0575 -0.5625,-1.1875 -0.086,-0.26 -0.01,-0.687 0.25,-1.25 0.173,-0.476 0.40125,-0.77625 0.53125,-0.90625 l 0.15625,-0.0312 c 0.346,-0.173 0.57025,-0.289 0.65625,-0.375 0.173,-0.13 0.288,-0.476 0.375,-1.125 0.086,-0.823 0.1445,-1.28125 0.1875,-1.28125 0.043,-0.26 0.2595,-0.534 0.5625,-0.75 0.26,-0.216 0.3945,-0.4665 0.4375,-0.8125 0.043,-0.303 -0.12275,-0.572 -0.46875,-0.875 -0.4765,-0.3465 -0.81725,-0.66025 -0.96875,-0.96875 -0.1515,-0.3085 -0.111,-0.5935 0.0625,-0.875 0.13,-0.26 0.206,-0.40625 0.25,-0.40625 l 0.53125,-0.5 c 0.043,-0.13 0.0312,-0.58325 0.0312,-1.40625 -0.043,-0.649 -0.1775,-1.06525 -0.4375,-1.28125 l -0.6875,-0.53125 c -0.346,-0.303 -0.4425,-0.69975 -0.3125,-1.21875 0.216,-0.649 0.26175,-1.06425 0.21875,-1.28125 -0.13,-0.346 -0.29075,-0.60825 -0.59375,-0.78125 -0.303,-0.13 -0.5195,-0.31425 -0.5625,-0.53125 -0.087,-0.173 -0.0665,-0.39725 0.0625,-0.65625 0.173,-0.303 0.28125,-0.5195 0.28125,-0.5625 0.043,-0.26 -0.0447,-0.567 -0.21875,-1 -0.216,-0.477 -0.34375,-0.707 -0.34375,-0.75 l 0.125,-0.375 c 0.087,-0.303 0.6095,-0.54075 1.5625,-0.84375 0.347,-0.087 0.52725,-0.1445 0.65625,-0.1875 0.13,-0.043 0.19525,-0.20875 0.28125,-0.46875 0.043,-0.217 0.0625,-0.3945 0.0625,-0.4375 -0.086,-0.086 -0.27125,-0.125 -0.53125,-0.125 -0.303,-0.043 -0.56525,-0.12 -0.78125,-0.25 -0.087,-0.13 -0.0753,-0.244 -0.0312,-0.375 0.086,-0.173 0.29075,-0.288 0.59375,-0.375 0.173,-0.043 0.33875,-0.24775 0.46875,-0.59375 0.086,-0.303 0.125,-0.44425 0.125,-0.53125 -0.52,-0.346 -0.8075,-0.64625 -0.9375,-0.90625 0,-0.26 0.076,-0.40625 0.25,-0.40625 0.736,0 1.20875,-0.038 1.46875,-0.125 0.346,-0.087 0.5245,-0.3405 0.4375,-0.6875 -0.043,-0.346 -0.20775,-0.60825 -0.46875,-0.78125 -0.303,-0.216 -0.83325,-0.3895 -1.65625,-0.5625 l 0,-0.0937 c 0.216,-0.216 0.49675,-0.332 0.84375,-0.375 l 0.21875,0.5 0.3125,-0.78125 c -0.16109,0.10185 -0.24159,0.12981 -0.46875,0.28125 0.043,-0.13 0.0235,-0.672 -0.0625,-1.625 l -0.0937,-0.0937 -0.8125,-0.125 c -0.173,-0.649 -0.007,-1.26125 0.46875,-1.78125 0.303,-0.303 0.456,-0.539 0.5,-0.625 0,-0.043 -0.0642,-0.2975 -0.28125,-0.6875 l -0.0937,-0.125 -0.125,0.0312 c -0.26,0.346 -0.62175,0.60825 -0.96875,0.78125 l -0.6875,0.21875 c -0.303,0.087 -1.07025,-0.2015 -2.28125,-0.9375 -0.087,0 -0.2595,-0.11325 -0.5625,-0.15625 -0.086,-0.043 -0.514,0.1725 -1.25,0.5625 -0.563,0.26 -1.0855,0.0553 -1.5625,-0.59375 -0.346,-0.13 -0.731,0.0425 -1.25,0.5625 -0.303,0.26 -0.61,0.59825 -1,1.03125 -0.346,0.39 -0.92025,0.9525 -1.65625,1.6875 -0.476,0.52 -1.12125,0.78125 -2.03125,0.78125 -0.13,0 -0.2645,0.0118 -0.4375,-0.0312 -1.429,0 -2.29075,0.115 -2.59375,0.375 -0.13,0.086 -0.3855,0.36 -0.6875,0.75 l -0.125,0.125 c -0.13,0 -0.25675,-0.007 -0.34375,-0.0937 -0.13,-0.129 -0.23725,-0.283 -0.28125,-0.5 l -0.0625,-0.125 -0.15625,0 c -0.347,0.217 -0.82475,0.605 -1.34375,1.125 l -0.1875,-0.0625 c -0.13,-0.086 -0.2265,-0.31025 -0.3125,-0.65625 -0.043,-0.043 -0.27125,0.0263 -0.53125,0.15625 -0.217,0.043 -0.4325,0.0168 -0.5625,-0.15625 -0.043,-0.086 -0.0312,-0.19425 -0.0312,-0.28125 l -0.0625,-0.125 c -0.13,-0.086 -0.595,-0.11325 -1.375,-0.15625 -0.13,0 -0.25775,0.12675 -0.34375,0.34375 -0.39,0.866 -0.39,1.447 0,1.75 0.26,0.26 0.46875,0.3945 0.46875,0.4375 l 0.0937,0.0937 0,0.15625 c -0.303,0.26 -0.375,0.649 -0.375,1.125 -0.13,0.13 -0.437,0.21875 -1,0.21875 l -0.21885,0.2186 -0.0625,0.34375 c 0,0.13 0.0195,0.27125 0.0625,0.53125 0.043,0.173 -0.008,0.562 -0.0937,1.125 l -0.18755,-0.0937 c 0,-0.043 -0.0263,-0.18925 -0.15625,-0.40625 -0.13,-0.086 -0.404,-0.168 -0.75,-0.125 l -0.125,0.0937 c -0.043,0.52 -0.0937,0.85725 -0.0937,1.03125 -0.086,0.086 -0.043,0.2645 0,0.4375 0.086,0.347 0.31425,0.5575 0.53125,0.6875 0.39,0.216 0.61325,0.3515 0.65625,0.4375 0.087,0.26 0.13175,0.4755 0.21875,0.5625 l 0.375,0.4375 c 0.086,0.13 0.1875,0.3025 0.1875,0.5625 0.043,0.216 -0.038,0.38275 -0.125,0.46875 -0.216,0.043 -0.53575,0.043 -0.96875,0 -0.347,0.217 -0.3995,0.51625 -0.3125,0.90625 0.173,0.563 0.3125,0.913 0.3125,1 -0.347,0.953 -0.99725,1.35275 -1.90625,1.09375 -0.173,0.086 -0.37775,0.2205 -0.59375,0.4375 -0.217,0.086 -0.53575,0.164 -0.96875,0.25 -0.216,0.087 -0.55525,0.2595 -1.03125,0.5625 -0.086,0.043 -0.71775,0.16975 -1.84375,0.34375 -0.26,0 -0.5485,0.1395 -0.9375,0.3125 -0.086,0 -0.71775,0.077 -1.84375,0.25 -0.26,0.996 -0.34375,1.50775 -0.34375,1.59375 0.043,0.043 0.077,0.24775 0.25,0.59375 l 0.0937,0.125 c 0.433,0.649 0.6055,1.10225 0.5625,1.40625 -0.087,0.26 -0.30925,0.54575 -0.65625,0.71875 -0.476,0.216 -0.899,0.2745 -1.375,0.1875 -0.043,-0.086 -0.1445,-0.18925 -0.1875,-0.40625 -0.303,-0.043 -0.56025,0.263 -0.90625,1 -0.173,0.39 -0.3455,0.893 -0.5625,1.5 l -0.53125,0.93755 c -0.087,0.13 -0.19525,0.3025 -0.28125,0.5625 -0.217,0.216 -0.82425,0.6675 -1.90625,1.1875 -0.216,0.086 -0.51725,0.27125 -0.90625,0.53125 -0.346,0.13 -0.9085,0.37275 -1.6875,0.71875 -0.26,0.173 -0.4705,0.447 -0.6875,0.75 -0.086,0.043 -0.31025,0.0352 -0.65625,-0.0937 -0.346,-0.129 -0.658,-0.11825 -0.875,-0.0312 l 0,0.5 c -0.043,0.043 -0.0703,0.39 -0.15625,1.125 l 0,0.40625 c -0.0393,0.55401 -0.2147,0.81852 -0.40625,0.96875 z",
                        "Poltava": "m 327.54,113.982 -0.563,0.043 c -0.13,0.086 -0.216,0.303 -0.303,0.649 l -0.129,0.043 c -0.52,0 -0.866,0 -1.04,0.086 -0.173,0.086 -0.52,0.563 -1.083,1.429 -0.476,0.649 -0.909,0.866 -1.342,0.693 l -0.26,-0.346 -0.217,-0.043 c -0.173,0.173 -0.692,0.216 -1.559,0.086 h -0.086 c 0,0.217 -0.043,0.433 -0.173,0.649 -0.216,0.303 -0.303,0.52 -0.303,0.606 -0.13,0.606 -0.217,0.952 -0.26,0.996 -0.476,0.26 -0.692,0.52 -0.692,0.779 0.303,0.13 0.433,0.347 0.303,0.606 -0.043,0.086 -0.173,0.303 -0.433,0.692 -0.26,0.347 -0.433,0.563 -0.477,0.65 h -0.043 l 0.173,0.13 c 0.303,-0.173 0.563,-0.173 0.736,0 0,0.043 0.043,0.129 0.173,0.216 0.043,0.26 0.13,0.52 0.13,0.736 0.13,0.217 0.39,0.477 0.78,0.736 0.043,0.173 0.129,0.433 0.129,0.779 0.13,0.13 0.477,0.26 1.083,0.346 0.39,0.086 0.649,0.433 0.78,1.039 0.043,0.087 0.129,0.13 0.259,0.173 0.13,0 0.39,-0.13 0.736,-0.39 0.346,-0.303 0.52,-0.433 0.649,-0.433 l 0.433,0.39 c 0.086,0.173 0.13,0.477 0.216,0.953 l -0.086,0.13 c -0.866,0.303 -1.342,0.476 -1.472,0.433 -0.043,0.13 0.086,0.476 0.346,1.039 0.26,0.649 0.347,1.125 0.347,1.515 l 0.216,0.173 1.169,0.433 c 0.13,0.043 0.433,-0.043 0.909,-0.26 l 0.347,0.692 c 0.129,0.217 0.26,0.65 0.39,1.256 0.173,0.563 0.779,1.083 1.775,1.645 0,0 0.043,0.087 0.13,0.217 0.043,0.173 0,0.563 -0.173,1.169 -0.173,0.649 -0.216,1.083 -0.173,1.255 0,0.173 0.13,0.39 0.303,0.65 0,0.13 -0.216,0.346 -0.606,0.649 -0.086,-0.043 -0.216,-0.087 -0.39,-0.26 -0.216,-0.043 -0.39,0.043 -0.52,0.217 -0.086,0.173 -0.13,0.346 -0.086,0.563 0.086,0.13 0.173,0.39 0.346,0.693 0.866,1.602 1.515,2.468 1.948,2.468 0.433,-0.303 0.693,-0.347 0.866,-0.217 0.303,0.347 0.563,0.606 0.692,0.779 0.087,0.043 0.173,0.217 0.26,0.477 0.217,0 0.477,-0.087 0.693,-0.303 0.043,0 0.433,0.303 1.212,0.909 0.13,0.13 0.173,0.563 0.087,1.386 -0.087,0.822 -0.087,1.299 0,1.385 0.173,0.043 1.212,0.477 3.16,1.212 0.433,0.13 0.693,0.26 0.779,0.346 0.087,0.13 0.087,0.433 0.043,0.909 -0.043,0.433 -0.043,0.78 0,0.953 0.087,0.26 0.303,0.477 0.693,0.736 0.39,0.216 0.606,0.433 0.736,0.606 0,0.26 0.086,0.649 0.259,1.256 0.043,0.52 -0.043,0.909 -0.39,1.212 -0.043,0 -0.086,0 -0.13,0 0.086,0.13 0.13,0.303 0.217,0.433 v 0.043 c -0.087,0.216 -0.217,0.39 -0.477,0.52 -0.346,0.346 -0.649,0.953 -0.909,1.818 l 0.13,0.043 c 0.217,0 0.563,0 1.039,0 0.173,0 0.433,0.043 0.779,0.173 0.087,0 0.217,0.043 0.347,0.087 0.26,0.086 0.692,0.476 1.299,1.212 0.13,0.043 0.346,0.086 0.606,0.173 0.39,0.087 0.563,0.26 0.606,0.433 0,0.086 -0.217,0.39 -0.649,0.779 -0.347,0.346 -0.39,0.563 -0.13,0.779 0.13,0 0.39,-0.043 0.779,-0.173 0.346,-0.13 0.606,-0.173 0.736,-0.13 0.346,0.087 0.52,0.347 0.606,0.736 0,0.26 0.043,0.563 0.086,0.996 0,0.087 0.043,0.217 0.173,0.433 l 0.13,0.736 c 0.173,0.347 0.649,0.65 1.342,0.823 0.216,0.13 0.433,0.347 0.736,0.563 l 0.13,0.086 c 0.043,0.043 0.13,0.087 0.216,0.217 0.086,0.26 0.26,0.692 0.52,1.212 0.043,0.173 0.087,0.39 0.13,0.736 0,0.13 0.086,0.216 0.173,0.303 0.303,0.476 0.649,0.822 0.953,1.039 0.043,0.043 0.216,0.086 0.476,0.216 0.303,0.087 0.606,0.39 0.996,0.866 l 0.216,0.736 c 0.216,0.649 0.477,1.169 0.779,1.559 0.13,0.13 0.347,0.303 0.736,0.477 0.346,0.173 0.563,0.346 0.649,0.52 0.086,0.173 0.173,0.476 0.216,0.952 0,0.303 0.173,0.563 0.52,0.823 0.086,0.087 0.303,0.13 0.693,0.173 0.736,0.086 1.255,0.13 1.472,0.086 0.043,0 0.39,-0.043 1.083,-0.13 0.433,-0.043 0.823,-0.043 1.126,0.043 l 0.303,0.173 c 0.173,0.043 0.346,0.087 0.606,0.13 0.26,0.086 1.039,0.736 2.381,1.905 0.39,0.173 0.649,0.303 0.779,0.303 0.086,0 0.173,0 0.346,-0.043 0.39,-0.086 0.823,-0.043 1.299,0.173 0.216,0.043 0.563,0.26 0.996,0.563 0.086,0.043 0.26,0.087 0.52,0.173 0.13,0.043 0.52,0.39 1.126,0.953 0.259,0.13 0.563,0.173 0.952,0.13 0.043,0.086 0.26,0.39 0.52,0.866 0.217,0.346 0.477,0.563 0.779,0.692 0.087,0 0.52,-0.043 1.386,-0.216 0.26,-0.086 0.693,0 1.299,0.216 0.39,0.173 0.953,0.52 1.732,1.126 0.13,0.086 0.346,0.303 0.606,0.606 0.13,0.043 0.303,0.13 0.52,0.173 0.173,0.086 0.346,0.26 0.649,0.476 0.129,0.043 0.346,0.13 0.736,0.173 0.043,0.043 0.216,0.173 0.476,0.39 0.217,0.13 0.433,0.216 0.649,0.26 0.26,0.26 0.953,0 2.165,-0.779 0.086,-0.13 0.216,-0.347 0.303,-0.606 0.216,-0.347 0.563,-0.52 1.039,-0.563 l 0.13,0.086 c 0.043,0.086 0.043,0.26 -0.043,0.563 -0.216,0.649 -0.433,1.083 -0.649,1.299 -0.303,0.216 -0.52,0.39 -0.693,0.52 -0.303,0.26 -0.433,0.563 -0.346,0.866 0.346,0.26 0.606,0.433 0.779,0.52 0.26,0.13 0.693,0.13 1.299,-0.043 0.563,-0.216 0.953,-0.26 1.125,-0.173 l 0.087,0.086 c -0.043,0.26 -0.216,0.433 -0.563,0.52 -0.433,0.13 -0.649,0.26 -0.736,0.433 l 0.13,0.087 c 0.13,0.086 0.39,0.043 0.823,-0.087 0.433,-0.173 0.736,-0.216 0.822,-0.216 0.347,0.043 0.52,0.26 0.563,0.693 0.043,0.216 0.086,0.52 0.086,0.996 0.043,0.043 0.173,0.303 0.433,0.736 0.043,0.043 0.173,0.087 0.26,0.173 0.13,0.043 0.26,0.087 0.52,0.13 0.606,-0.39 0.996,-0.779 1.255,-1.212 l -0.043,-0.13 -0.649,-0.476 c 0,0 0,-0.13 0,-0.303 0.043,-0.346 0.13,-0.563 0.303,-0.736 0.173,-0.13 0.26,-0.346 0.26,-0.606 l 0.173,-0.043 c 0.173,0.13 0.303,0.13 0.477,0.043 l 0.043,-0.173 -0.087,-0.779 v -0.173 c 0,-0.216 -0.216,-0.52 -0.649,-0.953 -0.216,-0.173 -0.39,-0.303 -0.477,-0.39 -0.259,-0.303 -0.216,-0.823 0.043,-1.515 0.173,-0.303 0.26,-0.477 0.303,-0.606 0.39,-1.082 0.606,-1.645 0.649,-1.688 0.26,-0.346 0.779,-0.52 1.559,-0.52 0.217,-0.086 0.303,-0.26 0.217,-0.563 l -0.173,-0.086 -0.303,0.086 c -0.216,-0.043 -0.346,-0.13 -0.346,-0.303 0.043,-0.173 0.39,-0.563 1.039,-1.083 0.563,-0.477 0.909,-0.953 0.909,-1.429 l -0.216,-0.563 c 0.043,-0.13 0.086,-0.216 0.216,-0.216 0.043,0 0.303,0.086 0.823,0.303 0.346,0.087 0.649,0.087 0.953,-0.086 0.216,-0.087 0.476,-0.26 0.866,-0.563 0.216,-0.13 0.606,-0.39 1.083,-0.693 0.303,-0.173 0.736,-0.39 1.342,-0.606 0.13,-0.086 0.303,-0.216 0.606,-0.39 0.086,-0.043 0.39,-0.086 0.953,-0.086 0.303,-0.043 0.736,-0.173 1.342,-0.433 0.39,-0.086 0.952,-0.26 1.775,-0.476 0.087,-0.043 0.173,-0.217 0.347,-0.563 0.086,-0.26 0.476,-0.477 1.039,-0.649 0.216,-0.087 0.476,-0.043 0.866,0.173 0.043,-0.043 0.173,-0.216 0.346,-0.52 0.087,-0.043 0.347,0.043 0.736,0.217 0.346,0.13 0.606,0.26 0.693,0.39 v 0.173 c -0.347,0.217 -0.52,0.433 -0.477,0.693 0.087,0.216 0.26,0.303 0.433,0.303 0.346,0 0.563,-0.13 0.693,-0.433 0.043,-0.043 0.13,-0.346 0.216,-0.866 l 0.13,-0.347 c 0.477,-0.346 1.212,-0.086 2.295,0.736 0,-0.043 0,-0.043 0.043,-0.043 0.26,-0.173 0.26,-0.693 0,-1.515 -0.173,-0.39 -0.259,-0.65 -0.303,-0.823 l -0.13,-0.26 c -0.303,-0.477 -0.477,-0.693 -0.477,-0.736 -0.346,-0.736 0.39,-1.905 2.165,-3.55 0.043,-0.043 0.13,-0.086 0.26,-0.086 0.216,0 0.39,0.086 0.476,0.173 0.043,0.086 0.13,0.216 0.26,0.39 0.217,0.26 0.433,0.39 0.649,0.476 0.563,0.173 1.516,0.26 2.944,0.26 0.26,0 0.649,-0.086 1.169,-0.26 1.126,-0.433 1.949,-1.083 2.555,-1.992 0.13,-0.216 0.346,-0.52 0.563,-0.953 l 0.952,-1.212 c 0.087,-0.087 0.13,-0.217 0.13,-0.347 -0.043,-0.173 -0.217,-0.346 -0.563,-0.476 v -0.173 c 0.173,-0.173 0.26,-0.346 0.303,-0.563 l -0.043,-0.13 c -0.13,-0.086 -0.39,-0.13 -0.779,-0.173 l -0.087,-0.13 0.087,-0.39 c -0.26,-0.303 -0.433,-0.52 -0.52,-0.693 0,-0.433 0.086,-0.779 0.346,-1.039 0.043,-0.043 0.216,-0.087 0.606,-0.13 0.087,-0.043 0.26,-0.086 0.39,-0.173 0.477,0 1.169,0.173 2.079,0.52 0.086,-0.13 0.216,-0.303 0.346,-0.563 0.13,-0.043 0.39,-0.086 0.823,-0.086 0.043,-0.043 0.086,-0.216 0.173,-0.476 -0.129,-0.347 -0.476,-0.563 -1.169,-0.693 -0.043,-0.346 -0.13,-0.563 -0.216,-0.693 -0.476,-0.043 -0.823,-0.086 -0.996,-0.216 -0.173,-0.303 -0.173,-0.477 -0.129,-0.563 1.688,0.086 2.598,-0.043 2.728,-0.39 v -0.173 c -1.299,-2.035 -1.992,-3.377 -1.992,-4.07 0.086,-0.13 0.26,-0.216 0.563,-0.26 -0.087,-0.649 -0.173,-0.996 -0.217,-1.039 -0.043,-0.043 -0.52,-0.043 -1.429,-0.043 -0.086,0.043 -0.173,0.217 -0.216,0.477 -0.043,0.216 -0.13,0.39 -0.173,0.433 -1.039,-0.303 -1.775,-0.476 -2.294,-0.563 l -0.087,-0.087 c 0.087,-0.303 0.087,-0.52 -0.043,-0.649 -0.563,-0.043 -0.996,-0.086 -1.255,-0.216 0,-0.606 0,-1.039 -0.087,-1.299 -0.043,-0.086 -0.259,-0.173 -0.606,-0.347 -0.303,-0.13 -0.476,-0.433 -0.563,-0.822 -0.087,-0.693 -0.173,-1.212 -0.13,-1.602 0.087,-0.693 0.13,-1.169 0.087,-1.429 -0.043,-0.39 -0.26,-0.736 -0.693,-1.083 l -0.13,-0.13 c -0.303,-0.13 -0.476,-0.173 -0.649,-0.086 -0.173,0.086 -0.303,0.173 -0.347,0.216 -0.389,0.26 -1.082,0.086 -2.035,-0.477 -0.563,-0.346 -0.866,-0.52 -0.866,-0.52 0.043,-0.303 -0.043,-0.52 -0.173,-0.606 -0.26,-0.086 -0.649,-0.13 -1.083,-0.086 -0.52,0 -0.866,-0.043 -1.083,-0.087 -0.26,-0.043 -0.476,-0.216 -0.649,-0.433 -0.216,-0.26 -0.346,-0.433 -0.433,-0.433 -0.563,-0.13 -0.866,-0.217 -0.909,-0.26 l -0.087,-0.26 c -0.173,-0.347 -0.39,-0.563 -0.693,-0.606 0.087,-0.216 0.13,-0.39 0.173,-0.476 0,-0.173 -0.086,-0.563 -0.303,-1.212 -0.173,-0.563 -0.346,-0.953 -0.476,-1.212 0.043,-0.303 0.433,-0.779 1.169,-1.429 0.736,-0.693 1.169,-1.169 1.169,-1.472 0,0 -0.043,-0.433 -0.086,-1.255 -0.13,-0.346 -0.173,-0.649 -0.087,-0.953 0.087,-0.433 0.13,-0.693 0.173,-0.736 -0.26,-0.26 -0.346,-0.477 -0.346,-0.606 -0.216,-0.303 -1.126,-0.649 -2.728,-0.996 -0.217,-0.043 -0.52,0.13 -0.866,0.563 l -0.13,0.043 c -0.476,0.39 -0.909,0.649 -1.212,0.779 l -0.216,-0.043 c -0.087,-0.13 -0.347,-0.347 -0.779,-0.693 h -0.173 c -0.173,0.043 -0.303,0.346 -0.39,0.866 -0.086,0.433 -0.26,0.736 -0.563,0.823 -0.866,0.043 -1.516,0.043 -1.949,0 -0.13,0 -0.303,-0.13 -0.563,-0.346 -0.216,-0.173 -0.433,-0.26 -0.649,-0.217 -1.169,0.26 -1.818,0.39 -1.948,0.52 -0.26,0.259 -0.477,0.476 -0.693,0.52 l -0.13,-0.087 -0.043,-0.13 c 0.086,-0.52 0.13,-0.823 0.13,-0.823 -0.173,-0.086 -0.347,-0.086 -0.563,-0.086 -0.086,-0.26 0,-0.779 0.216,-1.516 l 0.13,-0.086 c 0.693,0.173 1.083,-0.043 1.256,-0.649 0.13,-0.563 0.043,-0.953 -0.303,-1.255 -0.26,-0.173 -0.693,-0.347 -1.342,-0.52 0.043,-0.563 0,-0.91 -0.086,-0.996 -0.303,-0.086 -0.433,-0.173 -0.433,-0.216 l -0.043,-0.649 c 0,-0.13 -0.043,-0.26 -0.173,-0.433 -0.043,-0.086 -0.173,-0.13 -0.347,-0.216 -0.259,-0.087 -0.39,0 -0.52,0.216 -0.173,0.346 -0.26,0.52 -0.26,0.52 h -0.173 c -0.303,-0.173 -0.477,-0.736 -0.563,-1.688 0,-0.13 -0.043,-0.347 -0.086,-0.649 0,-0.173 0.086,-0.39 0.26,-0.649 0.216,-0.303 0.303,-0.477 0.26,-0.649 0,-0.303 -0.173,-0.649 -0.52,-1.04 -0.649,-0.433 -1.083,-0.822 -1.342,-1.039 -0.173,-0.303 -0.346,-0.476 -0.477,-0.563 -0.476,-0.52 -0.736,-0.823 -0.779,-0.866 -0.433,-0.606 -0.649,-1.083 -0.649,-1.472 -0.086,-1.559 -0.043,-2.684 0.086,-3.334 l -0.043,-0.129 c -0.649,-0.217 -1.126,-0.39 -1.386,-0.52 -0.086,0.347 -0.173,0.649 -0.26,0.78 -0.303,-0.173 -0.693,-0.173 -1.169,-0.043 l -0.086,0.086 -0.087,0.39 c -0.606,-0.13 -0.952,-0.13 -1.082,-0.043 -0.043,0.086 0,0.303 0.043,0.649 0.087,0.303 0.043,0.52 -0.086,0.649 -0.433,-0.26 -0.736,-0.433 -0.953,-0.433 -0.13,-0.043 -0.346,0.13 -0.606,0.39 -0.087,0.086 -0.043,0.26 0,0.433 0.086,0.173 0.086,0.303 0.043,0.433 -0.173,0.13 -0.347,0.13 -0.606,-0.043 -0.303,-0.173 -0.476,-0.303 -0.606,-0.346 -1.299,-0.563 -2.035,-0.953 -2.251,-1.126 -0.433,-0.39 -0.779,-0.823 -1.04,-1.255 l -0.129,-0.087 c -0.173,0 -0.649,0.13 -1.342,0.433 -0.693,0.216 -1.169,0.433 -1.386,0.563 -0.173,0.086 -0.26,0.216 -0.303,0.39 l 0.043,0.13 c 0.173,0.086 0.52,0.303 1.126,0.649 0,0.173 0,0.346 -0.087,0.563 -0.303,-0.13 -0.692,-0.173 -1.169,-0.217 l -0.779,-0.086 c -0.26,0 -0.52,0.13 -0.736,0.433 -0.26,0.346 -0.433,0.476 -0.563,0.52 -0.173,-0.043 -0.693,-0.303 -1.559,-0.736 -0.26,-0.086 -0.433,-0.173 -0.563,-0.216 -0.346,-0.216 -0.606,-0.347 -0.693,-0.347 -0.996,-0.13 -1.731,-0.216 -2.208,-0.303 l -1.862,-0.347 c -1.515,-0.043 -2.641,-0.13 -3.42,-0.216 -0.26,-0.043 -0.52,-0.173 -0.736,-0.303 -0.217,-0.26 -0.433,-0.433 -0.606,-0.563 -0.043,-0.087 -0.216,-0.087 -0.476,-0.043 -0.26,0.086 -0.433,0.086 -0.52,0.086 -0.13,-0.303 -0.217,-0.52 -0.303,-0.649 -0.13,-0.26 -0.303,-0.346 -0.563,-0.346 l -1.429,-0.043 -0.13,0.13 c -0.086,0.649 -0.216,1.083 -0.39,1.299 -0.13,0.043 -0.303,0.043 -0.649,0.043 -0.303,0 -0.52,-0.043 -0.52,-0.043 -0.216,-0.173 -0.39,-0.303 -0.476,-0.346 -0.346,-0.217 -0.779,-0.13 -1.256,0.216 -0.476,-0.346 -0.779,-0.563 -0.953,-0.606 l -0.476,-0.216 v 0.216 c -0.346,0.52 -0.606,0.909 -0.779,1.169 -0.13,0.52 -0.303,0.866 -0.476,1.126 -0.563,0.173 -0.953,0.303 -1.169,0.39 -0.347,0.13 -0.606,0.563 -0.693,1.299 -0.693,0.173 -1.169,0.346 -1.472,0.52 -0.173,0.086 -0.303,0.303 -0.39,0.736 -0.13,0.433 -0.217,0.736 -0.303,0.823 -0.173,0.13 -0.433,0.216 -0.779,0.216 -0.346,0 -0.649,0.043 -0.823,0.043 -0.043,0.043 -0.346,0.13 -0.909,0.303 -0.173,0.086 -0.303,0.173 -0.39,0.216 -0.606,0.303 -0.996,0.52 -1.083,0.649 v 0.13 c -0.043,0.13 -0.346,0.217 -0.909,0.217 -0.433,0 -0.779,0 -0.996,-0.043 0,-0.216 0,-0.347 -0.087,-0.477 -0.13,-0.086 -0.433,-0.129 -0.909,-0.129 l -0.13,0.346 c -0.303,0.13 -0.996,0.13 -2.122,0.086 -1.082,-0.086 -1.818,-0.173 -2.122,-0.346 -0.13,-0.173 -0.216,-0.303 -0.26,-0.347 -0.129,-0.822 -0.303,-1.212 -0.476,-1.299 l -0.433,-0.086 c -0.216,-0.043 -0.39,-0.043 -0.52,0 -0.043,0 -0.086,0.043 -0.216,0.216 -0.173,0.087 -0.303,0.173 -0.39,0.217 -0.173,0.216 -0.303,0.346 -0.433,0.433 l -0.13,-0.043 c -0.13,-0.13 -0.216,-0.26 -0.303,-0.347 -0.297,-0.35 -0.644,-0.523 -0.99,-0.523",
                        "Odessa": "m 231.118,214.344 c -0.173,-0.086 -0.736,0.087 -1.688,0.606 -0.13,0.13 -0.13,0.476 0.043,1.082 0.13,0.563 0.173,0.953 0.13,1.126 -0.13,0.13 -0.433,0.346 -0.909,0.606 -0.346,0.217 -0.649,0.563 -0.909,0.996 -0.303,0.52 -0.476,0.779 -0.476,0.823 -0.173,0.13 -0.649,0.303 -1.472,0.563 -0.693,0.217 -1.126,0.347 -1.299,0.347 0,0.086 0.13,0.216 0.303,0.433 0.347,0.519 0.52,0.779 0.563,0.779 0.173,0.26 0.563,0.606 1.039,0.996 0.606,0.693 1.039,1.039 1.342,1.125 0.13,0.043 0.433,0.087 0.866,0.087 0.433,0.043 0.779,-0.087 1.039,-0.39 0.13,-0.13 0.26,-0.563 0.433,-1.342 0.173,-0.216 0.26,-0.39 0.39,-0.52 0.043,0 0.173,0 0.303,-0.086 0.433,-0.13 0.866,-0.13 1.299,-0.087 0.13,0 0.217,0.087 0.433,0.26 0,0.043 0.346,0.563 0.866,1.472 0.216,1.516 0.39,2.338 0.433,2.338 0.13,0.303 0.433,0.477 0.91,0.563 0.563,0.086 0.822,0.173 0.909,0.217 l 0.087,0.129 -0.043,0.173 c -0.13,0.13 -0.39,0.52 -0.779,1.126 -0.086,0.173 -0.303,0.39 -0.563,0.649 -0.52,0.649 -0.692,1.212 -0.52,1.688 0.173,0.173 0.649,0.346 1.602,0.563 0.216,0.086 0.303,0.26 0.303,0.606 -0.043,0.346 -0.173,0.606 -0.39,0.736 0,0.043 0,0.043 0,0.043 -0.13,0.13 -0.347,0.303 -0.649,0.52 -0.39,0.346 -0.477,1.083 -0.39,2.251 l 0.13,0.303 c 0,0.26 -0.043,0.779 -0.173,1.515 -0.086,0.736 -0.216,1.256 -0.303,1.472 -0.13,0.303 -0.433,0.693 -0.909,1.212 -0.086,0 -0.303,0.173 -0.476,0.52 -0.39,0.649 -0.563,1.039 -0.563,1.126 -0.043,0.173 0,0.476 0.13,1.039 0.13,0.563 0.26,0.909 0.346,1.082 h 0.043 c 0.13,0.26 0.39,0.693 0.736,1.342 0.303,0.953 0.433,1.472 0.52,1.516 0.129,0.086 0.346,0.043 0.606,-0.043 0.13,-0.346 0.26,-0.606 0.39,-0.736 0.086,-0.13 0.26,-0.216 0.476,-0.216 0.173,-0.043 0.303,0.129 0.433,0.433 0.043,0.173 0.087,0.433 0.173,0.736 0.216,0.217 0.563,0.347 1.082,0.433 0.087,0.087 0.26,0.433 0.477,1.083 l 0.086,0.216 c 0.043,0.13 0.086,0.347 0.13,0.649 0.217,0.043 0.52,0.043 1.083,0 0.043,0.043 0.087,0.173 0.216,0.347 0.39,0.433 0.52,0.823 0.477,1.083 -0.13,0.476 -0.173,0.779 -0.173,0.909 0.043,0.173 0.217,0.476 0.52,0.909 0.303,0.39 0.477,0.649 0.649,0.736 0.043,0.043 0.303,0.043 0.78,0.043 0.563,-0.043 0.909,-0.13 1.082,-0.303 0.13,-0.173 0.217,-0.606 0.303,-1.212 0.043,-0.606 0.13,-0.953 0.303,-1.04 0.216,-0.086 0.563,-0.086 0.996,-0.043 0.433,0.043 0.736,0.13 0.909,0.216 0.347,0.303 0.693,0.996 0.953,2.078 0.26,1.126 0.173,1.775 -0.26,1.948 -0.433,0.173 -0.693,0.26 -0.736,0.347 -0.173,0.173 -0.216,0.39 -0.173,0.649 0.043,0.173 0.086,0.39 0.173,0.693 l 0.087,1.039 c 0,0.39 0.043,0.909 0.216,1.559 v 0.433 c -0.043,0.173 -0.173,0.303 -0.216,0.39 -0.216,0.173 -0.563,0.303 -0.953,0.346 -0.433,0.043 -0.779,0.086 -0.996,0.13 l -0.087,0.13 c 0,0.086 0,0.217 0.087,0.433 0.173,0.39 0.476,0.909 0.909,1.645 0,0.043 0.086,0.13 0.13,0.26 l 0.13,0.087 0.173,-0.043 c 0.086,-0.693 0.303,-1.169 0.736,-1.342 0.173,-0.13 0.39,-0.086 0.693,0.043 0.216,0.086 0.433,0.26 0.52,0.433 0.043,0.086 0.13,0.39 0.216,0.909 0.13,0.563 0.173,0.866 0.173,0.953 -0.087,0.346 -0.39,0.606 -0.823,0.779 -0.086,0.043 -0.173,0.477 -0.26,1.212 v 0.433 c 0,0 -0.087,0.39 -0.26,1.126 -0.13,0.563 -0.173,0.909 -0.13,0.996 0.216,0.087 0.649,0.13 1.342,0.043 0.086,0.043 0.26,0.216 0.606,0.606 0.346,0.39 0.606,0.606 0.823,0.649 0.26,0.13 0.779,0.13 1.386,0.087 0.259,0.13 0.476,0.433 0.692,0.996 0.173,0.52 0.347,0.866 0.52,0.953 0.087,0.086 0.26,0.13 0.606,0.13 0.26,0.043 0.476,0.086 0.649,0.086 0.39,-0.043 0.909,-0.043 1.515,-0.13 0.52,0.043 0.909,0.347 1.212,0.953 0.173,0.303 0.39,0.779 0.52,1.342 0.216,0.043 0.476,-0.087 0.736,-0.347 0.216,0 0.346,0.13 0.519,0.347 0.043,0.216 0,0.52 -0.129,0.952 0,0.043 0.173,0.477 0.563,1.342 0.043,0.043 0.087,0.26 0.13,0.649 l 0.086,0.606 c 0,0.26 -0.086,0.736 -0.216,1.299 0,0.433 0,0.866 -0.086,1.255 0,0.087 0,0.173 0,0.303 0,0.173 -0.086,0.39 -0.216,0.693 -0.173,0.303 -0.217,0.52 -0.217,0.779 0.086,0.606 0.217,1.212 0.52,1.862 0.043,0.26 0.087,0.39 0.13,0.39 -0.043,0.13 -0.043,0.26 0,0.476 -0.086,0.39 -0.26,0.563 -0.52,0.65 -0.39,-0.043 -0.693,0 -0.909,0.043 -0.086,0 -0.303,0.13 -0.736,0.347 0,0.043 0,0.129 0,0.303 0,0.086 0,0.216 0,0.347 0,0.216 0.216,0.519 0.606,0.996 0.043,0.086 0.173,0.216 0.346,0.433 0.043,0 0.173,0.043 0.477,0.086 0.216,0 0.346,0.043 0.39,0.13 0.044,0.087 0.13,0.216 0.26,0.433 0.086,0.173 0.26,0.173 0.433,0.043 0,0 0.086,-0.129 0.26,-0.346 l 0.13,-0.043 c 0.13,0.043 0.13,0.087 0.13,0.173 0.086,0.043 0.13,0.173 0.173,0.346 0.043,0.043 0.13,0.173 0.26,0.347 0.043,0.216 0.13,0.39 0.13,0.39 l 0.043,0.173 c -0.086,0.087 -0.216,0.13 -0.433,0.13 0,0.086 0,0.173 0.043,0.259 0.086,0.087 0.216,0.173 0.433,0.217 0.13,0.086 0.216,0.216 0.433,0.39 0.086,0.086 0.216,0.086 0.433,0.13 0.13,0 0.26,0.087 0.433,0.26 l 0.13,0.433 0.086,0.086 c 0.217,-0.043 0.39,-0.13 0.563,-0.303 0.13,-0.043 0.39,0 0.693,0.087 0.216,0.043 0.346,0.13 0.433,0.303 l 0.129,0.217 c 0,0.173 -0.043,0.39 -0.173,0.693 l -0.346,0.649 c -0.217,0.086 -0.433,0.173 -0.693,0.26 -0.606,0.043 -1.039,0.043 -1.299,0.043 -0.52,-0.043 -0.866,-0.043 -1.083,0 -0.173,0 -0.303,0 -0.39,0 -0.347,-0.043 -0.606,-0.043 -0.736,-0.043 -1.083,-0.043 -1.645,-0.043 -1.688,-0.043 -0.173,0.086 -0.39,0.39 -0.649,0.909 -0.26,0.433 -0.52,0.649 -0.823,0.649 -0.086,0 -0.26,-0.043 -0.52,-0.086 -0.346,-0.087 -0.563,-0.303 -0.693,-0.649 0.13,-0.477 0.13,-0.866 0.13,-1.126 -0.043,-0.043 -0.087,-0.13 -0.13,-0.26 -0.13,-0.303 -0.346,-0.779 -0.736,-1.429 -0.26,-0.476 -0.649,-0.866 -0.996,-1.125 -0.346,-0.173 -0.563,-0.347 -0.649,-0.433 -0.13,-0.346 -0.259,-0.606 -0.346,-0.736 -0.13,0.129 -0.086,0.606 0.087,1.385 0,0.13 -0.043,0.26 -0.173,0.39 -0.26,0.303 -0.563,0.433 -0.953,0.39 -0.563,-0.043 -0.909,-0.043 -1.083,0 l -0.043,0.173 c 0,0.173 0.173,0.52 0.52,1.039 l -0.173,0.476 c -0.303,0.52 -0.606,0.823 -0.823,0.953 -0.26,0.13 -0.606,0.043 -1.039,-0.216 -0.433,-0.217 -0.693,-0.477 -0.736,-0.779 0.043,-0.52 -0.043,-0.953 -0.259,-1.256 l -0.736,0.086 c -0.39,0 -0.866,-0.216 -1.515,-0.606 -0.26,-0.346 -0.26,-0.779 0.043,-1.385 0.217,-0.563 0.217,-0.953 -0.043,-1.169 -0.433,-0.26 -0.866,-0.173 -1.386,0.347 0,0 -0.216,0.26 -0.649,0.823 -0.086,0.13 -0.173,0.259 -0.303,0.433 -0.043,0.087 -0.173,0.217 -0.303,0.303 l -0.433,0.39 c -0.043,0.13 -0.043,0.39 0.086,0.736 l -0.043,0.173 -0.13,0.043 c -0.303,0 -0.649,-0.433 -0.909,-1.256 -0.087,-0.39 -0.217,-0.692 -0.26,-0.866 l -0.173,-0.52 c -0.087,-0.13 -0.216,-0.173 -0.347,-0.173 -0.303,0.043 -0.606,0.39 -0.822,0.996 -0.043,0.087 -0.13,0.217 -0.173,0.39 -0.043,0.086 0,0.52 0.173,1.212 0.086,0.52 0.043,0.866 -0.26,0.996 -0.259,-0.043 -0.433,-0.086 -0.563,-0.086 -0.26,-0.043 -0.433,0 -0.606,0.173 0,0 -0.13,0.303 -0.347,0.866 -0.173,0.39 -0.39,0.563 -0.736,0.52 -0.477,-0.043 -0.693,-0.303 -0.649,-0.693 0.433,-0.779 0.693,-1.299 0.736,-1.602 0.043,-0.13 0,-0.563 -0.13,-1.342 0.087,-0.433 0.13,-0.736 0.173,-0.909 0,-0.346 0,-0.779 -0.043,-1.429 0,-0.52 -0.086,-0.866 -0.086,-1.083 -0.087,-0.26 -0.26,-0.563 -0.606,-0.909 l -0.086,0.086 c -0.303,-0.043 -0.866,0.13 -1.602,0.606 -1.039,0.563 -1.602,0.866 -1.645,0.909 l -1.083,0.39 c -0.087,0 -0.477,0.26 -1.126,0.649 -0.13,0.087 -0.346,0.173 -0.606,0.303 -0.173,0.13 -0.433,0.346 -0.736,0.649 -0.13,0.13 -0.303,0.303 -0.433,0.563 -0.347,0.389 -0.52,0.649 -0.563,0.692 -0.303,0.477 -0.173,1.516 0.433,3.161 l 0.086,0.26 0.13,0.606 c 0.087,0.606 0.13,0.909 0.13,0.909 0,0.086 0,0.347 0,0.909 -0.086,0.13 -0.173,0.346 -0.39,0.649 -0.13,0.39 0.043,0.996 0.606,1.732 l 0.909,0.779 c 0.39,0.39 0.693,0.736 0.91,1.083 0.043,0.173 0.13,0.26 0.216,0.303 l -0.043,0.043 0.087,0.13 c 0,0.087 0,0.217 0,0.39 -0.043,0.13 -0.217,0.52 -0.606,1.212 -0.346,0.649 -0.606,1.083 -0.692,1.212 -0.043,0.043 -0.26,0.216 -0.649,0.563 -0.26,0.216 -0.433,0.476 -0.52,0.692 -0.043,0.217 -0.043,0.606 0.043,1.256 0.043,0.39 0.216,0.866 0.563,1.472 0.086,0.216 0.13,0.52 0.086,0.952 -0.086,0.433 -0.173,0.736 -0.346,0.823 -0.087,0.087 -0.26,0.173 -0.52,0.217 -1.732,0.563 -2.728,0.822 -2.901,0.779 -0.043,0 -0.303,0.086 -0.736,0.173 -0.086,0.043 -0.173,0.087 -0.216,0.13 -0.433,0.129 -0.693,0.216 -0.693,0.216 -0.173,0.043 -0.216,0.043 -0.303,0.086 -0.519,0.13 -0.866,0.303 -0.996,0.563 -0.173,0.216 -0.216,0.606 -0.173,1.169 0.043,0.173 0.087,0.433 0.217,0.736 0.086,0.216 0.13,0.519 0.173,0.996 0,0.216 0.087,0.563 0.26,1.039 0,0.173 -0.087,0.433 -0.217,0.866 -0.173,0.39 -0.563,0.693 -1.169,0.866 -0.606,0.173 -0.953,0.303 -0.996,0.39 -0.043,0.216 0,0.563 0.173,1.083 -0.086,0.52 -0.303,0.823 -0.693,0.909 -0.433,0.043 -0.736,0.086 -0.909,0.086 l -1.083,0.087 c -0.563,0.173 -0.779,0.433 -0.736,0.909 0.043,0.087 0.086,0.347 0.173,0.693 0.086,0.303 0.043,0.52 -0.087,0.649 l -0.216,0.087 c -0.173,0 -0.303,0 -0.39,0 -0.477,-0.043 -0.823,0 -1.039,0.13 l -0.043,0.13 c -0.173,0.216 -0.346,0.692 -0.606,1.342 -0.087,0.13 -0.13,0.217 -0.13,0.26 -0.216,0.26 -0.303,0.39 -0.303,0.476 0,0.087 0.173,0.216 0.52,0.39 0.303,0.173 0.52,0.347 0.606,0.52 0.043,0.043 0.043,0.303 0.043,0.866 0,0.476 0.13,0.866 0.347,1.169 0,0 0.129,0.13 0.39,0.39 l 0.043,0.13 c -0.129,0.26 -0.606,0.52 -1.299,0.779 -0.086,0.13 -0.086,0.216 -0.043,0.346 0.087,0.217 0.26,0.433 0.52,0.649 0.043,0.043 0.043,0.173 0.043,0.303 0.043,1.125 -0.563,1.602 -1.775,1.472 -0.649,-0.086 -1.126,-0.13 -1.342,-0.173 0.086,0.52 0.086,1.342 -0.043,2.468 0,0.217 0.087,0.563 0.217,1.04 0.043,0.173 0.043,0.52 0,0.909 0.13,1.992 0.086,3.074 -0.13,3.334 -0.043,0 -0.26,0.086 -0.649,0.173 -0.52,0.043 -0.78,0.086 -0.823,0.086 -0.13,-0.476 -0.26,-0.822 -0.39,-0.996 -0.346,-0.13 -0.519,-0.26 -0.649,-0.39 -0.129,-0.216 -0.216,-0.347 -0.303,-0.433 -0.173,-0.13 -0.303,-0.173 -0.347,-0.26 -0.216,-0.173 -0.346,-0.433 -0.346,-0.736 0,-0.347 0.087,-0.563 0.303,-0.779 0.043,-0.087 0.086,-0.13 0.086,-0.13 0.216,-0.303 0.433,-0.39 0.606,-0.39 l 0.477,0.39 c 0.173,0.13 0.347,0.173 0.563,0.043 0.26,0 0.433,0.173 0.649,0.52 l 0.13,-0.043 c 0.043,-0.26 0.086,-0.477 0.086,-0.563 0.217,-0.303 0.347,-0.52 0.347,-0.693 -0.043,-0.476 -0.087,-0.822 -0.087,-0.996 -0.043,-0.26 -0.043,-0.693 0,-1.386 0.043,-0.649 0.087,-1.082 0.173,-1.212 -0.303,0 -0.476,0.043 -0.476,0 -0.866,-0.303 -1.516,-0.477 -1.905,-0.52 -0.303,-0.129 -0.52,-0.173 -0.693,-0.173 -0.346,-0.087 -0.822,0.043 -1.342,0.26 -0.606,0.303 -0.909,0.606 -0.996,0.953 -0.086,0.13 -0.173,0.26 -0.216,0.476 -0.087,0.043 -0.087,0.086 -0.087,0.13 -0.086,0.13 -0.173,0.433 -0.26,0.779 -0.13,0.346 -0.173,0.606 -0.086,0.909 0.086,-0.086 0.39,-0.043 0.953,0.217 0.52,0.216 0.822,0.39 0.952,0.563 0.173,0.303 0.26,0.909 0.173,1.819 0.173,0.779 0.477,1.515 0.953,2.338 0.216,0.39 0.52,0.693 0.779,0.952 0.13,0.13 0.346,0.217 0.649,0.347 0.303,0.26 0.52,0.433 0.606,0.433 0.303,0.13 0.78,0.26 1.429,0.433 0.259,0.13 0.649,0.26 1.212,0.477 l 1.256,0.433 c 0.216,0.086 0.52,0.39 0.909,0.822 0.476,0.217 0.909,0.347 1.386,0.347 0.606,-0.043 0.952,0 1.169,0.086 0.13,0.043 0.476,0.216 0.996,0.52 0.346,0.216 0.693,0.346 1.083,0.346 0.173,0 0.606,-0.086 1.299,-0.216 0,-0.086 0.303,-0.173 0.823,-0.216 0.52,-0.087 0.736,-0.217 0.649,-0.477 -0.043,-0.086 -0.087,-0.13 -0.13,-0.216 l -0.347,-0.173 c -0.26,-0.13 -0.476,-0.216 -0.606,-0.346 -0.086,-0.086 -0.13,-0.217 -0.173,-0.433 l -0.823,-0.476 c 0,0.043 -0.173,0.26 -0.433,0.606 -0.303,0.303 -0.563,0.433 -0.823,0.39 -0.303,-0.173 -0.606,-0.26 -0.866,-0.303 -0.433,0.043 -0.779,0.043 -0.996,0 -0.13,-0.173 -0.216,-0.303 -0.303,-0.303 -0.476,-0.087 -0.779,-0.216 -0.866,-0.39 0,-0.173 0,-0.26 0,-0.347 -0.043,-0.13 -0.043,-0.26 -0.043,-0.303 -0.043,-0.26 0.043,-0.433 0.217,-0.649 0.13,-0.173 0.303,-0.26 0.52,-0.26 0,0.129 0.043,0.26 0.086,0.476 l 0.13,0.043 0.087,-0.043 c 0.13,-0.26 0.216,-0.433 0.216,-0.433 0.433,-0.346 0.649,-0.606 0.693,-0.692 l -0.087,-0.173 c -0.303,0 -0.52,0 -0.649,-0.043 -0.086,-0.043 -0.26,-0.216 -0.476,-0.476 -0.26,-0.303 -0.433,-0.477 -0.433,-0.563 0.087,-0.606 0.173,-0.996 0.173,-1.256 -0.13,-0.39 -0.173,-0.692 -0.173,-0.909 0.173,-0.39 0.26,-0.649 0.26,-0.823 -0.13,-0.389 -0.173,-0.649 -0.216,-0.822 -0.13,-1.299 -0.13,-2.425 0.043,-3.377 0.043,-0.347 0.216,-0.649 0.476,-0.823 0.216,-0.216 0.303,-0.433 0.346,-0.649 -0.173,-0.303 -0.26,-0.52 -0.303,-0.649 0,-0.26 0,-0.477 0,-0.563 -0.389,-0.433 -0.606,-0.736 -0.692,-0.909 -0.13,-0.347 -0.13,-0.823 -0.043,-1.342 0.086,-0.693 0.13,-1.125 0.086,-1.342 -0.086,-0.476 -0.129,-0.736 -0.129,-0.736 0.086,-0.13 0.129,-0.217 0.173,-0.217 h 0.13 c 0.13,0.173 0.347,0.78 0.606,1.862 0.043,0.13 0.13,0.347 0.303,0.649 0,0.13 0,0.347 -0.086,0.65 0.173,0.173 0.303,0.346 0.346,0.476 0.087,0.346 0.087,1.169 0,2.338 0,0.13 0.087,0.433 0.173,0.866 l -0.216,0.129 v 0.087 c 0.39,0.303 0.606,0.476 0.649,0.606 0,0.086 -0.043,0.217 -0.086,0.39 -0.043,0.173 -0.087,0.433 -0.087,0.866 -0.086,0.13 -0.13,0.216 -0.13,0.26 l 0.043,0.173 c 0.043,0 0.173,0.087 0.303,0.26 0.477,0.606 0.563,1.342 0.347,2.208 -0.043,0.173 -0.13,0.433 -0.303,0.736 0.043,0.087 0.086,0.173 0.086,0.303 0.217,0.606 0.347,0.996 0.347,1.169 0,0.13 -0.043,0.303 -0.173,0.563 -0.086,0.26 -0.13,0.433 -0.086,0.563 l 0.086,0.13 c 0.13,-0.13 0.26,-0.173 0.39,-0.173 0.086,0.043 0.217,0.173 0.346,0.346 0.217,0 0.39,0 0.477,0.086 0.043,0.13 0.043,0.26 0.086,0.52 0,0.086 0.173,0.26 0.476,0.433 0.26,0.13 0.39,0.303 0.39,0.477 l -0.13,0.086 c -0.26,-0.086 -0.433,-0.086 -0.606,-0.086 v 0.13 c 0,0.086 0.087,0.216 0.217,0.346 0.086,0.173 0.129,0.303 0.129,0.433 l 0.823,0.476 c -0.043,-0.303 0.173,-0.52 0.606,-0.692 0.433,-0.13 0.606,-0.303 0.563,-0.563 -0.346,-0.433 -0.433,-0.823 -0.346,-1.169 0.043,-0.043 0.217,-0.087 0.52,-0.13 0.347,-0.086 0.693,0 0.866,0.303 0.13,0.13 0.303,0.39 0.52,0.693 0.173,0.043 0.433,0 0.736,-0.086 0.173,0.043 0.39,0.303 0.693,0.736 0.693,0.649 1.212,0.693 1.602,0.173 0.13,-0.173 0.173,-0.433 0.26,-0.823 0.043,-0.433 0.13,-0.693 0.216,-0.866 h 0.086 l 0.043,-0.043 0.953,0.043 c 0.173,-0.043 0.346,-0.173 0.476,-0.477 0.173,-0.303 0.347,-0.433 0.477,-0.52 0.26,-0.043 0.433,-0.13 0.563,-0.173 0.173,-0.129 0.477,-0.346 0.866,-0.692 l -1.862,-1.732 -0.086,0.043 c -0.996,0.087 -1.602,0.043 -1.862,-0.086 -0.087,-0.086 -0.087,-0.303 0,-0.692 0.086,-0.477 0.086,-0.736 0.043,-0.78 l -0.346,-0.779 c -0.086,-0.303 -0.13,-0.433 -0.13,-0.433 -0.173,-0.347 -0.217,-0.606 -0.086,-0.736 h 0.173 c 0.043,0 0.173,0.26 0.347,0.736 0.173,0.433 0.346,0.649 0.52,0.649 -0.087,-0.347 -0.087,-0.606 -0.13,-0.736 0,-0.866 -0.043,-1.385 -0.043,-1.645 -0.13,-0.303 -0.216,-0.52 -0.216,-0.693 -0.347,-1.126 -0.347,-2.078 -0.13,-2.771 0.043,0.043 0.13,0.13 0.303,0.346 0.043,0.043 0.13,0.173 0.26,0.303 0.129,0.13 0.173,0.39 0.129,0.823 0,0.433 0,0.693 0.043,0.866 0.043,0.13 0.217,0.433 0.477,0.823 v 0.216 c 0,0.26 0,0.649 0.086,1.169 0,0.13 0,0.303 -0.043,0.563 0.043,0.13 0.173,0.303 0.347,0.476 0.086,0.043 0.26,-0.043 0.476,-0.216 0.26,-0.26 0.433,-0.39 0.52,-0.433 0.086,-0.086 0.216,-0.043 0.26,0.043 l 2.251,-0.649 c -0.347,-0.216 -0.433,-0.476 -0.26,-0.779 0.39,-0.217 0.606,-0.606 0.693,-1.169 0.043,-0.087 0.13,-0.173 0.216,-0.173 0.043,-0.433 0.13,-0.693 0.217,-0.866 0.563,-0.866 0.866,-1.429 0.952,-1.689 0,-0.13 0.043,-0.433 0,-1.039 0,-0.563 0,-0.952 -0.043,-1.039 -0.043,-0.216 -0.087,-0.39 -0.087,-0.476 -0.043,-0.649 -0.086,-0.996 -0.086,-0.996 -0.217,-0.346 -0.346,-0.52 -0.39,-0.606 0,-0.216 0.086,-0.39 0.216,-0.476 0.087,-0.087 0.303,-0.043 0.52,0.129 l 0.39,0.173 c 0.043,0 0.13,0.173 0.26,0.433 0.13,0.26 0.173,0.39 0.173,0.476 0,0.173 -0.043,0.477 -0.173,0.866 0.173,0.13 0.26,0.216 0.303,0.303 0.043,0.173 0,0.606 -0.173,1.255 -0.13,0.649 -0.26,1.039 -0.346,1.212 -0.086,0.13 -0.26,0.346 -0.433,0.606 -0.043,0.173 -0.13,0.563 -0.216,1.083 -0.087,0.173 -0.26,0.303 -0.52,0.476 -0.173,0.13 -0.346,0.39 -0.39,0.736 -0.043,0.303 -0.043,0.606 0.043,0.823 0.173,0.346 0.476,0.563 0.866,0.52 l -0.043,0.216 -0.086,0.043 c -0.26,0 -0.433,-0.043 -0.563,-0.043 -0.216,0 -0.563,0 -1.039,0 l -2.251,0.649 c 0.043,0 0.043,0.086 0.043,0.173 0,0.39 -0.173,0.779 -0.477,1.039 -0.13,0.476 -0.173,0.693 -0.173,0.736 -0.043,0.13 0,0.347 0.043,0.693 -0.043,0.13 -0.13,0.26 -0.346,0.303 l 1.862,1.732 c 0.433,0 0.866,-0.13 1.255,-0.433 0.043,-0.043 0.217,-0.173 0.39,-0.346 0.52,0.043 0.823,-0.043 0.91,-0.13 0.043,-0.129 0.129,-0.173 0.173,-0.173 l 0.043,-0.043 c 0.13,-0.26 0.216,-0.433 0.346,-0.52 0.26,-0.303 0.433,-0.476 0.477,-0.52 0.173,-0.216 0.303,-0.433 0.346,-0.563 0.173,-0.13 0.39,-0.13 0.649,-0.043 h 0.13 0.173 c 0.649,0.303 1.082,0.346 1.385,0.043 0.39,-0.39 0.606,-0.606 0.649,-0.606 0.13,-0.043 0.477,0.043 1.083,0.26 0.303,0.043 0.649,0.043 1.126,-0.043 0.39,-0.086 0.692,-0.086 0.909,-0.043 0.043,0 0.26,0.13 0.606,0.39 0.39,0.303 0.823,0.433 1.212,0.433 0.389,0 0.909,0.26 1.645,0.736 0.13,0 0.26,0.043 0.347,0.086 0.216,0.13 0.563,0.303 1.083,0.52 0.043,0 0.39,0.346 0.909,0.996 0.563,0.692 0.823,1.082 0.866,1.212 0.606,1.558 0.823,2.771 0.563,3.593 0,0.087 -0.043,0.173 -0.087,0.26 -0.086,0.043 -0.086,0.347 -0.129,0.953 0,0.216 0,0.433 0,0.693 l 0.303,0.13 c 0.13,-0.043 0.303,-0.216 0.52,-0.52 l 0.13,-0.043 c 0.13,0.173 0.26,0.303 0.477,0.39 0.043,-0.043 0.086,-0.173 0.216,-0.433 0.043,-0.043 0.216,-0.086 0.433,-0.086 0.086,-0.13 0.086,-0.303 0,-0.563 -0.086,-0.303 -0.173,-0.52 -0.13,-0.606 -0.043,0 0,-0.086 0.086,-0.26 0.26,-0.909 0.39,-1.602 0.563,-2.035 0.216,-0.433 0.346,-0.736 0.346,-0.953 -0.13,-0.26 -0.216,-0.519 -0.26,-0.692 0.13,-0.433 0.173,-0.649 0.173,-0.693 -0.173,-0.346 -0.26,-0.649 -0.26,-0.866 0,-0.563 0,-0.909 -0.043,-0.996 -0.26,-0.216 -0.433,-0.39 -0.563,-0.52 v -0.086 c 0.129,0 0.346,0.043 0.606,0.13 l 0.13,-0.087 c 0.043,-0.13 0.043,-0.433 0.043,-0.952 0,-0.519 -0.043,-0.866 -0.086,-0.953 -0.086,-0.087 -0.26,-0.303 -0.39,-0.736 -0.086,-0.086 -0.173,-0.129 -0.303,-0.086 0,0.043 -0.043,0.086 -0.173,0.216 -0.13,0.866 -0.26,1.299 -0.347,1.386 0,-0.52 -0.043,-0.909 -0.173,-1.083 l -0.173,-0.043 c -0.13,0 -0.26,0.087 -0.303,0.217 -0.13,0.26 -0.216,0.39 -0.26,0.39 l -0.13,0.043 c -0.043,-0.129 -0.086,-0.346 -0.043,-0.649 0,-0.346 -0.043,-0.563 -0.129,-0.606 l -0.217,-0.043 c -0.216,0.087 -0.346,0.347 -0.433,0.78 0,0.216 0,0.519 0,0.952 h -0.173 c -0.087,-0.043 -0.173,-0.13 -0.26,-0.216 v -0.043 h -0.043 c -0.173,-0.346 -0.303,-0.606 -0.433,-0.736 -0.173,-0.26 -0.346,-0.433 -0.433,-0.563 -0.043,-0.13 -0.087,-0.216 -0.043,-0.303 l 0.086,-0.13 c 0.217,-0.043 0.433,-0.26 0.649,-0.649 0.173,-0.476 0.347,-0.779 0.433,-0.866 0.173,0.043 0.346,-0.043 0.52,-0.26 0.087,-0.26 0.173,-0.52 0.26,-0.693 -0.173,-0.086 -0.303,-0.13 -0.39,-0.173 -0.043,0 -0.216,0 -0.52,0 -0.563,-0.043 -0.953,-0.174 -1.169,-0.52 -0.086,-0.086 -0.13,-0.173 -0.13,-0.346 0.26,-1.169 0.39,-1.992 0.346,-2.425 -0.303,-1.559 -0.346,-2.641 -0.216,-3.247 0.086,-0.216 0.216,-0.39 0.52,-0.563 0.346,-0.173 0.563,-0.346 0.693,-0.39 l -0.043,-0.216 c -0.173,-0.13 -0.346,-0.217 -0.39,-0.347 -0.346,-0.433 -0.216,-1.169 0.39,-2.208 0.13,-0.173 0.26,-0.303 0.347,-0.39 0,-0.086 0.043,-0.173 0.043,-0.216 -0.173,-0.347 -0.303,-0.606 -0.346,-0.736 -0.173,-0.346 -0.217,-0.606 -0.13,-0.822 l 0.13,-0.087 0.086,0.043 0.217,0.216 c 0,0.087 0.086,0.217 0.173,0.433 0.13,0.13 0.39,0.173 0.779,0.13 l 0.087,0.086 c 0.043,0.13 0.043,0.347 0.086,0.649 0.086,0.043 0.173,0.13 0.346,0.26 0.043,0.26 -0.086,0.563 -0.433,0.996 0,0.173 -0.087,0.52 -0.173,1.083 0,0.13 0.13,0.346 0.346,0.649 0,0.216 -0.086,0.563 -0.26,0.996 0,0.173 0.043,0.303 0.173,0.39 0.086,0.087 0.216,0.217 0.476,0.346 0.433,0.477 0.78,0.996 1.04,1.646 0.086,0.217 0.086,0.477 0,0.823 -0.087,0.303 -0.087,0.563 -0.043,0.736 h 0.13 c 0.086,-0.217 0.173,-0.39 0.216,-0.433 0.52,-0.173 0.909,-0.303 1.126,-0.52 -0.043,-0.303 -0.043,-0.52 0,-0.693 0.043,-0.086 0.129,-0.13 0.173,-0.13 0.303,0.13 0.477,0.216 0.52,0.216 0.043,0 0.303,-0.173 0.693,-0.476 0.606,-0.26 0.953,-0.52 0.996,-0.779 -0.043,-0.26 -0.217,-0.39 -0.52,-0.433 -0.39,-0.043 -0.606,-0.13 -0.692,-0.173 -0.347,-0.303 -0.649,-0.692 -0.823,-1.125 -0.13,-0.39 -0.086,-0.736 0.13,-0.996 0,-0.086 0.086,-0.13 0.173,-0.173 0.173,-0.087 0.39,-0.173 0.736,-0.217 0.173,-0.086 0.346,-0.173 0.606,-0.346 0.129,-0.043 0.346,-0.043 0.649,0 0.173,-0.303 0.26,-0.476 0.346,-0.52 l 0.086,-0.087 0.173,0.043 0.087,0.087 c -0.043,0.346 0.043,0.563 0.173,0.649 0.303,0.173 0.433,0.303 0.477,0.303 0.129,0.13 0.216,0.347 0.303,0.693 l 0.13,0.043 c 0.043,-0.087 0.043,-0.26 0.043,-0.563 0,-0.173 0,-0.346 0,-0.433 0,-0.043 -0.086,-0.216 -0.217,-0.52 -0.216,-0.476 -0.303,-0.736 -0.346,-0.822 -0.086,-0.606 0.043,-1.213 0.39,-1.862 h 0.173 c 0.13,0.347 0.13,0.78 0,1.342 0,0 0.13,0.26 0.39,0.693 h 0.086 c 0.303,-0.909 0.52,-1.386 0.52,-1.386 -0.173,-0.216 -0.216,-0.389 -0.26,-0.519 0,-0.13 0,-0.347 0.043,-0.649 0.13,-0.563 0.52,-0.736 1.212,-0.52 l -0.173,-0.649 c -0.043,0.043 -0.26,0.087 -0.606,0.13 l -0.087,-0.087 -0.043,-0.13 c -0.086,-0.13 -0.173,-0.173 -0.259,-0.173 0,-0.39 -0.043,-0.692 -0.043,-0.866 0,-0.086 0.13,-0.173 0.303,-0.303 0,-0.26 0.043,-0.433 0.13,-0.52 0.086,0 0.13,0.087 0.216,0.216 0.086,0.043 0.216,0.087 0.433,0.087 0.043,0.043 0.086,0.13 0.173,0.26 0.087,0.216 0.13,0.346 0.13,0.476 -0.043,0.043 -0.086,0.216 -0.173,0.39 -0.043,0.13 -0.13,0.303 -0.173,0.52 l 0.173,0.649 c 0.303,0.087 0.52,0.173 0.606,0.217 0.086,0.043 0.347,0.433 0.779,1.169 0,0.043 0.13,0.216 0.303,0.477 l 0.173,-0.043 c 0.086,-0.477 0.173,-0.736 0.259,-0.78 0.13,0.043 0.26,0.173 0.433,0.347 l 0.13,-0.043 c 0,-0.216 0.087,-0.39 0.087,-0.476 0.13,-0.217 0.173,-0.346 0.173,-0.477 -0.13,-0.259 -0.26,-0.519 -0.26,-0.649 0.217,-0.39 0.347,-0.649 0.433,-0.822 0.043,-0.736 0.13,-1.126 0.217,-1.212 v -0.043 l 0.173,0.043 c 0.043,0.086 0.173,0.26 0.39,0.563 0,0.13 0.043,0.26 0.087,0.476 0,0.173 -0.13,0.433 -0.303,0.736 0.086,0.086 0.173,0.259 0.303,0.39 0.173,0.346 0.173,0.736 0,1.212 l 0.736,-0.563 c 0.346,-0.303 0.563,-0.52 0.736,-0.649 0.217,-0.13 0.347,-0.26 0.477,-0.347 l 0.52,-0.476 c 0.346,-0.217 0.649,-0.347 0.779,-0.52 0.086,-0.087 0.13,-0.13 0.173,-0.173 0.216,-0.433 0.39,-0.649 0.433,-0.693 0.217,-0.303 0.39,-0.52 0.52,-0.693 0.086,-0.129 0.216,-0.433 0.433,-0.822 0.26,-0.953 0.823,-1.819 1.688,-2.685 0.866,-0.909 1.342,-1.385 1.386,-1.472 0.173,-0.086 0.346,-0.216 0.563,-0.39 0.086,-0.13 0.216,-0.26 0.26,-0.346 0.476,-0.649 0.996,-1.212 1.645,-1.602 0.173,-0.173 0.303,-0.303 0.346,-0.346 0.173,-0.26 0.303,-0.649 0.433,-1.169 0.13,-0.563 0.216,-0.909 0.26,-0.996 l -0.476,-0.216 c 0.043,0.173 -0.086,0.52 -0.347,0.952 -0.086,0.13 -0.26,0.347 -0.476,0.606 -0.52,0.779 -0.953,1.169 -1.342,1.125 -0.216,-0.173 -0.346,-0.433 -0.433,-0.779 -0.086,-0.433 -0.173,-0.736 -0.216,-0.866 -0.692,-0.823 -1.039,-1.342 -1.083,-1.472 0,-0.347 0,-0.563 -0.043,-0.693 -0.13,-0.693 -0.347,-1.212 -0.606,-1.472 -0.303,-0.173 -0.563,-0.26 -0.692,-0.346 -0.303,-0.346 -0.52,-0.606 -0.736,-0.693 -0.216,-0.086 -0.39,-0.13 -0.476,-0.13 l -0.26,-0.173 c -0.996,-0.217 -1.688,-0.477 -2.078,-0.693 -0.216,-0.173 -0.476,-0.39 -0.779,-0.693 -0.26,-0.433 -0.476,-0.736 -0.649,-0.909 l -0.779,-0.823 c -0.173,-0.303 -0.303,-0.52 -0.39,-0.606 -0.39,-0.52 -0.563,-0.779 -0.563,-0.823 -0.043,-0.26 -0.043,-0.52 0.173,-0.823 0.043,-0.086 0.26,-0.39 0.649,-0.866 0.39,-0.477 0.649,-0.736 0.736,-0.779 0.13,0 0.217,-0.043 0.26,-0.043 0.086,-0.043 0.216,-0.13 0.433,-0.173 l 0.736,-0.13 h 0.13 c 0.086,-0.086 0.26,-0.086 0.476,-0.043 0.39,0.129 0.477,0.563 0.173,1.299 -0.043,0.086 -0.13,0.303 -0.13,0.52 0.043,0.216 0.173,0.303 0.433,0.39 0.216,0.043 0.39,0.13 0.433,0.216 0,0 0.173,0.346 0.39,0.91 0.13,0.389 0.303,0.563 0.52,0.519 0.173,0 0.346,-0.173 0.476,-0.519 0.043,-0.043 0,-0.347 0,-0.91 -0.086,-0.693 0,-1.169 0.26,-1.472 0.086,0.086 0.216,0.649 0.433,1.645 0,0.13 0.043,0.303 0.13,0.563 0.043,0.217 0.086,0.65 0.13,1.342 0.043,0.087 0.303,0.26 0.692,0.52 0.347,0.26 0.649,0.39 0.866,0.433 0.216,0.217 0.433,0.433 0.649,0.563 0.13,0.13 0.26,0.39 0.346,0.779 0.087,0.346 0.13,0.649 0.087,0.823 -0.043,0.086 -0.087,0.216 -0.217,0.476 -0.086,0.173 -0.13,0.347 -0.086,0.476 0.043,0.087 0.173,0.217 0.303,0.347 0.129,0.13 0.346,0.26 0.649,0.477 0.129,0.086 0.26,0.346 0.433,0.692 0.043,0.043 0.303,0.26 0.779,0.606 0.39,0.259 0.606,0.476 0.606,0.649 l 0.476,0.216 c 0.39,-0.173 0.649,-0.39 0.779,-0.606 0.433,-1.039 0.779,-1.818 1.126,-2.251 0.13,-0.13 0.216,-0.217 0.303,-0.303 0.26,-0.477 0.477,-0.823 0.606,-1.039 0.476,-0.433 0.779,-0.779 0.996,-0.996 0.173,-0.303 0.433,-0.823 0.736,-1.602 0.26,-0.822 0.39,-1.385 0.346,-1.602 l -0.13,-0.259 c -0.26,-0.087 -0.476,-0.173 -0.693,-0.39 -0.259,-0.216 -0.346,-0.433 -0.173,-0.649 l 0.086,-0.086 c 0.173,-0.043 0.433,0.043 0.779,0.303 0.39,0.26 0.649,0.39 0.823,0.39 0.043,-0.086 0.086,-0.303 0.173,-0.649 0.086,-0.13 0.216,-0.26 0.259,-0.303 l 0.26,-0.13 c 0.26,-0.216 0.563,-0.433 0.822,-0.693 0.173,-0.433 0.26,-0.736 0.303,-0.996 0.173,-0.693 0.216,-1.083 0.26,-1.125 0.173,-0.303 0.26,-0.563 0.346,-0.736 0,-0.087 0.043,-0.216 0,-0.346 -0.173,-0.217 -0.303,-0.347 -0.346,-0.433 0.043,-0.476 0.043,-0.779 -0.043,-1.039 -0.043,-0.086 -0.216,-0.217 -0.476,-0.347 -0.26,-0.129 -0.39,-0.303 -0.476,-0.563 0,-0.13 0,-0.217 0.043,-0.303 0.217,-0.303 0.433,-0.52 0.563,-0.693 0.303,-0.779 0.606,-1.212 0.953,-1.299 l -0.996,-1.169 c -0.433,0.173 -0.779,0.086 -1.039,-0.303 l -0.563,1.169 c -0.043,0.346 -0.216,0.606 -0.563,0.779 -0.347,0.13 -0.649,0.043 -0.866,-0.303 -0.216,-0.433 -0.389,-0.779 -0.563,-0.953 -0.519,-0.649 -0.866,-1.169 -1.082,-1.515 -0.26,-0.823 -0.52,-1.386 -0.823,-1.646 -0.216,-0.173 -0.476,-0.303 -0.779,-0.39 -0.476,-0.13 -0.736,-0.26 -0.866,-0.303 -0.217,-0.13 -0.39,-0.216 -0.39,-0.303 l 0.043,-0.087 c 0.173,-0.043 0.433,0 0.823,0 l 0.086,-0.043 c 0.043,-0.087 0.043,-0.217 0,-0.303 -0.216,-0.303 -0.433,-0.779 -0.606,-1.472 -0.13,-0.303 -0.173,-0.476 -0.173,-0.606 0.217,-0.26 0.26,-0.606 0.173,-0.996 -0.173,-0.649 -0.303,-1.083 -0.303,-1.385 h 0.13 c 0.086,0.043 0.13,0.13 0.173,0.173 v 0.086 c 0.043,0.173 0.173,0.433 0.346,0.78 v 0.346 c 0.043,0.953 0.216,1.688 0.563,2.295 0.13,0.26 0.346,0.476 0.52,0.606 0.13,0.086 0.346,0.217 0.693,0.39 0.13,0.13 0.39,0.39 0.779,0.823 0.173,0.216 0.346,0.606 0.476,1.125 0.087,0.477 0.216,0.823 0.347,0.953 0.043,0.086 0.39,0.39 0.996,0.953 0.477,0.476 0.779,0.779 0.866,0.996 l 0.563,-1.169 c 0,-0.043 -0.043,-0.303 -0.13,-0.822 0,-0.347 -0.216,-1.169 -0.649,-2.468 -0.13,-0.39 -0.216,-0.606 -0.26,-0.693 -0.086,-0.13 -0.346,-0.39 -0.866,-0.692 -0.52,-0.347 -0.866,-0.606 -0.996,-0.736 -0.13,-0.346 -0.216,-0.563 -0.303,-0.693 -0.216,-0.39 -0.346,-0.692 -0.39,-0.822 0,-0.087 0,-0.39 -0.043,-0.953 V 274.7 h 0.173 l 0.13,0.086 0.086,0.13 0.043,0.043 c 0.087,0.823 0.26,1.515 0.477,2.165 0,0.087 0.086,0.217 0.216,0.347 0.13,0.173 0.347,0.303 0.693,0.52 0.216,0.173 0.52,0.52 0.909,0.953 0.606,0.476 0.953,0.779 1.083,0.952 0.26,0.347 0.433,0.953 0.563,1.862 0.043,0.086 0.173,0.173 0.39,0.346 0.13,0.173 0.26,0.346 0.346,0.563 -0.216,0.649 -0.346,1.04 -0.346,1.126 l -0.087,0.13 0.996,1.169 c 0.13,-0.043 0.303,0 0.606,0.13 0.26,0.13 0.52,0.173 0.779,0.043 0.736,-0.26 1.299,-0.52 1.689,-0.823 0.129,-0.086 0.39,-0.303 0.779,-0.563 0.217,-0.13 0.52,-0.086 0.78,0.043 0.736,-0.606 1.299,-0.953 1.732,-1.039 l 0.952,-0.303 c 0.26,-0.086 0.433,-0.173 0.563,-0.173 0.346,-0.043 0.866,-0.043 1.516,0 0.043,-0.043 0.39,-0.13 0.996,-0.347 0.347,-0.13 0.693,-0.173 1.083,-0.13 0,-0.216 -0.086,-0.649 -0.26,-1.386 -0.043,-0.129 -0.043,-0.216 -0.043,-0.26 h -0.086 c -0.13,-0.086 -0.26,-0.173 -0.346,-0.303 -0.173,-0.563 -0.347,-0.953 -0.477,-1.212 l -0.13,-0.217 v -0.173 l 0.13,-0.043 c 0.303,0.043 0.563,0 0.693,-0.216 l 0.043,-0.13 c -0.303,-0.736 -0.433,-1.386 -0.39,-2.035 0.173,-0.433 0.217,-0.823 0.173,-1.039 -0.13,-0.173 -0.173,-0.303 -0.173,-0.39 -0.043,-0.043 -0.13,-0.39 -0.26,-1.039 -0.043,-0.173 -0.086,-0.26 -0.13,-0.303 -0.563,-0.13 -0.909,-0.303 -0.996,-0.52 -0.043,-0.52 -0.216,-0.996 -0.433,-1.385 -0.606,-0.477 -1.082,-0.779 -1.385,-0.953 -0.39,-0.173 -0.563,-0.26 -0.563,-0.26 -0.086,-0.13 -0.086,-0.346 -0.043,-0.693 0,-0.433 0,-0.693 -0.043,-0.822 -0.217,-0.433 -0.303,-0.78 -0.303,-0.996 0.043,-0.39 0.043,-0.649 0,-0.866 -0.173,-0.476 -0.303,-0.866 -0.346,-1.125 0,-0.39 -0.043,-0.649 -0.13,-0.823 -0.043,-0.086 -0.087,-0.173 -0.13,-0.216 -0.129,-0.477 -0.216,-0.996 -0.173,-1.645 l 0.086,-0.087 c 0.26,0.347 0.433,0.779 0.52,1.255 0.043,0.087 0.043,0.173 0,0.347 0.043,0.13 0.13,0.346 0.347,0.649 0.043,0.13 0.086,0.39 0.086,0.736 0.086,0.173 0.173,0.39 0.303,0.736 v 0.693 c 0,0.043 0,0.13 0,0.173 0.173,0 0.433,-0.043 0.779,-0.086 0.346,0 0.606,-0.043 0.866,-0.086 0.13,-0.043 0.26,-0.303 0.433,-0.78 0.173,-0.173 0.39,-0.173 0.606,0 l 0.173,0.26 h 0.13 c 0.173,-0.129 0.563,-0.216 1.083,-0.216 0.043,0 0.086,0 0.173,0.043 0.78,0 1.169,-0.043 1.299,-0.13 0.043,-0.303 0.086,-0.52 0.173,-0.649 0.477,-0.216 0.736,-0.347 0.78,-0.347 0.26,-0.346 0.433,-0.909 0.476,-1.732 0.173,-0.086 0.303,-0.129 0.39,-0.173 0.26,-0.173 0.346,-0.52 0.216,-1.169 -0.043,-0.26 -0.043,-0.433 0,-0.476 0.217,-0.174 0.39,-0.26 0.433,-0.347 0.043,-0.13 0.043,-0.303 0,-0.477 -0.086,-0.303 -0.216,-0.433 -0.433,-0.433 -0.303,0.043 -0.52,0 -0.692,-0.043 -0.087,-0.39 -0.173,-0.693 -0.26,-0.823 -0.086,-0.173 -0.346,-0.476 -0.779,-0.866 -0.043,-0.043 -0.13,-0.173 -0.173,-0.346 0.043,-0.26 0.043,-0.433 -0.043,-0.52 l -0.13,-0.086 c -0.173,-0.043 -0.39,0 -0.649,0.173 -0.26,0.13 -0.476,0.216 -0.606,0.26 l -0.129,-0.043 c -0.303,-0.303 -0.78,-0.563 -1.386,-0.693 -0.346,-0.086 -0.477,-0.303 -0.477,-0.649 0.087,-0.39 0.087,-0.693 0.087,-0.866 0,-0.086 0.173,-0.173 0.39,-0.26 0.303,-0.086 0.476,-0.13 0.52,-0.173 0.346,-0.39 0.606,-0.649 0.823,-0.779 v -0.216 c -0.217,-0.736 -0.433,-1.212 -0.606,-1.429 l -0.173,-0.043 c -0.043,0.043 -0.563,0.13 -1.602,0.39 -0.303,0.043 -0.953,0.26 -1.905,0.736 -0.043,0 -0.086,0 -0.173,0 l -0.087,-0.086 c 0.087,-0.39 0.043,-0.649 -0.13,-0.779 -0.086,-0.086 -0.216,-0.13 -0.346,-0.086 -0.563,0 -0.953,0 -1.256,-0.043 -0.216,-0.087 -0.39,-0.13 -0.476,-0.173 -0.779,-0.086 -1.342,-0.173 -1.732,-0.26 l -1.775,-6.321 c 0.043,-0.086 0.217,-0.433 0.39,-0.996 0.173,-0.52 0.303,-0.823 0.303,-0.953 0.13,-0.649 0.173,-0.953 0.173,-1.039 -0.086,-0.217 -0.13,-0.346 -0.043,-0.433 0.173,-0.043 0.303,-0.173 0.39,-0.216 0.173,-0.823 0.173,-1.516 0,-2.035 l -0.65,-0.216 c -0.216,-0.736 -0.346,-1.169 -0.476,-1.256 -0.823,0 -1.299,0 -1.386,0 l -0.086,-0.13 c 0.303,-0.346 0.52,-0.606 0.649,-0.779 l -0.26,-0.39 v -0.173 c -0.13,-0.346 -0.216,-0.563 -0.216,-0.692 l -0.087,-0.086 c -0.39,0.086 -0.736,0.129 -0.909,0.173 -0.563,0.13 -0.909,0.217 -1.039,0.26 -0.043,0.086 -0.13,0.303 -0.173,0.736 -0.086,0.433 -0.216,0.736 -0.389,0.953 -0.13,0 -0.26,-0.086 -0.433,-0.26 -0.217,-0.216 -0.303,-0.346 -0.303,-0.433 0.173,-0.043 0.303,-0.087 0.347,-0.173 v -0.173 l -0.26,-0.692 c -1.125,0.086 -1.731,0.043 -1.948,-0.087 -0.086,-0.13 -0.13,-0.216 -0.086,-0.303 -0.086,-0.087 -0.26,-0.13 -0.476,-0.217 l -0.173,0.086 c -0.087,0.303 -0.433,0.649 -1.083,0.909 l -0.303,-0.129 -0.26,-0.347 -0.13,-0.043 c -0.692,0.043 -1.212,0.173 -1.515,0.303 -0.303,-0.303 -0.52,-0.52 -0.649,-0.606 -0.649,-0.217 -1.04,-0.39 -1.083,-0.433 -0.043,-0.433 -0.087,-0.736 -0.13,-0.823 -0.26,-0.52 -0.346,-0.866 -0.39,-0.996 0,-0.173 0.086,-0.433 0.303,-0.779 0.173,-0.303 0.216,-0.606 0.129,-0.823 -0.216,-0.303 -0.433,-0.476 -0.563,-0.476 l -0.087,-0.087 c -0.173,-0.086 -0.303,-0.216 -0.433,-0.39 -0.043,-0.346 0.086,-0.606 0.39,-0.866 0.26,-0.217 0.303,-0.693 0.13,-1.516 -0.043,0 -0.39,-0.13 -0.953,-0.39 -0.13,0 -0.173,0 -0.173,0 -0.476,-0.303 -0.779,-0.52 -0.866,-0.736 -0.043,-0.043 -0.13,-0.433 -0.26,-1.083 -0.087,-0.866 -0.173,-1.516 -0.26,-1.948 l -0.217,-1.083 c -0.043,-0.779 -0.086,-1.256 -0.173,-1.472 0,-0.086 -0.13,-0.216 -0.26,-0.346 -0.39,-0.563 -0.736,-0.996 -0.996,-1.212 -0.086,-0.13 -0.26,-0.173 -0.563,-0.217 -0.303,-0.043 -0.476,-0.129 -0.563,-0.173 0,-0.477 0,-0.866 -0.043,-1.039 0.087,-0.217 0.216,-0.303 0.303,-0.303 0,-0.26 0,-0.433 0,-0.52 l 0.043,-0.953 -0.087,-0.086 c -0.26,0.043 -0.39,0 -0.52,-0.086 l -0.086,-0.087 c 0.086,-0.26 0.303,-0.433 0.649,-0.649 l 0.866,-0.39 c 0.173,-0.043 0.303,0.043 0.477,0.173 l 0.13,-0.086 c 0.129,-0.26 0.216,-0.347 0.26,-0.39 0.216,-0.086 0.433,0 0.649,0.173 l 0.216,-0.043 0.086,-0.13 0.087,-0.563 -0.693,-0.217 c -0.086,-0.173 -0.043,-0.433 0.043,-0.909 l -0.043,-0.13 c -0.303,-0.13 -0.563,-0.173 -0.736,-0.086 -0.26,0.086 -0.39,0.13 -0.52,0.13 -0.779,-0.303 -1.342,-0.433 -1.775,-0.477 -0.433,0.26 -0.736,0.39 -0.823,0.347 -0.39,-0.086 -0.649,-0.173 -0.822,-0.217 -0.563,0.217 -0.91,0.303 -1.126,0.217 -1.126,-0.433 -1.688,-0.649 -1.688,-0.649 -0.13,-0.477 -0.26,-0.823 -0.433,-0.996 -0.26,-0.216 -0.476,-0.433 -0.52,-0.649 -0.043,-0.606 -0.13,-0.953 -0.346,-1.125 -0.087,-0.13 -0.13,-0.26 -0.13,-0.26 v -0.13 c -0.563,0.52 -0.953,0.693 -1.256,0.52 -0.13,-0.217 -0.216,-0.39 -0.26,-0.476 -0.173,-0.174 -0.303,-0.26 -0.476,-0.174 -0.173,0.087 -0.39,0.39 -0.606,0.953 -0.303,0.52 -0.52,0.91 -0.736,1.083 -0.216,-0.043 -0.476,-0.26 -0.866,-0.779 -0.347,-0.52 -0.693,-0.736 -0.91,-0.736 -0.086,0 -0.39,0.173 -0.822,0.39 -0.13,0.086 -0.303,0.086 -0.563,0 -0.086,0.13 -0.26,0.303 -0.52,0.476 -0.173,-0.043 -0.477,0.087 -0.866,0.39 -0.433,0.217 -0.693,0.303 -0.78,0.303 -0.13,-0.26 -0.216,-0.39 -0.346,-0.433 -0.087,-0.043 -0.26,0 -0.433,0.13 -0.39,0.26 -0.39,0.649 0,1.126 l 0.433,0.606 c 0.346,0.476 0.346,0.953 0,1.429 0,0.086 -0.087,0.13 -0.173,0.217 0,0.086 0,0.303 0.086,0.692 l -0.086,0.13 -0.086,0.043 c -0.346,-0.216 -0.563,-0.303 -0.779,-0.303 -0.433,0.173 -0.779,0.26 -1.039,0.303 -0.347,0 -1.083,0.043 -2.122,0 -0.779,-0.043 -1.299,-0.086 -1.516,-0.216 0,0 -0.216,-0.13 -0.606,-0.347 -0.39,-0.303 -0.649,-0.433 -0.736,-0.563 -0.043,-0.087 -0.087,-0.173 -0.173,-0.217 h -0.173 c -0.26,0.39 -0.693,0.693 -1.342,0.866 -0.216,0.043 -0.39,0.086 -0.52,0.13 -0.13,0.216 -0.346,0.346 -0.563,0.346 -0.433,0.086 -0.822,0.13 -1.212,0.086 -0.477,-0.086 -0.866,-0.086 -1.126,-0.086 -0.476,0.13 -0.866,0.173 -1.169,0.173 -0.043,-0.087 -0.693,-0.39 -1.905,-0.909 -0.216,-0.043 -0.346,-0.173 -0.433,-0.26 -0.086,-0.216 -0.173,-0.303 -0.217,-0.346 l -0.433,-0.26 c -0.403,-0.264 -0.793,-0.611 -1.096,-1.087",
                        "Mykolaiv": "m 266.492,215.167 c -0.087,0.477 -0.13,0.736 -0.043,0.909 l 0.693,0.217 -0.087,0.563 -0.086,0.13 -0.216,0.043 c -0.216,-0.173 -0.433,-0.26 -0.649,-0.173 -0.043,0.043 -0.13,0.13 -0.26,0.39 l -0.13,0.086 c -0.173,-0.13 -0.303,-0.217 -0.477,-0.173 l -0.866,0.39 c -0.347,0.216 -0.563,0.39 -0.649,0.649 l 0.086,0.087 c 0.13,0.086 0.26,0.129 0.52,0.086 l 0.087,0.086 -0.043,0.953 c 0,0.086 0,0.26 0,0.52 -0.087,0 -0.216,0.086 -0.303,0.303 0.043,0.173 0.043,0.563 0.043,1.039 0.086,0.043 0.26,0.13 0.563,0.173 0.303,0.043 0.477,0.087 0.563,0.217 0.26,0.216 0.606,0.649 0.996,1.212 0.13,0.13 0.26,0.26 0.26,0.346 0.086,0.216 0.13,0.693 0.173,1.472 l 0.217,1.083 c 0.086,0.433 0.173,1.082 0.26,1.948 0.13,0.649 0.216,1.039 0.26,1.083 0.086,0.216 0.39,0.433 0.866,0.736 0,0 0.043,0 0.173,0 0.563,0.26 0.909,0.39 0.953,0.39 0.173,0.823 0.13,1.299 -0.13,1.516 -0.303,0.26 -0.433,0.52 -0.39,0.866 0.13,0.173 0.26,0.303 0.433,0.39 l 0.087,0.087 c 0.13,0 0.346,0.173 0.563,0.476 0.087,0.217 0.043,0.52 -0.129,0.823 -0.217,0.346 -0.303,0.606 -0.303,0.779 0.043,0.13 0.13,0.476 0.39,0.996 0.043,0.087 0.086,0.39 0.13,0.823 0.043,0.043 0.433,0.216 1.083,0.433 0.13,0.086 0.346,0.303 0.649,0.606 0.303,-0.13 0.823,-0.26 1.515,-0.303 l 0.13,0.043 0.26,0.347 0.303,0.129 c 0.649,-0.26 0.996,-0.606 1.083,-0.909 l 0.173,-0.086 c 0.216,0.086 0.39,0.13 0.476,0.217 -0.043,0.086 0,0.173 0.086,0.303 0.217,0.13 0.823,0.173 1.948,0.087 l 0.26,0.692 v 0.173 c -0.043,0.086 -0.173,0.13 -0.347,0.173 0,0.086 0.086,0.216 0.303,0.433 0.173,0.173 0.303,0.26 0.433,0.26 0.173,-0.216 0.303,-0.52 0.389,-0.953 0.043,-0.433 0.13,-0.649 0.173,-0.736 0.13,-0.043 0.477,-0.13 1.039,-0.26 0.173,-0.043 0.52,-0.086 0.909,-0.173 l 0.087,0.086 c 0,0.13 0.086,0.346 0.216,0.692 v 0.173 l 0.26,0.39 c -0.13,0.173 -0.346,0.433 -0.649,0.779 l 0.086,0.13 c 0.087,0 0.563,0 1.386,0 0.13,0.087 0.26,0.52 0.476,1.256 l 0.65,0.216 c 0.173,0.52 0.173,1.212 0,2.035 -0.087,0.043 -0.217,0.173 -0.39,0.216 -0.087,0.087 -0.043,0.216 0.043,0.433 0,0.086 -0.043,0.39 -0.173,1.039 0,0.13 -0.13,0.433 -0.303,0.953 -0.173,0.563 -0.347,0.909 -0.39,0.996 l 1.775,6.321 c 0.39,0.087 0.953,0.173 1.732,0.26 0.086,0.043 0.26,0.086 0.476,0.173 0.303,0.043 0.693,0.043 1.256,0.043 0.13,-0.043 0.26,0 0.346,0.086 0.173,0.13 0.217,0.39 0.13,0.779 l 0.087,0.086 c 0.086,0 0.13,0 0.173,0 0.953,-0.476 1.602,-0.692 1.905,-0.736 1.039,-0.26 1.559,-0.347 1.602,-0.39 l 0.173,0.043 c 0.173,0.217 0.39,0.693 0.606,1.429 v 0.216 c -0.217,0.13 -0.477,0.39 -0.823,0.779 -0.043,0.043 -0.216,0.087 -0.52,0.173 -0.216,0.086 -0.39,0.173 -0.39,0.26 0,0.173 0,0.476 -0.087,0.866 0,0.347 0.13,0.563 0.477,0.649 0.606,0.13 1.083,0.39 1.386,0.693 l 0.129,0.043 c 0.13,-0.043 0.347,-0.13 0.606,-0.26 0.26,-0.173 0.476,-0.216 0.649,-0.173 l 0.13,0.086 c 0.086,0.087 0.086,0.26 0.043,0.52 0.043,0.173 0.13,0.303 0.173,0.346 0.433,0.39 0.693,0.693 0.779,0.866 0.087,0.13 0.173,0.433 0.26,0.823 0.173,0.043 0.389,0.086 0.692,0.043 0.217,0 0.347,0.13 0.433,0.433 0.043,0.173 0.043,0.347 0,0.477 -0.043,0.086 -0.216,0.173 -0.433,0.347 -0.043,0.043 -0.043,0.216 0,0.476 0.13,0.649 0.043,0.996 -0.216,1.169 -0.087,0.043 -0.216,0.086 -0.39,0.173 -0.043,0.823 -0.216,1.386 -0.476,1.732 -0.043,0 -0.303,0.13 -0.78,0.347 -0.086,0.13 -0.13,0.346 -0.173,0.649 -0.13,0.086 -0.52,0.13 -1.299,0.13 -0.086,-0.043 -0.129,-0.043 -0.173,-0.043 -0.52,0 -0.909,0.087 -1.083,0.216 h -0.13 l -0.173,-0.26 c -0.216,-0.173 -0.433,-0.173 -0.606,0 -0.173,0.477 -0.303,0.736 -0.433,0.78 -0.26,0.043 -0.52,0.086 -0.866,0.086 -0.346,0.043 -0.606,0.086 -0.779,0.086 0.086,1.126 0.433,1.905 1.083,2.338 0.26,0.26 0.476,0.346 0.519,0.389 0.217,0.043 0.563,-0.043 1.04,-0.303 l 0.086,0.043 c 0.173,0.173 0.13,0.52 -0.086,0.996 -0.043,0.13 0.043,0.346 0.216,0.563 0.173,0.26 0.346,0.433 0.476,0.476 0.13,0.087 0.347,0.13 0.693,0.216 0.216,0.26 0.303,0.65 0.216,1.169 -0.043,0.649 -0.043,1.083 0,1.299 0.043,0.043 0.13,0.216 0.347,0.476 0.13,0.173 0.216,0.347 0.216,0.52 0,0.13 -0.13,0.39 -0.346,0.78 -0.173,0.346 -0.26,0.606 -0.26,0.736 0.043,0.173 0.303,0.39 0.779,0.649 l 0.043,0.13 c -0.087,0.13 -0.26,0.26 -0.563,0.476 -0.13,0.26 -0.217,0.606 -0.13,0.953 0.043,0.39 0.043,0.693 -0.13,0.953 l -0.043,0.043 c 0,0.043 0,0.13 0.043,0.26 0.173,0.736 0.26,1.169 0.26,1.386 0.26,0 0.822,0.173 1.602,0.606 0.086,0 0.563,0.087 1.429,0.173 0.26,0.043 0.606,0.13 1.125,0.26 0.087,0.043 0.217,0.043 0.303,0 l 0.303,-0.086 c 0.216,-0.13 0.563,-0.303 0.953,-0.563 0.216,-0.086 0.563,-0.216 0.996,-0.346 0.216,-0.087 0.347,-0.26 0.347,-0.477 0.043,-0.26 0.086,-0.476 0.129,-0.52 0.52,-0.346 0.91,-0.649 1.083,-0.909 0.217,-0.52 0.346,-0.866 0.477,-1.083 0.216,-0.346 0.346,-0.606 0.476,-0.779 0.086,-0.173 0.173,-0.346 0.173,-0.52 0,-0.13 -0.043,-0.26 -0.173,-0.39 -0.303,-0.043 -0.563,-0.173 -0.866,-0.39 -0.39,-0.26 -0.563,-0.563 -0.606,-0.909 0.043,-0.433 0,-0.823 -0.086,-1.083 -0.13,-0.26 -0.173,-0.433 -0.216,-0.563 l 0.086,-0.087 h 0.173 c 0.259,0.173 0.433,0.477 0.476,0.909 0.043,0.477 0.13,0.736 0.26,0.866 0.086,0.043 0.26,0.173 0.563,0.26 l 0.476,0.52 c 0.303,0.13 0.476,0.043 0.563,-0.347 0.086,-0.303 0.086,-0.606 0,-0.866 l 0.043,-0.173 c 0.346,-0.086 0.563,-0.173 0.692,-0.26 0.606,-0.346 0.996,-0.779 1.212,-1.212 0.043,-0.433 0.086,-0.736 0.216,-0.91 0.303,0.043 0.433,0.303 0.39,0.693 -0.086,0.303 -0.26,0.649 -0.563,0.996 -0.217,0.216 -0.477,0.52 -0.78,0.866 -0.26,0.303 -0.39,0.649 -0.39,1.039 0,0.476 -0.043,0.823 -0.086,0.953 -0.173,0.433 -0.52,0.866 -0.996,1.299 -0.087,0.173 -0.13,0.477 -0.13,0.909 -0.043,0.13 -0.173,0.303 -0.347,0.476 -0.303,0.13 -0.52,0.217 -0.606,0.347 -0.173,0.13 -0.26,0.346 -0.26,0.606 -0.043,0.26 0,0.433 0.216,0.52 0.087,0.043 0.347,0.086 0.779,0.129 0.347,0 0.65,0.13 0.909,0.26 l 0.26,0.173 c 0.043,0.13 0.217,0.26 0.477,0.346 0.26,0.087 0.433,0.087 0.563,-0.043 0.13,-0.693 0.303,-1.169 0.477,-1.342 0.26,-0.39 0.693,-0.606 1.255,-0.606 0.52,-0.043 1.212,0.173 2.079,0.692 0.173,0.087 0.433,0.216 0.822,0.477 0.26,0.086 0.606,0.13 0.996,0.043 0.26,0.043 0.606,0.217 1.082,0.477 0.26,0.043 0.78,-0.173 1.473,-0.606 l 0.52,-0.26 c 0.692,-0.26 1.039,-0.649 1.082,-1.125 -0.433,-0.779 -0.563,-1.429 -0.39,-1.992 0.173,-0.736 0.26,-1.126 0.217,-1.212 -0.087,-0.52 -0.347,-0.953 -0.649,-1.255 l -0.26,-0.173 c -0.173,-0.217 -0.347,-0.476 -0.39,-0.693 -0.173,-0.563 -0.087,-1.125 0.303,-1.818 0.217,-0.346 0.563,-0.649 0.996,-0.823 0.563,-0.26 0.866,-0.433 0.953,-0.52 0.129,-0.173 0.39,-0.693 0.649,-1.559 0.303,-0.909 0.433,-1.429 0.39,-1.646 0,-0.129 -0.13,-0.216 -0.303,-0.303 -0.433,0.26 -0.779,0.433 -1.039,0.52 -0.217,0.043 -0.477,0 -0.693,-0.217 -0.477,-0.476 -0.173,-1.385 0.866,-2.728 0.217,-0.26 0.303,-0.52 0.26,-0.693 -0.129,-0.26 -0.389,-0.26 -0.822,0.043 -0.52,0.346 -0.78,0.52 -0.823,0.52 -0.26,0 -0.433,-0.043 -0.563,-0.043 -0.26,-0.043 -0.52,-0.173 -0.649,-0.39 -0.086,-0.086 -0.173,-0.26 -0.216,-0.519 -0.217,-0.606 -0.086,-1.256 0.39,-1.949 0.433,-0.736 0.606,-1.256 0.476,-1.559 -0.173,-0.52 -0.476,-0.866 -0.866,-0.953 -0.477,-0.13 -0.736,-0.303 -0.779,-0.433 -0.087,-0.173 -0.043,-0.563 0.173,-1.169 0.13,-0.606 0.087,-1.125 -0.173,-1.602 -0.173,-0.26 -0.39,-0.433 -0.649,-0.52 -0.39,-0.086 -0.649,-0.13 -0.823,-0.216 -0.476,-0.13 -0.823,-0.39 -1.083,-0.779 -0.173,-0.26 -0.216,-0.606 -0.086,-0.996 0.13,-0.433 0.39,-0.649 0.736,-0.649 l 0.13,0.086 c 0,0.26 -0.043,0.649 -0.173,1.255 0.086,0.347 0.476,0.606 1.168,0.823 0.736,0.217 1.213,0.39 1.342,0.563 0.173,0.26 0.26,0.649 0.173,1.169 -0.086,0.649 -0.086,1.039 -0.086,1.212 0.086,0.303 0.26,0.563 0.649,0.692 0.433,0.173 0.693,0.303 0.779,0.433 0.13,0.13 0.216,0.346 0.303,0.649 0.173,0.779 0,1.688 -0.563,2.771 -0.13,0.26 -0.217,0.477 -0.217,0.649 0.043,0.303 0.347,0.477 0.91,0.52 0.26,-0.217 0.563,-0.303 0.866,-0.347 0.563,-0.13 0.996,-0.086 1.299,0.173 0.433,0.303 0.303,0.779 -0.39,1.472 -0.736,0.692 -0.953,1.299 -0.606,1.775 0.13,0.086 0.52,0.086 1.125,0 0.433,-0.086 0.779,0 0.953,0.347 0.087,0.129 0.13,0.303 0.13,0.433 0,0.26 -0.173,0.866 -0.433,1.862 -0.303,1.039 -0.52,1.646 -0.65,1.818 -0.043,0.043 -0.26,0.26 -0.692,0.649 -0.26,0.26 -0.433,0.52 -0.477,0.866 -0.086,0.216 -0.086,0.433 -0.086,0.693 -0.043,0.303 0,0.649 0.043,1.082 0.26,0.779 0.433,1.212 0.477,1.212 0.043,0.13 0.173,0.303 0.39,0.52 0.13,0 0.433,0.043 0.909,0.086 0.346,0.087 0.649,0.043 0.909,0 0.303,-0.433 0.52,-0.692 0.649,-0.779 0.26,-0.303 0.606,-0.346 1.039,-0.13 0.13,0.043 0.303,0.217 0.477,0.52 0.173,0.087 0.563,0 1.169,-0.173 0.692,-0.217 1.212,-0.606 1.559,-1.212 0.173,-0.217 0.26,-0.476 0.347,-0.779 0.216,-0.606 0.346,-0.909 0.39,-0.996 0.563,-0.347 1.039,-0.39 1.342,-0.26 0.347,0.173 0.649,0.303 0.909,0.39 0.13,0.087 0.347,0.13 0.649,0.26 l 0.563,0.086 c 0.26,0.086 0.477,0.043 0.563,0 0.086,-0.086 0.173,-0.303 0.303,-0.606 0.26,-0.909 0.476,-1.385 0.606,-1.429 1.255,-0.26 1.992,-0.346 2.122,-0.26 0.13,0.13 0.216,0.346 0.303,0.693 0.13,0.216 0.433,0.26 0.996,0.13 0.52,-0.173 0.866,-0.303 0.996,-0.52 0.13,-0.173 0.173,-0.563 0.13,-1.125 v -0.477 c 0.216,0 0.389,0 0.52,0.043 l 0.043,0.303 0.087,0.087 c 0.086,0 0.26,-0.043 0.476,-0.087 0.086,0.043 0.086,0.217 0.086,0.477 0.13,0.13 0.433,0.086 0.953,-0.086 0.52,-0.173 0.823,-0.217 0.909,-0.087 0.086,0.303 0.433,0.52 1.169,0.606 0.13,0.087 0.26,0.347 0.433,0.693 0.173,0.303 0.39,0.39 0.693,0.346 l 1.688,-0.259 c 0.303,-0.043 0.693,0 1.299,0.13 0.173,0.043 0.477,-0.173 0.909,-0.606 0.303,-0.173 0.78,-0.26 1.472,-0.346 0.606,-0.043 0.996,-0.13 1.169,-0.303 l 0.087,-0.39 -0.043,-0.086 c -0.303,0.086 -0.563,0.086 -0.779,-0.043 -0.086,-0.173 -0.173,-0.303 -0.26,-0.346 -0.52,0.216 -1.039,0.303 -1.688,0.346 -0.823,0 -1.256,-0.216 -1.342,-0.649 0,-0.086 0.086,-0.216 0.26,-0.39 0.693,0 1.732,-0.13 3.074,-0.433 0.173,0 0.477,-0.346 0.866,-0.953 0.13,-0.13 0.563,-0.303 1.342,-0.519 0.086,0 0.303,0 0.649,0 0.086,-0.13 0.13,-0.26 0.043,-0.477 -0.043,-0.173 -0.13,-0.26 -0.26,-0.346 -0.606,0.043 -1.083,0.043 -1.342,0 -0.173,-0.087 -0.26,-0.39 -0.303,-0.866 -0.043,-0.476 -0.043,-0.823 0,-0.953 0.26,-0.346 0.476,-0.476 0.736,-0.39 0.173,0.087 0.347,0.347 0.606,0.779 l 0.866,0.606 0.087,0.086 -0.043,-0.433 c 0,-0.13 0.216,-0.433 0.649,-0.953 0.347,-0.433 0.52,-0.736 0.433,-0.909 -0.043,-0.087 -0.26,-0.303 -0.649,-0.693 -0.39,-0.433 -0.649,-0.649 -0.779,-0.693 -1.039,-0.736 -1.688,-1.125 -1.862,-1.125 -0.389,0.086 -0.649,0.086 -0.779,0.043 -0.13,-0.043 -0.173,-0.173 -0.173,-0.303 v -0.39 c -0.087,-0.26 -0.13,-0.433 -0.13,-0.563 0.39,-0.649 0.649,-1.083 0.779,-1.299 0.086,-0.173 0.173,-0.39 0.26,-0.649 0.173,-0.303 0.303,-0.563 0.346,-0.736 0.13,-0.26 0.26,-0.649 0.433,-1.169 h 0.173 c 0.13,0.13 0.26,0.303 0.433,0.606 l -0.043,0.086 c 0.173,-0.13 0.606,-0.13 1.299,-0.086 0,0 0.086,-0.087 0.303,-0.26 0.26,-0.303 0.52,-0.649 0.822,-1.125 0.217,-0.216 0.563,-0.086 1.083,0.347 l 0.173,0.043 c 0.13,-0.043 0.216,-0.173 0.26,-0.476 0.086,-0.347 0.173,-0.563 0.303,-0.736 -0.606,-0.909 -0.953,-1.602 -0.996,-2.035 0,-0.303 0,-0.649 0.13,-1.082 0.043,-0.13 0.13,-0.347 0.26,-0.649 0.173,-0.606 0.217,-1.126 0.086,-1.602 -0.043,-0.216 -0.26,-0.736 -0.606,-1.559 -0.086,-0.13 -0.346,-0.217 -0.866,-0.217 l -0.693,-0.043 c -0.26,0 -0.433,-0.217 -0.563,-0.606 -0.086,-0.346 -0.13,-0.606 -0.086,-0.866 0.39,-0.173 0.606,-0.303 0.693,-0.477 0.043,-0.086 0.086,-0.26 0.043,-0.519 0,-0.217 0.043,-0.347 0.13,-0.433 l 0.13,-0.043 c 0.216,0.26 0.433,0.823 0.736,1.775 0.346,0.086 0.779,0.086 1.299,-0.043 0.216,-0.173 0.13,-0.606 -0.26,-1.299 0.173,-0.649 0.216,-1.126 0.173,-1.472 -0.26,-0.52 -0.433,-0.909 -0.477,-1.212 0.303,-0.433 0.39,-0.736 0.26,-0.953 -0.433,-0.39 -0.736,-0.692 -0.866,-0.909 -0.087,-0.606 -0.043,-1.125 0,-1.602 -0.303,-0.043 -1.083,-0.173 -2.338,-0.303 -0.346,-0.087 -0.563,-0.217 -0.606,-0.477 -0.043,-0.26 0.13,-0.563 0.477,-0.909 0.346,-0.346 0.52,-0.606 0.52,-0.779 0,-0.433 -0.173,-0.996 -0.477,-1.602 -0.476,-0.909 -0.736,-1.385 -0.779,-1.559 0.086,-0.173 0.693,-0.433 1.905,-0.736 h 0.303 c 0.736,-0.087 1.083,-0.13 1.126,-0.13 0,-0.606 0,-0.952 -0.087,-1.039 -0.476,-0.26 -0.779,-0.476 -0.909,-0.563 0.086,-0.779 0.086,-1.212 0.086,-1.429 l -0.086,-0.996 c 0,-0.433 0,-0.693 0.129,-0.909 0.087,-0.26 0.173,-0.476 0.173,-0.606 -0.086,-0.52 -0.086,-0.953 0,-1.169 0.043,-0.129 0.173,-0.303 0.476,-0.563 0,-0.087 0,-0.26 -0.086,-0.52 -0.086,-0.303 -0.13,-0.477 -0.173,-0.52 -0.476,0.086 -0.866,0.173 -1.125,0.13 -0.217,-0.043 -0.346,-0.173 -0.346,-0.26 -0.043,-0.217 0.173,-0.823 0.649,-1.818 -0.043,-0.087 -0.13,-0.173 -0.26,-0.303 h -0.13 c -0.043,0.043 -0.043,0.043 -0.043,0.043 l -0.043,-0.13 c -0.303,-0.086 -0.476,-0.173 -0.563,-0.303 0.086,-0.433 0.086,-0.736 0.043,-0.909 0,-0.13 -0.173,-0.347 -0.433,-0.65 -0.26,-0.303 -0.433,-0.606 -0.52,-0.779 0.043,-0.347 -0.043,-0.563 -0.173,-0.736 l -0.173,-0.043 c -0.39,0.39 -0.649,0.563 -0.779,0.649 -0.173,0 -0.39,0 -0.649,-0.173 -0.303,-0.173 -0.563,-0.217 -0.779,-0.13 -0.433,0.346 -0.563,0.736 -0.477,1.169 0.13,0.52 0.13,0.779 0.087,0.866 -0.087,0.043 -0.26,0.13 -0.563,0.216 -0.303,0.043 -0.52,0.087 -0.649,0.043 l -0.086,0.087 c -0.087,0.39 -0.173,0.649 -0.303,0.866 -0.087,0.086 -0.26,0.13 -0.433,0.086 -0.173,-0.086 -0.303,-0.173 -0.39,-0.26 -0.216,-0.39 -0.39,-0.692 -0.52,-0.866 l -0.13,-0.086 c -0.303,0.216 -0.649,0.346 -0.953,0.346 -0.433,0.043 -0.736,0.086 -0.909,0.216 -0.086,0 -0.26,0.13 -0.606,0.347 -0.217,0.13 -0.347,0.433 -0.433,0.909 -0.043,0.476 0.043,0.736 0.347,0.779 l 0.692,0.086 -0.043,0.909 c -0.043,0.043 -0.303,0.13 -0.693,0.13 -0.477,0.043 -0.736,0.087 -0.779,0.173 -0.173,0.173 -0.13,0.563 0.173,1.083 0.043,0.13 0.043,0.433 -0.043,0.909 l 0.043,0.13 0.346,0.26 c 0.043,0.13 0,0.26 -0.043,0.346 -0.563,0 -0.866,0.087 -0.909,0.13 0,0.996 -0.043,1.602 -0.173,1.731 l -1.948,0.173 c -0.043,0 -0.173,0.043 -0.433,0.13 l -2.468,0.433 c -0.433,0.086 -0.693,0.13 -0.779,0.086 -0.173,-0.043 -0.606,-0.173 -1.169,-0.39 -0.649,-0.303 -0.996,-0.476 -1.083,-0.563 l -0.173,-0.043 c -0.433,0.303 -0.736,0.477 -0.866,0.477 -0.173,-0.346 -0.52,-0.649 -1.039,-0.996 -0.52,-0.347 -0.953,-0.52 -1.342,-0.433 l -0.563,0.13 c -0.346,0.086 -0.563,0.173 -0.693,0.26 -0.129,0.26 -0.26,0.433 -0.303,0.52 l -0.433,0.649 c -0.26,0.563 -0.476,0.996 -0.606,1.212 -0.303,0.433 -0.649,0.649 -1.082,0.693 -0.606,0.043 -1.039,-0.043 -1.299,-0.303 -0.217,-0.736 -0.477,-1.212 -0.693,-1.472 -0.433,-0.216 -0.736,-0.433 -0.909,-0.563 -0.173,-0.26 -0.347,-0.346 -0.433,-0.433 -0.043,-0.043 -0.303,-0.087 -0.822,-0.26 -0.65,-0.13 -0.953,0.129 -0.996,0.822 l -0.13,0.043 c -1.255,0 -2.251,0 -2.901,0.043 -0.13,0 -0.26,0 -0.303,-0.087 -0.043,0 -0.043,-0.39 0.043,-1.125 0,-0.173 -0.043,-0.347 -0.217,-0.52 -0.129,-0.216 -0.216,-0.347 -0.259,-0.52 0,-0.087 0.173,-0.433 0.606,-1.039 0.346,-0.477 0.39,-0.91 0.13,-1.256 l -0.736,-0.866 c -0.13,-0.13 -0.173,-0.433 -0.173,-0.78 -0.26,-0.433 -0.433,-0.649 -0.52,-0.649 -0.303,0 -0.606,0.087 -0.953,0.347 l -0.13,-0.043 -0.823,-1.169 c -0.043,-0.043 -0.303,-0.52 -0.779,-1.385 -0.303,-0.563 -0.476,-0.953 -0.52,-0.996 0.693,-0.216 1.299,-0.52 1.818,-0.953 0.13,-0.13 0.173,-0.346 0.216,-0.692 -0.173,-0.433 -0.26,-0.736 -0.303,-0.953 -0.087,-0.52 -0.216,-0.823 -0.39,-0.866 -0.043,0 -0.39,0.043 -0.996,0.217 -0.563,0.13 -0.909,0.173 -1.039,0.043 l -0.043,-0.26 -0.13,-0.13 c -0.13,-0.086 -0.347,0 -0.649,0.26 l -0.173,-0.043 c -0.52,-0.693 -0.823,-0.996 -0.866,-0.996 -0.043,0 -0.303,0.173 -0.866,0.476 -0.086,0.217 -0.086,0.563 0,0.996 -0.26,0.173 -0.606,0.26 -1.083,0.303 l -0.13,-0.477 -0.086,-0.086 c -0.13,-0.043 -0.303,0 -0.476,0.13 -0.087,0.303 -0.13,0.779 -0.087,1.472 l -0.13,0.13 h -0.649 l -0.13,-0.087 c 0.216,-0.433 0.346,-0.779 0.39,-0.909 0.086,-1.039 0.043,-1.688 -0.086,-1.818 -0.173,-0.086 -0.823,-0.086 -1.992,0 -0.303,0.26 -0.52,0.433 -0.693,0.52 -0.26,0.043 -0.433,-0.043 -0.563,-0.303 -0.086,-0.303 -0.173,-0.52 -0.216,-0.649 -0.173,-0.043 -0.347,0.086 -0.606,0.346 -0.347,0.216 -0.563,0.39 -0.606,0.433 -0.866,-0.216 -1.342,-0.303 -1.472,-0.303 -0.52,0 -0.866,-0.043 -1.083,-0.043 -0.39,-0.043 -0.693,-0.216 -0.866,-0.52 l -0.13,-0.216 0.043,-0.866 c 0.043,-0.216 -0.13,-0.346 -0.433,-0.39 -0.39,-0.043 -0.606,-0.043 -0.649,-0.086 -0.086,-0.086 -0.13,-0.649 -0.216,-1.775 -0.043,-0.217 -0.13,-0.303 -0.303,-0.303 -0.563,0.043 -0.909,0.043 -1.039,-0.043 -0.173,-0.173 -0.26,-0.26 -0.303,-0.26 -0.043,0 -0.477,0.086 -1.255,0.303 -0.433,0.086 -0.65,-0.043 -0.693,-0.477 -0.043,-0.086 -0.346,-0.086 -0.823,0 -0.606,0.13 -0.996,0.26 -1.169,0.26 -0.13,0.043 -0.26,0.173 -0.303,0.39 -0.043,0.91 -0.26,1.342 -0.563,1.299 -0.692,-0.087 -1.083,-0.043 -1.169,0.086 -0.043,0.39 -0.13,0.606 -0.216,0.693 -0.173,0.13 -0.39,0.216 -0.649,0.26 -0.303,0.043 -0.52,-0.087 -0.606,-0.26 l -0.043,-0.693 c -0.043,-0.086 -0.13,-0.216 -0.26,-0.303 -0.173,-0.13 -0.346,-0.216 -0.477,-0.216 -0.346,0.086 -0.606,0.52 -0.779,1.342 -0.173,0.086 -0.39,0.086 -0.649,-0.043 -0.086,-0.346 -0.13,-0.606 -0.173,-0.736 l -0.217,-0.217 c -0.303,0.087 -0.476,0.13 -0.606,0.13 -0.173,0.043 -0.433,0.087 -0.866,0.087 -0.303,-0.173 -0.52,-0.303 -0.736,-0.347 -0.26,0 -0.476,0 -0.606,0.087 -0.13,0.086 -0.26,0.13 -0.303,0.13 -0.736,0.043 -1.126,0.13 -1.212,0.26 0,0.173 -0.13,0.346 -0.303,0.606 -0.043,0.216 -0.13,0.433 -0.216,0.563 -0.216,0.303 -1.256,0.086 -3.118,-0.736 -0.129,-0.043 -0.303,0 -0.476,0.173 -0.13,-0.086 -0.216,-0.086 -0.26,-0.086 -0.346,0 -0.606,0 -0.822,0 -0.563,-0.087 -0.996,-0.13 -1.256,-0.13 -0.303,0.13 -0.563,0.173 -0.779,0.13 -0.173,-0.173 -0.303,-0.303 -0.433,-0.347 -0.563,-0.216 -1.039,0.087 -1.429,0.866 -0.216,0.433 -0.347,0.649 -0.39,0.692 -0.13,0.087 -0.433,0.13 -0.823,0.043 l 0.04,0.142",
                        "Lviv": "m 55.81,132.167 c -0.563,0.347 -1.169,0.996 -1.818,1.949 -0.26,0.216 -0.39,0.476 -0.39,0.779 -0.13,0.173 -0.346,0.433 -0.693,0.779 -0.13,0.173 -0.433,0.606 -0.823,1.255 -0.173,0.217 -0.52,0.693 -1.125,1.386 -0.13,0.173 -0.347,0.476 -0.563,0.909 -0.173,0.173 -0.476,0.346 -0.909,0.476 -0.173,0.217 -0.26,0.606 -0.26,1.256 -0.043,0.26 -0.346,0.52 -0.909,0.736 -0.606,0.26 -0.953,0.779 -0.996,1.559 -0.043,0.433 -0.217,0.78 -0.519,1.039 -0.433,0.39 -0.693,0.65 -0.78,0.736 -0.086,0.173 -0.217,0.39 -0.303,0.736 -0.217,0.043 -0.52,0.087 -0.909,0.087 -0.346,0.173 -0.52,0.39 -0.65,0.649 -0.087,0.173 -0.173,0.476 -0.303,0.909 -0.303,0.693 -0.823,1.472 -1.602,2.338 -0.087,0.043 -0.346,0.433 -0.909,1.169 -0.173,0.26 -0.26,0.433 -0.303,0.52 -0.043,0.087 -0.086,0.26 -0.13,0.477 -0.087,0.26 -0.217,0.563 -0.476,0.996 0,0.13 0,0.346 0,0.606 0.216,0.216 0.39,0.389 0.476,0.52 l 0.216,0.303 c 0.217,0.39 0.303,0.779 0.303,1.169 0.043,0.216 0.086,0.563 0.13,1.039 0,0.26 -0.043,0.606 -0.087,1.082 0.043,0.13 0.216,0.347 0.606,0.606 0.346,0.303 0.606,0.563 0.736,0.866 0.173,0.303 0.173,1.169 0.087,2.598 0,0.173 0.13,0.477 0.346,0.91 0.173,0.346 0.303,0.692 0.303,1.039 0,0.433 -0.173,0.996 -0.563,1.775 -0.13,0.26 -0.303,0.736 -0.52,1.342 l 0.043,0.13 c 0,0.26 -0.173,0.693 -0.433,1.256 -0.26,0.52 -0.39,0.866 -0.346,1.039 l 0.13,0.13 c 0.13,0.043 0.26,-0.043 0.389,-0.173 0.043,-0.216 0.13,-0.346 0.217,-0.433 0.086,-0.043 0.173,-0.043 0.303,0 l 0.13,0.043 0.043,0.173 c -0.043,0.13 -0.087,0.303 -0.217,0.433 l 0.043,0.173 c 0.043,0.086 0.13,0.173 0.217,0.173 0.433,0.043 0.779,0.086 1.082,0.173 0.173,0.173 0.217,0.433 0.13,0.78 0.563,0.26 0.909,0.476 1.083,0.649 0.216,0.303 0.303,0.433 0.346,0.433 0.303,0 0.52,0 0.606,0.13 0.043,0.087 0.043,0.26 0.087,0.477 0.26,0 0.476,0.043 0.649,0.216 l 0.043,0.13 -0.043,0.173 c -0.303,0.26 -0.476,0.476 -0.476,0.563 0,0.086 0,0.26 0.087,0.563 -0.043,0.39 -0.043,0.606 -0.043,0.693 0.043,0.086 0.087,0.26 0.217,0.39 l -0.043,0.173 c 0.26,0.173 0.389,0.303 0.476,0.39 0.087,0.086 0.087,0.303 0,0.606 h 0.087 c 0.043,0.087 0.216,0.26 0.563,0.563 0,0.13 0,0.216 -0.043,0.346 -0.606,1.256 -0.563,2.295 0.173,3.161 0.433,0.433 0.649,0.693 0.736,0.736 0.476,0.216 0.779,0.39 0.953,0.606 0,0.26 0.043,0.433 0.087,0.52 0.13,0.736 0.52,1.04 1.255,0.909 0.043,0 0.303,-0.086 0.693,-0.303 0.736,-0.217 1.126,-0.347 1.169,-0.39 0.823,-0.303 1.385,-0.13 1.732,0.476 0.303,0.866 0.563,1.516 0.736,1.992 0.649,1.385 1.515,2.035 2.684,1.992 0.303,0 0.476,0 0.563,-0.043 0.087,-0.043 0.347,-0.26 0.736,-0.606 l 0.13,-0.087 0.13,0.087 c 0,0.13 0.043,0.39 0,0.736 0,0.303 0.043,0.563 0.217,0.736 l 0.216,0.043 c 0.086,-0.043 0.303,-0.26 0.52,-0.649 0.217,-0.346 0.39,-0.52 0.563,-0.52 0.26,0 0.433,0.26 0.476,0.779 0.043,0.606 0.173,0.953 0.476,1.039 0,0.043 0.217,0.087 0.693,0.173 0.779,0.216 1.385,0.26 1.905,0.173 0.563,-0.173 0.866,-0.26 0.909,-0.26 0.39,0.173 0.649,0.303 0.823,0.346 0.173,-0.173 0.39,-0.909 0.693,-2.208 0.346,-1.083 0.52,-1.862 0.563,-2.425 0.086,-0.909 -0.217,-1.645 -0.823,-2.208 0.26,-0.909 0.476,-1.472 0.52,-1.688 0.13,-0.477 0.217,-1.299 0.303,-2.468 0,-0.043 0.173,-0.217 0.563,-0.477 0.953,-0.693 1.602,-1.299 1.905,-1.775 0.087,-0.26 0.173,-0.476 0.217,-0.649 0.087,-0.26 0.173,-0.476 0.173,-0.606 0.217,-1.083 0.346,-1.688 0.476,-1.818 0.087,-0.043 0.26,-0.173 0.563,-0.433 H 71.44 c 0.563,-0.433 1.169,-0.606 1.775,-0.563 0.779,0.173 1.385,0.303 1.905,0.347 0.217,0.043 1.039,0 2.468,-0.043 0.173,0 0.346,-0.043 0.433,-0.173 0.26,-0.346 0.39,-0.563 0.433,-0.606 0.217,-0.173 0.606,-0.173 1.169,0.086 0.779,0.303 1.212,0.477 1.342,0.477 0.087,-0.043 0.217,-0.217 0.39,-0.563 0.39,-0.606 0.823,-0.909 1.342,-0.909 0.173,0 0.736,0.173 1.645,0.476 0.26,0.087 0.563,0.043 0.996,-0.173 0.477,-0.217 0.779,-0.39 0.909,-0.477 0.476,0.043 0.866,0.043 1.125,0.043 0.217,-0.043 0.823,-0.303 1.819,-0.779 0.173,-0.173 0.346,-0.26 0.476,-0.347 0.91,-0.39 1.559,-0.52 1.949,-0.39 0.26,0.26 0.433,0.39 0.563,0.433 0.216,0.043 0.39,-0.043 0.563,-0.216 0.563,-0.779 0.779,-1.212 0.693,-1.429 -0.347,-0.216 -0.606,-0.606 -0.779,-1.039 -0.217,0 -0.52,0.087 -0.953,0.217 -0.39,0.043 -0.693,-0.043 -0.909,-0.217 l -0.043,-0.173 c -0.043,-0.606 -0.086,-1.083 -0.086,-1.429 0,-0.043 0.13,-0.26 0.346,-0.693 0.173,-0.26 0.086,-0.52 -0.26,-0.693 -0.216,-0.173 -0.39,-0.216 -0.52,-0.173 -0.043,0 -0.26,0.217 -0.649,0.563 -0.26,0.26 -0.52,0.39 -0.693,0.303 -0.216,-0.087 -0.346,-0.303 -0.39,-0.606 -0.043,-0.39 0.043,-0.606 0.303,-0.692 0.303,-0.13 0.736,-0.217 1.342,-0.26 0.52,0 0.866,-0.087 0.996,-0.13 0.13,-0.043 0.173,-0.173 0.26,-0.39 0.043,-0.26 0.13,-0.39 0.173,-0.477 0.346,-0.26 0.649,-0.433 0.822,-0.563 0.26,-0.216 0.39,-0.476 0.39,-0.866 -0.129,-0.086 -0.39,-0.26 -0.779,-0.52 -0.39,-0.216 -0.563,-0.39 -0.65,-0.563 -0.086,-0.303 0.087,-0.649 0.52,-1.083 0.563,-0.476 0.866,-0.822 0.909,-0.952 0.13,-0.433 0.087,-0.823 -0.129,-1.212 -0.173,-0.347 -0.303,-0.563 -0.26,-0.649 0.087,-0.217 0.173,-0.347 0.217,-0.433 0.13,-0.433 0.346,-0.736 0.563,-0.866 0.606,0.13 1.039,0.173 1.212,0.216 0.26,0.043 1.126,-0.173 2.555,-0.563 0.087,-0.043 0.26,-0.043 0.563,0 0.346,0.043 0.606,0.173 0.779,0.26 0.693,0.693 1.125,1.039 1.299,0.996 l 0.26,-0.173 c 0.26,0.173 0.477,0.26 0.606,0.346 0.26,0.13 0.476,0.13 0.692,0 0.217,-0.13 0.39,-0.476 0.433,-1.082 0,-0.173 0,-0.303 0,-0.39 0.086,-0.736 0.13,-1.082 0.173,-1.125 v -0.52 c 0.216,-0.086 0.52,-0.086 0.866,0.043 0.346,0.129 0.563,0.13 0.649,0.086 0.217,-0.303 0.433,-0.563 0.693,-0.736 0.779,-0.347 1.342,-0.606 1.688,-0.736 0.39,-0.26 0.693,-0.433 0.909,-0.52 1.083,-0.52 1.688,-0.953 1.905,-1.169 0.086,-0.26 0.216,-0.433 0.303,-0.563 l 0.519,-0.952 c 0.217,-0.606 0.39,-1.126 0.563,-1.516 0.347,-0.736 0.606,-1.039 0.909,-0.996 0.043,0.216 0.13,0.346 0.173,0.433 0.476,0.087 0.909,0 1.385,-0.216 0.347,-0.173 0.563,-0.433 0.65,-0.693 0.043,-0.303 -0.13,-0.779 -0.563,-1.429 l -0.087,-0.13 c -0.173,-0.346 -0.216,-0.52 -0.26,-0.563 0,-0.086 0.087,-0.606 0.347,-1.602 1.126,-0.173 1.775,-0.26 1.862,-0.26 0.39,-0.173 0.649,-0.303 0.909,-0.303 1.125,-0.173 1.775,-0.303 1.862,-0.347 0.476,-0.303 0.823,-0.476 1.039,-0.563 0.433,-0.086 0.736,-0.173 0.953,-0.259 0.216,-0.217 0.433,-0.347 0.606,-0.433 0.909,0.26 1.559,-0.13 1.905,-1.083 0,-0.087 -0.13,-0.433 -0.303,-0.996 -0.087,-0.39 -0.043,-0.693 0.303,-0.91 0.433,0.043 0.736,0.043 0.952,0 0.087,-0.086 0.173,-0.26 0.13,-0.476 0,-0.26 -0.087,-0.433 -0.173,-0.563 l -0.39,-0.433 c -0.086,-0.087 -0.13,-0.303 -0.217,-0.563 -0.043,-0.086 -0.26,-0.217 -0.649,-0.433 -0.216,-0.13 -0.433,-0.346 -0.52,-0.693 -0.043,-0.173 -0.086,-0.346 0,-0.433 l -0.13,-0.173 c -0.26,-0.13 -0.736,-0.346 -1.299,-0.649 -0.649,-0.39 -0.953,-0.606 -1.039,-0.649 -0.563,-0.563 -0.909,-0.909 -1.083,-0.996 l -0.086,-0.13 c -0.217,-0.173 -0.52,-0.433 -0.909,-0.736 -0.13,-0.086 -0.347,-0.216 -0.563,-0.347 -0.216,-0.866 -0.346,-1.515 -0.346,-1.948 0,-0.52 0.13,-1.169 0.346,-1.992 0,-0.13 -0.13,-0.303 -0.433,-0.563 -0.346,-0.303 -0.52,-0.52 -0.563,-0.52 0,-0.26 0.173,-0.563 0.563,-0.91 0.433,-0.389 0.736,-0.692 0.823,-0.909 0.13,-0.39 0.13,-0.78 0,-1.126 -0.173,-0.433 -0.433,-0.693 -0.823,-0.779 -0.303,-0.087 -0.476,-0.087 -0.52,-0.087 -0.173,0.043 -0.52,0.217 -0.996,0.52 -0.347,0.217 -0.779,0.26 -1.342,0.13 -0.303,-0.087 -0.476,-0.13 -0.52,-0.13 -0.087,-0.086 -0.087,-0.259 -0.087,-0.52 0,-0.043 0,-0.086 0,-0.173 0,-0.26 0.043,-0.606 0.087,-1.083 0,-0.476 -0.173,-0.866 -0.52,-1.039 -0.13,-0.13 -0.26,-0.173 -0.347,-0.13 l -1.169,0.216 c -0.26,0.043 -0.563,-0.173 -0.952,-0.606 -0.347,-0.433 -0.736,-0.649 -1.04,-0.563 -0.086,0.086 -0.086,0.347 -0.043,0.649 0.086,0.347 0.043,0.563 0,0.736 l -0.13,0.043 c -0.39,0.043 -0.736,0 -0.953,-0.13 l -0.303,-0.26 c -0.346,-0.303 -0.822,-0.39 -1.342,-0.26 -0.26,0.043 -0.476,0.087 -0.649,0.173 -0.043,0 -0.26,0.173 -0.736,0.476 -0.347,0.26 -0.606,0.39 -0.693,0.347 l -0.953,-0.39 c -0.086,-0.043 -0.303,-0.13 -0.606,-0.217 -0.26,-0.13 -0.39,-0.303 -0.346,-0.52 0.043,-0.476 0.043,-0.779 0.043,-0.909 -0.13,-0.303 -0.433,-0.476 -0.952,-0.563 -0.563,-0.086 -0.866,-0.173 -0.91,-0.216 -0.043,-0.043 -0.086,-0.173 -0.043,-0.346 0,-0.217 0,-0.433 -0.13,-0.563 -0.043,-0.043 -0.347,-0.043 -0.909,0 -0.39,0 -0.693,-0.087 -0.779,-0.26 l -0.217,-0.606 c -0.086,-0.216 -0.26,-0.303 -0.563,-0.216 l -0.13,0.086 c -0.043,0.087 -0.043,0.39 -0.043,0.823 0,0.303 -0.173,0.52 -0.477,0.693 -0.26,0.086 -0.476,0.043 -0.606,-0.043 -0.13,-0.26 -0.216,-0.39 -0.216,-0.39 0,-0.13 0.043,-0.346 0.129,-0.649 0.043,-0.346 -0.086,-0.563 -0.346,-0.693 -0.823,-0.606 -1.299,-0.996 -1.342,-1.169 l 0.043,-0.173 0.39,-0.26 c 0.476,-0.087 0.866,-0.173 1.126,-0.217 0.476,-0.13 0.779,-0.346 0.996,-0.649 0.13,-0.303 0.173,-0.563 0.043,-0.866 -0.043,-0.043 -0.26,-0.303 -0.65,-0.866 -0.303,-0.303 -0.563,-0.476 -0.779,-0.563 -0.303,-0.043 -0.52,-0.043 -0.65,0.13 -0.216,0.129 -0.346,0.216 -0.389,0.216 -0.173,0 -0.433,-0.173 -0.823,-0.52 -0.39,-0.303 -0.606,-0.52 -0.692,-0.649 -0.043,-0.26 0.043,-0.52 0.26,-0.823 -0.043,-0.173 -0.303,-0.433 -0.823,-0.693 -0.563,-0.303 -0.909,-0.39 -1.126,-0.26 -0.129,0.087 -0.346,0.347 -0.563,0.693 -0.13,0.086 -0.346,0.086 -0.693,0.13 -0.26,0 -0.52,0.13 -0.823,0.26 -0.173,0.13 -0.346,0.26 -0.433,0.39 -0.173,0.043 -0.563,-0.13 -1.212,-0.476 -0.13,-0.043 -0.26,-0.347 -0.433,-0.779 l -0.692,-0.303 c -0.26,-0.13 -0.39,-0.39 -0.303,-0.779 -0.13,-0.347 -0.39,-0.52 -0.866,-0.52 -0.52,0 -0.822,0.26 -1.039,0.736 -0.086,0.736 -0.173,1.256 -0.173,1.429 l 0.043,0.13 c 0.043,0.13 0.13,0.26 0.13,0.303 0.043,0.26 0.087,0.39 0.087,0.52 0.043,0.13 0.173,0.303 0.433,0.563 0.173,0.216 0.26,0.39 0.26,0.563 -0.26,0.303 -0.606,0.563 -1.083,0.78 0,0.216 -0.13,0.39 -0.346,0.52 -0.26,0.13 -0.606,0.26 -1.083,0.303 -0.13,0.043 -0.26,0.13 -0.433,0.26 -0.26,0.303 -0.39,0.606 -0.26,0.91 0.043,0.086 0.13,0.13 0.217,0.173 0.086,0.173 0.086,0.39 0,0.693 -0.173,0.26 -0.26,0.433 -0.303,0.606 -0.13,0.303 -0.26,0.736 -0.476,1.342 0,0.043 -0.087,0.173 -0.173,0.303 -0.043,0.043 -0.13,0.086 -0.217,0.216 -0.433,0.217 -2.208,0.26 -5.239,0.043 -0.736,0.086 -1.645,0.39 -2.771,0.909 -0.433,0.216 -0.693,0.476 -0.779,0.823 -0.043,0 -0.087,0.39 -0.217,1.125 -0.086,0.303 -0.13,0.477 -0.13,0.52 -0.13,0.217 -0.346,0.347 -0.693,0.477 -0.39,0.13 -0.65,0.26 -0.779,0.346 -0.217,0.216 -0.433,0.606 -0.693,1.212 -0.52,0.649 -1.083,1.169 -1.646,1.516 l -1.602,1.212 c -0.216,0.173 -0.606,0.433 -1.212,0.866 -0.303,0.216 -0.693,0.692 -1.169,1.342 -0.216,0.217 -0.606,0.52 -1.126,0.953 -1.039,0.909 -1.862,1.689 -2.425,2.338 -0.173,0.26 -0.39,0.606 -0.736,1.125 -0.174,0.173 -0.39,0.346 -0.693,0.563 l -0.823,0.779 c -0.217,0.173 -0.39,0.52 -0.39,1.039 -0.166,0.308 -0.469,0.611 -1.032,0.871",
                        "Luhansk": "m 494.189,140.263 0.043,0.173 c 0.996,0.692 1.516,1.125 1.559,1.299 -0.087,0.173 -0.347,0.346 -0.78,0.433 -0.26,0.259 -0.39,0.606 -0.52,1.169 -0.606,-0.26 -0.953,-0.303 -1.082,-0.217 -0.087,0.043 -0.26,0.217 -0.52,0.606 -0.26,0.346 -0.39,0.606 -0.433,0.693 0.043,0.26 0.13,0.433 0.303,0.476 0.736,-0.39 1.212,-0.476 1.385,-0.346 0.216,0.259 0.303,0.476 0.26,0.779 -0.043,0.13 -0.086,0.346 -0.173,0.692 -0.043,0.13 0,0.433 0.087,0.866 0.086,0.39 0.086,0.693 0,0.866 -0.477,0.347 -0.693,0.693 -0.736,1.039 0,0.39 -0.043,0.563 -0.086,0.606 -0.433,0.216 -0.736,0.39 -0.866,0.563 v 0.173 c 0.087,0.13 0.217,0.39 0.303,0.823 0,0.043 0.087,0.173 0.26,0.346 0.086,0.13 0.13,0.26 0.13,0.39 l -0.086,0.13 c -0.173,-0.043 -0.303,-0.086 -0.39,-0.043 -0.043,0.043 0.086,0.39 0.346,0.996 0.173,0.563 0.217,0.866 0,0.953 -0.476,0.26 -0.779,0.433 -0.866,0.52 -0.26,0.26 -0.347,0.649 -0.347,1.212 -0.043,0.606 -0.086,0.953 -0.173,1.083 -0.563,0.086 -0.953,0.216 -1.169,0.346 -0.043,0.13 -0.217,0.476 -0.52,0.996 0.347,0.39 0.563,0.606 0.606,0.65 0.39,0.563 0.476,1.342 0.173,2.424 -0.043,0.13 -0.13,0.433 -0.259,0.866 -0.087,0.39 0.043,0.692 0.259,0.866 0.173,0.086 0.52,0.173 1.083,0.216 l 0.26,0.347 c -0.043,0.086 0,0.26 0.087,0.433 0,0.26 -0.26,0.563 -0.78,0.91 l 0.174,0.39 -0.13,0.086 c -0.606,0.346 -0.996,0.563 -1.125,0.606 -0.173,0.087 -0.26,0.087 -0.303,0.13 -0.13,0.087 -0.216,0.217 -0.303,0.39 0.52,0 0.996,0.39 1.342,1.169 0.087,0.043 0.477,0.13 1.256,0.216 0.086,0.26 0.13,0.433 0,0.52 -0.779,0 -1.212,0.043 -1.299,0.086 -0.26,0.779 -0.346,1.169 -0.303,1.256 0.086,0.086 0.173,0.173 0.26,0.173 0.823,0.26 1.559,0.606 2.208,1.04 0.173,0.129 0.303,0.173 0.477,0.043 l 0.996,-0.909 c 0,-0.043 0.606,0 1.732,0.086 -0.13,0.39 -0.26,0.953 -0.347,1.646 0.13,0.693 0.087,1.125 -0.129,1.342 -0.433,0.433 -0.606,0.736 -0.563,0.909 0.043,0.086 0.13,0.173 0.26,0.303 0.779,1.342 1.039,2.294 0.822,2.857 -0.173,0.13 -0.476,0.173 -0.952,0.13 -0.043,0.13 -0.043,0.346 0,0.649 -0.347,-0.13 -0.563,-0.13 -0.736,-0.043 -0.086,0.087 -0.173,0.217 -0.26,0.477 -0.086,0.216 -0.13,0.39 -0.086,0.476 l 0.13,0.087 0.476,-0.043 0.173,0.086 c 0.087,0.173 0.216,0.39 0.346,0.693 l 0.087,-0.086 c 0.216,-0.043 0.476,0 0.866,0.086 0.303,0.043 0.779,0.086 1.429,0.13 0.13,0 0.39,0.043 0.693,0.173 0.13,0 0.347,-0.043 0.649,-0.043 0.26,0 0.649,0.13 1.083,0.346 0.39,0.477 0.606,1.212 0.693,2.122 0,0.173 0,0.477 -0.043,0.866 0,0.173 0.216,0.303 0.649,0.39 0.52,0.086 0.823,0.13 0.866,0.216 l 0.13,0.26 c 0,0.043 -0.043,0.216 -0.173,0.477 -0.086,0.173 -0.086,0.346 0.043,0.476 l 0.39,0.433 c 0.347,0.346 0.26,0.952 -0.259,1.731 -0.217,0.26 -0.39,0.477 -0.477,0.649 -0.086,0.217 -0.086,0.563 -0.043,1.04 l 0.086,0.086 c 0.303,-0.303 0.649,-0.39 1.039,-0.26 l 0.13,0.086 0.043,0.13 c -0.087,0.39 -0.346,0.779 -0.779,1.256 -0.693,0.649 -1.04,1.039 -1.04,1.125 -0.086,0.217 -0.043,0.693 0.043,1.472 0,0.13 0.087,0.433 0.173,0.866 0,0.13 -0.086,0.303 -0.13,0.563 l 0.476,1.039 c 0.13,0.173 0.086,0.563 -0.13,1.126 -0.173,0.476 -0.173,0.823 0,0.996 0.173,0.13 0.39,0.217 0.779,0.303 0.347,0.043 0.606,0.13 0.736,0.26 0.043,0.303 0,0.606 -0.043,0.866 -0.043,0.043 -0.086,0.173 -0.13,0.303 -0.13,0.347 -0.216,0.736 -0.216,1.169 0,0.433 0,0.692 0.043,0.779 0.13,0.433 0.606,0.606 1.386,0.563 0.13,0 0.173,0.13 0.26,0.347 0.346,0.173 0.736,-0.043 1.125,-0.649 l 0.173,0.086 c 0.043,0.216 0.216,0.476 0.52,0.823 0.043,0.086 0.087,0.303 0.087,0.606 0.043,0.216 0.086,0.433 0.216,0.563 0.13,0.216 0.476,0.476 0.952,0.779 0.433,0.563 0.65,1.039 0.563,1.429 -0.043,0.433 -0.303,0.649 -0.736,0.779 -0.563,0.086 -0.953,0.13 -1.212,0.13 l -0.13,0.087 -0.13,0.086 0.216,0.736 c 0,0 0.087,0.433 0.303,1.299 0.173,0.173 0.303,0.26 0.39,0.26 0.779,0.043 1.342,0.043 1.646,0 1.169,-0.173 1.861,-0.26 2.165,-0.26 l 0.087,0.043 c 0.216,0.39 0.39,1.039 0.606,1.948 0.086,0.303 0.26,0.65 0.52,1.169 0,0.217 -0.086,0.649 -0.216,1.256 0.086,0.173 0.649,0.476 1.818,0.953 0.216,0.13 0.606,0.26 1.126,0.52 0,0 0.216,0.086 0.563,0.173 0.736,0.217 1.516,0.563 2.295,1.04 0.606,0.346 0.909,0.606 0.952,0.909 0,0 -0.173,0.39 -0.606,1.125 -0.303,0.52 -0.346,0.909 -0.13,1.169 l 0.909,1.126 c 0.043,0.043 0.216,0.086 0.476,0.086 1.516,-0.13 2.901,-0.043 4.244,0.303 0.389,0.086 0.692,0.173 0.952,0.26 0.303,0.13 0.433,0.39 0.39,0.779 0,0.13 -0.13,0.693 -0.346,1.688 -0.043,0.217 0.086,0.39 0.346,0.606 0.39,0.216 0.563,0.39 0.606,0.476 0,0.476 -0.216,1.342 -0.649,2.684 0.346,-0.043 0.649,0 0.866,0.13 0.086,0.086 0.433,0.303 0.996,0.779 0.389,0.346 0.736,0.52 1.039,0.52 0.26,0 0.952,-0.173 2.121,-0.563 0.909,-0.216 1.473,-0.303 1.602,-0.303 0.303,0 0.736,0 1.342,0.087 l 1.429,-0.043 c 0.433,0.043 0.78,0.173 1.039,0.52 0.303,0.303 0.52,0.476 0.606,0.476 0.216,0.043 0.52,0 0.953,-0.173 0.433,-0.216 0.736,-0.303 0.909,-0.26 0.043,0 0.303,0.13 0.779,0.346 0.346,0.086 0.779,0.086 1.385,-0.043 0.693,-0.173 1.212,-0.303 1.516,-0.259 0.346,0 0.953,0.129 1.818,0.433 0.866,0.303 1.516,0.476 1.905,0.52 0.563,0 0.996,-0.216 1.342,-0.736 0.129,-0.13 0.303,-0.39 0.606,-0.779 0.39,-0.433 0.563,-0.953 0.433,-1.472 -0.173,-0.909 -0.26,-1.386 -0.26,-1.429 0,-0.26 0.13,-0.649 0.347,-1.169 0.26,-0.52 0.346,-0.909 0.346,-1.169 0,-0.086 -0.043,-0.26 -0.13,-0.52 -0.086,-0.303 -0.26,-0.606 -0.433,-0.822 -0.476,-0.649 -0.736,-0.996 -0.779,-0.996 l 0.043,-0.173 c 0.086,-0.129 0.39,-0.26 0.953,-0.433 0.563,-0.173 0.909,-0.26 1.082,-0.26 0.174,0 0.39,0 0.693,0.043 0.043,-0.13 0,-0.26 -0.129,-0.52 -0.173,-0.173 -0.26,-0.346 -0.303,-0.476 -0.043,-0.39 -0.086,-0.736 -0.13,-0.909 l -0.087,-0.303 c -0.129,-0.606 0,-1.083 0.39,-1.429 0.52,-0.52 0.823,-0.823 0.866,-0.953 0.043,-0.346 0.086,-0.563 0.13,-0.736 0.216,-0.866 0.606,-1.646 1.169,-2.295 0.26,-0.303 0.779,-0.606 1.646,-0.866 0.216,-0.217 0.346,-0.347 0.433,-0.477 0.173,-0.303 0.26,-0.736 0.303,-1.255 0.043,-0.649 -0.086,-1.039 -0.433,-1.169 -0.13,-0.043 -0.26,-0.087 -0.303,-0.043 -0.606,0.043 -1.083,0.216 -1.429,0.433 -0.303,0.26 -0.52,0.433 -0.692,0.52 l -0.087,-0.043 c -0.303,-0.606 -0.736,-0.996 -1.299,-1.125 -0.606,-0.173 -0.909,-0.303 -0.996,-0.52 0,-0.216 0.216,-0.389 0.649,-0.563 0.606,-0.216 0.953,-0.347 1.039,-0.433 0.303,-0.26 0.563,-0.693 0.866,-1.386 -0.26,-0.129 -0.39,-0.39 -0.433,-0.779 0,-0.52 -0.043,-0.866 -0.087,-0.996 -0.216,-0.26 -0.39,-0.433 -0.39,-0.606 0.043,-0.433 0,-0.736 -0.086,-0.909 -0.043,-0.043 -0.346,-0.39 -0.953,-1.04 -0.476,-0.476 -0.606,-0.866 -0.476,-1.125 l 0.129,-0.13 c 0.087,0 0.26,0 0.477,0 l 0.13,-0.086 0.043,-0.173 c -0.086,-0.303 -0.13,-0.52 -0.173,-0.693 -0.043,-1.039 -0.13,-1.645 -0.303,-1.862 -0.217,-0.173 -0.39,-0.303 -0.52,-0.39 -0.303,-0.39 -0.649,-0.606 -0.996,-0.693 -0.26,-0.086 -0.563,-0.086 -0.996,-0.043 -0.476,0.043 -0.822,0.043 -0.996,0.043 -0.779,-0.303 -1.386,-0.346 -1.862,-0.26 -0.303,-0.52 -0.433,-0.909 -0.39,-1.082 0,-0.13 0.087,-0.347 0.26,-0.65 0.087,-0.173 0.217,-0.476 0.346,-0.866 0.39,-0.563 0.649,-0.996 0.736,-1.342 0.13,-0.303 0.13,-0.692 0.086,-1.169 -0.043,-0.26 -0.086,-0.433 -0.043,-0.476 0.173,-0.347 0.303,-0.606 0.346,-0.823 0.173,-0.606 0.26,-1.039 0.39,-1.299 0.086,-0.13 0.39,-0.216 0.866,-0.173 0.087,-0.13 0.173,-0.346 0.26,-0.736 0.087,-0.217 0.173,-0.433 0.303,-0.649 0.303,-0.52 0.649,-0.866 1.083,-1.083 0.434,-0.217 0.952,-0.173 1.602,0.13 0.346,0.173 0.823,0.476 1.472,0.909 0.13,0.043 0.346,0.13 0.649,0.216 0.39,0.13 0.649,0.217 0.822,0.217 0.477,0 1.083,-0.39 1.862,-1.126 0.693,-0.736 1.169,-1.472 1.386,-2.251 0.086,-0.692 -0.216,-1.125 -0.823,-1.342 -0.52,-0.173 -0.953,0.043 -1.256,0.606 -0.39,0.606 -0.692,0.909 -0.866,0.953 -0.346,0 -0.649,-0.173 -0.953,-0.563 -0.346,-0.433 -0.563,-0.649 -0.606,-0.693 -0.606,0.13 -1.083,0.216 -1.385,0.173 -0.173,0 -0.563,-0.13 -1.212,-0.433 -0.173,-0.13 -0.477,-0.13 -0.866,-0.13 -0.39,0.043 -0.779,-0.086 -1.169,-0.303 -0.13,-0.087 -0.216,-0.347 -0.303,-0.866 -0.086,-0.52 -0.216,-0.909 -0.433,-1.039 -0.217,-0.216 -0.433,-0.39 -0.606,-0.52 -0.26,-0.173 -0.476,-0.303 -0.563,-0.347 -0.173,-0.173 -0.26,-0.39 -0.303,-0.606 0.086,-0.433 0.086,-0.693 0.13,-0.866 0,-0.736 0.086,-1.299 0.173,-1.602 0.216,-0.173 0.692,-0.13 1.559,0.086 0.39,0.043 0.823,-0.086 1.255,-0.39 0.52,-0.346 0.866,-0.52 0.996,-0.563 0.216,-0.043 0.779,0 1.688,0.13 0.736,0.13 1.255,0.043 1.472,-0.13 0.303,-0.26 0.303,-0.692 0,-1.385 0,-0.13 0.13,-0.476 0.39,-0.996 0.043,-0.086 0.26,-0.39 0.649,-0.953 0.26,-0.389 1.039,-1.039 2.381,-1.948 0.173,-0.13 0.433,-0.303 0.823,-0.476 0.303,-0.433 0.649,-1.126 1.125,-2.078 0.216,-0.13 0.433,-0.217 0.736,-0.303 0.217,-0.086 0.433,-0.216 0.649,-0.476 0.043,-0.13 0.043,-0.39 -0.043,-0.736 -0.13,-0.39 -0.173,-0.649 -0.13,-0.779 0,-0.043 0.086,-0.26 0.26,-0.693 0.216,-0.736 0.303,-1.299 0.216,-1.818 -0.043,-0.346 -0.173,-0.649 -0.39,-0.909 -0.26,-0.26 -0.476,-0.52 -0.649,-0.736 l -0.26,-0.347 c -0.303,-0.39 -0.52,-0.693 -0.693,-0.866 -0.173,-0.217 -0.563,-0.823 -1.039,-1.775 -0.26,-0.303 -0.433,-0.563 -0.476,-0.736 -0.217,-0.52 -0.217,-1.083 -0.043,-1.732 0.216,-0.909 0.649,-1.516 1.299,-1.862 0.736,-0.346 1.169,-0.693 1.299,-1.039 0.13,-0.26 0.173,-0.52 0.173,-0.736 -0.173,-0.39 -0.26,-0.649 -0.303,-0.866 -0.476,-0.043 -0.822,-0.086 -1.125,-0.086 0,0 -0.346,-0.173 -0.996,-0.433 -0.649,-0.303 -1.342,-0.303 -2.035,-0.043 -0.303,0.173 -0.477,0.303 -0.606,0.477 -0.692,0.866 -1.082,1.342 -1.212,1.385 -0.043,0.043 -0.39,0.217 -1.083,0.477 -1.256,0.52 -2.295,0.649 -3.118,0.346 -0.476,-0.779 -0.779,-1.212 -0.909,-1.299 -0.086,-0.086 -0.39,-0.216 -0.952,-0.477 -0.563,-0.216 -0.909,-0.39 -1.04,-0.39 -0.39,-0.043 -0.649,-0.043 -0.866,-0.043 -0.303,-0.043 -0.606,-0.217 -0.866,-0.563 -0.216,-0.216 -0.433,-0.996 -0.736,-2.208 -0.303,-0.736 -0.476,-1.299 -0.563,-1.646 -0.086,-0.52 -0.216,-0.822 -0.303,-1.039 -0.043,-0.086 -0.087,-0.173 -0.13,-0.216 -0.823,0 -1.429,-0.043 -1.818,-0.173 -0.26,-0.043 -0.563,-0.303 -0.953,-0.649 -0.346,-0.346 -0.693,-0.476 -1.039,-0.433 -0.303,0.043 -0.736,0.26 -1.299,0.693 -0.52,0.346 -1.082,0.52 -1.602,0.477 -0.13,0 -0.433,-0.087 -0.909,-0.26 -0.477,-0.086 -0.78,-0.216 -0.996,-0.303 -0.563,-0.303 -0.952,-0.649 -1.083,-0.996 -0.086,-0.086 -0.216,-0.563 -0.39,-1.385 -0.043,-0.217 -0.086,-0.347 -0.086,-0.433 -0.347,-0.563 -0.563,-0.996 -0.606,-1.299 -0.043,-0.433 -0.086,-0.779 -0.129,-0.996 -0.087,-0.303 -0.26,-0.563 -0.606,-0.736 -0.086,-0.086 -0.303,-0.13 -0.563,-0.173 -0.39,-0.043 -0.692,0.087 -0.909,0.303 -0.26,0.346 -0.433,0.606 -0.606,0.823 -0.649,0.909 -1.126,1.429 -1.299,1.559 -0.26,0.173 -0.65,0.26 -1.126,0.26 -0.606,0 -0.996,0.043 -1.212,0.086 -0.563,0.217 -1.082,0.303 -1.559,0.26 -0.216,-0.173 -0.476,-0.606 -0.822,-1.342 -0.303,-0.736 -0.606,-1.212 -0.866,-1.386 -0.433,-0.26 -1.169,-0.476 -2.165,-0.563 -1.039,-0.13 -1.602,-0.216 -1.688,-0.26 -0.173,-0.13 -0.346,-0.346 -0.563,-0.649 -0.216,-0.39 -0.39,-0.606 -0.519,-0.736 -0.39,-0.13 -0.649,-0.303 -0.78,-0.39 -0.216,-0.217 -0.259,-0.649 -0.173,-1.256 0.043,-0.563 0.043,-0.909 -0.086,-1.039 -0.13,0 -0.26,0.13 -0.477,0.39 -0.26,0.303 -0.476,0.477 -0.693,0.52 -0.173,0.043 -0.433,0 -0.736,-0.13 -0.39,-0.13 -0.649,-0.216 -0.823,-0.216 -0.043,0 -0.433,0.13 -1.126,0.433 -0.173,0.043 -0.519,0.086 -0.996,0.173 -0.39,0.043 -0.649,0.043 -0.736,0.043 -0.173,-0.086 -0.389,-0.346 -0.649,-0.693 -0.259,-0.433 -0.476,-0.649 -0.649,-0.736 -0.216,-0.13 -0.649,-0.087 -1.385,0.043 -0.563,0.087 -0.996,-0.173 -1.386,-0.779 -0.086,-0.303 -0.173,-0.563 -0.26,-0.866 -0.173,-0.909 -0.303,-1.429 -0.346,-1.559 -0.26,-0.649 -0.649,-0.909 -1.125,-0.866 -0.693,0.39 -1.212,0.606 -1.602,0.606 -0.996,-0.347 -1.602,-0.433 -1.905,-0.217 l -0.086,0.13 c 0,0.043 0.086,0.433 0.216,1.212 0.043,0.26 0.043,0.563 0.086,0.823 0,0.173 0.043,0.39 0.13,0.736 -0.043,0.347 -0.043,0.823 -0.043,1.516 -0.043,0.346 -0.303,0.779 -0.736,1.255 -0.476,0.477 -0.909,0.606 -1.212,0.433 -0.173,-0.26 -0.303,-0.39 -0.39,-0.476 -0.217,-0.043 -0.693,0.173 -1.472,0.693 -0.606,0.259 -0.996,0.563 -1.212,0.909 l -0.13,0.043 c 0.086,0.173 0.216,0.52 0.433,0.953 0.346,0.606 0.606,0.996 0.736,1.039 l 0.606,0.303 0.086,0.13 v 0.173 c -0.043,0.13 -0.173,0.216 -0.346,0.26 -0.26,0 -0.433,0 -0.52,0 -0.952,0.085 -1.515,0.345 -1.732,0.864",
                        "Kirovohrad": "m 251.03125,211.90624 c 0.26,0.086 0.4325,0.086 0.5625,0 0.433,-0.217 0.75775,-0.375 0.84375,-0.375 0.217,0 0.55925,0.19875 0.90625,0.71875 0.39,0.52 0.62675,0.73825 0.84375,0.78125 0.216,-0.173 0.447,-0.5425 0.75,-1.0625 0.217,-0.563 0.42075,-0.88175 0.59375,-0.96875 0.173,-0.086 0.327,0.0135 0.5,0.1875 0.043,0.086 0.12,0.25175 0.25,0.46875 0.303,0.173 0.687,-0.0112 1.25,-0.53125 l 0,0.15625 c 0,0 0.038,0.12 0.125,0.25 0.216,0.173 0.30075,0.52 0.34375,1.125 0.043,0.217 0.27125,0.44025 0.53125,0.65625 0.173,0.173 0.3075,0.524 0.4375,1 0,0 0.5625,0.192 1.6875,0.625 0.216,0.086 0.562,-0.002 1.125,-0.21875 0.173,0.043 0.4235,0.13175 0.8125,0.21875 0.087,0.043 0.3795,-0.0828 0.8125,-0.34375 0.433,0.043 1.00225,0.16475 1.78125,0.46875 0.129,0 0.27125,-0.038 0.53125,-0.125 0.173,-0.086 0.41575,-0.0352 0.71875,0.0937 0.39,0.086 0.71375,0.0548 0.84375,-0.0312 0.043,-0.043 0.158,-0.2555 0.375,-0.6875 0.39,-0.779 0.8745,-1.092 1.4375,-0.875 0.13,0.043 0.2645,0.16975 0.4375,0.34375 0.216,0.043 0.47825,0.005 0.78125,-0.125 0.26,0 0.686,0.038 1.25,0.125 l 0.8125,0 c 0.043,0 0.15125,0.008 0.28125,0.0937 0.173,-0.173 0.33975,-0.2305 0.46875,-0.1875 1.862,0.823 2.908,1.053 3.125,0.75 0.086,-0.13 0.1445,-0.3465 0.1875,-0.5625 0.173,-0.26 0.3125,-0.452 0.3125,-0.625 0.086,-0.13 0.48275,-0.207 1.21875,-0.25 0.043,0 0.1825,-0.038 0.3125,-0.125 0.13,-0.087 0.33375,-0.0937 0.59375,-0.0937 0.216,0.043 0.447,0.16975 0.75,0.34375 0.433,0 0.67075,-0.0497 0.84375,-0.0937 0.13,0 0.322,-0.038 0.625,-0.125 l 0.21875,0.21875 c 0.043,0.13 0.0693,0.404 0.15625,0.75 0.26,0.13 0.48425,0.11825 0.65625,0.0312 0.173,-0.823 0.43525,-1.25775 0.78125,-1.34375 0.13,0 0.29475,0.0888 0.46875,0.21875 0.13,0.087 0.206,0.2265 0.25,0.3125 l 0.0625,0.6875 c 0.086,0.173 0.29075,0.293 0.59375,0.25 0.26,-0.043 0.48325,-0.12 0.65625,-0.25 0.086,-0.087 0.17575,-0.2975 0.21875,-0.6875 0.086,-0.13 0.46425,-0.18075 1.15625,-0.0937 0.303,0.043 0.5195,-0.4035 0.5625,-1.3125 0.043,-0.216 0.1825,-0.331 0.3125,-0.375 0.173,0 0.55025,-0.119 1.15625,-0.25 0.477,-0.086 0.79975,-0.086 0.84375,0 0.043,0.433 0.2545,0.55475 0.6875,0.46875 0.779,-0.217 1.207,-0.3125 1.25,-0.3125 0.043,0 0.1395,0.076 0.3125,0.25 0.13,0.087 0.46825,0.1065 1.03125,0.0625 0.173,0 0.2695,0.0955 0.3125,0.3125 0.086,1.125 0.13275,1.663 0.21875,1.75 0.043,0.043 0.236,0.0507 0.625,0.0937 0.303,0.043 0.4805,0.18925 0.4375,0.40625 l -0.0312,0.84375 0.125,0.21875 c 0.173,0.303 0.485,0.48825 0.875,0.53125 0.217,0 0.5425,0.0312 1.0625,0.0312 0.13,0 0.634,0.0955 1.5,0.3125 0.043,-0.043 0.24775,-0.2205 0.59375,-0.4375 0.259,-0.26 0.42075,-0.38775 0.59375,-0.34375 0.043,0.129 0.13275,0.35325 0.21875,0.65625 0.13,0.26 0.3025,0.32425 0.5625,0.28125 0.173,-0.086 0.3845,-0.24 0.6875,-0.5 1.169,-0.086 1.826,-0.086 2,0 0.13,0.13 0.18075,0.7735 0.0937,1.8125 -0.043,0.13 -0.18925,0.47425 -0.40625,0.90625 l 0.15625,0.0937 0.625,0 0.15625,-0.125 c -0.043,-0.693 -0.0245,-1.16575 0.0625,-1.46875 0.173,-0.13 0.37,-0.19925 0.5,-0.15625 l 0.0625,0.0937 0.125,0.46875 c 0.476,-0.043 0.83375,-0.10825 1.09375,-0.28125 -0.086,-0.433 -0.086,-0.783 0,-1 0.563,-0.303 0.832,-0.46875 0.875,-0.46875 0.043,0 0.356,0.307 0.875,1 l 0.15625,0.0312 c 0.303,-0.26 0.52625,-0.337 0.65625,-0.25 l 0.125,0.125 0.0312,0.25 c 0.13,0.13 0.5005,0.0987 1.0625,-0.0312 0.606,-0.173 0.957,-0.21875 1,-0.21875 0.173,0.043 0.288,0.32475 0.375,0.84375 0.043,0.216 0.1395,0.53575 0.3125,0.96875 -0.043,0.346 -0.0888,0.5585 -0.21875,0.6875 -0.52,0.433 -1.1195,0.75175 -1.8125,0.96875 0.043,0.043 0.196,0.40575 0.5,0.96875 0.476,0.866 0.73825,1.36325 0.78125,1.40625 l 0.84375,1.15625 0.125,0.0625 c 0.347,-0.26 0.6335,-0.375 0.9375,-0.375 0.086,0 0.27125,0.22425 0.53125,0.65625 0,0.347 0.0263,0.65125 0.15625,0.78125 l 0.75,0.875 c 0.26,0.346 0.221,0.773 -0.125,1.25 -0.433,0.606 -0.625,0.94425 -0.625,1.03125 0.043,0.173 0.15225,0.31425 0.28125,0.53125 0.173,0.173 0.21875,0.35725 0.21875,0.53125 -0.086,0.736 -0.1055,1.125 -0.0625,1.125 0.043,0.087 0.1825,0.0625 0.3125,0.0625 0.649,-0.043 1.65125,-0.0312 2.90625,-0.0312 l 0.125,-0.0312 c 0.043,-0.693 0.35,-0.97475 1,-0.84375 0.519,0.173 0.7695,0.23725 0.8125,0.28125 0.086,0.086 0.2645,0.1775 0.4375,0.4375 0.173,0.13 0.47325,0.3465 0.90625,0.5625 0.216,0.26 0.4705,0.73275 0.6875,1.46875 0.26,0.26 0.7055,0.32425 1.3125,0.28125 0.433,-0.043 0.7595,-0.2545 1.0625,-0.6875 0.13,-0.217 0.366,-0.65575 0.625,-1.21875 l 0.4375,-0.625 c 0.043,-0.086 0.15125,-0.27125 0.28125,-0.53125 0.13,-0.087 0.3415,-0.163 0.6875,-0.25 l 0.59375,-0.125 c 0.39,-0.087 0.7935,0.0592 1.3125,0.40625 0.52,0.346 0.8895,0.653 1.0625,1 0.13,0 0.41075,-0.16475 0.84375,-0.46875 l 0.1875,0.0312 c 0.086,0.087 0.44375,0.2595 1.09375,0.5625 0.563,0.216 0.98325,0.36225 1.15625,0.40625 0.086,0.043 0.34825,-0.008 0.78125,-0.0937 l 2.46875,-0.4375 c 0.26,-0.086 0.3945,-0.125 0.4375,-0.125 l 1.9375,-0.15625 c 0.13,-0.13 0.1875,-0.755 0.1875,-1.75 0.043,-0.043 0.34325,-0.125 0.90625,-0.125 0.043,-0.086 0.0743,-0.21375 0.0312,-0.34375 l -0.34375,-0.25 -0.0312,-0.15625 c 0.086,-0.476 0.0743,-0.77625 0.0312,-0.90625 -0.303,-0.52 -0.33025,-0.8885 -0.15625,-1.0625 0.043,-0.086 0.274,-0.1445 0.75,-0.1875 0.39,0 0.67475,-0.081 0.71875,-0.125 l 0.0313,-0.9062 -0.6875,-0.0937 c -0.303,-0.043 -0.38675,-0.30525 -0.34375,-0.78125 0.086,-0.476 0.2205,-0.77625 0.4375,-0.90625 0.346,-0.217 0.50775,-0.34375 0.59375,-0.34375 0.173,-0.13 0.47325,-0.17575 0.90625,-0.21875 0.303,0 0.66475,-0.12775 0.96875,-0.34375 l 0.125,0.0937 c 0.13,0.173 0.283,0.485 0.5,0.875 0.086,0.087 0.23325,0.163 0.40625,0.25 0.173,0.043 0.3505,-0.008 0.4375,-0.0937 0.13,-0.216 0.19425,-0.485 0.28125,-0.875 l 0.0937,-0.0625 c 0.13,0.043 0.35325,-0.0195 0.65625,-0.0625 0.303,-0.086 0.4755,-0.17575 0.5625,-0.21875 0.043,-0.086 0.0362,-0.32375 -0.0937,-0.84375 -0.086,-0.433 0.0347,-0.8415 0.46875,-1.1875 0.216,-0.087 0.47825,-0.048 0.78125,0.125 0.26,0.173 0.48325,0.1875 0.65625,0.1875 0.13,-0.086 0.39225,-0.26725 0.78125,-0.65625 l 0.1875,0.0312 c 0.13,0.173 0.19925,0.404 0.15625,0.75 0.087,0.173 0.27125,0.47825 0.53125,0.78125 0.259,0.303 0.4375,0.52625 0.4375,0.65625 0.043,0.173 0.0235,0.47325 -0.0625,0.90625 0.086,0.13 0.2595,0.2255 0.5625,0.3125 l 0.0625,0.125 0.0312,-0.0625 c 0.043,-0.173 0.1395,-0.677 0.3125,-1.5 0.087,-0.736 0.2645,-1.21375 0.4375,-1.34375 l 0.5625,0.0312 0.25,-0.125 c 0.043,-0.13 0.17075,-0.437 0.34375,-1 0.087,-0.303 0.38725,-0.42575 0.90625,-0.46875 0.13,-0.13 0.207,-0.3025 0.25,-0.5625 0.086,-0.043 0.40575,-0.043 0.96875,0 0.606,0.087 1.02125,0.0352 1.28125,-0.0937 0.087,-0.086 0.1445,-0.17075 0.1875,-0.34375 0.086,-0.217 0.11325,-0.48425 0.15625,-0.65625 l 0,-0.34375 c -0.043,-0.303 -0.0625,-0.60325 -0.0625,-0.90625 0.13,-0.39 0.207,-0.73325 0.25,-0.90625 0.043,-0.433 0.0937,-0.69025 0.0937,-0.90625 0.086,-0.086 0.2205,-0.13775 0.4375,-0.0937 0.26,0.52 0.34375,1.062 0.34375,1.625 l -0.28125,0.34375 c -0.043,0.13 -0.0235,0.39225 0.0625,0.78125 0.087,0.433 0.21375,0.6435 0.34375,0.6875 l 0.125,-0.0937 c 0.13,-0.216 0.39725,-0.82825 0.65625,-1.78125 0.26,-0.476 0.69375,-0.898 1.34375,-1.375 0.043,-0.086 0.082,-0.31025 0.125,-0.65625 l 0.125,-0.0937 c 0.13,0.043 0.2255,0.1005 0.3125,0.1875 0.043,0.043 0.13175,0.16975 0.21875,0.34375 0.52,0.476 0.99775,0.4185 1.34375,-0.1875 0.086,-0.13 0.15125,-0.3025 0.28125,-0.5625 0.043,-0.216 0.4565,-0.43525 1.0625,-0.78125 0.173,-0.217 0.27625,-0.47325 0.40625,-0.90625 l 1.21875,0 c 0.043,-0.043 0.19425,-0.47775 0.28125,-1.34375 0.13,-0.866 0.21875,-1.42075 0.21875,-1.59375 -0.087,-0.13 -0.30425,-0.25675 -0.78125,-0.34375 -0.043,-0.173 -0.0507,-0.52 -0.0937,-1.125 0,-0.996 -0.0507,-1.5965 -0.0937,-1.8125 -0.173,-0.693 -0.26175,-1.20375 -0.21875,-1.59375 -0.216,0 -0.3945,-0.0693 -0.4375,-0.15625 0,-0.217 -0.0457,-0.45975 -0.21875,-0.71875 l 0.0937,-0.1875 0.4375,-0.125 0.0937,-0.125 c 0,-0.086 -0.153,-0.46325 -0.5,-1.15625 -0.303,-0.692 -0.37325,-1.235 -0.15625,-1.625 l -0.53125,0.0625 c -0.217,-0.303 -0.293,-0.653 -0.25,-1 0.043,-0.087 0.1395,-0.1825 0.3125,-0.3125 0.39,-0.39 1.02075,-0.697 1.84375,-1 0.866,-0.303 1.3885,-0.52725 1.5625,-0.65625 l 0.0937,0.0625 c 0,0.217 0.007,0.3515 0.0937,0.4375 0.086,0.043 0.19425,0.0743 0.28125,0.0312 0.087,0 0.245,-0.16475 0.375,-0.46875 0.173,-0.346 0.37775,-0.60825 0.59375,-0.78125 l 0.0312,-0.0312 c 0.043,0 0.472,-0.22725 1.25,-0.53125 0.953,-0.433 1.66075,-0.79075 2.09375,-1.09375 l 0.65625,-0.5 c 0.13,-0.13 0.3455,-0.39125 0.5625,-0.78125 0.043,-0.043 0.3705,-0.0507 1.0625,-0.0937 0.217,-0.043 0.3895,-0.312 0.5625,-0.875 l -0.0625,-0.0937 c -0.26,-0.13 -0.7395,-0.201 -1.5625,-0.375 -0.043,-0.346 -0.1445,-0.577 -0.1875,-0.75 l -0.125,-0.0625 c -0.477,-0.043 -1.08925,-0.0625 -1.78125,-0.0625 -0.173,0 -0.366,-0.0642 -0.625,-0.28125 -0.303,-0.26 -0.48325,-0.40625 -0.65625,-0.40625 l -1.531,-0.219 c -0.086,0 -0.21375,-0.12 -0.34375,-0.25 -0.086,-0.563 -0.31025,-0.88175 -0.65625,-0.96875 -0.216,-0.173 -0.36325,-0.4995 -0.40625,-1.0625 l 0.125,-0.0937 0.15625,0 0.125,-0.0312 c 0.087,-0.173 0.17475,-0.45875 0.21875,-0.71875 0.086,-0.216 0.279,-0.26275 0.625,-0.21875 l 0.0625,0.15625 c -0.043,0.086 0.0195,0.19425 0.0625,0.28125 0.26,0.043 0.42075,0.1395 0.59375,0.3125 l 0.0937,0 c 0.086,-0.13 0.1825,-0.35325 0.3125,-0.65625 l 0.125,0 0.15625,0.0625 0.15625,-0.0937 c 0.043,-0.347 0.10825,-0.539 0.28125,-0.625 0.13,-0.043 0.36,0.007 0.75,0.0937 0.173,0.173 0.29975,0.48 0.34375,1 0.476,0.13 0.7645,0.0402 0.9375,-0.21875 0.26,-0.52 0.4765,-0.75675 0.5625,-0.84375 0.13,-0.043 0.39225,-0.005 0.78125,0.125 0.043,0.087 0.0548,0.24775 -0.0312,0.59375 -0.043,0.303 -0.0743,0.50775 -0.0312,0.59375 l 0.125,0.15625 0.15625,0 c 0.129,-0.086 0.27625,-0.437 0.40625,-1 l 0.125,-0.0937 0.125,0.0937 c 0.086,0.086 0.11825,0.3805 0.0312,0.8125 l 0.15625,0.0937 c 0.087,0.216 0.087,0.4285 0,0.6875 0.087,0.087 0.19025,0.13175 0.40625,0.21875 0.13,-0.043 0.2645,-0.3365 0.4375,-0.8125 0.173,-0.476 0.28125,-0.79475 0.28125,-0.96875 l 0.15625,0 0.125,0.0937 0.125,-0.0312 0.0625,-0.4375 c 0.043,-0.173 0.0693,-0.30075 0.15625,-0.34375 0.26,-0.043 0.457,-0.0693 0.5,-0.15625 0,0 0.0195,-0.12775 0.0625,-0.34375 0,-0.347 0.0888,-0.64525 0.21875,-0.90625 -0.39,-0.346 -0.69025,-0.50775 -0.90625,-0.59375 -0.347,-0.13 -0.54575,-0.2305 -0.71875,-0.1875 -1.082,0.347 -1.739,0.39675 -2,0.0937 0.043,-0.347 0.043,-0.6385 0,-0.8125 -0.129,-0.217 -0.25275,-0.4325 -0.46875,-0.5625 -0.086,-0.086 -0.31025,-0.2205 -0.65625,-0.4375 -0.043,0 -0.0312,-0.0118 -0.0312,0.0312 -0.087,-0.086 -0.17475,-0.11325 -0.21875,-0.15625 -0.39,-0.173 -0.61325,-0.2695 -0.65625,-0.3125 l -0.0625,0 -0.0312,0.0312 c -0.087,0 -0.13175,0.0888 -0.21875,0.21875 -0.086,0.216 -0.17575,0.524 -0.21875,1 -0.043,0.13 -0.082,0.31925 -0.125,0.40625 l 0,0.15625 -0.125,0.125 -0.0625,0 c -0.043,0 -0.0625,0.0195 -0.0625,0.0625 l -0.0625,-0.0625 -0.125,-0.0312 0,-0.0937 c -0.043,-0.087 -0.0312,-0.15125 -0.0312,-0.28125 0,-0.086 -0.0195,-0.2255 -0.0625,-0.3125 l 0,-0.0937 c -0.043,0 -0.0312,0.0118 -0.0312,-0.0312 -0.086,-0.346 -0.29075,-0.64625 -0.59375,-0.90625 l -0.125,-0.0937 c -0.303,-0.173 -0.539,-0.36225 -0.625,-0.40625 -0.346,-0.086 -0.5585,-0.21375 -0.6875,-0.34375 -0.087,-0.043 -0.125,-0.0185 -0.125,-0.0625 -0.13,0.043 -0.19425,0.13175 -0.28125,0.21875 -0.086,0.303 -0.207,0.50775 -0.25,0.59375 -0.347,0.476 -0.6335,0.5725 -0.9375,0.3125 0,-0.13 -0.0235,-0.3025 0.0625,-0.5625 l -0.0312,-0.15625 c -0.173,-0.13 -0.53075,-0.206 -1.09375,-0.25 -0.52,-0.043 -0.80075,-0.13275 -0.84375,-0.21875 -0.086,-0.043 -0.086,-0.24775 0,-0.59375 l -1.969,-0.6564 c -0.173,-0.043 -0.288,0.0397 -0.375,0.34375 l -0.125,0.625 c -0.26,0 -0.44425,-0.14625 -0.53125,-0.40625 -0.173,-0.346 -0.25675,-0.5195 -0.34375,-0.5625 l -0.34375,0.0312 -0.125,-0.0625 c -0.217,-0.52 -0.73275,-1.101 -1.46875,-1.75 0.477,-0.26 0.6875,-0.54075 0.6875,-0.84375 -0.043,-0.216 -0.0937,-0.37 -0.0937,-0.5 0.13,-0.087 0.42925,-0.17475 0.90625,-0.21875 0.043,-0.13 0.0353,-0.322 -0.0937,-0.625 -0.52,0.087 -0.909,0.0402 -1.125,-0.21875 -0.087,-0.26 -0.125,-0.49 -0.125,-0.75 l -1.34375,0.0312 -0.78125,-0.0312 c -0.563,-0.087 -0.87,-0.13675 -1,-0.0937 -0.217,0.043 -0.45975,0.279 -0.71875,0.625 -0.52,0.822 -0.60875,1.60775 -0.21875,2.34375 0.433,0.779 0.6055,1.31425 0.5625,1.53125 l -0.3125,-0.0625 c -0.303,-0.303 -0.46475,-0.58375 -0.59375,-0.84375 -0.216,-0.433 -0.34375,-0.625 -0.34375,-0.625 -0.303,-0.346 -0.927,-0.31975 -1.75,0.15625 -0.216,0.13 -0.38275,0.2695 -0.46875,0.3125 -1.126,0.606 -1.98775,0.8995 -2.59375,0.8125 l 0,-0.0312 c 0.519,-0.39 1.40025,-0.8795 2.65625,-1.3125 0.173,-0.13 0.4665,-0.29075 0.8125,-0.59375 0.043,-0.13 0.0743,-0.31425 0.0312,-0.53125 -0.086,-0.26 -0.125,-0.4765 -0.125,-0.5625 0.043,-0.39 0.0507,-0.658 0.0937,-0.875 0,-0.52 -0.23,-0.75 -0.75,-0.75 -0.477,0.129 -0.85325,0.16125 -1.15625,0.0312 -0.259,-0.433 -0.56025,-0.61725 -0.90625,-0.53125 -0.217,0 -0.48425,0.18925 -0.65625,0.40625 -0.217,0.303 -0.4665,0.4765 -0.8125,0.5625 -0.259,0.043 -0.3935,0.0625 -0.4375,0.0625 -0.303,-0.043 -0.62175,-0.20375 -0.96875,-0.59375 -0.347,-0.39 -0.7155,-0.59375 -1.0625,-0.59375 -0.086,0 -0.20875,0.0195 -0.46875,0.0625 -0.346,0.086 -0.62,0.13275 -0.75,0.21875 -0.259,0.217 -0.48325,0.3945 -0.65625,0.4375 -0.043,0.043 -0.082,0.0507 -0.125,0.0937 l 0,0.0312 c 0.043,0.086 0.312,0.8455 0.875,2.1875 l 0.78125,0.125 c 0.043,0.433 -0.0145,0.71375 -0.1875,0.84375 -0.216,-0.043 -0.42075,0.0263 -0.59375,0.15625 -0.087,0.13 -0.125,0.3025 -0.125,0.5625 l -0.0937,0.0625 c -0.13,0 -0.25175,0.0693 -0.46875,0.15625 -0.216,0.043 -0.34375,0.1015 -0.34375,0.1875 L 340,178.31249 c -0.173,0.086 -0.47325,0.0675 -0.90625,-0.0625 -0.087,-0.086 -0.164,-0.15625 -0.25,-0.15625 -0.043,-0.13 -0.13275,-0.1445 -0.21875,-0.1875 l -0.125,-0.15625 c -0.433,-0.303 -0.7255,-0.457 -0.8125,-0.5 -0.39,-0.173 -0.663,-0.22375 -0.75,-0.0937 -0.13,0.26 -0.2255,0.534 -0.3125,0.75 -0.086,0.173 -0.2975,0.404 -0.6875,0.75 -0.346,0.26 -0.5195,0.4375 -0.5625,0.4375 -0.347,0.086 -0.735,-0.028 -1.125,-0.375 -0.39,-0.303 -0.69025,-0.3995 -0.90625,-0.3125 -0.13,0.086 -0.15625,0.2975 -0.15625,0.6875 0.043,0.39 -0.0263,0.6445 -0.15625,0.6875 -0.086,0.043 -0.32875,0.043 -0.71875,0 l -0.28125,-0.15625 c -0.173,-1.212 -0.23825,-1.86325 -0.28125,-1.90625 -0.953,-1.169 -1.42575,-1.92075 -1.46875,-2.09375 0,-0.13 -0.0118,-0.58325 0.0312,-1.40625 l -0.0312,-0.1875 c -0.043,-0.0861 -0.15125,-0.1133 -0.28125,-0.1563 -0.346,0.52 -0.736,0.8075 -1.125,0.9375 -0.823,-0.13 -1.25775,-0.25275 -1.34375,-0.46875 0,-0.217 0.0118,-0.40125 -0.0312,-0.53125 -0.216,-0.173 -0.40125,-0.23825 -0.53125,-0.28125 0.086,-0.476 0.086,-0.745 0,-0.875 l -0.28125,-0.1875 -0.125,0.0625 -0.375,0.5 -0.125,0.0625 -0.375,-0.0937 c 0,0.043 -0.0457,0.17075 -0.21875,0.34375 -0.173,0.173 -0.21875,0.31925 -0.21875,0.40625 0.173,0.26 0.2315,0.46475 0.1875,0.59375 -0.044,0.129 -0.13275,0.17575 -0.21875,0.21875 -0.606,-0.303 -1.0145,-0.4375 -1.1875,-0.4375 l -0.125,0.0937 c -0.043,0.086 -0.082,0.17575 -0.125,0.21875 -0.259,0.476 -0.4325,0.81525 -0.5625,1.03125 -0.173,0.173 -0.2695,0.288 -0.3125,0.375 -0.216,0.52 -0.3945,0.788 -0.4375,0.875 -0.606,0.303 -0.991,0.46875 -1.25,0.46875 l -0.46875,1.125 c 0,0.043 0.16475,0.22725 0.46875,0.53125 -0.086,0.909 -0.3025,1.50275 -0.5625,1.71875 -0.13,0.087 -0.33375,0.15625 -0.59375,0.15625 -0.303,-0.043 -0.4765,-0.1395 -0.5625,-0.3125 0.043,-0.13 -0.0195,-0.2265 -0.0625,-0.3125 -0.13,-0.086 -0.322,0.0213 -0.625,0.28125 -0.346,0.173 -0.58975,0.20425 -0.71875,0.0312 l -0.0312,-0.125 0.0937,-0.125 c 0,-0.087 -0.0195,-0.19425 -0.0625,-0.28125 l -0.46875,-0.21875 -0.125,0.0625 c -0.26,0.52 -0.77575,0.87 -1.46875,1 -0.693,0.13 -1.04975,0.245 -1.09375,0.375 -0.216,0.477 -0.42075,0.79575 -0.59375,0.96875 l -0.21875,0.125 c -0.13,0.26 -0.207,0.38175 -0.25,0.46875 -0.13,0.173 -0.283,0.2695 -0.5,0.3125 -0.303,-0.043 -0.456,-0.18925 -0.5,-0.40625 -0.173,-1.125 -0.39725,-1.81425 -0.65625,-2.03125 l -0.9688,-0.5937 c -0.736,-0.26 -1.279,-0.4325 -1.625,-0.5625 -0.303,-0.13 -0.52725,-0.2695 -0.65625,-0.3125 l -0.8125,-0.0937 c -0.173,0.043 -0.33875,0.0625 -0.46875,0.0625 -0.303,0 -0.539,0.038 -0.625,0.125 0.043,0.52 0.005,0.87 -0.125,1 -0.173,0.13 -0.39725,0.19925 -0.65625,0.15625 -0.26,-0.043 -0.48325,-0.0937 -0.65625,-0.0937 -0.39,0.043 -0.67075,0.0548 -0.84375,-0.0312 -0.476,-0.13 -0.822,-0.3075 -1.125,-0.4375 l -0.28125,0 c -0.346,0.173 -0.46875,0.70825 -0.46875,1.53125 0.043,0.476 0.081,1.0775 0.125,1.8125 -0.043,0.606 -0.158,0.98325 -0.375,1.15625 -0.173,0.13 -0.36325,0.19425 -0.40625,0.28125 -0.39,0.26 -0.65025,0.50275 -0.78125,0.71875 l -0.125,0.3125 c -0.043,0.173 -0.0702,0.5055 -0.15625,0.9375 -0.087,0.217 -0.16975,0.5855 -0.34375,1.0625 -0.563,0.303 -1.0145,0.44925 -1.1875,0.40625 -0.346,-0.26 -0.812,-0.063 -1.375,0.5 -0.303,0.043 -0.52725,-0.0263 -0.65625,-0.15625 l -0.15625,0 c -0.043,0.26 -0.1825,0.495 -0.3125,0.625 l -0.1875,-0.0937 -0.0312,-0.0937 c -0.173,-0.433 -0.30075,-0.6445 -0.34375,-0.6875 -0.433,-0.303 -0.82975,-0.42975 -1.21875,-0.34375 -0.216,0.087 -0.33975,0.0753 -0.46875,0.0312 -0.693,-0.173 -1.082,-0.28125 -1.125,-0.28125 -0.173,0.043 -0.31925,0.0937 -0.40625,0.0937 -0.39,-0.043 -0.62675,-0.043 -0.84375,0 -0.217,0.086 -0.529,0.2595 -0.875,0.5625 -0.346,0.26 -0.5955,0.4765 -0.8125,0.5625 -0.606,-0.043 -1.0145,-0.0937 -1.1875,-0.0937 -0.346,0.086 -0.60825,0.11825 -0.78125,0.0312 -0.26,-0.216 -0.3945,-0.331 -0.4375,-0.375 -0.606,-0.346 -1.06025,-0.5195 -1.40625,-0.5625 -0.346,0 -0.62,-0.0195 -0.75,-0.0625 -0.347,-0.216 -0.5955,-0.28125 -0.8125,-0.28125 -0.433,0.13 -0.8415,0.15625 -1.1875,0.15625 l -0.125,0.0937 -0.125,0 c -0.26,-0.26 -0.50275,-0.336 -0.71875,-0.25 -0.13,0.13 -0.39225,0.25775 -0.78125,0.34375 -0.346,0.13 -0.63175,0.11825 -0.71875,0.0312 -0.173,-0.086 -0.288,-0.29075 -0.375,-0.59375 l -0.21875,0 c -0.086,0.173 -0.27125,0.25 -0.53125,0.25 -0.086,-0.043 -0.24,-0.12675 -0.5,-0.34375 -0.173,-0.086 -0.29575,-0.13675 -0.46875,-0.0937 -0.217,0.043 -0.36325,0.0937 -0.40625,0.0937 -0.217,-0.129 -0.4325,-0.17575 -0.5625,-0.21875 -0.433,0.303 -0.7205,0.42475 -0.9375,0.46875 l -0.31255,0.0937 c -0.216,0.086 -0.36225,0.2645 -0.40625,0.4375 -0.129,0.26 -0.206,0.42575 -0.25,0.46875 -0.779,0.26 -1.21375,0.52225 -1.34375,0.78125 l -0.0312,0.3125 c 0.043,0.086 0.12,0.17075 0.25,0.34375 0.086,0.173 0.0743,0.33775 0.0312,0.46875 -0.043,0.563 -0.15125,1.07875 -0.28125,1.46875 -0.043,0.087 -0.1445,0.163 -0.1875,0.25 -0.303,0.087 -0.46375,0.1445 -0.59375,0.1875 -0.649,0.649 -1,1.03125 -1,1.03125 l -0.0937,0.21875 c 0.043,0.13 0.2155,0.31925 0.5625,0.40625 0.346,0.13 0.582,0.25775 0.625,0.34375 l 0,0.84375 c 0,0.606 -0.0575,0.96375 -0.1875,1.09375 -0.13,0.13 -0.46825,0.207 -1.03125,0.25 -0.39,-0.043 -0.97,0.007 -1.75,0.0937 -0.173,-0.477 -0.37775,-0.78125 -0.59375,-0.78125 -0.953,-0.217 -1.5535,-0.1155 -1.8125,0.1875 -0.087,0.26 -0.1875,0.67525 -0.1875,1.28125 -0.086,0.26 -0.15125,0.4765 -0.28125,0.5625 -0.909,0.26 -1.491,0.44425 -1.75,0.53125 -0.303,0.087 -0.5145,0.207 -0.6875,0.25 l -1.03125,0.5625 c -0.13,0.303 -0.3075,0.54575 -0.4375,0.71875 -0.216,0.303 -0.529,0.3175 -0.875,0.1875 -0.217,-0.433 -0.37,-0.6825 -0.5,-0.8125 l -0.59375,-0.0937 c -0.217,0.043 -0.41575,0.2155 -0.71875,0.5625 -0.346,0.303 -0.48725,0.5 -0.53125,0.5 -0.043,0.043 -0.12775,0.14625 -0.34375,0.40625 -0.217,0.216 -0.3945,0.3945 -0.4375,0.4375 l -1.0625,-0.0625 c -0.0921,0.1764 -0.3789,0.50158 -0.71875,0.96875 -0.13,0.087 -0.32875,0.1875 -0.71875,0.1875 -0.476,0.044 -0.789,0.082 -0.875,0.125 -0.086,0.043 -0.11325,0.0457 -0.15625,0.21875 -0.043,0.173 -0.0507,0.43525 -0.0937,0.78125 -0.043,0.216 -0.40075,0.61275 -1.09375,1.21875 -0.087,0.043 -0.2255,0.0625 -0.3125,0.0625 -0.173,-0.087 -0.288,-0.3355 -0.375,-0.8125 -0.13,-0.52 -0.2645,-0.82025 -0.4375,-0.90625 0.173,-0.52 0.212,-0.87675 0.125,-1.09375 -0.13,-0.26 -0.4615,-0.20925 -0.9375,0.0937 -0.39,0.26 -0.658,0.534 -0.875,0.75 -0.086,0.173 -0.25275,0.43525 -0.46875,0.78125 l -0.46875,0.59375 c 0,0.043 -0.317,0.2555 -0.75,0.6875 -0.347,0.303 -0.57025,0.56525 -0.65625,0.78125 -0.086,0.173 -0.13775,0.70325 -0.0937,1.65625 -0.217,0.649 -0.5815,1.33825 -1.1875,2.03125 0.086,0.39 0.55975,0.58875 1.46875,0.71875 l 0.0312,0.15625 c 0,0.043 -0.038,0.18925 -0.125,0.40625 0,0.129 0.082,0.19425 0.125,0.28125 l 0.0625,0.28125 c -0.086,0.173 -0.284,0.43425 -0.5,0.78125 0.086,0.129 0.13775,0.25775 0.0937,0.34375 z ",
                        "Kiev": "m 276.45,87.961 c -0.346,-0.303 -0.563,-0.433 -0.649,-0.433 -0.39,0.173 -0.649,0.216 -0.823,0.173 -0.26,-0.303 -0.476,-0.52 -0.649,-0.606 -0.043,-0.043 -0.086,-0.043 -0.13,-0.043 -0.13,0.26 -0.216,0.477 -0.26,0.693 -0.043,0.087 -0.043,0.39 -0.043,0.909 0,0.13 -0.043,0.433 -0.087,0.953 -0.086,0.693 -0.043,1.083 0,1.169 l 0.217,0.043 c 0.13,-0.087 0.216,-0.217 0.303,-0.347 l 0.13,-0.043 0.173,0.086 0.043,0.13 c -0.043,0.217 -0.173,0.52 -0.477,0.909 -0.303,0.39 -0.52,0.693 -0.52,0.953 0.086,0.217 0.433,0.433 0.953,0.563 0.086,0.173 0.13,0.52 0.13,1.125 0.043,0.606 0,1.039 -0.13,1.299 -0.173,0.563 -0.649,0.91 -1.299,0.996 l -0.173,0.216 v 0.173 c 0.13,0.086 0.477,0.216 0.909,0.433 v 0.13 c -0.39,0.173 -0.649,0.476 -0.866,0.866 0,0.13 0.086,0.39 0.303,0.779 0.173,0.347 0.259,0.606 0.173,0.823 -0.216,0.13 -0.39,0.26 -0.52,0.303 -0.13,0.216 -0.26,0.692 -0.346,1.342 -0.13,0.649 -0.173,1.126 -0.173,1.429 0.086,0.649 0.217,1.169 0.433,1.515 0.13,0.26 0.216,0.606 0.26,1.126 l -0.043,0.13 c -0.043,0 -0.043,0 -0.086,0 0.043,0.216 -0.087,0.52 -0.303,0.866 -0.173,0.173 -0.303,0.39 -0.39,0.563 l 6.148,0.52 -0.087,-0.217 c -0.043,-0.173 -0.043,-0.346 0.043,-0.433 0.433,-0.52 0.736,-0.649 0.909,-0.477 0.216,0.217 0.563,0.477 0.996,0.779 l 0.563,-0.043 0.996,0.866 0.043,0.606 -1.212,0.779 -0.259,-0.26 -0.433,0.216 v 0.52 l -0.477,0.39 -0.043,0.649 0.433,0.217 0.087,1.559 0.952,0.303 0.736,0.78 -0.173,0.303 0.433,0.606 -0.347,0.216 h -0.519 l -0.13,0.433 -0.563,0.736 c 0.086,0.347 0.043,0.52 -0.043,0.606 -0.26,0.086 -0.39,0.086 -0.476,-0.043 l -0.173,-0.476 h -0.433 l 0.043,0.952 -1.125,0.39 -0.52,-0.39 -0.346,0.087 -0.303,-0.347 -1.255,0.217 0.346,0.476 c 0.173,0.216 0.26,0.346 0.303,0.39 0.216,0.303 0.347,0.52 0.347,0.649 l 0.043,0.693 c 0.303,0.173 0.476,0.433 0.39,0.736 -0.086,0.433 -0.043,0.693 0.217,0.779 0.606,-0.346 0.952,-0.216 1.039,0.347 0.043,0.303 0.043,0.692 0.043,1.255 0.13,0.217 0.39,0.347 0.866,0.477 0.043,0.13 0,0.346 -0.13,0.649 0.086,0.216 0.303,0.476 0.692,0.779 0.087,0.13 0.173,0.433 0.217,0.909 0.173,0.216 0.476,0.303 0.953,0.173 l 0.086,0.087 c 0.043,0.086 0.043,0.216 0.043,0.476 0.043,0.433 0.347,0.649 0.953,0.606 0.736,-0.043 1.169,0.086 1.342,0.39 0.303,0.52 0.823,1.169 1.515,1.948 0.13,0.173 0.26,0.39 0.477,0.736 0.173,0.26 0.476,0.649 0.866,1.169 l 1.602,1.732 c 0.39,0.347 0.65,0.563 0.823,0.649 0.39,0.173 0.693,0.173 0.953,0 0.303,-0.216 0.476,-0.346 0.563,-0.346 0.043,0 0.26,0.043 0.563,0.13 0.217,0.13 0.433,0.433 0.736,0.909 0.346,0.303 0.779,0.52 1.212,0.563 0.217,0.043 0.52,0.086 0.996,0.086 0.173,0.043 0.477,0.13 0.909,0.26 0.303,0 0.476,-0.26 0.563,-0.822 0.086,-0.649 0.26,-1.126 0.433,-1.299 0.26,-0.303 0.779,-0.303 1.559,-0.043 0.216,0 0.52,-0.087 0.952,-0.26 0.217,0.043 0.563,0.173 0.996,0.39 0.13,0 0.303,0.043 0.606,0.043 0.13,0.043 0.217,0.087 0.26,0.173 0.129,0.26 -0.043,0.996 -0.606,2.165 0,0.043 0.086,0.39 0.26,1.082 0.13,-0.043 0.303,-0.043 0.39,0 0.086,0.087 0.173,0.303 0.26,0.693 0.043,0.303 0.216,0.52 0.52,0.649 0.043,0.173 0.087,0.433 0.13,0.823 0.043,0.13 0.173,0.26 0.39,0.433 0.043,0.086 0.13,0.173 0.217,0.346 h 0.173 c 0.086,-0.043 0.13,-0.26 0.173,-0.692 0.043,-0.39 0.216,-0.563 0.433,-0.606 0.216,0.043 0.39,0.216 0.606,0.477 0.216,0.13 0.476,0.086 0.649,-0.043 0.347,-0.173 0.52,-0.476 0.563,-0.909 0,-0.477 0.043,-0.779 0.13,-0.823 0.433,-0.13 0.649,0.086 0.649,0.563 -0.043,0.693 -0.043,1.082 0,1.125 0.043,0.043 0.346,0.13 0.909,0.217 0.173,0.043 0.909,0.173 2.208,0.433 0.173,-0.173 0.477,-0.649 0.866,-1.515 0.043,-0.043 0.26,-0.26 0.606,-0.606 0.13,-0.13 0.13,-0.433 0.043,-0.996 0.043,-0.087 0.173,-0.303 0.476,-0.563 0.347,-0.433 0.606,-0.909 0.823,-1.385 0.086,-0.26 0.086,-0.65 0,-1.169 -0.086,-0.519 -0.086,-0.822 -0.086,-0.909 0.086,-0.043 0.52,-0.173 1.299,-0.346 0.52,-0.13 0.736,-0.39 0.779,-0.779 -0.13,-0.13 -0.26,-0.39 -0.346,-0.823 l -0.087,-0.606 c 0,-0.26 0,-0.433 -0.043,-0.563 -0.13,-0.346 -0.217,-0.649 -0.303,-0.823 v -0.173 c 0.043,-0.217 0.39,-0.477 0.953,-0.736 0.476,-0.216 0.779,-0.736 0.866,-1.472 l 0.13,-0.13 c 0.26,0.347 0.477,0.477 0.736,0.433 0.129,-0.043 0.39,-0.216 0.736,-0.476 0.866,-0.78 1.125,-1.342 0.822,-1.775 -0.346,-0.433 -0.519,-0.693 -0.563,-0.866 -0.087,-0.39 0,-0.78 0.346,-1.169 0.26,-0.347 0.606,-0.563 0.996,-0.606 0.216,-0.043 0.52,0.087 0.909,0.346 0.303,0.173 0.476,0.26 0.563,0.26 h 0.043 c 0.043,-0.087 0.217,-0.303 0.477,-0.65 0.26,-0.39 0.39,-0.606 0.433,-0.692 0.129,-0.26 0,-0.477 -0.303,-0.606 0,-0.26 0.216,-0.52 0.692,-0.779 0.043,-0.043 0.13,-0.39 0.26,-0.996 l -1.732,-2.555 0.043,-0.173 c 0.216,-0.26 0.477,-0.52 0.779,-0.692 0.043,-0.173 0.043,-0.26 0,-0.39 -0.173,-0.129 -0.433,-0.173 -0.736,-0.129 -0.39,0.086 -0.649,0.129 -0.693,0.129 -0.216,-0.043 -0.563,-0.303 -0.996,-0.866 -0.043,-0.173 -0.043,-0.52 0.043,-1.039 -0.173,-0.216 -0.563,-0.563 -1.256,-0.909 0,-0.217 0.13,-0.476 0.346,-0.823 0.173,-0.346 0.346,-0.52 0.52,-0.563 0.086,0 0.259,0 0.519,0.087 0.26,0.043 0.39,0 0.477,-0.13 0.086,-0.13 0.13,-0.347 0.173,-0.693 h 0.173 l 0.13,-0.043 c 0,-0.173 -0.13,-0.563 -0.433,-1.125 -0.043,-0.086 -0.347,-0.13 -0.953,-0.13 -0.606,0.043 -1.039,0 -1.169,-0.043 -0.26,-0.086 -0.477,-0.26 -0.649,-0.52 -0.13,-0.303 -0.26,-0.563 -0.39,-0.736 l -0.52,-0.693 c -0.563,-0.216 -0.952,-0.476 -1.169,-0.779 -0.086,-0.26 -0.173,-0.433 -0.26,-0.52 -0.173,-0.087 -0.52,-0.087 -1.039,0.043 -0.477,0.087 -0.779,0.173 -0.866,0.303 0,0.433 -0.043,0.693 -0.13,0.823 l -0.217,0.173 c -0.13,0.13 -0.086,0.346 0.043,0.606 l -0.043,0.173 c -0.13,0.043 -0.303,0.13 -0.52,0.216 -0.13,0.303 -0.303,0.563 -0.52,0.779 -0.173,0.043 -0.476,0.087 -0.866,0 -0.477,-0.043 -0.823,-0.086 -0.996,0 -0.13,0 -0.26,0.13 -0.433,0.303 -0.129,0.26 -0.26,0.39 -0.303,0.39 -0.303,0.043 -0.52,0.043 -0.693,0.13 -0.173,0.13 -0.346,0.39 -0.563,0.693 -0.086,0.086 -0.259,0.086 -0.476,0.043 -0.216,-0.043 -0.39,-0.043 -0.433,-0.043 -0.216,0.26 -0.433,0.39 -0.606,0.433 -0.39,-0.043 -0.649,-0.086 -0.779,-0.13 -0.346,-0.086 -0.606,-0.173 -0.823,-0.216 -0.476,-0.13 -0.736,-0.13 -0.779,0 -0.563,0.649 -1.039,0.909 -1.429,0.779 -0.217,-0.086 -0.39,-0.173 -0.477,-0.216 -0.433,-0.13 -0.693,-0.217 -0.909,-0.26 -0.433,-0.217 -0.779,-0.303 -0.996,-0.39 l -0.303,0.303 c -0.39,0.26 -0.649,0.303 -0.866,0.087 -0.303,-0.303 -0.477,-0.433 -0.563,-0.433 -0.173,0.13 -0.346,0.173 -0.477,0.13 -0.389,-0.216 -0.606,-0.476 -0.692,-0.779 0.13,-0.606 0.13,-0.953 0.086,-1.083 l -0.13,-0.086 c -0.26,-0.087 -0.563,-0.043 -0.779,0.173 -0.173,0 -0.26,0 -0.346,-0.086 -0.693,-0.736 -1.083,-1.125 -1.256,-1.255 -0.13,-0.347 -0.043,-0.649 0.173,-0.909 l 0.13,-0.043 c 0.216,0.086 0.346,0.086 0.476,0.043 0.087,-0.087 0.173,-0.217 0.26,-0.39 0.217,-0.433 0.173,-1.083 -0.043,-1.905 -0.087,-0.39 -0.26,-0.736 -0.563,-0.996 -0.606,-0.433 -0.953,-0.736 -1.039,-0.866 0.086,-0.39 0.13,-0.649 0.086,-0.736 -0.043,0 -0.39,-0.043 -1.039,0 -0.39,-0.043 -0.52,-0.26 -0.433,-0.736 0.043,-0.13 0.13,-0.346 0.26,-0.606 l -0.52,-0.173 c -0.086,-0.043 -0.13,-0.173 -0.13,-0.26 0.043,-0.13 0.086,-0.26 0.043,-0.303 -0.043,-0.173 -0.303,-0.26 -0.649,-0.216 -0.26,0.216 -0.476,0.39 -0.606,0.433 -0.26,0.173 -0.736,0.173 -1.429,0.13 -0.779,-0.13 -1.212,-0.13 -1.385,-0.13 -0.13,0.043 -0.347,0.173 -0.606,0.39 -0.26,0.26 -0.433,0.39 -0.606,0.476 -0.866,-0.736 -1.429,-0.909 -1.775,-0.563 -0.086,0.52 -0.303,0.822 -0.649,0.822 -0.173,-0.043 -0.346,-0.216 -0.563,-0.52 -0.173,-0.346 -0.39,-0.563 -0.606,-0.649 -0.216,-0.086 -0.52,-0.043 -0.909,0.13 -0.346,0.173 -0.606,0.217 -0.823,0.13 -0.043,-0.043 -0.086,-0.13 -0.13,-0.216 0,-0.043 0.173,-0.433 0.563,-1.169 0.086,-0.173 0.173,-0.39 0.303,-0.606 0.13,-0.433 0.26,-0.909 0.346,-1.472 0.086,-0.346 0.086,-0.52 0.086,-0.563 -0.043,-0.173 -0.216,-0.303 -0.433,-0.477 -0.606,-0.39 -0.909,-0.606 -0.996,-0.649 -1.342,-0.303 -2.078,-0.606 -2.294,-0.953 -0.13,-0.216 -0.13,-0.779 0.086,-1.645 0.173,-0.909 0.216,-1.602 0.043,-2.035 -0.04,-0.176 -0.3,-0.479 -0.733,-0.955 m -8.4,-16.973 c -0.043,-0.649 -0.043,-1.039 -0.086,-1.169 -0.043,-0.086 -0.563,-0.346 -1.472,-0.779 -0.39,-0.173 -0.823,-0.52 -1.256,-1.039 -0.173,-0.173 -0.26,-0.26 -0.303,-0.347 -0.346,-0.52 -0.563,-0.822 -0.692,-0.996 -0.606,-0.606 -1.429,-0.823 -2.511,-0.736 -0.606,0.13 -1.083,0.173 -1.386,0.173 -1.212,-0.086 -2.078,-0.043 -2.684,0.043 -0.433,0.043 -0.78,0.173 -1.083,0.476 -0.347,0.347 -0.649,0.649 -0.866,0.909 l -0.13,0.043 c -0.086,-0.086 -0.173,-0.216 -0.259,-0.346 -0.043,-0.217 -0.13,-0.303 -0.26,-0.39 -0.347,0 -0.65,0.216 -0.866,0.649 -0.303,0.52 -0.52,0.822 -0.606,0.866 -0.173,0.086 -0.39,0.13 -0.563,0 -0.303,-0.13 -0.477,-0.216 -0.649,-0.216 -0.26,-0.043 -0.433,-0.043 -0.563,-0.043 -0.52,0.13 -0.866,0.173 -1.083,0.13 -0.433,0 -0.649,-0.216 -0.822,-0.606 -0.043,-0.173 -0.087,-0.433 -0.13,-0.779 -0.303,-0.563 -0.433,-0.909 -0.433,-0.953 -0.303,-0.303 -0.996,-0.303 -2.078,0 -0.477,0.086 -0.736,0.173 -0.78,0.173 -0.173,0.13 -0.303,0.26 -0.39,0.476 -0.043,0.649 -0.216,1.039 -0.39,1.169 -0.26,0.173 -0.606,0.173 -1.125,0 -0.477,-0.13 -0.823,-0.173 -0.996,0 -0.086,0.043 -0.13,0.13 -0.173,0.216 -0.043,0.347 -0.13,0.606 -0.173,0.736 -0.303,1.125 -0.563,1.732 -0.823,1.818 -0.173,0.043 -0.433,-0.043 -0.823,-0.216 -0.433,-0.26 -0.779,-0.39 -1.039,-0.347 -0.606,0 -1.125,0.26 -1.515,0.736 -0.216,0.216 -0.347,0.39 -0.52,0.476 0.086,0.13 0.216,0.347 0.39,0.606 l 0.13,0.043 c 0.13,0 0.216,-0.086 0.39,-0.303 h 0.13 c 0.13,0.13 0.216,0.649 0.086,1.472 0.043,0.39 0.043,0.736 0.043,0.953 0,0.173 -0.086,0.433 -0.26,0.779 -0.303,0.649 -0.866,1.256 -1.688,1.819 -0.563,0.433 -1.126,0.606 -1.688,0.52 l -0.043,0.13 c 0.173,0.476 0.26,0.822 0.303,0.996 l 0.043,0.043 c 0.173,0.476 0.26,0.822 0.303,1.039 0,0.26 0.086,0.649 0.086,1.169 0.13,0.996 0.303,1.732 0.606,2.294 0.043,0 0.346,-0.433 0.823,-1.255 l 0.173,-0.086 c 0.39,0.086 0.823,0.303 1.299,0.692 0.52,0.433 0.866,0.78 0.953,1.126 0.086,0.086 0.13,0.303 0.173,0.606 l 0.086,0.087 c 0.996,0.26 1.602,0.649 1.732,1.169 0.043,0.216 0.043,0.39 0,0.52 -0.346,0.39 -0.606,0.736 -0.736,0.996 -0.087,0.26 -0.13,0.736 -0.043,1.299 0.13,0.909 0.173,1.385 0.13,1.472 -0.173,0 -0.303,-0.043 -0.52,-0.26 -0.216,-0.173 -0.347,-0.303 -0.433,-0.303 -0.346,-0.087 -0.823,-0.087 -1.299,-0.043 l -0.086,0.13 c 0,0.606 0.043,0.996 0.086,1.212 0.043,0.043 0.216,0.043 0.433,0 0.173,-0.043 0.303,0 0.39,0.086 0.13,0.216 0.346,0.563 0.693,0.953 0.649,1.039 1.039,1.602 1.168,1.732 0.13,0.216 0.39,0.52 0.78,0.866 0.043,0.087 0.043,0.26 0,0.477 l -0.087,0.563 c -0.346,1.169 -0.476,2.122 -0.563,2.858 l 0.086,0.13 h 0.173 c 1.299,-0.217 2.035,-0.13 2.251,0.346 0.043,0.476 0.13,0.823 0.217,1.083 0,0.13 0.086,0.52 0.303,1.212 0.173,0.563 0.173,0.996 -0.043,1.255 -0.173,0.173 -0.606,0.39 -1.299,0.736 -0.043,0 -0.173,0.303 -0.477,0.866 -0.433,0.606 -0.779,1.083 -0.996,1.385 -0.216,0.563 -0.39,0.953 -0.52,1.212 0,0.13 0.173,0.303 0.476,0.563 0.433,0.26 0.649,0.433 0.693,0.52 -0.303,0.996 -0.52,1.559 -0.649,1.732 -0.347,-0.086 -0.563,-0.043 -0.693,0.086 -0.086,0.303 -0.086,0.52 0,0.693 l 0.693,0.26 c 0.216,0.303 0.173,0.779 -0.043,1.385 -0.173,0.347 -0.303,0.563 -0.433,0.693 -0.173,0 -0.433,-0.043 -0.91,-0.216 l -0.129,0.13 -0.087,0.303 0.087,0.13 0.779,0.346 v 0.13 c -0.173,0.303 -0.303,0.476 -0.346,0.476 l -0.866,0.087 c -0.26,0.086 -0.303,0.346 -0.13,0.736 0.173,0.13 0.346,0.173 0.476,0.13 l 0.736,-0.216 c 0.129,-0.043 0.346,-0.13 0.563,-0.26 l 0.303,-0.13 c 0.26,-0.043 0.649,-0.043 1.255,-0.043 0.173,0 0.477,0.216 0.823,0.693 0.347,0.433 0.52,0.779 0.563,0.996 -0.086,0.563 -0.086,0.996 -0.043,1.256 0.13,0.13 0.303,0.216 0.606,0.346 -0.217,0.606 -0.26,1.039 -0.217,1.299 l 0.043,0.13 c 0.086,0.043 0.52,0.043 1.255,0 0.217,0.173 0.563,0.779 1.039,1.862 0.173,0.13 0.39,0.173 0.52,0.173 l 0.26,0.173 v 0.13 c -0.13,0.173 -0.26,0.346 -0.303,0.52 -0.043,0.476 -0.043,0.823 0,1.082 0.043,0.433 0.043,0.78 0.043,0.996 0,0.26 0,0.649 -0.043,1.125 l 0.043,0.13 c 0.13,0.303 0.433,0.563 0.952,0.779 l 0.13,0.26 c 0,0.086 -0.043,0.216 -0.217,0.433 -0.13,0.217 -0.13,0.433 -0.043,0.649 0.087,0.087 0.347,0.173 0.693,0.217 0,0.043 -0.043,0.216 -0.086,0.563 -0.13,0.129 -0.39,0.259 -0.909,0.476 -0.52,0.173 -0.823,0.216 -0.909,0.173 -0.26,0.086 -0.39,0.26 -0.39,0.476 0.043,0.26 0.217,1.083 0.563,2.468 -0.216,0.173 -0.433,0.303 -0.476,0.347 -0.087,0.303 0.563,1.559 2.035,3.723 -0.043,0.52 -0.347,0.953 -0.996,1.299 -0.693,0.303 -1.083,0.52 -1.212,0.649 -0.086,0.13 -0.13,0.39 -0.13,0.649 -0.086,0.13 -0.13,0.216 -0.173,0.216 -0.26,0.26 -0.39,0.39 -0.433,0.433 l -0.13,0.13 -0.087,0.043 -0.606,0.217 c -0.216,0.216 -0.346,0.346 -0.39,0.39 -0.563,0.26 -0.953,0.433 -1.255,0.606 -0.477,0.39 -0.866,0.649 -1.04,0.823 -0.13,0.043 -0.303,0.086 -0.433,0.043 -0.173,-0.087 -0.303,-0.087 -0.389,-0.087 -0.087,0.087 -0.13,0.26 -0.173,0.52 l -0.216,0.217 c -0.303,-0.087 -0.563,-0.087 -0.693,-0.087 -0.26,0.217 -0.477,0.347 -0.606,0.39 0,0.26 0.043,0.52 0.26,0.78 0.173,0.26 0.216,0.476 0.26,0.606 0.043,0.649 -0.217,1.342 -0.736,2.035 -0.086,0.129 -0.173,0.303 -0.346,0.476 0.563,0.043 0.909,0.043 1.039,0 0.216,0 0.52,-0.043 0.866,-0.13 0.217,0.216 0.217,0.736 -0.043,1.559 -0.433,0.086 -0.693,0.216 -0.866,0.346 -0.13,0.26 -0.173,0.52 -0.043,0.736 0.217,0.086 0.606,0.13 1.126,0.13 0.476,0.086 0.779,0.26 0.909,0.563 0,0.303 -0.086,0.649 -0.347,1.083 0,0.086 -0.086,0.173 -0.173,0.259 -0.173,0.606 -0.173,1.212 0,1.732 0.173,0.39 0.52,0.736 1.169,0.996 0.606,0.26 0.866,0.433 0.866,0.563 0.043,0.216 0,0.52 -0.043,0.909 l 0.043,0.13 c 0,0.086 -0.13,0.216 -0.433,0.303 -0.26,0.13 -0.39,0.26 -0.433,0.433 0,0.216 0.173,0.606 0.477,1.169 0.346,0.563 0.476,0.909 0.519,0.996 l -0.043,0.909 c -0.043,0.173 -0.52,0.52 -1.516,1.169 -0.303,0.173 -0.52,0.433 -0.563,0.779 -0.087,0.39 0,0.693 0.216,0.909 0.26,0.26 0.39,0.52 0.433,0.693 0.043,0.779 0.13,1.212 0.216,1.255 0.13,0.13 0.693,0.173 1.688,0.217 0.303,0.043 0.649,0.563 0.866,1.515 0.173,0.173 0.303,0.39 0.563,0.693 0.043,0.13 0.129,0.39 0.173,0.736 0.303,0.173 0.649,0.087 1.083,-0.13 l 0.346,0.043 c 0.13,0.086 0.217,0.346 0.26,0.736 0.433,0.347 0.823,0.39 1.126,0.173 0.173,0.043 0.303,0.217 0.346,0.476 l -0.086,0.13 c -0.26,0.043 -0.39,0.13 -0.52,0.26 -0.13,0.173 -0.13,0.303 0,0.433 0.693,0.736 1.299,1.083 1.732,1.039 0.476,-0.043 0.736,-0.043 0.822,-0.043 0.173,-0.043 0.433,-0.087 0.78,-0.173 0.216,0.043 0.519,0.086 0.909,0.216 0.087,-0.13 0.087,-0.346 0.043,-0.606 -0.086,-0.303 -0.086,-0.476 -0.043,-0.563 l 0.52,-0.52 c 0.346,-0.346 0.649,-0.866 0.822,-1.559 0.52,-0.216 0.866,-0.476 1.039,-0.866 0.26,-0.086 0.736,-0.043 1.429,0.087 l 0.346,-0.13 c 0.043,-0.043 0.173,-0.26 0.347,-0.606 0.129,-0.259 0.303,-0.39 0.519,-0.39 0.087,0.087 0.303,0.26 0.52,0.477 l 0.173,-0.043 0.043,-0.173 c 0.346,-0.216 0.736,-0.086 1.169,0.39 0.13,0 0.216,0 0.347,0 l 0.086,-0.13 c 0,-0.216 -0.13,-0.52 -0.476,-0.952 0,-0.347 0.129,-0.606 0.346,-0.736 l 0.649,-0.086 c 0.043,-0.13 0.13,-0.346 0.13,-0.693 0.13,-0.086 0.563,0.043 1.299,0.39 0,0.13 -0.13,0.39 -0.39,0.779 -0.216,0.303 -0.303,0.606 -0.216,0.823 0.086,0.13 0.952,0.39 2.641,0.693 1.861,0.303 2.857,0.52 3.117,0.649 0,0.563 -0.043,0.909 -0.086,1.039 0.173,0.13 0.476,0.13 0.866,0.043 l 0.087,-0.13 c 0.129,-0.649 0.346,-1.516 0.606,-2.641 0.13,-0.26 0.216,-0.477 0.216,-0.649 -0.043,-0.52 0,-0.953 0.086,-1.212 0.13,-0.346 0.26,-0.52 0.347,-0.563 0.433,-0.346 0.909,-0.173 1.429,0.433 0.087,0.13 0.216,0.39 0.347,0.736 0,0 0.519,-0.13 1.429,-0.476 0.086,-0.043 0.173,-0.216 0.216,-0.476 h 0.13 c 0.086,0.043 0.26,0.173 0.606,0.303 0.259,0.13 0.389,0.26 0.433,0.39 l 0.13,0.043 c 0.173,-0.043 0.477,-0.563 0.866,-1.516 l 0.129,0.043 0.52,0.52 c 0.129,0.13 0.346,0.086 0.606,-0.086 0.303,-0.217 0.52,-0.303 0.693,-0.173 0.13,0.087 0.303,0.39 0.563,0.823 0.173,0.476 0.347,0.693 0.477,0.736 0.216,-0.043 0.39,-0.173 0.563,-0.346 0.173,-0.216 0.303,-0.347 0.39,-0.347 0.476,0.173 0.866,0.087 1.125,-0.303 0.303,-0.39 0.52,-0.606 0.693,-0.606 0.043,0 0.173,0.173 0.303,0.433 0.129,0.043 0.346,0.043 0.649,-0.043 0.086,-0.043 0.173,-0.216 0.26,-0.433 0.086,-0.173 0.216,-0.26 0.476,-0.303 l 0.173,0.043 c 0.13,0.13 0.303,0.433 0.476,0.909 l 0.39,0.086 0.217,-0.086 c 0.13,-0.26 0.173,-0.563 0.173,-0.823 -0.043,-0.39 -0.043,-0.649 0,-0.823 0.303,-0.476 0.477,-0.779 0.563,-0.953 l 0.433,-0.909 c 0.086,-0.173 0.303,-0.26 0.649,-0.303 0.216,-0.217 0.476,-0.606 0.823,-1.126 0.433,-0.086 0.736,-0.433 1.039,-0.996 0.086,-0.13 0.303,-0.217 0.649,-0.347 0.26,-0.086 0.476,-0.259 0.606,-0.433 0.043,-0.087 0.13,-0.26 0.303,-0.606 l 0.26,-0.606 c 0.26,-0.563 0.433,-0.909 0.476,-0.996 0.13,-0.086 0.477,-0.26 1.039,-0.39 0.303,-0.086 0.39,-0.606 0.217,-1.515 -0.087,-0.13 -0.217,-0.216 -0.347,-0.216 -0.26,-0.043 -0.39,-0.043 -0.433,-0.087 -0.087,-0.086 -0.13,-0.26 -0.13,-0.563 -0.043,-0.303 0,-0.52 0.043,-0.606 0.13,-0.173 0.303,-0.346 0.563,-0.433 0.13,-0.476 0.39,-1.125 0.823,-1.905 0.043,-0.173 0.043,-0.303 -0.043,-0.52 -0.13,-0.217 -0.173,-0.347 -0.173,-0.39 0,-0.173 0.217,-0.477 0.52,-0.953 0.086,-0.173 0.216,-0.823 0.346,-1.948 0,-0.043 -0.173,-0.217 -0.52,-0.563 0,-0.216 0.086,-0.477 0.26,-0.779 0.216,-0.347 0.303,-0.606 0.346,-0.779 -0.39,-0.217 -0.606,-0.433 -0.692,-0.563 0.26,-0.303 0.433,-0.563 0.563,-0.736 l 0.216,-0.65 c 0.087,-0.303 0.39,-0.433 0.866,-0.433 0.52,-0.043 0.866,-0.087 0.909,-0.13 0.043,0 0.217,-0.173 0.433,-0.39 0.996,-0.866 1.775,-1.299 2.338,-1.299 0.26,-0.043 0.693,0 1.255,0 0.13,0 0.347,-0.087 0.649,-0.217 0.043,0 0.13,-0.043 0.217,-0.043 -0.173,-0.692 -0.26,-1.039 -0.26,-1.082 0.563,-1.169 0.736,-1.905 0.606,-2.165 -0.043,-0.086 -0.13,-0.13 -0.26,-0.173 -0.303,0 -0.476,-0.043 -0.606,-0.043 -0.433,-0.217 -0.779,-0.346 -0.996,-0.39 -0.433,0.173 -0.736,0.26 -0.952,0.26 -0.779,-0.26 -1.299,-0.26 -1.559,0.043 -0.173,0.173 -0.347,0.65 -0.433,1.299 -0.087,0.563 -0.26,0.822 -0.563,0.822 -0.433,-0.13 -0.736,-0.216 -0.909,-0.26 -0.476,0 -0.779,-0.043 -0.996,-0.086 -0.433,-0.043 -0.866,-0.26 -1.212,-0.563 -0.303,-0.476 -0.52,-0.779 -0.736,-0.909 -0.303,-0.086 -0.52,-0.13 -0.563,-0.13 -0.087,0 -0.26,0.13 -0.563,0.346 -0.26,0.173 -0.563,0.173 -0.953,0 -0.173,-0.086 -0.433,-0.303 -0.823,-0.649 l -1.602,-1.732 c -0.39,-0.52 -0.692,-0.909 -0.866,-1.169 -0.216,-0.346 -0.346,-0.563 -0.477,-0.736 -0.692,-0.779 -1.212,-1.429 -1.515,-1.948 -0.173,-0.303 -0.606,-0.433 -1.342,-0.39 -0.606,0.043 -0.909,-0.173 -0.953,-0.606 0,-0.26 0,-0.39 -0.043,-0.476 l -0.086,-0.087 c -0.477,0.13 -0.78,0.043 -0.953,-0.173 -0.043,-0.477 -0.13,-0.779 -0.217,-0.909 -0.39,-0.303 -0.606,-0.563 -0.692,-0.779 0.13,-0.303 0.173,-0.52 0.13,-0.649 -0.477,-0.13 -0.736,-0.26 -0.866,-0.477 0,-0.563 0,-0.952 -0.043,-1.255 -0.087,-0.563 -0.433,-0.693 -1.039,-0.347 -0.26,-0.086 -0.303,-0.346 -0.217,-0.779 0.086,-0.303 -0.086,-0.563 -0.39,-0.736 v 1.688 l -0.563,0.216 0.346,0.606 -0.303,0.433 0.346,0.39 0.173,0.346 -1.775,0.476 -1.342,-2.554 c 0.043,-0.52 -0.043,-0.779 -0.173,-0.779 -0.52,0 -0.693,-0.13 -0.52,-0.433 0.13,-0.26 0.13,-0.52 0.043,-0.736 -0.173,-0.433 -0.433,-0.606 -0.78,-0.563 -0.043,0 -0.216,-0.13 -0.563,-0.347 -0.087,-0.043 -0.13,-0.13 -0.13,-0.303 0,-0.087 0.043,-0.173 0.043,-0.217 l -0.086,-0.303 -1.212,0.26 -0.13,-0.606 0.39,-0.692 -1.342,-1.429 -0.259,0.173 -0.39,-0.303 0.13,-0.303 -0.606,-1.126 -0.433,-0.043 -0.303,-0.303 -1.819,0.26 -0.303,0.346 c 0.13,0.26 0.13,0.39 -0.043,0.433 l -0.736,-0.086 0.347,-1.472 0.086,-0.693 0.433,-0.693 c 0.13,-0.043 0.173,-0.173 0.086,-0.346 -0.216,-0.476 -0.216,-0.736 0,-0.823 0.39,-0.173 0.649,-0.476 0.866,-0.909 0.173,-0.303 0.303,-0.433 0.433,-0.433 0.173,0 0.389,0.13 0.649,0.433 l 0.216,-0.13 -0.13,-0.52 0.216,-0.303 -1.039,-1.342 5.672,0.477 c 0.087,-0.173 0.216,-0.39 0.39,-0.563 0.216,-0.346 0.347,-0.649 0.303,-0.866 -0.13,0 -0.216,0 -0.303,-0.043 -0.043,-0.173 -0.216,-0.346 -0.476,-0.39 -0.39,-0.173 -0.606,-0.216 -0.606,-0.26 -0.173,-0.606 -0.476,-0.953 -0.823,-1.039 -0.173,-0.217 -0.216,-0.347 -0.26,-0.347 -0.259,-0.13 -0.476,-0.26 -0.563,-0.303 -0.303,-0.217 -0.52,-0.52 -0.649,-0.953 -0.087,-0.217 -0.087,-0.52 0,-0.909 0,-0.217 -0.13,-0.606 -0.433,-1.169 -0.216,-0.52 -0.303,-0.909 -0.26,-1.212 0.26,-0.303 0.347,-0.52 0.303,-0.736 -0.087,-0.346 -0.13,-0.563 -0.087,-0.606 0.087,-0.909 0.303,-1.646 0.606,-2.165 0.043,-0.173 0.173,-0.39 0.39,-0.736 0.13,-0.26 0.216,-0.649 0.346,-1.212 0.043,-0.13 0.13,-0.26 0.346,-0.476 0,-0.173 -0.043,-0.563 -0.216,-1.039 l 0.347,0.043 c 0.303,-0.173 0.216,-0.866 -0.26,-1.992 0,-0.043 0.043,-0.173 0.173,-0.346 0.087,-0.173 0.13,-0.26 0.043,-0.39 -0.13,-0.13 -0.26,-0.216 -0.433,-0.26 -0.086,-0.086 -0.173,-0.346 -0.13,-0.779 -0.043,-0.433 -0.086,-0.736 -0.216,-0.909 -0.13,-0.26 -0.347,-0.39 -0.693,-0.39 -0.476,0.043 -0.779,0.043 -0.779,0 -0.26,-0.173 -0.433,-0.303 -0.52,-0.347 -0.649,-0.303 -1.299,-0.26 -1.862,0.173 -0.736,-0.043 -1.125,-0.216 -1.169,-0.476 0,-0.13 0.043,-0.217 0.086,-0.26 l 0.13,-0.087 c 0.606,0.043 1.039,-0.086 1.256,-0.303 0.303,-0.303 0.476,-0.477 0.52,-0.477 0.086,0 0.303,0.13 0.736,0.346 0.347,0.173 0.563,0.26 0.693,0.173 0.086,-0.043 0.13,-0.13 0.173,-0.303 -0.26,-0.347 -0.303,-0.649 -0.217,-0.823 0,0 0.217,0 0.736,0.086 0.39,0.043 0.693,0 0.822,-0.173 l 0.043,-0.13 c -0.086,-0.13 -0.216,-0.303 -0.346,-0.476 v -0.173 c 0.13,-0.086 0.216,-0.39 0.26,-0.952 0.043,-0.043 0.13,-0.13 0.26,-0.13 l 1.169,-0.173 c 0.086,0.043 0.26,0.043 0.433,0.086 l 0.173,-0.043 0.086,-0.129 c 0,-0.173 0,-0.433 0.043,-0.91 -0.043,-0.086 -0.173,-0.216 -0.476,-0.346 -0.26,-0.13 -0.476,-0.26 -0.52,-0.39 -0.087,-0.173 0,-0.433 0.216,-0.866 0.043,-0.043 0.217,-0.043 0.433,-0.043 0.13,-0.086 0.217,-0.39 0.173,-0.866 0.13,-0.26 0.346,-0.476 0.649,-0.649 0.173,-0.13 0.303,-0.173 0.433,-0.216 -0.043,-0.13 -0.087,-0.26 -0.13,-0.303 0.043,-0.216 0.259,-0.303 0.563,-0.216 0.39,0.043 0.649,0 0.779,-0.216 v -0.173 c -0.13,-0.173 -0.216,-0.476 -0.26,-0.823 -0.216,-0.26 -0.433,-0.433 -0.563,-0.476 -0.736,0.043 -1.256,0 -1.516,-0.216 -0.043,-0.087 -0.13,-0.303 -0.13,-0.606 -0.086,-0.303 -0.216,-0.52 -0.433,-0.606 -0.173,-0.087 -0.433,-0.13 -0.736,-0.087 -0.39,0.043 -0.649,0.043 -0.779,0 -0.216,-0.043 -0.433,-0.13 -0.606,-0.26 -0.347,-0.26 -0.866,-0.866 -1.602,-1.775 0.043,-0.087 0.173,-0.217 0.433,-0.433 0.011,-0.042 0.054,-0.431 0.054,-1.081",
                        "Kiev City": "m 266.751,110.951 0.26,-0.216 0.692,0.13 0.173,0.433 -0.52,0.476 -0.39,-0.26 -0.215,-0.563 m 5.759,-3.766 -5.672,-0.477 1.039,1.342 -0.216,0.303 0.13,0.52 -0.216,0.13 c -0.26,-0.303 -0.477,-0.433 -0.649,-0.433 -0.13,0 -0.26,0.13 -0.433,0.433 -0.217,0.433 -0.477,0.736 -0.866,0.909 -0.216,0.086 -0.216,0.347 0,0.823 0.087,0.173 0.043,0.303 -0.086,0.346 l -0.433,0.693 -0.086,0.693 -0.347,1.472 0.736,0.086 c 0.173,-0.043 0.173,-0.173 0.043,-0.433 l 0.303,-0.346 1.819,-0.26 0.303,0.303 0.433,0.043 0.606,1.126 -0.13,0.303 0.39,0.303 0.259,-0.173 1.342,1.429 -0.39,0.692 0.13,0.606 1.212,-0.26 0.086,0.303 c 0,0.043 -0.043,0.13 -0.043,0.217 0,0.173 0.043,0.26 0.13,0.303 0.346,0.217 0.52,0.347 0.563,0.347 0.347,-0.043 0.606,0.13 0.78,0.563 0.086,0.217 0.086,0.477 -0.043,0.736 -0.173,0.303 0,0.433 0.52,0.433 0.13,0 0.216,0.26 0.173,0.779 l 1.342,2.554 1.775,-0.476 -0.173,-0.346 -0.346,-0.39 0.303,-0.433 -0.346,-0.606 0.563,-0.216 v -1.688 m 1.556,-11.951 0.087,0.217 -6.148,-0.52 c -0.043,0.13 -0.086,0.26 -0.086,0.39 0,0.173 0.13,0.39 0.39,0.52 0.346,0.173 0.52,0.303 0.563,0.433 0.043,0.173 0.043,0.39 -0.087,0.692 -0.13,0.347 -0.216,0.606 -0.216,0.693 0.26,0.606 0.39,1.039 0.433,1.299 0,0.39 0,0.606 0.043,0.606 0.347,0.216 0.563,0.39 0.693,0.476 0.086,0.086 0.173,0.303 0.303,0.693 0.26,0.649 0.346,1.212 0.346,1.688 -0.043,0.39 -0.043,0.736 -0.043,0.953 -0.043,0.346 0.043,0.649 0.173,0.909 0.996,1.125 1.559,1.818 1.688,2.165 0.086,0.129 0.086,0.346 0.13,0.606 0.043,0.043 0.087,0.086 0.173,0.13 l -0.043,-0.693 c 0,-0.13 -0.13,-0.346 -0.347,-0.649 -0.043,-0.043 -0.13,-0.173 -0.303,-0.39 l -0.346,-0.476 1.255,-0.217 0.303,0.347 0.346,-0.087 0.52,0.39 1.125,-0.39 -0.043,-0.952 h 0.433 l 0.173,0.476 c 0.086,0.13 0.216,0.13 0.476,0.043 0.087,-0.087 0.13,-0.26 0.043,-0.606 l 0.563,-0.736 0.13,-0.433 h 0.519 l 0.347,-0.216 -0.433,-0.606 0.173,-0.303 -0.736,-0.78 -0.952,-0.303 -0.087,-1.559 -0.433,-0.217 0.043,-0.649 0.477,-0.39 v -0.52 l 0.433,-0.216 0.259,0.26 1.212,-0.779 -0.043,-0.606 -0.996,-0.866 -0.563,0.043 c -0.433,-0.303 -0.779,-0.563 -0.996,-0.779 -0.173,-0.173 -0.476,-0.043 -0.909,0.477 -0.085,0.086 -0.085,0.259 -0.042,0.432",
                        "Khmelnytskyi": "m 146.75,125.21874 -0.3125,0.78125 -0.21875,-0.5 c -0.347,0.043 -0.62775,0.159 -0.84375,0.375 l 0,0.0937 c 0.823,0.173 1.35325,0.3465 1.65625,0.5625 0.261,0.173 0.42575,0.43525 0.46875,0.78125 0.087,0.347 -0.0915,0.6005 -0.4375,0.6875 -0.26,0.087 -0.73275,0.125 -1.46875,0.125 -0.174,0 -0.25,0.14625 -0.25,0.40625 0.13,0.26 0.4175,0.56025 0.9375,0.90625 0,0.087 -0.039,0.22825 -0.125,0.53125 -0.13,0.346 -0.29575,0.55075 -0.46875,0.59375 -0.303,0.087 -0.50775,0.202 -0.59375,0.375 -0.044,0.131 -0.0557,0.245 0.0312,0.375 0.216,0.13 0.47825,0.207 0.78125,0.25 0.26,0 0.44525,0.039 0.53125,0.125 0,0.043 -0.0195,0.2205 -0.0625,0.4375 -0.086,0.26 -0.15125,0.42575 -0.28125,0.46875 -0.129,0.043 -0.30925,0.1005 -0.65625,0.1875 -0.953,0.303 -1.4755,0.54075 -1.5625,0.84375 l -0.12495,0.37505 c 0,0.043 0.12775,0.273 0.34375,0.75 0.174,0.433 0.26175,0.74 0.21875,1 0,0.043 -0.10825,0.2595 -0.28125,0.5625 -0.129,0.259 -0.1495,0.48325 -0.0625,0.65625 0.043,0.217 0.2595,0.40125 0.5625,0.53125 0.303,0.173 0.46375,0.43525 0.59375,0.78125 0.043,0.217 -0.003,0.63225 -0.21875,1.28125 -0.13,0.519 -0.0335,0.91575 0.3125,1.21875 l 0.6875,0.53125 c 0.26,0.216 0.3945,0.63225 0.4375,1.28125 0,0.823 0.0118,1.27625 -0.0312,1.40625 l -0.53125,0.5 c -0.044,0 -0.12,0.14625 -0.25,0.40625 -0.1735,0.2815 -0.214,0.5665 -0.0625,0.875 0.1515,0.3085 0.49225,0.62225 0.96875,0.96875 0.346,0.303 0.51175,0.572 0.46875,0.875 -0.043,0.346 -0.1775,0.5965 -0.4375,0.8125 -0.303,0.216 -0.5195,0.49 -0.5625,0.75 -0.043,0 -0.1015,0.45825 -0.1875,1.28125 -0.087,0.649 -0.202,0.995 -0.375,1.125 -0.086,0.086 -0.31025,0.202 -0.65625,0.375 l -0.1563,0.0312 c -0.13,0.13 -0.35825,0.43025 -0.53125,0.90625 -0.26,0.563 -0.336,0.99 -0.25,1.25 0,0.13 0.2165,0.5385 0.5625,1.1875 0.26,0.476 0.4705,1.28125 0.6875,2.40625 0,0.173 0.20375,0.39625 0.59375,0.65625 0.346,0.216 0.582,0.42075 0.625,0.59375 0.043,0.216 0.005,0.51625 -0.125,0.90625 0.044,0.303 0.159,0.80025 0.375,1.40625 0,0.043 -0.1015,0.26625 -0.1875,0.65625 -0.13,0.259 -0.13,0.452 0,0.625 0.173,0.26 0.447,0.61 0.75,1 0.13,0.347 0.0462,0.66575 -0.34375,0.96875 -0.044,0.13 -0.0118,0.29075 0.0312,0.59375 0.086,0.217 0.086,0.40125 0,0.53125 -0.044,0.087 -0.20875,0.164 -0.46875,0.25 -0.346,0.13 -0.58875,0.31525 -0.71875,0.53125 -0.087,0.043 -0.0937,0.235 -0.0937,0.625 0,0.39 -0.10825,0.976 -0.28125,1.625 0.043,0.26 0.18925,0.4715 0.40625,0.6875 0.26,0.217 0.3945,0.40125 0.4375,0.53125 0,0.087 -0.0575,0.25175 -0.1875,0.46875 -0.173,0.26 -0.21875,0.5865 -0.21875,1.0625 0,0.087 0.12675,0.398 0.34375,0.875 0.26,0.476 0.38675,0.865 0.34375,1.125 -0.173,0.304 -0.51625,0.66575 -0.90625,0.96875 -0.26,0.303 -0.20925,0.7105 0.0937,1.1875 0.304,0.562 0.48825,0.95875 0.53125,1.21875 l -0.0937,0.125 c -0.346,-0.087 -0.62,-0.087 -0.75,0 l -0.0625,0.125 c 0,0.043 0.077,0.2215 0.25,0.4375 0.173,0.217 0.2305,0.40125 0.1875,0.53125 l -0.0937,0.125 -0.4375,0.125 c -0.086,0.043 -0.1445,0.15225 -0.1875,0.28125 0.044,0.043 0.14625,0.19025 0.40625,0.40625 0.173,0.216 0.26175,0.408 0.21875,0.625 0,0.087 -0.10825,0.32875 -0.28125,0.71875 -0.129,0.346 -0.1485,0.58875 -0.0625,0.71875 l 0.125,0.0312 0.5625,-0.25 0.15625,0.0625 0.0625,0.15625 c 0,0.173 -0.0575,0.47325 -0.1875,0.90625 -0.043,0.087 -0.082,0.6095 -0.125,1.5625 -0.043,0.129 0.0838,0.279 0.34375,0.625 0.043,0.044 0.082,0.15125 0.125,0.28125 0.13,0.13 0.4565,0.29575 1.0625,0.46875 l 0.0312,0.125 0,0.1875 c -0.131,0.13 -0.3795,0.212 -0.8125,0.125 0,0.087 -0.0118,0.24 0.0312,0.5 -0.389,0.433 -0.467,0.75275 -0.25,0.96875 0.432,0.433 0.6445,0.67575 0.6875,0.71875 0,0.173 -0.12775,0.404 -0.34375,0.75 0.043,0.78 0.043,1.2645 0,1.4375 -0.043,0.129 -0.13275,0.33375 -0.21875,0.59375 -0.0435,0.433 0.043,0.73738 0.28125,0.9375 0.23825,0.20012 0.63675,0.30275 1.15625,0.28125 l 0.0625,0.0937 0,0.15625 c -0.13,0.173 -0.21875,0.3845 -0.21875,0.6875 0.044,0.086 0.1015,0.17575 0.1875,0.21875 0.303,0.13 0.5525,-0.0475 0.8125,-0.4375 l 0.15625,-0.0312 c 0.043,0.087 0.043,0.21375 0,0.34375 -0.043,0.519 -0.24,1.0045 -0.5,1.4375 0.087,0.302 0.5765,0.5525 1.3125,0.8125 0.087,0.26 0.399,0.4765 0.875,0.5625 l 0.0312,0.1875 -0.0312,0.125 c -0.087,0.086 -0.1825,0.0937 -0.3125,0.0937 l -0.1875,-0.0625 -0.21875,0.1875 0,0.125 c 0.26,0.303 0.4375,0.68025 0.4375,1.15625 0.346,0.303 0.539,0.538 0.625,0.625 0.216,-0.173 0.409,-0.25 0.625,-0.25 l 0.71875,0 c 0.433,-0.217 0.77125,-0.3125 1.03125,-0.3125 0.303,0.043 0.69875,0.30525 1.21875,0.78125 0.39,0.476 0.6825,0.87275 0.8125,1.21875 0.347,0.866 0.6335,1.409 0.9375,1.625 0.217,0.217 0.567,0.26175 1,0.21875 0.433,-0.087 0.668,-0.29075 0.625,-0.59375 -0.043,-0.173 -0.18925,-0.53675 -0.40625,-0.96875 -0.26,-0.52 -0.25225,-0.8075 0.0937,-0.9375 0.173,-0.043 0.332,-0.043 0.375,0 0.347,0.433 0.615,0.63175 0.875,0.71875 0.043,0 0.16575,-0.0195 0.46875,-0.0625 0.26,0.043 0.4755,0.0195 0.5625,0.0625 0.173,0 0.37,-0.0263 0.5,-0.15625 0.086,-0.086 0.125,-0.17575 0.125,-0.21875 0,-0.173 -0.2545,-0.447 -0.6875,-0.75 -0.433,-0.433 -0.71375,-0.6435 -0.84375,-0.6875 -0.086,-0.043 -0.42525,-0.0312 -1.03125,-0.0312 -0.303,0 -0.42975,-0.2505 -0.34375,-0.8125 0.217,-0.347 0.5095,-0.543 0.8125,-0.5 0.477,0 0.83375,0.22825 1.09375,0.53125 0.303,0.433 0.52725,0.63175 0.65625,0.71875 0.216,0.086 0.47825,0.1105 0.78125,-0.0625 0.39,-0.303 0.53625,-0.62275 0.40625,-0.96875 -0.043,-0.087 -0.28575,-0.42525 -0.71875,-1.03125 -0.086,-0.087 -0.0743,-0.27125 -0.0312,-0.53125 l 0.0625,-0.0625 0.34375,0 c 0.39,0.173 0.63175,0.5425 0.71875,1.0625 0.086,0.606 0.11325,0.92475 0.15625,0.96875 0.433,0.086 0.7265,-0.2835 0.8125,-1.0625 -0.216,-0.866 -0.1195,-1.4275 0.3125,-1.6875 0.433,-0.13 0.73325,0.005 0.90625,0.4375 0,0.086 -0.038,0.322 -0.125,0.625 -0.13,0.26 -0.168,0.4325 -0.125,0.5625 0.39,0.736 0.72725,1.21375 1.03125,1.34375 0.736,0.39 1.2985,0.24375 1.6875,-0.40625 0.303,-0.649 0.5965,-1.06525 0.8125,-1.28125 0.173,-0.043 0.3895,-0.043 0.5625,0 0.173,0.086 0.37,0.0625 0.5,0.0625 0.217,-0.173 0.37,-0.25 0.5,-0.25 0.086,0 0.21375,0.115 0.34375,0.375 0.13,0.26 0.27625,0.456 0.40625,0.5 0.13,0.086 0.33375,0.0743 0.59375,0.0312 0.303,-0.086 0.496,-0.125 0.625,-0.125 0.216,0.13 0.3945,0.17475 0.4375,0.21875 0.563,0.043 0.947,0.0937 1.25,0.0937 0.26,0 0.50275,-0.18425 0.71875,-0.53125 0.26,-0.39 0.491,-0.59375 0.75,-0.59375 0.173,-0.043 0.4655,0.0838 0.8125,0.34375 0.216,0.13 0.4665,0.245 0.8125,0.375 0.217,0.086 0.3895,0.13775 0.5625,0.0937 0.303,-0.13 0.52725,-0.2645 0.65625,-0.4375 0.26,-0.779 0.0358,-1.17575 -0.65625,-1.21875 -0.216,-0.173 -0.255,-0.327 -0.125,-0.5 0.217,-0.217 0.491,-0.36325 0.75,-0.40625 0.433,-0.043 0.84825,0.23 1.28125,0.75 0.39,0.433 0.80525,0.471 1.28125,0.125 0.086,-0.26 0.163,-0.46375 0.25,-0.59375 0.086,-0.26 0.25275,-0.3945 0.46875,-0.4375 0.043,-0.346 0.16475,-0.83825 0.46875,-1.53125 0.26,-0.649 0.40625,-1.11 0.40625,-1.5 0,-0.866 -0.0118,-1.38275 0.0312,-1.46875 0.086,-0.216 0.0937,-0.375 0.0937,-0.375 l -0.0937,-0.28125 -0.15625,-1 0.0937,-0.0937 c 0.13,-0.086 0.3415,-0.0352 0.6875,0.0937 0.086,0 0.163,-0.0507 0.25,-0.0937 0,-0.173 0.005,-0.326 -0.125,-0.5 -0.173,-0.26 -0.25,-0.414 -0.25,-0.5 l -0.28125,-0.71875 c -0.303,-0.996 -0.41125,-1.7935 -0.28125,-2.3125 l 0.125,-0.5625 c 0,-0.043 -0.1345,-0.6055 -0.4375,-1.6875 -0.217,-0.39 -0.3515,-0.69025 -0.4375,-0.90625 -0.043,-0.043 -0.043,-0.16975 0,-0.34375 0,-0.173 0.038,-0.25 0.125,-0.25 l 0.5625,-0.28125 c 0.303,-0.173 0.16175,-0.62625 -0.53125,-1.40625 -0.043,-0.043 -0.087,-0.20875 0,-0.46875 0.346,-0.433 0.4805,-0.85325 0.4375,-1.15625 0.043,-0.173 0.1395,-0.25 0.3125,-0.25 0.433,-0.346 0.745,-0.56525 0.875,-0.78125 0.129,-0.433 0.207,-0.77625 0.25,-0.90625 0.087,-0.303 0.399,-0.4805 0.875,-0.4375 l 0.125,-0.0625 0,-0.1875 c -0.13,-0.303 -0.168,-0.52725 -0.125,-0.65625 l 0.375,-0.46875 c 0.043,-0.433 0.0888,-0.7205 0.21875,-0.9375 0,-0.043 0.0497,-0.11225 0.0937,-0.15625 l 0.0312,-0.0312 c 0.26,0 0.61675,0.0118 1.09375,-0.0312 0.303,0.043 0.7065,0.13275 1.3125,0.21875 0.173,-0.13 0.33775,-0.39225 0.46875,-0.78125 0.173,-0.477 0.288,-0.745 0.375,-0.875 0.13,-0.13 0.56475,-0.053 1.34375,0.25 0.216,0.043 0.51625,0.279 0.90625,0.625 0.216,0.086 0.5865,0.163 1.0625,0.25 0.13,0.043 0.3455,0.20875 0.5625,0.46875 0.26,0.13 0.45975,0.2695 0.71875,0.3125 0.303,0.043 0.534,-0.0145 0.75,-0.1875 0.043,-0.086 0.2205,-0.2985 0.4375,-0.6875 l 0.34375,-0.25 c 0.476,-0.259 1.1145,-0.34375 1.9375,-0.34375 0.086,0 0.21375,-0.10725 0.34375,-0.28125 0.043,-0.043 -0.0457,-0.38225 -0.21875,-1.03125 0.086,-0.649 0.0362,-1.072 -0.0937,-1.375 -0.39,-0.476 -0.6445,-0.9225 -0.6875,-1.3125 -0.043,-0.086 -0.043,-0.15125 0,-0.28125 0.043,-0.217 0.2155,-0.49775 0.5625,-0.84375 0.217,-0.26 0.16525,-0.5475 -0.0937,-0.9375 l -0.0625,-0.0937 c -0.347,-0.39 -0.5,-0.663 -0.5,-0.75 0.043,-0.39 0.0497,-0.6395 0.0937,-0.8125 0,-0.303 -0.115,-0.5195 -0.375,-0.5625 l -0.4375,-0.0937 -0.25,-0.125 c 0,-0.433 -0.0693,-0.745 -0.15625,-0.875 l -0.25,-0.46875 c -0.39,-0.52 0.038,-0.8455 1.25,-1.0625 0.043,-0.13 -0.0457,-0.399 -0.21875,-0.875 -0.173,-0.433 -0.288,-0.6875 -0.375,-0.6875 -1.04,0.13 -1.78575,0.0665 -2.21875,-0.0625 -0.26,-0.13 -0.42475,-0.283 -0.46875,-0.5 -0.043,-0.303 0.033,-0.52725 0.25,-0.65625 0.346,-0.173 0.582,-0.31925 0.625,-0.40625 l 0,-0.125 c -0.953,-0.779 -1.40625,-1.1445 -1.40625,-1.1875 0.043,-0.39 0.1005,-0.658 0.1875,-0.875 0.043,-0.347 0.20875,-0.53125 0.46875,-0.53125 0.173,-0.043 0.31925,-0.043 0.40625,0 0.26,0.346 0.5095,0.386 0.8125,0.125 0.216,-0.303 0.30575,-0.5535 0.21875,-0.8125 -0.173,-0.26 -0.3855,-0.534 -0.6875,-0.75 l -0.0625,-0.15625 c 0.216,-0.26 0.36225,-0.44425 0.40625,-0.53125 0.173,-0.26 0.43525,-0.72 0.78125,-1.5 0.26,-0.563 0.375,-0.909 0.375,-1.125 -0.043,-0.26 -0.2545,-0.55925 -0.6875,-0.90625 -0.649,-0.303 -1.115,-0.52225 -1.375,-0.78125 -0.043,-0.13 0.0457,-0.39225 0.21875,-0.78125 0.173,-0.346 0.27625,-0.57025 0.40625,-0.65625 0.216,0 0.606,0.0888 1.125,0.21875 0.563,-0.26 0.9315,-0.59825 1.0625,-1.03125 -0.043,-0.043 -0.394,-0.2975 -1,-0.6875 0.043,-0.13 0.2925,-0.15625 0.8125,-0.15625 0.433,0.043 0.707,0.0118 0.75,-0.0312 0.043,-0.086 0.11325,-0.36 0.15625,-0.75 -0.13,-0.043 -0.4565,-0.1005 -1.0625,-0.1875 -0.693,-0.303 -1.22825,-0.52725 -1.53125,-0.65625 -0.13,-0.043 -0.71775,-0.18925 -1.84375,-0.40625 l -0.53125,-0.125 c -0.043,-0.043 -0.20875,-0.0312 -0.46875,-0.0312 -0.173,0.043 -0.3895,-0.0457 -0.5625,-0.21875 l -0.0937,-0.0625 c -0.173,-0.26 -0.36225,-0.54075 -0.40625,-0.84375 -0.13,-0.39 -0.23325,-0.64625 -0.40625,-0.90625 -0.692,-0.779 -1.0625,-1.3025 -1.0625,-1.5625 0.26,-0.649 0.19475,-1.038 -0.28125,-1.125 -0.563,0.043 -0.9325,-0.0195 -1.0625,-0.0625 l -0.21875,-0.21875 c -0.086,-0.086 -0.086,-0.629 0,-1.625 l 0.0937,-0.125 c 0.563,0 0.90125,-0.0693 1.03125,-0.15625 0,-0.39 -0.20475,-0.812 -0.59375,-1.375 -0.39,-0.563 -0.59375,-0.97825 -0.59375,-1.28125 0.26,0.043 0.6245,0.1015 1.1875,0.1875 0.606,0.043 1.06525,-0.0408 1.28125,-0.34375 0.216,-0.303 0.49275,-0.46875 0.96875,-0.46875 l 0.094,-0.0939 c 0.086,-0.476 0.1445,-0.77125 0.1875,-1.03125 -0.043,-0.39 -0.22825,-0.63175 -0.53125,-0.71875 -0.433,-0.13 -0.67575,-0.23825 -0.71875,-0.28125 -0.173,-0.217 -0.18475,-0.59825 0.0312,-1.03125 0.173,-0.477 0.37775,-0.73725 0.59375,-0.78125 0.087,-0.086 0.13675,-0.21375 0.0937,-0.34375 -0.39,-0.26 -0.6435,-0.44425 -0.6875,-0.53125 -0.043,-0.216 0.008,-0.37 0.0937,-0.5 l 0.5625,-0.21875 c 0.043,-0.043 0.081,-0.13175 0.125,-0.21875 0.086,-0.303 -0.0592,-0.64125 -0.40625,-1.03125 -0.39,-0.433 -0.69525,-0.71375 -0.78125,-0.84375 -0.173,-0.173 -0.2305,-0.43525 -0.1875,-0.78125 0.217,-1.212 0.1975,-1.83875 -0.0625,-1.96875 -0.13,-0.043 -0.3025,-0.0937 -0.5625,-0.0937 l -0.125,0.125 c -0.086,0.346 -0.163,0.50775 -0.25,0.59375 l -0.21875,0.1875 c -0.259,0.52 -0.40625,0.832 -0.40625,0.875 -0.129,0.043 -0.42525,-0.0195 -1.03125,-0.0625 -0.563,-0.086 -0.8935,-0.11325 -0.9375,-0.15625 0,-0.216 -0.0245,-0.51725 0.0625,-0.90625 -0.173,-0.26 -0.41575,-0.457 -0.71875,-0.5 -0.39,-0.043 -0.625,-0.0625 -0.625,-0.0625 -0.086,-0.043 -0.11325,-0.2205 -0.15625,-0.4375 0,-0.217 -0.0507,-0.3945 -0.0937,-0.4375 -0.173,-0.043 -0.33875,-0.0547 -0.46875,0.0312 -0.173,0.086 -0.25675,0.125 -0.34375,0.125 l -0.125,-0.0625 -0.15625,-0.28125 0.0625,-0.15625 c 0.26,-0.216 0.375,-0.33875 0.375,-0.46875 -0.13,-0.13 -0.283,-0.2695 -0.5,-0.3125 l -0.625,-0.46875 c -0.303,-0.26 -0.46475,-0.414 -0.59375,-0.5 -0.216,-0.13 -0.6245,-0.3025 -1.1875,-0.5625 -0.216,-0.13 -0.32025,-0.37275 -0.40625,-0.71875 -0.043,-0.39 -0.19425,-0.664 -0.28125,-0.75 -0.173,-0.13 -0.3845,-0.21875 -0.6875,-0.21875 -0.173,-0.043 -0.39725,-0.0625 -0.65625,-0.0625 -0.476,-0.086 -0.56075,-0.56475 -0.34375,-1.34375 l 0.28125,-0.96875 c 0.173,-0.606 0.41075,-1.12275 0.84375,-1.46875 l 0.0937,-0.125 c 0.563,-0.26 0.91975,-0.495 1.09375,-0.625 l -0.0937,-0.125 c -0.303,-0.087 -0.769,-0.202 -1.375,-0.375 -0.217,-0.259 -0.3505,-0.6675 -0.4375,-1.1875 -0.476,-0.043 -0.745,-0.12 -0.875,-0.25 -0.043,-0.13 -0.0937,-0.31425 -0.0937,-0.53125 -0.086,-0.173 -0.31025,-0.288 -0.65625,-0.375 -0.13,0 -0.43025,-0.0575 -0.90625,-0.1875 -0.563,-0.086 -0.80075,-0.207 -0.84375,-0.25 0,-0.087 -0.0118,-0.32975 0.0312,-0.71875 0,-0.39 -0.008,-0.63175 -0.0937,-0.71875 -0.043,-0.13 -0.2155,-0.1445 -0.5625,-0.1875 -0.303,0 -0.50775,-0.0235 -0.59375,0.0625 -0.217,0.217 -0.3945,0.562 -0.4375,1.125 -0.043,0.086 -0.317,0.21375 -0.75,0.34375 -0.563,0.173 -0.83875,0.31925 -0.96875,0.40625 -0.26,0.173 -0.4325,0.3515 -0.5625,0.4375 -0.173,0.39 -0.3465,0.58875 -0.5625,0.71875 -0.303,0.13 -0.693,0.10375 -1.125,-0.15625 -0.606,-0.347 -0.96375,-0.5195 -1.09375,-0.5625 -0.173,0.043 -0.4665,0.24775 -0.8125,0.59375 -0.173,0.13 -0.442,0.366 -0.875,0.625 -0.043,0.043 -0.34325,0.0312 -0.90625,0.0312 -0.043,0 -0.15125,0.0263 -0.28125,0.15625 -0.26,0.303 -0.32425,0.615 -0.28125,0.875 0.087,0.433 0.0937,0.73325 0.0937,0.90625 l -0.0937,0.0937 c -0.346,0.13 -0.658,0.091 -0.875,-0.125 -0.303,-0.216 -0.5145,-0.34375 -0.6875,-0.34375 -0.173,0.043 -0.3125,0.26725 -0.3125,0.65625 -0.043,0.52 -0.082,0.75675 -0.125,0.84375 -0.389,0.13 -0.61325,0.21375 -0.65625,0.34375 l -0.0937,0.96875 c 0,0.303 -0.2545,0.50775 -0.6875,0.59375 -0.52,0.13 -0.87,0.27625 -1,0.40625 -0.043,0.086 -0.043,0.25275 0,0.46875 0,0.26 -0.0263,0.4715 -0.15625,0.6875 -0.13,0.216 -0.66525,0.57375 -1.53125,1.09375 -0.173,0.13 -0.3465,0.43025 -0.5625,0.90625 -0.216,0.433 -0.37,0.69425 -0.5,0.78125 -0.173,0.13 -0.57375,0.283 -1.09375,0.5 -0.736,0.996 -1.12,1.48725 -1.25,1.53125 l -0.5625,0.0937 c -0.347,0.086 -0.5575,0.0743 -0.6875,0.0312 -0.173,-0.043 -0.485,-0.119 -0.875,-0.25 -0.693,0.347 -1.471,1.14525 -2.25,2.53125 -0.346,0.606 -0.6335,0.996 -0.9375,1.125 -0.173,0.087 -0.43525,0.13175 -0.78125,0.21875 -0.0973,0.0484 -0.38679,0.24416 -0.59375,0.375 z",
                        "Kherson": "m 382.96,301.371 c -0.13,-0.043 -0.217,-0.043 -0.303,0 -0.303,0.736 -0.476,1.212 -0.563,1.385 -0.303,0.086 -0.39,0.303 -0.39,0.693 0.043,0.433 0,0.693 -0.043,0.736 -0.39,0.13 -0.649,0.217 -0.779,0.26 -0.217,0.39 -0.26,0.779 -0.13,1.212 0.043,0.216 0.173,0.477 0.433,0.779 0.26,0.303 0.477,0.476 0.649,0.52 l 0.173,0 0.043,-0.173 c -0.086,-0.26 -0.173,-0.52 -0.217,-0.736 -0.043,-0.26 0,-0.476 0.087,-0.606 l 0.13,-0.086 0.13,0.043 c 0.216,0.086 0.303,0.39 0.26,0.823 0,0.13 -0.043,0.346 -0.13,0.563 l 0.086,0.129 c 0.26,0 0.52,-0.043 0.736,-0.173 0.043,-0.043 0.087,-0.086 0.173,-0.086 0.303,-0.26 0.433,-0.52 0.39,-0.78 0,-0.043 -0.086,-0.129 -0.26,-0.346 0.433,-1.039 0.563,-1.732 0.303,-1.992 -0.13,0 -0.26,0.217 -0.433,0.563 -0.173,0.39 -0.303,0.649 -0.39,0.736 l -0.173,0 c 0.087,-0.52 0.087,-0.866 0.043,-1.039 -0.173,-0.346 -0.26,-0.563 -0.216,-0.692 0,-0.13 0.216,-0.303 0.606,-0.52 0.131,-0.218 0.045,-0.607 -0.215,-1.213 m -40.959,5.715 c -0.086,0.043 -0.26,0.173 -0.563,0.389 -0.217,0.217 -0.606,0.347 -1.083,0.39 l -2.165,-0.216 c -1.775,-0.52 -2.771,-0.736 -2.987,-0.606 0.043,0.086 0.216,0.173 0.606,0.346 1.256,0.433 1.905,0.649 1.992,0.649 0.26,0.043 0.649,0 1.169,0 0.087,0 0.303,0 0.563,0.043 0.303,0.043 0.736,0.086 1.212,0.173 0.39,0.043 0.953,0.26 1.645,0.563 0.303,0.043 0.909,0.043 1.732,0 0.216,0 0.779,0.086 1.646,0.26 0.649,0.13 1.212,0.173 1.688,0.13 0.26,-0.043 0.476,-0.173 0.649,-0.39 0.173,-0.216 0.13,-0.433 -0.086,-0.606 -0.217,-0.13 -0.39,-0.173 -0.606,-0.086 -0.39,0.086 -0.563,0.173 -0.563,0.173 -0.173,0 -0.303,-0.043 -0.477,-0.13 -0.173,-0.173 -0.303,-0.26 -0.346,-0.26 -0.043,-0.13 -0.13,-0.216 -0.26,-0.303 -0.26,-0.173 -0.606,-0.173 -1.083,0.087 -0.52,0.216 -0.823,0.26 -0.953,0.216 l -0.216,-0.173 c -0.26,-0.303 -0.39,-0.477 -0.433,-0.477 -0.086,-0.086 -0.303,-0.13 -0.649,-0.13 -0.215,-0.042 -0.389,-0.042 -0.432,-0.042 m 65.032,-15.76 c 0,-0.217 -0.043,-0.39 -0.043,-0.476 -0.217,-1.126 -0.347,-1.775 -0.39,-1.949 -0.087,-0.043 -0.52,-0.086 -1.299,-0.086 -0.26,-0.217 -0.477,-0.39 -0.606,-0.433 -0.346,0 -0.606,-0.086 -0.823,-0.26 -0.216,-0.39 -0.433,-0.606 -0.52,-0.649 -0.13,-0.086 -0.433,-0.043 -0.953,0.043 -0.563,0.086 -0.909,0.13 -1.082,0.043 -0.043,-0.086 -0.086,-0.26 -0.086,-0.476 0,-0.26 0,-0.433 0.043,-0.476 0.303,-0.173 0.476,-0.433 0.52,-0.736 l -0.087,-0.13 c -0.086,-0.086 -0.433,-0.173 -1.039,-0.216 -0.606,-0.043 -0.996,-0.043 -1.168,0 -0.563,0.043 -0.866,0.043 -0.91,0 -0.086,-0.39 -0.216,-0.649 -0.303,-0.823 -0.13,-0.216 -0.217,-0.39 -0.26,-0.52 -0.259,-0.217 -0.519,-0.606 -0.649,-1.083 -0.086,-0.216 0,-0.39 0.173,-0.649 0.303,-0.346 0.433,-0.52 0.433,-0.563 0.13,-0.303 0.086,-0.822 -0.216,-1.559 -0.043,-0.216 -0.173,-0.346 -0.39,-0.346 -0.866,-0.13 -1.299,-0.216 -1.342,-0.26 -0.13,-0.303 -0.216,-0.477 -0.303,-0.52 l -0.173,0 c -0.303,0.26 -0.606,0.346 -0.822,0.173 -0.13,-0.13 -0.173,-0.563 -0.173,-1.256 0.13,-0.303 0.39,-0.433 0.736,-0.433 0.52,0 0.866,0 0.953,-0.043 0.086,-0.043 0.217,-0.26 0.39,-0.649 0.13,-0.173 0.346,-0.26 0.606,-0.347 0.173,-0.216 0.303,-0.52 0.389,-0.996 0.303,-0.39 0.433,-0.649 0.433,-0.693 -0.086,-0.606 -0.086,-1.039 0.043,-1.342 0,0 0.173,-0.086 0.52,-0.216 0.043,0 0.39,-0.173 0.996,-0.477 0.043,-0.173 0.043,-0.476 -0.086,-0.996 -0.086,-0.606 -0.346,-0.909 -0.649,-0.953 -0.39,0 -0.606,0 -0.693,-0.086 -0.26,-0.173 -0.433,-0.909 -0.606,-2.122 -0.173,-0.216 -0.779,-0.433 -1.775,-0.779 -0.087,0 -0.303,-0.173 -0.563,-0.433 -0.216,-0.173 -0.606,-0.303 -1.212,-0.346 -0.13,-0.087 -0.173,-0.39 -0.217,-0.909 0,-0.563 -0.173,-0.91 -0.433,-1.04 -0.303,0 -0.52,0 -0.649,-0.043 -0.173,-0.217 -0.26,-0.563 -0.217,-1.083 0,-0.606 0,-0.996 -0.043,-1.169 l -0.087,-0.606 c -0.13,-0.39 -0.216,-0.693 -0.26,-0.866 l -0.13,-0.736 -0.086,-0.13 -0.866,-0.26 -0.087,-0.13 c -0.043,-0.26 -0.043,-0.476 -0.043,-0.606 -0.129,-0.433 -0.173,-0.736 -0.216,-0.909 0.13,-0.779 0.13,-1.386 0.13,-1.775 -0.043,-0.129 -0.086,-0.216 -0.086,-0.303 l -0.217,-1.04 c -0.043,-0.216 0.043,-0.433 0.217,-0.563 0.216,-0.173 0.303,-0.346 0.303,-0.52 0,-0.26 -0.217,-0.476 -0.649,-0.736 -0.39,-0.26 -0.477,-0.736 -0.217,-1.559 0,-0.086 0.173,-0.173 0.476,-0.303 0.26,-0.086 0.433,-0.216 0.477,-0.303 l -0.043,-0.173 c -0.173,-0.173 -0.303,-0.26 -0.39,-0.26 l -1.732,0.173 c -0.173,0 -0.433,0.086 -0.693,0.216 -0.043,0.433 -0.086,0.649 -0.13,0.736 -0.26,0.303 -0.39,0.563 -0.39,0.692 0,0.043 -0.086,0.087 -0.173,0.13 -0.26,0.086 -0.606,0 -1.083,-0.346 -0.216,0.043 -0.39,0.086 -0.433,0.043 -0.433,0.476 -0.823,0.649 -1.212,0.52 -0.086,-0.087 -0.13,-0.173 -0.13,-0.26 l -0.043,-0.866 c -0.173,-0.476 -0.303,-0.822 -0.39,-1.083 -0.13,-0.52 -0.217,-0.909 -0.303,-1.125 -0.346,-1.039 -0.563,-1.602 -0.563,-1.688 -0.173,-0.606 -0.303,-1.126 -0.433,-1.646 -0.433,0.217 -0.866,0.303 -1.386,0.39 -0.433,0.043 -0.779,0 -0.996,-0.086 -0.173,-0.173 -0.347,-0.217 -0.433,-0.26 -0.52,0.086 -0.866,0.173 -1.039,0.216 -0.52,-0.043 -0.909,-0.086 -1.169,-0.086 -0.433,-0.043 -0.779,0.13 -0.953,0.433 -0.087,0.13 -0.13,0.996 -0.173,2.598 l 0.043,0.13 c 0.13,0 0.303,-0.13 0.476,-0.346 0.173,0 0.606,0.043 1.299,0.216 0.52,0.086 1.039,0 1.602,-0.26 0.26,-0.13 0.649,-0.477 1.169,-1.083 l 0.173,0.043 c 0.173,0.13 0.13,0.39 -0.173,0.779 -0.346,0.346 -0.52,0.606 -0.476,0.779 0,0.13 0.26,0.346 0.649,0.649 0.433,0.303 0.693,0.563 0.779,0.779 l -0.086,0.173 -0.087,0.13 c -0.52,-0.303 -0.866,-0.52 -1.125,-0.649 -0.563,-0.26 -1.212,-0.477 -1.905,-0.563 -0.909,-0.173 -1.515,-0.086 -1.862,0.216 -0.173,0.13 -0.346,0.39 -0.476,0.823 -0.216,0.476 -0.39,0.866 -0.476,1.169 -0.043,0.303 -0.13,0.693 -0.173,1.256 -0.086,0.476 -0.26,0.866 -0.477,1.169 -0.086,0.086 -0.433,0.563 -1.125,1.385 -0.216,0.303 -0.39,0.563 -0.52,0.736 -0.303,0.26 -0.52,0.476 -0.606,0.649 -0.217,0.563 -0.39,0.953 -0.563,1.212 -0.043,0.043 -0.303,0.173 -0.693,0.346 -0.433,0.173 -0.692,0.39 -0.823,0.693 -0.086,0.173 -0.173,0.563 -0.216,1.125 -0.086,0.477 -0.173,0.823 -0.303,1.04 -0.433,0.303 -0.736,0.519 -0.909,0.692 -0.52,0.606 -0.866,0.996 -1.082,1.169 -0.217,0.217 -0.39,0.39 -0.52,0.52 -0.39,0.303 -0.649,0.563 -0.822,0.736 -0.433,0.52 -0.65,1.342 -0.693,2.381 0,0.173 0,0.346 0.086,0.649 l 0.173,0.216 c 0.086,0.043 0.606,0.043 1.472,-0.086 0.736,-0.087 1.125,0.043 1.212,0.346 -0.13,0.13 -0.649,0.217 -1.602,0.26 -0.996,0.086 -1.688,0.26 -2.035,0.563 -0.043,0 -0.173,0.13 -0.303,0.346 -0.26,0.347 -0.39,0.65 -0.433,0.866 l 0.13,0.086 0.433,-0.086 c 0.303,-0.087 0.606,-0.043 0.909,0.086 0.303,0.173 0.477,0.39 0.52,0.649 l -0.043,0.173 -0.13,0.086 c -0.173,-0.043 -0.303,-0.086 -0.347,-0.086 -0.649,-0.13 -1.125,-0.043 -1.429,0.173 -0.13,0.086 -0.346,0.346 -0.606,0.822 -0.26,0.347 -0.52,0.563 -0.823,0.649 l -1.169,-0.086 c -0.779,-0.043 -1.342,-0.043 -1.732,-0.043 -0.52,-0.043 -0.909,-0.086 -1.169,-0.043 -0.26,0.043 -0.52,0.13 -0.736,0.216 -0.173,0.13 -0.347,0.303 -0.477,0.52 -0.26,0.39 -0.39,0.563 -0.433,0.649 -0.26,0.13 -0.433,0.303 -0.563,0.39 -0.217,0.26 -0.39,0.433 -0.476,0.52 -0.347,0.303 -0.823,0.477 -1.473,0.606 l -0.216,-0.477 c -0.433,0.26 -1.083,0.13 -2.035,-0.39 -0.13,-0.13 -0.736,-0.26 -1.775,-0.476 -1.125,-0.173 -2.035,0.086 -2.685,0.779 -0.52,0.606 -1.385,0.823 -2.598,0.693 -0.606,-0.043 -1.385,0.216 -2.424,0.736 -0.563,0.26 -1.472,0.866 -2.814,1.775 -0.779,0.52 -1.905,0.779 -3.464,0.779 -0.476,0 -0.953,0.173 -1.472,0.563 0,0 0,0 -0.043,0 -0.26,0.216 -0.477,0.39 -0.649,0.606 0.173,-0.043 0.303,0.043 0.346,0.216 -0.043,0.13 -0.173,0.26 -0.346,0.433 -0.477,0.649 -0.78,0.996 -0.953,1.083 -0.52,0.173 -0.866,0.26 -1.126,0.346 -0.433,0.26 -0.779,0.476 -0.996,0.563 -0.26,0.13 -0.649,0.26 -1.212,0.476 -0.26,0.13 -0.606,0.476 -0.953,1.04 -0.216,0.129 -0.52,0.303 -0.909,0.519 -0.26,0.217 -0.433,0.477 -0.52,0.866 -0.086,0.303 -0.086,0.52 -0.086,0.52 0,0.173 0.086,0.26 0.26,0.39 0.13,0.086 0.26,0.173 0.26,0.26 0,0.13 -0.086,0.26 -0.26,0.39 -0.13,0.087 -0.39,0.216 -0.736,0.347 -0.086,0.043 -0.39,0.303 -0.996,0.822 -0.216,0.043 -0.736,-0.043 -1.429,-0.216 -0.779,-0.173 -1.212,-0.303 -1.386,-0.39 -0.216,-0.52 -0.692,-0.823 -1.299,-0.996 -0.26,-0.043 -0.52,-0.043 -0.779,0.043 -0.303,0.13 -0.52,0.173 -0.606,0.13 -1.083,-0.563 -1.819,-0.866 -2.165,-0.823 -0.26,0.087 -0.433,0.173 -0.563,0.173 -0.563,0.216 -1.082,0.303 -1.515,0.26 -0.823,-0.346 -1.429,-0.52 -1.862,-0.563 -0.693,-0.043 -1.169,-0.043 -1.472,-0.13 -0.303,-0.086 -0.476,-0.13 -0.563,-0.13 -0.346,0.13 -0.692,0.13 -0.909,0.087 -0.173,-0.043 -0.303,-0.173 -0.39,-0.303 -0.086,-0.173 -0.346,-0.26 -0.779,-0.303 -0.303,-0.043 -0.649,-0.26 -1.126,-0.606 -0.433,-0.303 -0.822,-0.477 -1.125,-0.477 l -0.606,0.13 c -0.087,0 -0.347,0 -0.736,0 -0.086,0 -0.173,0.043 -0.216,0.043 l -0.173,0.043 c -0.39,0.173 -0.649,0.26 -0.823,0.303 -0.39,0.043 -0.649,0.043 -0.822,0.043 -0.91,0.086 -1.516,0.043 -1.862,-0.086 -0.347,-0.173 -0.693,-0.433 -1.039,-0.866 -0.303,-0.433 -0.563,-0.693 -0.779,-0.779 l -0.087,0.043 c 0.217,0.216 0.433,0.606 0.736,1.256 0.216,0.26 0.649,0.563 1.299,0.952 0.086,0.087 0.303,0.433 0.693,1.039 0.26,0.39 0.563,0.736 0.909,0.953 0.563,0.347 0.866,0.649 0.996,0.866 0.087,0.217 0.303,0.78 0.563,1.646 l 0.13,-0.043 c 0.043,-0.13 0.043,-0.476 0.043,-1.082 -0.043,-0.563 0.043,-0.996 0.13,-1.212 0.216,-0.217 0.39,-0.39 0.476,-0.476 0.26,-0.043 0.606,-0.043 1.083,0.086 0.303,-0.173 0.606,-0.217 0.953,-0.13 0.13,0.043 0.39,0.13 0.736,0.346 0.563,0.173 1.126,0.433 1.646,0.693 0.259,0.13 0.606,0.303 1.125,0.433 0.216,0.129 0.606,0.346 1.083,0.606 0.346,0.13 0.649,0.043 0.953,-0.303 0.173,0 0.433,0 0.779,0.087 0.13,-0.043 0.26,-0.043 0.347,0 0.043,0.043 0.217,0.346 0.52,0.822 0.043,0.087 0.086,0.13 0.13,0.217 0,0 0,0 0.043,0.043 0.13,0.173 0.303,0.39 0.52,0.649 0.26,0.39 0.433,0.736 0.476,1.039 0,0.13 -0.086,0.217 -0.173,0.26 -0.303,-0.043 -0.52,-0.087 -0.693,-0.043 -0.346,0 -0.52,0.13 -0.606,0.39 -0.13,0.346 -0.217,0.563 -0.217,0.606 -0.26,0.26 -0.649,0.477 -1.255,0.65 -0.13,0.043 -0.217,0.086 -0.347,0.129 -0.649,0.173 -1.342,0.217 -1.992,0.13 -0.779,-0.087 -1.342,-0.13 -1.732,-0.043 l -0.173,0.086 c -0.13,0.043 -0.303,0.173 -0.563,0.347 -0.173,0.086 -0.433,0.216 -0.779,0.39 -0.043,0.043 -0.173,0.129 -0.303,0.26 -0.043,0.086 -0.086,0.173 -0.086,0.303 l 0.563,0.649 c 0.13,0.087 0.216,0.303 0.39,0.563 0.433,0.303 0.996,0.39 1.645,0.26 0.087,-0.043 0.216,-0.043 0.433,-0.086 l 0.822,0 c 0.087,-0.087 0.13,-0.173 0.13,-0.303 -0.433,-0.476 -0.606,-0.866 -0.477,-1.169 l 0.13,-0.086 c 0.173,0 0.606,0.173 1.212,0.649 0.173,0.086 0.39,0.216 0.649,0.433 0.043,0.043 0.13,0.217 0.303,0.52 0.086,0.216 0.216,0.346 0.346,0.39 0.13,0.043 0.39,0.086 0.693,0.173 0.649,0.303 1.039,0.433 1.212,0.433 0.086,0 0.26,0 0.52,-0.086 0.173,-0.043 0.346,0 0.52,0.13 0.39,0.303 0.736,0.736 0.996,1.299 0.173,0.303 0.216,0.476 0.259,0.52 0.043,0.086 0.217,0.216 0.433,0.346 l 1.862,0.779 c 0.173,0.043 0.39,0.043 0.606,-0.043 0.173,-0.043 0.39,0 0.693,0.13 0.173,0 0.52,-0.173 1.039,-0.433 l 0.043,0.13 c 0,0.043 -0.26,0.303 -0.649,0.736 l -0.087,0.173 c 0.043,0.216 0.173,0.52 0.39,0.953 l 0.173,1.039 c 0.173,0.173 0.433,0.303 0.866,0.303 0.692,0.346 1.169,0.52 1.385,0.606 0.043,0 0.173,0.043 0.347,0.086 l 1.299,0.433 c 0.303,0.13 0.433,0.173 0.52,0.216 0.303,0.087 0.779,0.173 1.385,0.303 1.212,0.303 1.905,0.477 2.035,0.477 0.26,-0.043 0.433,-0.173 0.606,-0.433 0.173,-0.26 0.433,-0.433 0.779,-0.52 0.087,0.086 0.39,-0.043 0.866,-0.303 0.043,0 0.13,0 0.303,-0.043 0.649,-0.217 1.039,-0.347 1.082,-0.347 0.217,0 0.52,0.086 0.909,0.173 0.087,0 0.217,-0.087 0.347,-0.173 0.13,-0.043 0.346,-0.043 0.606,-0.086 0.26,-0.087 0.563,-0.26 0.953,-0.606 0.13,-0.043 0.346,-0.086 0.649,-0.13 0.13,0 0.26,0 0.39,0 0.52,-0.043 0.866,-0.043 1.039,0.043 0.173,0.043 0.52,0.173 0.909,0.346 0.173,0.043 0.433,0.043 0.823,-0.043 0.087,0.043 0.216,0.13 0.39,0.26 l 0.043,0.13 c 0.433,0.216 0.909,0.086 1.559,-0.347 0.173,-0.043 0.649,-0.043 1.472,0 0.693,0 1.083,-0.173 1.169,-0.476 0.086,-0.433 0.086,-0.693 0.043,-0.823 -0.129,-0.086 -0.173,-0.26 -0.259,-0.433 l 0.043,-0.13 0.13,-0.086 c 0.086,0 0.26,0.086 0.433,0.216 0.477,0.13 0.693,0.173 0.736,0.173 0.043,0.043 0.26,0.26 0.606,0.693 0.216,0.26 0.476,0.433 0.692,0.476 0.39,0 0.996,-0.39 1.905,-1.169 0.26,-0.173 0.433,-0.26 0.476,-0.26 0.043,-0.086 0.087,-0.26 0.087,-0.563 -0.043,-0.303 0,-0.52 0.043,-0.606 0.086,-0.086 0.129,-0.13 0.26,-0.13 0.13,-0.086 0.259,-0.303 0.39,-0.606 0.086,-0.347 0.173,-0.563 0.303,-0.649 l 0.087,0.086 c 0.043,0.303 -0.043,0.779 -0.26,1.342 0,0.303 0.086,0.822 0.26,1.559 -0.043,0.26 -0.217,0.563 -0.52,0.909 0,0.13 0.043,0.216 0.13,0.26 0.086,0 0.303,-0.13 0.649,-0.39 0.086,-0.086 0.173,-0.13 0.26,-0.216 0.216,-0.087 0.39,-0.13 0.563,-0.13 0.043,0.043 0.087,0.043 0.087,0.086 0.52,0.303 0.909,0.52 1.125,0.649 0.13,0.043 0.216,0.086 0.26,0.13 0.173,0.13 0.173,0.346 0.043,0.649 -0.043,0.086 -0.173,0.217 -0.433,0.39 -0.216,0.087 -0.346,0.216 -0.346,0.346 0.043,0.087 0.216,0.173 0.433,0.173 0.13,-0.043 0.259,-0.173 0.39,-0.433 0.086,-0.217 0.216,-0.39 0.39,-0.39 0.173,0.087 0.476,0.217 0.866,0.303 0.043,0 0.087,0 0.13,0.043 0.043,0 0.13,0.043 0.303,0.13 0.303,0.346 0.39,0.693 0.303,0.953 l 0.433,0.39 c 0.043,0 0.173,0.216 0.39,0.563 0.13,0.217 0.303,0.303 0.563,0.347 0.086,0 0.26,-0.087 0.476,-0.26 0.217,-0.173 0.39,-0.217 0.563,-0.173 0.043,0 0.216,0.13 0.563,0.346 0.26,0.217 0.476,0.303 0.606,0.26 l 0.087,-0.129 c -0.217,-0.347 -0.347,-0.606 -0.433,-0.736 -0.13,-0.216 -0.086,-0.52 0.086,-0.779 0.13,-0.216 0.26,-0.303 0.433,-0.303 0.043,-0.043 0.26,0 0.606,0.087 0.26,0.043 0.477,0 0.563,-0.043 l 0.043,-0.173 c -0.043,-0.13 -0.216,-0.26 -0.433,-0.346 -0.303,-0.13 -0.476,-0.217 -0.52,-0.346 -0.087,-0.087 -0.087,-0.26 -0.043,-0.39 0.087,-0.303 0.217,-0.433 0.347,-0.477 0.086,-0.043 0.26,-0.13 0.433,-0.216 0.086,-0.043 0.173,-0.173 0.216,-0.39 0.086,-0.173 0.216,-0.303 0.476,-0.347 0.043,-0.043 0.13,-0.173 0.173,-0.346 0.043,-0.173 0.13,-0.26 0.26,-0.303 0.173,0 0.39,0.087 0.52,0.26 0.216,0.217 0.39,0.606 0.476,1.212 0,0.043 0,0.043 0.043,0.043 0.173,-0.043 0.346,-0.13 0.476,-0.26 0.26,-0.259 0.347,-0.649 0.303,-1.212 0,-0.217 0,-0.39 -0.043,-0.477 -0.086,-0.26 -0.173,-0.433 -0.173,-0.519 l -0.217,-0.736 c -0.216,-0.866 -0.086,-1.429 0.433,-1.732 l 0.303,0 c 0.173,0.087 0.39,0.303 0.649,0.649 l 0.173,-0.043 c 0.043,0.043 0.216,0.13 0.476,0.26 0.303,0.13 0.433,0.173 0.52,0.173 0.043,-0.173 0.216,-0.433 0.39,-0.823 0.086,-0.086 0.13,-0.216 0.173,-0.303 0.346,-0.043 0.606,-0.173 0.866,-0.477 l 0.303,0 c 0.086,0.043 0.26,0.217 0.563,0.606 0.26,0.26 0.476,0.433 0.692,0.563 0.043,0.043 0.13,0.043 0.217,0.087 0.303,0.086 0.606,0.043 0.866,-0.087 0.043,-0.043 0.086,-0.043 0.086,-0.086 0.13,-0.086 0.303,-0.216 0.52,-0.39 l 0.173,0.086 c 0.043,0.087 0.173,0.217 0.347,0.433 0.13,0.13 0.389,0.173 0.779,0.216 0.13,0 0.216,0 0.39,0 0.52,0 0.909,0.173 1.083,0.477 0.173,0.303 0.346,0.736 0.476,1.429 0.13,0.216 0.346,0.52 0.693,0.909 0.086,0.13 0.26,0.26 0.39,0.433 0.13,0.26 0.173,0.39 0.216,0.39 0,0.043 0.043,0.086 0.086,0.086 l 0.13,0.043 c 0.086,-0.043 0.216,-0.216 0.259,-0.476 0.087,-0.26 0.173,-0.39 0.303,-0.477 0.217,-0.043 0.39,0.13 0.52,0.606 0.13,0.433 0.303,0.692 0.52,0.649 l 0.26,-0.13 0.173,0.043 c 0.087,0.13 0.173,0.217 0.216,0.39 0.13,0.087 0.303,0.087 0.433,0.043 0.087,-0.043 0.13,-0.13 0.216,-0.26 -0.129,-0.303 -0.216,-0.52 -0.26,-0.649 0.043,-0.433 0.043,-0.779 -0.086,-0.996 -0.086,-0.173 -0.26,-0.259 -0.433,-0.346 -0.303,-0.043 -0.477,-0.13 -0.52,-0.173 -0.043,0 -0.043,0 -0.043,-0.043 -0.086,-0.087 -0.216,-0.26 -0.433,-0.52 l 0.086,-0.129 c 0.217,-0.043 0.433,0.043 0.736,0.216 0.303,-0.173 0.476,-0.52 0.649,-1.083 l 0.173,0 c 0,0.043 0.129,0.13 0.303,0.303 l 0.216,0.346 c 0.043,0.087 0.087,0.173 0.087,0.26 0.043,0.217 0,0.477 -0.087,0.823 -0.086,0.433 -0.129,0.736 -0.086,0.866 l 0.086,0.086 0.13,0 c 0.606,-0.303 0.996,-0.779 1.212,-1.386 0.043,-0.216 0.043,-0.346 0,-0.433 -0.216,-0.043 -0.39,-0.087 -0.476,-0.217 -0.086,-0.043 -0.13,-0.13 -0.13,-0.173 -0.39,-0.433 -0.606,-0.78 -0.779,-1.039 -0.173,-0.303 -0.173,-1.212 0.086,-2.728 l 0.087,-0.086 c 0.13,0 0.26,0 0.476,0.13 0.39,0.216 0.866,0.736 1.385,1.472 0.043,0.086 0.13,0.216 0.217,0.39 0.303,0.303 0.476,0.563 0.606,0.779 0.043,0.13 0.13,0.303 0.173,0.52 0.13,0.346 0.26,0.866 0.433,1.472 0.043,0.086 0.303,0.26 0.779,0.476 0.043,0.13 0.086,0.693 0.129,1.602 0,0.866 0.087,1.342 0.217,1.429 0.26,0 0.433,-0.303 0.476,-0.909 0.043,-0.693 0.043,-1.083 0.087,-1.256 0.086,-0.736 0.173,-1.125 0.173,-1.125 -0.13,-0.13 -0.303,-0.216 -0.52,-0.303 -0.259,-0.043 -0.433,-0.129 -0.52,-0.216 -0.13,-0.13 -0.086,-0.433 0.13,-0.823 0.26,-0.433 0.477,-0.649 0.649,-0.649 0.217,0.043 0.477,0.39 0.866,0.953 0.173,0.173 0.346,0.26 0.563,0.216 0.216,0 0.39,0 0.476,0.043 0.216,0.173 0.433,0.476 0.606,0.953 0.173,0.13 0.476,0.26 0.996,0.346 0.173,0.13 0.39,0.347 0.736,0.693 0.303,0.216 0.65,0.216 1.04,-0.043 0.26,-0.13 0.433,-0.433 0.563,-0.909 0.173,-0.52 0.303,-0.866 0.39,-0.996 0.087,-0.043 0.216,-0.043 0.303,-0.043 0.13,0.086 0.303,0.347 0.563,0.779 0.26,0.433 0.39,0.736 0.39,0.823 0.043,0.13 0,0.303 -0.087,0.476 -0.043,0.173 -0.086,0.476 -0.043,0.909 0,0.39 -0.13,0.736 -0.303,1.126 -0.303,0.433 -0.52,0.52 -0.736,0.216 -0.087,-0.086 -0.13,-0.433 -0.13,-0.952 -0.043,-0.217 -0.043,-0.347 -0.043,-0.477 l -0.173,-0.043 c -0.043,0 -0.346,0.433 -0.779,1.299 l -0.13,0.087 -0.13,-0.043 c -0.13,-0.173 -0.086,-0.346 0.043,-0.606 0.129,-0.26 0.173,-0.52 0.13,-0.693 l -0.13,-0.086 c -0.173,0 -0.303,0.043 -0.433,0.216 -0.086,0.216 -0.216,0.39 -0.26,0.476 -0.303,0.13 -0.476,0.26 -0.563,0.39 -0.216,0.217 -0.303,0.563 -0.26,0.996 0,0.39 0.087,0.736 0.26,1.039 0.303,0.086 0.52,0.303 0.606,0.736 l -0.087,0.217 c -0.043,0.086 -0.173,0.086 -0.26,0.043 -0.26,-0.303 -0.476,-0.476 -0.693,-0.563 l -0.129,0.043 c -0.13,0.129 -0.173,0.259 -0.26,0.39 -0.043,0.129 -0.217,0.346 -0.433,0.563 -0.087,0.173 -0.13,0.303 -0.13,0.433 0,0.26 0.13,0.433 0.433,0.52 0.13,0.043 0.303,0 0.563,0 0.043,-0.043 0.13,-0.043 0.217,-0.086 0.346,-0.043 0.606,-0.043 0.779,0.043 0.216,0.217 0.216,0.52 0.043,0.996 -0.086,0.173 -0.13,0.346 -0.13,0.476 0,0.173 0,0.303 0.087,0.433 l 0.173,0.043 c 0.216,-0.043 0.39,-0.217 0.52,-0.477 0,-0.043 0.043,-0.13 0.043,-0.216 0.13,-0.39 0.303,-0.649 0.563,-0.693 0.173,0.086 0.39,0.13 0.606,0.173 0.433,0.043 0.823,0 1.169,-0.087 0.043,-0.043 0.087,-0.086 0.13,-0.173 0.087,-0.13 0.173,-0.303 0.26,-0.477 0.087,-0.216 0.13,-0.433 0.217,-0.649 0.13,-0.693 0.303,-1.169 0.433,-1.429 0.13,-0.13 0.26,-0.39 0.52,-0.736 0.173,-0.26 0.303,-0.563 0.26,-0.779 0,-0.477 -0.043,-0.78 -0.13,-0.953 l -0.173,-0.346 c -0.217,-0.91 -0.217,-1.646 -0.043,-2.208 l 0.087,-0.086 c 0.216,-0.26 0.563,-0.477 0.996,-0.606 0.433,-0.129 0.823,-0.129 1.169,-0.043 0.043,0.043 0.173,0.13 0.39,0.303 0.043,0.043 0.13,0.086 0.303,0.129 0.26,0.173 0.606,0.433 0.996,0.866 0.217,0.216 0.39,0.39 0.52,0.52 0.26,-0.606 0.65,-0.909 1.212,-1.039 -0.043,-0.13 -0.043,-0.303 -0.043,-0.39 -0.043,-0.347 0.043,-0.65 0.26,-0.996 0.13,-0.26 0.433,-0.52 0.91,-0.736 l 0.043,0 c 0.129,-0.086 0.216,-0.13 0.303,-0.173 0.303,-0.173 0.52,-0.346 0.606,-0.52 0.043,-0.043 0.087,-0.303 0.173,-0.823 0.086,-0.346 0.173,-0.563 0.347,-0.563 l 0,-0.043 0.173,0.043 c 0.13,0.129 0.216,0.346 0.26,0.692 0,0.26 0.087,0.477 0.173,0.52 0.39,0.13 0.909,0 1.515,-0.476 1.212,-0.346 1.862,-0.563 1.949,-0.606 0.216,-0.086 0.736,-0.563 1.559,-1.385 0.216,-0.173 0.346,-0.346 0.52,-0.476 -0.736,0 -1.169,-0.043 -1.299,-0.13 -0.13,-0.043 -0.173,-0.26 -0.13,-0.563 -0.173,-0.909 -0.26,-1.559 -0.26,-1.992 0.174,-0.476 0.303,-0.866 0.303,-1.083 -0.003,-0.077 -0.132,-0.596 -0.392,-1.505 m -33.295,-47.973 c -0.13,-0.173 -0.13,-0.389 -0.087,-0.563 0.043,-0.087 0.043,-0.13 0.087,-0.216 -0.173,-0.087 -0.26,-0.13 -0.303,-0.13 -0.433,0 -0.779,0.043 -0.996,0.043 -0.649,0.087 -2.035,0.433 -4.157,1.169 -0.26,0.086 -1.125,0.13 -2.598,0.173 -0.13,0 -0.26,-0.173 -0.39,-0.52 -0.173,-0.52 -0.26,-0.736 -0.26,-0.779 l -0.173,-0.043 c -0.606,0.173 -0.953,0.26 -1.039,0.26 l -0.086,-0.086 c -0.043,-0.39 -0.13,-0.649 -0.173,-0.779 -0.086,-0.087 -0.13,-0.217 -0.13,-0.26 -0.043,-0.13 0.13,-0.477 0.433,-1.039 0.086,-0.087 0,-0.303 -0.217,-0.693 -0.043,-0.173 -0.52,-0.173 -1.342,0 -0.866,0.173 -1.299,0.303 -1.342,0.433 -0.043,0.217 0,0.563 0.086,0.996 0,0.346 -0.779,0.649 -2.295,0.866 l -1.515,0.26 -0.13,0.087 c -0.086,0.13 -0.173,0.39 -0.173,0.779 l -0.13,0.086 c -0.216,0.043 -0.52,-0.043 -0.779,-0.26 -0.346,-0.26 -0.563,-0.476 -0.606,-0.606 -0.129,-0.52 -0.26,-0.866 -0.39,-1.083 -0.173,-0.433 -0.476,-0.649 -0.866,-0.606 -1.255,0.086 -1.992,-0.043 -2.294,-0.26 l -0.52,-0.52 c -0.606,-0.216 -1.342,-0.433 -2.294,-0.649 -0.043,0.477 -0.087,0.996 0,1.602 0.13,0.217 0.433,0.52 0.866,0.909 0.13,0.217 0.043,0.52 -0.26,0.953 0.043,0.303 0.217,0.693 0.477,1.212 0.043,0.346 0,0.823 -0.173,1.472 0.39,0.693 0.476,1.125 0.26,1.299 -0.52,0.13 -0.953,0.13 -1.299,0.043 -0.303,-0.953 -0.52,-1.516 -0.736,-1.775 l -0.13,0.043 c -0.086,0.086 -0.13,0.216 -0.13,0.433 0.043,0.259 0,0.433 -0.043,0.519 -0.087,0.173 -0.303,0.303 -0.693,0.477 -0.043,0.26 0,0.52 0.086,0.866 0.13,0.39 0.303,0.606 0.563,0.606 l 0.693,0.043 c 0.52,0 0.779,0.087 0.866,0.217 0.346,0.822 0.563,1.342 0.606,1.559 0.13,0.476 0.087,0.996 -0.086,1.602 -0.13,0.303 -0.216,0.52 -0.26,0.649 -0.13,0.433 -0.13,0.779 -0.13,1.082 0.043,0.433 0.39,1.126 0.996,2.035 -0.13,0.173 -0.217,0.39 -0.303,0.736 -0.043,0.303 -0.13,0.433 -0.26,0.476 l -0.173,-0.043 c -0.52,-0.433 -0.866,-0.563 -1.083,-0.347 -0.303,0.476 -0.563,0.823 -0.822,1.125 -0.217,0.173 -0.303,0.26 -0.303,0.26 -0.693,-0.043 -1.125,-0.043 -1.299,0.086 l 0.043,-0.086 c -0.173,-0.303 -0.303,-0.477 -0.433,-0.606 l -0.173,0 c -0.173,0.52 -0.303,0.909 -0.433,1.169 -0.043,0.173 -0.173,0.433 -0.346,0.736 -0.086,0.26 -0.173,0.476 -0.26,0.649 -0.13,0.216 -0.39,0.649 -0.779,1.299 0,0.13 0.043,0.303 0.13,0.563 l 0,0.39 c 0,0.13 0.043,0.26 0.173,0.303 0.129,0.043 0.39,0.043 0.779,-0.043 0.174,0 0.823,0.39 1.862,1.125 0.13,0.043 0.39,0.26 0.779,0.693 0.39,0.39 0.606,0.606 0.649,0.693 0.086,0.173 -0.086,0.476 -0.433,0.909 -0.433,0.52 -0.649,0.823 -0.649,0.953 l 0.043,0.433 -0.087,-0.086 -0.866,-0.606 c -0.26,-0.433 -0.433,-0.692 -0.606,-0.779 -0.26,-0.086 -0.476,0.043 -0.736,0.39 -0.043,0.13 -0.043,0.477 0,0.953 0.043,0.476 0.13,0.779 0.303,0.866 0.26,0.043 0.736,0.043 1.342,0 0.129,0.086 0.216,0.173 0.26,0.346 0.086,0.216 0.043,0.346 -0.043,0.477 -0.346,0 -0.563,0 -0.649,0 -0.779,0.216 -1.212,0.389 -1.342,0.519 -0.39,0.606 -0.693,0.953 -0.866,0.953 -1.342,0.303 -2.381,0.433 -3.074,0.433 -0.173,0.173 -0.26,0.303 -0.26,0.39 0.086,0.433 0.52,0.649 1.342,0.649 0.649,-0.043 1.169,-0.13 1.688,-0.346 0.086,0.043 0.173,0.173 0.26,0.346 0.216,0.13 0.476,0.13 0.779,0.043 l 0.043,0.086 -0.087,0.39 c -0.173,0.173 -0.563,0.26 -1.169,0.303 -0.692,0.086 -1.169,0.173 -1.472,0.346 -0.433,0.433 -0.736,0.649 -0.909,0.606 -0.606,-0.13 -0.996,-0.173 -1.299,-0.13 l -1.688,0.259 c -0.303,0.043 -0.52,-0.043 -0.693,-0.346 -0.173,-0.346 -0.303,-0.606 -0.433,-0.693 -0.736,-0.086 -1.083,-0.303 -1.169,-0.606 -0.086,-0.13 -0.39,-0.086 -0.909,0.087 -0.52,0.173 -0.822,0.216 -0.953,0.086 0,-0.26 0,-0.433 -0.086,-0.477 -0.216,0.043 -0.39,0.087 -0.476,0.087 l -0.087,-0.087 -0.043,-0.303 c -0.13,-0.043 -0.303,-0.043 -0.52,-0.043 l 0,0.477 c 0.043,0.563 0,0.952 -0.13,1.125 -0.13,0.216 -0.477,0.346 -0.996,0.52 -0.563,0.13 -0.866,0.086 -0.996,-0.13 -0.087,-0.347 -0.173,-0.563 -0.303,-0.693 -0.13,-0.086 -0.866,0 -2.122,0.26 -0.13,0.043 -0.346,0.52 -0.606,1.429 -0.13,0.303 -0.217,0.52 -0.303,0.606 -0.086,0.043 -0.303,0.086 -0.563,0 l -0.563,-0.086 c -0.303,-0.13 -0.52,-0.173 -0.649,-0.26 -0.26,-0.086 -0.563,-0.216 -0.909,-0.39 -0.303,-0.13 -0.779,-0.086 -1.342,0.26 -0.043,0.086 -0.173,0.39 -0.39,0.996 -0.087,0.303 -0.173,0.563 -0.347,0.779 -0.346,0.606 -0.866,0.996 -1.559,1.212 -0.606,0.173 -0.996,0.26 -1.169,0.173 -0.173,-0.303 -0.347,-0.476 -0.477,-0.52 -0.433,-0.216 -0.779,-0.173 -1.039,0.13 -0.13,0.087 -0.346,0.347 -0.649,0.779 -0.26,0.043 -0.563,0.087 -0.909,0 -0.477,-0.043 -0.779,-0.086 -0.909,-0.086 0.043,0.043 0.086,0.086 0.13,0.173 0.086,0.216 0.086,0.649 0.043,1.212 l 0.563,1.645 c 0.217,0.433 0.477,0.823 0.823,1.169 0.346,0.433 0.779,0.649 1.342,0.649 0.606,-0.043 1.083,0.087 1.429,0.39 0.26,0.217 0.433,0.606 0.52,1.256 0.043,0.52 0.173,0.866 0.303,0.953 l 0.173,-0.043 c 0.303,-0.39 0.606,-0.649 0.822,-0.779 0.693,-0.13 1.083,-0.26 1.256,-0.346 0.173,-0.39 0.346,-0.649 0.476,-0.736 0.13,-0.086 0.303,-0.086 0.52,0 0,0 0.347,0.39 0.996,1.039 0.39,0.52 0.736,0.823 0.909,0.909 0.173,0.043 0.563,0.043 1.212,0.043 0.779,-0.043 1.429,-0.216 1.905,-0.476 0.606,-0.433 1.126,-0.779 1.602,-1.039 0.477,-0.217 0.779,-0.347 0.909,-0.433 0.086,-0.087 0.26,-0.173 0.433,-0.347 l 0.39,-0.13 c 0.26,-0.173 0.563,-0.216 0.952,-0.173 0.303,-0.087 1.04,-0.563 2.122,-1.342 0.173,-0.216 0.39,-0.39 0.649,-0.606 0.043,0 0.043,0 0.043,0 0.52,-0.39 0.996,-0.563 1.472,-0.563 1.559,0 2.685,-0.26 3.464,-0.779 1.342,-0.91 2.251,-1.516 2.814,-1.775 1.039,-0.52 1.818,-0.779 2.424,-0.736 1.212,0.13 2.078,-0.087 2.598,-0.693 0.649,-0.693 1.559,-0.953 2.685,-0.779 1.039,0.216 1.646,0.346 1.775,0.476 0.952,0.52 1.602,0.649 2.035,0.39 l -0.216,-0.52 c 0.736,-0.346 1.212,-0.649 1.472,-0.822 0.173,-0.173 0.433,-0.477 0.736,-0.953 0.26,-0.477 0.52,-0.779 0.736,-0.909 0.173,-0.087 0.736,-0.26 1.645,-0.606 0,-0.476 0.087,-0.822 0.13,-1.083 l 0.13,0 c 0.087,0 0.216,0.043 0.433,0.087 0.26,0.216 0.52,0.476 0.823,0.779 0.303,0.173 0.649,0.303 1.169,0.303 0.303,0.043 0.563,-0.087 0.736,-0.303 0.13,-0.173 0.173,-0.433 0.173,-0.823 0,-0.346 0.043,-0.606 0.13,-0.649 0.043,-0.043 0.173,-0.086 0.433,-0.13 0.129,-0.086 0.26,-0.173 0.303,-0.303 0.043,-0.13 0.043,-0.476 -0.043,-1.125 -0.087,-0.606 -0.043,-1.083 0.086,-1.429 0.043,-0.087 0.173,-0.26 0.346,-0.52 0.087,-0.087 0.26,-0.217 0.563,-0.52 0.216,-0.259 0.216,-0.519 0.043,-0.692 l -0.173,-0.087 c -0.216,0.13 -0.433,0.173 -0.52,0.173 -0.043,0 -0.26,-0.086 -0.563,-0.26 -0.476,-0.303 -0.692,-0.563 -0.649,-0.823 0.043,-0.043 0.086,-0.13 0.217,-0.173 l 0.563,0.173 c 0.347,0.087 0.606,0.087 0.823,0 0.173,-0.173 0.216,-0.476 0.13,-0.996 0.13,-0.779 0.39,-1.255 0.779,-1.429 l 0.13,0.086 c 0.086,0.13 0.043,0.433 -0.13,0.866 -0.173,0.433 -0.216,0.692 -0.086,0.822 l 0.13,0.087 c 0.346,-0.087 0.693,-0.347 0.996,-0.78 0.173,-0.216 0.39,-0.606 0.649,-1.039 0.13,-0.173 0.303,-0.39 0.606,-0.649 0.043,-0.086 0.173,-0.26 0.346,-0.563 0.13,-0.26 0.433,-0.693 0.823,-1.342 0.346,-0.563 0.476,-1.083 0.39,-1.516 -0.043,-0.26 -0.217,-0.476 -0.433,-0.563 -0.346,-0.043 -0.563,-0.087 -0.649,-0.173 l -0.086,-0.13 -0.043,-0.173 0.26,-0.13 c 0.217,0.043 0.606,0.13 1.126,0.216 0.13,0 0.216,0 0.303,-0.043 0.087,-0.087 0.217,-0.26 0.39,-0.433 0.173,-0.173 0.477,-0.39 0.909,-0.693 0.173,-0.173 0.303,-0.26 0.303,-0.303 l 0.26,-0.477 c 0.086,-0.26 0.173,-0.39 0.303,-0.433 0.173,-0.086 0.39,-0.086 0.693,-0.043 0.129,-0.26 0.346,-0.649 0.563,-1.212 0.953,-1.602 1.472,-2.468 1.516,-2.598 0,-0.26 -0.086,-0.606 -0.346,-0.996 -0.26,-0.433 -0.39,-0.692 -0.39,-0.736 l 0.129,-0.173 c 0.043,0 0.217,0 0.477,0 0.173,0.043 0.303,0 0.39,-0.13 0.13,-0.086 0.173,-0.26 0.13,-0.476 0,-0.52 -0.39,-1.212 -1.125,-2.079 -0.693,-0.822 -0.996,-1.342 -0.953,-1.472 0.086,-0.086 0.303,-0.13 0.563,-0.13 0.216,-0.043 0.39,-0.087 0.433,-0.13 l 0.086,-0.173 c 0,-0.086 -0.086,-0.216 -0.26,-0.39 -0.173,-0.173 -0.303,-0.26 -0.39,-0.346 -0.002,-0.039 -0.132,-0.169 -0.305,-0.515 m 22.124,62.087 c -0.13,0.043 -0.217,0.173 -0.26,0.346 l 0.13,0.303 0.606,0.26 c 0.347,0.13 0.477,0.563 0.39,1.255 l 0.606,0.78 c 0.086,0.086 0.26,0.216 0.52,0.346 0.043,0.216 0.13,0.39 0.26,0.476 l 0.173,0.043 c 0.216,-0.086 0.346,-0.303 0.39,-0.649 0,-0.347 0.086,-0.563 0.216,-0.606 l 0.13,0 c 0.086,0.043 0.26,0.303 0.433,0.736 0.346,0.649 0.52,1.515 0.563,2.728 0,0.649 0,1.083 0.043,1.256 0.043,0.173 0.26,0.39 0.606,0.692 0.26,0.173 0.347,0.433 0.26,0.693 -0.173,0.043 -0.303,0.087 -0.39,0.216 0.043,0 0.043,0 0.043,0 0.086,0 0.173,0 0.217,0 l 0.216,3.464 c 0.173,-0.173 0.303,-0.346 0.346,-0.563 0.087,-0.13 0.13,-0.39 0.217,-0.693 l 0.216,-0.173 c 0.13,-0.043 0.303,0.043 0.477,0.173 0.476,0.303 0.779,0.822 0.909,1.515 0.173,0.693 0.259,1.212 0.346,1.472 l 0.996,0 c -0.173,-0.303 -0.303,-0.52 -0.346,-0.736 -0.216,-0.563 -0.346,-0.953 -0.433,-1.256 0.043,-0.043 -0.086,-0.476 -0.303,-1.212 -0.259,-0.692 -0.433,-1.125 -0.519,-1.299 -0.087,-0.173 -0.217,-0.346 -0.39,-0.563 -0.303,-0.39 -0.52,-0.866 -0.649,-1.429 -0.174,-1.255 -0.347,-2.208 -0.477,-2.857 l -0.693,-2.035 c -0.13,-0.52 -0.216,-1.732 -0.26,-3.551 0,-0.13 0,-0.26 0,-0.346 -0.216,-0.693 -0.346,-1.255 -0.39,-1.688 -0.563,0.13 -0.953,0.433 -1.212,1.039 0.087,0.086 0.13,0.173 0.173,0.173 0.216,0.476 0.346,1.125 0.346,2.035 -0.086,0.086 -0.173,0.13 -0.303,0.13 -0.26,0 -0.52,-0.173 -0.736,-0.476 l -0.173,0.736 c 0.13,0.217 0.173,0.477 0.13,0.823 -0.043,0.303 -0.173,0.563 -0.39,0.693 -0.217,0 -0.39,-0.173 -0.39,-0.563 -0.043,-0.346 0,-0.649 0.086,-0.866 l 0.26,-0.173 c 0.173,0.043 0.26,0.043 0.303,0.086 l 0.173,-0.736 c -0.216,-0.346 -0.433,-0.563 -0.52,-0.563 -0.779,0.303 -1.255,0.52 -1.472,0.563 l -0.474,0",
                        "Kharkiv": "m 478.473,114.458 c 0.13,-0.996 0.086,-1.602 -0.13,-1.775 -0.563,0 -1.083,0.043 -1.516,0.13 -0.26,0.086 -0.433,0.13 -0.563,0.173 -1.169,0 -1.905,0.086 -2.165,0.216 -0.649,0.779 -1.126,1.299 -1.342,1.472 -0.476,0.52 -1.645,1.083 -3.464,1.732 0,0 0,0 -0.043,0 l -0.736,0.303 c -0.043,0.043 -0.13,0.043 -0.216,0.043 -0.477,0.087 -0.736,0.13 -0.779,0.13 -0.823,0.26 -1.299,0.347 -1.386,0.303 l -0.26,-0.173 c -0.303,-0.173 -0.693,-0.303 -1.125,-0.346 h -0.606 c -0.563,0.173 -0.996,0.26 -1.212,0.303 -0.563,0.086 -0.996,0.13 -1.256,0.173 -0.173,0.087 -0.26,0.13 -0.303,0.13 -0.346,0.217 -0.606,0.347 -0.822,0.433 -0.433,0.173 -0.909,0.39 -1.429,0.52 -0.476,0.477 -0.909,0.823 -1.255,0.996 -1.169,0.52 -1.948,0.996 -2.381,1.515 -0.649,1.169 -0.996,1.818 -1.083,1.905 -0.433,0.173 -1.083,0.13 -1.861,-0.043 -0.26,-0.086 -0.477,-0.13 -0.606,-0.173 -0.476,-0.346 -0.649,-0.736 -0.563,-1.169 0,-0.13 0.13,-0.346 0.346,-0.606 0.173,-0.26 0.217,-0.477 0.217,-0.606 -0.086,-0.216 -0.303,-0.303 -0.649,-0.346 -0.347,-0.043 -0.606,-0.043 -0.736,0.086 -0.173,-0.043 -0.39,-0.173 -0.563,-0.39 -0.39,-0.433 -0.736,-0.606 -1.083,-0.649 -0.433,-0.043 -0.823,-0.13 -1.083,-0.303 -0.216,-0.346 -0.346,-0.52 -0.433,-0.52 -0.216,0.043 -0.39,0.173 -0.563,0.39 -0.217,0.39 -0.346,0.606 -0.39,0.606 -0.13,0.173 -0.39,0.303 -0.823,0.52 -0.433,0.173 -0.736,0.303 -0.909,0.303 -0.26,0 -0.52,-0.087 -0.736,-0.217 -0.563,-0.39 -0.909,-0.822 -0.996,-1.212 0,-0.303 -0.043,-0.52 -0.087,-0.606 -0.346,-0.216 -0.606,-0.346 -0.692,-0.476 -0.606,-0.606 -1.039,-1.256 -1.256,-1.949 -0.043,-0.563 -0.13,-0.909 -0.303,-0.996 -0.043,-0.043 -0.303,0.043 -0.693,0.13 0.173,-0.39 0.086,-0.736 -0.303,-0.953 -0.173,-0.13 -0.866,-0.26 -2.122,-0.476 -1.255,-0.217 -2.035,-0.303 -2.251,-0.303 -0.563,0.043 -0.996,0.086 -1.342,0.173 -0.39,-0.043 -0.693,-0.043 -0.866,0 -0.216,0 -0.953,0.086 -2.295,0.303 -0.693,0.217 -1.168,0.52 -1.342,0.823 -0.216,0.477 -0.303,0.693 -0.346,0.693 -0.13,0.13 -0.39,0.173 -0.779,0.216 -0.39,0 -0.649,0.13 -0.823,0.26 0,0.043 -0.043,0.39 -0.13,0.996 0,0.303 -0.303,0.476 -0.822,0.563 -0.173,0 -0.347,0.043 -0.477,0.043 0.087,0.303 0,0.563 -0.173,0.866 -0.303,0.476 -0.78,0.606 -1.429,0.433 -0.952,-0.26 -1.472,-0.39 -1.602,-0.346 -0.173,0.173 -0.347,0.303 -0.433,0.39 -0.217,0.13 -0.866,0.086 -1.905,-0.173 -0.173,-0.043 -0.303,0 -0.433,0.087 0.433,0.346 0.606,0.606 0.606,0.822 l -0.086,0.13 c -0.13,0 -0.606,-0.303 -1.516,-0.909 -0.909,-0.606 -1.516,-0.822 -1.905,-0.606 l -0.086,0.13 c 0.26,0.866 0.173,1.472 -0.173,1.732 -0.173,-0.043 -0.476,-0.173 -0.866,-0.433 -0.39,-0.26 -0.649,-0.346 -0.823,-0.303 -0.476,0.303 -0.736,0.563 -0.736,0.693 l 0.39,0.433 v 0.13 l -0.347,0.303 h -0.173 c -0.087,-0.13 -0.26,-0.173 -0.433,-0.217 -0.39,-0.13 -0.649,-0.086 -0.823,0.173 -0.13,0.173 -0.173,0.303 -0.173,0.39 0.26,0.52 0.303,0.866 0.173,1.039 -0.13,0.13 -0.389,0.26 -0.736,0.39 -0.433,0.173 -0.693,0.26 -0.736,0.26 l -0.477,-0.39 -0.779,-0.39 -0.52,-0.043 c -0.216,-0.086 -0.433,-0.043 -0.563,0 -0.303,0.087 -0.52,0.347 -0.606,0.78 -0.13,0.52 -0.26,0.866 -0.39,0.952 l -0.13,0.043 c -0.347,-0.39 -0.563,-0.563 -0.693,-0.563 -0.216,0.13 -0.433,0.26 -0.693,0.39 -0.26,0.13 -0.433,0.26 -0.433,0.347 0.086,0.216 0.173,0.476 0.39,0.822 -0.13,0.347 -0.217,0.563 -0.303,0.606 -0.086,0 -0.347,-0.087 -0.693,-0.347 -0.303,-0.216 -0.52,-0.39 -0.606,-0.52 -0.13,-0.173 -0.216,-0.303 -0.216,-0.303 l -0.173,0.043 c -0.13,0.13 -0.26,0.52 -0.39,1.212 -0.087,0.173 -0.26,0.39 -0.649,0.563 -0.52,0.216 -0.779,0.346 -0.823,0.346 0,0.13 0.086,0.347 0.346,0.606 -0.043,0.043 -0.086,0.303 -0.173,0.736 -0.086,0.303 -0.043,0.606 0.087,0.953 0.043,0.823 0.086,1.255 0.086,1.255 0,0.303 -0.433,0.779 -1.169,1.472 -0.736,0.649 -1.125,1.126 -1.169,1.429 0.13,0.26 0.303,0.649 0.476,1.212 0.217,0.649 0.303,1.039 0.303,1.212 -0.043,0.086 -0.086,0.26 -0.173,0.476 0.303,0.043 0.52,0.26 0.693,0.606 l 0.087,0.26 c 0.043,0.043 0.346,0.13 0.909,0.26 0.086,0 0.216,0.173 0.433,0.433 0.173,0.216 0.39,0.389 0.649,0.433 0.217,0.043 0.563,0.087 1.083,0.087 0.433,-0.043 0.823,0 1.083,0.086 0.13,0.086 0.216,0.303 0.173,0.606 0,0 0.303,0.173 0.866,0.52 0.953,0.563 1.646,0.736 2.035,0.477 0.043,-0.043 0.173,-0.13 0.347,-0.216 0.173,-0.087 0.346,-0.043 0.649,0.086 l 0.13,0.13 c 0.433,0.346 0.649,0.693 0.693,1.083 0.043,0.26 0,0.736 -0.087,1.429 -0.043,0.39 0.043,0.909 0.13,1.602 0.086,0.39 0.26,0.692 0.563,0.822 0.347,0.173 0.563,0.26 0.606,0.347 0.087,0.26 0.087,0.692 0.087,1.299 0.26,0.13 0.693,0.173 1.255,0.216 0.13,0.13 0.13,0.347 0.043,0.649 l 0.087,0.087 c 0.519,0.086 1.255,0.26 2.294,0.563 0.043,-0.043 0.13,-0.216 0.173,-0.433 0.043,-0.26 0.13,-0.433 0.216,-0.477 0.909,0 1.386,0 1.429,0.043 0.043,0.043 0.13,0.39 0.217,1.039 -0.303,0.043 -0.477,0.13 -0.563,0.26 0,0.693 0.693,2.035 1.992,4.07 v 0.173 c -0.13,0.346 -1.039,0.476 -2.728,0.39 -0.043,0.086 -0.043,0.26 0.129,0.563 0.173,0.13 0.52,0.173 0.996,0.216 0.086,0.13 0.173,0.347 0.216,0.693 0.693,0.13 1.04,0.346 1.169,0.693 -0.086,0.26 -0.129,0.433 -0.173,0.476 -0.433,0 -0.693,0.043 -0.823,0.086 -0.13,0.26 -0.26,0.433 -0.346,0.563 -0.91,-0.346 -1.602,-0.52 -2.079,-0.52 -0.13,0.087 -0.303,0.13 -0.39,0.173 -0.39,0.043 -0.563,0.086 -0.606,0.13 -0.26,0.26 -0.346,0.606 -0.346,1.039 0.086,0.173 0.26,0.39 0.52,0.693 l -0.087,0.39 0.087,0.13 c 0.39,0.043 0.649,0.086 0.779,0.173 l 0.043,0.13 c -0.043,0.217 -0.13,0.39 -0.303,0.563 v 0.173 c 0.346,0.13 0.52,0.303 0.563,0.476 0,0.13 -0.043,0.26 -0.13,0.347 l -0.952,1.212 c -0.217,0.433 -0.433,0.736 -0.563,0.953 -0.606,0.909 -1.429,1.559 -2.555,1.992 -0.52,0.173 -0.909,0.26 -1.169,0.26 -1.429,0 -2.381,-0.086 -2.944,-0.26 -0.216,-0.086 -0.433,-0.216 -0.649,-0.476 -0.129,-0.173 -0.216,-0.303 -0.26,-0.39 -0.086,-0.087 -0.26,-0.173 -0.476,-0.173 -0.13,0 -0.217,0.043 -0.26,0.086 -1.775,1.646 -2.511,2.814 -2.165,3.55 0,0.043 0.173,0.26 0.477,0.736 l 0.13,0.26 c 0.043,0.173 0.13,0.433 0.303,0.823 0.26,0.822 0.26,1.342 0,1.515 0.217,0.346 0.477,0.52 0.78,0.52 0.086,0 0.26,-0.13 0.433,-0.346 0.173,-0.13 0.347,-0.217 0.606,-0.217 0.129,0.043 0.26,0.217 0.433,0.563 l 0.173,0.043 c 0.563,-0.217 0.909,-0.26 1.039,-0.26 0.13,0.043 0.303,0.086 0.606,0.173 0.13,0 0.346,0 0.649,-0.043 0.433,0.086 1.039,0.433 1.818,1.082 0.086,0.043 0.173,0.303 0.26,0.736 0.043,0.086 0.433,0.39 1.083,0.866 l 0.173,0.216 c 0.043,0 0.39,0.13 1.039,0.346 l 0.087,0.13 c -0.043,0.26 -0.087,0.477 -0.087,0.563 -0.043,0 0.26,0.173 0.78,0.52 0.26,0.13 0.692,0.606 1.255,1.429 0.173,0.13 0.52,0.303 0.996,0.39 0.303,0.216 0.693,0.477 1.083,0.866 0.606,0.563 0.953,0.909 0.996,0.909 0.13,0.086 0.39,0.043 0.693,-0.043 0.346,-0.13 0.606,-0.173 0.736,-0.13 l 1.385,0.26 c 0.087,0 0.303,-0.086 0.65,-0.346 0.26,0.13 0.606,0.433 0.996,0.909 0.13,0.043 0.347,0.043 0.606,0 0.26,-0.086 0.52,-0.086 0.736,0 0.086,0 0.173,0.13 0.303,0.303 0.086,0.216 0.173,0.303 0.303,0.303 0.043,0 0.26,-0.13 0.606,-0.433 0.087,-0.043 0.217,-0.043 0.347,0.043 0.043,0.043 0.173,0.13 0.346,0.26 0.217,0.173 0.563,0.217 0.996,0.13 0.13,0.043 0.26,0.13 0.433,0.217 l 0.086,0.043 0.086,0.087 0.13,0.26 0.13,0.043 c 0.13,-0.086 0.39,-0.26 0.866,-0.563 0.086,0.043 0.39,-0.087 0.909,-0.433 0.52,-0.303 0.909,-0.477 1.169,-0.563 0.216,-0.086 0.476,-0.13 0.909,-0.26 0.086,-0.043 0.216,-0.173 0.433,-0.346 0.216,0 0.52,0.216 1.039,0.52 0.433,0.303 0.779,0.563 0.953,0.779 -0.13,0.173 -0.217,0.346 -0.26,0.563 l -0.043,0.39 c -0.043,0.086 0.26,0.476 0.909,1.083 l 0.043,0.129 c -0.173,0.39 -0.39,0.736 -0.563,0.996 -0.043,0.043 -0.303,0.173 -0.779,0.433 -0.39,0.173 -0.563,0.39 -0.563,0.649 l 0.086,0.086 c 0.043,0.043 0.477,0 1.212,-0.13 0.173,0 0.477,0.217 0.909,0.779 0.13,0.13 0.563,0.216 1.299,0.26 0.043,0.13 0,0.347 -0.13,0.693 0.086,0.13 0.26,0.173 0.519,0.216 0.26,0 0.433,0.043 0.477,0.173 l 0.043,0.086 c 0.26,0.087 0.476,0.39 0.649,0.953 0.086,0.13 0.26,0.216 0.52,0.26 0.346,0.086 0.606,0.216 0.779,0.433 0.086,0.346 -0.216,0.736 -0.996,1.212 -0.087,0 -0.13,0.13 -0.217,0.346 -0.086,0.173 -0.086,0.346 -0.043,0.433 0.043,0.043 0.26,0.173 0.693,0.39 0.303,0.216 0.693,0.563 1.125,1.039 0.13,0.13 0.65,0.563 1.516,1.212 0.606,0.52 1.083,0.952 1.299,1.429 -0.086,0.303 -0.346,0.779 -0.692,1.342 l 0.043,0.173 c 0.606,0.433 1.039,0.823 1.299,1.212 -0.26,0.303 -0.649,0.779 -1.169,1.429 l 0.606,0.606 c 0.173,-0.043 0.433,-0.347 0.822,-0.866 0.173,0.043 0.433,0.26 0.823,0.649 0.13,0.043 0.39,-0.13 0.693,-0.433 l 0.563,-0.217 c -0.13,-0.13 -0.39,-0.303 -0.736,-0.52 l -0.043,-0.13 0.087,-0.173 c 0.39,-0.649 0.649,-1.083 0.866,-1.299 l 0.433,-0.433 c 0.217,-0.303 0.563,-0.736 1.039,-1.342 0.173,-0.217 0.52,-0.52 0.996,-0.823 l 0.13,-0.043 c 0.043,0.043 0.433,0.26 1.125,0.693 0.086,0 0.173,0.043 0.346,0.13 0.043,0 0.347,0.216 0.866,0.649 0,0 0.13,0.173 0.303,0.433 0.173,0.216 0.259,0.346 0.39,0.346 l 1.602,-0.13 0.217,-0.173 0.26,-0.649 c 0.216,-0.043 0.909,-0.087 2.035,-0.217 -0.347,-0.563 -0.52,-0.953 -0.477,-1.169 l 0.043,-0.693 c 0.043,-0.606 0.086,-1.039 0.086,-1.299 0.043,-0.346 -0.043,-0.779 -0.26,-1.299 -0.086,-0.26 -0.216,-0.779 -0.346,-1.429 -0.173,-0.953 0.043,-1.386 0.606,-1.342 0.303,0 0.476,0 0.563,0.043 0.563,0.346 0.909,0.52 1.039,0.563 0.087,0.043 0.649,0.087 1.602,0.173 l 0.173,-0.043 c 0.129,-0.13 0.303,-0.346 0.563,-0.692 0.433,-0.477 0.953,-0.649 1.516,-0.52 0.216,0.043 0.736,0.303 1.559,0.736 0.606,0.303 0.996,0.52 1.169,0.606 l 0.217,0.043 c 0.129,0.13 0.346,0.346 0.649,0.649 l 0.173,-0.043 c 0.13,-0.13 0.26,-0.39 0.347,-0.736 -0.087,-0.13 -0.26,-0.216 -0.563,-0.346 -0.347,-0.087 -0.52,-0.217 -0.563,-0.347 v -0.346 c 0.347,-0.606 0.606,-0.953 0.779,-0.909 0.086,0 0.26,0.086 0.52,0.26 0.26,0.13 0.477,0.13 0.563,0.086 0.13,-0.13 0.216,-0.346 0.26,-0.649 0,-0.346 0.043,-0.606 0.13,-0.736 0.13,-0.087 0.26,-0.13 0.476,-0.173 0.26,-0.043 0.477,0.086 0.65,0.303 0.173,0.346 0.346,0.52 0.476,0.563 0.216,0.13 0.692,0.086 1.429,-0.13 0.13,0 0.13,-0.347 0.087,-0.996 -0.087,-0.606 0.043,-0.953 0.303,-0.996 l 0.39,0.087 c 0.043,-0.043 0.173,-0.476 0.433,-1.212 0.433,-0.173 0.909,-0.52 1.429,-0.953 0.649,0.087 1.039,0.087 1.212,0 0.216,-0.173 0.303,-0.39 0.216,-0.649 -0.173,-0.26 -0.303,-0.476 -0.346,-0.649 0.086,-0.346 0.13,-0.606 0.173,-0.736 -0.347,-0.13 -0.563,-0.303 -0.563,-0.52 0,-0.087 0.173,-0.433 0.563,-1.039 0.086,-0.217 0.303,-0.347 0.606,-0.347 0.303,-0.043 0.476,-0.13 0.563,-0.216 0.086,-0.13 0.13,-0.433 0.13,-0.909 0,-0.39 0.346,-0.779 0.996,-1.169 0.216,-0.087 0.52,-0.26 0.909,-0.433 0.173,-0.086 0.39,-0.26 0.649,-0.563 0.173,-0.13 0.433,-0.216 0.866,-0.346 l 1.472,-0.866 c 0,0 0.043,-0.043 0.13,-0.086 1.818,-0.996 2.728,-1.645 2.771,-1.862 -0.26,-0.433 -0.477,-0.779 -0.736,-1.083 l -0.649,0.087 c -0.26,0 -0.606,0 -1.083,-0.087 -0.563,-0.13 -0.866,-0.26 -0.952,-0.39 0.129,-0.13 0.346,-0.39 0.606,-0.866 0.303,-0.476 0.476,-0.779 0.52,-0.909 0.043,-0.043 0.39,-0.043 1.083,-0.087 0.13,0 0.26,-0.043 0.476,-0.086 0.866,0 1.386,0 1.559,0.043 0.26,0.043 0.996,0.26 2.122,0.649 0.953,0.346 1.689,0.476 2.165,0.433 l 1.472,-0.13 c 0.13,-0.173 0.216,-0.52 0.26,-1.083 0.043,-0.043 0.043,-0.087 0.043,-0.087 0.087,-0.173 0.173,-0.303 0.303,-0.39 0.043,-0.043 0.13,-0.043 0.303,-0.13 0.13,-0.043 0.52,-0.26 1.125,-0.606 l 0.13,-0.086 -0.174,-0.39 c 0.52,-0.347 0.78,-0.649 0.78,-0.91 -0.087,-0.173 -0.13,-0.346 -0.087,-0.433 l -0.26,-0.347 c -0.563,-0.043 -0.909,-0.13 -1.083,-0.216 -0.216,-0.173 -0.346,-0.476 -0.259,-0.866 0.129,-0.433 0.216,-0.736 0.259,-0.866 0.303,-1.083 0.217,-1.862 -0.173,-2.424 -0.043,-0.043 -0.26,-0.26 -0.606,-0.65 0.303,-0.52 0.477,-0.866 0.52,-0.996 0.216,-0.13 0.606,-0.26 1.169,-0.346 0.086,-0.13 0.13,-0.477 0.173,-1.083 0,-0.563 0.087,-0.953 0.347,-1.212 0.086,-0.086 0.39,-0.26 0.866,-0.52 0.217,-0.086 0.173,-0.39 0,-0.953 -0.26,-0.606 -0.39,-0.953 -0.346,-0.996 0.086,-0.043 0.216,0 0.39,0.043 l 0.086,-0.13 c 0,-0.13 -0.043,-0.26 -0.13,-0.39 -0.173,-0.173 -0.26,-0.303 -0.26,-0.346 -0.086,-0.433 -0.216,-0.693 -0.303,-0.823 v -0.173 c 0.13,-0.173 0.433,-0.347 0.866,-0.563 0.043,-0.043 0.086,-0.217 0.086,-0.606 0.043,-0.346 0.26,-0.692 0.736,-1.039 0.086,-0.173 0.086,-0.476 0,-0.866 -0.087,-0.433 -0.13,-0.736 -0.087,-0.866 0.087,-0.346 0.13,-0.563 0.173,-0.692 0.043,-0.303 -0.043,-0.52 -0.26,-0.779 -0.173,-0.13 -0.649,-0.043 -1.385,0.346 -0.173,-0.043 -0.26,-0.216 -0.303,-0.476 0.043,-0.087 0.173,-0.347 0.433,-0.693 0.26,-0.39 0.433,-0.563 0.52,-0.606 0.129,-0.086 0.476,-0.043 1.082,0.217 0.13,-0.563 0.26,-0.91 0.52,-1.169 0.433,-0.087 0.693,-0.26 0.78,-0.433 -0.043,-0.173 -0.563,-0.606 -1.559,-1.299 l -0.043,-0.173 c 0.216,-0.52 0.779,-0.779 1.731,-0.866 0.087,0 0.26,0 0.52,0 0.173,-0.043 0.303,-0.13 0.346,-0.26 v -0.173 l -0.086,-0.13 -0.606,-0.303 c -0.13,-0.043 -0.39,-0.433 -0.736,-1.039 -0.217,-0.433 -0.347,-0.779 -0.433,-0.953 h -0.173 l -0.13,-0.086 c 0.043,-0.087 0.043,-0.13 0.043,-0.173 0.13,-0.563 0.173,-0.953 0.086,-1.212 -0.173,-0.216 -0.303,-0.39 -0.346,-0.476 -0.086,-0.043 -0.216,-0.303 -0.39,-0.736 -0.433,-0.563 -0.693,-0.953 -0.823,-1.212 -0.216,-0.173 -0.303,-0.347 -0.39,-0.477 -0.303,-0.476 -0.52,-0.779 -0.563,-0.952 l -0.346,-0.347 c -0.086,-0.043 -0.433,-0.216 -1.169,-0.52 -0.823,-0.52 -1.472,-0.866 -1.948,-1.039 -0.866,-0.216 -1.429,-0.39 -1.732,-0.563 -0.043,0 -0.217,-0.13 -0.52,-0.346 -0.173,-0.173 -0.39,-0.649 -0.52,-1.342 -0.087,-0.346 -0.606,-1.083 -1.472,-2.208 -0.26,-0.39 -0.433,-0.693 -0.563,-0.823 -0.13,-0.173 -0.216,-0.303 -0.26,-0.346 -0.736,-0.606 -1.083,-1.039 -1.083,-1.256 0.043,-0.13 0.13,-0.346 0.303,-0.692 0.043,-0.13 0.13,-0.693 0.216,-1.775 0.043,-0.173 0.087,-0.433 0.173,-0.736 0.043,-0.173 0,-0.347 -0.086,-0.606 -0.13,-0.216 -0.39,-0.39 -0.736,-0.476 -0.39,-0.087 -0.693,-0.13 -0.866,-0.173 -0.217,-0.043 -0.52,-0.173 -0.953,-0.303 -0.303,-0.303 -0.52,-0.52 -0.693,-0.606 -0.26,-0.173 -0.433,-0.26 -0.433,-0.303 l -0.173,-0.173 c -0.343,-0.601 -0.689,-1.294 -0.905,-2.117",
			"Donetsk": "m 492.458,167.583 c -0.779,-0.086 -1.169,-0.173 -1.256,-0.216 -0.346,-0.78 -0.822,-1.169 -1.342,-1.169 0,0 0,0.043 -0.043,0.087 -0.043,0.563 -0.13,0.909 -0.26,1.083 l -1.472,0.13 c -0.476,0.043 -1.212,-0.087 -2.165,-0.433 -1.125,-0.39 -1.862,-0.606 -2.122,-0.649 -0.173,-0.043 -0.693,-0.043 -1.559,-0.043 -0.216,0.043 -0.346,0.086 -0.476,0.086 -0.693,0.043 -1.04,0.043 -1.083,0.087 -0.043,0.13 -0.216,0.433 -0.52,0.909 -0.26,0.476 -0.477,0.736 -0.606,0.866 0.086,0.13 0.39,0.26 0.952,0.39 0.477,0.087 0.823,0.087 1.083,0.087 l 0.649,-0.087 c 0.26,0.303 0.477,0.649 0.736,1.083 -0.043,0.217 -0.953,0.866 -2.771,1.862 -0.087,0.043 -0.13,0.086 -0.13,0.086 l -1.472,0.866 c -0.433,0.13 -0.693,0.216 -0.866,0.346 -0.26,0.303 -0.476,0.477 -0.649,0.563 -0.39,0.173 -0.693,0.346 -0.909,0.433 -0.649,0.39 -0.996,0.779 -0.996,1.169 0,0.476 -0.043,0.779 -0.13,0.909 -0.087,0.086 -0.26,0.173 -0.563,0.216 -0.303,0 -0.52,0.13 -0.606,0.347 -0.39,0.606 -0.563,0.952 -0.563,1.039 0,0.216 0.216,0.39 0.563,0.52 -0.043,0.13 -0.087,0.39 -0.173,0.736 0.043,0.173 0.173,0.39 0.346,0.649 0.087,0.26 0,0.477 -0.216,0.649 -0.173,0.087 -0.563,0.087 -1.212,0 -0.52,0.433 -0.996,0.779 -1.429,0.953 -0.26,0.736 -0.39,1.169 -0.433,1.212 l -0.39,-0.087 c -0.26,0.043 -0.39,0.39 -0.303,0.996 0.043,0.649 0.043,0.996 -0.087,0.996 -0.736,0.216 -1.212,0.26 -1.429,0.13 -0.13,-0.043 -0.303,-0.217 -0.476,-0.563 -0.173,-0.217 -0.39,-0.347 -0.65,-0.303 -0.216,0.043 -0.346,0.086 -0.476,0.173 -0.086,0.13 -0.13,0.39 -0.13,0.736 -0.043,0.303 -0.13,0.52 -0.26,0.649 -0.086,0.043 -0.303,0.043 -0.563,-0.086 -0.26,-0.173 -0.433,-0.26 -0.52,-0.26 -0.173,-0.043 -0.433,0.303 -0.779,0.909 v 0.346 c 0.043,0.13 0.216,0.26 0.563,0.347 0.303,0.13 0.476,0.216 0.563,0.346 -0.087,0.346 -0.217,0.606 -0.347,0.736 l -0.173,0.043 c -0.303,-0.303 -0.52,-0.52 -0.649,-0.649 l -0.217,-0.043 c -0.173,-0.086 -0.563,-0.303 -1.169,-0.606 -0.823,-0.433 -1.342,-0.693 -1.559,-0.736 -0.563,-0.13 -1.083,0.043 -1.516,0.52 -0.26,0.346 -0.433,0.563 -0.563,0.692 l -0.173,0.043 c -0.953,-0.086 -1.515,-0.13 -1.602,-0.173 -0.13,-0.043 -0.477,-0.216 -1.039,-0.563 -0.087,-0.043 -0.26,-0.043 -0.563,-0.043 -0.563,-0.043 -0.779,0.39 -0.606,1.342 0.13,0.649 0.26,1.169 0.346,1.429 0.217,0.52 0.303,0.953 0.26,1.299 0,0.26 -0.043,0.693 -0.086,1.299 l -0.043,0.693 c -0.043,0.216 0.13,0.606 0.477,1.169 0.086,0.086 0.173,0.433 0.26,1.039 l 0.13,0.087 c 0.26,0.043 0.736,-0.043 1.342,-0.217 0.173,0.043 0.26,0.217 0.303,0.52 -0.173,0.087 -0.346,0.173 -0.433,0.217 -0.216,0.13 -0.346,0.39 -0.346,0.866 l -0.563,0.13 c -0.13,0.13 -0.173,0.693 0,1.646 l 0.043,0.086 c 0.173,-0.086 0.52,-0.13 1.125,-0.13 0.39,-0.043 0.606,-0.693 0.649,-2.078 0.13,-0.086 0.477,-0.13 0.996,-0.173 0.519,-0.043 0.866,-0.043 1.083,-0.043 l 0.13,0.13 c 0.086,0.216 0.173,0.649 0.216,1.299 0.043,0.606 0.043,0.952 -0.043,1.039 -0.779,0.216 -1.125,0.39 -1.169,0.52 0,0.13 0.13,0.476 0.303,0.996 l -0.043,0.13 -0.779,0.433 c 0.173,0.563 0.13,1.039 -0.086,1.516 0.086,0.216 0.303,0.346 0.649,0.476 -0.173,0.346 -0.649,0.649 -1.342,0.823 v 0.13 c 0,0.216 0.043,0.606 0.26,1.082 0.087,0.823 0.13,1.299 0.13,1.386 0,0.173 -0.043,0.433 -0.173,0.909 -0.087,0.346 -0.087,0.606 0.043,0.866 0,0.129 0.043,0.173 0.13,0.216 h 0.173 c 0.13,-0.087 0.303,-0.173 0.563,-0.216 0.26,-0.087 0.477,-0.087 0.563,0.043 0.087,0.13 0.13,0.347 0.13,0.563 0.477,0 0.823,0.043 1.039,0.173 l 0.087,0.086 0.043,0.823 c 0.043,0.173 0.086,0.39 0.173,0.736 0.043,0.13 0.087,0.346 0.087,0.606 l 0.173,1.039 c 0.13,0.736 0.173,1.255 0.13,1.515 -0.043,0.39 -0.303,0.649 -0.693,0.736 -0.563,0.086 -0.866,0.173 -0.952,0.259 -0.087,0.087 -0.13,0.173 -0.087,0.303 0.173,1.169 0.303,1.905 0.433,2.251 0,0.13 0.086,0.303 0.216,0.52 0.217,1.039 0.173,1.646 -0.13,1.948 -0.952,0.823 -1.472,1.169 -1.645,1.126 l -0.649,-0.26 c -0.26,-0.216 -0.433,-0.346 -0.563,-0.39 -0.346,-0.043 -0.606,-0.13 -0.779,-0.173 -0.433,-0.086 -0.649,-0.26 -0.736,-0.39 l -0.087,-0.476 c -0.13,-0.173 -0.303,-0.303 -0.563,-0.39 -0.26,-0.043 -0.52,-0.087 -0.649,-0.13 -0.736,-0.217 -1.082,-0.347 -1.169,-0.303 -0.433,0.13 -0.779,0.26 -0.996,0.303 l -0.217,-0.043 c -0.303,-0.043 -0.606,0.043 -0.953,0.26 -0.173,0.303 -0.216,0.866 -0.129,1.646 0.086,0.779 0,1.429 -0.217,1.862 0,0.086 0.087,0.216 0.303,0.476 0,0.13 -0.043,0.39 -0.216,0.909 l 0.043,0.13 c 0.78,0.087 1.212,0.216 1.299,0.433 0.39,0.909 0.606,1.385 0.606,1.429 -0.086,0.086 -0.736,0.13 -1.905,0.13 l -0.13,0.346 c -0.216,0.043 -0.476,0 -0.822,0 l -0.217,0.13 c -0.086,0.173 -0.086,0.39 -0.086,0.693 -0.043,0.303 0,0.52 0.13,0.649 l 0.909,0.173 0.086,0.086 c 0.217,0.649 0.26,1.083 0.217,1.212 0.173,0.217 0.129,0.823 -0.173,1.732 -0.043,0.086 0,0.13 0.043,0.216 0.259,0.52 0.736,0.693 1.472,0.606 0.173,-0.043 0.433,-0.087 0.866,-0.217 0.173,0.13 0.26,0.91 0.346,2.295 l 0.52,0.52 c 0.13,0.173 0.26,0.477 0.39,0.996 0.087,0.477 0.217,0.78 0.303,0.91 0.173,0.173 0.606,0.303 1.385,0.433 0,0.13 0,0.217 -0.043,0.26 -0.649,0.173 -1.039,0.347 -1.083,0.39 0.216,0.606 0.39,0.953 0.563,0.996 0.303,-0.043 0.476,-0.043 0.606,0.043 0.087,0.087 0.043,0.303 -0.043,0.649 -0.129,0.433 -0.129,0.693 -0.129,0.91 l 0.129,0.086 c 0.303,0.086 0.866,-0.086 1.775,-0.649 0.13,0.086 0.217,0.173 0.346,0.303 l 0.39,0.65 c 0.259,0.433 0.736,1.082 1.429,1.948 0.13,0 0.346,-0.13 0.693,-0.433 0.26,-0.303 0.606,-0.52 1.039,-0.736 h 0.173 c 0.39,0.692 0.823,1.039 1.299,1.083 0.217,0.173 0.52,0.606 0.91,1.299 0.086,0.086 0.303,0.26 0.606,0.476 0.13,0.086 0.346,0.303 0.563,0.649 0.216,0.13 0.52,0.347 0.909,0.606 0.086,0.086 0.346,0.476 0.779,1.212 0.043,0.043 0.086,0.13 0.13,0.26 l 0.173,0.043 c 0.087,0 0.217,-0.086 0.347,-0.26 l 0.043,-0.303 0.086,-0.13 c 0.39,0 0.866,0.086 1.429,0.26 0.173,0 0.433,-0.043 0.736,-0.13 l 0.13,0.087 c 0,0.39 -0.26,0.866 -0.736,1.515 0,0.13 0,0.39 0.043,0.779 -0.477,0.39 -0.649,0.996 -0.52,1.732 0.043,0.13 0.043,0.347 0.13,0.649 -0.087,0.087 -0.347,0.216 -0.693,0.433 -0.347,-0.866 -0.779,-1.299 -1.299,-1.256 -0.303,0.087 -0.52,0.26 -0.606,0.52 -0.087,0.173 -0.13,0.433 -0.26,0.822 -0.086,0.217 -0.26,0.563 -0.476,1.039 v 0.866 c -0.216,0.216 -0.649,0.39 -1.342,0.52 -0.13,0.043 -0.433,0.043 -0.866,0 -0.477,-0.043 -0.736,-0.13 -0.823,-0.216 0,-0.13 -0.087,-0.217 -0.13,-0.26 -0.303,0.043 -0.476,0.043 -0.649,0 l -0.26,-0.347 c -0.303,0.043 -0.563,0.173 -0.693,0.39 -0.173,0.26 -0.216,0.52 -0.043,0.736 0.087,0.086 0.26,0.303 0.477,0.606 0.13,0.26 0.216,0.693 0.303,1.299 0.13,0.649 0.13,1.083 0.043,1.299 -0.216,0.216 -0.606,0.347 -1.255,0.347 -0.693,0 -1.126,0.043 -1.212,0.173 l -0.086,0.173 c 0.086,0.173 0.346,0.433 0.736,0.866 l 0.433,0.433 c 0,0 0.26,0.087 0.822,0.303 0.693,0.303 1.169,0.606 1.386,0.866 0.303,0.39 0.563,0.996 0.866,1.818 0,0.13 0.129,0.563 0.303,1.299 0.606,0.39 0.996,0.736 1.255,1.039 h 0.13 c 0.043,-0.216 0.173,-0.476 0.39,-0.693 l 0.13,0.043 c 0.086,0.13 0.303,0.346 0.563,0.649 0.217,0.173 0.52,0.433 0.953,0.779 0.043,0.13 -0.086,0.303 -0.346,0.52 -0.303,0.303 -0.477,0.476 -0.52,0.606 0.043,0.13 0.173,0.347 0.433,0.65 0.217,0.26 0.347,0.476 0.39,0.692 -0.043,0.086 -0.347,0.347 -0.866,0.736 h -0.173 c -0.303,-0.303 -0.563,-0.39 -0.736,-0.39 -0.086,0.129 -0.216,0.216 -0.347,0.26 0,0 -0.129,0.13 -0.389,0.433 -0.087,0.043 -0.39,0.39 -0.866,0.996 -0.043,0.13 0,0.303 0.13,0.563 l 0.823,1.688 c 0.043,-0.043 0.086,-0.043 0.13,-0.087 0.303,-0.13 0.779,-0.346 1.385,-0.606 0.347,-0.173 0.91,-0.39 1.732,-0.649 0.39,-0.216 0.953,-0.563 1.689,-1.083 0.563,-0.216 0.996,-0.303 1.299,-0.216 0.303,0.086 0.692,0.39 1.212,0.953 0,0 0.173,0.086 0.52,0.259 0.26,0.087 0.389,0.217 0.433,0.303 0.043,0.173 0,0.346 -0.086,0.606 -0.173,0.26 -0.26,0.433 -0.217,0.52 l 0.043,0.13 0.173,0.043 c 0.303,-0.129 0.779,-0.822 1.385,-2.078 0.433,-0.823 0.736,-1.342 0.91,-1.559 0.086,-0.173 0.303,-0.347 0.606,-0.606 0.26,-0.433 0.693,-1.126 1.212,-2.035 0.39,-0.433 0.909,-1.083 1.688,-1.905 0,0 0.13,-0.26 0.433,-0.693 0.173,-0.303 0.346,-0.52 0.563,-0.649 0.26,-0.13 0.606,-0.173 1.083,-0.087 0.173,0 0.39,0 0.693,0.043 0.26,0.043 0.649,0.216 1.126,0.476 0.303,0.043 0.822,0.087 1.515,0.043 0.26,0.043 0.692,0.13 1.255,0.216 0.347,0 0.779,-0.13 1.386,-0.389 0.086,-0.087 0.216,-0.13 0.39,-0.13 0.736,-0.433 1.299,-0.649 1.732,-0.736 0.13,0 0.346,0 0.649,0.043 0.26,-0.043 0.39,-0.043 0.433,-0.043 0,0 0.433,0.173 1.299,0.52 0.086,0.043 0.346,-0.086 0.692,-0.39 0.13,0 0.217,0 0.26,0.043 0.303,0.129 0.823,0.303 1.602,0.649 0.173,-0.043 0.433,-0.173 0.736,-0.433 0.303,-0.26 0.52,-0.347 0.692,-0.26 0.217,0.173 0.563,0.476 0.996,0.866 0.13,0.13 0.346,0.26 0.649,0.433 l 0.173,0.26 c -0.043,0.346 -0.173,0.649 -0.477,0.909 -0.26,0.303 -0.39,0.52 -0.39,0.693 l 0.173,0.043 c 0.13,-0.043 0.26,-0.13 0.39,-0.217 l 1.039,-1.342 0.303,-0.303 c 0.26,-0.303 0.563,-0.736 0.996,-1.342 l 0.13,-0.13 c 0.173,-0.13 0.433,-0.303 0.779,-0.52 -0.173,-0.433 -0.26,-0.909 -0.346,-1.429 l -0.043,-0.477 c -0.043,-0.303 -0.043,-0.52 -0.086,-0.649 -0.13,-0.649 -0.173,-0.996 -0.173,-1.039 0,-0.043 0,-0.043 0,-0.086 v -0.043 c 0,-0.043 0,-0.043 0.043,-0.086 l 0.823,-1.212 c 0.13,-0.13 0.303,-0.26 0.476,-0.39 0.953,-0.563 1.472,-0.953 1.602,-1.083 0.086,-0.216 0.173,-0.563 0.173,-0.953 0,-0.39 -0.087,-0.692 -0.217,-0.952 -0.086,-0.087 -0.563,-0.087 -1.429,-0.043 -0.043,0 -0.216,0.043 -0.606,0.13 -0.173,0.043 -0.39,0 -0.606,-0.086 -0.173,-0.087 -0.303,-0.173 -0.303,-0.173 -0.26,-0.303 -0.217,-0.736 0.13,-1.342 0.173,-0.303 0.433,-0.693 0.822,-1.169 0.087,-0.217 0.26,-0.477 0.52,-0.866 l 0.606,-0.606 c 0.043,-0.043 0.086,-0.173 0.13,-0.39 v -1.602 c -0.13,-0.693 -0.173,-1.212 -0.217,-1.559 0.043,-0.563 0.043,-0.996 0,-1.256 0,-0.129 0,-0.216 0.043,-0.303 0.173,-0.477 0.26,-0.779 0.346,-1.04 0.043,-0.389 0.087,-0.736 0.13,-0.909 0.303,-0.347 0.563,-0.693 0.693,-0.866 0.086,-0.13 0.173,-0.433 0.346,-0.953 0.13,-0.39 0.346,-0.649 0.649,-0.779 0.303,-0.173 0.606,-0.26 0.909,-0.173 0.433,0.043 0.693,0.087 0.779,0.043 0.216,-0.043 0.476,-0.216 0.823,-0.606 0.303,-0.173 0.909,-0.217 1.775,-0.043 1.386,0.087 2.511,-0.13 3.42,-0.606 0.173,-0.13 0.39,-0.26 0.649,-0.52 0.217,-0.259 0.477,-0.692 0.78,-1.255 0.086,-0.086 0.303,-0.216 0.563,-0.433 0.303,-0.173 0.52,-0.216 0.693,-0.173 0.13,0.043 0.303,0.173 0.606,0.39 0.433,0.303 0.78,0.216 1.039,-0.217 0.13,-0.173 0.217,-0.866 0.303,-2.121 0.043,-0.433 0.303,-1.299 0.823,-2.468 0.216,-0.823 0.433,-1.472 0.606,-1.818 0.26,-0.649 0.736,-1.083 1.386,-1.299 0.39,-0.173 1.472,-0.173 3.247,-0.043 0.173,0.043 0.39,0.087 0.736,0.173 0.086,0 0.303,-0.086 0.563,-0.173 0.173,-0.043 0.347,-0.043 0.52,-0.043 0.433,-1.342 0.649,-2.208 0.649,-2.684 -0.043,-0.086 -0.216,-0.26 -0.606,-0.476 -0.26,-0.217 -0.39,-0.39 -0.346,-0.606 0.216,-0.996 0.346,-1.559 0.346,-1.688 0.043,-0.39 -0.086,-0.649 -0.39,-0.779 -0.26,-0.087 -0.563,-0.173 -0.952,-0.26 -1.342,-0.347 -2.728,-0.433 -4.244,-0.303 -0.26,0 -0.433,-0.043 -0.476,-0.086 l -0.909,-1.126 c -0.216,-0.26 -0.173,-0.649 0.13,-1.169 0.433,-0.736 0.606,-1.125 0.606,-1.125 -0.043,-0.303 -0.346,-0.563 -0.952,-0.909 -0.779,-0.477 -1.559,-0.823 -2.295,-1.04 -0.346,-0.086 -0.563,-0.173 -0.563,-0.173 -0.52,-0.26 -0.91,-0.39 -1.126,-0.52 -1.169,-0.477 -1.732,-0.779 -1.818,-0.953 0.13,-0.606 0.216,-1.039 0.216,-1.256 -0.26,-0.519 -0.433,-0.866 -0.52,-1.169 -0.216,-0.909 -0.39,-1.559 -0.606,-1.948 l -0.087,-0.043 c -0.303,0 -0.996,0.087 -2.165,0.26 -0.303,0.043 -0.866,0.043 -1.646,0 -0.086,0 -0.216,-0.087 -0.39,-0.26 -0.216,-0.866 -0.303,-1.299 -0.303,-1.299 l -0.216,-0.736 0.13,-0.086 0.13,-0.087 c 0.26,0 0.649,-0.043 1.212,-0.13 0.433,-0.13 0.693,-0.346 0.736,-0.779 0.086,-0.39 -0.13,-0.866 -0.563,-1.429 -0.476,-0.303 -0.822,-0.563 -0.952,-0.779 -0.13,-0.13 -0.173,-0.347 -0.216,-0.563 0,-0.303 -0.043,-0.52 -0.087,-0.606 -0.303,-0.347 -0.476,-0.606 -0.52,-0.823 l -0.173,-0.086 c -0.39,0.606 -0.779,0.822 -1.125,0.649 -0.086,-0.217 -0.13,-0.347 -0.26,-0.347 -0.779,0.043 -1.256,-0.13 -1.386,-0.563 -0.043,-0.086 -0.043,-0.346 -0.043,-0.779 0,-0.433 0.086,-0.823 0.216,-1.169 0.043,-0.13 0.086,-0.26 0.13,-0.303 0.043,-0.259 0.086,-0.563 0.043,-0.866 -0.13,-0.13 -0.39,-0.216 -0.736,-0.26 -0.39,-0.086 -0.606,-0.173 -0.779,-0.303 -0.173,-0.173 -0.173,-0.52 0,-0.996 0.216,-0.563 0.26,-0.953 0.13,-1.126 l -0.476,-1.039 c 0.043,-0.26 0.13,-0.433 0.13,-0.563 -0.086,-0.433 -0.173,-0.736 -0.173,-0.866 -0.086,-0.779 -0.13,-1.255 -0.043,-1.472 0,-0.086 0.347,-0.476 1.04,-1.125 0.433,-0.477 0.692,-0.866 0.779,-1.256 l -0.043,-0.13 -0.13,-0.086 c -0.39,-0.13 -0.736,-0.043 -1.039,0.26 l -0.086,-0.086 c -0.043,-0.477 -0.043,-0.823 0.043,-1.04 0.086,-0.173 0.26,-0.389 0.477,-0.649 0.52,-0.779 0.606,-1.385 0.259,-1.731 l -0.39,-0.433 c -0.129,-0.13 -0.129,-0.303 -0.043,-0.476 0.13,-0.26 0.173,-0.433 0.173,-0.477 l -0.13,-0.26 c -0.043,-0.086 -0.346,-0.13 -0.866,-0.216 -0.433,-0.087 -0.649,-0.216 -0.649,-0.39 0.043,-0.39 0.043,-0.693 0.043,-0.866 -0.087,-0.909 -0.303,-1.645 -0.693,-2.122 -0.433,-0.216 -0.823,-0.346 -1.083,-0.346 -0.303,0 -0.52,0.043 -0.649,0.043 -0.303,-0.13 -0.563,-0.173 -0.693,-0.173 -0.649,-0.043 -1.125,-0.086 -1.429,-0.13 -0.39,-0.086 -0.649,-0.13 -0.866,-0.086 l -0.087,0.086 c -0.13,-0.303 -0.259,-0.52 -0.346,-0.693 l -0.173,-0.086 -0.476,0.043 -0.13,-0.087 c -0.043,-0.086 0,-0.26 0.086,-0.476 0.087,-0.26 0.173,-0.39 0.26,-0.477 0.173,-0.086 0.39,-0.086 0.736,0.043 -0.043,-0.303 -0.043,-0.52 0,-0.649 0.476,0.043 0.779,0 0.952,-0.13 0.217,-0.563 -0.043,-1.515 -0.822,-2.857 -0.13,-0.13 -0.217,-0.217 -0.26,-0.303 -0.043,-0.173 0.13,-0.476 0.563,-0.909 0.216,-0.217 0.259,-0.649 0.129,-1.342 0.087,-0.693 0.217,-1.256 0.347,-1.646 -1.125,-0.086 -1.732,-0.13 -1.732,-0.086 l -0.996,0.909 c -0.173,0.13 -0.303,0.086 -0.477,-0.043 -0.649,-0.433 -1.385,-0.78 -2.208,-1.04 -0.086,0 -0.173,-0.086 -0.26,-0.173 -0.043,-0.087 0.043,-0.477 0.303,-1.256 0.087,-0.043 0.52,-0.086 1.299,-0.086 0.134,-0.087 0.091,-0.261 0.005,-0.521",
			"Dnipropetrovsk": "m 387.853,173.255 0.216,0.563 c 0,0.476 -0.346,0.952 -0.909,1.429 -0.649,0.52 -0.996,0.909 -1.039,1.083 0,0.173 0.13,0.26 0.346,0.303 l 0.303,-0.086 0.173,0.086 c 0.086,0.303 0,0.477 -0.217,0.563 -0.779,0 -1.299,0.173 -1.559,0.52 -0.043,0.043 -0.26,0.606 -0.649,1.688 -0.043,0.13 -0.13,0.303 -0.303,0.606 -0.26,0.692 -0.303,1.212 -0.043,1.515 0.087,0.086 0.26,0.216 0.477,0.39 0.433,0.433 0.649,0.736 0.649,0.953 v 0.173 l 0.087,0.779 -0.043,0.173 c -0.173,0.087 -0.303,0.087 -0.477,-0.043 l -0.173,0.043 c 0,0.26 -0.087,0.477 -0.26,0.606 -0.173,0.173 -0.26,0.39 -0.303,0.736 0,0.173 0,0.303 0,0.303 l 0.649,0.476 0.043,0.13 c -0.259,0.433 -0.649,0.823 -1.255,1.212 0,0 0,0 0.043,0 0.433,0.216 1.083,0.649 1.905,1.342 0.13,0.13 0.303,0.303 0.52,0.563 0.173,0.173 0.476,0.346 0.909,0.563 0.26,0.216 0.563,0.52 0.952,0.952 0.433,0.347 0.823,0.52 1.169,0.606 0.129,0.043 0.39,0.13 0.736,0.173 0.173,0.13 0.39,0.39 0.649,0.866 0.26,0.52 0.433,0.823 0.606,0.953 0.173,0.13 0.519,0.303 1.082,0.433 0.433,0.087 0.779,0.347 1.083,0.693 0.303,0.39 0.26,0.823 -0.043,1.256 0.13,0.216 0.26,0.346 0.39,0.39 l 0.779,0.173 c 0.13,0.043 0.39,0.087 0.736,0.087 0.173,0.043 0.476,0.216 0.866,0.476 0.477,0.173 0.779,0.26 0.823,0.346 1.039,0.823 1.646,1.256 1.818,1.342 l -0.216,0.347 1.645,0.563 c 0.39,0.217 0.953,0.043 1.602,-0.39 0.173,-0.13 0.736,-0.173 1.689,-0.173 0.52,0 1.125,0.173 1.861,0.52 0.087,0.086 0.606,0.303 1.559,0.736 0.216,0.173 0.692,0.433 1.429,0.779 0.173,0.173 0.26,0.39 0.26,0.736 -0.043,0.173 -0.043,0.476 -0.086,0.909 0,0.433 0.216,0.779 0.736,0.996 0.26,0.13 0.52,0.476 0.736,1.039 0.043,0.173 0.087,0.736 0.087,1.646 0,0.649 0.043,1.039 0.13,1.212 0.476,0.866 0.736,1.342 0.736,1.429 0.086,0.563 0.26,1.083 0.52,1.645 0.26,0.52 0.173,1.126 -0.303,1.775 -0.347,0.563 -0.39,1.212 0,2.078 0.216,0.52 0.129,0.909 -0.303,1.083 0.13,-0.043 0.216,-0.043 0.303,-0.086 0.043,0 0.129,-0.043 0.259,-0.087 l 1.646,-0.303 0.216,0.043 c 0.26,0 0.477,0.043 0.65,0.173 1.082,0.563 1.688,0.909 1.905,0.996 0.216,0.13 1.169,0.217 2.771,0.39 0.39,0.087 0.996,0.217 1.775,0.39 0.043,0 0.173,0.043 0.26,0.13 0.346,0.173 0.779,0.173 1.385,-0.043 0.216,-0.043 0.433,-0.303 0.649,-0.823 0.52,-0.433 1.299,-0.736 2.251,-0.996 0.736,-0.173 1.212,-0.129 1.472,0.13 0.13,0.13 0.433,0.519 0.866,1.083 0.043,0.043 0.563,0.129 1.646,0.346 0.173,0 0.346,0.26 0.563,0.649 0.216,0.39 0.39,0.606 0.649,0.649 0.043,-0.043 0.216,-0.13 0.476,-0.26 0.173,-0.13 0.346,-0.217 0.52,-0.303 1.126,-0.563 2.122,-0.866 2.857,-0.779 0.433,0 0.606,0.173 0.563,0.433 -0.173,0.822 -0.173,1.342 0.043,1.645 -0.086,0.39 -0.043,0.65 0,0.866 0.346,0.173 0.909,-0.13 1.732,-0.953 0.086,-0.043 0.173,-0.043 0.303,-0.043 0.087,0.087 0.13,0.217 0.173,0.433 0,0.173 -0.173,0.433 -0.433,0.736 -0.303,0.303 -0.433,0.563 -0.433,0.779 0.086,0.043 0.216,0.13 0.476,0.13 0.303,0.043 0.477,0.086 0.52,0.173 0.217,0.433 0.26,0.996 0.173,1.688 0,0.087 0,0.217 -0.043,0.39 0.346,-0.043 0.563,0.043 0.649,0.303 0.13,0.346 0.173,0.477 0.217,0.477 0.043,0 0.173,-0.087 0.303,-0.26 0.087,-0.087 0.303,-0.087 0.606,-0.087 l 0.043,0.13 c -0.13,0.303 -0.173,0.563 -0.087,0.823 0.087,0.216 0.13,0.346 0.087,0.39 -0.26,0.606 -0.433,1.169 -0.563,1.732 l -0.087,0.173 c -0.13,0.13 -0.303,0.043 -0.52,-0.173 -0.216,-0.26 -0.39,-0.39 -0.563,-0.303 0,0.476 0,0.736 0.043,0.736 l 0.347,0.129 0.086,0.13 c -0.043,0.216 -0.043,0.346 0,0.476 0.216,-0.043 0.39,0 0.52,0.13 v 0.173 l 0.086,0.13 c 0.866,0.086 1.472,0 1.905,-0.216 0.13,-0.13 0.26,-0.477 0.346,-0.996 0.173,-0.086 0.477,-0.13 0.953,-0.086 l 0.086,0.086 c 0.087,0.433 0.087,0.736 0.13,0.953 0,0.13 0,0.26 0.043,0.476 0.086,0.043 0.433,0.086 0.996,0.086 0.086,0.043 0.26,0.173 0.52,0.433 0.216,0.216 0.52,0.303 0.866,0.303 l 0.866,-0.173 c 0.129,-0.13 0.216,-0.433 0.303,-0.823 0.173,-0.173 0.39,-0.259 0.649,-0.303 0.39,0 0.606,0.043 0.693,0.216 0.13,0.26 0.26,0.433 0.303,0.477 0.346,-0.087 0.779,-0.13 1.429,-0.13 0.043,0 0.086,0 0.13,0 0.346,-0.086 0.823,-0.216 1.429,-0.346 0.563,-0.086 1.429,-0.26 2.555,-0.39 0.043,-0.13 0,-0.563 -0.217,-1.212 l -0.086,-0.086 -0.909,-0.173 c -0.13,-0.13 -0.173,-0.346 -0.13,-0.649 0,-0.303 0,-0.52 0.086,-0.693 l 0.217,-0.13 c 0.346,0 0.606,0.043 0.822,0 l 0.13,-0.346 c 1.169,0 1.819,-0.043 1.905,-0.13 0,-0.043 -0.216,-0.52 -0.606,-1.429 -0.086,-0.217 -0.519,-0.346 -1.299,-0.433 l -0.043,-0.13 c 0.173,-0.52 0.216,-0.779 0.216,-0.909 -0.216,-0.26 -0.303,-0.39 -0.303,-0.476 0.217,-0.433 0.303,-1.083 0.217,-1.862 -0.087,-0.78 -0.043,-1.342 0.129,-1.646 0.347,-0.216 0.65,-0.303 0.953,-0.26 l 0.217,0.043 c 0.216,-0.043 0.563,-0.173 0.996,-0.303 0.087,-0.043 0.433,0.086 1.169,0.303 0.13,0.043 0.39,0.086 0.649,0.13 0.26,0.086 0.433,0.216 0.563,0.39 l 0.087,0.476 c 0.086,0.13 0.303,0.303 0.736,0.39 0.173,0.043 0.433,0.13 0.779,0.173 0.13,0.043 0.303,0.173 0.563,0.39 l 0.649,0.26 c 0.173,0.043 0.693,-0.303 1.645,-1.126 0.303,-0.303 0.347,-0.909 0.13,-1.948 -0.13,-0.216 -0.216,-0.39 -0.216,-0.52 -0.13,-0.346 -0.26,-1.082 -0.433,-2.251 -0.043,-0.13 0,-0.216 0.087,-0.303 0.086,-0.086 0.39,-0.173 0.952,-0.259 0.39,-0.087 0.649,-0.347 0.693,-0.736 0.043,-0.26 0,-0.779 -0.13,-1.515 l -0.173,-1.039 c 0,-0.26 -0.043,-0.477 -0.087,-0.606 -0.086,-0.346 -0.13,-0.563 -0.173,-0.736 l -0.043,-0.823 -0.087,-0.086 c -0.216,-0.13 -0.563,-0.173 -1.039,-0.173 0,-0.216 -0.043,-0.433 -0.13,-0.563 -0.086,-0.13 -0.303,-0.13 -0.563,-0.043 -0.259,0.043 -0.433,0.129 -0.563,0.216 h -0.173 c -0.086,-0.043 -0.13,-0.087 -0.13,-0.216 -0.13,-0.26 -0.13,-0.52 -0.043,-0.866 0.13,-0.476 0.173,-0.736 0.173,-0.909 0,-0.087 -0.043,-0.563 -0.13,-1.386 -0.216,-0.476 -0.26,-0.866 -0.26,-1.082 v -0.13 c 0.693,-0.173 1.169,-0.477 1.342,-0.823 -0.346,-0.13 -0.563,-0.26 -0.649,-0.476 0.216,-0.477 0.26,-0.953 0.086,-1.516 l 0.779,-0.433 0.043,-0.13 c -0.173,-0.52 -0.303,-0.866 -0.303,-0.996 0.043,-0.13 0.39,-0.303 1.169,-0.52 0.087,-0.087 0.087,-0.433 0.043,-1.039 -0.043,-0.649 -0.13,-1.083 -0.216,-1.299 l -0.13,-0.13 c -0.217,0 -0.563,0 -1.083,0.043 -0.52,0.043 -0.866,0.087 -0.996,0.173 -0.043,1.385 -0.26,2.035 -0.649,2.078 -0.606,0 -0.952,0.043 -1.125,0.13 l -0.043,-0.086 c -0.173,-0.953 -0.13,-1.516 0,-1.646 l 0.563,-0.13 c 0,-0.476 0.13,-0.736 0.346,-0.866 0.087,-0.043 0.26,-0.13 0.433,-0.217 -0.043,-0.303 -0.13,-0.476 -0.303,-0.52 -0.606,0.173 -1.082,0.26 -1.342,0.217 l -0.13,-0.087 c -0.087,-0.606 -0.173,-0.953 -0.26,-1.039 -1.126,0.13 -1.819,0.173 -2.035,0.217 l -0.26,0.649 -0.217,0.173 -1.602,0.13 c -0.13,0 -0.217,-0.13 -0.39,-0.346 -0.173,-0.26 -0.303,-0.433 -0.303,-0.433 -0.52,-0.433 -0.823,-0.649 -0.866,-0.649 -0.173,-0.086 -0.26,-0.13 -0.346,-0.13 -0.693,-0.433 -1.083,-0.649 -1.125,-0.693 l -0.13,0.043 c -0.476,0.303 -0.822,0.606 -0.996,0.823 -0.476,0.606 -0.822,1.039 -1.039,1.342 l -0.433,0.433 c -0.216,0.216 -0.476,0.649 -0.866,1.299 l -0.087,0.173 0.043,0.13 c 0.346,0.217 0.606,0.39 0.736,0.52 l -0.563,0.217 c -0.303,0.303 -0.563,0.476 -0.693,0.433 -0.39,-0.39 -0.649,-0.606 -0.823,-0.649 -0.39,0.52 -0.649,0.823 -0.822,0.866 l -0.606,-0.606 c 0.52,-0.649 0.909,-1.125 1.169,-1.429 -0.26,-0.39 -0.692,-0.779 -1.299,-1.212 l -0.043,-0.173 c 0.346,-0.563 0.606,-1.04 0.692,-1.342 -0.216,-0.477 -0.692,-0.909 -1.299,-1.429 -0.866,-0.649 -1.385,-1.083 -1.516,-1.212 -0.433,-0.476 -0.822,-0.823 -1.125,-1.039 -0.433,-0.217 -0.649,-0.347 -0.693,-0.39 -0.043,-0.087 -0.043,-0.26 0.043,-0.433 0.086,-0.216 0.13,-0.346 0.217,-0.346 0.779,-0.477 1.082,-0.866 0.996,-1.212 -0.173,-0.217 -0.433,-0.347 -0.779,-0.433 -0.26,-0.043 -0.433,-0.13 -0.52,-0.26 -0.173,-0.563 -0.39,-0.866 -0.649,-0.953 l -0.043,-0.086 c -0.043,-0.13 -0.216,-0.173 -0.477,-0.173 -0.259,-0.043 -0.433,-0.086 -0.519,-0.216 0.13,-0.346 0.173,-0.563 0.13,-0.693 -0.736,-0.043 -1.169,-0.13 -1.299,-0.26 -0.433,-0.563 -0.736,-0.779 -0.909,-0.779 -0.736,0.13 -1.169,0.173 -1.212,0.13 l -0.086,-0.086 c 0,-0.26 0.173,-0.477 0.563,-0.649 0.476,-0.26 0.736,-0.39 0.779,-0.433 0.173,-0.26 0.39,-0.606 0.563,-0.996 l -0.043,-0.129 c -0.649,-0.606 -0.953,-0.996 -0.909,-1.083 l 0.043,-0.39 c 0.043,-0.217 0.13,-0.39 0.26,-0.563 -0.173,-0.217 -0.52,-0.476 -0.953,-0.779 -0.52,-0.303 -0.823,-0.52 -1.039,-0.52 -0.217,0.173 -0.347,0.303 -0.433,0.346 -0.433,0.13 -0.693,0.173 -0.909,0.26 -0.26,0.086 -0.649,0.26 -1.169,0.563 -0.52,0.346 -0.823,0.476 -0.909,0.433 -0.477,0.303 -0.736,0.476 -0.866,0.563 l -0.13,-0.043 -0.13,-0.26 -0.086,-0.087 -0.086,-0.043 c -0.173,-0.087 -0.303,-0.173 -0.433,-0.217 -0.433,0.087 -0.779,0.043 -0.996,-0.13 -0.173,-0.13 -0.303,-0.216 -0.346,-0.26 -0.13,-0.086 -0.26,-0.086 -0.347,-0.043 -0.346,0.303 -0.563,0.433 -0.606,0.433 -0.13,0 -0.216,-0.086 -0.303,-0.303 -0.13,-0.173 -0.217,-0.303 -0.303,-0.303 -0.217,-0.086 -0.477,-0.086 -0.736,0 -0.259,0.043 -0.476,0.043 -0.606,0 -0.39,-0.477 -0.736,-0.779 -0.996,-0.909 -0.347,0.26 -0.563,0.346 -0.65,0.346 l -1.385,-0.26 c -0.13,-0.043 -0.39,0 -0.736,0.13 -0.303,0.087 -0.563,0.13 -0.693,0.043 -0.043,0 -0.39,-0.347 -0.996,-0.909 -0.39,-0.39 -0.779,-0.65 -1.083,-0.866 -0.476,-0.086 -0.822,-0.26 -0.996,-0.39 -0.563,-0.823 -0.996,-1.299 -1.255,-1.429 -0.52,-0.346 -0.823,-0.52 -0.78,-0.52 0,-0.086 0.043,-0.303 0.087,-0.563 l -0.087,-0.13 c -0.649,-0.216 -0.996,-0.346 -1.039,-0.346 l -0.173,-0.216 c -0.649,-0.477 -1.039,-0.78 -1.083,-0.866 -0.087,-0.433 -0.173,-0.693 -0.26,-0.736 -0.779,-0.649 -1.385,-0.996 -1.818,-1.082 -0.303,0.043 -0.52,0.043 -0.649,0.043 -0.303,-0.086 -0.477,-0.13 -0.606,-0.173 -0.13,0 -0.476,0.043 -1.039,0.26 l -0.173,-0.043 c -0.173,-0.346 -0.303,-0.52 -0.433,-0.563 -0.26,0 -0.433,0.087 -0.606,0.217 -0.173,0.216 -0.346,0.346 -0.433,0.346 -0.303,0 -0.563,-0.173 -0.78,-0.52 -0.043,0 -0.043,0 -0.043,0.043 -1.083,-0.823 -1.818,-1.083 -2.295,-0.736 l -0.13,0.347 c -0.086,0.52 -0.173,0.822 -0.216,0.866 -0.13,0.303 -0.347,0.433 -0.693,0.433 -0.173,0 -0.346,-0.087 -0.433,-0.303 -0.043,-0.26 0.13,-0.476 0.477,-0.693 v -0.173 c -0.087,-0.13 -0.347,-0.26 -0.693,-0.39 -0.39,-0.173 -0.649,-0.26 -0.736,-0.217 -0.173,0.303 -0.303,0.477 -0.346,0.52 -0.39,-0.216 -0.649,-0.26 -0.866,-0.173 -0.563,0.173 -0.953,0.39 -1.039,0.649 -0.173,0.346 -0.26,0.52 -0.347,0.563 -0.823,0.216 -1.385,0.39 -1.775,0.476 -0.606,0.26 -1.04,0.39 -1.342,0.433 -0.563,0 -0.866,0.043 -0.953,0.086 -0.303,0.173 -0.476,0.303 -0.606,0.39 -0.606,0.216 -1.039,0.433 -1.342,0.606 -0.477,0.303 -0.866,0.563 -1.083,0.693 -0.39,0.303 -0.649,0.476 -0.866,0.563 -0.303,0.173 -0.606,0.173 -0.953,0.086 -0.52,-0.216 -0.779,-0.303 -0.823,-0.303 -0.127,-0.002 -0.17,0.084 -0.213,0.214 m -15.155,11.128 c -0.043,0.216 -0.086,0.346 -0.086,0.346 -0.043,0.086 -0.216,0.086 -0.476,0.13 -0.087,0.043 -0.13,0.173 -0.173,0.346 l -0.043,0.433 -0.129,0.043 -0.13,-0.087 h -0.173 c 0,0.173 -0.087,0.477 -0.26,0.953 -0.173,0.476 -0.303,0.779 -0.433,0.823 -0.216,-0.086 -0.346,-0.13 -0.433,-0.217 0.087,-0.259 0.087,-0.476 0,-0.692 l -0.13,-0.087 c 0.087,-0.433 0.043,-0.736 -0.043,-0.822 l -0.13,-0.087 -0.13,0.087 c -0.13,0.563 -0.26,0.909 -0.39,0.996 h -0.173 l -0.13,-0.13 c -0.043,-0.086 0,-0.303 0.043,-0.606 0.087,-0.347 0.087,-0.52 0.043,-0.606 -0.39,-0.13 -0.649,-0.173 -0.779,-0.13 -0.086,0.087 -0.303,0.347 -0.563,0.866 -0.173,0.26 -0.476,0.346 -0.952,0.216 -0.043,-0.52 -0.173,-0.823 -0.347,-0.996 -0.39,-0.087 -0.606,-0.13 -0.736,-0.087 -0.173,0.087 -0.26,0.26 -0.303,0.606 l -0.13,0.086 -0.173,-0.043 h -0.13 c -0.129,0.303 -0.216,0.52 -0.303,0.649 h -0.087 c -0.173,-0.173 -0.346,-0.26 -0.606,-0.303 -0.043,-0.087 -0.086,-0.217 -0.043,-0.303 l -0.086,-0.13 c -0.346,-0.043 -0.52,0 -0.606,0.216 -0.043,0.26 -0.13,0.52 -0.217,0.693 l -0.13,0.043 h -0.173 l -0.13,0.086 c 0.043,0.563 0.217,0.909 0.433,1.083 0.346,0.086 0.563,0.39 0.649,0.953 0.13,0.13 0.26,0.26 0.346,0.26 l 1.516,0.216 c 0.173,0 0.347,0.13 0.649,0.39 0.26,0.217 0.476,0.303 0.649,0.303 0.693,0 1.299,0 1.775,0.043 l 0.13,0.086 c 0.043,0.173 0.13,0.39 0.173,0.736 0.822,0.173 1.299,0.26 1.559,0.39 l 0.086,0.087 c -0.173,0.563 -0.346,0.822 -0.563,0.866 -0.692,0.043 -1.039,0.043 -1.082,0.086 -0.217,0.39 -0.433,0.65 -0.563,0.78 l -0.649,0.52 c -0.433,0.303 -1.126,0.649 -2.079,1.082 -0.779,0.303 -1.212,0.52 -1.255,0.52 l -0.043,0.043 c -0.216,0.173 -0.433,0.433 -0.606,0.779 -0.13,0.303 -0.26,0.477 -0.347,0.477 -0.086,0.043 -0.216,0 -0.303,-0.043 -0.087,-0.086 -0.087,-0.216 -0.087,-0.433 l -0.086,-0.043 c -0.173,0.13 -0.692,0.346 -1.559,0.649 -0.823,0.303 -1.472,0.606 -1.862,0.996 -0.173,0.13 -0.26,0.216 -0.303,0.303 -0.043,0.346 0.043,0.692 0.26,0.996 l 0.519,-0.043 c -0.216,0.389 -0.129,0.909 0.173,1.602 0.347,0.693 0.476,1.083 0.476,1.169 l -0.086,0.13 -0.433,0.13 -0.087,0.173 c 0.173,0.26 0.216,0.52 0.216,0.736 0.043,0.086 0.217,0.13 0.433,0.13 -0.043,0.39 0.043,0.909 0.217,1.602 0.043,0.216 0.086,0.822 0.086,1.818 0.043,0.606 0.043,0.953 0.086,1.125 0.477,0.087 0.693,0.217 0.78,0.347 0,0.173 -0.087,0.736 -0.217,1.602 -0.086,0.866 -0.216,1.299 -0.26,1.342 h -1.212 c -0.13,0.433 -0.26,0.693 -0.433,0.91 -0.606,0.346 -0.996,0.563 -1.039,0.779 -0.13,0.26 -0.216,0.433 -0.303,0.563 -0.347,0.606 -0.823,0.649 -1.342,0.173 -0.087,-0.173 -0.173,-0.303 -0.216,-0.347 -0.087,-0.086 -0.173,-0.129 -0.303,-0.173 l -0.13,0.086 c -0.043,0.347 -0.087,0.563 -0.13,0.649 -0.649,0.477 -1.082,0.91 -1.342,1.386 -0.26,0.953 -0.52,1.559 -0.649,1.775 l -0.13,0.087 c -0.13,-0.043 -0.26,-0.26 -0.347,-0.693 -0.086,-0.39 -0.086,-0.649 -0.043,-0.779 l 0.26,-0.347 c 0,-0.563 -0.087,-1.082 -0.347,-1.602 -0.216,-0.043 -0.346,0 -0.433,0.086 0,0.216 -0.043,0.476 -0.087,0.909 -0.043,0.173 -0.13,0.52 -0.26,0.909 0,0.303 0.043,0.606 0.087,0.909 0,0.13 0,0.217 0,0.347 -0.043,0.173 -0.087,0.433 -0.173,0.649 -0.043,0.173 -0.086,0.26 -0.173,0.346 -0.26,0.13 -0.693,0.173 -1.299,0.086 -0.563,-0.043 -0.866,-0.043 -0.952,0 -0.043,0.26 -0.13,0.433 -0.26,0.563 -0.52,0.043 -0.822,0.173 -0.909,0.476 -0.173,0.563 -0.303,0.866 -0.346,0.996 l -0.26,0.13 -0.563,-0.043 c -0.173,0.13 -0.346,0.606 -0.433,1.342 -0.173,0.823 -0.26,1.342 -0.303,1.516 h 0.13 c 0.13,0.13 0.216,0.216 0.26,0.303 -0.477,0.996 -0.693,1.602 -0.649,1.818 0,0.086 0.129,0.216 0.346,0.26 0.26,0.043 0.649,-0.043 1.125,-0.13 0.043,0.043 0.087,0.216 0.173,0.52 0.086,0.26 0.086,0.433 0.086,0.52 -0.303,0.26 -0.433,0.433 -0.476,0.563 -0.086,0.217 -0.086,0.649 0,1.169 0,0.13 -0.086,0.346 -0.173,0.606 -0.129,0.216 -0.129,0.476 -0.129,0.909 l 0.086,0.996 c 0,0.217 0,0.65 -0.086,1.429 0.129,0.086 0.433,0.303 0.909,0.563 0.087,0.087 0.087,0.433 0.087,1.039 -0.043,0 -0.39,0.043 -1.126,0.13 h -0.303 c -1.212,0.303 -1.819,0.563 -1.905,0.736 0.043,0.173 0.303,0.649 0.779,1.559 0.303,0.606 0.477,1.169 0.477,1.602 0,0.173 -0.173,0.433 -0.52,0.779 -0.347,0.346 -0.52,0.649 -0.477,0.909 0.043,0.26 0.26,0.39 0.606,0.477 1.256,0.13 2.035,0.259 2.338,0.303 0.952,0.217 1.688,0.433 2.294,0.649 l 0.52,0.52 c 0.303,0.216 1.039,0.346 2.294,0.26 0.39,-0.043 0.693,0.173 0.866,0.606 0.13,0.216 0.26,0.563 0.39,1.083 0.043,0.13 0.26,0.346 0.606,0.606 0.26,0.216 0.563,0.303 0.779,0.26 l 0.13,-0.086 c 0,-0.39 0.087,-0.649 0.173,-0.779 l 0.13,-0.087 1.515,-0.26 c 1.516,-0.216 2.295,-0.52 2.295,-0.866 -0.086,-0.433 -0.13,-0.779 -0.086,-0.996 0.043,-0.129 0.476,-0.26 1.342,-0.433 0.823,-0.173 1.299,-0.173 1.342,0 0.217,0.39 0.303,0.606 0.217,0.693 -0.303,0.563 -0.477,0.909 -0.433,1.039 0,0.043 0.043,0.173 0.13,0.26 0.043,0.13 0.13,0.39 0.173,0.779 l 0.086,0.086 c 0.086,0 0.433,-0.086 1.039,-0.26 l 0.173,0.043 c 0,0.043 0.086,0.26 0.26,0.779 0.13,0.346 0.26,0.52 0.39,0.52 1.472,-0.043 2.338,-0.087 2.598,-0.173 2.122,-0.736 3.507,-1.082 4.157,-1.169 0.216,0 0.563,-0.043 0.996,-0.043 0.043,0 0.13,0.043 0.303,0.13 0,-0.13 0.043,-0.26 0.043,-0.347 0,-0.346 -0.043,-0.649 -0.043,-0.866 0,-0.39 0.043,-0.65 0.173,-0.736 l 0.173,0.043 c 0.173,0.13 0.39,0.476 0.563,0.996 l 0.173,0.043 c 0.173,-0.13 0.39,-0.303 0.649,-0.606 0.173,-0.129 0.52,-0.216 0.952,-0.346 0.087,-0.043 0.173,-0.173 0.303,-0.346 0.52,-0.476 1.083,-0.649 1.688,-0.52 0.303,0.086 0.563,0.173 0.736,0.346 0.216,0.173 0.476,0.563 0.736,1.169 0.26,0.52 0.477,0.823 0.606,0.866 0.173,0.043 0.303,0 0.477,-0.173 0.173,-0.173 0.346,-0.216 0.476,-0.173 0.303,0.217 0.477,0.347 0.52,0.347 0.259,0.086 0.433,0 0.606,-0.26 0.043,-0.13 0.173,-0.39 0.303,-0.649 0.043,-0.13 0.173,-0.217 0.347,-0.26 0.303,-0.173 0.433,-0.563 0.26,-1.039 -0.043,-0.173 -0.216,-0.39 -0.52,-0.649 -0.303,-0.303 -0.433,-0.52 -0.433,-0.779 0.043,-0.173 0.173,-0.26 0.303,-0.26 0.346,0.087 0.692,0.087 1.039,0.043 0.086,0.043 0.173,0.13 0.173,0.216 0.043,0.086 -0.043,0.26 -0.173,0.606 -0.087,0.216 -0.087,0.476 0.043,0.649 0.13,0.173 0.259,0.216 0.346,0.26 0.173,-0.087 0.346,-0.216 0.606,-0.433 h 0.173 c 0.086,0.043 0.303,0.173 0.606,0.433 0.173,0.086 0.519,0.173 1.039,0.346 0.216,0.216 0.476,0.563 0.736,1.083 0.173,0.043 0.346,0.043 0.476,0 0.217,-0.433 0.347,-0.736 0.477,-0.866 0.086,-0.086 0.433,-0.129 0.996,-0.173 0.433,0 0.606,-0.173 0.52,-0.477 -0.303,-0.346 -0.476,-0.606 -0.606,-0.822 0.043,-0.217 0.346,-0.347 0.952,-0.433 0.13,0 0.39,0 0.693,0.086 0.217,0 0.563,0 0.996,-0.043 0.13,0 0.433,-0.087 0.823,-0.303 0.346,-0.13 0.649,-0.173 0.909,-0.173 0.433,0.043 0.823,0.26 1.212,0.606 0.433,0.433 0.779,0.649 1.039,0.779 0.216,0.086 0.563,0.13 1.039,0.173 0.216,0.086 0.476,0.26 0.866,0.519 0.26,0 0.649,-0.043 1.126,-0.086 0.173,0.043 0.433,0.086 0.736,0.173 0.736,0.043 1.126,0.086 1.256,0.13 0.129,0.043 0.303,0.13 0.563,0.303 0.216,0.173 0.39,0.26 0.563,0.26 0.173,0 0.39,0 0.649,-0.043 0.259,-0.043 0.477,-0.043 0.649,-0.043 0.043,-0.13 0.086,-0.216 0.086,-0.39 0.087,-0.476 0.087,-0.822 0.043,-0.909 -0.086,-0.173 -0.39,-0.477 -0.996,-0.866 v -0.173 l 0.52,-1.472 c 0.173,-0.953 0.303,-1.602 0.39,-2.078 0.13,-0.303 0.216,-0.52 0.26,-0.649 0.26,-0.909 0.346,-1.689 0.346,-2.468 -0.476,-0.087 -0.822,-0.173 -1.039,-0.217 l -0.736,-0.216 -0.043,-0.087 c 0.043,-0.13 0.087,-0.216 0.087,-0.39 0.086,-0.346 0.129,-0.52 0.129,-0.606 -0.129,-0.52 -0.173,-0.823 -0.173,-0.909 0.39,-0.52 0.563,-0.909 0.563,-1.169 -0.173,-0.26 -0.346,-0.39 -0.519,-0.476 -0.736,-0.347 -1.213,-0.65 -1.472,-0.78 -0.433,-0.346 -0.693,-0.52 -0.736,-0.563 -0.13,-0.217 -0.173,-0.477 -0.13,-0.866 0.043,-0.433 0.173,-0.736 0.39,-0.866 l 0.346,-0.043 c 0.087,-0.13 0.217,-0.303 0.433,-0.649 0.52,-0.173 1.126,-0.26 1.819,-0.303 0.086,-0.086 0.129,-0.346 0.216,-0.736 0.086,-0.563 -0.13,-0.909 -0.693,-1.039 -0.736,-0.13 -1.169,-0.347 -1.299,-0.563 -0.043,0 -0.087,-0.39 -0.173,-1.083 l -0.13,-0.043 h -0.649 c -0.13,-0.173 -0.173,-0.39 -0.13,-0.779 l 0.087,-0.086 0.563,-0.173 c 0.087,-0.086 0.173,-0.649 0.217,-1.688 0.086,-0.173 0.129,-0.26 0.129,-0.346 -0.129,-0.39 -0.259,-0.693 -0.303,-0.909 -0.173,-0.39 -0.216,-0.693 -0.13,-0.953 0.173,-0.13 0.52,-0.173 1.082,-0.13 l 0.087,0.13 c -0.087,0.433 -0.043,0.953 0.087,1.646 0.129,0.086 0.259,0.086 0.346,0.129 1.515,-0.043 2.338,-0.086 2.511,-0.216 0.216,-0.173 0.649,-0.693 1.385,-1.645 0.303,0.13 0.649,0.173 1.039,0.173 0.173,-0.043 0.52,-0.086 1.039,-0.216 0.087,-0.043 0.477,0 1.083,0.086 l 0.347,0.043 c 0.303,0 0.606,0 0.822,0 0.087,0 0.173,0 0.217,0 0.433,-0.173 0.52,-0.563 0.303,-1.083 -0.39,-0.866 -0.347,-1.515 0,-2.078 0.476,-0.649 0.563,-1.255 0.303,-1.775 -0.26,-0.563 -0.433,-1.083 -0.52,-1.645 0,-0.087 -0.26,-0.563 -0.736,-1.429 -0.087,-0.173 -0.13,-0.563 -0.13,-1.212 0,-0.909 -0.043,-1.472 -0.087,-1.646 -0.216,-0.563 -0.476,-0.909 -0.736,-1.039 -0.52,-0.216 -0.736,-0.563 -0.736,-0.996 0.043,-0.433 0.043,-0.736 0.086,-0.909 0,-0.347 -0.086,-0.563 -0.26,-0.736 -0.736,-0.346 -1.212,-0.606 -1.429,-0.779 -0.953,-0.433 -1.472,-0.649 -1.559,-0.736 -0.736,-0.347 -1.342,-0.52 -1.861,-0.52 -0.953,0 -1.516,0.043 -1.689,0.173 -0.649,0.433 -1.212,0.606 -1.602,0.39 l -1.645,-0.563 -0.173,0.26 c -0.649,-0.26 -1.125,-0.477 -1.429,-0.606 -0.26,-0.173 -0.476,-0.303 -0.693,-0.433 -0.13,-0.13 -0.259,-0.26 -0.346,-0.26 -1.126,-0.303 -1.905,-0.52 -2.294,-0.649 -0.693,-0.303 -1.212,-0.476 -1.516,-0.563 l -0.606,-0.13 c -0.519,0.086 -0.952,0.043 -1.212,-0.087 -0.173,-0.086 -0.303,-0.39 -0.303,-0.866 -0.086,-0.563 -0.173,-0.953 -0.303,-1.126 -0.173,-0.13 -0.563,-0.26 -1.255,-0.346 -0.736,-0.086 -1.212,-0.216 -1.429,-0.39 -0.26,-0.216 -0.39,-0.52 -0.433,-0.866 0,-0.433 -0.13,-0.736 -0.26,-0.953 -0.217,-0.13 -0.346,-0.26 -0.433,-0.347 l -0.303,-0.346 c -0.043,-0.086 -0.087,-0.13 -0.087,-0.13 -1.255,0.043 -2.294,-0.216 -3.031,-0.736 -0.216,-0.173 -0.433,-0.563 -0.736,-1.212 -0.303,-0.693 -0.649,-1.169 -1.04,-1.472 -0.259,-0.13 -0.476,-0.173 -0.649,-0.13 -0.476,0.173 -0.822,0.303 -1.083,0.39 -0.433,0.13 -0.822,0.086 -1.039,-0.26 -0.086,-0.216 -0.129,-0.39 -0.129,-0.52 -0.13,-0.39 -0.217,-0.649 -0.39,-0.736 -0.217,-0.173 -0.477,-0.346 -0.693,-0.52 -0.347,-0.173 -0.52,-0.303 -0.52,-0.303 -0.217,0.13 -0.347,0.346 -0.477,0.563 -0.173,0.433 -0.26,0.65 -0.26,0.693 -0.13,0.13 -0.173,0.216 -0.216,0.216 -0.086,0.087 -0.173,0.13 -0.216,0.173 l -0.303,-0.13 c -0.13,-0.26 -0.173,-0.39 -0.173,-0.433 -0.043,-0.39 -0.086,-0.649 -0.13,-0.779 -0.173,-0.216 -0.26,-0.39 -0.303,-0.476 -0.043,-0.13 -0.043,-0.433 0,-0.823 0.043,-0.39 0,-0.649 -0.173,-0.779 -0.347,-0.216 -0.649,-0.346 -0.823,-0.433 -0.125,0.261 -0.212,0.564 -0.212,0.911",
			"Chernivtsi": "m 125.907,203.39 c -0.173,-0.087 -0.39,-0.217 -0.736,-0.303 -0.086,-0.043 -0.52,-0.043 -1.342,-0.043 l -0.13,0.043 c -1.212,0.13 -2.208,0.476 -2.987,0.953 -0.217,0.129 -0.52,0.39 -0.866,0.736 -1.039,0.736 -1.732,1.299 -2.078,1.646 -0.216,0.259 -0.476,0.649 -0.822,1.212 -0.087,0.13 -0.173,0.26 -0.347,0.477 -0.26,0.346 -0.606,0.822 -1.039,1.472 -0.043,0.043 -0.346,0.173 -0.866,0.39 -0.433,0.087 -0.736,0.433 -0.952,0.996 -0.043,0.086 -0.043,0.217 -0.043,0.39 0,0.26 0,0.52 0.043,0.693 0,0.086 0.086,0.216 0.216,0.476 0.043,0.13 0.086,0.303 0.043,0.433 -0.043,0.043 -0.347,0.086 -0.866,0.086 -0.173,0.043 -0.39,0.217 -0.606,0.52 -0.086,0.173 -0.26,0.433 -0.433,0.736 -0.043,0.13 -0.303,0.433 -0.693,0.909 -0.216,0.26 -0.649,0.39 -1.299,0.26 -0.346,0.216 -0.606,0.649 -0.692,1.299 -0.087,0.779 -0.217,1.256 -0.347,1.472 -1.039,1.515 -1.515,2.641 -1.385,3.291 0.043,0.26 0.086,0.736 0.13,1.429 0.043,0.649 0.216,1.083 0.433,1.299 0.39,0.433 0.606,0.779 0.606,0.909 0.043,0.173 0.043,0.52 0,1.169 0,0.129 0.13,0.433 0.303,0.952 0.26,0.52 0.216,1.126 -0.087,1.905 -0.043,0.086 -0.13,0.216 -0.26,0.346 l -0.476,0.996 c -0.39,0.649 -0.563,1.385 -0.649,2.165 v 0.433 l 2.165,-0.26 -2.165,0.26 0.043,0.476 c 0.52,-0.173 0.866,-0.26 1.126,-0.346 0.433,-0.043 0.736,-0.086 0.909,-0.086 l 0.043,-0.043 c 0.649,-0.086 1.125,-0.217 1.429,-0.39 l 1.082,-0.477 c 0.13,-0.129 0.26,-0.216 0.347,-0.216 0.866,-0.563 1.516,-1.299 1.905,-2.165 0.173,-0.692 0.346,-1.168 0.519,-1.429 0.13,-0.173 0.39,-0.389 0.823,-0.692 0.173,-0.13 0.303,-0.477 0.347,-1.126 0.216,-0.303 0.39,-0.52 0.563,-0.649 0.043,0 0.649,-0.303 1.862,-0.866 0.303,-0.217 0.563,-0.39 0.779,-0.433 0.217,-0.13 0.52,-0.13 0.866,-0.086 0.433,0.086 0.779,0.13 0.866,0.086 0.606,0 1.126,-0.13 1.646,-0.303 0.216,-0.13 0.39,-0.216 0.52,-0.26 0.216,-0.086 0.563,-0.173 1.083,-0.216 0.736,-0.087 1.429,-0.173 2.165,-0.13 0.866,0.043 1.516,0.086 1.948,0.043 0.39,0.043 0.649,0.043 0.866,0.043 1.299,-0.13 1.992,-0.173 2.122,-0.173 0.649,0.086 0.996,0.129 1.125,0.129 0.26,-0.043 0.563,-0.216 0.909,-0.563 0.433,-0.39 0.693,-0.606 0.866,-0.693 0.216,-0.086 0.52,-0.086 0.909,0 0.477,0.087 0.779,0.087 0.909,0.087 0.217,-0.217 0.39,-0.347 0.563,-0.433 0.26,-0.26 0.779,-0.26 1.559,-0.087 h 0.043 c 0.13,0.043 0.303,0.087 0.476,0.087 0.303,-0.13 0.52,-0.26 0.649,-0.347 0.216,-0.086 0.52,-0.173 0.909,-0.216 h 0.043 c 0.303,0 0.52,0 0.649,0 0.433,-0.043 0.866,0 1.255,0.043 0.736,0.043 1.212,0.043 1.472,-0.043 0.173,-0.043 0.563,-0.303 1.169,-0.736 0.217,-0.13 0.433,-0.563 0.649,-1.169 0.26,-0.822 0.433,-1.255 0.477,-1.255 0.13,-0.26 0.346,-0.476 0.693,-0.606 0.303,-0.13 0.52,-0.26 0.563,-0.347 0.043,-0.476 0.13,-0.823 0.217,-1.083 0.26,-0.52 0.433,-0.866 0.563,-1.125 0.13,-0.476 0.26,-0.823 0.39,-1.039 0.216,-0.39 0.303,-0.563 0.303,-0.606 -0.13,-0.303 -0.173,-0.563 -0.173,-0.736 0,-0.13 0,-0.217 -0.043,-0.303 h 0.086 c 0.649,0.217 1.126,0.13 1.429,-0.346 l 0.13,-0.043 c 0.259,0.217 0.476,0.347 0.692,0.303 0.216,-0.217 0.39,-0.39 0.476,-0.39 0.303,0.043 0.477,0.043 0.52,0.043 0.346,-0.39 0.563,-0.52 0.649,-0.52 l 0.13,-0.086 c 0.086,-0.216 0.216,-0.346 0.433,-0.346 0.217,0.043 0.39,0.043 0.52,0.086 0.173,0 0.303,0 0.39,0 0.476,0.26 0.779,0.346 0.909,0.346 0.736,-0.433 1.169,-0.693 1.212,-0.779 0.13,-0.303 0.217,-0.563 0.347,-0.736 0.13,-0.086 0.26,-0.13 0.39,-0.086 0.043,0.043 0.13,0.173 0.26,0.39 h 0.13 c 0.043,-0.043 0.13,-0.173 0.26,-0.347 0.13,-0.174 0.173,-0.303 0.173,-0.346 0.086,-0.173 0.216,-0.26 0.346,-0.26 v -0.043 c 0,-0.173 0,-0.346 0,-0.39 0,-0.13 0.043,-0.346 0.173,-0.736 0.13,-0.563 0.346,-0.953 0.649,-1.04 0.433,0 0.649,-0.086 0.736,-0.259 0.043,-0.866 0.173,-1.342 0.433,-1.429 0.13,0.043 0.39,0.477 0.822,1.299 0.39,0.693 0.91,1.04 1.516,0.996 0.433,-0.086 0.693,-0.216 0.823,-0.433 0.216,-0.346 0.13,-1.212 -0.26,-2.468 -0.216,-0.693 -0.303,-1.039 -0.26,-1.039 0.043,-0.13 0.26,-0.13 0.606,-0.043 0.39,0.13 0.606,0.173 0.693,0.173 l 0.13,-0.086 c 0.173,-0.693 0.303,-1.04 0.39,-1.083 0.823,0.692 1.299,1.125 1.472,1.212 0.346,0.303 0.953,0.52 1.775,0.779 0.433,0.13 0.779,0.087 0.952,-0.043 l 0.13,-0.086 c 0.173,-0.347 0.347,-0.433 0.606,-0.347 0.433,0.173 0.693,0.26 0.866,0.26 l 0.043,-0.13 c 0,-0.216 -0.043,-0.433 -0.13,-0.693 -0.217,-0.433 -0.217,-0.736 0.043,-0.996 0.087,-0.043 0.217,-0.043 0.347,-0.043 0.52,0.303 0.866,0.52 1.082,0.606 0.13,0.086 0.39,0.173 0.78,0.303 0.822,0.389 1.559,0.649 2.165,0.736 0.433,0.043 0.736,0.043 0.866,0.086 0.303,0 0.563,-0.043 0.909,-0.216 0.26,-0.13 0.476,-0.303 0.606,-0.477 0.173,-0.346 0.26,-0.563 0.39,-0.736 0.39,-0.433 0.649,-0.779 0.823,-1.039 0.26,-0.476 0.52,-0.779 0.736,-0.823 0.129,-0.043 0.519,-0.043 1.125,0.043 h 0.043 l 0.173,0.043 c 0.26,0.086 0.433,0.216 0.476,0.476 0.087,0.303 0.174,0.476 0.26,0.563 h 0.173 c 0.52,-0.649 0.996,-1.083 1.429,-1.256 0.173,-0.043 0.39,-0.216 0.692,-0.476 0.39,-0.13 0.65,-0.217 0.823,-0.303 l 0.086,-0.086 c -0.303,-0.087 -0.52,-0.173 -0.606,-0.303 -0.173,-0.216 -0.39,-1.125 -0.649,-2.771 -0.086,-0.303 -0.173,-0.649 -0.303,-1.083 -0.26,-0.779 -0.433,-1.299 -0.476,-1.429 -0.303,-0.26 -0.563,-0.433 -0.693,-0.563 -0.909,-0.692 -1.515,-1.039 -1.775,-0.996 -0.216,0.043 -0.39,0.173 -0.476,0.433 -0.086,0.13 -0.173,0.346 -0.26,0.606 -0.476,0.346 -0.866,0.303 -1.256,-0.13 -0.433,-0.52 -0.866,-0.779 -1.299,-0.736 -0.259,0.043 -0.519,0.173 -0.736,0.39 -0.13,0.173 -0.086,0.346 0.13,0.52 0.693,0.043 0.909,0.433 0.649,1.212 -0.13,0.173 -0.346,0.303 -0.649,0.433 -0.173,0.043 -0.346,0 -0.563,-0.086 -0.346,-0.13 -0.606,-0.26 -0.822,-0.39 -0.347,-0.26 -0.649,-0.39 -0.823,-0.347 -0.26,0 -0.476,0.217 -0.736,0.606 -0.216,0.346 -0.476,0.52 -0.736,0.52 -0.303,0 -0.693,-0.043 -1.255,-0.086 -0.043,-0.043 -0.217,-0.087 -0.433,-0.217 -0.13,0 -0.303,0.043 -0.606,0.13 -0.26,0.043 -0.476,0.043 -0.606,-0.043 -0.13,-0.043 -0.26,-0.217 -0.39,-0.477 -0.13,-0.26 -0.26,-0.39 -0.346,-0.39 -0.13,0 -0.303,0.087 -0.52,0.26 -0.13,0 -0.303,0 -0.476,-0.086 -0.173,-0.043 -0.39,-0.043 -0.563,0 -0.216,0.216 -0.52,0.649 -0.822,1.299 -0.39,0.649 -0.953,0.779 -1.688,0.39 -0.303,-0.13 -0.65,-0.606 -1.04,-1.342 -0.043,-0.13 0,-0.303 0.13,-0.563 0.087,-0.303 0.13,-0.52 0.13,-0.606 -0.173,-0.433 -0.476,-0.563 -0.909,-0.433 -0.433,0.26 -0.52,0.823 -0.303,1.689 -0.086,0.779 -0.389,1.125 -0.822,1.039 -0.043,-0.043 -0.087,-0.347 -0.173,-0.953 -0.086,-0.52 -0.303,-0.909 -0.693,-1.083 h -0.346 l -0.086,0.086 c -0.043,0.26 -0.043,0.433 0.043,0.52 0.433,0.606 0.693,0.952 0.736,1.039 0.13,0.346 -0.043,0.649 -0.433,0.952 -0.303,0.173 -0.563,0.173 -0.779,0.087 -0.13,-0.087 -0.347,-0.303 -0.649,-0.736 -0.26,-0.303 -0.606,-0.52 -1.083,-0.52 -0.303,-0.043 -0.606,0.13 -0.823,0.477 -0.086,0.563 0.043,0.822 0.347,0.822 0.606,0 0.953,0 1.039,0.043 0.13,0.043 0.39,0.26 0.822,0.693 0.433,0.303 0.693,0.563 0.693,0.736 0,0.043 -0.043,0.13 -0.13,0.216 -0.13,0.13 -0.303,0.173 -0.476,0.173 -0.087,-0.043 -0.303,-0.043 -0.563,-0.086 -0.303,0.043 -0.433,0.086 -0.476,0.086 -0.26,-0.086 -0.52,-0.303 -0.866,-0.736 -0.043,-0.043 -0.216,-0.043 -0.39,0 -0.346,0.13 -0.346,0.433 -0.086,0.953 0.216,0.433 0.346,0.779 0.39,0.952 0.043,0.303 -0.173,0.52 -0.606,0.606 -0.433,0.043 -0.779,0 -0.996,-0.217 -0.303,-0.216 -0.606,-0.779 -0.953,-1.645 -0.13,-0.346 -0.433,-0.736 -0.822,-1.212 -0.52,-0.476 -0.91,-0.736 -1.212,-0.779 -0.26,0 -0.606,0.086 -1.039,0.303 h -0.693 c -0.217,0 -0.433,0.086 -0.649,0.26 0,0 0,0 -0.043,0 -0.043,0.086 -0.173,0.26 -0.346,0.476 -0.173,0.173 -0.347,0.303 -0.477,0.346 -0.086,0 -0.433,-0.13 -0.996,-0.433 -0.043,-0.043 -0.303,-0.043 -0.736,-0.043 -0.259,-0.13 -0.563,-0.39 -0.909,-0.779 -0.13,-0.043 -0.65,0 -1.473,0.173 -0.822,0.173 -1.429,0.13 -1.861,-0.173 l -0.087,-0.13 0.043,0.086 c -0.346,-0.346 -0.433,-0.909 -0.303,-1.688 0.087,-0.779 0.13,-1.212 0,-1.299 l -0.476,-0.39 c -0.26,-0.216 -0.476,-0.303 -0.693,-0.216 -0.39,0.216 -0.26,0.953 0.39,2.122 0,0.086 0.087,0.216 0.216,0.346 0.043,0.216 0.043,0.433 -0.043,0.563 -0.26,0.39 -0.693,0.346 -1.299,-0.13 -0.347,-0.26 -0.52,-0.433 -0.563,-0.52 l -0.216,-0.39 c -0.13,-0.303 -0.217,-0.52 -0.217,-0.563 0.043,-0.303 0.217,-0.649 0.52,-0.996 l -0.043,-0.26 c -0.043,-0.26 -0.087,-0.39 -0.13,-0.433 0.087,-0.303 0.087,-0.563 0.087,-0.736 -0.173,-0.26 -0.26,-0.39 -0.346,-0.476 h -0.173 c -0.217,0.13 -0.433,0.606 -0.649,1.472 -0.217,0.13 -0.476,0.13 -0.736,0 -0.346,-0.217 -0.52,-0.303 -0.563,-0.303 -0.173,0.693 -0.39,1.169 -0.606,1.385 -0.346,0.303 -0.866,0.303 -1.515,0.043 -0.086,-0.043 -0.26,-0.173 -0.52,-0.303 -0.043,-0.043 -0.26,0 -0.693,0.043 l -0.13,-0.043 c -0.086,-0.13 -0.086,-0.26 -0.086,-0.433 0.086,-0.13 0.13,-0.26 0.13,-0.39 l -0.043,-0.13 c -0.346,-0.39 -0.563,-0.649 -0.606,-0.736 -0.26,-0.52 -0.519,-0.909 -0.822,-1.212 -0.173,-0.216 -0.433,-0.303 -0.693,-0.303 -0.303,0.043 -0.52,0.173 -0.649,0.433 -0.043,0.13 -0.086,0.347 -0.13,0.693 0,0.216 -0.13,0.433 -0.303,0.606 -0.346,0.13 -0.563,0 -0.693,-0.433 -0.086,-0.477 -0.173,-0.736 -0.173,-0.823 -0.217,-0.173 -0.649,-0.346 -1.386,-0.476 -0.13,0 -0.346,0 -0.779,0.043 -0.39,-0.043 -0.52,-0.173 -0.476,-0.476 -0.173,0.173 -0.433,0.39 -0.866,0.606 -0.173,0.13 -0.346,0.303 -0.606,0.606 l -0.477,0.563 c -0.173,0.217 -0.043,1.04 0.303,2.468 0.087,0.216 0.173,0.563 0.39,0.996 l 0.347,0.996 c 0.043,0.13 0.13,0.346 0.26,0.563 -0.173,2.338 -0.217,3.551 -0.26,3.637 0,0.086 -0.043,0.346 -0.13,0.736 -0.217,0.909 -0.303,1.386 -0.39,1.516 -0.173,0.13 -0.347,0.13 -0.606,0.086 -0.137,-0.085 -0.31,-0.171 -0.57,-0.301",
			"Chernihiv": "m 356.375,27.605 c -0.563,-0.216 -1.039,-0.346 -1.342,-0.39 -0.649,-0.086 -1.125,-0.216 -1.429,-0.303 -0.606,-0.216 -0.952,-0.303 -1.125,-0.346 -0.216,0.086 -0.39,0.26 -0.563,0.563 -0.13,0.39 -0.26,0.649 -0.346,0.779 0,0.043 -0.26,0.26 -0.736,0.563 -0.259,0 -0.52,0.043 -0.866,0.13 -0.303,0.693 -0.606,1.083 -0.823,1.169 -0.216,-0.26 -0.39,-0.39 -0.606,-0.39 -0.346,0 -0.823,0.39 -1.516,1.039 -0.086,0.13 -0.303,0.26 -0.606,0.433 -0.39,0.173 -0.649,0.347 -0.823,0.477 -0.649,0.693 -1.125,1.083 -1.429,1.125 -0.303,0.087 -0.606,-0.086 -0.953,-0.433 -0.346,-0.347 -0.649,-0.563 -0.909,-0.563 -0.173,-0.043 -0.39,0 -0.649,0.13 l -0.347,0.043 c -0.259,0.13 -0.476,0.216 -0.606,0.26 -0.563,0.13 -1.169,0.13 -1.818,0.043 -0.823,-0.26 -1.256,-0.39 -1.299,-0.433 -0.433,-0.259 -0.779,-0.433 -1.039,-0.563 -0.477,-0.217 -0.866,-0.39 -1.083,-0.52 -0.693,-0.39 -1.299,-0.693 -1.775,-0.953 -0.953,-0.433 -1.516,-0.563 -1.732,-0.39 0,0.13 -0.043,0.26 -0.087,0.39 -0.086,0.043 -0.26,0 -0.52,-0.086 -0.26,-0.087 -0.433,-0.13 -0.563,-0.173 -0.563,-0.26 -0.953,-0.433 -1.255,-0.563 -0.433,-0.173 -0.909,-0.173 -1.342,0.043 -0.173,0.086 -0.303,0.173 -0.346,0.216 -0.087,0.086 -0.13,0.216 -0.217,0.39 -0.26,0.52 -0.26,1.083 0.087,1.775 0.346,0.606 0.563,0.953 0.563,1.039 0,0.346 -0.217,0.649 -0.65,0.953 -0.476,0.303 -0.736,0.52 -0.779,0.736 0.13,0.303 0.173,0.563 0.13,0.779 -0.26,0.347 -0.39,0.693 -0.433,0.953 0.173,0.346 0.259,0.563 0.303,0.736 -0.043,0.13 -0.086,0.303 -0.216,0.433 -0.217,0.216 -0.303,0.347 -0.303,0.39 -0.173,0.649 -0.303,1.083 -0.52,1.342 -0.13,0.216 -0.26,0.346 -0.433,0.433 l -0.866,0.433 c -0.736,0.477 -1.299,0.779 -1.688,0.953 -0.52,0.043 -0.909,0.13 -1.126,0.26 -0.563,0.606 -0.953,0.909 -1.169,0.953 -0.26,0.086 -0.606,0.043 -0.996,-0.13 -0.433,-0.173 -0.736,-0.303 -0.953,-0.39 -0.173,-0.043 -0.433,-0.043 -0.779,-0.043 -0.779,0 -1.429,0.13 -1.992,0.433 -0.606,0.303 -0.909,0.476 -0.953,0.476 -0.173,0 -0.39,-0.086 -0.563,-0.26 0,-0.173 -0.13,-0.433 -0.303,-0.692 l 0.13,-0.303 c 0.13,-0.346 0.13,-0.693 0,-1.039 -0.087,-0.26 -0.433,-0.477 -0.996,-0.693 -0.52,-0.216 -0.909,-0.303 -1.255,-0.346 -0.606,0.086 -1.083,0.13 -1.429,0.173 -0.347,-0.043 -0.866,0 -1.472,0.13 -0.606,0.087 -1.083,0.13 -1.386,0.087 -0.649,-0.13 -1.169,-0.173 -1.472,-0.217 -1.039,-0.086 -1.775,-0.13 -2.294,-0.216 -1.516,-0.173 -2.555,-0.303 -3.074,-0.303 l -0.996,-0.043 c -0.259,0.086 -0.519,0.13 -0.649,0.13 -0.736,0 -1.212,0.043 -1.429,0.13 -0.26,0.043 -0.563,0.26 -0.996,0.606 -0.433,0.346 -0.693,0.606 -0.779,0.823 -0.043,0.043 -0.086,0.303 -0.173,0.866 -0.086,0.303 -0.26,0.52 -0.606,0.649 -0.26,0.087 -0.39,0.13 -0.39,0.13 -0.303,0 -0.52,-0.043 -0.693,-0.173 -0.043,0 -0.13,-0.087 -0.216,-0.217 -0.736,-0.736 -1.342,-1.169 -1.775,-1.299 -0.13,-0.043 -0.346,-0.043 -0.649,-0.086 -0.649,-0.13 -1.515,-0.13 -2.598,0.043 -0.736,0.129 -1.212,0.129 -1.516,0.086 -0.476,-0.043 -0.866,0 -1.083,0.043 -0.173,0.173 -0.346,0.26 -0.606,0.347 -0.13,0.216 -0.216,0.433 -0.26,0.606 0.13,0.173 0.216,0.347 0.303,0.477 -0.303,0.26 -0.433,0.563 -0.433,0.866 0.52,-0.086 0.996,0.13 1.385,0.563 0.043,0.26 -0.086,0.476 -0.39,0.649 -0.303,0.173 -0.563,0.216 -0.822,0.173 l -0.26,-0.52 c -0.39,0.303 -0.693,0.476 -0.91,0.563 l -0.086,0.13 c 0,0.217 0.043,0.433 0.173,0.606 l -0.087,0.13 c -0.043,0.043 -0.129,0.086 -0.26,0.086 l -0.086,0.173 v 0.173 l -0.043,0.173 c -0.216,0.043 -0.389,0.086 -0.476,0.13 -0.13,0.173 -0.303,0.303 -0.433,0.346 -0.346,0.087 -0.52,0.087 -0.563,0.13 -0.087,0.043 -0.173,0.13 -0.26,0.13 -0.13,0.086 -0.347,0.129 -0.65,0.173 l -0.043,0.043 0.043,0.476 c 0.13,0.606 0.087,1.04 -0.173,1.299 -0.173,0.173 -0.433,0.26 -0.779,0.26 -0.39,-0.043 -0.606,0 -0.693,0.086 -0.13,0.433 -0.26,0.779 -0.39,0.953 -0.39,0.173 -0.649,0.346 -0.736,0.52 l -0.433,0.692 c -0.087,0.303 -0.173,0.52 -0.26,0.606 -0.043,0.086 -0.26,0.173 -0.606,0.26 -0.173,0.173 -0.173,0.39 -0.043,0.693 0.13,0.346 0.216,0.563 0.216,0.649 -0.13,0.216 -0.173,0.39 -0.216,0.52 -0.13,0.303 -0.173,0.433 -0.173,0.476 -0.13,0.13 -0.303,0.216 -0.563,0.216 -0.346,0 -0.52,0 -0.563,0.087 -0.087,0.086 -0.087,0.216 -0.043,0.303 0.043,0.173 0.303,0.346 0.822,0.52 v 0.13 c -0.216,0.13 -0.346,0.216 -0.346,0.303 -0.086,0.087 -0.13,0.303 -0.13,0.693 0,0.39 -0.086,0.649 -0.173,0.823 -0.086,0.13 -0.303,0.173 -0.606,0.13 -0.39,0 -0.693,0.043 -0.866,0.216 0,0.347 0.043,0.606 0.043,0.823 -0.303,0.26 -0.433,0.563 -0.433,0.866 0.173,0.13 0.216,0.347 0.173,0.52 -0.043,0.217 -0.173,0.347 -0.433,0.433 l -0.043,0.13 c 0,0.043 0.043,0.173 0.173,0.433 l -0.087,0.13 c -0.173,0 -0.303,0.13 -0.476,0.346 -0.216,0.13 -0.39,0.26 -0.477,0.39 -0.346,0.563 -0.173,0.953 0.563,1.126 l 0.086,0.13 -0.086,0.13 c -0.26,0.086 -0.433,0.173 -0.52,0.303 -0.043,0.129 0,0.259 0.13,0.476 0.173,0.433 0.433,0.649 0.693,0.649 0.476,0 0.736,0.043 0.866,0.086 l 0.043,0.13 c 0,0.13 -0.173,0.39 -0.476,0.823 -0.043,0.087 0.086,0.217 0.26,0.39 0.216,0.173 0.346,0.303 0.39,0.39 v 0.043 c -0.043,0.563 -0.043,0.866 0,0.996 0.043,0.13 0.173,0.26 0.433,0.347 0.217,0.086 0.347,0.26 0.39,0.476 l -0.043,0.173 c -0.347,-0.043 -0.563,-0.043 -0.736,0.043 -0.086,0.13 -0.173,0.347 -0.216,0.649 0,0.347 0.043,0.563 0.13,0.693 0.043,0 0.217,0.043 0.563,0.13 0.216,0 0.346,0.087 0.433,0.217 0.086,0.086 0.129,0.433 0.129,0.996 0.433,0.563 0.606,0.953 0.606,1.169 -0.043,0 -0.043,0 -0.043,0.043 l -0.216,0.26 c -0.043,0.086 -0.087,0.173 -0.087,0.216 v 0.173 c 0.26,0.303 0.347,0.563 0.347,0.823 l -0.086,0.13 c -0.477,0.173 -0.736,0.303 -0.866,0.39 -0.173,0.086 -0.433,0.303 -0.736,0.736 -0.303,0.043 -0.433,0.086 -0.476,0.13 -0.173,0.13 -0.173,0.303 -0.087,0.52 0.087,0.303 0.13,0.52 0.13,0.693 -0.043,0.086 -0.13,0.217 -0.303,0.346 -0.173,0.173 -0.303,0.39 -0.303,0.649 -0.043,0 -0.043,-0.043 -0.087,-0.086 0.043,0.347 0.13,0.649 0.26,0.823 v 0.173 c -0.13,0.216 -0.39,0.26 -0.779,0.216 -0.303,-0.086 -0.52,0 -0.563,0.216 0.043,0.043 0.086,0.173 0.13,0.303 0.173,-0.043 0.303,0 0.433,0.043 0.173,0.086 0.303,0.303 0.39,0.692 l 0.217,0.043 c 0.086,-0.043 0.303,-0.173 0.52,-0.433 0.26,-0.26 0.433,-0.39 0.563,-0.346 0.217,0.216 0.217,0.606 0,1.169 -0.173,0.26 -0.26,0.433 -0.26,0.606 -0.043,0.13 -0.043,0.216 0,0.346 0,0 -0.173,0.173 -0.39,0.433 -0.043,0.086 0.043,0.216 0.13,0.433 0,0.173 -0.043,0.303 -0.043,0.39 0.043,0.26 0.043,0.433 0.086,0.52 v 0.217 l -0.043,0.13 c -0.217,0.52 -0.347,0.866 -0.303,0.953 l 0.086,0.13 c 0.173,0 0.39,-0.043 0.606,-0.13 0.347,0.39 0.433,0.866 0.303,1.385 0,0.087 -0.13,0.303 -0.303,0.606 -0.346,0.563 -0.606,1.125 -0.779,1.602 0.043,0 0.087,0 0.13,0.043 0.173,0.086 0.39,0.303 0.649,0.606 0.173,0.043 0.433,0 0.823,-0.173 0.087,0 0.303,0.13 0.649,0.433 0.433,0.476 0.693,0.779 0.736,0.952 0.173,0.433 0.13,1.126 -0.043,2.035 -0.216,0.866 -0.216,1.429 -0.086,1.645 0.216,0.347 0.953,0.65 2.294,0.953 0.087,0.043 0.39,0.26 0.996,0.649 0.216,0.173 0.39,0.303 0.433,0.477 0,0.043 0,0.216 -0.086,0.563 -0.086,0.563 -0.216,1.039 -0.346,1.472 -0.13,0.217 -0.217,0.433 -0.303,0.606 -0.39,0.736 -0.563,1.125 -0.563,1.169 0.043,0.086 0.087,0.173 0.13,0.216 0.217,0.087 0.477,0.043 0.823,-0.13 0.39,-0.173 0.693,-0.216 0.909,-0.13 0.216,0.086 0.433,0.303 0.606,0.649 0.216,0.303 0.39,0.476 0.563,0.52 0.346,0 0.563,-0.303 0.649,-0.822 0.347,-0.347 0.91,-0.173 1.775,0.563 0.173,-0.086 0.346,-0.216 0.606,-0.476 0.26,-0.217 0.477,-0.347 0.606,-0.39 0.173,0 0.606,0 1.385,0.13 0.693,0.043 1.169,0.043 1.429,-0.13 0.13,-0.043 0.347,-0.217 0.606,-0.433 0.346,-0.043 0.606,0.043 0.649,0.216 0.043,0.043 0,0.173 -0.043,0.303 0,0.086 0.043,0.217 0.13,0.26 l 0.52,0.173 c -0.13,0.26 -0.216,0.476 -0.26,0.606 -0.086,0.477 0.043,0.693 0.433,0.736 0.649,-0.043 0.996,0 1.039,0 0.043,0.086 0,0.346 -0.086,0.736 0.086,0.13 0.433,0.433 1.039,0.866 0.303,0.26 0.476,0.606 0.563,0.996 0.216,0.823 0.26,1.472 0.043,1.905 -0.086,0.173 -0.173,0.303 -0.26,0.39 -0.13,0.043 -0.26,0.043 -0.476,-0.043 l -0.13,0.043 c -0.216,0.26 -0.303,0.563 -0.173,0.909 0.173,0.13 0.563,0.52 1.256,1.255 0.086,0.086 0.173,0.086 0.346,0.086 0.216,-0.216 0.52,-0.26 0.779,-0.173 l 0.13,0.086 c 0.043,0.13 0.043,0.477 -0.086,1.083 0.086,0.303 0.303,0.563 0.692,0.779 0.13,0.043 0.303,0 0.477,-0.13 0.086,0 0.26,0.13 0.563,0.433 0.216,0.216 0.476,0.173 0.866,-0.087 l 0.303,-0.303 c 0.216,0.086 0.563,0.173 0.996,0.39 0.216,0.043 0.477,0.13 0.909,0.26 0.087,0.043 0.26,0.13 0.477,0.216 0.39,0.13 0.866,-0.13 1.429,-0.779 0.043,-0.13 0.303,-0.13 0.779,0 0.216,0.043 0.477,0.13 0.823,0.216 0.13,0.043 0.39,0.087 0.779,0.13 0.173,-0.043 0.39,-0.173 0.606,-0.433 0.043,0 0.217,0 0.433,0.043 0.217,0.043 0.39,0.043 0.476,-0.043 0.217,-0.303 0.39,-0.563 0.563,-0.693 0.173,-0.086 0.39,-0.086 0.693,-0.13 0.043,0 0.173,-0.13 0.303,-0.39 0.173,-0.173 0.303,-0.303 0.433,-0.303 0.173,-0.086 0.52,-0.043 0.996,0 0.39,0.087 0.692,0.043 0.866,0 0.217,-0.216 0.39,-0.476 0.52,-0.779 0.216,-0.086 0.39,-0.173 0.52,-0.216 l 0.043,-0.173 c -0.13,-0.26 -0.173,-0.476 -0.043,-0.606 l 0.217,-0.173 c 0.086,-0.13 0.13,-0.39 0.13,-0.823 0.086,-0.13 0.389,-0.216 0.866,-0.303 0.52,-0.13 0.866,-0.13 1.039,-0.043 0.087,0.086 0.173,0.26 0.26,0.52 0.217,0.303 0.606,0.563 1.169,0.779 l 0.52,0.693 c 0.13,0.173 0.26,0.433 0.39,0.736 0.173,0.26 0.39,0.433 0.649,0.52 0.13,0.043 0.563,0.087 1.169,0.043 0.606,0 0.909,0.043 0.953,0.13 0.303,0.563 0.433,0.953 0.433,1.125 l -0.13,0.043 h -0.173 c -0.043,0.346 -0.086,0.563 -0.173,0.693 -0.087,0.13 -0.217,0.173 -0.477,0.13 -0.26,-0.087 -0.433,-0.087 -0.519,-0.087 -0.174,0.043 -0.347,0.217 -0.52,0.563 -0.216,0.347 -0.346,0.606 -0.346,0.823 0.692,0.346 1.083,0.693 1.256,0.909 -0.087,0.52 -0.087,0.866 -0.043,1.039 0.433,0.563 0.779,0.823 0.996,0.866 0.043,0 0.303,-0.043 0.693,-0.129 0.303,-0.043 0.563,0 0.736,0.129 0.043,0.13 0.043,0.217 0,0.39 -0.303,0.173 -0.563,0.433 -0.779,0.692 l -0.043,0.173 1.732,2.555 c 0,-0.087 0.086,-0.303 0.303,-0.606 0.13,-0.216 0.173,-0.433 0.173,-0.649 h 0.086 c 0.866,0.13 1.386,0.087 1.559,-0.086 l 0.217,0.043 0.26,0.346 c 0.433,0.173 0.866,-0.043 1.342,-0.693 0.563,-0.866 0.91,-1.342 1.083,-1.429 0.173,-0.086 0.52,-0.086 1.04,-0.086 l 0.129,-0.043 c 0.087,-0.346 0.173,-0.563 0.303,-0.649 l 0.563,-0.043 c 0.346,0 0.693,0.173 0.996,0.52 0.087,0.087 0.173,0.217 0.303,0.347 l 0.13,0.043 c 0.13,-0.086 0.26,-0.216 0.433,-0.433 0.086,-0.043 0.216,-0.13 0.39,-0.217 0.13,-0.173 0.173,-0.216 0.216,-0.216 0.13,-0.043 0.303,-0.043 0.52,0 l 0.433,0.086 c 0.173,0.087 0.347,0.477 0.476,1.299 0.043,0.043 0.13,0.173 0.26,0.347 0.303,0.173 1.04,0.26 2.122,0.346 1.126,0.043 1.819,0.043 2.122,-0.086 l 0.13,-0.346 c 0.477,0 0.779,0.043 0.909,0.129 0.087,0.13 0.087,0.26 0.087,0.477 0.216,0.043 0.563,0.043 0.996,0.043 0.563,0 0.866,-0.087 0.909,-0.217 v -0.13 c 0.087,-0.13 0.477,-0.346 1.083,-0.649 0.087,-0.043 0.216,-0.13 0.39,-0.216 0.563,-0.173 0.866,-0.26 0.909,-0.303 0.173,0 0.477,-0.043 0.823,-0.043 0.346,0 0.606,-0.086 0.779,-0.216 0.086,-0.086 0.173,-0.39 0.303,-0.823 0.086,-0.433 0.216,-0.649 0.39,-0.736 0.303,-0.173 0.779,-0.347 1.472,-0.52 0.086,-0.736 0.346,-1.169 0.693,-1.299 0.216,-0.087 0.606,-0.217 1.169,-0.39 0.173,-0.26 0.346,-0.606 0.476,-1.126 0.173,-0.26 0.433,-0.649 0.779,-1.169 v -0.216 c 0.043,-0.13 0.043,-0.303 0.043,-0.52 0.086,-0.303 0.303,-0.65 0.52,-1.04 0.563,-0.952 0.823,-1.991 0.823,-3.031 0,-0.043 -0.087,-0.173 -0.173,-0.433 0,-0.217 0,-0.347 -0.087,-0.477 0.043,-0.173 0.303,-0.303 0.78,-0.433 0.086,-0.043 0.086,-0.65 0.086,-1.819 0.086,-0.13 0.347,-0.303 0.779,-0.563 0.303,-0.173 0.433,-0.39 0.433,-0.693 -0.043,-0.347 -0.087,-0.52 -0.087,-0.563 -0.216,-0.086 -0.39,-0.13 -0.476,-0.173 -0.346,-0.346 -0.606,-0.606 -0.779,-0.779 -0.173,-1.039 -0.173,-1.775 0,-2.251 l 0.433,-1.125 c 0.043,-0.173 0.086,-0.433 0.086,-0.823 0.043,-0.216 0.216,-0.52 0.433,-0.953 0.26,0.043 0.433,0.087 0.563,0.043 0.346,-0.216 0.39,-1.125 0.173,-2.685 0.043,-0.13 0.13,-0.346 0.303,-0.649 -0.779,-0.563 -1.126,-0.909 -1.126,-1.039 -0.043,-0.216 0.087,-0.476 0.303,-0.693 0.13,-0.173 0.347,-0.346 0.606,-0.563 0.519,-0.953 0.822,-1.429 0.822,-1.472 l -0.13,-0.13 c -0.52,-0.173 -0.866,-0.303 -1.039,-0.347 -0.433,0.996 -0.693,1.559 -0.866,1.646 -0.173,0.086 -0.693,0 -1.516,-0.303 -0.866,-0.26 -1.385,-0.52 -1.515,-0.779 l 0.043,-0.173 c 0,-0.13 0.26,-0.303 0.736,-0.477 0.086,-0.13 0.043,-0.346 -0.087,-0.563 l -0.129,-0.086 c -0.087,-0.043 -0.303,0.043 -0.78,0.216 -0.736,-0.346 -1.212,-0.52 -1.472,-0.606 -0.389,-0.173 -0.822,-0.26 -1.342,-0.346 l -0.043,-0.087 0.476,-0.866 c 0.087,-0.216 0.303,-0.52 0.606,-0.953 0.043,-0.13 0.043,-0.216 -0.043,-0.303 l -0.39,-0.39 c 0.303,-0.52 0.303,-0.909 0.043,-1.125 0.043,-0.087 0.39,-0.217 0.996,-0.346 0.649,-0.13 0.996,-0.303 1.125,-0.52 0.13,-0.39 0.087,-0.866 -0.129,-1.299 0,-0.173 0.216,-0.346 0.649,-0.476 0.39,-0.173 0.606,-0.303 0.692,-0.477 0,-0.216 -0.086,-0.52 -0.346,-0.996 0.043,-0.086 0.173,-0.303 0.476,-0.606 -0.086,-0.303 -0.39,-0.563 -0.909,-0.823 v -0.173 c 0.043,-0.173 0.173,-0.433 0.347,-0.736 0.043,-0.303 0,-0.563 -0.217,-0.779 -0.086,-0.043 -0.303,-0.043 -0.692,0.043 -0.13,-0.043 -0.217,-0.086 -0.26,-0.173 0.043,-0.39 -0.173,-0.823 -0.563,-1.212 0,-0.303 0.13,-0.649 0.433,-1.126 0.26,0 0.433,0.043 0.563,0.087 0.173,0.216 0.303,0.52 0.433,0.909 0.13,0.346 0.476,0.433 0.996,0.39 0.563,-0.086 0.996,-0.26 1.255,-0.476 0.13,-0.39 0.043,-0.823 -0.173,-1.299 0,-0.173 0.13,-0.39 0.433,-0.606 l -0.043,-0.173 c -0.216,-0.216 -0.476,-0.39 -0.692,-0.433 l -0.087,-0.13 c 0.087,-0.389 0.087,-0.779 0,-1.169 l 0.087,-0.173 c 0.433,-0.13 0.692,-0.303 0.779,-0.433 0.043,-0.39 -0.086,-0.866 -0.433,-1.472 l 0.043,-0.13 c 0.303,0.13 0.736,0.39 1.342,0.693 0.043,-0.086 0.303,-0.346 0.693,-0.866 -0.13,-0.13 -0.26,-0.26 -0.303,-0.347 -0.086,-0.086 -0.346,-0.346 -0.822,-0.693 -0.087,-0.649 -0.13,-0.996 -0.087,-1.125 0.13,-0.173 0.477,-0.26 1.04,-0.347 0,-0.216 -0.043,-0.346 -0.13,-0.433 -0.173,-0.13 -0.39,-0.26 -0.563,-0.303 0,-0.13 0,-0.563 0,-1.212 0,-0.606 -0.043,-0.952 -0.173,-1.169 -0.173,0.043 -0.346,0 -0.52,-0.043 -0.173,-0.086 -0.216,-0.346 -0.13,-0.736 0,-0.043 0.043,-0.13 0.173,-0.216 0.433,-0.563 0.606,-0.91 0.563,-1.083 -0.173,-0.217 -0.433,-0.433 -0.736,-0.649 -0.693,-0.52 -1.083,-0.779 -1.169,-0.866 -0.26,-0.26 -0.433,-0.692 -0.563,-1.299 -0.216,-0.822 -0.303,-1.342 -0.303,-1.515 -0.043,-0.563 0.13,-1.039 0.477,-1.472 0.303,-0.39 0.563,-0.649 0.736,-0.779 0.347,-0.303 0.52,-0.477 0.52,-0.477 0.043,-0.086 0.087,-0.303 0.173,-0.649 0.043,-0.26 0.13,-0.433 0.216,-0.476 0.217,-0.13 0.52,-0.216 0.909,-0.303 l 0.043,-0.173 c -0.13,-0.173 -0.173,-0.303 -0.173,-0.39 0.043,-0.26 0.086,-0.433 0.216,-0.477 0.346,-0.13 0.952,-0.13 1.862,0 0.043,-0.303 0.13,-0.476 0.173,-0.52 0.173,-0.086 0.477,-0.086 0.909,-0.086 l 0.043,-0.13 0.13,-0.087 1.039,-0.346 c 0.347,-0.13 0.606,-0.26 0.736,-0.39 0.129,-0.043 0.476,-0.043 1.039,-0.043 0.086,0 0.173,-0.043 0.26,-0.173 0.086,-0.39 -0.13,-0.952 -0.649,-1.645 -0.043,-0.13 -0.087,-0.216 -0.13,-0.26 l -0.043,-0.043 0.043,-0.086 c 0.26,-0.173 0.476,-0.346 0.563,-0.476 0.043,-0.217 0.043,-0.649 0,-1.342 -0.043,-0.563 0,-0.953 0.086,-1.039 0.173,-0.13 0.303,-0.173 0.433,-0.173 0.13,0.13 0.216,0.303 0.216,0.52 l 0.13,0.13 c 0.996,0.173 1.775,0.043 2.338,-0.346 0.13,-0.909 0.216,-1.386 0.216,-1.516 -0.779,0 -1.212,0 -1.299,-0.086 -0.043,-0.043 -0.13,-0.26 -0.26,-0.563 -0.216,-0.173 -0.346,-0.303 -0.433,-0.39 -0.216,-0.346 -0.389,-0.606 -0.519,-0.736 l -0.52,-0.477 c -0.173,-0.13 -0.26,-0.216 -0.26,-0.216 -0.736,-0.13 -1.212,-0.303 -1.515,-0.476 l -0.086,0.086 c 0,-0.13 -0.043,-0.606 -0.173,-1.386 v -0.563 c -0.043,-0.477 0,-0.78 0.173,-0.996 0.086,-0.13 0.39,-0.346 0.866,-0.606 0.043,-0.043 0.173,-0.173 0.26,-0.39 0.043,-0.087 0,-0.303 -0.086,-0.563 -0.043,-0.26 -0.043,-0.476 0,-0.606 l 0.39,-0.736 c 0.086,-0.173 0.216,-0.39 0.433,-0.693 0.043,-0.13 0.173,-0.606 0.39,-1.429 0.13,-0.649 0.347,-1.083 0.563,-1.255 -0.086,-0.087 -0.13,-0.13 -0.216,-0.13 -0.347,-0.217 -0.693,-0.26 -1.083,-0.087 -0.527,0.218 -0.873,0.304 -1.09,0.304",
			"Cherkasy": "m 299.96,136.366 c -0.086,0 -0.173,0.043 -0.217,0.043 -0.303,0.13 -0.519,0.217 -0.649,0.217 -0.563,0 -0.996,-0.043 -1.255,0 -0.563,0 -1.342,0.433 -2.338,1.299 -0.216,0.216 -0.39,0.39 -0.433,0.39 -0.043,0.043 -0.39,0.086 -0.909,0.13 -0.477,0 -0.779,0.13 -0.866,0.433 l -0.216,0.65 c -0.13,0.173 -0.303,0.433 -0.563,0.736 0.086,0.13 0.303,0.346 0.692,0.563 -0.043,0.173 -0.13,0.433 -0.346,0.779 -0.173,0.303 -0.26,0.563 -0.26,0.779 0.346,0.346 0.52,0.52 0.52,0.563 -0.13,1.125 -0.26,1.775 -0.346,1.948 -0.303,0.476 -0.52,0.779 -0.52,0.953 0,0.043 0.043,0.173 0.173,0.39 0.087,0.216 0.087,0.346 0.043,0.52 -0.433,0.779 -0.693,1.429 -0.823,1.905 -0.26,0.087 -0.433,0.26 -0.563,0.433 -0.043,0.086 -0.086,0.303 -0.043,0.606 0,0.303 0.043,0.477 0.13,0.563 0.043,0.043 0.173,0.043 0.433,0.087 0.13,0 0.26,0.086 0.347,0.216 0.173,0.909 0.086,1.429 -0.217,1.515 -0.563,0.13 -0.909,0.303 -1.039,0.39 -0.043,0.087 -0.216,0.433 -0.476,0.996 l -0.26,0.606 c -0.173,0.347 -0.26,0.52 -0.303,0.606 -0.13,0.173 -0.346,0.346 -0.606,0.433 -0.347,0.13 -0.563,0.217 -0.649,0.347 -0.303,0.563 -0.606,0.909 -1.039,0.996 -0.347,0.52 -0.606,0.909 -0.823,1.126 -0.347,0.043 -0.563,0.13 -0.649,0.303 l -0.433,0.909 c -0.086,0.173 -0.26,0.477 -0.563,0.953 -0.043,0.173 -0.043,0.433 0,0.823 0,0.26 -0.043,0.563 -0.173,0.823 l -0.217,0.086 -0.39,-0.086 c -0.173,-0.476 -0.346,-0.779 -0.476,-0.909 l -0.173,-0.043 c -0.26,0.043 -0.39,0.13 -0.476,0.303 -0.087,0.216 -0.173,0.39 -0.26,0.433 -0.303,0.087 -0.52,0.087 -0.649,0.043 -0.13,-0.26 -0.26,-0.433 -0.303,-0.433 -0.173,0 -0.39,0.217 -0.693,0.606 -0.26,0.39 -0.649,0.476 -1.125,0.303 -0.087,0 -0.217,0.13 -0.39,0.347 -0.173,0.173 -0.347,0.303 -0.563,0.346 -0.13,-0.043 -0.303,-0.26 -0.477,-0.736 -0.259,-0.433 -0.433,-0.736 -0.563,-0.823 -0.173,-0.13 -0.39,-0.043 -0.693,0.173 -0.26,0.173 -0.477,0.216 -0.606,0.086 l -0.52,-0.52 -0.129,-0.043 c -0.39,0.953 -0.693,1.472 -0.866,1.516 l -0.13,-0.043 c -0.043,-0.13 -0.173,-0.26 -0.433,-0.39 -0.347,-0.13 -0.52,-0.26 -0.606,-0.303 h -0.13 c -0.043,0.26 -0.13,0.433 -0.216,0.476 -0.91,0.346 -1.429,0.476 -1.429,0.476 -0.13,-0.346 -0.26,-0.606 -0.347,-0.736 -0.52,-0.606 -0.996,-0.779 -1.429,-0.433 -0.087,0.043 -0.216,0.217 -0.347,0.563 -0.086,0.26 -0.13,0.693 -0.086,1.212 0,0.173 -0.086,0.39 -0.216,0.649 -0.26,1.125 -0.477,1.992 -0.606,2.641 l -0.087,0.13 c -0.39,0.086 -0.693,0.086 -0.866,-0.043 0.043,-0.13 0.086,-0.476 0.086,-1.039 -0.26,-0.13 -1.256,-0.347 -3.117,-0.649 -1.689,-0.303 -2.555,-0.563 -2.641,-0.693 -0.087,-0.216 0,-0.52 0.216,-0.823 0.26,-0.39 0.39,-0.649 0.39,-0.779 -0.736,-0.346 -1.169,-0.476 -1.299,-0.39 0,0.347 -0.086,0.563 -0.13,0.693 l -0.649,0.086 c -0.217,0.13 -0.346,0.39 -0.346,0.736 0.346,0.433 0.476,0.736 0.476,0.952 l -0.086,0.13 c -0.13,0 -0.217,0 -0.347,0 -0.433,-0.477 -0.823,-0.606 -1.169,-0.39 l -0.043,0.173 -0.173,0.043 c -0.217,-0.217 -0.433,-0.39 -0.52,-0.477 -0.216,0 -0.39,0.13 -0.519,0.39 -0.173,0.347 -0.303,0.563 -0.347,0.606 l -0.346,0.13 c -0.693,-0.13 -1.169,-0.173 -1.429,-0.087 -0.173,0.39 -0.519,0.65 -1.039,0.866 -0.173,0.693 -0.476,1.212 -0.822,1.559 l -0.52,0.52 c -0.043,0.087 -0.043,0.26 0.043,0.563 0.043,0.26 0.043,0.476 -0.043,0.606 -0.39,-0.13 -0.692,-0.173 -0.909,-0.216 -0.347,0.086 -0.606,0.13 -0.78,0.173 -0.086,0 -0.346,0 -0.822,0.043 -0.433,0.043 -1.039,-0.303 -1.732,-1.039 -0.13,-0.13 -0.13,-0.26 0,-0.433 0.13,-0.13 0.26,-0.217 0.52,-0.26 l 0.086,-0.13 c -0.043,-0.259 -0.173,-0.433 -0.346,-0.476 -0.303,0.217 -0.693,0.173 -1.126,-0.173 -0.086,0 -0.216,0.087 -0.476,0.303 -0.217,0.217 -0.346,0.346 -0.39,0.433 v 0.173 c 0.043,0.086 0.39,0.303 0.909,0.649 0.433,0.216 0.563,0.476 0.39,0.866 -0.39,0.216 -0.52,0.52 -0.303,0.909 0.303,0.476 0.39,0.779 0.347,0.909 -0.78,0.26 -1.212,0.52 -1.299,0.823 0.173,0.649 0.216,0.996 0.216,1.083 l -0.866,0.476 -0.26,0.13 c -0.39,0.217 -0.692,0.39 -0.866,0.563 -0.606,0.476 -0.736,1.039 -0.433,1.646 0.13,0.303 0.26,0.433 0.477,0.476 0.346,0.13 0.822,0.173 1.472,0.173 0.129,0.086 0.216,0.26 0.389,0.563 0.087,0.303 0.173,0.52 0.087,0.649 l -0.087,0.087 c -0.346,-0.043 -0.606,0.043 -0.779,0.216 0.043,0.39 0,0.649 -0.043,0.823 -0.087,0.086 -0.217,0.216 -0.39,0.39 0,0.086 0.13,0.216 0.433,0.39 0.346,0.216 0.563,0.39 0.649,0.563 0.129,0.043 0.346,0.043 0.649,0 0.346,0 0.606,0.303 0.822,0.866 0.13,0.26 0.173,0.476 0.13,0.606 -0.086,0.13 -0.346,0.347 -0.779,0.606 0.13,0.606 0.26,0.953 0.39,1.083 0.087,0.086 0.433,0.173 1.083,0.346 0,0 0.087,0.303 0.216,0.866 0.043,0.173 0.087,0.433 0.173,0.78 0.043,0.13 0.043,0.476 0.043,1.039 0.043,0.476 0.13,0.779 0.303,0.866 0.433,0.216 1.255,0.216 2.511,0.087 l 0.087,0.086 v 0.216 c 0.043,0.043 0.086,0.217 0.086,0.476 0.303,0.043 0.563,0.173 0.779,0.303 l 0.043,0.13 -0.043,0.173 c -0.563,0.216 -0.909,0.476 -1.082,0.736 0,0.087 0,0.217 0,0.39 0.043,0.433 0.433,0.91 1.255,1.472 0.26,0.173 0.433,0.26 0.563,0.303 l 1.169,0.433 0.13,0.086 c 0.043,0.086 0.043,0.39 -0.043,0.909 -0.043,0.476 0.087,0.953 0.303,1.472 0.303,0.563 0.433,0.823 0.433,0.823 l 0.52,0.693 c 0.346,0.303 0.52,0.649 0.563,0.996 l 0.13,0.649 c 0,0.13 -0.043,0.346 -0.173,0.606 -0.13,0.303 -0.347,0.433 -0.649,0.433 -0.087,0.433 -0.173,0.736 -0.347,0.953 -0.303,0.216 -0.52,0.433 -0.649,0.563 -0.26,0.303 -0.303,0.563 -0.13,0.823 0.13,0.13 0.563,0 1.256,-0.347 0.779,-0.39 1.385,-0.433 1.775,-0.086 0.26,0.26 0.433,0.433 0.52,0.606 l 1.083,0.086 c 0.043,-0.043 0.216,-0.216 0.433,-0.433 0.216,-0.26 0.303,-0.39 0.346,-0.433 0.043,0 0.173,-0.173 0.52,-0.476 0.303,-0.347 0.52,-0.52 0.736,-0.563 l 0.563,0.086 c 0.13,0.13 0.303,0.39 0.52,0.823 0.346,0.13 0.649,0.086 0.866,-0.216 0.13,-0.173 0.303,-0.39 0.433,-0.693 l 1.039,-0.563 c 0.173,-0.043 0.39,-0.173 0.693,-0.26 0.26,-0.086 0.822,-0.26 1.731,-0.52 0.13,-0.086 0.217,-0.303 0.303,-0.563 0,-0.606 0.086,-1.039 0.173,-1.299 0.26,-0.303 0.866,-0.39 1.818,-0.173 0.216,0 0.433,0.303 0.606,0.779 0.78,-0.087 1.342,-0.13 1.732,-0.087 0.563,-0.043 0.909,-0.13 1.04,-0.26 0.129,-0.13 0.173,-0.476 0.173,-1.083 v -0.866 c -0.043,-0.086 -0.26,-0.216 -0.606,-0.346 -0.347,-0.087 -0.52,-0.26 -0.563,-0.39 l 0.086,-0.217 c 0,0 0.347,-0.39 0.996,-1.039 0.13,-0.043 0.303,-0.086 0.606,-0.173 0.043,-0.086 0.13,-0.173 0.173,-0.26 0.13,-0.39 0.26,-0.909 0.303,-1.472 0.043,-0.13 0.043,-0.303 -0.043,-0.477 -0.13,-0.173 -0.217,-0.26 -0.26,-0.346 l 0.043,-0.303 c 0.13,-0.26 0.563,-0.52 1.342,-0.779 0.043,-0.043 0.13,-0.216 0.26,-0.476 0.043,-0.173 0.173,-0.347 0.39,-0.433 l 0.303,-0.086 c 0.217,-0.043 0.52,-0.173 0.953,-0.477 0.13,0.043 0.346,0.087 0.563,0.216 0.043,0 0.173,-0.043 0.39,-0.086 0.173,-0.043 0.303,0 0.476,0.086 0.26,0.217 0.433,0.303 0.52,0.347 0.26,0 0.433,-0.086 0.52,-0.26 h 0.216 c 0.087,0.303 0.217,0.52 0.39,0.606 0.087,0.087 0.347,0.087 0.693,-0.043 0.39,-0.086 0.649,-0.216 0.779,-0.346 0.217,-0.086 0.477,0 0.736,0.26 h 0.13 l 0.13,-0.086 c 0.346,0 0.736,-0.043 1.169,-0.173 0.216,0 0.476,0.087 0.823,0.303 0.13,0.043 0.39,0.043 0.736,0.043 0.347,0.043 0.823,0.217 1.429,0.563 0.043,0.043 0.173,0.173 0.433,0.39 0.173,0.087 0.433,0.043 0.779,-0.043 0.173,0 0.563,0.043 1.169,0.086 0.217,-0.086 0.477,-0.303 0.823,-0.563 0.346,-0.303 0.649,-0.476 0.866,-0.563 0.216,-0.043 0.476,-0.043 0.866,0 0.086,0 0.216,-0.043 0.39,-0.087 0.043,0 0.433,0.13 1.126,0.303 0.129,0.043 0.26,0.043 0.476,-0.043 0.39,-0.086 0.779,0.043 1.212,0.347 0.043,0.043 0.173,0.26 0.346,0.692 l 0.043,0.087 0.173,0.086 c 0.13,-0.13 0.26,-0.346 0.303,-0.606 h 0.173 c 0.13,0.13 0.346,0.173 0.649,0.13 0.563,-0.563 1.039,-0.736 1.385,-0.477 0.173,0.043 0.606,-0.13 1.169,-0.433 0.173,-0.477 0.26,-0.823 0.347,-1.04 0.086,-0.433 0.13,-0.779 0.173,-0.952 l 0.129,-0.303 c 0.13,-0.216 0.39,-0.476 0.78,-0.736 0.043,-0.087 0.216,-0.13 0.39,-0.26 0.216,-0.173 0.346,-0.563 0.39,-1.169 -0.043,-0.736 -0.086,-1.342 -0.13,-1.818 0,-0.823 0.13,-1.342 0.476,-1.515 h 0.26 c 0.303,0.13 0.649,0.303 1.125,0.433 0.173,0.087 0.477,0.087 0.866,0.043 0.173,0 0.39,0.043 0.649,0.086 0.26,0.043 0.477,-0.043 0.649,-0.173 0.13,-0.13 0.173,-0.477 0.13,-0.996 0.086,-0.086 0.303,-0.13 0.606,-0.13 0.13,0 0.303,0 0.476,-0.043 l 0.823,0.086 c 0.13,0.043 0.346,0.173 0.649,0.303 0.346,0.13 0.909,0.303 1.645,0.563 l 0.953,0.606 c 0.26,0.216 0.477,0.909 0.649,2.035 0.043,0.217 0.217,0.347 0.52,0.39 0.216,-0.043 0.347,-0.13 0.477,-0.303 0.043,-0.087 0.13,-0.217 0.26,-0.477 l 0.216,-0.13 c 0.173,-0.173 0.39,-0.476 0.606,-0.953 0.043,-0.13 0.39,-0.259 1.083,-0.39 0.693,-0.13 1.212,-0.476 1.472,-0.996 l 0.13,-0.043 0.477,0.217 c 0.043,0.086 0.043,0.173 0.043,0.26 l -0.086,0.13 0.043,0.13 c 0.13,0.173 0.346,0.13 0.692,-0.043 0.303,-0.26 0.52,-0.346 0.649,-0.26 0.043,0.086 0.087,0.173 0.043,0.303 0.086,0.173 0.26,0.26 0.563,0.303 0.26,0 0.476,-0.043 0.606,-0.13 0.26,-0.216 0.477,-0.822 0.563,-1.731 -0.303,-0.303 -0.477,-0.477 -0.477,-0.52 l 0.477,-1.126 c 0.26,0 0.649,-0.173 1.255,-0.476 0.043,-0.087 0.217,-0.347 0.433,-0.866 0.043,-0.086 0.13,-0.216 0.303,-0.39 0.13,-0.216 0.303,-0.563 0.563,-1.039 0.043,-0.043 0.087,-0.13 0.13,-0.216 l 0.129,-0.087 c 0.173,0 0.563,0.13 1.169,0.433 0.086,-0.043 0.173,-0.086 0.216,-0.216 0.043,-0.13 0,-0.347 -0.173,-0.606 0,-0.086 0.043,-0.216 0.217,-0.39 0.173,-0.173 0.216,-0.303 0.216,-0.346 l 0.39,0.086 0.13,-0.043 0.347,-0.52 0.129,-0.043 0.303,0.173 c 0.086,0.13 0.086,0.39 0,0.866 0.13,0.043 0.303,0.13 0.52,0.303 0.043,0.13 0.043,0.303 0.043,0.52 0.086,0.216 0.52,0.346 1.342,0.476 0.39,-0.13 0.779,-0.433 1.125,-0.953 0.13,0.043 0.217,0.087 0.26,0.173 l 0.043,0.173 c -0.043,0.822 -0.043,1.299 -0.043,1.429 0.043,0.173 0.52,0.909 1.472,2.078 0.043,0.043 0.13,0.693 0.303,1.905 l 0.26,0.173 c 0.39,0.043 0.649,0.043 0.736,0 0.13,-0.043 0.173,-0.303 0.13,-0.692 0,-0.39 0.043,-0.606 0.173,-0.693 0.216,-0.086 0.52,0 0.909,0.303 0.39,0.346 0.779,0.476 1.126,0.39 0.043,0 0.216,-0.173 0.563,-0.433 0.39,-0.346 0.606,-0.606 0.693,-0.779 0.087,-0.217 0.173,-0.477 0.303,-0.736 0.086,-0.13 0.346,-0.086 0.736,0.087 0.087,0.043 0.39,0.216 0.823,0.52 l 0.13,0.13 c 0.086,0.043 0.173,0.086 0.216,0.216 0.086,0 0.173,0.043 0.26,0.13 0.433,0.13 0.736,0.173 0.909,0.087 l 0.347,-0.78 c 0,-0.086 0.13,-0.173 0.346,-0.216 0.216,-0.086 0.347,-0.13 0.477,-0.13 l 0.086,-0.086 c 0,-0.26 0.043,-0.433 0.13,-0.563 0.173,-0.13 0.39,-0.173 0.606,-0.13 0.173,-0.13 0.217,-0.433 0.173,-0.866 l -0.779,-0.129 c -0.563,-1.342 -0.823,-2.079 -0.866,-2.165 v -0.043 c -0.173,0.043 -0.39,0 -0.606,-0.13 -0.173,-0.13 -0.216,-0.26 -0.216,-0.52 0.043,-0.303 0,-0.476 0,-0.563 -0.52,-0.433 -0.866,-0.779 -1.083,-0.996 -0.347,-0.779 -0.606,-1.299 -0.736,-1.602 -0.043,0 -0.26,-0.216 -0.736,-0.563 -0.476,-0.563 -0.823,-0.952 -1.125,-1.169 -0.606,-0.346 -1.083,-0.606 -1.386,-0.822 -0.303,-0.26 -0.563,-0.433 -0.779,-0.52 -0.476,-0.217 -0.736,-0.347 -0.736,-0.39 -0.26,-0.346 -0.476,-0.606 -0.692,-0.736 -0.866,-0.173 -1.516,-0.39 -1.949,-0.606 -0.216,-0.13 -0.606,-0.563 -1.212,-1.256 l -0.996,-0.909 c -0.823,-0.476 -1.342,-0.736 -1.689,-0.909 0,0 -0.476,-0.086 -1.299,-0.216 -0.606,-0.087 -1.299,-0.347 -2.078,-0.823 -0.477,-0.52 -0.736,-0.866 -0.866,-0.996 -0.346,-0.26 -0.563,-0.433 -0.736,-0.563 l -0.563,-0.606 c -0.216,-0.13 -0.346,-0.26 -0.39,-0.303 -0.39,-0.433 -0.649,-0.692 -0.866,-0.822 -0.217,-0.13 -0.52,-0.173 -0.909,-0.087 -0.39,0.043 -0.649,-0.043 -0.866,-0.26 -0.13,-0.13 -0.303,-0.52 -0.52,-1.212 -0.216,-0.649 -0.476,-1.082 -0.866,-1.342 -0.173,-0.173 -0.433,-0.26 -0.692,-0.26 -0.347,0 -0.563,0 -0.649,-0.043 -0.216,-0.087 -0.433,-0.346 -0.693,-0.779 -0.303,-0.39 -0.52,-0.649 -0.779,-0.693 -0.086,-0.043 -0.476,-0.043 -1.083,0 -0.52,0 -0.952,-0.086 -1.255,-0.216 -0.303,-0.217 -0.736,-0.736 -1.299,-1.688 -0.519,-0.953 -0.866,-1.429 -0.952,-1.516 -0.347,-0.173 -0.866,-0.303 -1.559,-0.346 -0.649,-0.043 -1.169,-0.173 -1.472,-0.347 -0.26,-0.173 -0.606,-0.52 -0.953,-1.125 -0.563,-0.779 -0.866,-1.212 -0.909,-1.299 -0.173,-0.217 -0.606,-0.606 -1.299,-1.039 -0.649,-0.477 -1.083,-0.823 -1.256,-1.04 -0.39,-0.692 -0.649,-1.212 -0.866,-1.515 -0.346,-0.433 -0.563,-0.736 -0.649,-0.996 -0.043,-0.26 0,-0.649 0.13,-1.169 0.173,-0.563 0.216,-0.952 0.173,-1.169 h 0.043 c -0.173,-0.693 -0.303,-1.082 -0.303,-1.169 -0.173,-0.649 -0.26,-1.125 -0.346,-1.515 m 0.39,0 c -0.086,-0.043 -0.26,-0.043 -0.39,0 0.086,0.39 0.173,0.866 0.347,1.516 0,0.087 0.129,0.476 0.303,1.169 h 0.043 c 0.043,0 0.086,0.087 0.086,0.217 0.043,0.13 0.043,0.303 0.043,0.563 0,0.217 -0.043,0.693 -0.173,1.429 0.043,0.173 0.303,0.563 0.779,1.212 l 0.52,0.693 0.433,0.779 c 0,0.043 0.736,0.563 2.122,1.559 0.13,0.087 0.303,0.26 0.52,0.477 0.303,0.26 0.433,0.606 0.52,1.083 l 0.173,0.216 c 0.173,0.26 0.433,0.433 0.693,0.52 0.129,0.043 0.433,0.13 0.822,0.216 0.736,0.217 1.126,0.347 1.212,0.39 0.173,0 0.433,0 0.823,-0.086 0.303,-0.043 0.606,0 0.909,0.173 0.173,0.086 0.563,0.649 1.125,1.731 0.52,1.04 0.91,1.602 1.169,1.732 0.26,0.087 0.779,0.087 1.515,-0.086 0.13,0 0.39,-0.043 0.736,-0.086 0.303,-0.087 0.52,-0.217 0.693,-0.433 0.043,-0.043 0.087,-0.346 0.216,-0.823 0.043,-0.346 0.217,-0.606 0.477,-0.693 0.13,-0.043 0.346,-0.043 0.52,0.087 0.303,0.13 0.779,0.476 1.472,1.083 0.13,0.13 0.26,0.26 0.39,0.476 l 0.043,0.303 c 0.043,0.26 0.216,0.692 0.519,1.255 0.087,0.043 0.217,0.173 0.303,0.303 l 0.563,0.086 c 0.26,0.043 0.52,0.13 0.909,0.303 0.13,0 0.216,0 0.303,0.043 0.173,0.129 0.433,0.26 0.693,0.39 0.13,0.043 0.303,0 0.563,0 0.217,0 0.563,0 1.083,0.043 0.217,-0.043 0.433,-0.173 0.606,-0.39 0.26,-0.13 0.65,-0.086 1.212,0.13 0.477,0.173 1.126,0.736 1.905,1.688 0.173,0.13 0.433,0.303 0.736,0.563 0.173,0.13 0.433,0.347 0.823,0.649 0,0.043 0.13,0.173 0.303,0.39 0.606,0.563 1.083,0.953 1.515,1.212 0.173,0.087 0.433,0.173 0.823,0.303 0.52,0.216 0.953,0.433 1.342,0.693 l 0.433,0.216 c 0.173,0.043 0.347,-0.043 0.563,-0.216 0.216,-0.217 0.346,-0.26 0.519,-0.173 0.087,0.086 0.173,0.346 0.217,0.693 0.13,0.216 0.346,0.39 0.693,0.606 0.086,0 0.129,0.086 0.26,0.173 0.39,0.303 0.909,0.433 1.559,0.476 0.476,0.043 0.952,0 1.385,-0.13 0.563,-0.216 0.78,-0.52 0.563,-0.953 -0.13,-0.303 -0.347,-0.52 -0.693,-0.649 -0.563,-0.173 -0.866,-0.303 -0.909,-0.346 -0.303,-0.173 -0.433,-0.433 -0.476,-0.736 0,-0.476 -0.043,-0.736 -0.086,-0.822 -0.087,-0.173 -0.39,-0.39 -0.866,-0.736 -0.476,-0.26 -0.736,-0.52 -0.779,-0.736 0.303,-0.649 0.52,-1.039 0.563,-1.212 0.259,-0.606 0.433,-1.169 0.476,-1.602 0.043,-0.476 0.086,-0.866 0.13,-1.083 0.043,-0.173 0.13,-0.303 0.216,-0.39 0.13,-0.086 0.477,-0.173 1.083,-0.26 0.13,-0.043 0.346,-0.13 0.736,-0.26 0.087,0.043 0.173,0.13 0.173,0.217 0.043,0.086 0.086,0.303 0.173,0.606 0.043,0.13 0.13,0.303 0.216,0.476 0.043,0 0.086,0 0.13,0 0.347,-0.303 0.433,-0.692 0.39,-1.212 -0.173,-0.606 -0.259,-0.996 -0.259,-1.256 -0.13,-0.173 -0.347,-0.39 -0.736,-0.606 -0.39,-0.26 -0.606,-0.477 -0.693,-0.736 -0.043,-0.173 -0.043,-0.52 0,-0.953 0.043,-0.476 0.043,-0.779 -0.043,-0.909 -0.086,-0.086 -0.346,-0.216 -0.779,-0.346 -1.948,-0.736 -2.987,-1.169 -3.16,-1.212 -0.087,-0.086 -0.087,-0.563 0,-1.385 0.086,-0.823 0.043,-1.256 -0.087,-1.386 -0.779,-0.606 -1.169,-0.909 -1.212,-0.909 -0.216,0.216 -0.476,0.303 -0.693,0.303 -0.086,-0.26 -0.173,-0.433 -0.26,-0.477 -0.129,-0.173 -0.39,-0.433 -0.692,-0.779 -0.173,-0.13 -0.433,-0.086 -0.866,0.217 -0.433,0 -1.083,-0.866 -1.948,-2.468 -0.173,-0.303 -0.26,-0.563 -0.346,-0.693 -0.043,-0.217 0,-0.39 0.086,-0.563 0.13,-0.173 0.303,-0.26 0.52,-0.217 0.173,0.173 0.303,0.217 0.39,0.26 0.39,-0.303 0.606,-0.52 0.606,-0.649 -0.173,-0.26 -0.303,-0.477 -0.303,-0.65 -0.043,-0.173 0,-0.606 0.173,-1.255 0.173,-0.606 0.217,-0.996 0.173,-1.169 -0.086,-0.13 -0.13,-0.217 -0.13,-0.217 -0.996,-0.563 -1.602,-1.082 -1.775,-1.645 -0.13,-0.606 -0.26,-1.039 -0.39,-1.256 l -0.347,-0.692 c -0.476,0.216 -0.779,0.303 -0.909,0.26 l -1.169,-0.433 -0.216,-0.173 c 0,-0.39 -0.087,-0.866 -0.347,-1.515 -0.26,-0.563 -0.39,-0.909 -0.346,-1.039 0.13,0.043 0.606,-0.13 1.472,-0.433 l 0.086,-0.13 c -0.086,-0.476 -0.13,-0.779 -0.216,-0.953 l -0.433,-0.39 c -0.13,0 -0.303,0.13 -0.649,0.433 -0.346,0.26 -0.606,0.39 -0.736,0.39 -0.13,-0.043 -0.216,-0.086 -0.259,-0.173 -0.13,-0.606 -0.39,-0.953 -0.78,-1.039 -0.606,-0.086 -0.952,-0.216 -1.083,-0.346 0,-0.347 -0.086,-0.606 -0.129,-0.779 -0.39,-0.26 -0.65,-0.52 -0.78,-0.736 0,-0.216 -0.086,-0.476 -0.13,-0.736 -0.129,-0.087 -0.173,-0.173 -0.173,-0.216 -0.173,-0.173 -0.433,-0.173 -0.736,0 l -0.173,-0.13 c -0.087,0 -0.26,-0.087 -0.563,-0.26 -0.39,-0.259 -0.693,-0.39 -0.909,-0.346 -0.39,0.043 -0.736,0.26 -0.996,0.606 -0.346,0.389 -0.433,0.779 -0.346,1.169 0.043,0.173 0.216,0.433 0.563,0.866 0.303,0.433 0.043,0.996 -0.822,1.775 -0.346,0.26 -0.606,0.433 -0.736,0.476 -0.26,0.043 -0.477,-0.086 -0.736,-0.433 l -0.13,0.13 c -0.086,0.736 -0.39,1.256 -0.866,1.472 -0.563,0.26 -0.909,0.52 -0.953,0.736 v 0.173 c 0.086,0.173 0.173,0.477 0.303,0.823 0.043,0.13 0.043,0.303 0.043,0.563 l 0.087,0.606 c 0.086,0.433 0.216,0.693 0.346,0.823 -0.043,0.39 -0.26,0.649 -0.779,0.779 -0.779,0.173 -1.212,0.303 -1.299,0.346 0,0.087 0,0.39 0.086,0.909 0.086,0.519 0.086,0.91 0,1.169 -0.216,0.476 -0.476,0.952 -0.823,1.385 -0.303,0.26 -0.433,0.476 -0.476,0.563 0.086,0.563 0.086,0.866 -0.043,0.996 -0.346,0.347 -0.563,0.563 -0.606,0.606 -0.39,0.866 -0.693,1.342 -0.866,1.515 -1.299,-0.26 -2.035,-0.39 -2.208,-0.433 -0.563,-0.087 -0.866,-0.173 -0.909,-0.217 -0.043,-0.044 -0.043,-0.433 0,-1.125 0,-0.477 -0.216,-0.693 -0.649,-0.563 -0.087,0.043 -0.13,0.346 -0.13,0.823 -0.043,0.433 -0.216,0.736 -0.563,0.909 -0.173,0.13 -0.433,0.173 -0.649,0.043 -0.216,-0.26 -0.39,-0.433 -0.606,-0.477 -0.217,0.043 -0.39,0.216 -0.433,0.606 -0.043,0.433 -0.087,0.649 -0.173,0.692 h -0.173 c -0.087,-0.173 -0.173,-0.26 -0.217,-0.346 -0.216,-0.173 -0.346,-0.303 -0.39,-0.433 -0.043,-0.39 -0.086,-0.649 -0.13,-0.823 -0.303,-0.13 -0.476,-0.346 -0.52,-0.649 -0.09,-0.39 -0.177,-0.606 -0.263,-0.693",						
			"Crimea": "m 365.944,299.206 h -0.303 c -0.52,0.303 -0.649,0.866 -0.433,1.732 l 0.217,0.736 c 0,0.086 0.086,0.259 0.173,0.519 0.043,0.087 0.043,0.26 0.043,0.477 0.043,0.563 -0.043,0.953 -0.303,1.212 -0.13,0.13 -0.303,0.217 -0.476,0.26 0.086,0.173 0.26,0.476 0.476,0.866 0.217,0.39 0.303,0.736 0.303,0.953 -0.043,0.216 -0.26,0.433 -0.563,0.649 -0.043,0.086 -0.043,0.477 -0.043,1.255 0,0.39 0.216,0.693 0.606,0.91 v 0.173 c -0.043,0.043 -0.13,0.173 -0.303,0.303 -0.216,0.086 -0.346,0.216 -0.39,0.433 0,0.086 0.13,0.303 0.39,0.606 0.173,0.216 0.26,0.433 0.217,0.649 0,0.086 -0.173,0.303 -0.476,0.736 -0.26,0.347 -0.303,0.606 -0.13,0.736 0.173,0.043 0.347,-0.043 0.52,-0.303 0.173,-0.303 0.347,-0.476 0.433,-0.52 0.173,-0.086 0.39,-0.086 0.649,0.043 0.173,0.043 0.39,0.13 0.649,0.216 0.26,0.086 0.563,0.13 0.996,0.173 0.303,0.043 0.606,0.216 0.866,0.476 0.173,0.217 0.26,0.39 0.26,0.563 0,0.087 -0.086,0.173 -0.173,0.216 -0.39,-0.173 -0.866,-0.086 -1.299,0.26 -0.13,0.043 -0.216,0.129 -0.216,0.129 -0.347,-0.043 -0.606,0 -0.779,0.087 -0.13,0.13 -0.13,0.476 0,1.083 0.173,0.563 0.13,0.952 -0.043,1.169 0,0 -0.086,0.043 -0.26,0.086 -0.346,0.087 -0.606,-0.043 -0.909,-0.39 -0.303,-0.433 -0.563,-0.606 -0.779,-0.606 -0.13,0 -0.433,0.086 -0.866,0.303 -0.477,0.173 -0.736,0.303 -0.823,0.39 -0.043,0.043 -0.086,0.217 -0.173,0.563 -0.043,0.217 -0.216,0.39 -0.476,0.477 -0.52,0.173 -0.909,0.129 -1.212,-0.087 -0.39,-0.216 -0.606,-0.346 -0.649,-0.346 -0.13,0.043 -0.217,0.13 -0.303,0.303 -0.043,0.13 -0.13,0.217 -0.173,0.26 -0.26,-0.043 -0.433,-0.043 -0.519,-0.043 -0.39,0 -0.693,0.086 -0.953,0.346 -0.13,0.086 -0.52,0.563 -1.083,1.386 -0.303,0.26 -0.996,0.736 -2.035,1.385 -1.169,0.693 -1.862,1.039 -2.165,1.039 -0.217,0.043 -0.347,0 -0.477,-0.13 -0.13,-0.173 -0.173,-0.303 -0.26,-0.346 -0.433,-0.173 -0.736,-0.39 -0.866,-0.606 -0.043,-0.433 -0.173,-0.693 -0.347,-0.736 -0.13,0.043 -0.216,0.173 -0.259,0.347 -0.087,0.346 0,0.649 0.39,0.996 0.303,0.26 0.39,0.476 0.26,0.649 -0.217,0.173 -0.563,0.26 -1.083,0.347 -0.39,0.216 -0.953,0.519 -1.646,1.039 -0.433,0.216 -1.125,0.519 -2.035,0.909 l -2.122,1.083 c -0.173,0.043 -0.389,0.129 -0.649,0.259 -0.476,0.26 -1.082,0.78 -1.818,1.559 -0.26,0.173 -0.606,0.476 -1.082,0.822 -0.173,0.217 -0.303,0.347 -0.347,0.52 -0.086,0.13 0.043,0.347 0.26,0.649 0.217,0.26 0.173,0.52 -0.086,0.823 -0.173,0.173 -0.52,0.13 -1.125,-0.043 -0.606,-0.216 -0.953,-0.303 -1.126,-0.173 -0.087,0.043 -0.26,0.303 -0.477,0.779 -0.173,0.39 -0.433,0.693 -0.736,0.866 -0.26,0.129 -0.606,0.216 -1.039,0.259 -0.433,0.087 -0.779,0.13 -0.909,0.217 -0.303,0.173 -0.649,0.433 -1.083,0.909 -0.39,0.26 -0.996,0.693 -1.862,1.212 -0.563,0.563 -1.083,1.299 -1.515,2.165 -0.043,0.129 -0.086,0.303 -0.173,0.563 0,0.043 -0.086,0.216 -0.13,0.477 -0.043,0.129 0.13,0.433 0.476,0.909 0.043,0.086 0.087,0.39 0.087,0.822 -0.043,0.39 0.086,0.649 0.26,0.779 0.52,0.087 0.909,0.173 1.169,0.347 0.433,0.39 0.736,0.606 0.866,0.606 0.13,0 0.347,0 0.606,-0.043 0.26,-0.043 0.476,-0.043 0.649,0.043 0.216,0.043 0.52,0.13 0.866,0.303 0.13,0 0.26,-0.043 0.39,-0.086 0.13,-0.347 0.26,-0.606 0.39,-0.693 0.39,-0.346 0.736,-0.606 0.953,-0.779 l 0.433,-0.39 c 0.173,-0.087 0.433,-0.087 0.823,-0.043 0.216,0 0.476,0.043 0.866,0.086 0.26,0 0.736,-0.086 1.472,-0.26 0.173,-0.043 0.476,-0.043 0.866,0.043 0.087,0 0.477,0.13 1.169,0.347 0.736,0.216 1.082,0.346 1.125,0.389 0.26,0.173 0.563,0.433 0.996,0.866 0.129,0.086 0.519,0.346 1.082,0.693 l 0.303,-0.347 c -0.173,0.087 -0.346,0.087 -0.606,-0.086 -0.129,-0.086 -0.346,-0.39 -0.692,-0.823 -0.303,-0.52 -0.476,-0.823 -0.433,-0.953 l 0.086,-0.13 0.13,-0.043 c 0.13,0.043 0.303,0.13 0.477,0.26 0.13,0.086 0.303,0 0.476,-0.217 0.13,-0.13 0.217,-0.26 0.26,-0.346 0.303,-0.043 0.563,-0.087 0.736,-0.13 0.13,-0.216 0.26,-0.39 0.347,-0.476 l 0.26,-0.087 c 0.39,-0.086 0.606,-0.173 0.693,-0.216 0.043,-0.043 0.173,-0.13 0.346,-0.217 0,0 0.173,-0.043 0.39,-0.129 0.26,-0.087 0.649,-0.39 1.212,-0.91 h 0.173 c 0,0.043 -0.043,0.303 -0.26,0.779 -0.173,0.433 -0.347,0.736 -0.433,0.866 -0.13,0.13 -0.476,0.216 -0.953,0.216 -0.476,-0.043 -0.823,0.043 -0.996,0.26 -0.173,0.13 -0.217,0.347 -0.173,0.649 0,0.347 0,0.563 -0.043,0.649 l -0.086,0.087 c -0.26,-0.087 -0.39,-0.13 -0.52,-0.087 -0.086,0.087 -0.173,0.217 -0.173,0.563 -0.043,0.26 -0.086,0.433 -0.216,0.52 l -0.303,0.347 c 0.13,0.086 0.52,0.39 1.126,0.952 0.563,0.52 0.952,0.866 1.039,0.996 0.649,0.823 1.039,1.255 1.169,1.385 0.086,0.087 0.26,0.303 0.52,0.649 0.346,0.433 0.736,0.823 1.083,1.169 0.173,0.129 0.563,0.216 1.125,0.216 0.303,0.086 0.606,0.346 0.953,0.779 0.303,0.39 0.606,0.606 0.953,0.606 0.216,0.043 0.52,-0.216 0.866,-0.649 0.087,-0.086 0.13,-0.173 0.173,-0.216 0.216,-0.086 0.476,-0.086 0.822,0 0.043,-0.043 0.217,-0.13 0.52,-0.303 0.433,-0.346 0.909,-0.39 1.429,-0.086 0.13,0.043 0.303,0.13 0.476,0.303 0.217,0.13 0.736,0.606 1.602,1.515 0.173,0.086 0.477,0.217 0.909,0.39 l 0.476,-1.255 c -0.173,0 -0.389,-0.13 -0.736,-0.347 -0.26,-0.173 -0.52,-0.39 -0.649,-0.649 -0.303,-0.39 -0.476,-0.606 -0.563,-0.736 l -0.52,-0.303 c -0.13,-0.13 -0.216,-0.26 -0.303,-0.303 0,-0.13 0,-0.217 0.043,-0.347 0.043,-0.086 0.477,-0.13 1.169,-0.13 0.173,-0.13 0.259,-0.216 0.346,-0.26 0.433,-0.39 0.693,-0.606 0.736,-0.606 l 0.043,0.13 c -0.173,0.433 -0.26,0.736 -0.217,0.779 0.173,0.043 0.477,-0.13 0.823,-0.433 0.216,-0.043 0.433,0 0.606,0.216 0.173,0.043 0.39,0 0.779,-0.086 l 0.39,0.173 0.043,0.13 c 0.043,0.13 0,0.216 -0.087,0.303 -0.043,0.043 -0.26,0.043 -0.649,0 -0.303,-0.043 -0.563,0.087 -0.736,0.303 -0.087,0.086 -0.087,0.217 -0.043,0.39 l 0.043,0.087 c 0.173,0.086 0.433,0.216 0.736,0.39 0.303,0.303 0.26,0.649 -0.13,0.996 -0.346,0.303 -0.736,0.39 -1.126,0.303 l -0.476,1.255 c 0.087,0.043 0.26,0.173 0.433,0.39 0.823,0.649 1.342,1.299 1.516,1.948 0.086,0.303 0.173,0.78 0.259,1.516 0.043,0.173 0.043,0.52 0,0.996 0,0.433 0.087,0.736 0.26,0.822 0,0.043 0,0.043 0,0.086 0.216,0.39 0.346,0.606 0.389,0.78 0.13,0.303 0.26,0.909 0.433,1.732 0.13,0.822 0.173,1.385 0.13,1.731 -0.043,0.217 -0.173,0.65 -0.346,1.169 -0.13,0.78 -0.217,1.169 -0.26,1.212 -0.086,0.086 -0.303,0.13 -0.736,0.173 -0.043,0 -0.043,0 -0.087,0.043 l 0.13,0.649 c 0,0.13 0.13,0.346 0.303,0.606 0.086,0.13 0.216,0.216 0.346,0.303 l 2.944,0.996 0.043,0.909 -2.425,0.693 0.043,1.516 1.948,0.13 c 0.13,0.216 0.216,0.216 0.26,0.043 l 0.043,-0.433 0.563,-0.043 -0.086,0.303 0.39,0.346 0.303,-0.476 0.26,0.13 0.476,0.606 c 0.086,0.086 0.346,0.173 0.779,0.346 l 0.043,0.52 -0.649,0.563 v 0.477 l -0.823,1.212 -0.216,-0.13 -0.39,0.606 0.216,0.13 -0.26,0.346 0.477,1.083 0.39,0.087 0.303,-0.26 0.216,0.217 0.477,-0.39 0.303,0.39 v 0.303 l 0.692,0.217 -0.043,0.39 c -0.13,0.26 -0.13,0.52 0.043,0.779 l 0.477,0.736 -0.043,0.866 0.563,0.476 0.173,-0.043 0.303,0.216 -0.303,0.346 0.303,0.303 0.086,0.692 0.563,-0.303 0.303,0.216 -0.303,0.477 0.866,1.905 -0.26,0.303 -2.338,-0.736 -1.039,0.563 -0.433,-0.346 -0.433,0.173 0.043,0.692 h -0.39 l -0.26,0.173 v 0.476 c 0.087,-0.043 0.173,-0.043 0.303,-0.043 0.173,0 0.433,0.086 0.779,0.216 0.173,0.043 0.26,0.043 0.303,0.043 0.173,0 0.433,-0.13 0.779,-0.303 0.303,-0.216 0.563,-0.303 0.779,-0.26 0.303,0 0.736,0.173 1.299,0.433 0.563,0.26 0.996,0.39 1.342,0.39 h 0.476 c 0.043,-0.043 0.13,-0.043 0.26,-0.043 0.26,-0.086 0.563,-0.26 0.996,-0.52 0.043,-0.043 0.26,-0.086 0.693,-0.173 0.173,-0.043 0.346,-0.216 0.606,-0.52 0.086,-0.043 0.26,-0.13 0.476,-0.216 0.087,-0.043 0.217,-0.086 0.39,-0.173 0.13,-0.043 0.39,-0.086 0.692,-0.13 0.78,-0.303 1.299,-0.563 1.559,-0.866 0,-0.043 0.217,-0.477 0.65,-1.256 0.216,-0.476 0.433,-0.779 0.649,-0.952 0.043,0 0.173,-0.043 0.433,-0.087 l 0.26,-0.13 c 0.217,-0.043 0.563,-0.086 1.039,-0.086 0.13,-0.26 0.26,-0.433 0.303,-0.563 0.217,-0.996 0.433,-1.515 0.606,-1.559 0.086,-0.043 0.433,0 0.953,0.13 0.476,0.086 0.779,0.043 0.952,-0.26 0.13,-0.649 0.26,-1.126 0.347,-1.342 0.216,-0.433 0.433,-0.779 0.52,-0.953 0.26,-0.779 0.476,-1.342 0.606,-1.688 0.476,-0.606 0.736,-1.039 0.909,-1.385 0.216,-0.606 0.433,-1.083 0.649,-1.429 0.303,-0.692 0.693,-1.039 1.039,-1.082 0.173,-0.087 0.303,-0.13 0.347,-0.13 0.952,-0.693 1.472,-1.039 1.602,-1.083 0.087,-0.043 0.217,-0.043 0.39,-0.043 0.346,-0.086 0.909,-0.26 1.602,-0.476 0.26,-0.13 0.693,-0.217 1.256,-0.303 0.346,-0.173 0.736,-0.52 1.125,-1.039 l 0.433,-0.303 c 0.563,-0.39 1.039,-0.563 1.429,-0.606 0.823,-0.043 1.342,-0.043 1.602,0.043 0.563,0.173 0.823,0.26 0.909,0.217 0,0 0.173,-0.13 0.39,-0.433 l 0.043,-0.086 c 0.216,-0.087 0.476,0 0.693,0.216 0.26,0.217 0.476,0.303 0.693,0.26 0.173,-0.086 0.303,-0.26 0.433,-0.52 0.173,-0.346 0.303,-0.52 0.476,-0.606 0.087,-0.043 0.303,-0.087 0.563,-0.087 0.433,-0.13 0.823,-0.13 1.212,-0.043 0.173,0.043 0.303,0.086 0.433,0.216 0.086,0.043 0.433,0.52 0.996,1.342 0.087,0.043 0.13,0.173 0.217,0.346 0.303,0.39 0.692,0.476 1.125,0.217 0.39,-0.217 0.693,-0.649 0.909,-1.342 0.13,-0.823 0.26,-1.386 0.39,-1.688 0.043,-0.217 0.173,-0.52 0.347,-0.909 0.173,-0.347 0.303,-0.563 0.433,-0.649 0.347,-0.39 0.823,-0.65 1.342,-0.736 0.519,-0.086 0.823,-0.216 0.909,-0.26 0.043,-0.086 0.173,-0.39 0.303,-0.953 0.13,-0.563 0.346,-0.866 0.563,-0.996 0.346,-0.173 0.779,-0.087 1.299,0.173 l 0.563,-0.39 c 0.26,0.087 0.606,0.39 1.125,0.953 l 0.173,0.043 c 0.086,-0.087 0.173,-0.173 0.173,-0.216 0,-0.173 -0.086,-0.433 -0.26,-0.823 -0.173,-0.347 -0.13,-0.649 0.043,-0.909 0.173,-0.303 0.563,-0.433 1.169,-0.39 0.563,0 0.909,-0.087 0.953,-0.347 v -0.13 c -0.086,-0.13 -0.303,-0.216 -0.649,-0.346 -0.26,-0.086 -0.433,-0.26 -0.477,-0.433 -0.043,-0.086 -0.043,-0.346 0.043,-0.736 0.173,-0.736 0.866,-1.516 2.079,-2.338 0.086,-0.043 0.303,-0.217 0.563,-0.347 0.173,-0.13 0.477,-0.39 0.996,-0.779 0.563,-0.216 1.299,-0.216 2.165,-0.043 1.126,0.173 1.948,0.477 2.511,0.823 0.347,0.216 0.563,0.39 0.606,0.433 l 0.606,0.303 c 0.086,0 0.26,0.129 0.52,0.303 0.216,0.13 0.477,0.347 0.823,0.649 0.173,0.13 0.433,0.26 0.736,0.52 0.086,0.087 0.13,0.26 0.26,0.477 l 0.216,0.346 c 0.217,0.303 0.433,0.736 0.606,1.299 0.13,0.303 0.217,0.52 0.26,0.52 0.13,0.086 0.39,0.173 0.649,0.217 0.087,0 0.649,-0.173 1.688,-0.433 0.433,-0.216 0.693,-0.39 0.693,-0.39 0.173,0 0.433,0.086 0.779,0.303 0.346,0.13 0.606,0.173 0.823,0.087 0.173,-0.087 0.39,-0.39 0.606,-0.996 0.217,-0.52 0.477,-0.866 0.78,-0.952 0.173,0 0.476,0 0.996,0 0.52,0.043 0.823,0.086 0.909,0.173 0.606,0.477 0.909,0.693 0.953,0.693 0.39,0.13 1.039,0.26 1.948,0.433 0.173,0 0.476,0.086 0.823,0.216 0.26,0 0.476,-0.26 0.649,-0.693 0.216,-0.52 0.433,-0.779 0.606,-0.822 0.173,-0.087 0.823,-0.087 1.905,0 0.13,0 0.346,0 0.606,-0.043 l 0.303,0.043 c 0.173,0 0.693,-0.347 1.516,-0.909 0.649,-0.303 0.996,-0.433 0.996,-0.477 0.173,-0.13 0.216,-0.346 0.173,-0.606 -0.303,-0.39 -0.476,-0.606 -0.563,-0.779 -0.563,-0.823 -0.866,-1.429 -0.953,-1.905 -0.13,-0.866 -0.043,-1.992 0.39,-3.42 0.173,-0.433 0.303,-0.779 0.347,-0.996 -0.087,-0.52 -0.043,-0.91 0,-1.212 0.086,-0.303 0.389,-0.476 0.909,-0.52 0.606,-0.087 0.909,-0.173 0.996,-0.303 0.13,-0.13 0.13,-0.26 0.086,-0.433 -0.173,-0.303 -0.303,-0.52 -0.39,-0.693 -0.173,-0.259 -0.173,-0.519 0.043,-0.822 0.086,-0.217 0.26,-0.303 0.476,-0.347 0.303,-0.13 0.693,-0.13 1.126,0 0.13,0 0.39,0.13 0.693,0.39 0.173,0.043 0.476,0.087 0.909,0.13 0.476,-0.043 0.779,-0.086 0.952,-0.13 0.13,-0.129 0.26,-0.303 0.303,-0.563 0.043,-0.043 0,-0.563 0,-1.472 -0.216,-0.39 -0.346,-0.649 -0.433,-0.823 -0.173,-0.346 -0.26,-0.606 -0.347,-0.779 -0.173,-0.303 -0.433,-0.476 -0.692,-0.433 -0.13,-0.043 -0.39,0.13 -0.78,0.477 -0.303,0.303 -0.606,0.39 -0.823,0.26 -0.086,0 -0.173,-0.13 -0.346,-0.26 -0.26,-0.347 -0.476,-0.606 -0.606,-0.823 -0.303,-0.303 -0.52,-0.476 -0.779,-0.39 -0.087,0 -0.303,0.043 -0.52,0.173 -0.346,0.087 -0.519,0.13 -0.563,0.173 l -0.39,0.043 c -0.606,0.043 -1.083,-0.086 -1.429,-0.39 -0.433,-0.39 -0.692,-0.563 -0.822,-0.606 -0.217,0 -0.433,0.13 -0.736,0.477 -0.26,0.303 -0.477,0.39 -0.693,0.303 l -0.13,-0.086 c -0.043,-0.173 0.043,-0.346 0.26,-0.476 0.216,-0.13 0.303,-0.346 0.303,-0.563 l -0.086,-0.13 c -0.043,-0.043 -0.26,0 -0.606,0.043 l -1.039,0.086 c -0.563,-0.043 -0.996,0 -1.256,0.043 -0.476,0.173 -0.909,0.216 -1.342,0.173 l -0.822,-0.13 c -0.087,0.043 -0.736,0.52 -2.035,1.429 -0.087,0.086 -0.26,0.563 -0.563,1.429 -0.303,0.822 -0.606,1.342 -0.909,1.515 -0.303,0.173 -0.779,0.217 -1.342,0.13 -0.606,-0.13 -0.996,-0.26 -1.299,-0.476 -0.26,-0.26 -0.476,-0.476 -0.693,-0.563 -0.866,-0.606 -1.342,-0.952 -1.472,-1.039 l -0.477,-0.173 c 0.043,0.217 0.173,0.477 0.347,0.779 0,0.13 0.086,0.26 0.259,0.477 0.087,0.173 0.087,0.303 -0.043,0.476 -0.216,0.043 -0.563,0.39 -1.04,0.996 -0.433,0.52 -0.822,0.692 -1.255,0.563 -0.26,-0.173 -0.346,-0.563 -0.26,-1.169 l 0.087,-0.086 c 0.043,-0.086 0.216,-0.13 0.389,-0.13 l 1.039,-0.736 c 0.087,-0.129 0.13,-0.346 0.087,-0.606 -0.087,-0.346 -0.13,-0.563 -0.13,-0.606 l 0.13,-0.13 h 0.13 l 0.26,0.173 0.477,0.173 c -0.303,-0.39 -0.477,-0.909 -0.477,-1.559 l 0.087,-0.086 c 0,-0.043 0.086,-0.043 0.303,-0.087 0.13,-0.043 0.216,-0.13 0.303,-0.26 -0.043,-0.303 -0.26,-0.52 -0.606,-0.649 -0.39,-0.173 -0.693,-0.13 -0.866,0.087 -0.13,0.129 -0.303,0.563 -0.433,1.212 -0.173,0.736 -0.303,1.256 -0.476,1.472 -0.216,0.39 -0.433,0.649 -0.649,0.823 -0.346,0.26 -0.563,0.433 -0.563,0.52 -0.043,0.086 -0.043,0.216 0,0.39 -0.043,0.173 -0.173,0.303 -0.346,0.39 -0.13,0.39 -0.26,0.649 -0.347,0.823 -0.173,0.216 -0.649,0.433 -1.515,0.649 -0.909,0.173 -1.472,0.303 -1.688,0.39 l -1.342,0.649 c -0.303,0.13 -0.693,0.26 -1.212,0.433 -0.606,0.13 -0.996,0.13 -1.212,0.043 -0.606,-0.216 -1.039,-0.563 -1.342,-0.953 -0.173,-0.303 -0.303,-0.476 -0.433,-0.563 -0.347,-0.13 -0.65,-0.26 -0.779,-0.39 -0.433,-0.26 -1.169,-0.866 -2.165,-1.732 -0.173,-0.216 -0.649,-0.909 -1.386,-2.122 l -0.216,-0.39 c -0.39,-0.477 -0.649,-0.866 -0.866,-1.126 -0.39,-0.606 -0.693,-1.082 -0.823,-1.472 l -1.169,-1.775 c -0.303,-0.649 -0.563,-1.083 -0.693,-1.385 -0.433,-0.477 -0.693,-0.866 -0.866,-1.083 -0.217,-0.303 -0.52,-0.779 -0.909,-1.472 -0.26,-0.346 -0.433,-0.606 -0.563,-0.779 -0.303,-0.477 -0.52,-0.779 -0.563,-0.996 -0.173,-0.477 -0.346,-0.823 -0.433,-1.083 -0.173,-0.26 -0.26,-0.477 -0.346,-0.606 -0.043,-0.216 -0.13,-0.346 -0.13,-0.433 -0.477,-0.563 -0.823,-1.04 -0.953,-1.386 -0.043,-0.13 -0.086,-0.26 -0.13,-0.346 -0.086,0.086 -0.13,0.216 -0.216,0.303 -0.13,0.043 -0.26,0.043 -0.39,0.087 0.043,0.043 0.086,0.13 0.173,0.216 0.043,0.13 0.087,0.346 0.087,0.606 0,0.087 0.043,0.303 0.173,0.563 l 0.087,0.173 c 0.043,0.13 0.173,0.346 0.346,0.563 0.043,0.173 0.173,0.39 0.303,0.692 l 0.086,0.26 c 0.13,0.129 0.433,0.39 0.823,0.736 0.173,0.346 0.303,0.606 0.303,0.822 0.043,0.13 0.086,0.347 0.086,0.606 0.173,0.26 0.563,0.779 1.299,1.516 0.173,0.259 0.433,0.692 0.779,1.342 l 1.126,1.429 c 0.13,0.173 0.26,0.39 0.433,0.736 0.087,0.13 0.477,0.693 1.169,1.775 0,0.043 0.217,0.303 0.563,0.78 0.347,0.476 0.736,1.212 1.212,2.294 0.303,0.39 0.52,0.649 0.606,0.736 0.173,0.086 0.39,0.303 0.736,0.52 0.086,0.173 0.26,0.563 0.52,1.169 0.086,0.13 0.346,0.216 0.736,0.346 0.043,0.087 0.087,0.13 0.173,0.173 0.13,0.173 0.303,0.433 0.476,0.823 0.043,0.043 0.13,0.086 0.217,0.216 0.173,0.043 0.433,0.086 0.779,0.086 0.086,0.087 0.26,0.217 0.606,0.39 0.217,0.173 0.39,0.347 0.433,0.477 0.086,0.13 0.043,0.346 -0.086,0.606 -0.39,0.779 -1.083,0.996 -2.035,0.563 -0.216,-0.13 -0.433,-0.347 -0.606,-0.693 -0.217,-0.39 -0.477,-0.693 -0.736,-0.823 -0.476,-0.043 -0.822,-0.13 -1.082,-0.216 -0.347,-0.216 -0.606,-0.39 -0.78,-0.476 -0.52,-0.13 -0.909,-0.26 -1.169,-0.39 -0.606,-0.433 -1.039,-0.78 -1.342,-0.996 -0.303,-0.216 -0.692,-0.173 -1.125,0.216 -0.39,0.303 -0.693,0.26 -0.996,-0.086 -0.173,-0.303 -0.347,-0.52 -0.477,-0.649 -0.563,-0.303 -0.953,-0.563 -1.125,-0.779 -0.13,-0.173 -0.26,-0.346 -0.303,-0.476 0,-0.52 -0.216,-0.953 -0.606,-1.386 -0.346,-0.39 -0.563,-0.606 -0.519,-0.736 0,-0.173 0.086,-0.303 0.26,-0.389 0.086,-0.043 0.259,-0.087 0.563,-0.13 0.866,-0.303 1.386,-0.736 1.646,-1.299 0.043,-0.173 0.043,-0.39 -0.086,-0.65 -0.13,-0.26 -0.217,-0.476 -0.26,-0.606 0.087,-0.736 0.087,-1.256 0,-1.688 -0.173,-0.52 -0.389,-0.996 -0.692,-1.386 -0.303,-0.303 -0.477,-0.476 -0.563,-0.649 -0.086,-0.086 -0.086,-0.303 -0.086,-0.606 0.043,-0.303 0,-0.477 -0.13,-0.606 -0.39,-0.216 -0.693,-0.433 -0.866,-0.606 -0.173,-0.216 -0.303,-0.346 -0.39,-0.39 -0.086,-0.173 -0.173,-0.477 -0.26,-0.909 -0.043,-0.39 -0.216,-0.649 -0.433,-0.866 -0.216,-0.13 -0.476,-0.173 -0.866,0 -0.39,0.13 -0.649,0.173 -0.779,0.13 -0.303,-0.087 -0.52,-0.347 -0.779,-0.823 -0.173,-0.39 -0.649,-0.692 -1.472,-0.822 V 322.8 c 0.736,-0.52 1.083,-0.953 1.083,-1.342 l -0.087,-0.086 c -0.173,-0.043 -0.346,0 -0.519,0.173 -0.26,0.26 -0.39,0.39 -0.433,0.39 -0.39,0.086 -0.649,0.13 -0.866,0.216 -0.13,0.13 -0.26,0.173 -0.346,0.216 -0.13,0 -0.347,-0.086 -0.693,-0.303 -0.346,-0.217 -0.606,-0.347 -0.823,-0.303 -0.39,0.13 -0.649,0.216 -0.822,0.26 l -0.13,-0.043 c 0,-0.13 0.216,-0.433 0.606,-0.822 0.433,-0.477 0.693,-0.78 0.736,-0.909 0.087,-0.13 0,-0.52 -0.13,-1.083 -0.043,-0.433 -0.086,-0.693 -0.173,-0.909 -0.043,-0.13 -0.13,-0.217 -0.303,-0.217 -0.217,-0.13 -0.433,-0.086 -0.649,0.13 -0.217,0.216 -0.39,0.39 -0.477,0.477 l -0.52,0.216 c -0.26,0.173 -0.433,0.303 -0.563,0.347 l -0.303,0.043 -0.13,-0.086 c -0.043,-0.217 0.043,-0.433 0.173,-0.606 0.259,-0.303 0.39,-0.433 0.39,-0.477 0,-0.563 0,-0.953 0.086,-1.212 0,-0.086 0.303,-0.303 0.866,-0.606 0.477,-0.303 0.823,-0.477 0.996,-0.52 l 0.13,0.043 c 0.173,0.303 0.26,0.433 0.346,0.477 0.173,-0.13 0.217,-0.477 0.217,-0.996 -0.043,-0.476 -0.13,-0.822 -0.303,-0.996 l -0.13,0.043 c -0.173,0.347 -0.347,0.65 -0.476,0.823 -0.043,0 -0.78,0.303 -2.252,0.866 -0.303,0.086 -0.519,0.303 -0.692,0.563 -0.26,0.476 -0.39,0.692 -0.433,0.736 -0.736,0.563 -1.125,0.909 -1.255,1.082 -0.087,0.217 -0.173,0.347 -0.217,0.477 -0.346,-0.043 -0.606,0 -0.779,0.043 -0.216,0.346 -0.433,0.52 -0.563,0.649 -0.39,0.086 -0.649,0.13 -0.866,0.173 -0.217,0.13 -0.39,0.217 -0.476,0.26 -0.173,0.043 -0.26,0.043 -0.347,0 l -0.043,-0.13 c 0,-0.087 0.043,-0.173 0.13,-0.303 0.086,-0.043 0.216,-0.13 0.433,-0.303 0.563,-0.303 0.823,-0.563 0.823,-0.779 0.043,-0.346 0.087,-0.606 0.216,-0.736 0.217,-0.259 0.52,-0.563 0.91,-0.909 0.13,-0.217 0.173,-0.563 0.173,-0.996 0.087,-0.13 0.39,-0.26 0.953,-0.346 0.476,-0.13 0.779,-0.39 0.953,-0.823 0,-0.26 0,-0.433 0.043,-0.52 0.173,-0.217 0.303,-0.39 0.347,-0.477 0.433,-0.736 0.476,-1.212 0.173,-1.429 -0.39,-0.13 -0.649,-0.303 -0.78,-0.476 -0.39,-0.087 -0.606,-0.13 -0.736,-0.173 -0.693,-0.346 -1.125,-0.476 -1.169,-0.39 v 0.13 c 0.086,0.087 0.173,0.173 0.26,0.346 0.693,0.866 0.866,1.473 0.52,1.775 h -0.173 c -0.26,-0.13 -0.52,-0.216 -0.649,-0.173 -0.216,0 -0.476,0.39 -0.779,1.256 -0.303,0.693 -0.563,0.909 -0.909,0.649 -0.476,-0.779 -0.649,-1.342 -0.52,-1.645 0.216,-0.173 0.39,-0.303 0.476,-0.477 -0.086,-0.173 -0.173,-0.303 -0.26,-0.346 -0.13,-0.043 -0.26,-0.043 -0.346,-0.043 -0.087,0 -0.26,0.086 -0.52,0.216 l -0.347,0.173 c -0.086,0.087 -0.173,0.303 -0.26,0.649 -0.086,0.346 -0.129,0.606 -0.129,0.779 0,0.26 0,0.736 0.043,1.472 -0.086,0.043 -0.173,0.043 -0.26,0.043 -0.173,-0.173 -0.216,-0.39 -0.173,-0.736 0.086,-0.433 0.086,-0.692 0.086,-0.736 h -0.13 c -0.043,0 -0.173,0.173 -0.433,0.606 h -0.13 -0.086 c 0.086,-0.563 0.086,-0.866 0.043,-0.909 -0.26,0.433 -0.52,0.649 -0.736,0.693 l -0.087,-0.13 c 0,-0.087 0.087,-0.216 0.217,-0.346 0.086,-0.173 0.216,-0.52 0.303,-1.04 l 0.086,-0.13 0.086,-0.129 0.087,-0.087 c 0.39,0.043 0.606,-0.13 0.736,-0.433 0.086,-0.216 0.173,-0.39 0.216,-0.476 0.087,-0.217 0.043,-0.39 -0.086,-0.52 -0.866,-0.39 -1.385,-0.736 -1.559,-0.996 v -0.173 c 0.13,-0.13 0.346,-0.217 0.693,-0.173 0,-0.043 -0.087,-0.216 -0.26,-0.606 -0.217,-0.433 -0.39,-0.736 -0.563,-0.866 -0.086,-0.043 -0.173,-0.043 -0.216,-0.043 -0.087,-0.043 -0.173,-0.087 -0.26,-0.13 -0.043,0 -0.043,0 -0.087,0.043 -0.086,0.087 -0.173,0.26 -0.216,0.52 -0.043,0.347 -0.086,0.563 -0.13,0.606 -0.087,0.216 -0.347,0.26 -0.693,0.086 -0.346,-0.13 -0.563,-0.303 -0.649,-0.476 -0.087,-0.13 -0.087,-0.433 0.043,-0.823 0.086,-0.347 0.13,-0.606 0.086,-0.779 -0.043,-0.043 -0.043,-0.086 -0.043,-0.086 l -0.13,-0.087 h -0.13 c -0.086,0.087 -0.26,0.477 -0.563,1.169 -0.173,0.433 -0.39,0.693 -0.649,0.823 l -0.346,-0.086 c -0.13,-0.173 -0.086,-0.39 0.13,-0.736 0.173,-0.26 0.173,-0.476 -0.086,-0.649 l -2.079,-0.303 c -0.39,-0.476 -0.736,-0.692 -1.082,-0.606 l -0.086,0.086 v 0.13 l 0.129,0.173 c 0.26,0.303 0.433,0.477 0.477,0.52 0.043,0.043 0.086,0.173 0.216,0.347 0,0 0.087,0.043 0.26,0.173 0.13,0 0.347,0.173 0.736,0.39 0.347,0.26 0.563,0.433 0.606,0.563 0.13,0.13 0.173,0.52 0.26,1.169 0.043,0.606 0.043,0.996 -0.043,1.169 -0.13,0.13 -0.347,0.26 -0.693,0.303 -0.433,0.13 -0.693,0.173 -0.736,0.216 l -0.303,-0.086 c -0.13,-0.13 -0.347,-0.39 -0.563,-0.823 l -0.736,0.52 c 0.043,0.087 0.043,0.26 0,0.477 -0.043,0.086 -0.13,0.26 -0.217,0.476 -0.043,0.173 -0.043,0.433 0,0.823 0,0.043 -0.043,0.13 -0.173,0.216 -0.173,0.087 -0.346,0 -0.52,-0.173 -0.13,-0.173 -0.346,-0.779 -0.649,-1.775 -0.303,-1.039 -0.433,-1.646 -0.39,-1.818 l -0.563,0.13 c -0.086,0.303 -0.086,0.693 -0.043,1.169 0.13,0.476 0.26,0.823 0.39,0.996 0.086,0.13 0.303,0.347 0.52,0.649 0.13,0.303 0.13,0.693 0.13,1.126 -0.043,0.52 -0.216,0.779 -0.52,0.779 -0.217,0 -0.346,-0.043 -0.39,-0.086 -0.173,-0.173 -0.217,-0.477 -0.173,-0.866 0.086,-0.52 0.086,-0.823 0,-0.953 -0.303,-0.303 -0.52,-0.52 -0.563,-0.606 -0.086,-0.173 -0.173,-0.52 -0.216,-1.083 -0.086,-0.606 -0.086,-0.996 -0.043,-1.125 0.13,-0.173 0.173,-0.303 0.26,-0.39 0.043,-0.13 0.13,-0.26 0.173,-0.477 0.216,-0.043 0.39,-0.043 0.476,-0.043 0.043,0.086 0.13,0.13 0.173,0.173 0.043,0.087 0,0.303 -0.173,0.736 l 0.563,-0.13 c 0.26,-0.303 0.433,-0.563 0.476,-0.779 0,-0.043 -0.043,-0.26 -0.043,-0.606 -0.043,-0.26 0,-0.433 0.086,-0.563 0.087,-0.043 0.216,0 0.477,0.043 0.043,0.173 0.173,0.347 0.303,0.606 0.043,0.303 0,0.606 -0.13,0.866 -0.173,0.217 -0.303,0.39 -0.346,0.52 -0.303,0.476 -0.216,0.909 0.173,1.255 0.216,0.173 0.52,0.303 0.953,0.433 l 0.736,-0.52 c -0.26,-0.52 -0.346,-0.822 -0.303,-0.953 h 0.173 c 0,0 0.13,0.043 0.39,0.217 0.173,0.086 0.346,0.086 0.476,0.043 0.347,-0.346 0.52,-0.692 0.52,-0.952 l -0.043,-0.13 c -0.087,-0.043 -0.909,-0.779 -2.425,-2.122 -0.476,-0.433 -0.736,-0.649 -0.736,-0.693 -0.822,-1.039 -1.342,-1.602 -1.515,-1.688 -0.26,-0.173 -0.693,-0.216 -1.299,-0.087 -0.606,0.087 -0.866,0.347 -0.693,0.736 0.086,0.216 0.347,0.346 0.823,0.39 0.476,0 0.779,0.086 0.823,0.216 0,0.173 -0.13,0.346 -0.39,0.477 -0.26,0.13 -0.39,0.303 -0.347,0.563 0.13,0.173 0.303,0.433 0.606,0.78 l -0.043,0.216 c -0.13,0.13 -0.216,0.216 -0.303,0.26 -0.346,0.26 -0.649,0.086 -0.953,-0.39 -0.259,-0.606 -0.433,-0.953 -0.519,-1.083 -0.087,-0.086 -0.217,-0.173 -0.39,-0.216 -0.13,0.086 -0.26,0.216 -0.303,0.39 -0.043,0.216 -0.087,0.346 -0.173,0.39 -0.13,0.086 -0.347,0.13 -0.563,0.13 l -0.216,0.173 h -0.13 l -0.043,-0.086 c 0.043,-0.303 0.087,-0.476 0.087,-0.52 l -0.173,-0.216 0.433,-0.39 c 0.173,-0.173 0.259,-0.433 0.173,-0.736 -0.043,-0.13 -0.303,-0.346 -0.736,-0.693 -0.433,-0.433 -0.649,-0.736 -0.606,-0.952 0.043,-0.13 0.13,-0.26 0.39,-0.477 0.087,-0.303 0.043,-0.822 -0.129,-1.602 -0.347,-0.13 -0.606,-0.259 -0.736,-0.303 -0.26,-0.216 -0.433,-0.347 -0.52,-0.39 l -0.086,0.086 c -0.043,0.216 -0.043,0.649 0,1.299 -0.043,0.606 -0.173,0.953 -0.39,1.126 -0.173,0 -0.26,0 -0.347,-0.043 -0.13,-0.26 -0.26,-0.477 -0.39,-0.563 -0.346,-0.13 -0.606,-0.26 -0.736,-0.303 -0.216,-0.13 -0.433,-0.39 -0.736,-0.736 -0.303,-0.39 -0.476,-0.649 -0.476,-0.866 -0.043,-0.13 0,-0.347 0.086,-0.693 -0.043,-0.173 -0.216,-0.347 -0.563,-0.563 -0.303,-0.216 -0.433,-0.433 -0.39,-0.649 l 0.043,-0.13 h 0.303 c -0.266,-0.345 -0.482,-0.562 -0.656,-0.648"
                    }
                }
            }
        }
    );
})(jQuery);
