/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexMatcher {
    private String text;
    private Pattern[] patterns;
    private boolean allMatched;

    public RegexMatcher(String text, String[] regexToMatch) {
        assert (text != null && regexToMatch != null);
        this.text = text;
        this.patterns = new Pattern[regexToMatch.length];
        for (int i = 0; i < regexToMatch.length; ++i) {
            this.patterns[i] = Pattern.compile(regexToMatch[i], 10);
        }
        this.allMatched = this.checkMatchingInSequentialOrder();
    }

    private boolean checkMatchingInSequentialOrder() {
        int index = 0;
        for (Pattern p : this.patterns) {
            Matcher m = p.matcher(this.text.substring(index));
            if (!m.find()) {
                return false;
            }
            index += m.end();
        }
        return true;
    }

    public boolean allMatchedInSequentialOrder() {
        return this.allMatched;
    }
}

