/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.ui.internal.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.AbstractProvider;
import org.openhab.core.common.registry.ManagedProvider;
import org.openhab.core.config.core.ConfigParser;
import org.openhab.core.storage.Storage;
import org.openhab.core.storage.StorageService;
import org.openhab.core.ui.components.RootUIComponent;
import org.openhab.core.ui.components.UIComponentProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component(factory="org.openhab.core.ui.component.provider.factory")
public class ManagedUIComponentProvider
extends AbstractProvider<RootUIComponent>
implements ManagedProvider<RootUIComponent, String>,
UIComponentProvider {
    private final String namespace;
    private final Storage<RootUIComponent> storage;

    @Activate
    public ManagedUIComponentProvider(@Reference StorageService storageService, Map<String, Object> config) {
        String namespace = (String)ConfigParser.valueAs((Object)config.get("ui.namespace"), String.class);
        if (namespace == null) {
            throw new IllegalStateException("'ui.namespace' must not be null in service configuration");
        }
        this.namespace = namespace;
        this.storage = storageService.getStorage("uicomponents_" + namespace.replace(':', '_'), this.getClass().getClassLoader());
    }

    public Collection<RootUIComponent> getAll() {
        ArrayList<RootUIComponent> components = new ArrayList<RootUIComponent>();
        for (RootUIComponent component : this.storage.getValues()) {
            if (component == null) continue;
            components.add(component);
        }
        return components;
    }

    public void add(RootUIComponent element) {
        if (element.getUID().isEmpty()) {
            throw new IllegalArgumentException("Invalid UID");
        }
        if (this.storage.get(element.getUID()) != null) {
            throw new IllegalArgumentException("Cannot add UI component to namespace " + this.namespace + ", because a component with same UID (" + element.getUID() + ") already exists.");
        }
        this.storage.put(element.getUID(), (Object)element);
        this.notifyListenersAboutAddedElement(element);
    }

    public @Nullable RootUIComponent remove(String key) {
        RootUIComponent element = (RootUIComponent)this.storage.remove(key);
        if (element != null) {
            this.notifyListenersAboutRemovedElement(element);
            return element;
        }
        return null;
    }

    public @Nullable RootUIComponent update(RootUIComponent element) {
        if (this.storage.get(element.getUID()) != null) {
            RootUIComponent oldElement = (RootUIComponent)this.storage.put(element.getUID(), (Object)element);
            if (oldElement != null) {
                this.notifyListenersAboutUpdatedElement(oldElement, element);
                return oldElement;
            }
        } else {
            throw new IllegalArgumentException("Cannot update UI component " + element.getUID() + " in namespace " + this.namespace + " because it doesn't exist.");
        }
        return null;
    }

    public @Nullable RootUIComponent get(String key) {
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Invalid UID");
        }
        return (RootUIComponent)this.storage.get(key);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }
}

