/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.activation.FileTypeMap;

public class MimetypesFileTypeMap
extends FileTypeMap {
    private static final String DEFAULT_TYPE = "application/octet-stream";
    private final Map types;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimetypesFileTypeMap() {
        FileInputStream is;
        File file2;
        block29: {
            this.types = new HashMap();
            try {
                InputStream is2 = MimetypesFileTypeMap.class.getResourceAsStream("/META-INF/mimetypes.default");
                if (is2 == null) break block29;
                try {
                    this.loadStream(is2);
                }
                finally {
                    is2.close();
                }
            }
            catch (IOException is2) {
                // empty catch block
            }
        }
        try {
            ClassLoader cl = MimetypesFileTypeMap.class.getClassLoader();
            if (cl != null) {
                Enumeration<URL> e = cl.getResources("/META-INF/mime.types");
                while (e.hasMoreElements()) {
                    URL url = e.nextElement();
                    try (InputStream is3 = url.openStream();){
                        this.loadStream(is3);
                    }
                    catch (IOException e1) {}
                }
            }
        }
        catch (SecurityException cl) {
        }
        catch (IOException cl) {
            // empty catch block
        }
        try {
            file2 = new File(System.getProperty("java.home"), "lib/mime.types");
            is = new FileInputStream(file2);
            try {
                this.loadStream(is);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (SecurityException file2) {
        }
        catch (FileNotFoundException file2) {
        }
        catch (IOException file2) {
            // empty catch block
        }
        try {
            file2 = new File(System.getProperty("user.home"), ".mime.types");
            is = new FileInputStream(file2);
            try {
                this.loadStream(is);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (SecurityException securityException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public MimetypesFileTypeMap(String mimeTypeFileName) throws IOException {
        this();
        BufferedReader reader = new BufferedReader(new FileReader(mimeTypeFileName));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.addMimeTypesOneLine(line);
            }
            reader.close();
        }
        catch (IOException e) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    public MimetypesFileTypeMap(InputStream is) {
        this();
        try {
            this.loadStream(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadStream(InputStream is) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            this.addMimeTypesOneLine(line);
        }
    }

    private synchronized void addMimeTypesOneLine(String mime_types) {
        StringTokenizer tok;
        int hashPos = mime_types.indexOf(35);
        if (hashPos != -1) {
            mime_types = mime_types.substring(0, hashPos);
        }
        if (!(tok = new StringTokenizer(mime_types)).hasMoreTokens()) {
            return;
        }
        String contentType = tok.nextToken();
        while (tok.hasMoreTokens()) {
            String fileType = tok.nextToken();
            this.types.put(fileType, contentType);
        }
    }

    public synchronized void addMimeTypes(String mime_types) {
        BufferedReader reader = new BufferedReader(new StringReader(mime_types));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.addMimeTypesOneLine(line);
            }
            reader.close();
        }
        catch (IOException e) {
            try {
                reader.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public String getContentType(File f) {
        return this.getContentType(f.getName());
    }

    @Override
    public synchronized String getContentType(String filename) {
        int index = filename.lastIndexOf(46);
        if (index == -1 || index == filename.length() - 1) {
            return DEFAULT_TYPE;
        }
        String fileType = filename.substring(index + 1);
        String contentType = (String)this.types.get(fileType);
        return contentType == null ? DEFAULT_TYPE : contentType;
    }
}

