/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import com.jetbrains.python.testing.PyAbstractTestFactory;
import com.jetbrains.python.testing.PythonUnitTestDetectorsKt;
import com.jetbrains.python.testing.TestRunnerService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonUnitTestDetectorsBasedOnSettings {
    private PythonUnitTestDetectorsBasedOnSettings() {
    }

    public static boolean isTestFile(@NotNull PyFile file, @NotNull ThreeState testCaseClassRequired, @Nullable TypeEvalContext context) {
        if (file == null) {
            PythonUnitTestDetectorsBasedOnSettings.$$$reportNull$$$0(0);
        }
        if (testCaseClassRequired == null) {
            PythonUnitTestDetectorsBasedOnSettings.$$$reportNull$$$0(1);
        }
        if (file.getTopLevelClasses().stream().anyMatch(o -> PythonUnitTestDetectorsBasedOnSettings.isTestClass(o, testCaseClassRequired, context))) {
            return true;
        }
        if (PythonUnitTestDetectorsBasedOnSettings.isTestCaseClassRequired((PsiElement)file, testCaseClassRequired)) {
            return false;
        }
        return file.getName().startsWith("test_") || file.getTopLevelFunctions().stream().anyMatch(o -> PythonUnitTestDetectorsBasedOnSettings.isTestFunction(o, testCaseClassRequired, context));
    }

    public static boolean isTestElement(@NotNull PsiElement element, @Nullable TypeEvalContext context) {
        PyFunction fun;
        if (element == null) {
            PythonUnitTestDetectorsBasedOnSettings.$$$reportNull$$$0(2);
        }
        if ((fun = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false)) != null && PythonUnitTestDetectorsBasedOnSettings.isTestFunction(fun, ThreeState.UNSURE, context)) {
            return true;
        }
        PyClass clazz = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false);
        if (clazz != null && PythonUnitTestDetectorsBasedOnSettings.isTestClass(clazz, ThreeState.UNSURE, context)) {
            return true;
        }
        return element instanceof PyFile && PythonUnitTestDetectorsBasedOnSettings.isTestFile((PyFile)element, ThreeState.UNSURE, context);
    }

    public static boolean isTestClass(@NotNull PyClass cls, @NotNull ThreeState testCaseClassRequired, @Nullable TypeEvalContext context) {
        if (cls == null) {
            PythonUnitTestDetectorsBasedOnSettings.$$$reportNull$$$0(3);
        }
        if (testCaseClassRequired == null) {
            PythonUnitTestDetectorsBasedOnSettings.$$$reportNull$$$0(4);
        }
        if (context == null) {
            context = TypeEvalContext.codeInsightFallback((Project)cls.getProject());
        }
        if (PythonUnitTestDetectorsBasedOnSettings.isTestCaseClassRequired((PsiElement)cls, testCaseClassRequired) && !PythonUnitTestDetectorsKt.isUnitTestCaseClass((PyClass)cls, (TypeEvalContext)context)) {
            return false;
        }
        return PythonUnitTestDetectorsKt.isTestClass((PyClass)cls, (TypeEvalContext)context);
    }

    public static boolean isTestFunction(@NotNull PyFunction function, @NotNull ThreeState testCaseClassRequired, @Nullable TypeEvalContext context) {
        if (function == null) {
            PythonUnitTestDetectorsBasedOnSettings.$$$reportNull$$$0(5);
        }
        if (testCaseClassRequired == null) {
            PythonUnitTestDetectorsBasedOnSettings.$$$reportNull$$$0(6);
        }
        if (!PythonUnitTestDetectorsKt.isTestFunction((PyFunction)function)) {
            return false;
        }
        PyClass aClass = function.getContainingClass();
        if (!PythonUnitTestDetectorsBasedOnSettings.isTestCaseClassRequired((PsiElement)function, testCaseClassRequired) && aClass == null) {
            return true;
        }
        return aClass != null && PythonUnitTestDetectorsBasedOnSettings.isTestClass(aClass, testCaseClassRequired, context);
    }

    public static boolean isTestCaseClassRequired(@NotNull PsiElement anchor) {
        Module module2;
        if (anchor == null) {
            PythonUnitTestDetectorsBasedOnSettings.$$$reportNull$$$0(7);
        }
        if ((module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)anchor)) == null) {
            return true;
        }
        Sdk sdk2 = PythonSdkUtil.findPythonSdk((Module)module2);
        if (sdk2 == null) {
            return true;
        }
        PyAbstractTestFactory<?> factory = TestRunnerService.getInstance(module2).getSelectedFactory();
        return factory.onlyClassesAreSupported(module2.getProject(), sdk2);
    }

    private static boolean isTestCaseClassRequired(@NotNull PsiElement anchor, @NotNull ThreeState userProvidedValue) {
        if (anchor == null) {
            PythonUnitTestDetectorsBasedOnSettings.$$$reportNull$$$0(8);
        }
        if (userProvidedValue == null) {
            PythonUnitTestDetectorsBasedOnSettings.$$$reportNull$$$0(9);
        }
        if (userProvidedValue != ThreeState.UNSURE) {
            return userProvidedValue.toBoolean();
        }
        return PythonUnitTestDetectorsBasedOnSettings.isTestCaseClassRequired(anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCaseClassRequired";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userProvidedValue";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/testing/PythonUnitTestDetectorsBasedOnSettings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestFunction";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestCaseClassRequired";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

