/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class GotopProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().number("(d+),").expression("([^,]+),").expression("([AV]),").text("DATE:").optional().number("(dd)(dd)(dd),").text("TIME:").optional().number("(dd)(dd)(dd),").text("LAT:").optional().number("(d+.d+)([NS]),").expression("LO[NT]:").optional().number("(d+.d+)([EW]),").text("Speed:").number("(d+.d+),").groupBegin().number("(d+)-").number("(d+),").groupBegin().number("(d+.d),").number("(d+.dd)").groupEnd("?").groupEnd("?").any().compile();

    public GotopProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        String type = parser.next();
        if (type.equals("CMD-KEY")) {
            position.addAlarm("sos");
        } else if (type.startsWith("ALM-B")) {
            if (Character.getNumericValue(type.charAt(5)) % 2 > 0) {
                position.addAlarm("geofenceEnter");
            } else {
                position.addAlarm("geofenceExit");
            }
        }
        position.setValid(parser.next().equals("A"));
        position.setTime(parser.nextDateTime());
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
        position.set("batteryLevel", parser.nextInt());
        position.set("rssi", parser.nextInt());
        position.setAltitude(parser.nextDouble(0.0));
        position.set("hdop", parser.nextDouble());
        return position;
    }
}

