/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.graalvm.svm;

import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.MonitoredData;
import org.graalvm.visualvm.tools.jvmstat.JvmJvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.JvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.MonitoredValue;

public class SVMMonitoredDataImpl
extends MonitoredData {
    private static final String ProcessCPUTime_COUNTER_NAME = "com.oracle.svm.processCPUTime";

    SVMMonitoredDataImpl(Jvm jvm, JvmstatModel monitoredVm, JvmJvmstatModel jvmstatModel) {
        this.monitoredVm = jvm;
        this.loadedClasses = jvmstatModel.getLoadedClasses();
        this.sharedLoadedClasses = jvmstatModel.getSharedLoadedClasses();
        this.sharedUnloadedClasses = jvmstatModel.getSharedUnloadedClasses();
        this.unloadedClasses = jvmstatModel.getUnloadedClasses();
        this.threadsDaemon = jvmstatModel.getThreadsDaemon();
        this.threadsLive = jvmstatModel.getThreadsLive();
        this.threadsLivePeak = jvmstatModel.getThreadsLivePeak();
        this.threadsStarted = jvmstatModel.getThreadsStarted();
        this.applicationTime = jvmstatModel.getApplicationTime() / (jvmstatModel.getOsFrequency() / 1000L);
        this.upTime = jvmstatModel.getUpTime() / (jvmstatModel.getOsFrequency() / 1000L);
        this.genCapacity = jvmstatModel.getGenCapacity();
        this.genUsed = jvmstatModel.getGenUsed();
        this.genMaxCapacity = jvmstatModel.getGenMaxCapacity();
        MonitoredValue cpuTimeVal = monitoredVm.findMonitoredValueByName(ProcessCPUTime_COUNTER_NAME);
        if (cpuTimeVal != null) {
            this.processCpuTime = (Long)cpuTimeVal.getValue();
        }
    }
}

