/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.v2.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.text.Caret;
import org.graalvm.visualvm.lib.profiler.v2.ProfilerFeature;
import org.graalvm.visualvm.lib.profiler.v2.impl.Bundle;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.HTMLTextArea;
import org.graalvm.visualvm.lib.ui.components.NoCaret;

public abstract class WelcomePanel
extends JPanel {
    public static final String CAPTION = Bundle.WelcomePanel_howtoCaption();

    public WelcomePanel(String configureButton, String profileButton, Set<ProfilerFeature> features) {
        Color background = UIUtils.getProfilerResultsBackground();
        JPanel pp = new JPanel(new GridBagLayout());
        pp.setOpaque(true);
        pp.setBackground(background);
        int y = 0;
        Paragraph header = new Paragraph(null, CAPTION, 3, background);
        header.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, header.getForeground()));
        if (UIUtils.isNimbus()) {
            header.setOpaque(false);
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = y++;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(4, 20, 4, 20);
        pp.add((Component)((Object)header), c);
        int counter = 0;
        Paragraph hint1 = new Paragraph(Bundle.WelcomePanel_clickForSetings("<b><a href='#'>" + configureButton + "</a></b>"), Integer.toString(++counter), 1, background){

            protected void showURL(URL url) {
                WelcomePanel.this.highlightItem(null);
            }
        };
        c = new GridBagConstraints();
        c.gridy = y++;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(4, 28, 0, 20);
        pp.add((Component)((Object)hint1), c);
        for (ProfilerFeature feature : features) {
            JLabel l1 = new JLabel(feature.getName(), feature.getIcon(), 10);
            l1.setFont(new JToolTip().getFont());
            l1.setIconTextGap(l1.getIconTextGap() + 2);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y;
            c.gridwidth = 1;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(3, 60, 3, 10);
            pp.add((Component)l1, c);
            JLabel l2 = new JLabel(feature.getDescription());
            l2.setFont(l1.getFont());
            l2.setEnabled(false);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = y++;
            c.gridwidth = 1;
            c.anchor = 17;
            c.fill = 2;
            c.insets = new Insets(3, 0, 3, 20);
            pp.add((Component)l2, c);
        }
        Paragraph hint2 = new Paragraph(Bundle.WelcomePanel_startProfiling("<b>" + profileButton + "</b>"), Integer.toString(++counter), 1, background);
        c = new GridBagConstraints();
        c.gridy = y++;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(6, 28, 0, 20);
        pp.add((Component)((Object)hint2), c);
        Paragraph hint3 = new Paragraph(Bundle.WelcomePanel_modifyProfiling(profileButton), Integer.toString(++counter), 1, background);
        c = new GridBagConstraints();
        c.gridy = y++;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(0, 28, 0, 20);
        pp.add((Component)((Object)hint3), c);
        int w = pp.getMinimumSize().width;
        header.setSize(w, Integer.MAX_VALUE);
        header.setPreferredSize(new Dimension(w, header.getPreferredSize().height));
        hint1.setSize(w, Integer.MAX_VALUE);
        hint1.setPreferredSize(new Dimension(w, hint1.getPreferredSize().height));
        hint2.setSize(w, Integer.MAX_VALUE);
        hint2.setPreferredSize(new Dimension(w, hint2.getPreferredSize().height));
        hint3.setSize(w, Integer.MAX_VALUE);
        hint3.setPreferredSize(new Dimension(w, hint2.getPreferredSize().height));
        this.setLayout(new GridBagLayout());
        this.setOpaque(true);
        this.setBackground(UIUtils.getProfilerResultsBackground());
        GridBagConstraints x = new GridBagConstraints();
        x.gridx = 0;
        x.gridy = 0;
        x.weightx = 1.0;
        x.weighty = 1.0;
        x.fill = 0;
        this.add((Component)pp, x);
    }

    public abstract void highlightItem(String var1);

    private static class Paragraph
    extends HTMLTextArea {
        Paragraph(String text, String caption, int captionSizeDiff, Color background) {
            this.setCaret((Caret)new NoCaret());
            this.setShowPopup(false);
            this.setBackground(background);
            if (UIUtils.isNimbus()) {
                this.setOpaque(false);
            }
            this.setFocusable(false);
            this.setFont(new JToolTip().getFont());
            this.setText(this.setupText(text, caption, captionSizeDiff));
        }

        private String setupText(String text, String caption, int captionSizeDiff) {
            int fsize = this.getFont().getSize() + captionSizeDiff;
            return caption == null ? text : "<span style='font-size:" + fsize + "px;'>" + caption + "</span>" + (text == null ? "" : ". " + text);
        }
    }
}

