/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core.rule.describe;

import com.google.common.base.Objects;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.UncheckedIOException;
import org.gradle.model.internal.core.rule.describe.AbstractModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;

@ThreadSafe
class NestedModelRuleDescriptor
extends AbstractModelRuleDescriptor {
    private final ModelRuleDescriptor parent;
    private final ModelRuleDescriptor child;

    public NestedModelRuleDescriptor(ModelRuleDescriptor parent, ModelRuleDescriptor child) {
        this.parent = parent;
        this.child = child;
    }

    @Override
    public void describeTo(Appendable appendable) {
        this.parent.describeTo(appendable);
        try {
            appendable.append(" > ");
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        this.child.describeTo(appendable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedModelRuleDescriptor that = (NestedModelRuleDescriptor)o;
        return Objects.equal((Object)this.parent, (Object)that.parent) && Objects.equal((Object)this.child, (Object)that.child);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.parent, this.child});
    }
}

