/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrOffset2Df
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    public XrOffset2Df(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrOffset2Df.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return XrOffset2Df.nx(this.address());
    }

    public float y() {
        return XrOffset2Df.ny(this.address());
    }

    public XrOffset2Df x(float value) {
        XrOffset2Df.nx(this.address(), value);
        return this;
    }

    public XrOffset2Df y(float value) {
        XrOffset2Df.ny(this.address(), value);
        return this;
    }

    public XrOffset2Df set(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public XrOffset2Df set(XrOffset2Df src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrOffset2Df malloc() {
        return (XrOffset2Df)XrOffset2Df.wrap(XrOffset2Df.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrOffset2Df calloc() {
        return (XrOffset2Df)XrOffset2Df.wrap(XrOffset2Df.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrOffset2Df create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrOffset2Df)XrOffset2Df.wrap(XrOffset2Df.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrOffset2Df create(long address) {
        return (XrOffset2Df)XrOffset2Df.wrap(XrOffset2Df.class, (long)address);
    }

    @Nullable
    public static XrOffset2Df createSafe(long address) {
        return address == 0L ? null : (XrOffset2Df)XrOffset2Df.wrap(XrOffset2Df.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrOffset2Df.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrOffset2Df.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrOffset2Df.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrOffset2Df.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrOffset2Df.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrOffset2Df.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrOffset2Df.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrOffset2Df malloc(MemoryStack stack) {
        return (XrOffset2Df)XrOffset2Df.wrap(XrOffset2Df.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrOffset2Df calloc(MemoryStack stack) {
        return (XrOffset2Df)XrOffset2Df.wrap(XrOffset2Df.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrOffset2Df.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrOffset2Df.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    public static void nx(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = XrOffset2Df.__struct((Struct.Member[])new Struct.Member[]{XrOffset2Df.__member((int)4), XrOffset2Df.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrOffset2Df, Buffer>
    implements NativeResource {
        private static final XrOffset2Df ELEMENT_FACTORY = XrOffset2Df.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrOffset2Df getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return XrOffset2Df.nx(this.address());
        }

        public float y() {
            return XrOffset2Df.ny(this.address());
        }

        public Buffer x(float value) {
            XrOffset2Df.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            XrOffset2Df.ny(this.address(), value);
            return this;
        }
    }
}

