/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.providersupport.shared;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.AbstractProvider;
import org.openhab.core.items.ManagedMetadataProvider;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.MetadataKey;
import org.openhab.core.items.MetadataPredicates;
import org.openhab.core.items.MetadataProvider;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={ScriptedMetadataProvider.class, MetadataProvider.class})
public class ScriptedMetadataProvider
extends AbstractProvider<Metadata>
implements ManagedMetadataProvider {
    private final Logger logger = LoggerFactory.getLogger(ScriptedMetadataProvider.class);
    private final Map<MetadataKey, Metadata> metadataStorage = new HashMap<MetadataKey, Metadata>();

    public void removeItemMetadata(String name) {
        this.getAll().stream().filter(MetadataPredicates.ofItem((String)name)).map(Metadata::getUID).forEach(this::remove);
    }

    public Collection<Metadata> getAll() {
        return this.metadataStorage.values();
    }

    public @Nullable Metadata get(MetadataKey metadataKey) {
        return this.metadataStorage.get(metadataKey);
    }

    public void add(Metadata metadata) {
        if (this.metadataStorage.containsKey(metadata.getUID())) {
            throw new IllegalArgumentException("Cannot add metadata, because metadata with the same UID (" + String.valueOf(metadata.getUID()) + ") already exists");
        }
        this.metadataStorage.put(metadata.getUID(), metadata);
        this.notifyListenersAboutAddedElement(metadata);
    }

    public @Nullable Metadata update(Metadata metadata) {
        Metadata oldMetadata = this.metadataStorage.get(metadata.getUID());
        if (oldMetadata != null) {
            this.metadataStorage.put(metadata.getUID(), metadata);
            this.notifyListenersAboutUpdatedElement(oldMetadata, metadata);
        } else {
            this.logger.warn("Could not update metadata with UID '{}', because it does not exist", (Object)metadata.getUID());
        }
        return oldMetadata;
    }

    public @Nullable Metadata remove(MetadataKey metadataKey) {
        Metadata metadata = this.metadataStorage.remove(metadataKey);
        if (metadata != null) {
            this.notifyListenersAboutRemovedElement(metadata);
        }
        return metadata;
    }
}

