/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec3(-1333333333333333259l, 85l, 94l) * i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(-1034804020101886343l, 7225l, 8836l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) * i64vec3(167l, 66l, 187l)) => i64vec3(-1305737782152034861l, 5610l, 17578l)
 * (i64vec3(167l, 66l, 187l) * i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(-1305737782152034861l, 5610l, 17578l)
 * (i64vec3(167l, 66l, 187l) * i64vec3(167l, 66l, 187l)) => i64vec3(27889l, 4356l, 34969l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) * i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(-1034804020101886343l, 7225l, 8836l))) ? 1 : -1] array0;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) * i64vec3(167l, 66l, 187l)), i64vec3(-1305737782152034861l, 5610l, 17578l))) ? 1 : -1] array1;
  float[all(equal((i64vec3(167l, 66l, 187l) * i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(-1305737782152034861l, 5610l, 17578l))) ? 1 : -1] array2;
  float[all(equal((i64vec3(167l, 66l, 187l) * i64vec3(167l, 66l, 187l)), i64vec3(27889l, 4356l, 34969l))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
