/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.codeInsight.codeVision.CodeVisionHost;
import com.intellij.codeInsight.codeVision.CodeVisionInitializer;
import com.intellij.codeInsight.codeVision.settings.CodeVisionSettings;
import com.intellij.codeInsight.hints.codeVision.CodeVisionFusCollector;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.AnnotationsPreloader;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcs.CacheableAnnotationProvider;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00102\u00020\u0001:\u0002\u000f\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/annotate/AnnotationsPreloader;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "schedulePreloading", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "refreshSelectedFiles", "AnnotationsPreloaderFileEditorManagerListener", "Companion", "intellij.platform.vcs.impl.lang"})
@SourceDebugExtension(value={"SMAP\nAnnotationsPreloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationsPreloader.kt\ncom/intellij/openapi/vcs/annotate/AnnotationsPreloader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,137:1\n13#2:138\n*S KotlinDebug\n*F\n+ 1 AnnotationsPreloader.kt\ncom/intellij/openapi/vcs/annotate/AnnotationsPreloader\n*L\n112#1:138\n*E\n"})
public final class AnnotationsPreloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final MergingUpdateQueue updateQueue;
    @NotNull
    private static final Logger LOG;

    public AnnotationsPreloader(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.updateQueue = MergingUpdateQueue.Companion.mergingUpdateQueue("Annotations preloader queue", 1000, this.coroutineScope);
        this.project.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> AnnotationsPreloader._init_$lambda$0(this));
    }

    public final void schedulePreloading(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.project.isDisposed()) {
            return;
        }
        Project project = this.project;
        this.updateQueue.queue((Update)new DisposableUpdate(file, this, project){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ AnnotationsPreloader this$0;
            {
                this.$file = $file;
                this.this$0 = $receiver;
                super((Disposable)$super_call_param$1, (Object)$file);
            }

            /*
             * WARNING - void declaration
             */
            protected void doRun() {
                try {
                    void $this$debug_u24default$iv;
                    AnnotationsPreloader annotationsPreloader = this.this$0;
                    VirtualFile virtualFile = this.$file;
                    boolean $i$f$measureTimeMillis = false;
                    long start$iv = System.currentTimeMillis();
                    boolean bl = false;
                    if (!FileEditorManager.getInstance((Project)AnnotationsPreloader.access$getProject$p(annotationsPreloader)).isFileOpen(virtualFile)) {
                        return;
                    }
                    if (virtualFile.getFileType().isBinary()) {
                        return;
                    }
                    CacheableAnnotationProvider cacheableAnnotationProvider = com.intellij.openapi.vcs.annotate.AnnotationsPreloader$Companion.access$getAnnotationProvider(AnnotationsPreloader.Companion, AnnotationsPreloader.access$getProject$p(annotationsPreloader), virtualFile);
                    if (cacheableAnnotationProvider == null) {
                        return;
                    }
                    CacheableAnnotationProvider annotationProvider = cacheableAnnotationProvider;
                    annotationProvider.populateCache(virtualFile);
                    long durationMs = System.currentTimeMillis() - start$iv;
                    BuildersKt.launch$default((CoroutineScope)AnnotationsPreloader.access$getCoroutineScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$file, this.this$0, durationMs, null){
                        int label;
                        final /* synthetic */ VirtualFile $file;
                        final /* synthetic */ AnnotationsPreloader this$0;
                        final /* synthetic */ long $durationMs;
                        {
                            this.$file = $file;
                            this.this$0 = $receiver;
                            this.$durationMs = $durationMs;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = CoroutinesKt.readAction(() -> schedulePreloading.doRun.1.invokeSuspend$lambda$0(this.$file, this.this$0, this.$durationMs), (Continuation)((Continuation)this));
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }

                        private static final Unit invokeSuspend$lambda$0(VirtualFile $file, AnnotationsPreloader this$0, long $durationMs) {
                            PsiFile psiFile;
                            PsiFile psiFile2 = psiFile = $file.isValid() ? PsiManager.getInstance((Project)AnnotationsPreloader.access$getProject$p(this$0)).findFile($file) : null;
                            if (psiFile != null) {
                                CodeVisionFusCollector.INSTANCE.reportVcsAnnotationDuration(psiFile, $durationMs);
                            }
                            return Unit.INSTANCE;
                        }
                    }), (int)3, null);
                    annotationsPreloader = AnnotationsPreloader.access$getLOG$cp();
                    VirtualFile virtualFile2 = this.$file;
                    Throwable e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        void var10_11 = $this$debug_u24default$iv;
                        boolean bl2 = false;
                        var10_11.debug("Preloaded VCS annotations for " + virtualFile2.getName() + " in " + durationMs + " ms", e$iv);
                    }
                    ActionsKt.runInEdt$default(null, () -> schedulePreloading.1.doRun$lambda$2(this.this$0), (int)1, null);
                }
                catch (VcsException e) {
                    AnnotationsPreloader.access$getLOG$cp().info((Throwable)e);
                }
            }

            private static final Unit doRun$lambda$2(AnnotationsPreloader this$0) {
                if (AnnotationsPreloader.access$getProject$p(this$0).isDisposed()) {
                    return Unit.INSTANCE;
                }
                CodeVisionInitializer.Companion.getInstance(AnnotationsPreloader.access$getProject$p(this$0)).getCodeVisionHost().invalidateProvider(new CodeVisionHost.LensInvalidateSignal(null, (Collection)CollectionsKt.listOf((Object)"vcs.code.vision")));
                return Unit.INSTANCE;
            }
        });
    }

    private final void refreshSelectedFiles() {
        if (!Companion.isEnabled$intellij_platform_vcs_impl_lang()) {
            return;
        }
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)this.project).getSelectedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
        for (VirtualFile file : virtualFileArray) {
            Intrinsics.checkNotNull((Object)file);
            this.schedulePreloading(file);
        }
    }

    private static final void _init_$lambda$0(AnnotationsPreloader this$0) {
        this$0.refreshSelectedFiles();
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(AnnotationsPreloader $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ Project access$getProject$p(AnnotationsPreloader $this) {
        return $this.project;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AnnotationsPreloader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/annotate/AnnotationsPreloader$AnnotationsPreloaderFileEditorManagerListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "selectionChanged", "", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.platform.vcs.impl.lang"})
    @SourceDebugExtension(value={"SMAP\nAnnotationsPreloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationsPreloader.kt\ncom/intellij/openapi/vcs/annotate/AnnotationsPreloader$AnnotationsPreloaderFileEditorManagerListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,137:1\n30#2,2:138\n*S KotlinDebug\n*F\n+ 1 AnnotationsPreloader.kt\ncom/intellij/openapi/vcs/annotate/AnnotationsPreloader$AnnotationsPreloaderFileEditorManagerListener\n*L\n107#1:138,2\n*E\n"})
    public static final class AnnotationsPreloaderFileEditorManagerListener
    implements FileEditorManagerListener {
        @NotNull
        private final Project project;

        public AnnotationsPreloaderFileEditorManagerListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
                Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create(...)");
                throw (Throwable)extensionNotApplicableException;
            }
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!Companion.isEnabled$intellij_platform_vcs_impl_lang()) {
                return;
            }
            VirtualFile virtualFile = event.getNewFile();
            if (virtualFile == null) {
                return;
            }
            VirtualFile file = virtualFile;
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<AnnotationsPreloader> serviceClass$iv = AnnotationsPreloader.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((AnnotationsPreloader)object).schedulePreloading(file);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/annotate/AnnotationsPreloader$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "isEnabled", "", "isEnabled$intellij_platform_vcs_impl_lang", "getAnnotationProvider", "Lcom/intellij/vcs/CacheableAnnotationProvider;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.vcs.impl.lang"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isEnabled$intellij_platform_vcs_impl_lang() {
            if (PowerSaveMode.isEnabled()) {
                return false;
            }
            boolean enabledInSettings = Registry.Companion.is("editor.codeVision.new") ? CodeVisionSettings.Companion.getInstance().isProviderEnabled("vcs.code.vision") : false;
            return enabledInSettings || AdvancedSettings.Companion.getBoolean("vcs.annotations.preload");
        }

        private final CacheableAnnotationProvider getAnnotationProvider(Project project, VirtualFile file) {
            FileStatus fileStatus = ChangeListManager.getInstance((Project)project).getStatus(file);
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getStatus(...)");
            FileStatus status = fileStatus;
            if (Intrinsics.areEqual((Object)status, (Object)FileStatus.UNKNOWN) || Intrinsics.areEqual((Object)status, (Object)FileStatus.ADDED) || Intrinsics.areEqual((Object)status, (Object)FileStatus.IGNORED)) {
                return null;
            }
            AbstractVcs abstractVcs = ProjectLevelVcsManager.Companion.getInstance(project).getVcsFor(file);
            if (abstractVcs == null) {
                return null;
            }
            AbstractVcs vcs = abstractVcs;
            AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
            return annotationProvider instanceof CacheableAnnotationProvider ? (CacheableAnnotationProvider)annotationProvider : null;
        }

        public static final /* synthetic */ CacheableAnnotationProvider access$getAnnotationProvider(Companion $this, Project project, VirtualFile file) {
            return $this.getAnnotationProvider(project, file);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

