/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDefaultFontProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintAnchor;
import net.sf.jasperreports.engine.JRPrintAnchorIndex;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRReportFont;

public class JasperPrint
implements Serializable {
    private static final long serialVersionUID = 10001L;
    private String name = null;
    private int pageWidth = 0;
    private int pageHeight = 0;
    private byte orientation = 1;
    private Map fontsMap = new HashMap();
    private List fontsList = new ArrayList();
    private List pages = new ArrayList();
    private transient Map anchorIndexes = null;
    private DefaultFontProvider defaultFontProvider = new DefaultFontProvider(null);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(int pageWidth) {
        this.pageWidth = pageWidth;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(int pageHeight) {
        this.pageHeight = pageHeight;
    }

    public byte getOrientation() {
        return this.orientation;
    }

    public void setOrientation(byte orientation) {
        this.orientation = orientation;
    }

    public JRReportFont getDefaultFont() {
        return this.defaultFontProvider.getDefaultFont();
    }

    public void setDefaultFont(JRReportFont font) {
        this.defaultFontProvider.setDefaultFont(font);
    }

    public JRDefaultFontProvider getDefaultFontProvider() {
        return this.defaultFontProvider;
    }

    public JRReportFont[] getFonts() {
        JRReportFont[] fontsArray = new JRReportFont[this.fontsList.size()];
        this.fontsList.toArray(fontsArray);
        return fontsArray;
    }

    public List getFontsList() {
        return this.fontsList;
    }

    public Map getFontsMap() {
        return this.fontsMap;
    }

    public void addFont(JRReportFont reportFont) throws JRException {
        if (this.fontsMap.containsKey(reportFont.getName())) {
            throw new JRException("Duplicate declaration of report font : " + reportFont.getName());
        }
        this.fontsList.add(reportFont);
        this.fontsMap.put(reportFont.getName(), reportFont);
        if (reportFont.isDefault()) {
            this.setDefaultFont(reportFont);
        }
    }

    public JRReportFont removeFont(String fontName) {
        return this.removeFont((JRReportFont)this.fontsMap.get(fontName));
    }

    public JRReportFont removeFont(JRReportFont reportFont) {
        if (reportFont != null) {
            if (reportFont.isDefault()) {
                this.setDefaultFont(null);
            }
            this.fontsList.remove(reportFont);
            this.fontsMap.remove(reportFont.getName());
        }
        return reportFont;
    }

    public List getPages() {
        return this.pages;
    }

    public void addPage(JRPrintPage page) {
        this.anchorIndexes = null;
        this.pages.add(page);
    }

    public void addPage(int index, JRPrintPage page) {
        this.anchorIndexes = null;
        this.pages.add(index, page);
    }

    public JRPrintPage removePage(int index) {
        this.anchorIndexes = null;
        return (JRPrintPage)this.pages.remove(index);
    }

    public Map getAnchorIndexes() {
        if (this.anchorIndexes == null) {
            this.anchorIndexes = new HashMap();
            JRPrintPage page = null;
            int i = 0;
            Iterator itp = this.pages.iterator();
            while (itp.hasNext()) {
                page = (JRPrintPage)itp.next();
                List elements = page.getElements();
                if (elements != null && elements.size() > 0) {
                    JRPrintElement element = null;
                    Iterator it = elements.iterator();
                    while (it.hasNext()) {
                        element = (JRPrintElement)it.next();
                        if (!(element instanceof JRPrintAnchor)) continue;
                        this.anchorIndexes.put(((JRPrintAnchor)((Object)element)).getAnchorName(), new JRPrintAnchorIndex(i, element));
                    }
                }
                ++i;
            }
        }
        return this.anchorIndexes;
    }

    private static class DefaultFontProvider
    implements JRDefaultFontProvider,
    Serializable {
        private static final long serialVersionUID = 10001L;
        private JRReportFont defaultFont;

        DefaultFontProvider(JRReportFont font) {
            this.defaultFont = font;
        }

        public JRReportFont getDefaultFont() {
            return this.defaultFont;
        }

        void setDefaultFont(JRReportFont font) {
            this.defaultFont = font;
        }
    }
}

