# This file was automatically generated by bifcl from /local/pobj/zeek-8.0.4/zeek-8.0.4/src/broker/comm.bif (alternative mode).

export {

##! Functions and events regarding broker communication mechanisms.



module Broker;


## Generated when Broker emits an internal logging event.
##
## lvl: the severity of the event as reported by Broker.
##
## id: an identifier for the event type.
##
## description: a message providing additional context.
global Broker::internal_log_event: event(lvl: LogSeverityLevel , id: string , description: string );


## Generated when a new peering has been established. Both sides of the peering
## receive this event, created independently in each endpoint. For the endpoint
## establishing the peering, the added endpoint's network information will match
## the address and port provided to :zeek:see:`Broker::peer`; for the listening
## endpoint it's the peer's TCP client's address and (likely ephemeral) TCP
## port.
##
## endpoint: the added endpoint's Broker ID and connection information.
##
## msg: a message providing additional context.
##
## .. zeek:see:: Broker::peer_removed Broker::peer_lost
##    Broker::endpoint_discovered Broker::endpoint_unreachable
##    Broker::status Broker::error
global Broker::peer_added: event(endpoint: EndpointInfo , msg: string );


## Generated when the local endpoint has removed its peering with another
## endpoint. This event can fire for multiple reasons, such as a local call to
## :zeek:see:`Broker::unpeer`, or because Broker autonomously decides to
## unpeer. One reason it might do this is message I/O backpressure overflow,
## meaning that the remote peer cannot keep up with the stream of messages the
## local endpoint sends it. Regardless of the cause, the remote endpoint will
## locally trigger a corresponding :zeek:see:`Broker::peer_lost` event once the
## peering ends. These events are independent of the original directionality of
## TCP connection establishment and only reflect which endpoint terminates the
## peering.
##
## endpoint: the removed endpoint's Broker ID and connection information.
##
## msg: a message providing additional context. If backpressure overflow
##      caused this unpeering, the message contains the string
##      *caf::sec::backpressure_overflow*.
##
## .. zeek:see:: Broker::peer_added Broker::peer_lost
##    Broker::endpoint_discovered Broker::endpoint_unreachable
##    Broker::status Broker::error
global Broker::peer_removed: event(endpoint: EndpointInfo , msg: string );


## Generated when the local endpoint has lost its peering with another
## endpoint. This event fires when the other endpoint stops or removes the
## peering for some other reason. This event is independent of the original
## directionality of connection establishment.
##
## endpoint: the lost endpoint's Broker ID and connection information.
##
## msg: a message providing additional context.
##
## .. zeek:see:: Broker::peer_added Broker::peer_removed
##    Broker::endpoint_discovered Broker::endpoint_unreachable
##    Broker::status Broker::error
global Broker::peer_lost: event(endpoint: EndpointInfo , msg: string );


## Generated when a new Broker endpoint appeared.
global Broker::endpoint_discovered: event(endpoint: EndpointInfo , msg: string );


## Generated when the last path to a Broker endpoint has been lost.
global Broker::endpoint_unreachable: event(endpoint: EndpointInfo , msg: string );


## Generated when an unspecified change occurs in Broker. This event only fires
## when the status change isn't covered by more specific Broker events. The
## provided message string may be empty.
##
## endpoint: the Broker ID and connection information, if available,
##           of the endpoint the update relates to.
##
## msg: a message providing additional context.
##
## .. zeek:see:: Broker::peer_added Broker::peer_removed Broker::peer_lost
##    Broker::endpoint_discovered Broker::endpoint_unreachable Broker::error
global Broker::status: event(endpoint: EndpointInfo , msg: string );


## Generated when an error occurs in the Broker sub-system. This event
## reports local errors in Broker, as indicated by the provided
## :zeek:type:`Broker::ErrorCode`.
##
## code: the type of error that triggered this event.
##
## msg: a message providing additional context.
##
## .. zeek:see:: Broker::peer_added Broker::peer_removed Broker::peer_lost
##    Broker::endpoint_discovered Broker::endpoint_unreachable Broker::status
global Broker::error: event(code: ErrorCode , msg: string );


## Enumerates the possible error types.
type ErrorCode: enum  {
	NO_ERROR = 0,
	UNSPECIFIED = 1,
	PEER_INCOMPATIBLE = 2,
	PEER_INVALID = 3,
	PEER_UNAVAILABLE = 4,
	PEER_DISCONNECT_DURING_HANDSHAKE = 5,
	PEER_TIMEOUT = 6,
	MASTER_EXISTS = 7,
	NO_SUCH_MASTER = 8,
	NO_SUCH_KEY = 9,
	REQUEST_TIMEOUT = 10,
	TYPE_CLASH = 11,
	INVALID_DATA = 12,
	BACKEND_FAILURE = 13,
	STALE_DATA = 14,
	CANNOT_OPEN_FILE = 15,
	CANNOT_WRITE_FILE = 16,
	INVALID_TOPIC_KEY = 17,
	END_OF_FILE = 18,
	INVALID_TAG = 19,
	INVALID_STATUS = 20,
	CAF_ERROR = 100,
} ;


type PeerStatus: enum  {
	INITIALIZING,
	CONNECTING,
	CONNECTED,
	PEERED,
	DISCONNECTED,
	RECONNECTING,
} ;


type BrokerProtocol: enum  {
	NATIVE,
	WEBSOCKET,
} ;


global Broker::__listen: function(a: string , p: port , proto: BrokerProtocol ): port ;


global Broker::__peer: function(a: string , p: port , retry: interval ): bool ;


global Broker::__peer_no_retry: function(a: string , p: port ): bool ;


global Broker::__unpeer: function(a: string , p: port ): bool ;


global Broker::__is_outbound_peering: function(a: string , p: port ): bool ;


global Broker::__peers: function(): PeerInfos ;


global Broker::__node_id: function(): string ;


global Broker::__peering_stats: function(): BrokerPeeringStatsTable ;

} # end of export section
module GLOBAL;
