/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.d2j.Method;
import com.googlecode.d2j.dex.BaseDexExceptionHandler;
import com.googlecode.d2j.dex.Dex2jar;
import com.googlecode.d2j.node.DexMethodNode;
import com.googlecode.d2j.reader.DexFileReader;
import com.googlecode.d2j.smali.BaksmaliDumper;
import com.googlecode.d2j.smali.Smali;
import com.googlecode.dex2jar.ir.ET;
import com.googlecode.dex2jar.tools.BaseCmd;
import com.googlecode.dex2jar.tools.Dex2jarCmd;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.MethodVisitor;

public class BaksmaliBaseDexExceptionHandler
extends BaseDexExceptionHandler {
    public static final String REPORT_MESSAGE = "Please report this file to https://github.com/pxb1988/dex2jar/issues if possible.";
    private Map<DexMethodNode, Exception> exceptionMap = new HashMap<DexMethodNode, Exception>();
    private List<Exception> fileExceptions = new ArrayList<Exception>();

    public boolean hasException() {
        return this.exceptionMap.size() > 0 || this.fileExceptions.size() > 0;
    }

    public void handleFileException(Exception e) {
        super.handleFileException(e);
        this.fileExceptions.add(e);
    }

    public void handleMethodTranslateException(Method method, DexMethodNode methodNode, MethodVisitor mv, Exception e) {
        super.handleMethodTranslateException(method, methodNode, mv, e);
        this.exceptionMap.put(methodNode, e);
    }

    public static String getVersionString() {
        ArrayList<String> vs = new ArrayList<String>();
        BaksmaliBaseDexExceptionHandler.doAddVersion(vs, "dex-reader", DexFileReader.class);
        BaksmaliBaseDexExceptionHandler.doAddVersion(vs, "dex-reader-api", Method.class);
        BaksmaliBaseDexExceptionHandler.doAddVersion(vs, "dex-ir", ET.class);
        BaksmaliBaseDexExceptionHandler.doAddVersion(vs, "d2j-smali", Smali.class);
        BaksmaliBaseDexExceptionHandler.doAddVersion(vs, "d2j-base-cmd", BaseCmd.class);
        BaksmaliBaseDexExceptionHandler.doAddVersion(vs, "dex-tools", Dex2jarCmd.class);
        BaksmaliBaseDexExceptionHandler.doAddVersion(vs, "dex-translator", Dex2jar.class);
        return ((Object)vs).toString();
    }

    private static void doAddVersion(List<String> vs, String pkg, Class<?> clz) {
        try {
            vs.add(pkg + "-" + clz.getPackage().getImplementationVersion());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dump(Path exFile, String[] originalArgs) {
        String fileName = exFile.getFileName().toString().toLowerCase();
        try {
            if (fileName.endsWith(".zip")) {
                this.dumpZip(exFile, originalArgs);
            } else if (fileName.endsWith(".gz")) {
                this.dumGZip(exFile, originalArgs);
            } else {
                this.dumpTxt(exFile, originalArgs);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void dumpTxt(Path exFile, String[] originalArgs) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(exFile, new OpenOption[0]), StandardCharsets.UTF_8));){
            this.dumpTxt0(writer, originalArgs);
        }
    }

    private void dumGZip(Path exFile, String[] originalArgs) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(Files.newOutputStream(exFile, new OpenOption[0])), StandardCharsets.UTF_8));){
            this.dumpTxt0(writer, originalArgs);
        }
    }

    private void dumpTxt0(BufferedWriter writer, String[] originalArgs) throws IOException {
        this.dumpSummary(originalArgs, writer);
        int i = 0;
        for (Map.Entry<DexMethodNode, Exception> e : this.exceptionMap.entrySet()) {
            DexMethodNode dexMethodNode = e.getKey();
            Exception ex = e.getValue();
            writer.newLine();
            writer.write("================= " + i++ + " ===================");
            writer.newLine();
            this.dumpMethod(writer, dexMethodNode, ex);
        }
    }

    public void dumpZip(Path exFile, String[] originalArgs) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(exFile, new OpenOption[0]));){
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)zos, StandardCharsets.UTF_8));
            zos.putNextEntry(new ZipEntry("summary.txt"));
            this.dumpTxt0(writer, originalArgs);
            zos.closeEntry();
            zos.flush();
        }
    }

    private void dumpMethod(BufferedWriter writer, DexMethodNode dexMethodNode, Exception ex) throws IOException {
        writer.append(dexMethodNode.method.toString());
        writer.newLine();
        writer.flush();
        ex.printStackTrace(new PrintWriter((Writer)writer, true));
        writer.newLine();
        try {
            new BaksmaliDumper().baksmaliMethod(dexMethodNode, writer);
        }
        catch (Exception e) {
            PrintWriter s = new PrintWriter(writer);
            e.printStackTrace(s);
            s.flush();
        }
        writer.flush();
    }

    private void dumpSummary(String[] originalArgs, BufferedWriter writer) throws IOException {
        writer.write("#This file is generated by dex2jar");
        writer.newLine();
        writer.write(REPORT_MESSAGE);
        writer.newLine();
        writer.newLine();
        if (this.fileExceptions.size() > 0) {
            writer.append(String.format("There are %d fails.", this.fileExceptions.size()));
            writer.newLine();
        }
        if (this.exceptionMap.size() > 0) {
            writer.append(String.format("There are %d methods fail to translate.", this.exceptionMap.size()));
            writer.newLine();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        writer.append(sdf.format(new Date()));
        writer.newLine();
        writer.append("version: ");
        writer.append(BaksmaliBaseDexExceptionHandler.getVersionString());
        writer.newLine();
        writer.append("cmdline: ");
        writer.append(Arrays.asList(originalArgs).toString());
        writer.newLine();
        writer.append("env:");
        writer.newLine();
        Properties properties = System.getProperties();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith("java.") || key.toLowerCase().contains("pass")) continue;
            writer.append(key).append(": ").append(properties.getProperty(key));
            writer.newLine();
        }
        PrintWriter p = new PrintWriter((Writer)writer, true);
        for (Exception ex : this.fileExceptions) {
            ex.printStackTrace(p);
        }
        writer.flush();
    }
}

