/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class ModifyVpcEndpoint
extends BaseCmd {
    private static final String[] VPC_ENDPOINT_DESC = new String[]{"The ID of the VPC endpoint."};
    private static final String[] ADD_ROUTE_TABLES_DESC = new String[]{"One or more route tables IDs to associate with the endpoint."};
    private static final String[] REMOVE_ROUTE_TABLES_DESC = new String[]{"One or more route table IDs to disassociate from the endpoint."};
    private static final String[] POLICY_DOCUMENT_DESC = new String[]{"Specifies the file containing the policy to associate with the endpoint."};
    private static final String[] RESET_POLICY_DOCUMENT_DESC = new String[]{"Specify to reset the policy document to the default policy", "The default policy allows access to the endpoint service."};

    public ModifyVpcEndpoint(String[] args) {
        super("ec2mve", "ec2-modify-vpc-endpoint");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"vpc-endpoint");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)ModifyVpcEndpoint.joinDescription(VPC_ENDPOINT_DESC));
        o.addOption(OptionBuilder.create((String)"e"));
        OptionBuilder.withLongOpt((String)"add-route-tables");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)ModifyVpcEndpoint.joinDescription(ADD_ROUTE_TABLES_DESC));
        o.addOption(OptionBuilder.create((String)"a"));
        OptionBuilder.withLongOpt((String)"remove-route-tables");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)ModifyVpcEndpoint.joinDescription(REMOVE_ROUTE_TABLES_DESC));
        o.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withLongOpt((String)"policy-document-file");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)ModifyVpcEndpoint.joinDescription(POLICY_DOCUMENT_DESC));
        o.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"reset-policy-document");
        OptionBuilder.withDescription((String)ModifyVpcEndpoint.joinDescription(RESET_POLICY_DOCUMENT_DESC));
        o.addOption(OptionBuilder.create());
        return o;
    }

    @Override
    protected String getOptionString() {
        return "VPC_ENDPOINT (-a ROUTE_TABLE (-a ROUTE_TABLE)) (-r ROUTE_TABLE (-r ROUTE_TABLE)) (-p POLICY_DOCUMENT | --reset-policy-document)";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Modifies attributes of a specified VPC endpoint. You can modify the policy associated with the endpoint, and you can add and remove route tables associated with the endpoint.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("vpc-endpoint");
        this.printOption("add-route-tables");
        this.printOption("remove-route-tables");
        this.printOption("policy-document-file");
        this.printOption("reset-policy-document");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertOptionSet("vpc-endpoint");
        String vpcEndpointId = this.getOptionValue("vpc-endpoint");
        String[] addRouteTableIds = null;
        String[] removeRouteTableIds = null;
        String policyDocument = null;
        Boolean resetPolicy = null;
        if (this.isOptionSet("add-route-tables")) {
            addRouteTableIds = this.getOptionValues("add-route-tables");
        }
        if (this.isOptionSet("remove-route-tables")) {
            removeRouteTableIds = this.getOptionValues("remove-route-tables");
        }
        if (this.isOptionSet("policy-document-file")) {
            policyDocument = this.readPolicyDocument(this.getOptionValue("policy-document-file"));
        }
        if (this.isOptionSet("reset-policy-document")) {
            resetPolicy = true;
        }
        RequestResultPair rsp = jec2.modifyVpcEndpoint(vpcEndpointId, addRouteTableIds, removeRouteTableIds, policyDocument, resetPolicy);
        out.output(System.out, (Boolean)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new ModifyVpcEndpoint(args).invoke();
    }
}

