# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.infra.domains.forwarding_policies.rules.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class Statistics(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.domains.forwarding_policies.rules.statistics'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StatisticsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             domain_id,
             forwarding_policy_id,
             forwarding_rule_id,
             container_cluster_path=None,
             enforcement_point_path=None,
             ):
        """
        Get aggregated statistics of Forwarding Policy Rule. Stats include
        total number of packets and total number of bytes for the rule. - no
        enforcement point path specified: Stats will be evaluated on each
        enforcement point. - {enforcement_point_path}: Stats are evaluated only
        on the given enforcement point

        :type  domain_id: :class:`str`
        :param domain_id: Domain id (required)
        :type  forwarding_policy_id: :class:`str`
        :param forwarding_policy_id: Forwarding policy id (required)
        :type  forwarding_rule_id: :class:`str`
        :param forwarding_rule_id: Forwarding Rule id (required)
        :type  container_cluster_path: :class:`str` or ``None``
        :param container_cluster_path: String Path of the Container Cluster entity (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ForwardingRuleStatisticsListResult`
        :return: com.vmware.nsx_policy.model.ForwardingRuleStatisticsListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'domain_id': domain_id,
                            'forwarding_policy_id': forwarding_policy_id,
                            'forwarding_rule_id': forwarding_rule_id,
                            'container_cluster_path': container_cluster_path,
                            'enforcement_point_path': enforcement_point_path,
                            })
class _StatisticsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'domain_id': type.StringType(),
            'forwarding_policy_id': type.StringType(),
            'forwarding_rule_id': type.StringType(),
            'container_cluster_path': type.OptionalType(type.StringType()),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/domains/{domain-id}/forwarding-policies/{forwarding-policy-id}/rules/{forwarding-rule-id}/statistics',
            path_variables={
                'domain_id': 'domain-id',
                'forwarding_policy_id': 'forwarding-policy-id',
                'forwarding_rule_id': 'forwarding-rule-id',
            },
             header_parameters={
                       },
            query_parameters={
                'container_cluster_path': 'container_cluster_path',
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'ForwardingRuleStatisticsListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.domains.forwarding_policies.rules.statistics',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'Statistics': Statistics,
    }

