untrusted comment: verify with openbsd-77-base.pub
RWSbCCUoGpcxVWhgCo3NTBHyuMd5/ewqVFQgaKBkve9Ukgahm4xFWRqbIvWhf476NoKlvALnNRKBtv287KZg1DNLMSNt8Dk1yg0=

OpenBSD 7.7 errata 018, January 14, 2026:

A malicious RPKI Trust Anchor can cause memory exhaustion.

Apply by doing:
    signify -Vep /etc/signify/openbsd-77-base.pub -x 018_rpki.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install rpki-client:
    cd /usr/src/usr.sbin/rpki-client
    make obj
    make
    make install

Index: usr.sbin/rpki-client/cert.c
===================================================================
RCS file: /cvs/src/usr.sbin/rpki-client/cert.c,v
diff -u -p -r1.158 cert.c
--- usr.sbin/rpki-client/cert.c	3 Apr 2025 14:29:44 -0000	1.158
+++ usr.sbin/rpki-client/cert.c	9 Jan 2026 16:17:59 -0000
@@ -805,7 +805,6 @@ cert_parse_pre(const char *fn, const uns
 {
 	struct cert		*cert;
 	const unsigned char	*oder;
-	size_t			 j;
 	int			 i, extsz;
 	X509			*x = NULL;
 	X509_EXTENSION		*ext = NULL;
@@ -991,12 +990,21 @@ cert_parse_pre(const char *fn, const uns
 			warnx("%s: unexpected IP resources in BGPsec cert", fn);
 			goto out;
 		}
-		for (j = 0; j < cert->num_ases; j++) {
-			if (cert->ases[j].type == CERT_AS_INHERIT) {
-				warnx("%s: inherit elements not allowed in EE"
-				    " cert", fn);
-				goto out;
-			}
+		if (cert->num_ases == 0) {
+			warnx("%s: missing AS resources in BGPsec cert", fn);
+			goto out;
+		}
+		if (cert->num_ases == 1 &&
+		    cert->ases[0].type == CERT_AS_INHERIT) {
+			warnx("%s: inherit elements not allowed in "
+			    "BGPsec cert", fn);
+			goto out;
+		}
+		if (cert->num_ases != 1 ||
+		    cert->ases[0].type != CERT_AS_ID) {
+			warnx("%s: BGPsec certs with more than one "
+			    "AS number are not supported", fn);
+			goto out;
 		}
 		if (sia) {
 			warnx("%s: unexpected SIA extension in BGPsec cert",
