/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Traceable;
import org.apache.camel.processor.BaseProcessorSupport;
import org.apache.camel.processor.StopProcessor;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplingThrottler
extends BaseProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(SamplingThrottler.class);
    private String id;
    private String routeId;
    private long messageFrequency;
    private long currentMessageCount;
    private long samplePeriod;
    private long periodInMillis;
    private TimeUnit units;
    private long timeOfLastExchange;
    private final StopProcessor stopper = new StopProcessor();
    private final Lock calculationLock = new ReentrantLock();
    private final SampleStats sampled = new SampleStats();

    public SamplingThrottler(long messageFrequency) {
        if (messageFrequency <= 0L) {
            throw new IllegalArgumentException("A positive value is required for the sampling message frequency");
        }
        this.messageFrequency = messageFrequency;
    }

    public SamplingThrottler(long samplePeriod, TimeUnit units) {
        if (samplePeriod <= 0L) {
            throw new IllegalArgumentException("A positive value is required for the sampling period");
        }
        if (units == null) {
            throw new IllegalArgumentException("A invalid null value was supplied for the units of the sampling period");
        }
        this.samplePeriod = samplePeriod;
        this.units = units;
        this.periodInMillis = units.toMillis(samplePeriod);
    }

    public String toString() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getTraceLabel() {
        if (this.messageFrequency > 0L) {
            return "samplingThrottler[1 exchange per: " + this.messageFrequency + " messages received]";
        }
        return "samplingThrottler[1 exchange per: " + this.samplePeriod + " " + this.units.toString().toLowerCase(Locale.ENGLISH) + "]";
    }

    public long getMessageFrequency() {
        return this.messageFrequency;
    }

    public long getSamplePeriod() {
        return this.samplePeriod;
    }

    public TimeUnit getUnits() {
        return this.units;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        boolean doSend = false;
        this.calculationLock.lock();
        try {
            if (this.messageFrequency > 0L) {
                ++this.currentMessageCount;
                if (this.currentMessageCount % this.messageFrequency == 0L) {
                    doSend = true;
                }
            } else {
                long now = Duration.ofNanos(System.nanoTime()).toMillis();
                if (now >= this.timeOfLastExchange + this.periodInMillis) {
                    doSend = true;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(this.sampled.sample());
                    }
                    this.timeOfLastExchange = now;
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace(this.sampled.drop());
                }
            }
        }
        finally {
            this.calculationLock.unlock();
        }
        if (!doSend) {
            try {
                this.stopper.process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
        }
        callback.done(true);
        return true;
    }

    private static class SampleStats {
        private long droppedThisPeriod;
        private long totalDropped;
        private long totalSampled;
        private long totalThisPeriod;

        private SampleStats() {
        }

        String drop() {
            ++this.droppedThisPeriod;
            ++this.totalThisPeriod;
            ++this.totalDropped;
            return this.getDroppedLog();
        }

        String sample() {
            this.totalThisPeriod = 1L;
            ++this.totalSampled;
            this.droppedThisPeriod = 0L;
            return this.getSampledLog();
        }

        String getSampledLog() {
            return String.format("Sampled %d of %d total exchanges", this.totalSampled, this.totalSampled + this.totalDropped);
        }

        String getDroppedLog() {
            return String.format("Dropped %d of %d exchanges in this period, totalling %d dropped of %d exchanges overall.", this.droppedThisPeriod, this.totalThisPeriod, this.totalDropped, this.totalSampled + this.totalDropped);
        }
    }
}

