# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from __future__ import annotations

from datetime import datetime

from airflow.api_fastapi.core_api.base import BaseModel
from airflow.utils.state import TaskInstanceState


class LightGridTaskInstanceSummary(BaseModel):
    """Task Instance Summary model for the Grid UI."""

    task_id: str
    task_display_name: str
    state: TaskInstanceState | None
    child_states: dict[TaskInstanceState | None, int] | None
    min_start_date: datetime | None
    max_end_date: datetime | None
    dag_version_number: int | None = None


class GridTISummaries(BaseModel):
    """DAG Run model for the Grid UI."""

    run_id: str
    dag_id: str
    task_instances: list[LightGridTaskInstanceSummary]
