/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	http "net/http"

	camelv1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1"
	scheme "github.com/apache/camel-k/v2/pkg/client/camel/clientset/versioned/scheme"
	rest "k8s.io/client-go/rest"
)

type CamelV1Interface interface {
	RESTClient() rest.Interface
	BuildsGetter
	CamelCatalogsGetter
	IntegrationsGetter
	IntegrationKitsGetter
	IntegrationPlatformsGetter
	IntegrationProfilesGetter
	KameletsGetter
	PipesGetter
}

// CamelV1Client is used to interact with features provided by the camel.apache.org group.
type CamelV1Client struct {
	restClient rest.Interface
}

func (c *CamelV1Client) Builds(namespace string) BuildInterface {
	return newBuilds(c, namespace)
}

func (c *CamelV1Client) CamelCatalogs(namespace string) CamelCatalogInterface {
	return newCamelCatalogs(c, namespace)
}

func (c *CamelV1Client) Integrations(namespace string) IntegrationInterface {
	return newIntegrations(c, namespace)
}

func (c *CamelV1Client) IntegrationKits(namespace string) IntegrationKitInterface {
	return newIntegrationKits(c, namespace)
}

func (c *CamelV1Client) IntegrationPlatforms(namespace string) IntegrationPlatformInterface {
	return newIntegrationPlatforms(c, namespace)
}

func (c *CamelV1Client) IntegrationProfiles(namespace string) IntegrationProfileInterface {
	return newIntegrationProfiles(c, namespace)
}

func (c *CamelV1Client) Kamelets(namespace string) KameletInterface {
	return newKamelets(c, namespace)
}

func (c *CamelV1Client) Pipes(namespace string) PipeInterface {
	return newPipes(c, namespace)
}

// NewForConfig creates a new CamelV1Client for the given config.
// NewForConfig is equivalent to NewForConfigAndClient(c, httpClient),
// where httpClient was generated with rest.HTTPClientFor(c).
func NewForConfig(c *rest.Config) (*CamelV1Client, error) {
	config := *c
	setConfigDefaults(&config)
	httpClient, err := rest.HTTPClientFor(&config)
	if err != nil {
		return nil, err
	}
	return NewForConfigAndClient(&config, httpClient)
}

// NewForConfigAndClient creates a new CamelV1Client for the given config and http client.
// Note the http client provided takes precedence over the configured transport values.
func NewForConfigAndClient(c *rest.Config, h *http.Client) (*CamelV1Client, error) {
	config := *c
	setConfigDefaults(&config)
	client, err := rest.RESTClientForConfigAndClient(&config, h)
	if err != nil {
		return nil, err
	}
	return &CamelV1Client{client}, nil
}

// NewForConfigOrDie creates a new CamelV1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *CamelV1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new CamelV1Client for the given RESTClient.
func New(c rest.Interface) *CamelV1Client {
	return &CamelV1Client{c}
}

func setConfigDefaults(config *rest.Config) {
	gv := camelv1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = rest.CodecFactoryForGeneratedClient(scheme.Scheme, scheme.Codecs).WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *CamelV1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
