/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.util;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.celeborn.common.exception.CelebornException;
import org.apache.celeborn.common.metrics.source.ThreadPoolSource$;
import org.apache.celeborn.common.util.ThreadExceptionHandler;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Awaitable;
import scala.concurrent.CanAwait;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.VolatileObjectRef;
import scala.util.control.NonFatal$;

public final class ThreadUtils$ {
    public static final ThreadUtils$ MODULE$;
    private final ExecutionContextExecutorService sameThreadExecutionContext;

    static {
        new ThreadUtils$();
    }

    private ExecutionContextExecutorService sameThreadExecutionContext() {
        return this.sameThreadExecutionContext;
    }

    public ExecutorService sameThreadExecutorService() {
        return new AbstractExecutorService(){
            private final ReentrantLock lock;
            private final Condition termination;
            private int runningTasks;
            private boolean serviceIsShutdown;

            private ReentrantLock lock() {
                return this.lock;
            }

            private Condition termination() {
                return this.termination;
            }

            private int runningTasks() {
                return this.runningTasks;
            }

            private void runningTasks_$eq(int x$1) {
                this.runningTasks = x$1;
            }

            private boolean serviceIsShutdown() {
                return this.serviceIsShutdown;
            }

            private void serviceIsShutdown_$eq(boolean x$1) {
                this.serviceIsShutdown = x$1;
            }

            public void shutdown() {
                this.lock().lock();
                try {
                    this.serviceIsShutdown_$eq(true);
                    return;
                }
                finally {
                    this.lock().unlock();
                }
            }

            public List<Runnable> shutdownNow() {
                this.shutdown();
                return Collections.emptyList();
            }

            public boolean isShutdown() {
                this.lock().lock();
                try {
                    return this.serviceIsShutdown();
                }
                finally {
                    this.lock().unlock();
                }
            }

            public synchronized boolean isTerminated() {
                this.lock().lock();
                try {
                    return this.serviceIsShutdown() && this.runningTasks() == 0;
                }
                finally {
                    this.lock().unlock();
                }
            }

            public boolean awaitTermination(long timeout, TimeUnit unit) {
                long nanos = unit.toNanos(timeout);
                this.lock().lock();
                try {
                    while (nanos > 0L && !this.isTerminated()) {
                        nanos = this.termination().awaitNanos(nanos);
                    }
                    return this.isTerminated();
                }
                finally {
                    this.lock().unlock();
                }
            }

            /*
             * Loose catch block
             */
            public void execute(Runnable command) {
                this.lock().lock();
                if (this.isShutdown()) {
                    throw new RejectedExecutionException("Executor already shutdown");
                }
                this.runningTasks_$eq(this.runningTasks() + 1);
                command.run();
                this.lock().lock();
                try {
                    this.runningTasks_$eq(this.runningTasks() - 1);
                    if (this.isTerminated()) {
                        this.termination().signalAll();
                    }
                    return;
                }
                finally {
                    this.lock().unlock();
                }
                catch (Throwable throwable) {
                    this.lock().lock();
                    try {
                        this.runningTasks_$eq(this.runningTasks() - 1);
                        if (this.isTerminated()) {
                            this.termination().signalAll();
                        }
                        throw throwable;
                    }
                    finally {
                        this.lock().unlock();
                    }
                }
                finally {
                    this.lock().unlock();
                }
            }
            {
                this.lock = new ReentrantLock();
                this.termination = this.lock().newCondition();
                this.runningTasks = 0;
                this.serviceIsShutdown = false;
            }
        };
    }

    public ExecutionContextExecutor sameThread() {
        return this.sameThreadExecutionContext();
    }

    public ThreadFactory namedThreadFactory(String threadNamePrefix) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-%d"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{threadNamePrefix}))).setUncaughtExceptionHandler(new ThreadExceptionHandler(threadNamePrefix)).build();
    }

    public ThreadFactory namedSingleThreadFactory(String threadName) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(threadName).setUncaughtExceptionHandler(new ThreadExceptionHandler(threadName)).build();
    }

    /*
     * WARNING - void declaration
     */
    public ThreadPoolExecutor newDaemonCachedThreadPool(String prefix) {
        void var2_2;
        ThreadPoolExecutor threadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool(this.namedThreadFactory(prefix));
        ThreadPoolSource$.MODULE$.registerSource(prefix, threadPool);
        return var2_2;
    }

    public ThreadPoolExecutor newDaemonCachedThreadPool(String prefix, int maxThreadNumber, int keepAliveSeconds) {
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(maxThreadNumber, maxThreadNumber, (long)keepAliveSeconds, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), this.namedThreadFactory(prefix));
        threadPool.allowCoreThreadTimeOut(true);
        ThreadPoolSource$.MODULE$.registerSource(prefix, threadPool);
        return threadPool;
    }

    public int newDaemonCachedThreadPool$default$3() {
        return 60;
    }

    /*
     * WARNING - void declaration
     */
    public ThreadPoolExecutor newDaemonFixedThreadPool(int nThreads, String prefix) {
        void var3_3;
        ThreadPoolExecutor threadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(nThreads, this.namedThreadFactory(prefix));
        ThreadPoolSource$.MODULE$.registerSource(prefix, threadPool);
        return var3_3;
    }

    public ExecutorService newDaemonSingleThreadExecutor(String threadName) {
        return Executors.newSingleThreadExecutor(this.namedSingleThreadFactory(threadName));
    }

    /*
     * WARNING - void declaration
     */
    public ScheduledExecutorService newDaemonSingleThreadScheduledExecutor(String threadName) {
        void var2_2;
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, this.namedSingleThreadFactory(threadName));
        executor.setRemoveOnCancelPolicy(true);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public ScheduledExecutorService newDaemonThreadPoolScheduledExecutor(String threadNamePrefix, int numThreads) {
        void var3_3;
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(numThreads, this.namedThreadFactory(threadNamePrefix));
        executor.setRemoveOnCancelPolicy(true);
        return var3_3;
    }

    public <T> T runInNewThread(String threadName, boolean isDaemon, Function0<T> body) {
        VolatileObjectRef exception = VolatileObjectRef.create((Object)None$.MODULE$);
        VolatileObjectRef result = VolatileObjectRef.create(null);
        Thread thread = new Thread(threadName, body, exception, result){
            private final Function0 body$1;
            private final VolatileObjectRef exception$1;
            private final VolatileObjectRef result$1;

            public void run() {
                try {
                    this.result$1.elem = this.body$1.apply();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.exception$1.elem = new Some((Object)e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.body$1 = body$1;
                this.exception$1 = exception$1;
                this.result$1 = result$1;
                super(threadName$1);
            }
        };
        thread.setDaemon(isDaemon);
        thread.start();
        thread.join();
        Option option = (Option)exception.elem;
        if (option instanceof Some) {
            Some some = (Some)option;
            Throwable realException = (Throwable)some.x();
            StackTraceElement[] baseStackTrace = (StackTraceElement[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace()).dropWhile((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(StackTraceElement x$1) {
                    return !x$1.getClassName().contains(ThreadUtils$.MODULE$.getClass().getSimpleName());
                }
            })).drop(1);
            StackTraceElement[] extraStackTrace = (StackTraceElement[])Predef$.MODULE$.refArrayOps((Object[])realException.getStackTrace()).takeWhile((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(StackTraceElement x$2) {
                    return !x$2.getClassName().contains(ThreadUtils$.MODULE$.getClass().getSimpleName());
                }
            });
            StackTraceElement placeHolderStackElem = new StackTraceElement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"... run in separate thread using ", " .."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString(this.getClass().getName())).stripSuffix("$")})), " ", "", -1);
            StackTraceElement[] finalStackTrace = (StackTraceElement[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])extraStackTrace).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StackTraceElement[]{placeHolderStackElem})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StackTraceElement.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])baseStackTrace), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StackTraceElement.class)));
            realException.setStackTrace(finalStackTrace);
            throw realException;
        }
        if (None$.MODULE$.equals(option)) {
            Object object = result.elem;
            return (T)object;
        }
        throw new MatchError((Object)option);
    }

    public <T> boolean runInNewThread$default$2() {
        return true;
    }

    public ForkJoinPool newForkJoinPool(String prefix, int maxThreadNumber) {
        ForkJoinPool.ForkJoinWorkerThreadFactory factory = new ForkJoinPool.ForkJoinWorkerThreadFactory(prefix){
            public final String prefix$1;

            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                return new ForkJoinWorkerThread(this, pool){
                    {
                        super(pool$1);
                        this.setName(new StringBuilder().append((Object)$outer.prefix$1).append((Object)"-").append((Object)super.getName()).toString());
                    }
                };
            }
            {
                this.prefix$1 = prefix$1;
            }
        };
        return new ForkJoinPool(maxThreadNumber, factory, null, false);
    }

    public <T> T awaitResult(Awaitable<T> awaitable, Duration atMost) throws CelebornException {
        try {
            CanAwait awaitPermission = null;
            return (T)awaitable.result(atMost, awaitPermission);
        }
        catch (Throwable throwable) {
            Throwable t;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty() || (t = (Throwable)option.get()) instanceof TimeoutException) {
                if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    throw throwable3;
                }
                throw throwable;
            }
            throw new CelebornException("Exception thrown in awaitResult: ", t);
        }
    }

    public <T> Awaitable<T> awaitReady(Awaitable<T> awaitable, Duration atMost) throws CelebornException {
        try {
            CanAwait awaitPermission = null;
            return awaitable.ready(atMost, awaitPermission);
        }
        catch (Throwable throwable) {
            Throwable t;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty() || (t = (Throwable)option.get()) instanceof TimeoutException) {
                throw throwable;
            }
            throw new CelebornException("Exception thrown in awaitResult: ", t);
        }
    }

    public void shutdown(ExecutorService executor) {
        this.shutdown(executor, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(800)).millis());
    }

    public void shutdown(ExecutorService executor, Duration gracePeriod) {
        if (executor == null) {
            return;
        }
        try {
            executor.shutdown();
            if (!executor.awaitTermination(gracePeriod.toMillis(), TimeUnit.MILLISECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            executor.shutdownNow();
        }
    }

    public Duration shutdown$default$2() {
        return FiniteDuration$.MODULE$.apply(30L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public <I, O> Iterable<O> parmap(Iterable<I> in, String prefix, int maxThreads, Function1<I, O> f) {
        Iterable iterable;
        ForkJoinPool pool = this.newForkJoinPool(prefix, maxThreads);
        try {
            ExecutionContextExecutor ec = ExecutionContext$.MODULE$.fromExecutor((Executor)pool);
            Iterable futures = (Iterable)in.map((Function1)new Serializable(f, ec){
                public static final long serialVersionUID = 0L;
                public final Function1 f$1;
                private final ExecutionContextExecutor ec$1;

                public final Future<O> apply(I x) {
                    return Future$.MODULE$.apply((Function0)new Serializable(this, x){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.3 $outer;
                        private final Object x$3;

                        public final O apply() {
                            return (O)this.$outer.f$1.apply(this.x$3);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x$3 = x$3;
                        }
                    }, (ExecutionContext)this.ec$1);
                }
                {
                    this.f$1 = f$1;
                    this.ec$1 = ec$1;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            Future futureSeq = Future$.MODULE$.sequence((TraversableOnce)futures, Iterable$.MODULE$.canBuildFrom(), (ExecutionContext)ec);
            iterable = (Iterable)this.awaitResult((Awaitable)futureSeq, (Duration)Duration$.MODULE$.Inf());
            pool.shutdownNow();
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.shutdownNow();
            throw throwable;
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    public Thread newThread(Runnable runnable, String name) {
        void var3_3;
        Thread thread = new Thread(runnable, name);
        thread.setUncaughtExceptionHandler(new ThreadExceptionHandler(name));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Thread newDaemonThread(Runnable runnable, String name) {
        void var3_3;
        Thread thread = this.newThread(runnable, name);
        thread.setDaemon(true);
        return var3_3;
    }

    private ThreadUtils$() {
        MODULE$ = this;
        this.sameThreadExecutionContext = ExecutionContext$.MODULE$.fromExecutorService(this.sameThreadExecutorService());
    }
}

