/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.http;

import org.apache.celeborn.server.common.http.HttpServer;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.math.package$;

public final class HttpServer$
implements Serializable {
    public static HttpServer$ MODULE$;

    static {
        new HttpServer$();
    }

    public HttpServer apply(String role, String host, int port, int poolSize, long stopTimeout, long idleTimeout) {
        QueuedThreadPool pool = new QueuedThreadPool(package$.MODULE$.max(poolSize, 8));
        pool.setName(new StringBuilder(16).append(role).append("-JettyThreadPool").toString());
        pool.setDaemon(true);
        Server server = new Server((ThreadPool)pool);
        server.setStopTimeout(stopTimeout);
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(true);
        errorHandler.setServer(server);
        server.addBean((Object)errorHandler);
        ContextHandlerCollection collection = new ContextHandlerCollection();
        server.setHandler((Handler)collection);
        ScheduledExecutorScheduler serverExecutor = new ScheduledExecutorScheduler(new StringBuilder(15).append(role).append("-JettyScheduler").toString(), true);
        HttpConfiguration httpConf = new HttpConfiguration();
        ServerConnector connector = new ServerConnector(server, null, (Scheduler)serverExecutor, null, -1, -1, new ConnectionFactory[]{new HttpConnectionFactory(httpConf)});
        connector.setHost(host);
        connector.setPort(port);
        connector.setReuseAddress(!SystemUtils.IS_OS_WINDOWS);
        connector.setAcceptQueueSize(package$.MODULE$.min(connector.getAcceptors(), 8));
        connector.setStopTimeout(stopTimeout);
        connector.setIdleTimeout(idleTimeout);
        return new HttpServer(role, server, connector, collection);
    }

    public HttpServer apply(String role, Server server, ServerConnector connector, ContextHandlerCollection rootHandler) {
        return new HttpServer(role, server, connector, rootHandler);
    }

    public Option<Tuple4<String, Server, ServerConnector, ContextHandlerCollection>> unapply(HttpServer x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.role(), (Object)x$0.server(), (Object)x$0.connector(), (Object)x$0.rootHandler()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private HttpServer$() {
        MODULE$ = this;
    }
}

