/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ratis.client.DataStreamClient;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.client.api.DataStreamApi;
import org.apache.ratis.client.api.LeaderElectionManagementApi;
import org.apache.ratis.client.api.SnapshotManagementApi;
import org.apache.ratis.client.impl.AdminImpl;
import org.apache.ratis.client.impl.AsyncImpl;
import org.apache.ratis.client.impl.BlockingImpl;
import org.apache.ratis.client.impl.GroupManagementImpl;
import org.apache.ratis.client.impl.LeaderElectionManagementImpl;
import org.apache.ratis.client.impl.MessageStreamImpl;
import org.apache.ratis.client.impl.OrderedAsync;
import org.apache.ratis.client.impl.SnapshotManagementImpl;
import org.apache.ratis.client.retry.ClientRetryEvent;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.LeaderNotReadyException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.protocol.exceptions.RaftRetryFailureException;
import org.apache.ratis.protocol.exceptions.ResourceUnavailableException;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.thirdparty.com.google.common.cache.Cache;
import org.apache.ratis.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutExecutor;

public final class RaftClientImpl
implements RaftClient {
    private static final Cache<RaftGroupId, RaftPeerId> LEADER_CACHE = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).maximumSize(1024L).build();
    private final ClientId clientId;
    private final RaftClientRpc clientRpc;
    private final RaftPeerList peers = new RaftPeerList();
    private final RaftGroupId groupId;
    private final RetryPolicy retryPolicy;
    private volatile RaftPeerId leaderId;
    private final RepliedCallIds repliedCallIds;
    private final TimeoutExecutor scheduler = TimeoutExecutor.getInstance();
    private final Supplier<OrderedAsync> orderedAsync;
    private final Supplier<AsyncImpl> asyncApi;
    private final Supplier<BlockingImpl> blockingApi;
    private final Supplier<MessageStreamImpl> messageStreamApi;
    private final MemoizedSupplier<DataStreamApi> dataStreamApi;
    private final Supplier<AdminImpl> adminApi;
    private final ConcurrentMap<RaftPeerId, GroupManagementImpl> groupManagement = new ConcurrentHashMap<RaftPeerId, GroupManagementImpl>();
    private final ConcurrentMap<RaftPeerId, SnapshotManagementApi> snapshotManagement = new ConcurrentHashMap<RaftPeerId, SnapshotManagementApi>();
    private final ConcurrentMap<RaftPeerId, LeaderElectionManagementApi> leaderElectionManagement = new ConcurrentHashMap<RaftPeerId, LeaderElectionManagementApi>();

    RaftClientImpl(ClientId clientId, RaftGroup group, RaftPeerId leaderId, RaftPeer primaryDataStreamServer, RaftClientRpc clientRpc, RetryPolicy retryPolicy, RaftProperties properties, Parameters parameters) {
        this.clientId = clientId;
        this.peers.set(group.getPeers());
        this.groupId = group.getGroupId();
        this.leaderId = Objects.requireNonNull(RaftClientImpl.computeLeaderId(leaderId, group), () -> "this.leaderId is set to null, leaderId=" + leaderId + ", group=" + group);
        this.repliedCallIds = new RepliedCallIds(clientId);
        this.retryPolicy = Objects.requireNonNull(retryPolicy, "retry policy can't be null");
        clientRpc.addRaftPeers(group.getPeers());
        this.clientRpc = clientRpc;
        this.orderedAsync = JavaUtils.memoize(() -> OrderedAsync.newInstance(this, properties));
        this.messageStreamApi = JavaUtils.memoize(() -> MessageStreamImpl.newInstance(this, properties));
        this.asyncApi = JavaUtils.memoize(() -> new AsyncImpl(this));
        this.blockingApi = JavaUtils.memoize(() -> new BlockingImpl(this));
        this.dataStreamApi = JavaUtils.memoize(() -> DataStreamClient.newBuilder(this).setDataStreamServer(primaryDataStreamServer).setProperties(properties).setParameters(parameters).build());
        this.adminApi = JavaUtils.memoize(() -> new AdminImpl(this));
    }

    @Override
    public RaftPeerId getLeaderId() {
        return this.leaderId;
    }

    @Override
    public RaftGroupId getGroupId() {
        return this.groupId;
    }

    private static RaftPeerId computeLeaderId(RaftPeerId leaderId, RaftGroup group) {
        if (leaderId != null) {
            return leaderId;
        }
        RaftPeerId cached = (RaftPeerId)LEADER_CACHE.getIfPresent((Object)group.getGroupId());
        if (cached != null && group.getPeer(cached) != null) {
            return cached;
        }
        return RaftClientImpl.getHighestPriorityPeer(group).getId();
    }

    private static RaftPeer getHighestPriorityPeer(RaftGroup group) {
        Iterator i = group.getPeers().iterator();
        if (!i.hasNext()) {
            throw new IllegalArgumentException("Group peers is empty in " + group);
        }
        RaftPeer highest = (RaftPeer)i.next();
        while (i.hasNext()) {
            RaftPeer peer = (RaftPeer)i.next();
            if (peer.getPriority() <= highest.getPriority()) continue;
            highest = peer;
        }
        return highest;
    }

    @Override
    public ClientId getId() {
        return this.clientId;
    }

    RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    TimeDuration getEffectiveSleepTime(Throwable t, TimeDuration sleepDefault) {
        return t instanceof NotLeaderException && ((NotLeaderException)t).getSuggestedLeader() != null ? TimeDuration.ZERO : sleepDefault;
    }

    TimeoutExecutor getScheduler() {
        return this.scheduler;
    }

    OrderedAsync getOrderedAsync() {
        return this.orderedAsync.get();
    }

    RaftClientRequest newRaftClientRequest(RaftPeerId server, long callId, Message message, RaftClientRequest.Type type, RaftProtos.SlidingWindowEntry slidingWindowEntry) {
        RaftClientRequest.Builder b = RaftClientRequest.newBuilder();
        if (server != null) {
            b.setServerId(server);
        } else {
            b.setLeaderId(this.getLeaderId()).setRepliedCallIds(this.repliedCallIds.get(callId));
        }
        return b.setClientId(this.clientId).setGroupId(this.groupId).setCallId(callId).setMessage(message).setType(type).setSlidingWindowEntry(slidingWindowEntry).build();
    }

    @Override
    public AdminImpl admin() {
        return this.adminApi.get();
    }

    @Override
    public GroupManagementImpl getGroupManagementApi(RaftPeerId server) {
        return this.groupManagement.computeIfAbsent(server, id -> new GroupManagementImpl((RaftPeerId)id, this));
    }

    @Override
    public SnapshotManagementApi getSnapshotManagementApi() {
        return (SnapshotManagementApi)JavaUtils.memoize(() -> new SnapshotManagementImpl(null, this)).get();
    }

    @Override
    public SnapshotManagementApi getSnapshotManagementApi(RaftPeerId server) {
        return this.snapshotManagement.computeIfAbsent(server, id -> new SnapshotManagementImpl((RaftPeerId)id, this));
    }

    @Override
    public LeaderElectionManagementApi getLeaderElectionManagementApi(RaftPeerId server) {
        return this.leaderElectionManagement.computeIfAbsent(server, id -> new LeaderElectionManagementImpl((RaftPeerId)id, this));
    }

    @Override
    public BlockingImpl io() {
        return this.blockingApi.get();
    }

    @Override
    public AsyncImpl async() {
        return this.asyncApi.get();
    }

    @Override
    public MessageStreamImpl getMessageStreamApi() {
        return this.messageStreamApi.get();
    }

    @Override
    public DataStreamApi getDataStreamApi() {
        return (DataStreamApi)this.dataStreamApi.get();
    }

    Throwable noMoreRetries(ClientRetryEvent event) {
        int attemptCount = event.getAttemptCount();
        Throwable throwable = event.getCause();
        if (attemptCount == 1 && throwable != null) {
            return throwable;
        }
        return new RaftRetryFailureException(event.getRequest(), attemptCount, this.retryPolicy, throwable);
    }

    RaftClientReply handleReply(RaftClientRequest request, RaftClientReply reply) {
        if (request.isToLeader() && reply != null) {
            if (!request.getType().isReadOnly()) {
                this.repliedCallIds.add(reply.getCallId());
            }
            if (reply.getException() == null) {
                LEADER_CACHE.put((Object)reply.getRaftGroupId(), (Object)reply.getServerId());
            }
        }
        return reply;
    }

    static <E extends Throwable> RaftClientReply handleRaftException(RaftClientReply reply, Function<RaftException, E> converter) throws E {
        RaftException e;
        if (reply != null && (e = reply.getException()) != null) {
            throw (Throwable)converter.apply(e);
        }
        return reply;
    }

    RaftClientReply handleLeaderException(RaftClientRequest request, RaftClientReply reply) {
        if (reply == null || reply.getException() instanceof LeaderNotReadyException) {
            return null;
        }
        NotLeaderException nle = reply.getNotLeaderException();
        if (nle == null) {
            return reply;
        }
        return this.handleNotLeaderException(request, nle, null);
    }

    RaftClientReply handleNotLeaderException(RaftClientRequest request, NotLeaderException nle, Consumer<RaftClientRequest> handler) {
        this.refreshPeers(nle.getPeers());
        RaftPeerId newLeader = nle.getSuggestedLeader() == null ? null : nle.getSuggestedLeader().getId();
        this.handleIOException(request, (IOException)nle, newLeader, handler);
        return null;
    }

    private void refreshPeers(Collection<RaftPeer> newPeers) {
        if (newPeers != null && !newPeers.isEmpty()) {
            this.peers.set(newPeers);
            this.clientRpc.addRaftPeers(newPeers);
        }
    }

    void handleIOException(RaftClientRequest request, IOException ioe) {
        this.handleIOException(request, ioe, null, null);
    }

    void handleIOException(RaftClientRequest request, IOException ioe, RaftPeerId newLeader, Consumer<RaftClientRequest> handler) {
        boolean reconnect;
        LOG.debug("{}: suggested new leader: {}. Failed {} with {}", new Object[]{this.clientId, newLeader, request, ioe});
        if (LOG.isTraceEnabled()) {
            LOG.trace("Stack trace", new Throwable("TRACE"));
        }
        Optional.ofNullable(handler).ifPresent(h -> h.accept(request));
        if (ioe instanceof LeaderNotReadyException || ioe instanceof ResourceUnavailableException) {
            return;
        }
        RaftPeerId oldLeader = request.getServerId();
        RaftPeerId curLeader = this.getLeaderId();
        boolean stillLeader = oldLeader.equals((Object)curLeader);
        if (newLeader == null && stillLeader) {
            newLeader = (RaftPeerId)CollectionUtils.random((Object)oldLeader, (Iterable)CollectionUtils.as((Iterable)this.peers, RaftPeer::getId));
        }
        LOG.debug("{}: oldLeader={},  curLeader={}, newLeader={}", new Object[]{this.clientId, oldLeader, curLeader, newLeader});
        boolean changeLeader = newLeader != null && stillLeader;
        boolean bl = reconnect = changeLeader || this.clientRpc.shouldReconnect(ioe);
        if (reconnect) {
            if (changeLeader && oldLeader.equals((Object)this.getLeaderId())) {
                LOG.debug("{} changes Leader from {} to {} for {}", new Object[]{this.clientId, oldLeader, newLeader, this.groupId, ioe});
                this.leaderId = newLeader;
            }
            this.clientRpc.handleException(oldLeader, ioe, true);
        }
    }

    @Override
    public RaftClientRpc getClientRpc() {
        return this.clientRpc;
    }

    @Override
    public void close() throws IOException {
        this.clientRpc.close();
        if (this.dataStreamApi.isInitialized()) {
            ((DataStreamApi)this.dataStreamApi.get()).close();
        }
    }

    static class RepliedCallIds {
        private final Object name;
        private Set<Long> replied = new TreeSet<Long>();
        private final ConcurrentMap<Long, Set<Long>> sent = new ConcurrentHashMap<Long, Set<Long>>();

        RepliedCallIds(Object name) {
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(long repliedCallId) {
            RaftClient.LOG.debug("{}: add replied callId {}", this.name, (Object)repliedCallId);
            RepliedCallIds repliedCallIds = this;
            synchronized (repliedCallIds) {
                this.replied.add(repliedCallId);
            }
            this.sent.remove(repliedCallId);
        }

        Iterable<Long> get(long callId) {
            MemoizedSupplier supplier = MemoizedSupplier.valueOf(this::getAndReset);
            Set<Long> set = Collections.unmodifiableSet(this.sent.computeIfAbsent(callId, arg_0 -> RepliedCallIds.lambda$get$0((Supplier)supplier, arg_0)));
            RaftClient.LOG.debug("{}: get {} returns {}", new Object[]{this.name, callId, set});
            return set;
        }

        private synchronized Set<Long> getAndReset() {
            Set<Long> previous = this.replied;
            this.replied = new TreeSet<Long>();
            return previous;
        }

        private static /* synthetic */ Set lambda$get$0(Supplier supplier, Long cid) {
            return (Set)supplier.get();
        }
    }

    static class RaftPeerList
    implements Iterable<RaftPeer> {
        private final AtomicReference<List<RaftPeer>> list = new AtomicReference();

        RaftPeerList() {
        }

        @Override
        public Iterator<RaftPeer> iterator() {
            return this.list.get().iterator();
        }

        void set(Collection<RaftPeer> newPeers) {
            Preconditions.assertTrue((!newPeers.isEmpty() ? 1 : 0) != 0, (Object)"newPeers is empty.");
            this.list.set(Collections.unmodifiableList(new ArrayList<RaftPeer>(newPeers)));
        }
    }

    public static abstract class PendingClientRequest {
        private final long creationTimeInMs = System.currentTimeMillis();
        private final CompletableFuture<RaftClientReply> replyFuture = new CompletableFuture();
        private final AtomicInteger attemptCount = new AtomicInteger();
        private final Map<Class<?>, Integer> exceptionCount = new ConcurrentHashMap();

        public abstract RaftClientRequest newRequestImpl();

        final RaftClientRequest newRequest() {
            this.attemptCount.incrementAndGet();
            return this.newRequestImpl();
        }

        CompletableFuture<RaftClientReply> getReplyFuture() {
            return this.replyFuture;
        }

        public int getAttemptCount() {
            return this.attemptCount.get();
        }

        int incrementExceptionCount(Throwable t) {
            return t != null ? this.exceptionCount.compute(t.getClass(), (k, v) -> v != null ? v + 1 : 1) : 0;
        }

        public int getExceptionCount(Throwable t) {
            return t != null ? Optional.ofNullable(this.exceptionCount.get(t.getClass())).orElse(0) : 0;
        }

        public boolean isRequestTimeout(TimeDuration timeout) {
            if (timeout == null) {
                return false;
            }
            return System.currentTimeMillis() - this.creationTimeInMs > timeout.toLong(TimeUnit.MILLISECONDS);
        }
    }
}

