/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import java.io.IOException;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.service.deploy.worker.storage.DeviceMonitor;
import org.apache.celeborn.service.deploy.worker.storage.PartitionDataWriter;
import org.apache.celeborn.service.deploy.worker.storage.PartitionDataWriterContext;
import org.apache.celeborn.service.deploy.worker.storage.StorageManager;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReducePartitionDataWriter
extends PartitionDataWriter {
    private static final Logger logger = LoggerFactory.getLogger(ReducePartitionDataWriter.class);

    public ReducePartitionDataWriter(StorageManager storageManager, AbstractSource workerSource, CelebornConf conf, DeviceMonitor deviceMonitor, PartitionDataWriterContext writerContext) throws IOException {
        super(storageManager, workerSource, conf, deviceMonitor, writerContext, true);
    }

    private void updateLastChunkOffset() {
        FileInfo fileInfo = this.getCurrentFileInfo();
        fileInfo.getReduceFileMeta().updateChunkOffset(fileInfo.getFileLength(), true);
    }

    @Override
    public void flush(boolean finalFlush, boolean fromEvict) throws IOException {
        super.flush(finalFlush, fromEvict);
        this.getCurrentFileInfo().getReduceFileMeta().updateChunkOffset(this.getCurrentFileInfo().getFileLength(), finalFlush);
    }

    private boolean isChunkOffsetValid() {
        if (this.diskFileInfo != null) {
            return this.diskFileInfo.getReduceFileMeta().getLastChunkOffset() == this.diskFileInfo.getFileLength();
        }
        if (this.memoryFileInfo != null) {
            return this.memoryFileInfo.getReduceFileMeta().getLastChunkOffset() == this.memoryFileInfo.getFileLength();
        }
        return false;
    }

    @Override
    public synchronized long close() throws IOException {
        long streamId = super.close(() -> {
            if (!this.isChunkOffsetValid()) {
                this.updateLastChunkOffset();
            }
        }, () -> {
            if (this.diskFileInfo != null) {
                if (this.diskFileInfo.isHdfs()) {
                    if (StorageManager.hadoopFs().exists(this.diskFileInfo.getHdfsPeerWriterSuccessPath())) {
                        StorageManager.hadoopFs().delete(this.diskFileInfo.getHdfsPath(), false);
                        this.deleted = true;
                    } else {
                        StorageManager.hadoopFs().create(this.diskFileInfo.getHdfsWriterSuccessPath()).close();
                        FSDataOutputStream indexOutputStream = StorageManager.hadoopFs().create(this.diskFileInfo.getHdfsIndexPath());
                        indexOutputStream.writeInt(this.diskFileInfo.getReduceFileMeta().getChunkOffsets().size());
                        for (Long offset : this.diskFileInfo.getReduceFileMeta().getChunkOffsets()) {
                            indexOutputStream.writeLong(offset.longValue());
                        }
                        indexOutputStream.close();
                    }
                }
            } else {
                Object object = this.flushLock;
                synchronized (object) {
                    this.flushBuffer.consolidate();
                    this.memoryFileInfo.setBuffer(this.flushBuffer);
                }
            }
        }, () -> {});
        return streamId;
    }
}

