/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.client.ShuffleClientImpl;
import org.apache.celeborn.client.read.CelebornInputStream;
import org.apache.celeborn.client.read.MetricsCallback;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.exception.PartitionUnRetryAbleException;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PbOpenStreamList;
import org.apache.celeborn.common.protocol.PbOpenStreamListResponse;
import org.apache.celeborn.common.protocol.PbStreamHandler;
import org.apache.celeborn.common.protocol.PbStreamHandlerOpt;
import org.apache.celeborn.common.protocol.message.StatusCode;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.apache.spark.Aggregator;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.TaskContext;
import org.apache.spark.celeborn.ExceptionMakerHelper$;
import org.apache.spark.internal.Logging;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.shuffle.FetchFailedException;
import org.apache.spark.shuffle.ShuffleReadMetricsReporter;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.celeborn.CelebornShuffleHandle;
import org.apache.spark.shuffle.celeborn.CelebornShuffleReader$;
import org.apache.spark.shuffle.celeborn.ExecutorShuffleIdTracker;
import org.apache.spark.shuffle.celeborn.SparkCommonUtils;
import org.apache.spark.shuffle.celeborn.SparkUtils;
import org.apache.spark.util.CompletionIterator;
import org.apache.spark.util.CompletionIterator$;
import org.apache.spark.util.collection.ExternalSorter;
import org.apache.spark.util.collection.ExternalSorter$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product2;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001\u0002\u0011\"\u00011B\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t+\u0002\u0011\t\u0011)A\u0005-\"A\u0011\f\u0001B\u0001B\u0003%a\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003W\u0011!Y\u0006A!A!\u0002\u00131\u0006\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011B/\t\u0011\u0005\u0004!\u0011!Q\u0001\n\tD\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\t[\u0002\u0011\t\u0011)A\u0005]\")\u0011\u000f\u0001C\u0001e\"I\u00111\u0001\u0001C\u0002\u0013%\u0011Q\u0001\u0005\t\u0003'\u0001\u0001\u0015!\u0003\u0002\b!I\u0011Q\u0003\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003K\u0001\u0001\u0015!\u0003\u0002\u001a!I\u0011q\u0005\u0001C\u0002\u0013%\u0011\u0011\u0006\u0005\t\u0003\u001f\u0002\u0001\u0015!\u0003\u0002,!I\u0011\u0011\u000b\u0001C\u0002\u0013%\u00111\u000b\u0005\t\u00037\u0002\u0001\u0015!\u0003\u0002V!I\u0011Q\f\u0001C\u0002\u0013%\u0011q\f\u0005\b\u0003C\u0002\u0001\u0015!\u0003W\u0011\u001d\t\u0019\u0007\u0001C!\u0003KBq!!\"\u0001\t\u0013\t9\tC\u0004\u0002 \u0002!\t!!)\b\u000f\u0005m\u0016\u0005#\u0001\u0002>\u001a1\u0001%\tE\u0001\u0003\u007fCa!]\r\u0005\u0002\u0005\u0005\u0007\"CAb3\u0001\u0007I\u0011AAc\u0011%\ty-\u0007a\u0001\n\u0003\t\t\u000e\u0003\u0005\u0002^f\u0001\u000b\u0015BAd\u0011%\ty.GI\u0001\n\u0003\t\t\u000fC\u0005\u0002~f\t\n\u0011\"\u0001\u0002\u0000\n)2)\u001a7fE>\u0014hn\u00155vM\u001adWMU3bI\u0016\u0014(B\u0001\u0012$\u0003!\u0019W\r\\3c_Jt'B\u0001\u0013&\u0003\u001d\u0019\b.\u001e4gY\u0016T!AJ\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005!J\u0013AB1qC\u000eDWMC\u0001+\u0003\ry'oZ\u0002\u0001+\ri#\bR\n\u0005\u00019\"d\t\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0004B]f\u0014VM\u001a\t\u0005kYB4)D\u0001$\u0013\t94EA\u0007TQV4g\r\\3SK\u0006$WM\u001d\t\u0003sib\u0001\u0001B\u0003<\u0001\t\u0007AHA\u0001L#\ti\u0004\t\u0005\u00020}%\u0011q\b\r\u0002\b\u001d>$\b.\u001b8h!\ty\u0013)\u0003\u0002Ca\t\u0019\u0011I\\=\u0011\u0005e\"E!B#\u0001\u0005\u0004a$!A\"\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%+\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005-C%a\u0002'pO\u001eLgnZ\u0001\u0007Q\u0006tG\r\\31\u00059\u001b\u0006#B(QqI\u001bU\"A\u0011\n\u0005E\u000b#!F\"fY\u0016\u0014wN\u001d8TQV4g\r\\3IC:$G.\u001a\t\u0003sM#\u0011\u0002V\u0001\u0002\u0002\u0003\u0005)\u0011\u0001\u001f\u0003\u0007}#\u0013'\u0001\bti\u0006\u0014H\u000fU1si&$\u0018n\u001c8\u0011\u0005=:\u0016B\u0001-1\u0005\rIe\u000e^\u0001\rK:$\u0007+\u0019:uSRLwN\\\u0001\u000egR\f'\u000f^'ba&sG-\u001a=\u0002\u0017\u0015tG-T1q\u0013:$W\r_\u0001\bG>tG/\u001a=u!\tqv,D\u0001&\u0013\t\u0001WEA\u0006UCN\\7i\u001c8uKb$\u0018\u0001B2p]\u001a\u0004\"aY4\u000e\u0003\u0011T!!\u001a4\u0002\r\r|W.\\8o\u0015\t\u0011s%\u0003\u0002iI\na1)\u001a7fE>\u0014hnQ8oM\u00069Q.\u001a;sS\u000e\u001c\bCA\u001bl\u0013\ta7E\u0001\u000eTQV4g\r\\3SK\u0006$W*\u001a;sS\u000e\u001c(+\u001a9peR,'/\u0001\ttQV4g\r\\3JIR\u0013\u0018mY6feB\u0011qj\\\u0005\u0003a\u0006\u0012\u0001$\u0012=fGV$xN]*ik\u001a4G.Z%e)J\f7m[3s\u0003\u0019a\u0014N\\5u}QY1\u000f^={wrlhp`A\u0001!\u0011y\u0005\u0001O\"\t\u000b1S\u0001\u0019A;1\u0005YD\b#B(Qq]\u001c\u0005CA\u001dy\t%!F/!A\u0001\u0002\u000b\u0005A\bC\u0003V\u0015\u0001\u0007a\u000bC\u0003Z\u0015\u0001\u0007a\u000bC\u0004[\u0015A\u0005\t\u0019\u0001,\t\u000fmS\u0001\u0013!a\u0001-\")AL\u0003a\u0001;\")\u0011M\u0003a\u0001E\")\u0011N\u0003a\u0001U\")QN\u0003a\u0001]\u0006\u0019A-\u001a9\u0016\u0005\u0005\u001d\u0001\u0007BA\u0005\u0003#\u0001rAXA\u0006q\u0005=1)C\u0002\u0002\u000e\u0015\u0012\u0011c\u00155vM\u001adW\rR3qK:$WM\\2z!\rI\u0014\u0011\u0003\u0003\n)\u0006\t\t\u0011!A\u0003\u0002q\nA\u0001Z3qA\u0005i1\u000f[;gM2,7\t\\5f]R,\"!!\u0007\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\bg\u0003\u0019\u0019G.[3oi&!\u00111EA\u000f\u00055\u0019\u0006.\u001e4gY\u0016\u001cE.[3oi\u0006q1\u000f[;gM2,7\t\\5f]R\u0004\u0013\u0001D3yG\u0016\u0004H/[8o%\u00164WCAA\u0016!\u0019\ti#a\u0010\u0002D5\u0011\u0011q\u0006\u0006\u0005\u0003c\t\u0019$\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003k\t9$\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\u000f\u0002<\u0005!Q\u000f^5m\u0015\t\ti$\u0001\u0003kCZ\f\u0017\u0002BA!\u0003_\u0011q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\t\u0005\u0003\u000b\nY%\u0004\u0002\u0002H)!\u0011\u0011JA\u001e\u0003\tIw.\u0003\u0003\u0002N\u0005\u001d#aC%P\u000bb\u001cW\r\u001d;j_:\fQ\"\u001a=dKB$\u0018n\u001c8SK\u001a\u0004\u0013A\u0005;ie><8OR3uG\"4\u0015-\u001b7ve\u0016,\"!!\u0016\u0011\u0007=\n9&C\u0002\u0002ZA\u0012qAQ8pY\u0016\fg.A\nuQJ|wo\u001d$fi\u000eDg)Y5mkJ,\u0007%\u0001\tf]\u000e|G-\u001a3BiR,W\u000e\u001d;JIV\ta+A\tf]\u000e|G-\u001a3BiR,W\u000e\u001d;JI\u0002\nAA]3bIR\u0011\u0011q\r\t\u0007\u0003S\nI(a \u000f\t\u0005-\u0014Q\u000f\b\u0005\u0003[\n\u0019(\u0004\u0002\u0002p)\u0019\u0011\u0011O\u0016\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0014bAA<a\u00059\u0001/Y2lC\u001e,\u0017\u0002BA>\u0003{\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003o\u0002\u0004#B\u0018\u0002\u0002b\u001a\u0015bAABa\tA\u0001K]8ek\u000e$('A\u000biC:$G.\u001a$fi\u000eDW\t_2faRLwN\\:\u0015\u0013u\nI)!$\u0002\u0012\u0006U\u0005BBAF-\u0001\u0007a+\u0001\u0007baB\u001c\u0006.\u001e4gY\u0016LE\r\u0003\u0004\u0002\u0010Z\u0001\rAV\u0001\ng\",hM\u001a7f\u0013\u0012Da!a%\u0017\u0001\u00041\u0016a\u00039beRLG/[8o\u0013\u0012Dq!a&\u0017\u0001\u0004\tI*\u0001\u0002dKB!\u0011\u0011NAN\u0013\u0011\ti*! \u0003\u0013QC'o\\<bE2,\u0017!\u00068foN+'/[1mSj,'/\u00138ti\u0006t7-\u001a\u000b\u0005\u0003G\u000by\u000b\u0005\u0003\u0002&\u0006-VBAAT\u0015\r\tI+J\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018\u0002BAW\u0003O\u0013!cU3sS\u0006d\u0017N_3s\u0013:\u001cH/\u00198dK\"9\u00111A\fA\u0002\u0005E\u0006\u0007BAZ\u0003o\u0003rAXA\u0006q\u0005U6\tE\u0002:\u0003o#1\"!/\u00020\u0006\u0005\t\u0011!B\u0001y\t\u0019q\fJ\u001a\u0002+\r+G.\u001a2pe:\u001c\u0006.\u001e4gY\u0016\u0014V-\u00193feB\u0011q*G\n\u000339\"\"!!0\u0002#M$(/Z1n\u0007J,\u0017\r^8s!>|G.\u0006\u0002\u0002HB!\u0011\u0011ZAf\u001b\t\t\u0019$\u0003\u0003\u0002N\u0006M\"A\u0005+ie\u0016\fG\rU8pY\u0016CXmY;u_J\fQc\u001d;sK\u0006l7I]3bi>\u0014\bk\\8m?\u0012*\u0017\u000f\u0006\u0003\u0002T\u0006e\u0007cA\u0018\u0002V&\u0019\u0011q\u001b\u0019\u0003\tUs\u0017\u000e\u001e\u0005\n\u00037d\u0012\u0011!a\u0001\u0003\u000f\f1\u0001\u001f\u00132\u0003I\u0019HO]3b[\u000e\u0013X-\u0019;peB{w\u000e\u001c\u0011\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\u0019\t\u0019/!?\u0002|V\u0011\u0011Q\u001d\u0016\u0004-\u0006\u001d8FAAu!\u0011\tY/!>\u000e\u0005\u00055(\u0002BAx\u0003c\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005M\b'\u0001\u0006b]:|G/\u0019;j_:LA!a>\u0002n\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000bmr\"\u0019\u0001\u001f\u0005\u000b\u0015s\"\u0019\u0001\u001f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\u0019\t\u0019O!\u0001\u0003\u0004\u0011)1h\bb\u0001y\u0011)Qi\bb\u0001y\u0001")
public class CelebornShuffleReader<K, C>
implements ShuffleReader<K, C>,
Logging {
    private final CelebornShuffleHandle<K, ?, C> handle;
    private final int startPartition;
    private final int endPartition;
    private final int startMapIndex;
    private final int endMapIndex;
    private final TaskContext context;
    private final CelebornConf conf;
    public final ShuffleReadMetricsReporter org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics;
    private final ExecutorShuffleIdTracker shuffleIdTracker;
    private final ShuffleDependency<K, ?, C> dep;
    private final ShuffleClient shuffleClient;
    private final AtomicReference<IOException> exceptionRef;
    private final boolean throwsFetchFailure;
    private final int encodedAttemptId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <K, C> int $lessinit$greater$default$5() {
        return CelebornShuffleReader$.MODULE$.$lessinit$greater$default$5();
    }

    public static <K, C> int $lessinit$greater$default$4() {
        return CelebornShuffleReader$.MODULE$.$lessinit$greater$default$4();
    }

    public static void streamCreatorPool_$eq(ThreadPoolExecutor threadPoolExecutor) {
        CelebornShuffleReader$.MODULE$.streamCreatorPool_$eq(threadPoolExecutor);
    }

    public static ThreadPoolExecutor streamCreatorPool() {
        return CelebornShuffleReader$.MODULE$.streamCreatorPool();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ShuffleDependency<K, ?, C> dep() {
        return this.dep;
    }

    private ShuffleClient shuffleClient() {
        return this.shuffleClient;
    }

    private AtomicReference<IOException> exceptionRef() {
        return this.exceptionRef;
    }

    private boolean throwsFetchFailure() {
        return this.throwsFetchFailure;
    }

    private int encodedAttemptId() {
        return this.encodedAttemptId;
    }

    public Iterator<Product2<K, C>> read() {
        InterruptibleIterator resultIter;
        InterruptibleIterator interruptibleIterator;
        SerializerInstance serializerInstance = this.newSerializerInstance(this.dep());
        int shuffleId = SparkUtils.celebornShuffleId(this.shuffleClient(), this.handle, this.context, Predef$.MODULE$.boolean2Boolean(false));
        this.shuffleIdTracker.track(this.handle.shuffleId(), shuffleId);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("get shuffleId ").append(shuffleId).append(" for appShuffleId ").append($this.handle.shuffleId()).append(" attemptNum ").append($this.context.stageAttemptNumber()).toString());
        MetricsCallback metricsCallback = new MetricsCallback(this){
            private final /* synthetic */ CelebornShuffleReader $outer;

            public void incBytesRead(long bytesWritten) {
                this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics.incRemoteBytesRead(bytesWritten);
                this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics.incRemoteBlocksFetched(1L);
            }

            public void incReadTime(long time) {
                this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics.incFetchWaitTime(time);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        if (CelebornShuffleReader$.MODULE$.streamCreatorPool() == null) {
            CelebornShuffleReader$ celebornShuffleReader$ = CelebornShuffleReader$.MODULE$;
            synchronized (celebornShuffleReader$) {
                if (CelebornShuffleReader$.MODULE$.streamCreatorPool() == null) {
                    CelebornShuffleReader$.MODULE$.streamCreatorPool_$eq(ThreadUtils$.MODULE$.newDaemonCachedThreadPool("celeborn-create-stream-thread", this.conf.readStreamCreatorPoolThreads(), 60));
                }
            }
        }
        long startTime = System.currentTimeMillis();
        long fetchTimeoutMs = this.conf.clientFetchTimeoutMs();
        boolean localFetchEnabled = this.conf.enableReadLocalShuffleFile();
        String localHostAddress = Utils$.MODULE$.localHostName(this.conf);
        String shuffleKey = Utils$.MODULE$.makeShuffleKey(this.handle.appUniqueId(), shuffleId);
        ObjectRef fileGroups = ObjectRef.create(null);
        try {
            fileGroups.elem = this.shuffleClient().updateFileGroup(shuffleId, this.startPartition);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof CelebornIOException ? true : throwable2 instanceof PartitionUnRetryAbleException) {
                throw this.handleFetchExceptions(this.handle.shuffleId(), shuffleId, 0, throwable2);
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                throw throwable3;
            }
            throw throwable;
        }
        HashMap workerRequestMap = new HashMap();
        IntRef partCnt = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.startPartition), this.endPartition).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
            if (((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).partitionGroups.containsKey(BoxesRunTime.boxToInteger((int)partitionId))) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).partitionGroups.get(BoxesRunTime.boxToInteger((int)partitionId))).asScala()).foreach((Function1 & Serializable & scala.Serializable)location -> {
                    Tuple3 tuple3;
                    BoxedUnit boxedUnit;
                    ++partCnt$1.elem;
                    String hostPort = location.hostAndFetchPort();
                    if (!workerRequestMap.containsKey(hostPort)) {
                        try {
                            TransportClient client = this.shuffleClient().getDataClientFactory().createClient(location.getHost(), location.getFetchPort());
                            PbOpenStreamList.Builder pbOpenStreamList = PbOpenStreamList.newBuilder();
                            pbOpenStreamList.setShuffleKey(shuffleKey);
                            boxedUnit = workerRequestMap.put(hostPort, new Tuple3((Object)client, new ArrayList(), (Object)pbOpenStreamList));
                        }
                        catch (Exception ex) {
                            this.shuffleClient().excludeFailedFetchLocation(location.hostAndFetchPort(), ex);
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Failed to create client for ").append(shuffleKey).append("-").append(partitionId).append(" from host: ").append(location.hostAndFetchPort()).append(". ").append("Shuffle reader will try its replica if exists.").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    if ((tuple3 = (Tuple3)workerRequestMap.get(hostPort)) != null) {
                        ArrayList locArr = (ArrayList)tuple3._2();
                        PbOpenStreamList.Builder pbOpenStreamListBuilder = (PbOpenStreamList.Builder)tuple3._3();
                        locArr.add(location);
                        pbOpenStreamListBuilder.addFileName(location.getFileName()).addStartIndex($this.startMapIndex).addEndIndex($this.endMapIndex);
                        return pbOpenStreamListBuilder.addReadLocalShuffle(localFetchEnabled && location.getHost().equals(localHostAddress));
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Empty client for host ").append(hostPort).toString());
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
        ConcurrentHashMap locationStreamHandlerMap = JavaUtils.newConcurrentHashMap();
        List futures = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(workerRequestMap.values()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> CelebornShuffleReader$.MODULE$.streamCreatorPool().submit(new Runnable(null, (Tuple3)entry, fetchTimeoutMs, locationStreamHandlerMap){
            private final Tuple3 entry$1;
            private final long fetchTimeoutMs$1;
            private final ConcurrentHashMap locationStreamHandlerMap$1;

            public void run() {
                PbOpenStreamListResponse pbOpenStreamListResponse;
                PbOpenStreamListResponse pbOpenStreamListResponse2;
                Tuple3 tuple3 = this.entry$1;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                TransportClient client = (TransportClient)tuple3._1();
                ArrayList locArr = (ArrayList)tuple3._2();
                PbOpenStreamList.Builder pbOpenStreamListBuilder = (PbOpenStreamList.Builder)tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)client, (Object)locArr, (Object)pbOpenStreamListBuilder);
                TransportClient client2 = (TransportClient)tuple32._1();
                ArrayList locArr2 = (ArrayList)tuple32._2();
                PbOpenStreamList.Builder pbOpenStreamListBuilder2 = (PbOpenStreamList.Builder)tuple32._3();
                TransportMessage msg = new TransportMessage(MessageType.BATCH_OPEN_STREAM, pbOpenStreamListBuilder2.build().toByteArray());
                try {
                    ByteBuffer response = client2.sendRpcSync(msg.toByteBuffer(), this.fetchTimeoutMs$1);
                    pbOpenStreamListResponse2 = (PbOpenStreamListResponse)TransportMessage.fromByteBuffer(response).getParsedPayload();
                }
                catch (Exception exception) {
                    pbOpenStreamListResponse2 = pbOpenStreamListResponse = null;
                }
                if (pbOpenStreamListResponse != null) {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), locArr2.size()).foreach((Function1 & Serializable & scala.Serializable)idx -> $anon$2.$anonfun$run$1(this, pbOpenStreamListResponse, locArr2, BoxesRunTime.unboxToInt((Object)idx)));
                    return;
                }
            }

            public static final /* synthetic */ Object $anonfun$run$1($anon$2 $this, PbOpenStreamListResponse pbOpenStreamListResponse$1, ArrayList locArr$1, int idx) {
                PbStreamHandlerOpt streamHandlerOpt = pbOpenStreamListResponse$1.getStreamHandlerOptList().get(idx);
                if (streamHandlerOpt.getStatus() == StatusCode.SUCCESS.getValue()) {
                    return $this.locationStreamHandlerMap$1.put(locArr$1.get(idx), streamHandlerOpt.getStreamHandler());
                }
                return BoxedUnit.UNIT;
            }
            {
                this.entry$1 = entry$1;
                this.fetchTimeoutMs$1 = fetchTimeoutMs$1;
                this.locationStreamHandlerMap$1 = locationStreamHandlerMap$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.spark.shuffle.celeborn.CelebornShuffleReader$$anon$2 org.apache.celeborn.common.protocol.PbOpenStreamListResponse java.util.ArrayList java.lang.Object )}, serializedLambda);
            }
        }), Iterable$.MODULE$.canBuildFrom())).toList();
        futures.foreach((Function1 & Serializable & scala.Serializable)f -> f.get());
        long end = System.currentTimeMillis();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("BatchOpenStream for ").append(partCnt$1.elem).append(" cost ").append(end - startTime).append("ms").toString());
        ConcurrentHashMap streams = new ConcurrentHashMap();
        int inputStreamCreationWindow = this.conf.clientInputStreamCreationWindow();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.startPartition), Math.min(this.startPartition + inputStreamCreationWindow, this.endPartition)).foreach((Function1 & Serializable & scala.Serializable)partitionId -> CelebornShuffleReader.$anonfun$read$12(this, fileGroups, locationStreamHandlerMap, shuffleId, metricsCallback, streams, BoxesRunTime.unboxToInt((Object)partitionId)));
        Iterator recordIter = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.startPartition), this.endPartition).iterator().map((Function1 & Serializable & scala.Serializable)partitionId -> CelebornShuffleReader.$anonfun$read$13(this, streams, shuffleId, metricsCallback, inputStreamCreationWindow, fileGroups, locationStreamHandlerMap, BoxesRunTime.unboxToInt((Object)partitionId))).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CelebornShuffleReader.$anonfun$read$16(x0$1))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int partitionId = tuple2._1$mcI$sp();
                CelebornInputStream inputStream = (CelebornInputStream)tuple2._2();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)serializerInstance.deserializeStream((InputStream)inputStream).asKeyValueIterator());
            }
            throw new MatchError((Object)tuple2);
        }).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                Iterator iterator;
                int partitionId = tuple2._1$mcI$sp();
                Iterator iter = (Iterator)tuple2._2();
                try {
                    iterator = iter;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof CelebornIOException ? true : throwable2 instanceof PartitionUnRetryAbleException) {
                        throw this.handleFetchExceptions($this.handle.shuffleId(), shuffleId, partitionId, throwable2);
                    }
                    throw throwable;
                }
                return iterator;
            }
            throw new MatchError((Object)tuple2);
        });
        Iterator iterWithUpdatedRecordsRead = recordIter.map((Function1 & Serializable & scala.Serializable)record -> {
            $this.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics.incRecordsRead(1L);
            return record;
        });
        CompletionIterator metricIter = CompletionIterator$.MODULE$.apply(iterWithUpdatedRecordsRead, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.context.taskMetrics().mergeShuffleReadMetrics());
        InterruptibleIterator interruptibleIter = new InterruptibleIterator(this.context, (Iterator)metricIter);
        if (this.dep().keyOrdering().isDefined()) {
            ExternalSorter externalSorter;
            if (this.dep().aggregator().isDefined()) {
                if (this.dep().mapSideCombine()) {
                    TaskContext x$1 = this.context;
                    Option x$2 = Option$.MODULE$.apply((Object)new Aggregator((Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x), ((Aggregator)this.dep().aggregator().get()).mergeCombiners(), ((Aggregator)this.dep().aggregator().get()).mergeCombiners()));
                    Some x$32 = new Some(this.dep().keyOrdering().get());
                    Serializer x$4 = this.dep().serializer();
                    Option x$5 = ExternalSorter$.MODULE$.$lessinit$greater$default$3();
                    externalSorter = new ExternalSorter(x$1, x$2, x$5, (Option)x$32, x$4);
                } else {
                    TaskContext x$6 = this.context;
                    Option x$7 = this.dep().aggregator();
                    Some x$8 = new Some(this.dep().keyOrdering().get());
                    Serializer x$9 = this.dep().serializer();
                    Option x$10 = ExternalSorter$.MODULE$.$lessinit$greater$default$3();
                    externalSorter = new ExternalSorter(x$6, x$7, x$10, (Option)x$8, x$9);
                }
            } else {
                TaskContext x$11 = this.context;
                Some x$12 = new Some(this.dep().keyOrdering().get());
                Serializer x$13 = this.dep().serializer();
                None$ x$14 = ExternalSorter$.MODULE$.$lessinit$greater$default$2();
                Option x$15 = ExternalSorter$.MODULE$.$lessinit$greater$default$3();
                externalSorter = new ExternalSorter(x$11, (Option)x$14, x$15, (Option)x$12, x$13);
            }
            ExternalSorter sorter = externalSorter;
            sorter.insertAll((Iterator)interruptibleIter);
            this.context.taskMetrics().incMemoryBytesSpilled(sorter.memoryBytesSpilled());
            this.context.taskMetrics().incDiskBytesSpilled(sorter.diskBytesSpilled());
            this.context.taskMetrics().incPeakExecutionMemory(sorter.peakMemoryUsedBytes());
            this.context.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$3 -> {
                sorter.stop();
                return BoxedUnit.UNIT;
            });
            interruptibleIterator = CompletionIterator$.MODULE$.apply(sorter.iterator(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> sorter.stop());
        } else if (this.dep().aggregator().isDefined()) {
            if (this.dep().mapSideCombine()) {
                InterruptibleIterator combinedKeyValuesIterator = interruptibleIter;
                interruptibleIterator = ((Aggregator)this.dep().aggregator().get()).combineCombinersByKey((Iterator)combinedKeyValuesIterator, this.context);
            } else {
                InterruptibleIterator keyValuesIterator = interruptibleIter;
                interruptibleIterator = ((Aggregator)this.dep().aggregator().get()).combineValuesByKey((Iterator)keyValuesIterator, this.context);
            }
        } else {
            interruptibleIterator = interruptibleIter;
        }
        InterruptibleIterator interruptibleIterator2 = resultIter = interruptibleIterator;
        if (interruptibleIterator2 instanceof InterruptibleIterator) {
            return resultIter;
        }
        return new InterruptibleIterator(this.context, (Iterator)resultIter);
    }

    private Nothing$ handleFetchExceptions(int appShuffleId, int shuffleId, int partitionId, Throwable ce) {
        if (this.throwsFetchFailure() && this.shuffleClient().reportShuffleFetchFailure(appShuffleId, shuffleId)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Handle fetch exceptions for ").append(shuffleId).append("-").append(partitionId).toString(), ce);
            throw new FetchFailedException(null, appShuffleId, -1L, -1, partitionId, new StringBuilder(47).append("Celeborn FetchFailure appShuffleId/shuffleId: ").append(appShuffleId).append("/").append(shuffleId).toString(), ce);
        }
        throw ce;
    }

    public SerializerInstance newSerializerInstance(ShuffleDependency<K, ?, C> dep) {
        return dep.serializer().newInstance();
    }

    public final void org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$createInputStream$1(int partitionId, ObjectRef fileGroups$1, ConcurrentHashMap locationStreamHandlerMap$1, int shuffleId$1, MetricsCallback metricsCallback$1, ConcurrentHashMap streams$1) {
        ArrayList<PbStreamHandler> streamHandlers;
        ArrayList<PbStreamHandler> arrayList;
        ArrayList<PartitionLocation> locations;
        ArrayList<PartitionLocation> arrayList2 = locations = ((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).partitionGroups.containsKey(BoxesRunTime.boxToInteger((int)partitionId)) ? new ArrayList<PartitionLocation>((Collection)((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).partitionGroups.get(BoxesRunTime.boxToInteger((int)partitionId))) : new ArrayList();
        if (locations != null) {
            ArrayList<PbStreamHandler> streamHandlerArr = new ArrayList<PbStreamHandler>(locations.size());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(locations).asScala()).foreach((Function1 & Serializable & scala.Serializable)loc -> BoxesRunTime.boxToBoolean((boolean)streamHandlerArr.add(locationStreamHandlerMap$1.get(loc))));
            arrayList = streamHandlerArr;
        } else {
            arrayList = streamHandlers = null;
        }
        if (this.exceptionRef().get() == null) {
            try {
                CelebornInputStream inputStream = this.shuffleClient().readPartition(shuffleId$1, this.handle.shuffleId(), partitionId, this.encodedAttemptId(), this.startMapIndex, this.endMapIndex, this.throwsFetchFailure() ? ExceptionMakerHelper$.MODULE$.SHUFFLE_FETCH_FAILURE_EXCEPTION_MAKER() : null, locations, streamHandlers, ((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).mapAttempts, metricsCallback$1);
                streams$1.put(Predef$.MODULE$.int2Integer(partitionId), inputStream);
            }
            catch (IOException e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Exception caught when readPartition ").append(partitionId).append("!").toString(), e);
                this.exceptionRef().compareAndSet(null, e);
            }
            catch (Throwable e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Non IOException caught when readPartition ").append(partitionId).append("!").toString(), e);
                this.exceptionRef().compareAndSet(null, new CelebornIOException(e));
            }
            return;
        }
    }

    public static final /* synthetic */ Future $anonfun$read$12(CelebornShuffleReader $this, ObjectRef fileGroups$1, ConcurrentHashMap locationStreamHandlerMap$1, int shuffleId$1, MetricsCallback metricsCallback$1, ConcurrentHashMap streams$1, int partitionId) {
        return CelebornShuffleReader$.MODULE$.streamCreatorPool().submit(new Runnable($this, partitionId, fileGroups$1, locationStreamHandlerMap$1, shuffleId$1, metricsCallback$1, streams$1){
            private final /* synthetic */ CelebornShuffleReader $outer;
            private final int partitionId$3;
            private final ObjectRef fileGroups$1;
            private final ConcurrentHashMap locationStreamHandlerMap$1;
            private final int shuffleId$1;
            private final MetricsCallback metricsCallback$1;
            private final ConcurrentHashMap streams$1;

            public void run() {
                this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$createInputStream$1(this.partitionId$3, this.fileGroups$1, this.locationStreamHandlerMap$1, this.shuffleId$1, this.metricsCallback$1, this.streams$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionId$3 = partitionId$3;
                this.fileGroups$1 = fileGroups$1;
                this.locationStreamHandlerMap$1 = locationStreamHandlerMap$1;
                this.shuffleId$1 = shuffleId$1;
                this.metricsCallback$1 = metricsCallback$1;
                this.streams$1 = streams$1;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$read$15(ObjectRef inputStream$1, TaskContext x$2) {
        ((CelebornInputStream)inputStream$1.elem).close();
    }

    public static final /* synthetic */ Tuple2 $anonfun$read$13(CelebornShuffleReader $this, ConcurrentHashMap streams$1, int shuffleId$1, MetricsCallback metricsCallback$1, int inputStreamCreationWindow$1, ObjectRef fileGroups$1, ConcurrentHashMap locationStreamHandlerMap$1, int partitionId) {
        if ($this.handle.numMappers() > 0) {
            long startFetchWait = System.nanoTime();
            ObjectRef inputStream = ObjectRef.create((Object)((CelebornInputStream)streams$1.get(BoxesRunTime.boxToInteger((int)partitionId))));
            while ((CelebornInputStream)inputStream.elem == null) {
                if ($this.exceptionRef().get() != null) {
                    IOException iOException = $this.exceptionRef().get();
                    if (iOException instanceof CelebornIOException ? true : iOException instanceof PartitionUnRetryAbleException) {
                        throw $this.handleFetchExceptions($this.handle.shuffleId(), shuffleId$1, partitionId, iOException);
                    }
                    throw iOException;
                }
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "inputStream is null, sleeping...");
                Thread.sleep(50L);
                inputStream.elem = (CelebornInputStream)streams$1.get(BoxesRunTime.boxToInteger((int)partitionId));
            }
            metricsCallback$1.incReadTime(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startFetchWait));
            $this.context.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$2 -> {
                CelebornShuffleReader.$anonfun$read$15(inputStream, x$2);
                return BoxedUnit.UNIT;
            });
            Object object = partitionId + inputStreamCreationWindow$1 < $this.endPartition ? CelebornShuffleReader$.MODULE$.streamCreatorPool().submit(new Runnable($this, partitionId, inputStreamCreationWindow$1, fileGroups$1, locationStreamHandlerMap$1, shuffleId$1, metricsCallback$1, streams$1){
                private final /* synthetic */ CelebornShuffleReader $outer;
                private final int partitionId$4;
                private final int inputStreamCreationWindow$1;
                private final ObjectRef fileGroups$1;
                private final ConcurrentHashMap locationStreamHandlerMap$1;
                private final int shuffleId$1;
                private final MetricsCallback metricsCallback$1;
                private final ConcurrentHashMap streams$1;

                public void run() {
                    this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$createInputStream$1(this.partitionId$4 + this.inputStreamCreationWindow$1, this.fileGroups$1, this.locationStreamHandlerMap$1, this.shuffleId$1, this.metricsCallback$1, this.streams$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partitionId$4 = partitionId$4;
                    this.inputStreamCreationWindow$1 = inputStreamCreationWindow$1;
                    this.fileGroups$1 = fileGroups$1;
                    this.locationStreamHandlerMap$1 = locationStreamHandlerMap$1;
                    this.shuffleId$1 = shuffleId$1;
                    this.metricsCallback$1 = metricsCallback$1;
                    this.streams$1 = streams$1;
                }
            }) : BoxedUnit.UNIT;
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)((CelebornInputStream)inputStream.elem));
        }
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)CelebornInputStream.empty());
    }

    public static final /* synthetic */ boolean $anonfun$read$16(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            CelebornInputStream inputStream;
            CelebornInputStream celebornInputStream = inputStream = (CelebornInputStream)tuple2._2();
            CelebornInputStream celebornInputStream2 = CelebornInputStream.empty();
            return celebornInputStream == null ? celebornInputStream2 != null : !celebornInputStream.equals(celebornInputStream2);
        }
        throw new MatchError((Object)tuple2);
    }

    public CelebornShuffleReader(CelebornShuffleHandle<K, ?, C> handle, int startPartition, int endPartition, int startMapIndex, int endMapIndex, TaskContext context, CelebornConf conf, ShuffleReadMetricsReporter metrics, ExecutorShuffleIdTracker shuffleIdTracker) {
        this.handle = handle;
        this.startPartition = startPartition;
        this.endPartition = endPartition;
        this.startMapIndex = startMapIndex;
        this.endMapIndex = endMapIndex;
        this.context = context;
        this.conf = conf;
        this.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics = metrics;
        this.shuffleIdTracker = shuffleIdTracker;
        Logging.$init$((Logging)this);
        this.dep = handle.dependency();
        this.shuffleClient = ShuffleClient.get(handle.appUniqueId(), handle.lifecycleManagerHost(), handle.lifecycleManagerPort(), conf, handle.userIdentifier(), handle.extension());
        this.exceptionRef = new AtomicReference();
        this.throwsFetchFailure = handle.throwsFetchFailure();
        this.encodedAttemptId = SparkCommonUtils.getEncodedAttemptNumber(context);
    }
}

