/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import junit.framework.TestCase;
import org.apache.commons.beanutils.BeanPropertyValueEqualsPredicate;
import org.apache.commons.beanutils.TestBean;

public class BeanPropertyValueEqualsPredicateTestCase
extends TestCase {
    private static final Integer expectedIntegerValue = 123;
    private static final Float expectedFloatValue = Float.valueOf(123.123f);
    private static final Double expectedDoubleValue = 567879.12344;
    private static final Boolean expectedBooleanValue = Boolean.TRUE;
    private static final Byte expectedByteValue = Byte.valueOf("12");

    public BeanPropertyValueEqualsPredicateTestCase(String name) {
        super(name);
    }

    public void testEvaluateWithBooleanProperty() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("booleanProperty", (Object)expectedBooleanValue);
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((boolean)predicate.evaluate((Object)new TestBean((boolean)expectedBooleanValue)));
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((!predicate.evaluate((Object)new TestBean(expectedBooleanValue == false)) ? 1 : 0) != 0);
    }

    public void testEvaluateWithByteProperty() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("byteProperty", (Object)expectedByteValue);
        TestBean testBean = new TestBean();
        testBean.setByteProperty(expectedByteValue);
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((boolean)predicate.evaluate((Object)testBean));
        testBean.setByteProperty((byte)(expectedByteValue - 1));
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((!predicate.evaluate((Object)testBean) ? 1 : 0) != 0);
    }

    public void testEvaluateWithDoubleProperty() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("doubleProperty", (Object)expectedDoubleValue);
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((boolean)predicate.evaluate((Object)new TestBean(expectedDoubleValue)));
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((!predicate.evaluate((Object)new TestBean(expectedDoubleValue - 1.0)) ? 1 : 0) != 0);
    }

    public void testEvaluateWithFloatProperty() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("floatProperty", (Object)expectedFloatValue);
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((boolean)predicate.evaluate((Object)new TestBean(expectedFloatValue.floatValue())));
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((!predicate.evaluate((Object)new TestBean(expectedFloatValue.floatValue() - 1.0f)) ? 1 : 0) != 0);
    }

    public void testEvaluateWithIndexedProperty() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("intIndexed[0]", (Object)expectedIntegerValue);
        TestBean testBean = new TestBean();
        testBean.setIntIndexed(0, expectedIntegerValue);
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((boolean)predicate.evaluate((Object)testBean));
        testBean.setIntIndexed(0, expectedIntegerValue - 1);
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((!predicate.evaluate((Object)testBean) ? 1 : 0) != 0);
        predicate = new BeanPropertyValueEqualsPredicate("intIndexed[999]", (Object)"exception-ahead");
        try {
            BeanPropertyValueEqualsPredicateTestCase.assertTrue((!predicate.evaluate((Object)testBean) ? 1 : 0) != 0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testEvaluateWithIntProperty() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("intProperty", (Object)expectedIntegerValue);
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((boolean)predicate.evaluate((Object)new TestBean((int)expectedIntegerValue)));
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((!predicate.evaluate((Object)new TestBean(expectedIntegerValue - 1)) ? 1 : 0) != 0);
    }

    public void testEvaluateWithInvalidPropertyName() {
        try {
            new BeanPropertyValueEqualsPredicate("bogusProperty", null).evaluate((Object)new TestBean());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEvaluateWithMappedProperty() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("mappedProperty(test-key)", (Object)"match");
        TestBean testBean = new TestBean();
        testBean.setMappedProperty("test-key", "match");
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((boolean)predicate.evaluate((Object)testBean));
        testBean.setMappedProperty("test-key", "no-match");
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((!predicate.evaluate((Object)testBean) ? 1 : 0) != 0);
        predicate = new BeanPropertyValueEqualsPredicate("mappedProperty(invalid-key)", (Object)"match");
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((!predicate.evaluate((Object)testBean) ? 1 : 0) != 0);
    }

    public void testEvaluateWithNestedMappedProperty() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("anotherNested.mappedProperty(test-key)", (Object)"match");
        TestBean testBean = new TestBean();
        TestBean nestedBean = new TestBean();
        nestedBean.setMappedProperty("test-key", "match");
        testBean.setAnotherNested(nestedBean);
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((boolean)predicate.evaluate((Object)testBean));
        nestedBean.setMappedProperty("test-key", "no-match");
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((!predicate.evaluate((Object)testBean) ? 1 : 0) != 0);
    }

    public void testEvaluateWithNestedProperty() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("anotherNested.stringProperty", (Object)"match");
        TestBean testBean = new TestBean();
        TestBean nestedBean = new TestBean("match");
        testBean.setAnotherNested(nestedBean);
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((boolean)predicate.evaluate((Object)testBean));
        testBean.setAnotherNested(new TestBean("no-match"));
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((!predicate.evaluate((Object)testBean) ? 1 : 0) != 0);
    }

    public void testEvaluateWithNullInPath() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("anotherNested.stringProperty", (Object)"foo");
        try {
            predicate.evaluate((Object)new TestBean());
            BeanPropertyValueEqualsPredicateTestCase.fail((String)"Should have throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEvaluateWithNullInPathAndIgnoreTrue() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("anotherNested.stringProperty", (Object)"foo", true);
        try {
            BeanPropertyValueEqualsPredicateTestCase.assertTrue((!predicate.evaluate((Object)new TestBean()) ? 1 : 0) != 0);
        }
        catch (IllegalArgumentException e) {
            BeanPropertyValueEqualsPredicateTestCase.fail((String)"Should not have throw IllegalArgumentException");
        }
    }

    public void testEvaluateWithPrimitiveAndNull() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("intProperty", null);
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((!predicate.evaluate((Object)new TestBean(0)) ? 1 : 0) != 0);
        predicate = new BeanPropertyValueEqualsPredicate("booleanProperty", null);
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((!predicate.evaluate((Object)new TestBean(true)) ? 1 : 0) != 0);
        predicate = new BeanPropertyValueEqualsPredicate("floatProperty", null);
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((!predicate.evaluate((Object)new TestBean(expectedFloatValue.floatValue())) ? 1 : 0) != 0);
    }

    public void testEvaluateWithReadOnlyProperty() {
        TestBean testBean = new TestBean();
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("readOnlyProperty", (Object)testBean.getReadOnlyProperty());
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((boolean)predicate.evaluate((Object)new TestBean()));
    }

    public void testEvaluateWithSimpleStringProperty() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("stringProperty", (Object)"foo");
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((boolean)predicate.evaluate((Object)new TestBean("foo")));
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((!predicate.evaluate((Object)new TestBean("bar")) ? 1 : 0) != 0);
    }

    public void testEvaluateWithSimpleStringPropertyWithNullValues() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("stringProperty", null);
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((boolean)predicate.evaluate((Object)new TestBean((String)null)));
        BeanPropertyValueEqualsPredicateTestCase.assertTrue((!predicate.evaluate((Object)new TestBean("bar")) ? 1 : 0) != 0);
    }

    public void testEvaluateWithWriteOnlyProperty() {
        try {
            new BeanPropertyValueEqualsPredicate("writeOnlyProperty", null).evaluate((Object)new TestBean());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

