/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ProxyOutputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ProxyOutputStreamTest {
    private ByteArrayOutputStream target;
    private ProxyOutputStream proxied;
    private final AtomicBoolean hitByteArray = new AtomicBoolean();
    private final AtomicBoolean hitByteArrayAt = new AtomicBoolean();
    private final AtomicBoolean hitInt = new AtomicBoolean();

    ProxyOutputStreamTest() {
    }

    @BeforeEach
    public void setUp() {
        this.target = new ByteArrayOutputStream(){

            public void write(byte[] ba) {
                ProxyOutputStreamTest.this.hitByteArray.set(true);
                super.write(ba);
            }

            public void write(byte[] b, int off, int len) {
                ProxyOutputStreamTest.this.hitByteArrayAt.set(true);
                super.write(b, off, len);
            }

            public synchronized void write(int ba) {
                ProxyOutputStreamTest.this.hitInt.set(true);
                super.write(ba);
            }
        };
        this.proxied = new ProxyOutputStream((OutputStream)this.target);
    }

    @Test
    void testBuilder() throws Exception {
        Assertions.assertSame((Object)this.target, (Object)((ProxyOutputStream.Builder)new ProxyOutputStream.Builder().setOutputStream((OutputStream)this.target)).get().unwrap());
    }

    @Test
    void testSetReference() throws Exception {
        Assertions.assertFalse((boolean)this.hitByteArray.get());
        this.proxied.setReference((OutputStream)new ByteArrayOutputStream());
        this.proxied.write(121);
        Assertions.assertFalse((boolean)this.hitByteArray.get());
        Assertions.assertEquals((int)0, (int)this.target.size());
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])this.target.toByteArray());
    }

    @Test
    void testWriteByteArray() throws Exception {
        Assertions.assertFalse((boolean)this.hitByteArray.get());
        this.proxied.write(new byte[]{121, 122});
        Assertions.assertTrue((boolean)this.hitByteArray.get());
        Assertions.assertEquals((int)2, (int)this.target.size());
        Assertions.assertArrayEquals((byte[])new byte[]{121, 122}, (byte[])this.target.toByteArray());
    }

    @Test
    void testWriteByteArrayAt() throws Exception {
        Assertions.assertFalse((boolean)this.hitByteArrayAt.get());
        this.proxied.write(new byte[]{121, 122}, 1, 1);
        Assertions.assertTrue((boolean)this.hitByteArrayAt.get());
        Assertions.assertEquals((int)1, (int)this.target.size());
        Assertions.assertArrayEquals((byte[])new byte[]{122}, (byte[])this.target.toByteArray());
    }

    @Test
    void testWriteByteArrayAtRepeat() throws Exception {
        this.proxied.writeRepeat(new byte[]{121, 122}, 1, 1, 0L);
        Assertions.assertFalse((boolean)this.hitByteArrayAt.get());
        this.hitByteArray.set(false);
        Assertions.assertEquals((int)0, (int)this.target.size());
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])this.target.toByteArray());
        this.proxied.writeRepeat(new byte[]{121, 122}, 1, 1, 0L);
        Assertions.assertFalse((boolean)this.hitByteArrayAt.get());
        this.hitByteArray.set(false);
        Assertions.assertEquals((int)0, (int)this.target.size());
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])this.target.toByteArray());
        this.proxied.writeRepeat(new byte[]{121, 122}, 1, 1, 1L);
        Assertions.assertTrue((boolean)this.hitByteArrayAt.get());
        this.hitByteArray.set(false);
        Assertions.assertEquals((int)1, (int)this.target.size());
        Assertions.assertArrayEquals((byte[])new byte[]{122}, (byte[])this.target.toByteArray());
        this.proxied.writeRepeat(new byte[]{121, 120}, 1, 1, 2L);
        Assertions.assertTrue((boolean)this.hitByteArrayAt.get());
        Assertions.assertEquals((int)3, (int)this.target.size());
        Assertions.assertArrayEquals((byte[])new byte[]{122, 120, 120}, (byte[])this.target.toByteArray());
    }

    @Test
    void testWriteByteArrayRepeat() throws Exception {
        this.proxied.writeRepeat(new byte[]{121, 122}, -1L);
        Assertions.assertFalse((boolean)this.hitByteArray.get());
        this.hitByteArray.set(false);
        Assertions.assertEquals((int)0, (int)this.target.size());
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])this.target.toByteArray());
        this.proxied.writeRepeat(new byte[]{121, 122}, 0L);
        Assertions.assertFalse((boolean)this.hitByteArray.get());
        this.hitByteArray.set(false);
        Assertions.assertEquals((int)0, (int)this.target.size());
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])this.target.toByteArray());
        this.proxied.writeRepeat(new byte[]{121, 122}, 1L);
        Assertions.assertTrue((boolean)this.hitByteArray.get());
        this.hitByteArray.set(false);
        Assertions.assertEquals((int)2, (int)this.target.size());
        Assertions.assertArrayEquals((byte[])new byte[]{121, 122}, (byte[])this.target.toByteArray());
        this.proxied.writeRepeat(new byte[]{121, 122}, 2L);
        Assertions.assertTrue((boolean)this.hitByteArray.get());
        Assertions.assertEquals((int)6, (int)this.target.size());
        Assertions.assertArrayEquals((byte[])new byte[]{121, 122, 121, 122, 121, 122}, (byte[])this.target.toByteArray());
    }

    @Test
    void testWriteInt() throws Exception {
        Assertions.assertFalse((boolean)this.hitInt.get());
        this.proxied.write(121);
        Assertions.assertTrue((boolean)this.hitInt.get());
        Assertions.assertEquals((int)1, (int)this.target.size());
        Assertions.assertEquals((int)121, (int)this.target.toByteArray()[0]);
    }

    @Test
    void testWriteIntRepeat() throws Exception {
        Assertions.assertFalse((boolean)this.hitInt.get());
        this.proxied.writeRepeat(121, -1L);
        Assertions.assertFalse((boolean)this.hitInt.get());
        Assertions.assertEquals((int)0, (int)this.target.size());
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])this.target.toByteArray());
        Assertions.assertFalse((boolean)this.hitInt.get());
        this.proxied.writeRepeat(121, 0L);
        Assertions.assertFalse((boolean)this.hitInt.get());
        Assertions.assertEquals((int)0, (int)this.target.size());
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])this.target.toByteArray());
        Assertions.assertFalse((boolean)this.hitInt.get());
        this.proxied.writeRepeat(121, 1L);
        Assertions.assertTrue((boolean)this.hitInt.get());
        this.hitInt.set(false);
        Assertions.assertEquals((int)1, (int)this.target.size());
        Assertions.assertArrayEquals((byte[])new byte[]{121}, (byte[])this.target.toByteArray());
        Assertions.assertFalse((boolean)this.hitInt.get());
        this.proxied.writeRepeat(122, 2L);
        Assertions.assertTrue((boolean)this.hitInt.get());
        this.hitInt.set(false);
        Assertions.assertEquals((int)3, (int)this.target.size());
        Assertions.assertArrayEquals((byte[])new byte[]{121, 122, 122}, (byte[])this.target.toByteArray());
    }

    @Test
    void testWriteNullArrayProxiesToUnderlying() throws Exception {
        Assertions.assertFalse((boolean)this.hitByteArray.get());
        byte[] ba = null;
        Assertions.assertThrows(NullPointerException.class, () -> this.target.write(ba));
        Assertions.assertTrue((boolean)this.hitByteArray.get());
        Assertions.assertThrows(NullPointerException.class, () -> this.proxied.write(ba));
        Assertions.assertTrue((boolean)this.hitByteArray.get());
    }
}

