/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import org.apache.hadoop.security.GroupMappingServiceProvider;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * Group Mapping class used for test cases. Returns only primary group of the
 * given user
 */
public class PrimaryGroupMapping implements GroupMappingServiceProvider {

  @Override
  public List<String> getGroups(String user) {
    return Arrays.asList(user + "group");
  }

  @Override
  public void cacheGroupsRefresh() throws IOException {
    throw new UnsupportedOperationException();
  }

  @Override
  public void cacheGroupsAdd(List<String> groups) throws IOException {
    throw new UnsupportedOperationException();
  }

  @Override
  public Set<String> getGroupsSet(String user) throws IOException {
    return Collections.singleton(user + "group");
  }
}
