/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.resources.helix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.rest.common.HelixDataAccessorWrapper;
import org.apache.helix.rest.server.json.cluster.ClusterTopology;
import org.apache.helix.rest.server.json.instance.StoppableCheck;
import org.apache.helix.rest.server.resources.AbstractResource;
import org.apache.helix.rest.server.resources.exceptions.HelixHealthException;
import org.apache.helix.rest.server.resources.helix.AbstractHelixResource;
import org.apache.helix.rest.server.service.ClusterServiceImpl;
import org.apache.helix.rest.server.service.InstanceServiceImpl;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.type.JavaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/clusters/{clusterId}/instances")
public class InstancesAccessor
extends AbstractHelixResource {
    private static final Logger _logger = LoggerFactory.getLogger(InstancesAccessor.class);
    private static final String INSTANCE_NOT_EXIST = "Helix:INSTANCE_NOT_EXIST";

    @GET
    public Response getAllInstances(@PathParam(value="clusterId") String clusterId) {
        HelixDataAccessor accessor = this.getDataAccssor(clusterId);
        List instances = accessor.getChildNames(accessor.keyBuilder().instanceConfigs());
        if (instances == null) {
            return this.notFound();
        }
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        root.put(AbstractResource.Properties.id.name(), (JsonNode)JsonNodeFactory.instance.textNode(clusterId));
        ArrayNode instancesNode = root.putArray(InstancesProperties.instances.name());
        instancesNode.addAll((ArrayNode)OBJECT_MAPPER.valueToTree((Object)instances));
        ArrayNode onlineNode = root.putArray(InstancesProperties.online.name());
        ArrayNode disabledNode = root.putArray(InstancesProperties.disabled.name());
        List liveInstances = accessor.getChildNames(accessor.keyBuilder().liveInstances());
        ClusterConfig clusterConfig = (ClusterConfig)accessor.getProperty(accessor.keyBuilder().clusterConfig());
        for (String instanceName : instances) {
            InstanceConfig instanceConfig = (InstanceConfig)accessor.getProperty(accessor.keyBuilder().instanceConfig(instanceName));
            if (instanceConfig == null) continue;
            if (!instanceConfig.getInstanceEnabled() || clusterConfig.getDisabledInstances() != null && clusterConfig.getDisabledInstances().containsKey(instanceName)) {
                disabledNode.add((JsonNode)JsonNodeFactory.instance.textNode(instanceName));
            }
            if (!liveInstances.contains(instanceName)) continue;
            onlineNode.add((JsonNode)JsonNodeFactory.instance.textNode(instanceName));
        }
        return this.JSONRepresentation(root);
    }

    @POST
    public Response instancesOperations(@PathParam(value="clusterId") String clusterId, @QueryParam(value="command") String command, String content) {
        AbstractResource.Command cmd;
        try {
            cmd = AbstractResource.Command.valueOf(command);
        }
        catch (Exception e) {
            return this.badRequest("Invalid command : " + command);
        }
        HelixAdmin admin = this.getHelixAdmin();
        try {
            JsonNode node = null;
            if (content.length() != 0) {
                node = OBJECT_MAPPER.readTree(content);
            }
            if (node == null) {
                return this.badRequest("Invalid input for content : " + content);
            }
            List enableInstances = (List)OBJECT_MAPPER.readValue(node.get(InstancesProperties.instances.name()).toString(), (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, String.class));
            switch (cmd) {
                case enable: {
                    admin.enableInstance(clusterId, enableInstances, true);
                    break;
                }
                case disable: {
                    admin.enableInstance(clusterId, enableInstances, false);
                    break;
                }
                case stoppable: {
                    return this.batchGetStoppableInstances(clusterId, node);
                }
                default: {
                    _logger.error("Unsupported command :" + command);
                    return this.badRequest("Unsupported command :" + command);
                }
            }
        }
        catch (HelixHealthException e) {
            _logger.error(String.format("Current cluster %s has issue with health checks!", clusterId), (Throwable)e);
            return this.serverError(e);
        }
        catch (Exception e) {
            _logger.error("Failed in updating instances : " + content, (Throwable)e);
            return this.badRequest(e.getMessage());
        }
        return this.OK();
    }

    private Response batchGetStoppableInstances(String clusterId, JsonNode node) throws IOException {
        try {
            InstanceHealthSelectionBase selectionBase = InstanceHealthSelectionBase.valueOf(node.get(InstancesProperties.selection_base.name()).getValueAsText());
            List instances = (List)OBJECT_MAPPER.readValue(node.get(InstancesProperties.instances.name()).toString(), (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, String.class));
            List orderOfZone = null;
            String customizedInput = null;
            if (node.get(InstancesProperties.customized_values.name()) != null) {
                customizedInput = node.get(InstancesProperties.customized_values.name()).getTextValue();
            }
            if (node.get(InstancesProperties.zone_order.name()) != null) {
                orderOfZone = (List)OBJECT_MAPPER.readValue(node.get(InstancesProperties.zone_order.name()).toString(), (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, String.class));
            }
            ObjectNode result = JsonNodeFactory.instance.objectNode();
            ArrayNode stoppableInstances = result.putArray(InstancesProperties.instance_stoppable_parallel.name());
            ObjectNode failedStoppableInstances = result.putObject(InstancesProperties.instance_not_stoppable_with_reasons.name());
            InstanceServiceImpl instanceService = new InstanceServiceImpl(new HelixDataAccessorWrapper((ZKHelixDataAccessor)this.getDataAccssor(clusterId)), this.getConfigAccessor());
            ClusterServiceImpl clusterService = new ClusterServiceImpl(this.getDataAccssor(clusterId), this.getConfigAccessor());
            ClusterTopology clusterTopology = clusterService.getClusterTopology(clusterId);
            switch (selectionBase) {
                case zone_based: {
                    List<String> zoneBasedInstance = this.getZoneBasedInstances(instances, orderOfZone, clusterTopology.toZoneMapping());
                    Map<String, StoppableCheck> instancesStoppableChecks = instanceService.batchGetInstancesStoppableChecks(clusterId, zoneBasedInstance, customizedInput);
                    for (Map.Entry<String, StoppableCheck> instanceStoppableCheck : instancesStoppableChecks.entrySet()) {
                        String instance = instanceStoppableCheck.getKey();
                        StoppableCheck stoppableCheck = instanceStoppableCheck.getValue();
                        if (!stoppableCheck.isStoppable()) {
                            ArrayNode failedReasonsNode = failedStoppableInstances.putArray(instance);
                            for (String failedReason : stoppableCheck.getFailedChecks()) {
                                failedReasonsNode.add((JsonNode)JsonNodeFactory.instance.textNode(failedReason));
                            }
                            continue;
                        }
                        stoppableInstances.add(instance);
                    }
                    HashSet nonSelectedInstances = new HashSet(instances);
                    nonSelectedInstances.removeAll(clusterTopology.getAllInstances());
                    for (String nonSelectedInstance : nonSelectedInstances) {
                        ArrayNode failedReasonsNode = failedStoppableInstances.putArray(nonSelectedInstance);
                        failedReasonsNode.add((JsonNode)JsonNodeFactory.instance.textNode(INSTANCE_NOT_EXIST));
                    }
                    break;
                }
                default: {
                    throw new NotImplementedException("instance_based selection is not supported yet!");
                }
            }
            return this.JSONRepresentation(result);
        }
        catch (HelixException e) {
            _logger.error(String.format("Current cluster %s has issue with health checks!", clusterId), (Throwable)e);
            throw new HelixHealthException(e);
        }
        catch (Exception e) {
            _logger.error(String.format("Failed to get parallel stoppable instances for cluster %s with a HelixException!", clusterId), (Throwable)e);
            throw e;
        }
    }

    private List<String> getZoneBasedInstances(List<String> instances, List<String> orderedZones, Map<String, Set<String>> zoneMapping) {
        if (orderedZones == null) {
            orderedZones = new ArrayList<String>(zoneMapping.keySet());
        }
        Collections.sort(orderedZones);
        if (orderedZones.isEmpty()) {
            return orderedZones;
        }
        TreeSet<String> instanceSet = null;
        for (String zone : orderedZones) {
            instanceSet = new TreeSet<String>(instances);
            HashSet currentZoneInstanceSet = new HashSet(zoneMapping.get(zone));
            instanceSet.retainAll(currentZoneInstanceSet);
            if (instanceSet.size() <= 0) continue;
            return new ArrayList<String>(instanceSet);
        }
        return Collections.EMPTY_LIST;
    }

    public static enum InstanceHealthSelectionBase {
        instance_based,
        zone_based;

    }

    public static enum InstancesProperties {
        instances,
        online,
        disabled,
        selection_base,
        zone_order,
        customized_values,
        instance_stoppable_parallel,
        instance_not_stoppable_with_reasons;

    }
}

