/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.ZNRecord;
import org.apache.helix.api.config.StateTransitionThrottleConfig;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.AbstractRebalancer;
import org.apache.helix.controller.rebalancer.util.RebalanceScheduler;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedAutoRebalancer
extends AbstractRebalancer<ResourceControllerDataProvider> {
    private static final Logger LOG = LoggerFactory.getLogger(DelayedAutoRebalancer.class);
    private static RebalanceScheduler _rebalanceScheduler = new RebalanceScheduler();

    @Override
    public IdealState computeNewIdealState(String resourceName, IdealState currentIdealState, CurrentStateOutput currentStateOutput, ResourceControllerDataProvider clusterData) {
        ZNRecord newIdealMapping;
        Set<String> allNodes;
        Set<String> liveEnabledNodes;
        String instanceTag;
        IdealState cachedIdealState = this.getCachedIdealState(resourceName, clusterData);
        if (cachedIdealState != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Use cached IdealState for " + resourceName);
            }
            return cachedIdealState;
        }
        LOG.info("Computing IdealState for " + resourceName);
        ArrayList<String> allPartitions = new ArrayList<String>(currentIdealState.getPartitionSet());
        if (allPartitions.size() == 0) {
            LOG.info("Partition count is 0 for resource " + resourceName + ", stop calculate ideal mapping for the resource.");
            return this.generateNewIdealState(resourceName, currentIdealState, this.emptyMapping(currentIdealState));
        }
        Map<Object, Object> userDefinedPreferenceList = new HashMap();
        ClusterConfig clusterConfig = clusterData.getClusterConfig();
        ResourceConfig resourceConfig = clusterData.getResourceConfig(resourceName);
        boolean delayRebalanceEnabled = this.isDelayRebalanceEnabled(currentIdealState, clusterConfig);
        if (resourceConfig != null && !(userDefinedPreferenceList = resourceConfig.getPreferenceLists()).isEmpty()) {
            LOG.info("Using user defined preference list for partitions: " + userDefinedPreferenceList.keySet());
        }
        if ((instanceTag = currentIdealState.getInstanceGroupTag()) != null) {
            liveEnabledNodes = clusterData.getEnabledLiveInstancesWithTag(instanceTag);
            allNodes = clusterData.getInstancesWithTag(instanceTag);
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("Found the following participants with tag %s for %s: instances: %s, liveEnabledInstances: %s", currentIdealState.getInstanceGroupTag(), resourceName, allNodes, liveEnabledNodes));
            }
        } else {
            liveEnabledNodes = clusterData.getEnabledLiveInstances();
            allNodes = clusterData.getAllInstances();
        }
        Set<String> activeNodes = liveEnabledNodes;
        if (delayRebalanceEnabled) {
            long delay = this.getRebalanceDelay(currentIdealState, clusterConfig);
            activeNodes = this.getActiveInstances(allNodes, currentIdealState, liveEnabledNodes, clusterData.getInstanceOfflineTimeMap(), clusterData.getLiveInstances().keySet(), clusterData.getInstanceConfigMap(), delay, clusterConfig);
            HashSet<String> offlineOrDisabledInstances = new HashSet<String>(activeNodes);
            offlineOrDisabledInstances.removeAll(liveEnabledNodes);
            this.setRebalanceScheduler(currentIdealState, offlineOrDisabledInstances, clusterData.getInstanceOfflineTimeMap(), clusterData.getLiveInstances().keySet(), clusterData.getInstanceConfigMap(), delay, clusterConfig);
        }
        if (allNodes.isEmpty() || activeNodes.isEmpty()) {
            LOG.error(String.format("No instances or active instances available for resource %s, allInstances: %s, liveInstances: %s, activeInstances: %s", resourceName, allNodes, liveEnabledNodes, activeNodes));
            return this.generateNewIdealState(resourceName, currentIdealState, this.emptyMapping(currentIdealState));
        }
        StateModelDefinition stateModelDef = clusterData.getStateModelDef(currentIdealState.getStateModelDefRef());
        int replicaCount = currentIdealState.getReplicaCount(activeNodes.size());
        if (replicaCount == 0) {
            LOG.error("Replica count is 0 for resource " + resourceName + ", stop calculate ideal mapping for the resource.");
            return this.generateNewIdealState(resourceName, currentIdealState, this.emptyMapping(currentIdealState));
        }
        LinkedHashMap<String, Integer> stateCountMap = stateModelDef.getStateCountMap(activeNodes.size(), replicaCount);
        Map<String, Map<String, String>> currentMapping = this.currentMapping(currentStateOutput, resourceName, allPartitions, stateCountMap);
        int maxPartition = currentIdealState.getMaxPartitionsPerInstance();
        this._rebalanceStrategy = this.getRebalanceStrategy(currentIdealState.getRebalanceStrategy(), allPartitions, resourceName, stateCountMap, maxPartition);
        ArrayList<String> allNodeList = new ArrayList<String>(allNodes);
        ArrayList<String> liveEnabledNodeList = new ArrayList<String>(liveEnabledNodes);
        Collections.sort(allNodeList);
        Collections.sort(liveEnabledNodeList);
        ZNRecord finalMapping = newIdealMapping = this._rebalanceStrategy.computePartitionAssignment(allNodeList, liveEnabledNodeList, currentMapping, clusterData);
        if (this.isDelayRebalanceEnabled(currentIdealState, clusterConfig)) {
            ArrayList<String> activeNodeList = new ArrayList<String>(activeNodes);
            Collections.sort(activeNodeList);
            int minActiveReplicas = this.getMinActiveReplica(currentIdealState, replicaCount);
            ZNRecord newActiveMapping = this._rebalanceStrategy.computePartitionAssignment(allNodeList, activeNodeList, currentMapping, clusterData);
            finalMapping = this.getFinalDelayedMapping(currentIdealState, newIdealMapping, newActiveMapping, liveEnabledNodes, replicaCount, minActiveReplicas);
        }
        finalMapping.getListFields().putAll(userDefinedPreferenceList);
        if (LOG.isDebugEnabled()) {
            LOG.debug("currentMapping: " + currentMapping);
            LOG.debug("stateCountMap: " + stateCountMap);
            LOG.debug("liveEnabledNodes: " + liveEnabledNodes);
            LOG.debug("activeNodes: " + activeNodes);
            LOG.debug("allNodes: " + allNodes);
            LOG.debug("maxPartition: " + maxPartition);
            LOG.debug("newIdealMapping: " + newIdealMapping);
            LOG.debug("finalMapping: " + finalMapping);
        }
        IdealState idealState = this.generateNewIdealState(resourceName, currentIdealState, finalMapping);
        clusterData.setCachedIdealMapping(resourceName, idealState.getRecord());
        return idealState;
    }

    private IdealState generateNewIdealState(String resourceName, IdealState currentIdealState, ZNRecord newMapping) {
        IdealState newIdealState = new IdealState(resourceName);
        newIdealState.getRecord().setSimpleFields(currentIdealState.getRecord().getSimpleFields());
        newIdealState.setRebalanceMode(currentIdealState.getRebalanceMode());
        newIdealState.getRecord().setListFields(newMapping.getListFields());
        return newIdealState;
    }

    private Set<String> getActiveInstances(Set<String> allNodes, IdealState idealState, Set<String> liveEnabledNodes, Map<String, Long> instanceOfflineTimeMap, Set<String> liveNodes, Map<String, InstanceConfig> instanceConfigMap, long delay, ClusterConfig clusterConfig) {
        HashSet<String> activeInstances = new HashSet<String>(liveEnabledNodes);
        if (!this.isDelayRebalanceEnabled(idealState, clusterConfig)) {
            return activeInstances;
        }
        HashSet<String> offlineOrDisabledInstances = new HashSet<String>(allNodes);
        offlineOrDisabledInstances.removeAll(liveEnabledNodes);
        long currentTime = System.currentTimeMillis();
        for (String ins : offlineOrDisabledInstances) {
            long inactiveTime = this.getInactiveTime(ins, liveNodes, instanceOfflineTimeMap.get(ins), delay, instanceConfigMap.get(ins), clusterConfig);
            InstanceConfig instanceConfig = instanceConfigMap.get(ins);
            if (inactiveTime <= currentTime || instanceConfig == null || !instanceConfig.isDelayRebalanceEnabled()) continue;
            activeInstances.add(ins);
        }
        return activeInstances;
    }

    private void setRebalanceScheduler(IdealState idealState, Set<String> offlineOrDisabledInstances, Map<String, Long> instanceOfflineTimeMap, Set<String> liveNodes, Map<String, InstanceConfig> instanceConfigMap, long delay, ClusterConfig clusterConfig) {
        String resourceName = idealState.getResourceName();
        if (!this.isDelayRebalanceEnabled(idealState, clusterConfig)) {
            _rebalanceScheduler.removeScheduledRebalance(resourceName);
            return;
        }
        long currentTime = System.currentTimeMillis();
        long nextRebalanceTime = Long.MAX_VALUE;
        for (String ins : offlineOrDisabledInstances) {
            long inactiveTime = this.getInactiveTime(ins, liveNodes, instanceOfflineTimeMap.get(ins), delay, instanceConfigMap.get(ins), clusterConfig);
            if (inactiveTime == -1L || inactiveTime <= currentTime || inactiveTime >= nextRebalanceTime) continue;
            nextRebalanceTime = inactiveTime;
        }
        if (nextRebalanceTime == Long.MAX_VALUE) {
            long startTime = _rebalanceScheduler.removeScheduledRebalance(resourceName);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Remove exist rebalance timer for resource %s at %d\n", resourceName, startTime));
            }
        } else {
            long currentScheduledTime = _rebalanceScheduler.getRebalanceTime(resourceName);
            if (currentScheduledTime < 0L || currentScheduledTime > nextRebalanceTime) {
                _rebalanceScheduler.scheduleRebalance(this._manager, resourceName, nextRebalanceTime);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Set next rebalance time for resource %s at time %d\n", resourceName, nextRebalanceTime));
                }
            }
        }
    }

    private long getInactiveTime(String instance, Set<String> liveInstances, Long offlineTime, long delay, InstanceConfig instanceConfig, ClusterConfig clusterConfig) {
        long inactiveTime = Long.MAX_VALUE;
        if (!liveInstances.contains(instance) && offlineTime != null && offlineTime > 0L && offlineTime + delay < inactiveTime) {
            inactiveTime = offlineTime + delay;
        }
        if (!instanceConfig.getInstanceEnabled() || clusterConfig.getDisabledInstances() != null && clusterConfig.getDisabledInstances().containsKey(instance)) {
            long disabledTime = instanceConfig.getInstanceEnabledTime();
            if (clusterConfig.getDisabledInstances() != null && clusterConfig.getDisabledInstances().containsKey(instance)) {
                long batchDisableTime = Long.parseLong(clusterConfig.getDisabledInstances().get(instance));
                if (disabledTime == -1L || disabledTime > batchDisableTime) {
                    disabledTime = batchDisableTime;
                }
            }
            if (disabledTime > 0L && disabledTime + delay < inactiveTime) {
                inactiveTime = disabledTime + delay;
            }
        }
        if (inactiveTime == Long.MAX_VALUE) {
            return -1L;
        }
        return inactiveTime;
    }

    private long getRebalanceDelay(IdealState idealState, ClusterConfig clusterConfig) {
        long delayTime = idealState.getRebalanceDelay();
        if (delayTime < 0L) {
            delayTime = clusterConfig.getRebalanceDelayTime();
        }
        return delayTime;
    }

    private boolean isDelayRebalanceEnabled(IdealState idealState, ClusterConfig clusterConfig) {
        long delay = this.getRebalanceDelay(idealState, clusterConfig);
        return delay > 0L && idealState.isDelayRebalanceEnabled() && clusterConfig.isDelayRebalaceEnabled();
    }

    private ZNRecord getFinalDelayedMapping(IdealState idealState, ZNRecord newIdealMapping, ZNRecord newActiveMapping, Set<String> liveInstances, int numReplica, int minActiveReplica) {
        if (minActiveReplica >= numReplica) {
            return newIdealMapping;
        }
        ZNRecord finalMapping = new ZNRecord(idealState.getResourceName());
        for (String partition : newIdealMapping.getListFields().keySet()) {
            List<String> idealList = newIdealMapping.getListField(partition);
            List<String> activeList = newActiveMapping.getListField(partition);
            ArrayList<String> liveList = new ArrayList<String>();
            int activeReplica = 0;
            for (String ins : activeList) {
                if (!liveInstances.contains(ins)) continue;
                ++activeReplica;
                liveList.add(ins);
            }
            if (activeReplica >= minActiveReplica) {
                finalMapping.setListField(partition, activeList);
                continue;
            }
            ArrayList<String> candidates = new ArrayList<String>(idealList);
            candidates.removeAll(activeList);
            for (String liveIns : candidates) {
                liveList.add(liveIns);
                if (liveList.size() < minActiveReplica) continue;
                break;
            }
            finalMapping.setListField(partition, liveList);
        }
        return finalMapping;
    }

    private ZNRecord emptyMapping(IdealState idealState) {
        ZNRecord emptyMapping = new ZNRecord(idealState.getResourceName());
        for (String partition : idealState.getPartitionSet()) {
            emptyMapping.setListField(partition, new ArrayList<String>());
        }
        return emptyMapping;
    }

    @Override
    public ResourceAssignment computeBestPossiblePartitionState(ResourceControllerDataProvider cache, IdealState idealState, Resource resource, CurrentStateOutput currentStateOutput) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing resource:" + resource.getResourceName());
        }
        Set<String> allNodes = cache.getEnabledInstances();
        Set<String> liveNodes = cache.getLiveInstances().keySet();
        ClusterConfig clusterConfig = cache.getClusterConfig();
        long delayTime = this.getRebalanceDelay(idealState, clusterConfig);
        Set<String> activeNodes = this.getActiveInstances(allNodes, idealState, liveNodes, cache.getInstanceOfflineTimeMap(), cache.getLiveInstances().keySet(), cache.getInstanceConfigMap(), delayTime, clusterConfig);
        String stateModelDefName = idealState.getStateModelDefRef();
        StateModelDefinition stateModelDef = cache.getStateModelDef(stateModelDefName);
        ResourceAssignment partitionMapping = new ResourceAssignment(resource.getResourceName());
        for (Partition partition : resource.getPartitions()) {
            Set<String> disabledInstancesForPartition = cache.getDisabledInstancesForPartition(resource.getResourceName(), partition.toString());
            List<String> preferenceList = DelayedAutoRebalancer.getPreferenceList(partition, idealState, activeNodes);
            Map<String, String> bestStateForPartition = this.computeBestPossibleStateForPartition(liveNodes, stateModelDef, preferenceList, currentStateOutput, disabledInstancesForPartition, idealState, clusterConfig, partition);
            partitionMapping.addReplicaMap(partition, bestStateForPartition);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Best possible mapping for resource  " + resource.getResourceName() + ": " + partitionMapping);
        }
        return partitionMapping;
    }

    private int getMinActiveReplica(IdealState idealState, int replicaCount) {
        int minActiveReplicas = idealState.getMinActiveReplicas();
        if (minActiveReplicas < 0) {
            minActiveReplicas = replicaCount;
        }
        return minActiveReplicas;
    }

    @Override
    protected Map<String, String> computeBestPossibleStateForPartition(Set<String> liveInstances, StateModelDefinition stateModelDef, List<String> preferenceList, CurrentStateOutput currentStateOutput, Set<String> disabledInstancesForPartition, IdealState idealState, ClusterConfig clusterConfig, Partition partition) {
        HashMap<String, String> currentStateMap = new HashMap<String, String>(currentStateOutput.getCurrentStateMap(idealState.getResourceName(), partition));
        if (preferenceList == null) {
            return this.computeBestPossibleMapForDroppedResource(currentStateMap);
        }
        if (!idealState.isEnabled()) {
            return this.computeBestPossibleMapForDisabledResource(currentStateMap, stateModelDef);
        }
        ArrayList currentInstances = new ArrayList(currentStateMap.keySet());
        Collections.sort(currentInstances);
        HashMap<String, String> pendingStates = new HashMap<String, String>(currentStateOutput.getPendingStateMap(idealState.getResourceName(), partition));
        for (String instance : pendingStates.keySet()) {
            if (currentStateMap.containsKey(instance)) continue;
            currentStateMap.put(instance, stateModelDef.getInitialState());
            currentInstances.add(instance);
        }
        HashSet<String> instancesToDrop = new HashSet<String>();
        Iterator it = currentInstances.iterator();
        while (it.hasNext()) {
            String instance = (String)it.next();
            String state = (String)currentStateMap.get(instance);
            if (state != null) continue;
            it.remove();
            instancesToDrop.add(instance);
        }
        if (preferenceList == null) {
            preferenceList = Collections.emptyList();
        }
        int numExtraReplicas = this.getNumExtraReplicas(clusterConfig);
        int numReplicas = preferenceList.size();
        ArrayList<String> instanceToAdd = new ArrayList<String>(preferenceList);
        instanceToAdd.removeAll(currentInstances);
        ArrayList<String> combinedPreferenceList = new ArrayList<String>();
        if (currentInstances.size() <= numReplicas && numReplicas + numExtraReplicas - currentInstances.size() > 0) {
            int subListSize = numReplicas + numExtraReplicas - currentInstances.size();
            combinedPreferenceList.addAll(instanceToAdd.subList(0, subListSize <= instanceToAdd.size() ? subListSize : instanceToAdd.size()));
        }
        HashMap<String, String> currentMapWithPreferenceList = new HashMap<String, String>(currentStateMap);
        currentMapWithPreferenceList.keySet().retainAll(preferenceList);
        combinedPreferenceList.addAll(currentInstances);
        Collections.sort(combinedPreferenceList, new AbstractRebalancer.PreferenceListNodeComparator(currentStateMap, stateModelDef, preferenceList));
        Map<String, String> bestPossibleStateMap = this.computeBestPossibleMap(combinedPreferenceList, stateModelDef, currentStateMap, liveInstances, disabledInstancesForPartition);
        for (String instance : instancesToDrop) {
            bestPossibleStateMap.put(instance, HelixDefinedState.DROPPED.name());
        }
        if (!currentMapWithPreferenceList.values().contains(HelixDefinedState.ERROR.name()) && bestPossibleStateMap.size() > numReplicas && this.readyToDrop(currentStateMap, bestPossibleStateMap, preferenceList, combinedPreferenceList)) {
            for (int i = 0; i < combinedPreferenceList.size() - numReplicas; ++i) {
                String instanceToDrop = (String)combinedPreferenceList.get(combinedPreferenceList.size() - i - 1);
                bestPossibleStateMap.put(instanceToDrop, HelixDefinedState.DROPPED.name());
            }
        }
        for (String instance : combinedPreferenceList) {
            if (!currentStateMap.containsKey(instance) || !((String)currentStateMap.get(instance)).equals(HelixDefinedState.ERROR.name())) continue;
            bestPossibleStateMap.put(instance, HelixDefinedState.ERROR.name());
        }
        return bestPossibleStateMap;
    }

    private boolean readyToDrop(Map<String, String> currentStateMap, Map<String, String> bestPossibleMap, List<String> preferenceList, List<String> combinedPreferenceList) {
        HashSet<String> preferenceWithActiveState = new HashSet<String>(preferenceList);
        preferenceWithActiveState.retainAll(combinedPreferenceList);
        for (String instance : preferenceWithActiveState) {
            if (currentStateMap.containsKey(instance) && currentStateMap.get(instance).equals(bestPossibleMap.get(instance))) continue;
            return false;
        }
        return true;
    }

    private int getNumExtraReplicas(ClusterConfig clusterConfig) {
        int numExtraReplicas = 1;
        List<StateTransitionThrottleConfig> stateTransitionThrottleConfigs = clusterConfig.getStateTransitionThrottleConfigs();
        for (StateTransitionThrottleConfig throttleConfig : stateTransitionThrottleConfigs) {
            if (!StateTransitionThrottleConfig.ThrottleScope.PARTITION.equals((Object)throttleConfig.getThrottleScope()) || !StateTransitionThrottleConfig.RebalanceType.LOAD_BALANCE.equals((Object)throttleConfig.getRebalanceType())) continue;
            numExtraReplicas = (int)Math.min((long)numExtraReplicas, throttleConfig.getMaxPartitionInTransition());
        }
        return numExtraReplicas;
    }
}

