/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans.dynamicMBeans;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import org.apache.helix.HelixException;

public abstract class DynamicMetric<O, T> {
    protected static final String DEFAULT_ATTRIBUTE_DESCRIPTION = "Attribute exposed for management";
    private final Set<MBeanAttributeInfo> _attributeInfoSet;
    private O _metricObject;

    public DynamicMetric(String metricName, O metricObject) {
        if (metricName == null || metricObject == null) {
            throw new HelixException("Failed to construct metric due to missing argument.");
        }
        this._metricObject = metricObject;
        this._attributeInfoSet = Collections.unmodifiableSet(this.generateAttributeInfos(metricName, metricObject));
    }

    public Collection<MBeanAttributeInfo> getAttributeInfos() {
        return this._attributeInfoSet;
    }

    public abstract Object getAttributeValue(String var1);

    public abstract void updateValue(T var1);

    protected Set<MBeanAttributeInfo> generateAttributeInfos(String metricName, O metricObject) {
        HashSet<MBeanAttributeInfo> attributeInfoSet = new HashSet<MBeanAttributeInfo>();
        attributeInfoSet.add(new MBeanAttributeInfo(metricName, metricObject.getClass().getName(), DEFAULT_ATTRIBUTE_DESCRIPTION, true, false, false));
        return attributeInfoSet;
    }

    protected O getMetricObject() {
        return this._metricObject;
    }

    protected void setMetricObject(O metricObject) {
        this._metricObject = metricObject;
    }
}

